/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ui;

import com.sybase.asa.ASAComboBox;
import com.sybase.asa.ASALabel;
import com.sybase.asa.ASARadioButton;
import com.sybase.asa.ASASpinBox;
import com.sybase.asa.ASATextField;
import com.sybase.util.ds.uaf.DiscoverySetting;
import com.sybase.util.ds.uaf.SyUAF;
import com.sybase.util.ds.ui.BasePanel;
import com.sybase.util.ds.ui.ConstraintDocument;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.text.Document;

public class EditDiscoverySettingPage
extends BasePanel
implements KeyListener {
    public ASALabel discoveryMethodLabel;
    public ASAComboBox discoveryMethodComboBox;
    public ASALabel discoveryHostLabel;
    public ASARadioButton defaultHostRadioButton;
    public ASARadioButton specifyHostRadioButton;
    public ASATextField discoveryHostTextField;
    public ASALabel discoveryPortLabel;
    public ASARadioButton defaultPortRadioButton;
    public ASARadioButton specifyPortRadioButton;
    public ASASpinBox discoveryPortSpinBox;

    public EditDiscoverySettingPage(boolean bl) {
        this.createGUI();
    }

    private void createGUI() {
        this.discoveryMethodLabel = new ASALabel(_res.get("DISCOVERY_METHOD"));
        this.discoveryMethodComboBox = new ASAComboBox();
        this.discoveryMethodLabel.setLabelFor((Component)this.discoveryMethodComboBox);
        this.discoveryHostLabel = new ASALabel(_res.get("DISCOVERY_HOST"));
        this.defaultHostRadioButton = new ASARadioButton(_res.get("USE_DEFAULT_HOST"));
        this.specifyHostRadioButton = new ASARadioButton(_res.get("SPECIFY_HOST"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.defaultHostRadioButton);
        buttonGroup.add((AbstractButton)this.specifyHostRadioButton);
        this.discoveryHostTextField = new ASATextField();
        this.discoveryHostTextField.setDocument((Document)new ConstraintDocument());
        this.discoveryPortLabel = new ASALabel(_res.get("DISCOVERY_PORT"));
        this.defaultPortRadioButton = new ASARadioButton(_res.get("USE_DEFAULT_PORT"));
        this.specifyPortRadioButton = new ASARadioButton(_res.get("SPECIFY_PORT"));
        buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.defaultPortRadioButton);
        buttonGroup.add((AbstractButton)this.specifyPortRadioButton);
        this.discoveryPortSpinBox = new ASASpinBox(4160, 1025, 65535);
        this.discoveryPortSpinBox.setPreferredWidthToDigits(5);
        int n = 0;
        this.add((Component)this.discoveryMethodLabel, 0, n, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this.add((Component)this.discoveryMethodComboBox, 1, n, 2, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        this.add((Component)this.discoveryHostLabel, 0, ++n, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this.add((Component)this.defaultHostRadioButton, 1, n, 1, 1, 0.0, 0.0, 17, 0, INSETS_FIRST, 0, 0);
        this.add((Component)this.specifyHostRadioButton, 1, ++n, 1, 1, 0.0, 0.0, 17, 0, INSETS_LAST, 0, 0);
        this.add((Component)this.discoveryHostTextField, 2, n, 1, 1, 1.0, 0.0, 17, 2, INSETS_INDENT_LAST, 0, 0);
        this.add((Component)this.discoveryPortLabel, 0, ++n, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this.add((Component)this.defaultPortRadioButton, 1, n, 1, 1, 0.0, 0.0, 17, 0, INSETS_FIRST, 0, 0);
        this.add((Component)this.specifyPortRadioButton, 1, ++n, 1, 1, 0.0, 0.0, 17, 0, INSETS_LAST, 0, 0);
        this.add((Component)this.discoveryPortSpinBox, 2, n, 1, 1, 1.0, 0.0, 17, 2, INSETS_INDENT_LAST, 0, 0);
        this.add(Box.createGlue(), 0, ++n, 0, 1, 1.0, 1.0, 10, 1, INSETS_NONE, 0, 0);
        this.defaultHostRadioButton.addKeyListener((KeyListener)this);
        this.specifyHostRadioButton.addKeyListener((KeyListener)this);
        this.defaultPortRadioButton.addKeyListener((KeyListener)this);
        this.specifyPortRadioButton.addKeyListener((KeyListener)this);
    }

    public void init(DiscoverySetting discoverySetting) {
        int n;
        Object object;
        if (this.discoveryMethodComboBox.getItemCount() == 0) {
            object = SyUAF.DISCOVERY_METHODS;
            for (n = 0; n < ((String[])object).length; ++n) {
                this.discoveryMethodComboBox.addItem((Object)object[n]);
            }
        }
        object = discoverySetting == null ? new DiscoverySetting() : discoverySetting;
        this.discoveryMethodComboBox.setSelectedItem(object.service);
        if (object.host == null || object.host.length() == 0) {
            this.defaultHostRadioButton.setSelected(true);
        } else {
            this.specifyHostRadioButton.setSelected(true);
            this.discoveryHostTextField.setText(object.host);
        }
        if (object.port == null || object.port.length() == 0) {
            this.defaultPortRadioButton.setSelected(true);
        } else {
            this.specifyPortRadioButton.setSelected(true);
            try {
                n = Integer.valueOf(object.port);
            }
            catch (NumberFormatException numberFormatException) {
                n = 4160;
            }
            this.discoveryPortSpinBox.setValue(n);
        }
        this.enableComponents();
    }

    public String getDiscoveryService() {
        Object object = this.discoveryMethodComboBox.getSelectedItem();
        return object != null ? object.toString() : null;
    }

    public String getDiscoveryHost() {
        if (this.defaultHostRadioButton.isSelected()) {
            return "";
        }
        return this.discoveryHostTextField.getText();
    }

    public String getDiscoveryPort() {
        if (this.defaultPortRadioButton.isSelected()) {
            return "";
        }
        return String.valueOf(this.discoveryPortSpinBox.getValue());
    }

    public void handleActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.specifyPortRadioButton) {
            this.discoveryPortSpinBox.requestFocusInWindow();
        } else if (actionEvent.getSource() == this.specifyHostRadioButton) {
            this.discoveryHostTextField.selectAll();
            this.discoveryHostTextField.requestFocus();
        } else if (actionEvent.getSource() == this.discoveryMethodComboBox) {
            String string = this.getDiscoveryService();
        }
        this.enableComponents();
    }

    public void enableComponents() {
        String string = this.getDiscoveryService();
        boolean bl = string == null || !string.equals(SyUAF.SERVICE_UDP);
        this.discoveryHostLabel.setEnabled(bl);
        this.defaultHostRadioButton.setEnabled(bl);
        this.specifyHostRadioButton.setEnabled(bl);
        this.discoveryHostTextField.setEnabled(bl && this.specifyHostRadioButton.isSelected());
        this.discoveryPortLabel.setEnabled(bl);
        this.defaultPortRadioButton.setEnabled(bl);
        this.specifyPortRadioButton.setEnabled(false);
        this.discoveryPortSpinBox.setEnabled(bl && this.specifyPortRadioButton.isSelected());
    }

    public boolean getEnableSave() {
        boolean bl = this.defaultHostRadioButton.isSelected() || this.specifyHostRadioButton.isSelected() && this.discoveryHostTextField.getText().length() > 0;
        boolean bl2 = this.defaultPortRadioButton.isSelected() || this.specifyPortRadioButton.isSelected() && String.valueOf(this.discoveryPortSpinBox.getValue()).length() > 0;
        String string = this.getDiscoveryService();
        boolean bl3 = string != null && (string.equals(SyUAF.SERVICE_UDP) || bl && bl2);
        return bl3;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 38) {
            if (keyEvent.getSource() == this.defaultHostRadioButton) {
                this.specifyHostRadioButton.setSelected(true);
                this.discoveryHostTextField.selectAll();
                this.discoveryHostTextField.requestFocus();
                this.discoveryHostTextField.setEnabled(true);
            } else if (keyEvent.getSource() == this.specifyHostRadioButton) {
                this.discoveryHostTextField.setEnabled(false);
            } else if (keyEvent.getSource() == this.defaultPortRadioButton) {
                this.discoveryPortSpinBox.requestFocusInWindow();
                this.discoveryPortSpinBox.setEnabled(true);
            } else if (keyEvent.getSource() == this.specifyPortRadioButton) {
                this.discoveryPortSpinBox.setEnabled(false);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

