/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ui;

import com.sybase.asa.ASABaseGridBagPanel;
import com.sybase.asa.ASAButton;
import com.sybase.asa.ASACheckBox;
import com.sybase.asa.ASALabel;
import com.sybase.asa.ASASpinBox;
import com.sybase.asa.ASASpinBoxChangeListener;
import com.sybase.asa.ASATextField;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.ds.Settings;
import com.sybase.util.ds.Utils;
import com.sybase.util.ds.interfaces.SyInterfacesDriver;
import com.sybase.util.ds.ui.BasePanel;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.EventListener;
import javax.swing.Box;
import javax.swing.event.DocumentListener;

public class GeneralPage
extends BasePanel {
    public ASACheckBox saveServersCheckBox;
    public ASASpinBox numSavedServersSpinBox;
    public ASALabel serversLabel;
    public ASACheckBox clearServersCheckBox;
    public ASACheckBox lastDatabaseCheckBox;
    public ASACheckBox loginTimeoutCheckBox;
    public ASASpinBox loginTimeoutSpinBox;
    public ASALabel secondsLabel;
    public ASACheckBox defaultIniCheckBox;
    public ASALabel iniPathLabel;
    public ASATextField iniPathTextField;
    public ASALabel messageLabel;
    public ASAButton browseButton;
    private int _initNumSavedServers;
    private boolean _initSaveServers;
    private boolean _initLastDatabase;
    private boolean _initEnableLoginTimeout;
    private int _initLoginTimeout;
    private boolean _initUseDefaultInterfaces;
    private String _initIniPath = "";

    public GeneralPage() {
        this.createGUI();
    }

    private void createGUI() {
        this.saveServersCheckBox = new ASACheckBox(_res.get("CHKB_REMEMBER"));
        this.numSavedServersSpinBox = new ASASpinBox(1, 1, 20);
        this.numSavedServersSpinBox.setPreferredWidthToDigits(2);
        this.serversLabel = new ASALabel(_res.get("RECENT_SERVERS"));
        this.clearServersCheckBox = new ASACheckBox(_res.get("CHKB_CLEAR_SERVERS"));
        this.lastDatabaseCheckBox = new ASACheckBox(_res.get("CHKB_CONNECT_LAST_DATABASE"));
        this.loginTimeoutCheckBox = new ASACheckBox(_res.get("CHKB_LOGIN_TIMEOUT"));
        this.loginTimeoutSpinBox = new ASASpinBox(30, 1, 999);
        this.loginTimeoutSpinBox.setPreferredWidthToDigits(3);
        this.secondsLabel = new ASALabel(_res.get("SECONDS"));
        this.defaultIniCheckBox = new ASACheckBox(_res.get("CHKB_DEFAULT_INTERFACES"));
        this.iniPathLabel = new ASALabel(_res.get("INTERFACES_FILE_PATH"));
        this.iniPathTextField = new ASATextField();
        this.iniPathLabel.setLabelFor((Component)this.iniPathTextField);
        this.messageLabel = new ASALabel();
        this.browseButton = new ASAButton(_res.get("BTTN_BROWSE"));
        int n = 0;
        ASABaseGridBagPanel aSABaseGridBagPanel = new ASABaseGridBagPanel(INSETS_NONE);
        aSABaseGridBagPanel.add((Component)this.saveServersCheckBox, 0, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS_NONE, 0, 0);
        aSABaseGridBagPanel.add((Component)this.numSavedServersSpinBox, 1, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)this.serversLabel, 2, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)this.clearServersCheckBox, 3, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS_INDENT, 0, 0);
        this.add((Component)aSABaseGridBagPanel, 0, n, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this.add((Component)this.lastDatabaseCheckBox, 0, ++n, 0, 1, 0.0, 0.0, 17, 0, INSETS_INDENT_LAST, 0, 0);
        aSABaseGridBagPanel = new ASABaseGridBagPanel(INSETS_NONE);
        aSABaseGridBagPanel.add((Component)this.loginTimeoutCheckBox, 0, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS_NONE, 0, 0);
        aSABaseGridBagPanel.add((Component)this.loginTimeoutSpinBox, 1, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)this.secondsLabel, 2, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this.add((Component)aSABaseGridBagPanel, 0, ++n, 0, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this.add((Component)this.defaultIniCheckBox, 0, ++n, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel = new ASABaseGridBagPanel(INSETS_NONE);
        aSABaseGridBagPanel.add((Component)this.iniPathLabel, 0, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)this.iniPathTextField, 1, 0, 2, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)this.messageLabel, 1, 1, 1, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)this.browseButton, 2, 1, 1, 1, 0.0, 0.0, 13, 0, INSETS_LAST, 0, 0);
        this.add((Component)aSABaseGridBagPanel, 0, ++n, 0, 1, 1.0, 0.0, 17, 2, INSETS_INDENT_NONE, 0, 0);
        this.add(Box.createGlue(), 0, ++n, 0, 1, 1.0, 1.0, 10, 1, INSETS_NONE, 0, 0);
    }

    private void handleListeners(boolean bl, EventListener eventListener) {
        if (eventListener instanceof ActionListener) {
            if (bl) {
                this.saveServersCheckBox.addActionListener((ActionListener)eventListener);
                this.clearServersCheckBox.addActionListener((ActionListener)eventListener);
                this.lastDatabaseCheckBox.addActionListener((ActionListener)eventListener);
                this.loginTimeoutCheckBox.addActionListener((ActionListener)eventListener);
                this.defaultIniCheckBox.addActionListener((ActionListener)eventListener);
                this.browseButton.addActionListener((ActionListener)eventListener);
            } else {
                this.saveServersCheckBox.removeActionListener((ActionListener)eventListener);
                this.clearServersCheckBox.removeActionListener((ActionListener)eventListener);
                this.lastDatabaseCheckBox.removeActionListener((ActionListener)eventListener);
                this.loginTimeoutCheckBox.removeActionListener((ActionListener)eventListener);
                this.defaultIniCheckBox.removeActionListener((ActionListener)eventListener);
                this.browseButton.removeActionListener((ActionListener)eventListener);
            }
        }
        if (eventListener instanceof DocumentListener) {
            if (bl) {
                this.iniPathTextField.getDocument().addDocumentListener((DocumentListener)eventListener);
            } else {
                this.iniPathTextField.getDocument().removeDocumentListener((DocumentListener)eventListener);
            }
        }
        if (eventListener instanceof ASASpinBoxChangeListener) {
            if (bl) {
                this.loginTimeoutSpinBox.addSpinBoxChangeListener((ASASpinBoxChangeListener)eventListener);
                this.numSavedServersSpinBox.addSpinBoxChangeListener((ASASpinBoxChangeListener)eventListener);
            } else {
                this.loginTimeoutSpinBox.removeSpinBoxChangeListener((ASASpinBoxChangeListener)eventListener);
                this.numSavedServersSpinBox.removeSpinBoxChangeListener((ASASpinBoxChangeListener)eventListener);
            }
        }
    }

    protected void init(EventListener eventListener) {
        this.handleListeners(false, eventListener);
        this._initNumSavedServers = Settings.getNumberOfSavedServers();
        this._initSaveServers = Settings.getEnableSaveServers();
        this._initLastDatabase = Settings.getEnableLastDatabase();
        this.saveServersCheckBox.setSelected(this._initSaveServers);
        this.lastDatabaseCheckBox.setEnabled(this._initSaveServers);
        this.lastDatabaseCheckBox.setSelected(this._initLastDatabase);
        this.numSavedServersSpinBox.setValue(this._initNumSavedServers);
        this.numSavedServersSpinBox.setEnabled(this._initSaveServers);
        this._initEnableLoginTimeout = Settings.getEnableLoginTimeout();
        this.loginTimeoutCheckBox.setSelected(this._initEnableLoginTimeout);
        this._initLoginTimeout = Settings.getLoginTimeout();
        this.loginTimeoutSpinBox.setValue(this._initLoginTimeout);
        this.loginTimeoutSpinBox.setEnabled(this._initEnableLoginTimeout);
        this._initUseDefaultInterfaces = Settings.getUseDefaultInterfaces();
        this.defaultIniCheckBox.setSelected(this._initUseDefaultInterfaces);
        this.setIniPathEnabled(!this._initUseDefaultInterfaces);
        if (this._initUseDefaultInterfaces) {
            this.setDefaultInterfacesPath();
        } else {
            this._initIniPath = Settings.getCustomInterfacesPath();
            this.iniPathTextField.setText(this._initIniPath);
        }
        this.isIniPathChanged();
        this.handleListeners(true, eventListener);
    }

    private void setDefaultInterfacesPath() {
        String string;
        String string2 = Utils.getSybasePath();
        if (string2 != null && Utils.isExistingDirectory(string2) && Utils.isExistingFile(string = SyInterfacesDriver.getInterfacesFilePath(string2))) {
            this.iniPathTextField.setText(string);
            return;
        }
        this.iniPathTextField.setText("");
    }

    public void handleActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.saveServersCheckBox) {
            boolean bl = this.saveServersCheckBox.isSelected();
            this.numSavedServersSpinBox.setEnabled(bl);
            this.lastDatabaseCheckBox.setEnabled(bl);
            if (bl) {
                this.numSavedServersSpinBox.requestFocusInWindow();
            }
        } else if (object == this.loginTimeoutCheckBox) {
            boolean bl = this.loginTimeoutCheckBox.isSelected();
            this.loginTimeoutSpinBox.setEnabled(bl);
            if (bl) {
                this.loginTimeoutSpinBox.requestFocusInWindow();
            }
        } else if (object == this.defaultIniCheckBox) {
            boolean bl = this.defaultIniCheckBox.isSelected();
            this.setIniPathEnabled(!bl);
            if (!bl) {
                this.iniPathTextField.requestFocus();
                if (!this._initUseDefaultInterfaces) {
                    this.iniPathTextField.setText(this._initIniPath);
                }
            } else {
                this.setDefaultInterfacesPath();
            }
        } else if (object == this.browseButton) {
            SybFileChooser sybFileChooser = new SybFileChooser(17);
            String string = Settings.getLastInterfacesFolder();
            if (Utils.isNormalPath(string)) {
                SybFileFilter[] sybFileFilterArray;
                string = Utils.removeControlCharacter(string);
                File file = new File(string);
                String string2 = this.iniPathTextField.getText();
                File file2 = null;
                if (Utils.isExistingFile(string2)) {
                    file2 = new File(string2);
                    file = file2.getParentFile();
                } else if (Utils.isExistingDirectory(string2)) {
                    file = new File(string2);
                }
                if (Utils.OS_WINDOWS) {
                    sybFileFilterArray = new SybFileFilter[]{new SybFileFilter("ini", "Interfaces File", null), SybFileFilter.getAllFilesFilter()};
                    sybFileChooser.setFilters(sybFileFilterArray, 0);
                }
                if (sybFileChooser.showDialog((Window)this.getParentDialog(), file, file2)) {
                    sybFileFilterArray = sybFileChooser.getSelectedFile();
                    this.iniPathTextField.setText(sybFileFilterArray.toString());
                    Settings.setLastInterfacesFolder(sybFileFilterArray.getParent());
                }
            }
        }
    }

    private void setIniPathEnabled(boolean bl) {
        this.iniPathTextField.setEditable(bl);
        this.browseButton.setEnabled(bl);
    }

    public boolean getEnableSave() {
        return this.isNumSavedServersChanged() || this.isConnectLastDatabaseChanged() || this.isLoginTimeoutChanged() || this.isIniPathChanged() || this.clearServersCheckBox.isSelected();
    }

    public boolean saveSettings() {
        Settings.setEnableLoginTimeout(this.loginTimeoutCheckBox.isSelected());
        Settings.setLoginTimeout(this.loginTimeoutSpinBox.getValue());
        if (this.isNumSavedServersChanged()) {
            Settings.setNumberOfSavedServers(this.numSavedServersSpinBox.getValue());
            Settings.setEnableSaveServers(this.saveServersCheckBox.isSelected());
        }
        if (this._initLastDatabase != this.lastDatabaseCheckBox.isSelected()) {
            Settings.setEnableLastDatabase(this.lastDatabaseCheckBox.isSelected());
        }
        if (this._initUseDefaultInterfaces != this.defaultIniCheckBox.isSelected()) {
            Settings.setUseDefaultInterfaces(this.defaultIniCheckBox.isSelected());
        }
        if (this.isIniPathChanged()) {
            Settings.setCustomInterfacesPath(this.iniPathTextField.getText());
        }
        return true;
    }

    boolean isNumSavedServersChanged() {
        int n = this.numSavedServersSpinBox.getValue();
        boolean bl = this.saveServersCheckBox.isSelected();
        return bl != this._initSaveServers || n != this._initNumSavedServers;
    }

    boolean isConnectLastDatabaseChanged() {
        return this._initLastDatabase != this.lastDatabaseCheckBox.isSelected();
    }

    boolean isLoginTimeoutChanged() {
        return this._initEnableLoginTimeout != this.loginTimeoutCheckBox.isSelected() || this._initLoginTimeout != this.loginTimeoutSpinBox.getValue();
    }

    boolean isIniPathChanged() {
        boolean bl = !this._initUseDefaultInterfaces && this.defaultIniCheckBox.isSelected();
        String string = this.iniPathTextField.getText();
        boolean bl2 = Utils.isExistingFile(string);
        this.messageLabel.setText(Utils.isExistingFile(string) ? "" : _res.get("FILENAMEEDIT_NOTE_FILE_NOT_EXIST"));
        boolean bl3 = this.iniPathTextField.isEnabled() && bl2 && !this._initIniPath.equals(string);
        return bl || bl3;
    }
}

