/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.jdbc;

import com.sybase.jdbc42.jdbc.ErrorMessage;
import com.sybase.jdbc42.jdbc.EscapeTokenizer;
import java.sql.SQLException;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class Escape {
    protected static final int CALL = 1;
    protected static final int RETURN_CALL = 2;
    protected static final int DATE = 3;
    protected static final int TIME = 4;
    protected static final int TIMESTAMP = 5;
    protected static final int FUNCTION = 6;
    protected static final int LIKE_ESCAPE = 7;
    protected static final int OUTER_JOIN = 8;
    protected static final int UNKNOWN = -1;
    private static final char LEFT_CURLY = '{';
    private static final char RIGHT_CURLY = '}';
    private static final char COMMA = ',';
    private static final char LEFT_PAREN = '(';
    private static final char RIGHT_PAREN = ')';
    private static final char PERCENT_SIGN = '%';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final int MAX_ARGUMENTS = 4;
    private int _type;
    private String _body;

    Escape(String string) throws SQLException {
        int n;
        String string2;
        int n2;
        int n3;
        int n4 = string.length();
        for (n3 = 1; n3 < n4 && Character.isWhitespace(string.charAt(n3)); ++n3) {
        }
        if (n3 == n4) {
            ErrorMessage.raiseError("JZ0S8", string);
        }
        for (n2 = n3; n2 < n4 && !Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        if (n2 == n4) {
            ErrorMessage.raiseError("JZ0S8", string);
        }
        if ((string2 = string.substring(n3, n2).toLowerCase(Locale.ENGLISH)).equals("call")) {
            this._type = 1;
        } else if (string2.equals("?") || string2.equals("?=") || string2.equals("?=call")) {
            n2 = string.toLowerCase().indexOf("call") + 4;
            this._type = 2;
        } else if (string2.equals("d")) {
            this._type = 3;
        } else if (string2.equals("t")) {
            this._type = 4;
        } else if (string2.equals("ts")) {
            this._type = 5;
        } else if (string2.equals("fn")) {
            this._type = 6;
        } else if (string2.equals("escape")) {
            this._type = 7;
        } else if (string2.equals("oj")) {
            this._type = 8;
        } else {
            ErrorMessage.raiseError("JZ0S8", string);
        }
        for (n = n2; n < n4 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n == n4 - 1) {
            ErrorMessage.raiseError("JZ0S8", string);
        }
        int n5 = n4 - 2;
        while (Character.isWhitespace(string.charAt(n5))) {
            --n5;
        }
        this._body = string.substring(n, n5 + 1);
    }

    Escape(String string, int n) throws SQLException {
        this._body = string;
        this._type = n;
    }

    protected int getType() {
        return this._type;
    }

    protected String getBody() {
        return this._body;
    }

    protected String functionName() throws SQLException {
        String string = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this._body, " \t\n\r(");
            string = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            ErrorMessage.raiseError("JZ0S8", this._body, noSuchElementException);
        }
        string = string.toLowerCase(Locale.ENGLISH);
        if (string.equals("convert") || string.equals("timestampadd") || string.equals("timestampdiff")) {
            int n;
            int n2;
            if (string.equals("convert")) {
                n2 = this._body.lastIndexOf(44) + 1;
                n = this._body.lastIndexOf(41) - 1;
            } else {
                n2 = this._body.indexOf(40) + 1;
                n = this._body.indexOf(44) - 1;
            }
            int n3 = this._body.length();
            while (n2 <= n3 && Character.isWhitespace(this._body.charAt(n2))) {
                ++n2;
            }
            while (n > 0 && Character.isWhitespace(this._body.charAt(n))) {
                --n;
            }
            if (n2 < 0 || n < 0 || n < n2 + 1) {
                ErrorMessage.raiseError("JZ0S8", this._body);
            }
            string = string + this._body.substring(n2, n + 1).toLowerCase();
        }
        return string;
    }

    protected String doMap(String string) throws SQLException {
        int n;
        String[] stringArray;
        String string2;
        String[] stringArray2 = new String[5];
        String string3 = "";
        int n2 = this._body.indexOf(40);
        int n3 = this._body.lastIndexOf(41);
        if (n2 < 0 || n3 < 0 || n3 < n2 + 1) {
            ErrorMessage.raiseError("JZ0S8", this._body);
        }
        if ((string2 = this.functionName()).equalsIgnoreCase("extract")) {
            stringArray = this._body.split("[()]|[fF]+[rR]+[oO]+[mM]");
            if (stringArray.length == 3) {
                string3 = stringArray[2].trim();
            } else {
                ErrorMessage.raiseError("JZ0S8", this._body);
            }
        } else if (string2.equalsIgnoreCase("position")) {
            stringArray = this.getPositionArgs(this._body.substring(n2 + 1, n3).trim());
            if (stringArray.length == 2) {
                string3 = stringArray[0] + "," + stringArray[1];
            } else {
                ErrorMessage.raiseError("JZ0S8", this._body);
            }
        } else {
            string3 = this._body.substring(n2 + 1, n3);
        }
        for (int i = 1; i <= 4 && string3.length() > 0; ++i) {
            n = this.nextComma(string3);
            if (n < 0) {
                stringArray2[i] = string3;
                break;
            }
            if (n == 0) {
                ErrorMessage.raiseError("JZ0S8", this._body);
                continue;
            }
            stringArray2[i] = string3.substring(0, n);
            string3 = string3.substring(n + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '%') {
                int n4 = 0;
                try {
                    n4 = Integer.parseInt(string.substring(i + 1, i + 2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (stringArray2[n4] == null) {
                    ErrorMessage.raiseError("JZ0S8", this._body);
                } else {
                    stringBuffer.append(stringArray2[n4]);
                }
                ++i;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private String[] getPositionArgs(String string) throws SQLException {
        if (string == null || string.length() < 6) {
            ErrorMessage.raiseError("JZ0S8", this._body);
        }
        String[] stringArray = new String[2];
        char c = string.charAt(0);
        int n = 0;
        if (c == '\'' || c == '\"') {
            while (n > -1 && (n = string.indexOf(c, n + 1)) > -1 && string.indexOf(c, n + 1) == n + 1) {
                ++n;
            }
            if (n == -1) {
                ErrorMessage.raiseError("JZ0S8", this._body);
            }
            stringArray[0] = string.substring(0, n + 1);
        } else {
            n = string.indexOf(32);
            if (n == -1) {
                ErrorMessage.raiseError("JZ0S8", this._body);
            } else {
                stringArray[0] = string.substring(0, n);
            }
        }
        stringArray[1] = string.substring(n + 1).trim().substring(3).trim();
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int nextComma(String string) throws SQLException {
        int n = string.length();
        int n2 = -1;
        int n3 = 1;
        int n4 = 0;
        while (n4 < n) {
            char c = string.charAt(n4);
            switch (c) {
                case '\"': 
                case '\'': {
                    n3 = EscapeTokenizer.nextState(n3, c);
                    break;
                }
                case '(': {
                    if (n3 != 1 || (n4 = EscapeTokenizer.matchClosingChar(c, new StringBuffer(string), n4)) >= 0) break;
                    ErrorMessage.raiseError("JZ0S8", this._body);
                    break;
                }
                case ',': {
                    if (n3 != 1) break;
                    return n4;
                }
            }
            ++n4;
        }
        return n2;
    }
}

