/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.jdbc;

import com.sybase.jdbc42.jdbc.SybCallableStatement;
import com.sybase.jdbc42.jdbc.SybConnection;
import com.sybase.jdbc42.jdbc.SybConnectionProxy;
import com.sybase.jdbc42.jdbc.SybPreparedStatement;
import com.sybase.jdbc42.jdbc.SybUrlProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class SybPooledConnection
extends SybConnection
implements PooledConnection {
    private Vector<ConnectionEventListener> _connectionEventListeners = new Vector(5);
    protected Vector<StatementEventListener> _statementEventListeners = new Vector(5);
    private static final int NUMBER_OF_CONNECTION_LISTENERS = 5;
    private static final int NUMBER_OF_STATEMENT_LISTENERS = 5;
    protected SybConnectionProxy _currentProxy = null;

    protected SybPooledConnection(SybUrlProvider sybUrlProvider, int n) throws SQLException {
        super(null, sybUrlProvider, null, n);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.reAssignProxy(this);
        return this._currentProxy;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this._connectionEventListeners.add(connectionEventListener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this._connectionEventListeners.remove(connectionEventListener);
    }

    @Override
    public void close() throws SQLException {
        if (this._currentProxy != null && !this._currentProxy.wasClosed()) {
            this._currentProxy.close();
        }
        super.close();
        this._statementEventListeners.clear();
        this._connectionEventListeners.clear();
    }

    protected void notifyConnectionListeners() {
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        Enumeration<ConnectionEventListener> enumeration = this._connectionEventListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = enumeration.nextElement();
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    protected void notifyConnectionListeners(SQLException sQLException) {
        ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
        Enumeration<ConnectionEventListener> enumeration = this._connectionEventListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = enumeration.nextElement();
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    protected void notifyCallableStatementListeners(SybCallableStatement sybCallableStatement) {
        StatementEvent statementEvent = new StatementEvent(this, sybCallableStatement);
        Enumeration<StatementEventListener> enumeration = this._statementEventListeners.elements();
        while (enumeration.hasMoreElements()) {
            StatementEventListener statementEventListener = enumeration.nextElement();
            statementEventListener.statementClosed(statementEvent);
        }
    }

    protected void notifyCallableStatementListeners(SybCallableStatement sybCallableStatement, SQLException sQLException) {
        StatementEvent statementEvent = new StatementEvent(this, sybCallableStatement, sQLException);
        Enumeration<StatementEventListener> enumeration = this._statementEventListeners.elements();
        while (enumeration.hasMoreElements()) {
            StatementEventListener statementEventListener = enumeration.nextElement();
            statementEventListener.statementErrorOccurred(statementEvent);
        }
    }

    protected void notifyPreparedStatementListeners(SybPreparedStatement sybPreparedStatement) {
        StatementEvent statementEvent = new StatementEvent(this, sybPreparedStatement);
        Enumeration<StatementEventListener> enumeration = this._statementEventListeners.elements();
        while (enumeration.hasMoreElements()) {
            StatementEventListener statementEventListener = enumeration.nextElement();
            statementEventListener.statementClosed(statementEvent);
        }
    }

    protected void notifyPreparedStatementListeners(SybPreparedStatement sybPreparedStatement, SQLException sQLException) {
        StatementEvent statementEvent = new StatementEvent(this, sybPreparedStatement, sQLException);
        Enumeration<StatementEventListener> enumeration = this._statementEventListeners.elements();
        while (enumeration.hasMoreElements()) {
            StatementEventListener statementEventListener = enumeration.nextElement();
            statementEventListener.statementErrorOccurred(statementEvent);
        }
    }

    private final void reAssignProxy(SybPooledConnection sybPooledConnection) {
        if (this._currentProxy != null && !this._currentProxy.wasClosed()) {
            try {
                this._currentProxy.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this._currentProxy = new SybConnectionProxy(sybPooledConnection);
    }

    protected Connection getConnectionProxy() {
        return this._currentProxy;
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        this._statementEventListeners.add(statementEventListener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        this._statementEventListeners.remove(statementEventListener);
    }
}

