/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.jdbc;

import com.sybase.jdbc42.IConstants;
import com.sybase.jdbc42.jdbc.Convert;
import com.sybase.jdbc42.jdbc.ErrorMessage;
import com.sybase.jdbc42.jdbc.JdbcDataObject;
import com.sybase.jdbc42.jdbc.ProtocolContext;
import com.sybase.jdbc42.jdbc.ProtocolResultSet;
import com.sybase.jdbc42.jdbc.SybStatement;
import com.sybase.jdbc42.utils.CacheManager;
import com.sybase.jdbc42.utils.Cacheable;
import com.sybase.jdbc42.utils.Debug;
import com.sybase.jdbc42.utils.LogUtil;
import com.sybase.jdbcx.TextPointer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class SybResultSet
implements com.sybase.jdbcx.SybResultSet,
Cacheable {
    private static final Logger LOG = LogUtil.createLoggerInstance(SybResultSet.class.getName());
    protected String _logId = null;
    private int _logIdCounter = 0;
    private AtomicLong _apiCount = new AtomicLong();
    protected static final int BEFORE_FIRST = -1;
    protected static final int AFTER_LAST = -2;
    protected static final int INSERT_ROW = -3;
    protected static final int UNDEFINED = -4;
    protected ProtocolResultSet _prs;
    protected JdbcDataObject _currentColumn;
    protected SybStatement _statement;
    protected ProtocolContext _pc = null;
    protected IConstants.CONNECTION_STATE _state = IConstants.CONNECTION_STATE.BUSY;
    private Hashtable<String, Integer> _nameToColumn = null;
    private Hashtable<String, Integer> _labelToColumn = null;
    protected CacheManager _cm;
    protected int _rowIndex;
    protected int _lastRowIndex = -4;
    protected int _concurType = 1007;
    protected String _concurTypeString = "CONCUR_READ_ONLY";
    protected int _scrollType = 1003;
    protected int _fetchSize = 0;
    protected int _fetchDirection = 1000;
    protected boolean _usedForParams = false;
    protected SQLWarning _savedWarnings = null;
    protected int _currentStatus = 1;

    public SybResultSet(String string, SybStatement sybStatement, ProtocolResultSet protocolResultSet) throws SQLException {
        this._logId = string + "_Rs" + this._logIdCounter++;
        this._statement = sybStatement;
        this._prs = protocolResultSet;
        this._rowIndex = -1;
        if (this._prs != null) {
            this._scrollType = this._prs.getType();
        }
        if (this._statement != null) {
            this._pc = this._statement._context;
        }
    }

    public SybResultSet(String string, ProtocolResultSet protocolResultSet, ProtocolContext protocolContext) throws SQLException {
        this._logId = string + "_Rs" + this._logIdCounter++;
        this._prs = protocolResultSet;
        this._rowIndex = -1;
        if (this._prs != null) {
            this._scrollType = this._prs.getType();
        }
        this._pc = protocolContext;
    }

    protected String getLogIdName() {
        return "Rs";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkResultSet();
            this.clearWarnings();
            this.moveToCurrentRow();
            if (this.checkRowIndexBeforeProtocolNext()) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl3 = this._prs.next();
            if (!bl3) {
                if (this._statement != null && this._prs != null) {
                    this._statement.setRowCount(this._prs.getCount());
                }
                this.adjustRowIndexesAfterProtocolNext();
            }
            if (this._currentColumn != null) {
                this._currentColumn.clearWarning();
            }
            this._currentColumn = null;
            boolean bl4 = bl3;
            return bl4;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "next", null, null, l);
            }
        }
    }

    protected boolean checkRowIndexBeforeProtocolNext() {
        boolean bl = false;
        switch (this._rowIndex) {
            case -2: {
                bl = true;
                break;
            }
            case -1: {
                this._rowIndex = 1;
                break;
            }
            default: {
                if (this._rowIndex <= 0) break;
                ++this._rowIndex;
            }
        }
        return bl;
    }

    protected void adjustRowIndexesAfterProtocolNext() {
        if (this._rowIndex == 1) {
            this._lastRowIndex = 0;
            this._rowIndex = -1;
        } else {
            this._lastRowIndex = this._rowIndex - 1;
            this._rowIndex = -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.close(false);
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "close", null, null, l);
            }
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkResultSet();
        if (this._currentColumn == null) {
            ErrorMessage.raiseError("JZ0NC");
        }
        return this._currentColumn.isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n) throws SQLException {
        String string;
        block7: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                JdbcDataObject jdbcDataObject = this.getColumn(n);
                String string2 = jdbcDataObject.getString();
                if (jdbcDataObject.getWarning() != null) {
                    if (this._savedWarnings != null) {
                        this._savedWarnings.setNextWarning(jdbcDataObject.getWarning());
                    } else {
                        this._savedWarnings = jdbcDataObject.getWarning();
                    }
                }
                string = string2;
                if (!bl) break block7;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getString", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getString", "int", new Object[]{n}, l);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n) throws SQLException {
        boolean bl;
        block4: {
            boolean bl2 = LogUtil.isLoggingEnabled(LOG);
            long l = bl2 ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl2) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                bl = this.getColumn(n).getBoolean();
                if (!bl2) break block4;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBoolean", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBoolean", "int", new Object[]{n}, l);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n) throws SQLException {
        byte by;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                by = this.getColumn(n).getByte();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getByte", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getByte", "int", new Object[]{n}, l);
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n) throws SQLException {
        byte[] byArray;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                byArray = this.getColumn(n).getBytes();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getByte", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getByte", "int", new Object[]{n}, l);
        }
        return byArray;
    }

    @Override
    public TextPointer getSybTextPointer(int n) throws SQLException {
        return this.getColumn(n).getTextPtr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n) throws SQLException {
        short s;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                s = this.getColumn(n).getShort();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getShort", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getShort", "int", new Object[]{n}, l);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n) throws SQLException {
        int n2;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                n2 = this.getColumn(n).getInt();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getInt", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getInt", "int", new Object[]{n}, l);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n) throws SQLException {
        long l;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l2);
                }
                l = this.getColumn(n).getLong();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getLong", "int", new Object[]{n}, l2);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getLong", "int", new Object[]{n}, l2);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n) throws SQLException {
        float f;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                f = this.getColumn(n).getFloat();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getFloat", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getFloat", "int", new Object[]{n}, l);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n) throws SQLException {
        double d;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                d = this.getColumn(n).getDouble();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getDouble", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getDouble", "int", new Object[]{n}, l);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                bigDecimal = this.getColumn(n).getBigDecimal(n2);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBigDecimal", "int, int", new Object[]{n, n2}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBigDecimal", "int, int", new Object[]{n, n2}, l);
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                bigDecimal = this.getBigDecimal(n, -1);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBigDecimal", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBigDecimal", "int", new Object[]{n}, l);
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n) throws SQLException {
        Date date;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                date = Convert.objectToDate(this.getColumn(n).getDateObject(91, null), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getDate", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getDate", "int", new Object[]{n}, l);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n) throws SQLException {
        Time time;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                time = Convert.objectToTime(this.getColumn(n).getDateObject(92, null), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTime", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTime", "int", new Object[]{n}, l);
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                timestamp = Convert.objectToTimestamp(this.getColumn(n).getDateObject(93, null), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", "int", new Object[]{n}, l);
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                inputStream = this.getColumn(n).getAsciiStream();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getAsciiStream", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getAsciiStream", "int", new Object[]{n}, l);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        InputStream inputStream;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                inputStream = this.getColumn(n).getUnicodeStream();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getUnicodeStream", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getUnicodeStream", "int", new Object[]{n}, l);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                inputStream = this.getColumn(n).getBinaryStream();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBinaryStream", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBinaryStream", "int", new Object[]{n}, l);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n) throws SQLException {
        Object object;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                object = this.getColumn(n).getObject();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getObject", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getObject", "int", new Object[]{n}, l);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(String string) throws SQLException {
        String string2;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                string2 = this.getString(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getString", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getString", "String", new Object[]{string}, l);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(String string) throws SQLException {
        boolean bl;
        block4: {
            boolean bl2 = LogUtil.isLoggingEnabled(LOG);
            long l = bl2 ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl2) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                bl = this.getBoolean(this.findColumn(string));
                if (!bl2) break block4;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBoolean", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBoolean", "String", new Object[]{string}, l);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(String string) throws SQLException {
        byte by;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                by = this.getByte(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getByte", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getByte", "String", new Object[]{string}, l);
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(String string) throws SQLException {
        short s;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                s = this.getShort(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getShort", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getShort", "String", new Object[]{string}, l);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(String string) throws SQLException {
        int n;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                n = this.getInt(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getInt", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getInt", "String", new Object[]{string}, l);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(String string) throws SQLException {
        long l;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l2);
                }
                l = this.getLong(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getLong", "String", new Object[]{string}, l2);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getLong", "String", new Object[]{string}, l2);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(String string) throws SQLException {
        float f;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                f = this.getFloat(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getFloat", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getFloat", "String", new Object[]{string}, l);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(String string) throws SQLException {
        double d;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                d = this.getDouble(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getDouble", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getDouble", "String", new Object[]{string}, l);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        BigDecimal bigDecimal;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                bigDecimal = this.getBigDecimal(this.findColumn(string), n);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBigDecimal", "String, int", new Object[]{string, n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBigDecimal", "String, int", new Object[]{string, n}, l);
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        BigDecimal bigDecimal;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                bigDecimal = this.getBigDecimal(string, -1);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBigDecimal", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBigDecimal", "String", new Object[]{string}, l);
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(String string) throws SQLException {
        byte[] byArray;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                byArray = this.getBytes(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", "String", new Object[]{string}, l);
        }
        return byArray;
    }

    @Override
    public TextPointer getSybTextPointer(String string) throws SQLException {
        return this.getSybTextPointer(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(String string) throws SQLException {
        Date date;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                date = this.getDate(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getDate", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getDate", "String", new Object[]{string}, l);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(String string) throws SQLException {
        Time time;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                time = this.getTime(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTime", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTime", "String", new Object[]{string}, l);
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        Timestamp timestamp;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                timestamp = this.getTimestamp(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", "String", new Object[]{string}, l);
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        InputStream inputStream;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                inputStream = this.getAsciiStream(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", "String", new Object[]{string}, l);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        InputStream inputStream;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                inputStream = this.getUnicodeStream(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getUnicodeStream", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getUnicodeStream", "String", new Object[]{string}, l);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        InputStream inputStream;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                inputStream = this.getBinaryStream(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBinaryStream", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBinaryStream", "String", new Object[]{string}, l);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(String string) throws SQLException {
        Object object;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                object = this.getObject(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getObject", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getObject", "String", new Object[]{string}, l);
        }
        return object;
    }

    @Override
    public URL getURL(int n) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getURL(int)");
        return null;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getURL(String)");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            SQLWarning sQLWarning = null;
            if (this._prs != null) {
                if (this._savedWarnings != null) {
                    this._savedWarnings.setNextWarning(this._prs.getWarnings());
                    this._prs.clearWarnings();
                    sQLWarning = this._savedWarnings;
                } else {
                    sQLWarning = this._prs.getWarnings();
                }
            } else if (this._savedWarnings != null) {
                sQLWarning = this._savedWarnings;
            }
            SQLWarning sQLWarning2 = sQLWarning;
            return sQLWarning2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getWarnings", null, null, l);
            }
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this._prs != null) {
            this._prs.clearWarnings();
        }
        this._savedWarnings = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            ResultSetMetaData resultSetMetaData;
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkResultSet();
            ResultSetMetaData resultSetMetaData2 = resultSetMetaData = this._prs.getMetaData();
            return resultSetMetaData2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getMetaData", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumn(String string) throws SQLException {
        int n;
        block15: {
            long l;
            boolean bl;
            block13: {
                int n2;
                block14: {
                    Integer n3;
                    block9: {
                        int n4;
                        block12: {
                            block10: {
                                int n5;
                                block11: {
                                    bl = LogUtil.isLoggingEnabled(LOG);
                                    l = bl ? this._apiCount.incrementAndGet() : 0L;
                                    try {
                                        Integer n6;
                                        if (bl) {
                                            LogUtil.logBegin(LOG, this._logId, l);
                                        }
                                        if (!this._pc._conn._props.getBoolean(40)) break block9;
                                        if (this._labelToColumn == null) {
                                            this._labelToColumn = new Hashtable();
                                        }
                                        if ((n6 = this._labelToColumn.get(string)) == null) break block10;
                                        n5 = n6;
                                        if (!bl) break block11;
                                    }
                                    catch (Throwable throwable) {
                                        if (bl) {
                                            LogUtil.logEnd(LOG, null, null, this._logId, "findColumn", "String", new Object[]{string}, l);
                                        }
                                        throw throwable;
                                    }
                                    LogUtil.logEnd(LOG, null, null, this._logId, "findColumn", "String", new Object[]{string}, l);
                                }
                                return n5;
                            }
                            int n7 = this._prs.findColumnByLabel(string);
                            this._labelToColumn.put(string, new Integer(n7));
                            n4 = n7;
                            if (!bl) break block12;
                            LogUtil.logEnd(LOG, null, null, this._logId, "findColumn", "String", new Object[]{string}, l);
                        }
                        return n4;
                    }
                    if (this._nameToColumn == null) {
                        this._nameToColumn = new Hashtable();
                    }
                    if ((n3 = this._nameToColumn.get(string)) == null) break block13;
                    n2 = n3;
                    if (!bl) break block14;
                    LogUtil.logEnd(LOG, null, null, this._logId, "findColumn", "String", new Object[]{string}, l);
                }
                return n2;
            }
            int n8 = this._prs.findColumn(string);
            this._nameToColumn.put(string, new Integer(n8));
            n = n8;
            if (!bl) break block15;
            LogUtil.logEnd(LOG, null, null, this._logId, "findColumn", "String", new Object[]{string}, l);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        Reader reader;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                reader = this.getColumn(n).getCharacterStream();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getCharacterStream", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getCharacterStream", "int", new Object[]{n}, l);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        Reader reader;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                reader = this.getCharacterStream(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getCharacterStream", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getCharacterStream", "String", new Object[]{string}, l);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (this._rowIndex <= 0) {
                int n = 0;
                return n;
            }
            int n = this._rowIndex;
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getRow", null, null, l);
            }
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this._rowIndex == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this._rowIndex == -2;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this._rowIndex == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this._lastRowIndex != -4) {
            return this._rowIndex == this._lastRowIndex;
        }
        ErrorMessage.raiseMethodNotSupportedException(this, "isLast()");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkForScrollability("previous()");
            this.clearWarnings();
            boolean bl2 = true;
            switch (this._rowIndex) {
                case -1: {
                    boolean bl3 = false;
                    return bl3;
                }
                case 1: {
                    this._rowIndex = -1;
                    bl2 = false;
                    break;
                }
                case -2: {
                    this._rowIndex = this._lastRowIndex;
                    break;
                }
                default: {
                    --this._rowIndex;
                }
            }
            this._prs.previous();
            boolean bl4 = bl2;
            return bl4;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "previous", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int n) throws SQLException {
        boolean bl;
        block19: {
            int n2;
            long l;
            boolean bl2;
            block17: {
                boolean bl3;
                block18: {
                    block13: {
                        boolean bl4;
                        block16: {
                            block14: {
                                boolean bl5;
                                block15: {
                                    block11: {
                                        boolean bl6;
                                        block12: {
                                            bl2 = LogUtil.isLoggingEnabled(LOG);
                                            l = bl2 ? this._apiCount.incrementAndGet() : 0L;
                                            if (bl2) {
                                                LogUtil.logBegin(LOG, this._logId, l);
                                            }
                                            this.checkForScrollability("absolute(int)");
                                            this.clearWarnings();
                                            if (this._lastRowIndex != 0) break block11;
                                            bl6 = false;
                                            if (!bl2) break block12;
                                            LogUtil.logEnd(LOG, null, null, this._logId, "absolute", "int", new Object[]{n}, l);
                                        }
                                        return bl6;
                                    }
                                    if (n == 0) {
                                        ErrorMessage.raiseError("JZ0I3", String.valueOf(n), "absolute(int)");
                                    }
                                    if (n >= 0) break block13;
                                    if (this._lastRowIndex != -4 || this.last()) break block14;
                                    bl5 = false;
                                    if (!bl2) break block15;
                                    LogUtil.logEnd(LOG, null, null, this._logId, "absolute", "int", new Object[]{n}, l);
                                }
                                return bl5;
                            }
                            if ((n += this._lastRowIndex + 1) > 0) break block13;
                            this.beforeFirst();
                            bl4 = false;
                            if (!bl2) break block16;
                            LogUtil.logEnd(LOG, null, null, this._logId, "absolute", "int", new Object[]{n}, l);
                        }
                        return bl4;
                    }
                    n2 = this._prs.getNumRowsCached();
                    if (n > n2) break block17;
                    this._rowIndex = n;
                    this._prs.absolute(n);
                    bl3 = true;
                    if (!bl2) break block18;
                    LogUtil.logEnd(LOG, null, null, this._logId, "absolute", "int", new Object[]{n}, l);
                }
                return bl3;
            }
            try {
                if (n2 > 0) {
                    this._rowIndex = n2;
                    this._prs.absolute(this._rowIndex);
                }
                while (this._rowIndex < n && this.next()) {
                }
                boolean bl7 = bl = this._rowIndex == n;
                if (!bl2) break block19;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "absolute", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "absolute", "int", new Object[]{n}, l);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkForScrollability("afterLast()");
            this.clearWarnings();
            if (this.last()) {
                this.next();
            }
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "afterLast", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkForScrollability("beforeFirst()");
            this.clearWarnings();
            if (this.first()) {
                this.previous();
            }
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "beforeFirst", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkForScrollability("first()");
            this.clearWarnings();
            this.moveToCurrentRow();
            if (this._rowIndex == 1) {
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = this.absolute(1);
            return bl3;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "first", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkForScrollability("last()");
            this.clearWarnings();
            this.moveToCurrentRow();
            if (this._lastRowIndex == -4) {
                if (this._prs.getNumRowsCached() > 0) {
                    this._rowIndex = this._prs.getNumRowsCached();
                    this._prs.absolute(this._rowIndex);
                }
                while (this.next()) {
                }
                this.previous();
            } else if (this._lastRowIndex != 0) {
                this._rowIndex = this._lastRowIndex;
                this._prs.absolute(this._rowIndex);
            }
            boolean bl2 = this._lastRowIndex != 0;
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "last", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean relative(int n) throws SQLException {
        int n2;
        block7: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                this.checkForScrollability("relative(int)");
                this.clearWarnings();
                this.moveToCurrentRow();
                int n3 = 0;
                if (this._rowIndex != -1 && this._rowIndex != -2) {
                    n2 = this._rowIndex + n;
                    if (n2 <= 0) {
                        this.beforeFirst();
                    } else {
                        n3 = this.absolute(n2) ? 1 : 0;
                    }
                }
                n2 = n3;
                if (!bl) break block7;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "relative", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "relative", "int", new Object[]{n}, l);
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void refreshRow() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            switch (this._scrollType) {
                case 1003: 
                case 1004: {
                    return;
                }
                case 1005: {
                    ErrorMessage.raiseMethodNotSupportedException(this, "refreshRow() FOR TYPE_SCROLL_SENSITIVE");
                    return;
                }
            }
            return;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "refreshRow", null, null, l);
            }
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "moveToInsertRow()", this._concurTypeString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFetchDirection(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            block1 : switch (this._scrollType) {
                case 1003: {
                    ErrorMessage.raiseError("JZ0BT", "setFetchDirection(int)", "TYPE_FORWARD_ONLY");
                    break;
                }
                case 1004: 
                case 1005: {
                    switch (n) {
                        case 1000: 
                        case 1001: 
                        case 1002: {
                            this._fetchDirection = n;
                            break block1;
                        }
                    }
                    ErrorMessage.raiseError("JZ0I3", String.valueOf(n), "setFetchDirection(int)");
                }
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setFetchDirection", "int", new Object[]{n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setFetchDirection", "int", new Object[]{n}, l);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this._fetchDirection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFetchSize(int n) throws SQLException {
        long l;
        boolean bl;
        block5: {
            bl = LogUtil.isLoggingEnabled(LOG);
            l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                if (n != 0) break block5;
                if (!bl) return;
            }
            catch (Throwable throwable) {
                if (!bl) throw throwable;
                LogUtil.logEnd(LOG, null, null, this._logId, "setFetchSize", "int", new Object[]{n}, l);
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "setFetchSize", "int", new Object[]{n}, l);
            return;
        }
        int n2 = this._pc._protocol.getIntOption(this._pc, 4);
        if (n < 0 || n2 > 0 && n > n2) {
            ErrorMessage.raiseError("JZ0BI");
        }
        this._fetchSize = n;
        if (!bl) return;
        LogUtil.logEnd(LOG, null, null, this._logId, "setFetchSize", "int", new Object[]{n}, l);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this._scrollType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this._concurType;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int n) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNull(int)", this._concurTypeString);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBoolean(int, boolean)", this._concurTypeString);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateByte(int, byte)", this._concurTypeString);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateShort(int, short)", this._concurTypeString);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateInt(int, int)", this._concurTypeString);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateLong(int, long)", this._concurTypeString);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateFloat(int, float)", this._concurTypeString);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDouble(int, double)", this._concurTypeString);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBigDecimal(int, BigDecimal)", this._concurTypeString);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateString(int, String)", this._concurTypeString);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBytes(int, byte[])", this._concurTypeString);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDate(int, java.sql.Date)", this._concurTypeString);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTime(int, java.sql.Time)", this._concurTypeString);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTimestamp(int, java.sql.Timestamp)", this._concurTypeString);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateAsciiStream(int, java.io.InputStream, int)", this._concurTypeString);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBinaryStream(int, java.io.InputStream, int)", this._concurTypeString);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateCharacterStream(int, java.io.Reader, int)", this._concurTypeString);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(int, Object, int)", this._concurTypeString);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(int, Object)", this._concurTypeString);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNull(String)", this._concurTypeString);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBoolean(String, boolean)", this._concurTypeString);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateByte(String, byte)", this._concurTypeString);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateShort(String, short)", this._concurTypeString);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateInt(String, int)", this._concurTypeString);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateLong(String, long)", this._concurTypeString);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateFloat(String, float)", this._concurTypeString);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDouble(String, double)", this._concurTypeString);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBigDecimal(String, BigDecimal)", this._concurTypeString);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateString(String, String)", this._concurTypeString);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBytes(String, byte[])", this._concurTypeString);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDate(String, java.sql.Date)", this._concurTypeString);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTime(String, java.sql.Time)", this._concurTypeString);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTimestamp(String, java.sql.Timestamp)", this._concurTypeString);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateAsciiStream(String, java.io.InputStream, int)", this._concurTypeString);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBinaryStream(String, java.io.InputStream, int)", this._concurTypeString);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateCharacterStream(String, java.io.Reader, int)", this._concurTypeString);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(String, Object, int)", this._concurTypeString);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(String, Object)", this._concurTypeString);
    }

    @Override
    public void insertRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "insertRow()", this._concurTypeString);
    }

    @Override
    public void updateRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateRow()", this._concurTypeString);
    }

    @Override
    public void deleteRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "deleteRow()", this._concurTypeString);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "cancelRowUpdates()", this._concurTypeString);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this._statement;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getRef(int)");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int n) throws SQLException {
        Blob blob;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                blob = this.getColumn(n).getBlob();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBlob", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBlob", "int", new Object[]{n}, l);
        }
        return blob;
    }

    protected Blob getInitializedBlob(int n) throws SQLException {
        return this.getColumn(n).getInitializedBlob();
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBlob(int, Blob)", this._concurTypeString);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBlob(String, Blob)", this._concurTypeString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int n) throws SQLException {
        Clob clob;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                clob = this.getColumn(n).getClob();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getClob", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getClob", "int", new Object[]{n}, l);
        }
        return clob;
    }

    protected Clob getInitializedClob(int n) throws SQLException {
        return this.getColumn(n).getInitializedClob();
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateClob(int, Clob)", this._concurTypeString);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateClob(String, Clob)", this._concurTypeString);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getArray(int)");
        return null;
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateArray(int, Array)");
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateArray(String, Array)");
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getRef(String)");
        return null;
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateRef(int, Ref)");
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateRef(String, Ref)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(String string) throws SQLException {
        Blob blob;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                blob = this.getBlob(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBlob", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBlob", "String", new Object[]{string}, l);
        }
        return blob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(String string) throws SQLException {
        Clob clob;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                clob = this.getClob(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getClob", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getClob", "String", new Object[]{string}, l);
        }
        return clob;
    }

    @Override
    public Array getArray(String string) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getArray(String)");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                date = Convert.objectToDate(this.getColumn(n).getDateObject(91, calendar), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getDate", "int, Calendar", new Object[]{n, calendar}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getDate", "int, Calendar", new Object[]{n, calendar}, l);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        Date date;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                date = this.getDate(this.findColumn(string), calendar);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getDate", "String, Calendar", new Object[]{string, calendar}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getDate", "String, Calendar", new Object[]{string, calendar}, l);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                time = Convert.objectToTime(this.getColumn(n).getDateObject(92, calendar), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTime", "int, Calendar", new Object[]{n, calendar}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTime", "int, Calendar", new Object[]{n, calendar}, l);
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        Time time;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                time = this.getTime(this.findColumn(string), calendar);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTime", "String, Calendar", new Object[]{string, calendar}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTime", "String, Calendar", new Object[]{string, calendar}, l);
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                timestamp = Convert.objectToTimestamp(this.getColumn(n).getDateObject(93, calendar), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", "int, Calendar", new Object[]{n, calendar}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", "int, Calendar", new Object[]{n, calendar}, l);
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                timestamp = this.getTimestamp(this.findColumn(string), calendar);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", "String, Calendar", new Object[]{string, calendar}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", "String, Calendar", new Object[]{string, calendar}, l);
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            try {
                this.close(false);
            }
            catch (SQLException sQLException) {
                ErrorMessage.raiseIOECheckDead(sQLException);
            }
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "clear", null, null, l);
            }
        }
    }

    @Override
    public void setManager(CacheManager cacheManager) {
        this._cm = cacheManager;
    }

    @Override
    public void reset() throws IOException {
        Debug.notSupported(this, "reset()");
    }

    @Override
    public void resetInputStream(InputStream inputStream) {
        Debug.notSupported(this, "resetInputStream(InputStream is)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cache() throws IOException {
        try {
            switch (this._currentStatus) {
                case 2: {
                    if (this._rowIndex == -2) return;
                    if (this._scrollType != 1004) {
                        this._prs.setType(1004);
                    }
                    while (this._prs.next()) {
                    }
                    if (this._rowIndex == -1) {
                        this._prs.absolute(1);
                        this._prs.previous();
                    } else {
                        this._prs.absolute(this._rowIndex);
                    }
                    this._statement._currentOpenRS.addElement(this);
                    return;
                }
                case 3: {
                    Enumeration<SybResultSet> enumeration = this._statement._currentOpenRS.elements();
                    while (enumeration.hasMoreElements()) {
                        enumeration.nextElement().close();
                    }
                    this._statement._currentOpenRS.clear();
                }
                case 1: {
                    this.close();
                    return;
                }
            }
            return;
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOECheckDead(sQLException);
            return;
        }
        finally {
            if (this._cm != null) {
                this._cm.doneReading();
                this._cm.dead(this);
                this._cm = null;
            }
        }
    }

    @Override
    public void open(boolean bl) {
    }

    @Override
    public int getState() {
        if (this._state == IConstants.CONNECTION_STATE.DEAD) {
            return 0;
        }
        return 1;
    }

    protected synchronized void markDead(boolean bl) throws SQLException {
        block10: {
            if (this._state == IConstants.CONNECTION_STATE.DEAD) {
                return;
            }
            this._state = IConstants.CONNECTION_STATE.DEAD;
            try {
                if (this._prs == null) break block10;
                this._prs.close(bl);
                if (this._statement == null) break block10;
                try {
                    SQLWarning sQLWarning = this._prs.getWarnings();
                    if (sQLWarning != null) {
                        this._statement.handleSQLE(sQLWarning);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this._statement.setRowCount(this._prs.getCount());
            }
            finally {
                if (this._cm != null) {
                    this._cm.doneReading();
                    this._cm.dead(this);
                    this._cm = null;
                }
                if (this._statement != null) {
                    this._statement._currentRS = null;
                    if (this._statement.getCurrentCloseOnCompletionState()) {
                        this._statement.close();
                    }
                    this._statement = null;
                }
                this._nameToColumn = null;
                this._prs = null;
            }
        }
    }

    protected void checkResultSet() throws SQLException {
        if (this._state != IConstants.CONNECTION_STATE.BUSY) {
            ErrorMessage.raiseError("JZ0R0");
        }
    }

    protected void close(boolean bl) throws SQLException {
        this.markDead(bl);
    }

    protected JdbcDataObject getColumn(int n) throws SQLException {
        this.checkResultSet();
        this.checkIfReadableRow();
        this._currentColumn = this._prs.getColumn(n);
        return this._currentColumn;
    }

    protected void checkIfReadableRow() throws SQLException {
        if (this._rowIndex == -1 && !this._usedForParams) {
            ErrorMessage.raiseError("JZ0R1");
        } else if (this._rowIndex == -2) {
            ErrorMessage.raiseError("JZ0R5");
        }
    }

    public void setHoldsParams(boolean bl) {
        this._usedForParams = bl;
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal, int n2, int n3) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateBigDecimal(int, BigDecimal, int, int)");
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal, int n, int n2) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateBigDecimal(String, BigDecimal, int, int)");
    }

    protected void checkForScrollability(String string) throws SQLException {
        switch (this._scrollType) {
            case 1003: {
                ErrorMessage.raiseError("JZ0BT", string, "TYPE_FORWARD_ONLY");
                break;
            }
            case 1004: {
                break;
            }
            case 1005: {
                ErrorMessage.raiseMethodNotSupportedException(this, string + " for TYPE_SCROLL_SENSITIVE");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHoldability() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            int n = this._statement.getResultSetHoldability();
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getHoldability", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        Reader reader;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                reader = this.getColumn(n).getCharacterStream();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getNCharacterStream", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getNCharacterStream", "int", new Object[]{n}, l);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        Reader reader;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                reader = this.getNCharacterStream(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getNCharacterStream", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getNCharacterStream", "String", new Object[]{string}, l);
        }
        return reader;
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getNClob(int columnIndex)");
        return null;
    }

    protected NClob getInitializedNClob(int n) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getInitializedNClob()");
        return null;
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getNClob(String)");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int n) throws SQLException {
        String string;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                string = this.getColumn(n).getString();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getNString", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getNString", "int", new Object[]{n}, l);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(String string) throws SQLException {
        String string2;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                string2 = this.getNString(this.findColumn(string));
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getNString", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getNString", "String", new Object[]{string}, l);
        }
        return string2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._state == IConstants.CONNECTION_STATE.DEAD;
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getObject(int columnIndex, Map<String, Class<?>> map)");
        return null;
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getObject(String columnLabel, Map<String, Class<?>> map)");
        return null;
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getRowId(int columnIndex)");
        return null;
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getRowId(String columnLabel)");
        return null;
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getSQLXML(int columnIndex)");
        return null;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getSQLXML(String columnLabel)");
        return null;
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateAsciiStream(int columnIndex, InputStream x)");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateAsciiStream(String columnLabel, InputStream x)");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateAsciiStream(int columnIndex, InputStream x, long length)");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateAsciiStream(String columnLabel, InputStream x, long length)");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateBinaryStream(int columnIndex, InputStream x)");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateBinaryStream(String columnLabel, InputStream x)");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateBinaryStream(int columnIndex, InputStream x, long length)");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateBinaryStream(String columnLabel, InputStream x, long length)");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBlob(int, InputStream)", this._concurTypeString);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBlob(String, InputStream)", this._concurTypeString);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBlob(int, InputStream, long)", this._concurTypeString);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBlob(String, InputStream, long)", this._concurTypeString);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateCharacterStream(int columnIndex, Reader x)");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateCharacterStream(String columnLabel, Reader reader)");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateCharacterStream(int columnIndex, Reader x, long length)");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateCharacterStream(String columnLabel, Reader reader, long length)");
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateClob(int, Reader)", this._concurTypeString);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateClob(String, Readear)", this._concurTypeString);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateClob(int, Reader, long)", this._concurTypeString);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateClob(String, Reader, long)", this._concurTypeString);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNCharacterStream(int, java.io.Reader)", this._concurTypeString);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNCharacterStream(String, java.io.Reader)", this._concurTypeString);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNCharacterStream(int, java.io.Reader, long)", this._concurTypeString);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNCharacterStream(String, java.io.Reader, long)", this._concurTypeString);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "public void updateNClob(int columnIndex, NClob clob)");
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "public void updateNClob(String columnLabel, NClob clob)");
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "public void updateNClob(int columnIndex, Reader reader)");
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNClob(String, Reader)", this._concurTypeString);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNClob(int, Reader, long)", this._concurTypeString);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNClob(String, Reader, long)", this._concurTypeString);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNString(int, String)", this._concurTypeString);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNString(String, String)", this._concurTypeString);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateRowId(int columnIndex, RowId x)");
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateRowId(String columnLabel, RowId x)");
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateSQLXML(int columnIndex, SQLXML xmlObject)");
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateSQLXML(String columnLabel, SQLXML xmlObject)");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        T t = null;
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            ErrorMessage.raiseError("JZ031", clazz.getName(), classCastException);
        }
        return t;
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        Object object = null;
        switch (clazz.getCanonicalName()) {
            case "byte[]": {
                object = this.getColumn(n).getBytes();
                break;
            }
            case "java.sql.Date": {
                object = Convert.objectToDate(this.getColumn(n).getDateObject(91, null), null);
                break;
            }
            case "java.sql.Time": {
                object = Convert.objectToTime(this.getColumn(n).getDateObject(92, null), null);
                break;
            }
            case "java.sql.Timestamp": {
                object = Convert.objectToTimestamp(this.getColumn(n).getDateObject(93, null), null);
                break;
            }
            default: {
                object = this.getColumn(n).getObject();
            }
        }
        String string = this.convertObjectToJavaType(object, clazz);
        return (T)string;
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        Object object = null;
        switch (clazz.getCanonicalName()) {
            case "byte[]": {
                object = this.getBytes(this.findColumn(string));
                break;
            }
            case "java.sql.Date": {
                object = this.getDate(this.findColumn(string));
                break;
            }
            case "java.sql.Time": {
                object = this.getTime(this.findColumn(string));
                break;
            }
            case "java.sql.Timestamp": {
                object = this.getTimestamp(this.findColumn(string));
                break;
            }
            default: {
                object = this.getObject(this.findColumn(string));
            }
        }
        String string2 = this.convertObjectToJavaType(object, clazz);
        return (T)string2;
    }

    private <T> T convertObjectToJavaType(Object object, Class<T> clazz) throws SQLException {
        switch (clazz.getCanonicalName()) {
            case "java.lang.Integer": {
                if (!(object instanceof Short)) break;
                object = ((Short)object).intValue();
                break;
            }
            case "java.lang.Float": {
                if (!(object instanceof BigDecimal)) break;
                object = Float.valueOf(((BigDecimal)object).floatValue());
                break;
            }
            case "java.lang.Double": {
                if (!(object instanceof BigDecimal)) break;
                object = ((BigDecimal)object).doubleValue();
            }
        }
        try {
            object = clazz.cast(object);
        }
        catch (ClassCastException classCastException) {
            ErrorMessage.raiseError("JZ0TC", new SQLException(classCastException));
        }
        return (T)object;
    }
}

