/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.charset.CharsetUtil;
import com.sybase.jdbc42.jdbc.ErrorMessage;
import com.sybase.jdbc42.jdbc.ParamManager;
import com.sybase.jdbc42.jdbc.SybProperty;
import com.sybase.jdbc42.security.asn1.ASN1InputStream;
import com.sybase.jdbc42.security.asn1.ASN1Integer;
import com.sybase.jdbc42.security.asn1.DLSequence;
import com.sybase.jdbc42.security.util.Base64Tools;
import com.sybase.jdbc42.tds.Encryption;
import com.sybase.jdbc42.tds.MsgToken;
import com.sybase.jdbc42.tds.Tds;
import com.sybase.jdbc42.tds.TdsDataObject;
import com.sybase.jdbc42.tds.TdsInt;
import com.sybase.jdbc42.tds.TdsJdbcInputStream;
import com.sybase.jdbc42.tds.TdsProtocolContext;
import com.sybase.jdbc42.utils.JCEProviderUtil;
import com.sybase.jdbc42.utils.LogUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.RSAPublicKeySpec;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public final class SecLoginContext {
    private static final Logger LOG = LogUtil.createLoggerInstance(SecLoginContext.class.getName());
    private byte[] _salt = null;
    private byte[] _nonce = null;
    private Tds _protocol = null;
    private Cipher _cipherSuite = null;
    private int _encryptMsgId;
    private SecretKey _symmetricKey = null;
    private SYMMETRICKEY_STATE _symmetricKeyState = SYMMETRICKEY_STATE.NOT_GENERATED;

    SecLoginContext(Tds tds, int n) throws SQLException {
        this._protocol = tds;
        this._encryptMsgId = n;
        SybProperty sybProperty = this._protocol.getSybProperty();
        if (this._encryptMsgId == 14 || this._encryptMsgId == 30 || this._encryptMsgId == 35) {
            try {
                Object object = sybProperty.getObject(66);
                boolean bl = sybProperty.getBoolean(104);
                JCEProviderUtil.initProvider(object, bl);
            }
            catch (Exception exception) {
                ErrorMessage.raiseError("JZ028", new SQLException(exception));
            }
        }
    }

    void extractServerPublicKey(TdsProtocolContext tdsProtocolContext) throws IOException, SQLException {
        TdsDataObject tdsDataObject;
        this._protocol.nextResult(tdsProtocolContext);
        int n = tdsProtocolContext._in.readUnsignedByte();
        int n2 = 0;
        if (this._encryptMsgId == 14 || this._encryptMsgId == 30 || this._encryptMsgId == 35) {
            tdsDataObject = new TdsInt(tdsProtocolContext);
            ((TdsInt)tdsDataObject)._dataFmt = tdsProtocolContext._paramFmts.getDataFormat(n2);
            ((TdsInt)tdsDataObject).getInt();
            try {
                this._cipherSuite = JCEProviderUtil.createCipherSuite();
            }
            catch (GeneralSecurityException generalSecurityException) {
                ErrorMessage.raiseError("JZ0LA", "RSA/ECB/OAEPWithSHA1AndMGF1Padding or RSA/NONE/OAEPWithSHA1AndMGF1Padding", generalSecurityException);
            }
            ++n2;
        }
        tdsDataObject = new TdsJdbcInputStream(null, tdsProtocolContext, this._protocol);
        ((TdsJdbcInputStream)tdsDataObject)._dataFmt = tdsProtocolContext._paramFmts.getDataFormat(n2);
        this._salt = ((TdsJdbcInputStream)tdsDataObject).getBytes();
        ++n2;
        if (this._encryptMsgId == 30 || this._encryptMsgId == 35) {
            TdsJdbcInputStream tdsJdbcInputStream = new TdsJdbcInputStream(null, tdsProtocolContext, this._protocol);
            tdsJdbcInputStream._dataFmt = tdsProtocolContext._paramFmts.getDataFormat(n2);
            this._nonce = tdsJdbcInputStream.getBytes();
        }
        tdsProtocolContext._lastResult = -1;
        if (this._protocol._info.getBoolean(55) || !this._protocol._capT._reqCaps.get(106)) {
            this._protocol.nextResult(tdsProtocolContext);
        }
    }

    void sendEncPwd(TdsProtocolContext tdsProtocolContext, String string) throws SQLException, IOException {
        Object object;
        if (string == null) {
            string = "";
        }
        byte[] byArray = this._protocol._charsetName == null ? string.getBytes() : (this._protocol._charsetName.equals("x-SybUTF8") ? CharsetUtil.fromSybUTF8(string) : string.getBytes(this._protocol._charsetName));
        byte[] byArray2 = null;
        int n = 2;
        int n2 = 3;
        int n3 = -3;
        if (this._encryptMsgId == 14 || this._encryptMsgId == 30 || this._encryptMsgId == 35) {
            if (this._encryptMsgId == 30 || this._encryptMsgId == 35) {
                n = 31;
                n2 = 32;
                n3 = -4;
                byArray = this.prependNonce(byArray);
            } else {
                n = 15;
                n2 = 22;
            }
            try {
                object = this.generateServerPublicKey();
                this._cipherSuite.init(1, (Key)object);
                byArray2 = this._cipherSuite.doFinal(byArray);
            }
            catch (GeneralSecurityException generalSecurityException) {
                ErrorMessage.raiseError("JZ0P4");
            }
        } else {
            byArray2 = new byte[33];
            object = new Encryption();
            int n4 = ((Encryption)object).pwd_encrypt(this._salt, this._salt.length, byArray, byArray.length, byArray2);
            byArray2[32] = (byte)n4;
        }
        object = new MsgToken(1, (short)n);
        ParamManager paramManager = new ParamManager(1, tdsProtocolContext);
        paramManager.setParam(1, n3, (Object)byArray2, 0);
        ((MsgToken)object).send(this._protocol._out);
        this._protocol.sendParamStream(paramManager, this._protocol._out);
        object = new MsgToken(1, (short)n2);
        paramManager = new ParamManager(2, tdsProtocolContext);
        paramManager.setParam(1, 12, null, 0);
        paramManager.setParam(2, n3, (Object)byArray2, 0);
        ((MsgToken)object).send(this._protocol._out);
        this._protocol.sendParamStream(paramManager, this._protocol._out);
        if (this._encryptMsgId == 35) {
            this.generateSymmetricKey(tdsProtocolContext);
        }
        this._protocol._out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey generateServerPublicKey() throws SQLException, IOException {
        PublicKey publicKey = null;
        String string = this._protocol._charsetName == null ? new String(this._salt) : (this._protocol._charsetName.equals("x-SybUTF8") ? CharsetUtil.toSybUTF8(this._salt) : new String(this._salt, this._protocol._charsetName));
        ASN1InputStream aSN1InputStream = new ASN1InputStream(this.decodePEM(new StringReader(string)));
        DLSequence dLSequence = (DLSequence)aSN1InputStream.readObject();
        Enumeration enumeration = dLSequence.getObjects();
        BigInteger bigInteger = ASN1Integer.getInstance(enumeration.nextElement()).getPositiveValue();
        BigInteger bigInteger2 = ASN1Integer.getInstance(enumeration.nextElement()).getPositiveValue();
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (GeneralSecurityException generalSecurityException) {
            ErrorMessage.raiseError("JZ0P4");
        }
        finally {
            if (aSN1InputStream != null) {
                aSN1InputStream.close();
            }
        }
        return publicKey;
    }

    void generateSymmetricKey(TdsProtocolContext tdsProtocolContext) throws SQLException, IOException {
        MsgToken msgToken = new MsgToken(1, 34);
        ParamManager paramManager = new ParamManager(1, tdsProtocolContext);
        try {
            this.createSymmetricKey();
            byte[] byArray = this.prependNonce(this._symmetricKey.getEncoded());
            this._cipherSuite.init(1, this.generateServerPublicKey());
            byte[] byArray2 = this._cipherSuite.doFinal(byArray);
            paramManager.setParam(1, -4, (Object)byArray2, 0);
            msgToken.send(this._protocol._out);
            this._protocol.sendParamStream(paramManager, this._protocol._out);
            this._symmetricKeyState = SYMMETRICKEY_STATE.GENERATED;
        }
        catch (GeneralSecurityException generalSecurityException) {
            ErrorMessage.raiseError("JZ0P4");
        }
    }

    private byte[] decodePEM(Reader reader) throws SQLException, IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = null;
        boolean bl = false;
        StringWriter stringWriter = new StringWriter();
        while ((string = bufferedReader.readLine()) != null) {
            if (!bl && string.startsWith("-----BEGIN")) {
                bl = true;
                continue;
            }
            if (bl && string.startsWith("-----END")) break;
            stringWriter.write(string);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64Tools.decode(new StringReader(stringWriter.toString()), byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] prependNonce(byte[] byArray) {
        byte[] byArray2 = new byte[this._nonce.length + byArray.length];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = i < this._nonce.length ? this._nonce[i] : byArray[i - this._nonce.length];
        }
        return byArray2;
    }

    private void createSymmetricKey() throws SQLException {
        if (this._symmetricKey == null) {
            try {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                keyGenerator.init(256, new SecureRandom());
                this._symmetricKey = keyGenerator.generateKey();
            }
            catch (GeneralSecurityException generalSecurityException) {
                ErrorMessage.raiseError("JZ0P4");
            }
        }
    }

    byte[] encryptData(byte[] byArray) throws SQLException {
        byte[] byArray2 = null;
        try {
            Cipher cipher = JCEProviderUtil.createAESCipherSuite();
            cipher.init(1, this._symmetricKey);
            byArray2 = cipher.doFinal(byArray);
            if (LogUtil.isLoggingEnabled(LOG)) {
                LOG.finer("Decrypted Data: " + this.decryptData(byArray2, cipher.getIV()));
            }
            byte[] byArray3 = new byte[8 + cipher.getIV().length + byArray2.length];
            System.arraycopy(cipher.getIV(), 0, byArray3, 8, cipher.getIV().length);
            System.arraycopy(byArray2, 0, byArray3, 24, byArray2.length);
            byArray2 = byArray3;
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (LogUtil.isLoggingEnabled(LOG)) {
                LOG.finer("Unable to load AES/CBC/PKCS5Padding: {" + generalSecurityException.getMessage() + "} giving up!");
            }
            ErrorMessage.raiseError("JZ0P4");
        }
        return byArray2;
    }

    byte[] encryptData(byte[] byArray, byte[] byArray2) throws SQLException {
        byte[] byArray3 = null;
        try {
            Cipher cipher = JCEProviderUtil.createAESCipherSuite();
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            cipher.init(1, (Key)this._symmetricKey, ivParameterSpec);
            byArray3 = cipher.doFinal(byArray);
            if (LogUtil.isLoggingEnabled(LOG)) {
                LOG.finer("Decrypted Data: " + this.decryptData(byArray3, cipher.getIV()));
            }
            byte[] byArray4 = new byte[8 + byArray3.length];
            System.arraycopy(byArray3, 0, byArray4, 8, byArray3.length);
            byArray3 = byArray4;
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (LogUtil.isLoggingEnabled(LOG)) {
                LOG.finer("Unable to load AES/CBC/PKCS5Padding: {" + generalSecurityException.getMessage() + "} giving up!");
            }
            ErrorMessage.raiseError("JZ0P4");
        }
        return byArray3;
    }

    String decryptData(byte[] byArray, byte[] byArray2) throws SQLException {
        byte[] byArray3 = null;
        try {
            Cipher cipher = JCEProviderUtil.createAESCipherSuite();
            if (byArray2 == null) {
                cipher.init(2, this._symmetricKey);
            } else {
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
                cipher.init(2, (Key)this._symmetricKey, ivParameterSpec);
            }
            byArray3 = cipher.doFinal(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            ErrorMessage.raiseError("JZ0P4");
        }
        return new String(byArray3);
    }

    boolean isSymmetricKeySent() {
        return this._symmetricKeyState == SYMMETRICKEY_STATE.SENT;
    }

    boolean isSymmetricKeyGenerated() {
        return this._symmetricKeyState == SYMMETRICKEY_STATE.GENERATED;
    }

    void setSymmetricKeyStateSENT() {
        this._symmetricKeyState = SYMMETRICKEY_STATE.SENT;
    }

    private static enum SYMMETRICKEY_STATE {
        NOT_GENERATED,
        GENERATED,
        SENT;

    }
}

