/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.jdbc.ErrorMessage;
import com.sybase.jdbc42.jdbc.JdbcDataObject;
import com.sybase.jdbc42.jdbc.ProtocolResultSet;
import com.sybase.jdbc42.jdbc.SybConnection;
import com.sybase.jdbc42.tds.AltFormatToken;
import com.sybase.jdbc42.tds.DataFormat;
import com.sybase.jdbc42.tds.RowFormatToken;
import com.sybase.jdbc42.tds.Tds;
import com.sybase.jdbc42.tds.TdsDataObject;
import com.sybase.jdbc42.tds.TdsInt;
import com.sybase.jdbc42.tds.TdsJdbcInputStream;
import com.sybase.jdbc42.tds.TdsProtocolContext;
import com.sybase.jdbc42.tds.TdsReal;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

public class TdsResultSet
implements ProtocolResultSet {
    protected static final int TYPE_TDSRESULTSET = 1;
    protected static final int TYPE_TDSPARAMSET_EED = 2;
    protected static final int TYPE_TDSPARAMSET_EVENT = 3;
    protected static final int TYPE_TDSPARAMSET_MSG = 4;
    protected TdsProtocolContext _tpc = null;
    protected int _rowCount = 0;
    protected boolean _needNext = true;
    protected SQLWarning _warning;
    protected TdsDataObject[] _columns;
    protected int _tdsResultSetType = 1;
    protected RowFormatToken _rowfmt;
    protected int _totalColumns = -1;
    protected Vector<TdsDataObject[]> _cachedRows = null;
    protected int _rowIndex = 0;
    protected boolean _dead = false;
    protected int _type = 1003;
    protected boolean _scrolling = false;
    protected boolean _serverSideScrolling = false;
    protected TdsDataObject[] _savedCols = null;
    protected int _lastFetchSize = 1;
    protected boolean _isAltResult = false;
    protected boolean _altFetchFinished = false;
    protected int _totalCursorRows = 0;

    protected TdsResultSet(TdsProtocolContext tdsProtocolContext) throws SQLException {
        this._tpc = tdsProtocolContext;
        if (tdsProtocolContext._lastResult == 6) {
            int n = tdsProtocolContext.getCurrentAltRow().getId();
            this._rowfmt = tdsProtocolContext.getAltFmt(n);
            this._rowfmt.setPc(tdsProtocolContext);
            this._totalColumns = ((AltFormatToken)this._rowfmt).getFormatCount();
            this._isAltResult = true;
        } else {
            this._rowfmt = tdsProtocolContext.getFormat();
            this._rowfmt.setPc(tdsProtocolContext);
            this._totalColumns = this._rowfmt._numColumns;
        }
        this._columns = new TdsDataObject[this._totalColumns];
        TdsDataObject tdsDataObject = null;
        try {
            for (int i = 0; i < this._totalColumns; ++i) {
                DataFormat dataFormat = this._rowfmt.getDataFormat(i);
                switch (dataFormat._datatype) {
                    case 38: 
                    case 48: 
                    case 52: 
                    case 56: 
                    case 65: 
                    case 66: 
                    case 191: {
                        this._columns[i] = new TdsInt(tdsProtocolContext);
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        this._columns[i] = new TdsReal(tdsProtocolContext);
                        break;
                    }
                    case 68: {
                        if (dataFormat._length < 8) {
                            this._columns[i] = new TdsInt(tdsProtocolContext);
                            break;
                        }
                        this._columns[i] = new TdsJdbcInputStream(null, tdsProtocolContext, (Tds)tdsProtocolContext._protocol);
                        break;
                    }
                    default: {
                        this._columns[i] = new TdsJdbcInputStream(null, tdsProtocolContext, (Tds)tdsProtocolContext._protocol);
                    }
                }
                this._columns[i]._dataFmt = dataFormat;
                this._columns[i].setPrevious(tdsDataObject);
                if (tdsDataObject != null) {
                    tdsDataObject.setNext(this._columns[i]);
                }
                tdsDataObject = this._columns[i];
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    protected RowFormatToken getFormat() {
        return this._tpc._paramFmts;
    }

    @Override
    public void setType(int n) {
        this._type = n;
        if (this._type == 1004) {
            this._cachedRows = new Vector();
            this._scrolling = true;
        }
    }

    @Override
    public int getType() {
        return this._type;
    }

    public void setLastFetchSize(int n) {
        this._lastFetchSize = n;
    }

    public int getLastFetchSize() {
        return this._lastFetchSize;
    }

    @Override
    public boolean previous() throws SQLException {
        --this._rowIndex;
        if (this._rowIndex != 0) {
            this._columns = this._cachedRows.get(this._rowIndex - 1);
        }
        return false;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (this._rowIndex != n && n != 0) {
            this._rowIndex = n;
            this._columns = this._cachedRows.get(this._rowIndex - 1);
        }
        return false;
    }

    @Override
    public boolean relative(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean first() throws SQLException {
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        return false;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return false;
    }

    @Override
    public boolean isResultSetEmpty() throws SQLException {
        return false;
    }

    @Override
    public int getRowNumber() throws SQLException {
        return -1;
    }

    @Override
    public int getNumRowsCached() {
        return this._scrolling ? this._cachedRows.size() : 0;
    }

    @Override
    public boolean next() throws SQLException {
        int n;
        if (this._scrolling) {
            if (this._rowIndex < this._cachedRows.size()) {
                ++this._rowIndex;
                this._columns = this._cachedRows.get(this._rowIndex - 1);
                return true;
            }
            if (this._dead) {
                ++this._rowIndex;
                return false;
            }
            if (this._rowIndex > 0 && this._cachedRows.size() == 0) {
                this._cachedRows.setSize(this._rowIndex - 1);
                this.cacheCurrentRow();
            }
        }
        if (!this._needNext) {
            if (this._tpc._lastResult != 211) {
                this._tpc._lastResult = -1;
            }
            try {
                if (this._scrolling) {
                    this._columns = this._savedCols;
                }
                for (n = 0; n < this._totalColumns; ++n) {
                    this._columns[n].clear();
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
        if (this._altFetchFinished) {
            this.markDead();
            ++this._rowIndex;
            return false;
        }
        n = this.nextResult();
        switch (n) {
            case 211: {
                this._altFetchFinished = true;
            }
            case 209: {
                ++this._rowIndex;
                ++this._rowCount;
                if (this._scrolling) {
                    this.cacheCurrentRow();
                }
                this._needNext = false;
                return true;
            }
            case 5: {
                this._rowCount = this._tpc._protocol.count(this._tpc);
                if (this._tpc._cursor != null) {
                    this._totalCursorRows += this._rowCount;
                }
                ++this._rowIndex;
                this.markDead();
                return false;
            }
            case 6: {
                this._tpc._protocol.ungetResult(this._tpc, n);
                this.markDead();
                ++this._rowIndex;
                return false;
            }
        }
        this._tpc._protocol.ungetResult(this._tpc, n);
        this.markDead();
        return false;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._warning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._warning = null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this._rowfmt;
    }

    protected synchronized void markDead() {
        this._dead = true;
    }

    @Override
    public void close(boolean bl) throws SQLException {
        if (this._dead) {
            if (this._tpc._cursor == null) {
                switch (this._tdsResultSetType) {
                    case 1: {
                        this._tpc._trs = null;
                        break;
                    }
                    case 2: {
                        this._tpc._trsForEed = null;
                        break;
                    }
                    case 3: {
                        this._tpc._trsForEvent = null;
                        break;
                    }
                    case 4: {
                        this._tpc._trsForMsg = null;
                    }
                }
            }
            return;
        }
        if (this._scrolling) {
            this._scrolling = false;
            if (this._savedCols != null) {
                this._columns = this._savedCols;
            }
        }
        if (!bl) {
            while (this.next()) {
            }
        }
        if (this._tpc._cursor == null) {
            switch (this._tdsResultSetType) {
                case 1: {
                    this._tpc._trs = null;
                    break;
                }
                case 2: {
                    this._tpc._trsForEed = null;
                    break;
                }
                case 3: {
                    this._tpc._trsForEvent = null;
                    break;
                }
                case 4: {
                    this._tpc._trsForMsg = null;
                }
            }
        }
        this.markDead();
    }

    @Override
    public int getCount() throws SQLException {
        return this._rowCount;
    }

    @Override
    public JdbcDataObject getColumn(int n) throws SQLException {
        int n2 = this._isAltResult ? n - 1 : this._rowfmt.mapColumn(n);
        return this._columns[n2];
    }

    @Override
    public int findColumn(String string) throws SQLException {
        int n = 0;
        for (int i = 0; i < this._rowfmt._numColumns; ++i) {
            if ((this._rowfmt.getStatus(i) & 1) != 0) continue;
            ++n;
            if (!this._rowfmt.getName(i).equalsIgnoreCase(string)) continue;
            return n;
        }
        ErrorMessage.raiseError("S0022", string);
        return -1;
    }

    @Override
    public int findColumnByLabel(String string) throws SQLException {
        int n = 0;
        for (int i = 0; i < this._rowfmt._numColumns; ++i) {
            if ((this._rowfmt.getStatus(i) & 1) != 0) continue;
            ++n;
            if (!this._rowfmt.getLabel(i).equalsIgnoreCase(string)) continue;
            return n;
        }
        ErrorMessage.raiseError("S0022", string);
        return -1;
    }

    protected void handleSQLE(SQLException sQLException) throws SQLException {
        boolean bl = SybConnection.thisChainHasAnException(sQLException);
        SQLWarning sQLWarning = null;
        if (!bl) {
            sQLWarning = (SQLWarning)sQLException;
        } else if (((Tds)this._tpc._protocol).getSybProperty().getBoolean(76)) {
            sQLException = SybConnection.getAllExceptions(sQLException);
        } else {
            sQLWarning = SybConnection.getAllTheWarnings(sQLException);
        }
        if (sQLWarning != null) {
            if (this._warning == null) {
                this._warning = sQLWarning;
            } else {
                this._warning.setNextWarning(sQLWarning);
            }
        }
        if (bl) {
            throw sQLException;
        }
    }

    protected int nextResult() throws SQLException {
        int n;
        while (true) {
            try {
                n = this._tpc._protocol.nextResult(this._tpc);
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
                continue;
            }
            break;
        }
        return n;
    }

    protected void prepareForNextFetch() {
        this._needNext = true;
        if (this._scrolling) {
            if (this._rowIndex != 0) {
                --this._rowIndex;
            }
            this._dead = false;
        }
    }

    protected void cacheCurrentRow() throws SQLException {
        TdsDataObject[] tdsDataObjectArray = new TdsDataObject[this._totalColumns];
        try {
            for (int i = 0; i < this._totalColumns; ++i) {
                tdsDataObjectArray[i] = this._columns[i].createCachedCopy();
            }
            this._cachedRows.insertElementAt(tdsDataObjectArray, this._rowIndex - 1);
            this._savedCols = this._columns;
            this._columns = tdsDataObjectArray;
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZ006", iOException.getMessage());
        }
    }

    protected void dump() {
    }

    protected void reset() {
        this._rowCount = 0;
        this._needNext = true;
        this._warning = null;
        if (this._cachedRows != null) {
            this._cachedRows.clear();
        }
        this._rowIndex = 0;
        this._dead = false;
        this._lastFetchSize = 1;
        for (int i = 0; i < this._totalColumns; ++i) {
            this._columns[i].initialize();
        }
    }
}

