/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.utils;

import com.sybase.jdbc42.jdbc.ErrorMessage;
import com.sybase.jdbc42.jdbc.SybProperty;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;

public class JCEProviderUtil {
    public static final String RSA_JCE_PROVIDER_NAME = "JsafeJCE";
    public static final String RSA_JCE_FIPS_PROVIDER_NAME = "JsafeJCE/FIPS140/USER";

    public static final Provider initProvider(Object object, boolean bl) throws Exception {
        Provider provider = null;
        if (bl) {
            boolean bl2;
            boolean bl3 = bl2 = Security.getProvider(RSA_JCE_FIPS_PROVIDER_NAME) != null;
            if (bl2) {
                if (!Security.getProviders()[0].getName().equals(RSA_JCE_FIPS_PROVIDER_NAME)) {
                    provider = Security.getProvider(RSA_JCE_FIPS_PROVIDER_NAME);
                    Security.removeProvider(RSA_JCE_FIPS_PROVIDER_NAME);
                    bl2 = false;
                }
            } else {
                provider = JCEProviderUtil.initRSAProvider();
                if (provider == null) {
                    ErrorMessage.raiseError("JZ035");
                }
            }
            if (!bl2) {
                int n = Security.insertProviderAt(provider, 1);
            }
            return provider;
        }
        if (object != null) {
            if (object instanceof String) {
                provider = (Provider)Class.forName((String)object).newInstance();
            } else if (object instanceof Provider) {
                provider = (Provider)object;
            }
            if (!Security.getProviders()[0].getName().equals(provider.getName())) {
                Security.removeProvider(provider.getName());
                Security.insertProviderAt(provider, 1);
            }
        } else {
            provider = Security.getProviders()[0];
        }
        return provider;
    }

    private static Provider initRSAProvider() {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            if (!providerArray[i].getClass().getName().equals("com.rsa.jsafe.provider.JsafeJCE")) continue;
            return providerArray[i];
        }
        try {
            return JCEProviderUtil.getRSAFIPSProvider(null);
        }
        catch (Exception exception) {
            URL[] uRLArray = new URL[SybProperty.RSA_JCE_PROVIDER_JARS.length];
            if (uRLArray.length > 0) {
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                URL[] uRLArray2 = null;
                Method method = null;
                try {
                    method = classLoader.getClass().getMethod("getURLs", null);
                    if (method != null) {
                        uRLArray2 = (URL[])method.invoke((Object)classLoader, (Object[])null);
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (uRLArray2 != null) {
                    int n;
                    URL uRL = null;
                    for (n = 0; n < uRLArray2.length; ++n) {
                        if (uRLArray2[n].getPath().indexOf("jconn42.jar") == -1 && uRLArray2[n].getPath().indexOf("jconn42d.jar") == -1) continue;
                        uRL = uRLArray2[n];
                        break;
                    }
                    if (uRL != null) {
                        n = uRL.getPath().lastIndexOf("/");
                        if (n != -1) {
                            String string = uRL.getPath().substring(0, n);
                            try {
                                for (int i = 0; i < uRLArray.length; ++i) {
                                    uRLArray[i] = new File(string, SybProperty.RSA_JCE_PROVIDER_JARS[i]).toURI().toURL();
                                }
                            }
                            catch (Exception exception3) {
                                uRLArray = new URL[]{};
                            }
                        }
                    } else {
                        uRLArray = new URL[]{};
                    }
                    URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                    try {
                        return JCEProviderUtil.getRSAFIPSProvider(uRLClassLoader);
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
            }
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return JCEProviderUtil.getRSAFIPSProvider(classLoader);
            }
            catch (Exception exception5) {
                return null;
            }
        }
    }

    private static Provider getRSAFIPSProvider(ClassLoader classLoader) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException, ClassNotFoundException {
        Class<?> clazz = null;
        clazz = classLoader == null ? Class.forName("com.rsa.jsafe.crypto.CryptoJ") : Class.forName("com.rsa.jsafe.crypto.CryptoJ", true, classLoader);
        Method method = clazz.getMethod("getFIPS140Context", null);
        Object object = method.invoke(null, (Object[])null);
        clazz = classLoader == null ? Class.forName("com.rsa.jsafe.provider.JsafeJCE") : Class.forName("com.rsa.jsafe.provider.JsafeJCE", true, classLoader);
        Constructor<?> constructor = clazz.getConstructor(object.getClass());
        return (Provider)constructor.newInstance(object);
    }

    public static Cipher createCipherSuite() throws GeneralSecurityException {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
        }
        catch (GeneralSecurityException generalSecurityException) {
            cipher = Cipher.getInstance("RSA/NONE/OAEPWithSHA1AndMGF1Padding");
        }
        return cipher;
    }

    public static Cipher createAESCipherSuite() throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        return cipher;
    }
}

