/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import sek.ase.auditor.AppConfig;
import sek.ase.auditor.NormalExitException;
import sek.ase.auditor.Version;
import sek.ase.auditor.collectors.SybAuditCollector;
import sek.ase.auditor.collectors.SybStmntCollector;
import sek.ase.auditor.utils.Configuration;
import sek.ase.auditor.utils.Memory;
import sek.ase.auditor.utils.OpenSslAesUtil;
import sek.ase.auditor.utils.ShutdownHandler;
import sek.ase.auditor.utils.StringUtil;
import sek.ase.auditor.wqs.WriterQueueHandler;

public class AseAuditor {
    private static Logger _logger = LogManager.getLogger();
    private static SybAuditCollector _sybSecurityCollector;
    private static SybStmntCollector _sybStmntCollector;
    public static final String APP_NAME;

    public static String getAppHomeEnvName() {
        return "SEK_ASE_AUDITOR_HOME";
    }

    public static String getAppSaveDirEnvName() {
        return "SEK_ASE_AUDITOR_SAVE_DIR";
    }

    public static void printHelp(Options options, String errorStr) {
        PrintWriter pw = new PrintWriter(System.out);
        if (errorStr != null) {
            pw.println();
            pw.println(errorStr);
            pw.println();
        }
        pw.println("usage: " + Version.getAppName() + " [-h] [-v] [-x] ");
        pw.println("              [-U user] [-P passwd] [-S srv] ");
        pw.println("              [-C <cfgfile>] [-D <key=val>] ");
        pw.println("  ");
        pw.println("options:");
        pw.println("  -U,--user <user>          Username when connecting to server.");
        pw.println("  -P,--passwd <passwd>      Password when connecting to server. null=noPasswd");
        pw.println("  -S,--server <server>      Server to connect to (in interfaces file)");
        pw.println("                            or HOSTNAME:PORT or full URL jdbc:sybase:Tds:HOSTNAME:PORT");
        pw.println("  -C,--config  <filename>   System Config file.");
        pw.println("  ");
        pw.println("  -h,--help                 Usage information.");
        pw.println("  -v,--version              Display " + Version.getAppName() + " and JVM Version.");
        pw.println("  -D,--javaSystemProp <k=v> set Java System Property, same as java -Dkey=value");
        pw.println("  -1,--encrypt1 passwd      Encrypt a password that can go into configuration");
        pw.println("  -2,--encrypt2 passwd      Encrypt a password that can go into ~/passwd.enc");
        pw.println("  -x,--debug <dbg1,dbg2>    Debug options: a comma separated string");
        pw.println("                            To get available option, do -x list");
        pw.println("  ");
        pw.flush();
    }

    public static synchronized Options buildCommandLineOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"C").longOpt("config").hasArg(true).build());
        options.addOption(Option.builder((String)"h").longOpt("help").hasArg(false).build());
        options.addOption(Option.builder((String)"v").longOpt("version").hasArg(false).build());
        options.addOption(Option.builder((String)"x").longOpt("debug").hasArg(true).build());
        options.addOption(Option.builder((String)"U").longOpt("user").hasArg(true).build());
        options.addOption(Option.builder((String)"P").longOpt("passwd").hasArg(true).build());
        options.addOption(Option.builder((String)"S").longOpt("server").hasArg(true).build());
        options.addOption(Option.builder((String)"D").longOpt("javaSystemProp").hasArgs().valueSeparator('=').build());
        options.addOption(Option.builder((String)"1").longOpt("encrypt1").hasArg(true).build());
        options.addOption(Option.builder((String)"2").longOpt("encrypt2").hasArg(true).build());
        return options;
    }

    public static CommandLine parseCommandLine(String[] args, Options options) throws ParseException {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        if (_logger.isDebugEnabled()) {
            for (Option opt : cmd) {
                _logger.debug("parseCommandLine: swith='" + opt.getOpt() + "', value='" + opt.getValue() + "'.");
            }
        }
        return cmd;
    }

    public static String getConfigFileName() {
        return "sek_ase_auditor.properties";
    }

    public static void init(CommandLine cmd) throws Exception {
        String encPasswd;
        String cleanPasswd;
        String CONFIG_FILE_NAME = System.getProperty("CONFIG_FILE_NAME", AseAuditor.getConfigFileName());
        String APP_HOME = System.getProperty(AseAuditor.getAppHomeEnvName());
        String defaultPropsFile = APP_HOME != null ? APP_HOME + File.separator + "conf" + File.separator + CONFIG_FILE_NAME : CONFIG_FILE_NAME;
        String propFile = cmd.getOptionValue("config", defaultPropsFile);
        StringUtil.setEnvironmentVariablesToSystemProperties(false, false);
        if (cmd.hasOption('D')) {
            Properties javaProps = cmd.getOptionProperties("D");
            for (String key : javaProps.stringPropertyNames()) {
                String val = javaProps.getProperty(key);
                System.setProperty(key, val);
                boolean debug = true;
                if (!debug) continue;
                System.out.println("   SETTING SYSTEM PROPERTY: key=|" + key + "|, val=|" + val + "|.");
            }
        }
        System.setProperty("java.awt.headless", "true");
        if (cmd.hasOption("encrypt1")) {
            cleanPasswd = cmd.getOptionValue("encrypt1");
            encPasswd = Configuration.encryptPropertyValue("dbms.password", cleanPasswd);
            System.out.println("");
            System.out.println("=======================================================================================================");
            System.out.println("Paste the below encrypted password in the config file '" + propFile + "'.");
            System.out.println("dbms.password = " + encPasswd);
            System.out.println("=======================================================================================================");
            System.out.println("");
            System.exit(0);
        }
        if (cmd.hasOption("encrypt2")) {
            String tmpSrvname;
            cleanPasswd = cmd.getOptionValue("encrypt2");
            encPasswd = OpenSslAesUtil.encode("sybase", cleanPasswd);
            String tmpUsername = cmd.hasOption('U') ? cmd.getOptionValue('U') : "sa";
            String string = tmpSrvname = cmd.hasOption('S') ? cmd.getOptionValue('S') : "PROD_1A_ASE";
            if (tmpSrvname.contains(":")) {
                tmpSrvname = "PROD_1A_ASE";
            }
            System.out.println("");
            System.out.println("=======================================================================================================");
            System.out.println("Paste the encrypted password '" + encPasswd + "' in the '~/passwd.enc' file in the format 'username:srvname:encyptedPassword'");
            System.out.println("Example: echo '" + tmpUsername + ":" + tmpSrvname + ":" + encPasswd + "' >> ${HOME}/passwd.enc");
            System.out.println("=======================================================================================================");
            System.out.println("");
            System.exit(0);
        }
        RollingFileAppender appender = (RollingFileAppender)LoggerContext.getContext().getConfiguration().getAppenders().get("LOGFILE");
        _logger.info("Using Logfile name '" + (appender == null ? "-unknown-" : appender.getFileName()) + "'.");
        Configuration appProps = null;
        if (new File(propFile).exists()) {
            _logger.info("Using configuration file '" + propFile + "'.");
            appProps = new Configuration(propFile);
            Configuration.setInstance("SYSTEM_CONF", appProps);
        } else {
            _logger.info("The configuration file '" + propFile + "', did not exists, starting with an empty configuration.");
            appProps = new Configuration();
            Configuration.setInstance("SYSTEM_CONF", appProps);
        }
        Configuration.setSearchOrder("SYSTEM_CONF");
        AppConfig.setInstance(new AppConfig(cmd, Configuration.getInstance("SYSTEM_CONF")));
        _logger.info("Starting " + Version.getAppName() + ", version " + Version.getVersionStr() + ", build " + Version.getBuildStr());
        _logger.info("Using Java Runtime Environment Version:         " + System.getProperty("java.version"));
        _logger.info("Using Java VM Implementation  Version:          " + System.getProperty("java.vm.version"));
        _logger.info("Using Java VM Implementation  Vendor:           " + System.getProperty("java.vm.vendor"));
        _logger.info("Using Java VM Implementation  Name:             " + System.getProperty("java.vm.name"));
        _logger.info("Using Java VM Home:                             " + System.getProperty("java.home"));
        _logger.info("Java class format version number:               " + System.getProperty("java.class.version"));
        _logger.info("Java class path:                                " + System.getProperty("java.class.path"));
        _logger.info("List of paths to search when loading libraries: " + System.getProperty("java.library.path"));
        _logger.info("Name of JIT compiler to use:                    " + System.getProperty("java.compiler"));
        _logger.info("Path of extension directory or directories:     " + System.getProperty("java.ext.dirs"));
        _logger.info("Maximum memory is set to:  " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB. this could be changed with  -Xmx###m (where ### is number of MB)");
        _logger.info("Total Physical Memory on this machine:          " + Memory.getTotalPhysicalMemorySizeInMB() + " MB.");
        _logger.info("Free Physical Memory on this machine:           " + Memory.getFreePhysicalMemorySizeInMB() + " MB.");
        _logger.info("Running on Operating System Name:               " + System.getProperty("os.name"));
        _logger.info("Running on Operating System Version:            " + System.getProperty("os.version"));
        _logger.info("Running on Operating System Architecture:       " + System.getProperty("os.arch"));
        _logger.info("The application was started by the username:    " + System.getProperty("user.name"));
        _logger.info("The application was started in the directory:   " + System.getProperty("user.dir"));
        _logger.info("The user '" + System.getProperty("user.name") + "' home directory:   " + System.getProperty("user.home"));
        _logger.info("System configuration file is '" + propFile + "'.");
        _logger.info("Combined Configuration Search Order '" + StringUtil.toCommaStr(Configuration.getSearchOrder()) + "'.");
        _logger.info("Combined Configuration Search Order, With file names: " + StringUtil.toCommaStr(Configuration.getSearchOrder(true)));
        AseAuditor.startWriterQueueService();
        AseAuditor.startAseAuditCollector();
        AseAuditor.startAseSqlInfoCollector();
    }

    private static void close() {
        try {
            AseAuditor.stopAseSqlInfoCollector();
            AseAuditor.stoptAseAuditCollector();
            AseAuditor.stopWriterQueueService();
        }
        catch (Exception ex) {
            _logger.warn("Problems when closing the system down.", (Throwable)ex);
        }
    }

    public static String getAppLogDir() {
        String homeDir = System.getProperty("user.home");
        String logDir = System.getProperty("SEK_ASE_AUDITOR_HOME", homeDir + File.separator + "log");
        String val = System.getProperty("SEK_ASE_AUDITOR_LOG_DIR", logDir);
        return val;
    }

    private static void installShutdownHandler() {
        _logger.info("Installing shutdown hook, which will help us stop the system gracefully if we are killed.");
        System.setProperty("dbxtune.isShutdownHookInstalled", "true");
        ShutdownHandler.addShutdownHandler(new ShutdownHandler.Shutdownable(){

            @Override
            public List<String> systemShutdown() {
                ShutdownHandler.shutdown("shutdown-handler");
                return Arrays.asList("main");
            }
        });
    }

    private static void startWriterQueueService() throws Exception {
        WriterQueueHandler writerQueueHandler = null;
        try {
            writerQueueHandler = new WriterQueueHandler();
            writerQueueHandler.init(Configuration.getCombinedConfiguration());
            writerQueueHandler.start();
            WriterQueueHandler.setInstance(writerQueueHandler);
        }
        catch (Exception e) {
            _logger.error("Problems initializing WriterQueueHandler", (Throwable)e);
            throw new Exception("Problems initializing WriterQueueHandler", e);
        }
        if (!writerQueueHandler.hasWriters()) {
            _logger.error("No writers installed to the WriterQueueHandler, this is NO-GUI... So I do not see the need for me to start.");
            throw new Exception("No writers installed to the WriterQueueHandler, this is NO-GUI... So I do not see the need for me to start.");
        }
    }

    private static void stopWriterQueueService() throws Exception {
        if (WriterQueueHandler.hasInstance()) {
            int maxWaitTimeInMs = 10000;
            _logger.info("Stopping the Writer Queue Thread (and it's sub threads). maxWaitTimeInMs=" + maxWaitTimeInMs);
            WriterQueueHandler.getInstance().stop(true, maxWaitTimeInMs);
        }
    }

    private static void startAseAuditCollector() throws Exception {
        _sybSecurityCollector = new SybAuditCollector();
        _sybSecurityCollector.init(Configuration.getCombinedConfiguration());
        _sybSecurityCollector.start();
    }

    private static void stoptAseAuditCollector() throws Exception {
        if (_sybSecurityCollector != null) {
            _sybSecurityCollector.stop();
        }
    }

    private static void startAseSqlInfoCollector() throws Exception {
        _sybStmntCollector = new SybStmntCollector();
        _sybStmntCollector.init(Configuration.getCombinedConfiguration());
        _sybStmntCollector.start();
    }

    private static void stopAseSqlInfoCollector() throws Exception {
        if (_sybStmntCollector != null) {
            _sybStmntCollector.stop();
        }
    }

    public static void main(String[] args) {
        Version.setAppName(APP_NAME);
        Options options = AseAuditor.buildCommandLineOptions();
        try {
            CommandLine cmd = AseAuditor.parseCommandLine(args, options);
            if (cmd.hasOption("help")) {
                AseAuditor.printHelp(options, "The option '--help' was passed.");
            } else if (cmd.hasOption("version")) {
                System.out.println();
                System.out.println(Version.getAppName() + " Version: " + Version.getVersionStr() + " JVM: " + System.getProperty("java.version"));
                System.out.println();
            } else if (cmd.hasOption("install-audit")) {
                System.out.println();
                System.out.println("ERROR: 'install-audit' option is NOT YET IMPLEMENTED...");
                System.out.println();
            } else if (cmd.getArgs() != null && cmd.getArgs().length > 0) {
                String error = "Unknown options: " + Arrays.toString(cmd.getArgs());
                AseAuditor.printHelp(options, error);
            } else {
                AseAuditor.init(cmd);
                boolean doDummy = false;
                if (doDummy) {
                    int runSec = 999;
                    System.out.println(" * Sleeping for " + runSec + " sec, before leaving dummy loop");
                    Thread.sleep(runSec * 1000);
                } else {
                    ShutdownHandler.waitforShutdown();
                }
                AseAuditor.close();
                _logger.info("The server has now been STOPPED.");
            }
        }
        catch (ParseException pe) {
            String error = "Error: " + pe.getMessage();
            AseAuditor.printHelp(options, error);
            System.exit(1);
        }
        catch (NormalExitException e) {
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println();
            System.out.println("Error: " + e.getMessage());
            System.out.println();
            System.out.println("Printing a stacktrace, where the error occurred.");
            System.out.println("--------------------------------------------------------------------");
            e.printStackTrace();
            System.out.println("--------------------------------------------------------------------");
            System.exit(1);
        }
        if (ShutdownHandler.wasRestartSpecified()) {
            System.exit(8);
        }
    }

    static {
        APP_NAME = Version.PRODUCT_STRING;
    }
}

