/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.collectors;

import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.Version;
import sek.ase.auditor.collectors.SybSysProcessesCache;
import sek.ase.auditor.utils.AseUtils;
import sek.ase.auditor.utils.Configuration;
import sek.ase.auditor.utils.StringUtil;
import sek.ase.auditor.utils.TimeUtils;
import sek.ase.auditor.wqs.WriterQueueContainer;
import sek.ase.auditor.wqs.WriterQueueHandler;

public abstract class SybAbstractCollector
implements Runnable {
    private static Logger _logger = LogManager.getLogger();
    public static final String PROPKEY_skipLoginNameRegex = "SybCollector.skip.loginName.regex";
    public static final String DEFAULT_skipLoginNameRegex = null;
    public static final String PROPKEY_skipProgramNameRegex = "SybCollector.skip.programName.regex";
    public static final String DEFAULT_skipProgramNameRegex = "(AseTune.*)";
    public static final String PROPKEY_sleepTimeInSeconds = "SybCollector.sleepTime.seconds";
    public static final int DEFAULT_sleepTimeInSeconds = 1;
    public static final String PROPKEY_statisticsMessagePeriodSeconds = "SybCollector.statistics.message.period.seconds";
    public static final int DEFAULT_statisticsMessagePeriodSeconds = 300;
    public static final String PROPKEY_dbms_server = "SybCollector.dbms.server";
    public static final String DEFAULT_dbms_server = null;
    public static final String PROPKEY_dbms_username = "SybCollector.dbms.username";
    public static final String DEFAULT_dbms_username = null;
    public static final String PROPKEY_dbms_password = "SybCollector.dbms.password";
    public static final String DEFAULT_dbms_password = null;
    public static final String PROPKEY_dbms_connectFaileRetrySleepTimeMs = "SybCollector.dbms.connect.fail.retry.sleepTimeMs";
    public static final int DEFAULT_dbms_connectFaileRetrySleepTimeMs = 10000;
    public static final String PROPKEY_dbms_connectFaileRetryMaxWaitTimeInSec = "SybCollector.dbms.connect.fail.retry.maxWaitTimeInSec";
    public static final int DEFAULT_dbms_connectFaileRetryMaxWaitTimeInSec = 7200;
    public static final String PROPKEY_dbms_connectFaileRetryCount = "SybCollector.dbms.connect.fail.retry.count";
    public static final int DEFAULT_dbms_connectFaileRetryCount = 100000;
    public static final String PROPKEY_dbms_exitIfFirstConnFails = "SybCollector.dbms.exit.if.first.connect.fails";
    public static final boolean DEFAULT_dbms_exitIfFirstConnFails = true;
    private String _skipLoginNameRegex = DEFAULT_skipLoginNameRegex;
    private String _skipProgramNameRegex = "(AseTune.*)";
    private Pattern _skipLoginNamePattern = this._skipLoginNameRegex == null ? null : Pattern.compile(this._skipLoginNameRegex);
    private Pattern _skipProgramNamePattern = this._skipProgramNameRegex == null ? null : Pattern.compile(this._skipProgramNameRegex);
    private Configuration _conf;
    private Thread _thread;
    private Connection _conn;
    private boolean _isNewConnection = false;
    private String _aseServerName;
    private String _aseHostName;
    private boolean _running;
    private int _sleepTimeSec = 1;
    private ConcurrentHashMap<String, AtomicInteger> _skipLoginNameMapCounter = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicInteger> _skipProgramNameMapCounter = new ConcurrentHashMap();
    private AtomicLong _totalQueueCount = new AtomicLong();
    private AtomicLong _totalSkipCount = new AtomicLong();
    private long _lastTotalQueueCount = 0L;
    private long _lastTotalSkipCount = 0L;
    private long _statisticsMessageLastTime = System.currentTimeMillis();
    private long _statisticsMessagePeriodSec = 300L;
    private String _dbmsUrl = null;
    private String _dbmsUsername = null;
    private String _dbmsPassword = null;

    public void init(Configuration config) throws Exception {
        this._conf = config != null ? config : Configuration.getCombinedConfiguration();
        this._skipLoginNameRegex = this._conf.getProperty(PROPKEY_skipLoginNameRegex, DEFAULT_skipLoginNameRegex);
        this._skipProgramNameRegex = this._conf.getProperty(PROPKEY_skipProgramNameRegex, DEFAULT_skipProgramNameRegex);
        this._skipLoginNamePattern = StringUtil.isNullOrBlank(this._skipLoginNameRegex) ? null : Pattern.compile(this._skipLoginNameRegex);
        this._skipProgramNamePattern = StringUtil.isNullOrBlank(this._skipProgramNameRegex) ? null : Pattern.compile(this._skipProgramNameRegex);
        this.setSleepTimeSec(this.getConfig().getIntProperty(PROPKEY_sleepTimeInSeconds, 1));
        this._statisticsMessagePeriodSec = this.getConfig().getLongProperty(PROPKEY_statisticsMessagePeriodSeconds, 300L);
        this.setDbmsUrl();
        this.setDbmsUsername();
        this.setDbmsPassword();
    }

    public abstract void printConfig();

    public void printBaseConfig(int len) {
        _logger.info("   > Base Cfg for '" + this.getName() + "'");
        _logger.info("                   " + StringUtil.left(PROPKEY_skipLoginNameRegex, len) + " = " + this._skipLoginNameRegex);
        _logger.info("                   " + StringUtil.left(PROPKEY_skipProgramNameRegex, len) + " = " + this._skipProgramNameRegex);
        _logger.info("                   " + StringUtil.left(PROPKEY_statisticsMessagePeriodSeconds, len) + " = " + this._statisticsMessagePeriodSec);
        _logger.info("                   " + StringUtil.left(PROPKEY_dbms_exitIfFirstConnFails, len) + " = " + this.getConfig().getBooleanProperty(PROPKEY_dbms_exitIfFirstConnFails, true));
        _logger.info("                   " + StringUtil.left(PROPKEY_dbms_connectFaileRetrySleepTimeMs, len) + " = " + this.getConfig().getIntProperty(PROPKEY_dbms_connectFaileRetrySleepTimeMs, 10000));
        _logger.info("                   " + StringUtil.left(PROPKEY_dbms_connectFaileRetryMaxWaitTimeInSec, len) + " = " + this.getConfig().getIntProperty(PROPKEY_dbms_connectFaileRetryMaxWaitTimeInSec, 7200));
        _logger.info("                   " + StringUtil.left(PROPKEY_dbms_connectFaileRetryCount, len) + " = " + this.getConfig().getIntProperty(PROPKEY_dbms_connectFaileRetryCount, 100000));
    }

    public Configuration getConfig() {
        return this._conf;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void start() {
        this._thread = new Thread((Runnable)this, this.getName());
        this._thread.setDaemon(true);
        this._thread.start();
    }

    public void stop() {
        if (this._thread != null) {
            this.setRunning(false);
            this._thread.interrupt();
        }
    }

    public void setRunning(boolean running) {
        this._running = running;
    }

    public boolean isRunning() {
        return this._running;
    }

    public int getSleepTimeSec() {
        return this._sleepTimeSec;
    }

    public void setSleepTimeSec(int sleepTimeSec) {
        this._sleepTimeSec = sleepTimeSec;
    }

    @Override
    public void run() {
        this._running = true;
        int loopCount = 0;
        _logger.info("Starting Thread for: " + this.getName());
        while (this._running) {
            try {
                WriterQueueContainer container;
                if (loopCount > 0) {
                    Thread.sleep(this.getSleepTimeSec() * 1000);
                }
                ++loopCount;
                if (TimeUtils.secondsDiffNow(this._statisticsMessageLastTime) >= this._statisticsMessagePeriodSec) {
                    this.printStatisticsMessage();
                }
                if ((container = this.getData()) == null || container != null && container.isEmpty()) continue;
                if (!this.isRunning()) {
                    _logger.info("The service is about to stop, discarding a consume(AuditRecord) queue entry.");
                    continue;
                }
                this._totalQueueCount.getAndAdd(container.size());
                WriterQueueHandler.getInstance().add(container);
            }
            catch (InterruptedException ex) {
                _logger.info("Received 'InterruptedException' in '" + this.getName() + "', time to stop...");
                this._running = false;
            }
            catch (Throwable t) {
                _logger.error("Found some issue in '" + this.getName() + "', continuing anyway... Caught: " + t, t);
            }
        }
        _logger.info("Ending Thread for " + this.getName());
    }

    protected void printStatisticsMessage() {
        String statMsg = this.getStatisticsMessageAndReset();
        _logger.info("STATISTICS[" + this.getName() + "]: " + StringUtil.trim(statMsg));
    }

    protected String getStatisticsMessageAndReset() {
        this._statisticsMessageLastTime = System.currentTimeMillis();
        long tmpTotalQueueCount = this._totalQueueCount.get();
        long tmpTotalSkipCount = this._totalSkipCount.get();
        long diffTotalQueueCount = tmpTotalQueueCount - this._lastTotalQueueCount;
        long diffTotalSkipCount = tmpTotalSkipCount - this._lastTotalSkipCount;
        this._lastTotalQueueCount = tmpTotalQueueCount;
        this._lastTotalSkipCount = tmpTotalSkipCount;
        return "TotalQueueCount=" + tmpTotalQueueCount + " (" + diffTotalQueueCount + "), TotalSkipCount=" + tmpTotalSkipCount + " (" + diffTotalSkipCount + "), SkipLoginCounters=" + this._skipLoginNameMapCounter + ", SkipProgramNameCounters=" + this._skipProgramNameMapCounter;
    }

    protected abstract WriterQueueContainer getData() throws SQLException, InterruptedException;

    public boolean includeLoginName(String loginName) {
        if (this._skipLoginNamePattern != null) {
            boolean include = this._skipLoginNamePattern.matcher(loginName).matches();
            if (!include) {
                this._totalSkipCount.getAndIncrement();
                AtomicInteger counter = this._skipLoginNameMapCounter.get(loginName);
                if (counter == null) {
                    counter = new AtomicInteger(0);
                    this._skipLoginNameMapCounter.put(loginName, counter);
                }
                counter.getAndIncrement();
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Skipping login name '" + loginName + "', due to match in regex '" + this._skipLoginNamePattern.pattern() + "'.");
                }
            }
            return include;
        }
        return true;
    }

    public boolean includeProgramName(Connection conn, int spid, int kpid) {
        try {
            String sysProcProgramName;
            SybSysProcessesCache.SybSysProcessesEntry sysProcEntry = SybSysProcessesCache.getInstance().getRecord(conn, spid, kpid);
            if (sysProcEntry != null && (sysProcProgramName = sysProcEntry.getProgramName()) != null) {
                if (Version.getAppName().equals(sysProcProgramName)) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Skipping program name '" + Version.getAppName() + "', since this is THIS program.");
                    }
                    this.privateIncrementSkipCounterForProgName(sysProcProgramName);
                    return false;
                }
                if (this._skipProgramNamePattern != null && this._skipProgramNamePattern.matcher(sysProcProgramName).matches()) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Skipping program name '" + sysProcProgramName + "', due to match in regex '" + this._skipProgramNamePattern.pattern() + "'.");
                    }
                    this.privateIncrementSkipCounterForProgName(sysProcProgramName);
                    return false;
                }
            }
            return true;
        }
        catch (SQLException ex) {
            _logger.error("includeProgramName(spid=" + spid + ", kpid=" + kpid + "): Problems looking up information from SybSysProcessesCache. Action=The entry will be INCLUDED. " + AseUtils.sqlExceptionOrWarningAllToString(ex));
            return true;
        }
    }

    private void privateIncrementSkipCounterForProgName(String progName) {
        this._totalSkipCount.getAndIncrement();
        AtomicInteger counter = this._skipProgramNameMapCounter.get(progName);
        if (counter == null) {
            counter = new AtomicInteger(0);
            this._skipProgramNameMapCounter.put(progName, counter);
        }
        counter.getAndIncrement();
    }

    private void setClientProps(Connection conn, String clientname, String clienthostname, String clientapplname) throws SQLException {
        String sql = "";
        if (clientname != null) {
            sql = sql + "set clientname     '" + clientname + "' \n";
        }
        if (clienthostname != null) {
            sql = sql + "set clienthostname '" + clienthostname + "' \n";
        }
        if (clientapplname != null) {
            sql = sql + "set clientapplname '" + clientapplname + "' \n";
        }
        try (Statement stmnt = conn.createStatement();){
            stmnt.executeUpdate(sql);
        }
    }

    private void setDbname(Connection conn, String dbname) throws SQLException {
        _logger.info(this.getName() + ": Changing database context to '" + dbname + "'.");
        String sql = "use " + dbname;
        try (Statement stmnt = conn.createStatement();){
            stmnt.executeUpdate(sql);
        }
    }

    private void getServerInfo(Connection conn) {
        String sql = "select @@servername, asehostname()";
        try (Statement stmnt = conn.createStatement();
             ResultSet rs = stmnt.executeQuery(sql);){
            while (rs.next()) {
                this._aseServerName = rs.getString(1);
                this._aseHostName = rs.getString(2);
            }
        }
        catch (SQLException ex) {
            _logger.warn(this.getName() + ": Problems getting ASE Server information using SQL='" + sql + "'. " + AseUtils.sqlExceptionOrWarningAllToString(ex) + ". Lets try with just 'select @@servername' and getting hostname from the URL.");
            this._aseServerName = "-UNKNOWN-";
            this._aseHostName = "-UNKNOWN-";
            sql = "select @@servername";
            try (Statement stmnt2 = conn.createStatement();
                 ResultSet rs2 = stmnt2.executeQuery(sql);){
                while (rs2.next()) {
                    this._aseServerName = rs2.getString(1);
                }
                String jdbcUrl = conn.getMetaData().getURL();
                if (jdbcUrl != null && jdbcUrl.startsWith("jdbc:sybase:Tds:")) {
                    String cleanURI = "sybase://" + jdbcUrl.substring("jdbc:sybase:Tds:".length());
                    URI uri = URI.create(cleanURI);
                    this._aseHostName = uri.getHost();
                }
            }
            catch (SQLException ex2) {
                _logger.warn(this.getName() + ": Problems getting ASE Server information using SQL='" + sql + "'. " + AseUtils.sqlExceptionOrWarningAllToString(ex2) + ". Hmmm... cant even do 'select @@servername', something must be OFF here...");
            }
        }
    }

    public String getAseServerName() {
        return this._aseServerName;
    }

    public String getAseHostName() {
        return this._aseHostName;
    }

    public boolean isNewConnection() {
        return this._isNewConnection;
    }

    public Connection getConnection(String dbname) throws SQLException, InterruptedException {
        return this.private_getConnection(dbname, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean atInitTestConnection(String dbname) throws Exception {
        Connection conn = null;
        try {
            conn = this.private_getConnection(dbname, true);
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException | SQLException ex) {
            boolean exitIfFirstConnFails = this.getConfig().getBooleanProperty(PROPKEY_dbms_exitIfFirstConnFails, true);
            if (exitIfFirstConnFails) {
                throw new Exception("Not possible to Connect to the DBMS. url='" + this.getDbmsUrl() + "'. Can NOT continue... Possibly see the errorlog for more details. If you want the service and try new connections later. Enable config '" + PROPKEY_dbms_exitIfFirstConnFails + " = false'. Caught: " + ex, ex);
            }
            _logger.warn("Initial DBMS Connection-Test failed. Normally this would cause the service to NOT startup. But config 'SybCollector.dbms.exit.if.first.connect.fails = false' so, lets continue to start, hopefully any following connection attempt(s) will be successfull.");
            boolean bl = true;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private Connection private_getConnection(String dbname, boolean atInitTestConnection) throws SQLException, InterruptedException {
        this._isNewConnection = false;
        if (this._conn == null || this._conn != null && !this._conn.isValid(1)) {
            if (this._conn != null) {
                this._conn.close();
            }
            String url = this.getDbmsUrl();
            Properties connProps = new Properties();
            connProps.put("user", this.getDbmsUsername());
            connProps.put("password", this.getDbmsPassword());
            connProps.put("ENCRYPT_PASSWORD", "true");
            connProps.put("APPLICATIONNAME", Version.getAppName());
            Properties strippedConnProps = new Properties();
            for (Map.Entry<Object, Object> entry : connProps.entrySet()) {
                strippedConnProps.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
            strippedConnProps.setProperty("password", "*******");
            SQLException finalException = null;
            int loopLimit = this.getConfig().getIntProperty(PROPKEY_dbms_connectFaileRetryCount, 100000);
            int sleepTime = this.getConfig().getIntProperty(PROPKEY_dbms_connectFaileRetrySleepTimeMs, 10000);
            int maxWaitTimeInSec = this.getConfig().getIntProperty(PROPKEY_dbms_connectFaileRetryMaxWaitTimeInSec, 7200);
            ++loopLimit;
            long loopStartTime = System.currentTimeMillis();
            for (int i = 1; i < loopLimit; ++i) {
                try {
                    finalException = null;
                    Connection conn = DriverManager.getConnection(url, connProps);
                    _logger.info("Succeeded connecting to URL '" + url + "', Properties='" + strippedConnProps + "'.");
                    if (StringUtil.hasValue(dbname)) {
                        this.setDbname(conn, dbname);
                    }
                    this.setClientProps(conn, this.getName(), null, null);
                    this.getServerInfo(conn);
                    this.onConnect(conn);
                    this._conn = conn;
                    this._isNewConnection = true;
                    break;
                }
                catch (SQLException ex) {
                    finalException = ex;
                    if (atInitTestConnection) {
                        _logger.error("Problems Connection DBMS. URL='" + url + "', Properties='" + strippedConnProps + "'. Exception: " + ex);
                        throw finalException;
                    }
                    long secondsWaiting = TimeUtils.secondsDiffNow(loopStartTime);
                    _logger.error("Problems Connection DBMS, atTry=" + i + ", tryLimit=" + loopLimit + ", maxWaitTimeInSec=" + maxWaitTimeInSec + ", secondsWaiting=" + secondsWaiting + ". URL='" + url + "', Properties='" + strippedConnProps + "'. Exception: " + ex);
                    if (secondsWaiting > (long)maxWaitTimeInSec) {
                        throw new InterruptedException("Leaving Connection retry logic. Reached Connect Retry setting SybCollector.dbms.connect.fail.retry.maxWaitTimeInSec = " + maxWaitTimeInSec + ". ");
                    }
                    Thread.sleep(sleepTime);
                    continue;
                }
            }
            if (finalException != null) {
                throw finalException;
            }
        }
        return this._conn;
    }

    public void onConnect(Connection conn) throws SQLException {
    }

    public String getDbmsUrl() {
        return this._dbmsUrl;
    }

    public String getDbmsUsername() {
        return this._dbmsUsername;
    }

    public String getDbmsPassword() {
        return this._dbmsPassword;
    }

    public void setDbmsUrl() {
        String srvName = this._conf.getProperty(PROPKEY_dbms_server, DEFAULT_dbms_server);
        if (StringUtil.isNullOrBlank(srvName)) {
            throw new RuntimeException("Can't find the mandatory property 'SybCollector.dbms.server'.");
        }
        if (srvName.startsWith("jdbc:sybase:Tds:")) {
            this._dbmsUrl = srvName;
            return;
        }
        String hostPortStr = AseUtils.getHostPortFromInterfacesFile(srvName);
        if (StringUtil.isNullOrBlank(hostPortStr)) {
            this._dbmsUrl = null;
            throw new RuntimeException("Can't find the server name '" + srvName + "' in the interfaces file. If you do not have a interfaces file, you can specify the URL in property: " + PROPKEY_dbms_server + " = jdbc:sybase:Tds:HOSTNAME:PORT");
        }
        this._dbmsUrl = "jdbc:sybase:Tds:" + hostPortStr;
    }

    public void setDbmsUsername() {
        String username = this._conf.getProperty(PROPKEY_dbms_username, DEFAULT_dbms_username);
        if (StringUtil.isNullOrBlank(username)) {
            throw new RuntimeException("Can't find the mandatory property 'SybCollector.dbms.username'.");
        }
        this._dbmsUsername = username;
    }

    public void setDbmsPassword() {
        String password = this._conf.getProperty(PROPKEY_dbms_password, DEFAULT_dbms_password);
        if (StringUtil.isNullOrBlank(password)) {
            throw new RuntimeException("Can't find the mandatory property 'SybCollector.dbms.password'.");
        }
        this._dbmsPassword = password;
    }
}

