/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.collectors;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.collectors.SybAbstractCollector;
import sek.ase.auditor.collectors.SybSysProcessesCache;
import sek.ase.auditor.collectors.records.AuditRecordSybAudit;
import sek.ase.auditor.utils.AseUtils;
import sek.ase.auditor.utils.Configuration;
import sek.ase.auditor.utils.StringUtil;
import sek.ase.auditor.wqs.WriterQueueContainer;

public class SybAuditCollector
extends SybAbstractCollector {
    private static Logger _logger = LogManager.getLogger();
    private Timestamp _lastEntryTs;
    public static final String PROPKEY_sleepTimeInSeconds = "SybAuditCollector.sleepTime.seconds";
    public static final int DEFAULT_sleepTimeInSeconds = 10;
    public static final String PROPKEY_printGetData = "SybAuditCollector.print.getData";
    public static final boolean DEFAULT_printGetData = false;
    private boolean _printGetData = false;

    @Override
    public void init(Configuration config) throws Exception {
        super.init(config);
        this._printGetData = this.getConfig().getBooleanProperty(PROPKEY_printGetData, false);
        this.setSleepTimeSec(this.getConfig().getIntProperty(PROPKEY_sleepTimeInSeconds, 10));
        this.atInitTestConnection("sybsecurity");
        this.printConfig();
    }

    @Override
    public void printConfig() {
        int len = 60;
        _logger.info("Configuration for '" + this.getName() + "', with full class name '" + this.getClass().getName() + "'.");
        _logger.info("                   " + StringUtil.left(PROPKEY_sleepTimeInSeconds, len) + " = " + this.getSleepTimeSec());
        _logger.info("                   " + StringUtil.left(PROPKEY_printGetData, len) + " = " + this._printGetData);
        this.printBaseConfig(len);
    }

    @Override
    protected WriterQueueContainer getData() throws SQLException, InterruptedException {
        if (this._printGetData) {
            _logger.info("------------------------------------ " + this.getName() + "::getData()");
        }
        _logger.debug("------------------------------------ " + this.getName() + "::getData()");
        Connection conn = this.getConnection("sybsecurity");
        WriterQueueContainer.HeaderInfo headerInfo = new WriterQueueContainer.HeaderInfo(new Timestamp(System.currentTimeMillis()), this.getAseServerName(), this.getAseHostName());
        WriterQueueContainer container = new WriterQueueContainer(headerInfo);
        ArrayList<AuditRecordSybAudit> list = new ArrayList<AuditRecordSybAudit>(1000);
        if (this._lastEntryTs == null) {
            this._lastEntryTs = new Timestamp(0L);
        }
        String sql = "{?=call audit_collector()}";
        try {
            int returnStatus;
            SQLWarning sqlw = null;
            CallableStatement stmnt = conn.prepareCall(sql);
            ResultSet rs = null;
            int rowsAffected = 0;
            stmnt.setQueryTimeout(60);
            if (_logger.isDebugEnabled()) {
                _logger.debug("EXECUTING: " + sql);
            }
            boolean hasRs = false;
            if (stmnt instanceof CallableStatement) {
                stmnt.registerOutParameter(1, 4);
                hasRs = stmnt.execute();
            } else {
                hasRs = stmnt.execute(sql);
            }
            do {
                if (hasRs) {
                    rs = stmnt.getResultSet();
                    this.readResultSet(list, rs, sql);
                    for (sqlw = rs.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                        _logger.info("SQL Warning: " + AseUtils.sqlExceptionOrWarningSingleToString(sqlw));
                    }
                    rs.clearWarnings();
                    rs.close();
                } else {
                    rowsAffected = stmnt.getUpdateCount();
                    if (rowsAffected >= 0) {
                        // empty if block
                    }
                }
                hasRs = stmnt.getMoreResults();
                _logger.trace("--hasRs=" + hasRs + ", rowsAffected=" + rowsAffected);
            } while (hasRs || rowsAffected != -1);
            if (stmnt instanceof CallableStatement && (returnStatus = stmnt.getInt(1)) != 0) {
                _logger.info("Unexpected Return Code of " + returnStatus + " from the SQL '" + sql + "'.");
            }
            for (sqlw = stmnt.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                _logger.info("SQL Warning: " + AseUtils.sqlExceptionOrWarningSingleToString(sqlw));
            }
            stmnt.clearWarnings();
            stmnt.close();
        }
        catch (SQLWarning w) {
            _logger.warn("Problems when executing sql: " + sql, (Throwable)w);
        }
        catch (SQLException ex) {
            throw ex;
        }
        for (AuditRecordSybAudit auditRecord : list) {
            if (!this.includeProgramName(conn, auditRecord.getSybAuditEntry().getSpid(), -1)) continue;
            auditRecord.getSybAuditEntry().normalizeExtraInfo();
            SybSysProcessesCache.SybSysProcessesEntry sysProcEntry = SybSysProcessesCache.getInstance().getRecord(conn, auditRecord.getSybAuditEntry().getSpid(), -1);
            auditRecord.setSybSysProcessesEntry(sysProcEntry);
            container.add(auditRecord);
        }
        return container;
    }

    private int readResultSet(List<AuditRecordSybAudit> list, ResultSet rs, String sql) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int expectedColCount = 16;
        int actualColCount = rsmd.getColumnCount();
        if (actualColCount != expectedColCount) {
            _logger.error("Unexpected Column Count of " + actualColCount + ", I was expecting " + expectedColCount + " columns in the ResultSet for SQL=|" + sql + "|.");
            while (rs.next()) {
            }
            rs.close();
            return 0;
        }
        AuditRecordSybAudit lastAuditRecord = null;
        int rowsRead = 0;
        while (rs.next()) {
            ++rowsRead;
            String event_name = rs.getString(1);
            int event = rs.getInt(2);
            int eventmod = rs.getInt(3);
            int spid = rs.getInt(4);
            Timestamp eventtime = rs.getTimestamp(5);
            int sequence = rs.getInt(6);
            int suid = rs.getInt(7);
            int dbid = rs.getInt(8);
            int objid = rs.getInt(9);
            String xactid = StringUtil.bytesToHex("0x", rs.getBytes(10), true);
            String loginname = rs.getString(11);
            String dbname = rs.getString(12);
            String objname = rs.getString(13);
            String objowner = rs.getString(14);
            String extrainfo = rs.getString(15);
            int nodeid = rs.getInt(16);
            if (eventtime != null && eventtime.getTime() > this._lastEntryTs.getTime()) {
                this._lastEntryTs = eventtime;
            }
            if (!this.includeLoginName(loginname)) continue;
            if (sequence <= 1) {
                AuditRecordSybAudit auditRecord = new AuditRecordSybAudit();
                auditRecord.setSybAuditEntry(event_name, event, eventmod, spid, eventtime, sequence, suid, dbid, objid, xactid, loginname, dbname, objname, objowner, extrainfo, nodeid);
                list.add(auditRecord);
                lastAuditRecord = auditRecord;
                continue;
            }
            if (lastAuditRecord == null) continue;
            lastAuditRecord.getSybAuditEntry().addExtraInfo(extrainfo, sequence);
        }
        return rowsRead;
    }
}

