/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.collectors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.collectors.SybAbstractCollector;
import sek.ase.auditor.collectors.SybSysProcessesCache;
import sek.ase.auditor.collectors.records.AuditRecordSybStmnt;
import sek.ase.auditor.utils.AseUtils;
import sek.ase.auditor.utils.Configuration;
import sek.ase.auditor.utils.StringUtil;
import sek.ase.auditor.utils.TimeUtils;
import sek.ase.auditor.wqs.WriterQueueContainer;

public class SybStmntCollector
extends SybAbstractCollector {
    private static Logger _logger = LogManager.getLogger();
    public static final String PROPKEY_skipSqlTextRegex = "SybStmntCollector.skip.sqlText.regex";
    public static final String DEFAULT_skipSqlTextRegex = null;
    public static final String PROPKEY_keepSqlTextRegex = "SybStmntCollector.keep.sqlText.regex";
    public static final String DEFAULT_keepSqlTextRegex = null;
    public static final String PROPKEY_sleepTimeInSeconds = "SybStmntCollector.sleepTime.seconds";
    public static final int DEFAULT_sleepTimeInSeconds = 1;
    public static final String PROPKEY_clearMonTablesOnConnect = "SybStmntCollector.clearMonTablesOnConnect";
    public static final boolean DEFAULT_clearMonTablesOnConnect = false;
    public static final String PROPKEY_printGetData = "SybStmntCollector.print.getData";
    public static final boolean DEFAULT_printGetData = false;
    public static final String PROPKEY_sampleStatementDetatils = "SybStmntCollector.sample.statement.details";
    public static final boolean DEFAULT_sampleStatementDetatils = true;
    public static final String PROPKEY_sampleStatementProcName = "SybStmntCollector.sample.statement.procName";
    public static final boolean DEFAULT_sampleStatementProcName = false;
    public static final String PROPKEY_statistics_printSpidSqlTextManagerInfo = "SybStmntCollector.statistics.printSpidSqlTextManagerInfo";
    public static final boolean DEFAULT_statistics_printSpidSqlTextManagerInfo = false;
    private boolean _sampleStatementDetails = true;
    private boolean _clearMonTablesOnConnect = false;
    private boolean _printGetData = false;
    private String _skipSqlTextRegex = DEFAULT_skipSqlTextRegex;
    private String _keepSqlTextRegex = DEFAULT_keepSqlTextRegex;
    private Pattern _skipSqlTextPattern = this._skipSqlTextRegex == null ? null : Pattern.compile(this._skipSqlTextRegex);
    private Pattern _keepSqlTextPattern = this._keepSqlTextRegex == null ? null : Pattern.compile(this._keepSqlTextRegex);
    private long _totalSqlTextSkipCount = 0L;
    private long _lastSqlTextSkipCount = 0L;
    public static final String CFGNAME_aseConfig_enable_monitoring = "enable monitoring";
    public static final String PROPKEY_aseConfig_enable_monitoring = "SybStmntCollector.ase.config.enable_monitoring";
    public static final int DEFAULT_aseConfig_enable_monitoring = 1;
    public static final String CFGNAME_aseConfig_sql_text_pipe_active = "sql text pipe active";
    public static final String PROPKEY_aseConfig_sql_text_pipe_active = "SybStmntCollector.ase.config.sql_text_pipe_active";
    public static final int DEFAULT_aseConfig_sql_text_pipe_active = 1;
    public static final String CFGNAME_aseConfig_sql_text_pipe_max_messages = "sql text pipe max messages";
    public static final String PROPKEY_aseConfig_sql_text_pipe_max_messages = "SybStmntCollector.ase.config.sql_text_pipe_max_messages";
    public static final int DEFAULT_aseConfig_sql_text_pipe_max_messages = 1000;
    public static final String CFGNAME_aseConfig_statement_pipe_active = "statement pipe active";
    public static final String PROPKEY_aseConfig_statement_pipe_active = "SybStmntCollector.ase.config.statement_pipe_active";
    public static final int DEFAULT_aseConfig_statement_pipe_active = 1;
    public static final String CFGNAME_aseConfig_statement_pipe_max_messages = "statement pipe max messages";
    public static final String PROPKEY_aseConfig_statement_pipe_max_messages = "SybStmntCollector.ase.config.statement_pipe_max_messages";
    public static final int DEFAULT_aseConfig_statement_pipe_max_messages = 10000;
    public static final String CFGNAME_aseConfig_statement_statistics_active = "statement statistics active";
    public static final String PROPKEY_aseConfig_statement_statistics_active = "SybStmntCollector.ase.config.statement_statistics_active";
    public static final int DEFAULT_aseConfig_statement_statistics_active = 1;
    public static final String CFGNAME_aseConfig_per_object_statistics_active = "per object statistics active";
    public static final String PROPKEY_aseConfig_per_object_statistics_active = "SybStmntCollector.ase.config.per_object_statistics_active";
    public static final int DEFAULT_aseConfig_per_object_statistics_active = 1;
    private SpidSqlTextManager _instanceSpidSqlTextManager = new SpidSqlTextManager();
    private MdaCheckMarker _mdaCheckMarker;

    @Override
    public void init(Configuration config) throws Exception {
        super.init(config);
        this._sampleStatementDetails = this.getConfig().getBooleanProperty(PROPKEY_sampleStatementDetatils, true);
        this._skipSqlTextRegex = config.getProperty(PROPKEY_skipSqlTextRegex, DEFAULT_skipSqlTextRegex);
        this._keepSqlTextRegex = config.getProperty(PROPKEY_keepSqlTextRegex, DEFAULT_keepSqlTextRegex);
        this._clearMonTablesOnConnect = this.getConfig().getBooleanProperty(PROPKEY_clearMonTablesOnConnect, false);
        this._printGetData = this.getConfig().getBooleanProperty(PROPKEY_printGetData, false);
        this.setSleepTimeSec(this.getConfig().getIntProperty(PROPKEY_sleepTimeInSeconds, 1));
        this._skipSqlTextPattern = this._skipSqlTextRegex == null ? null : Pattern.compile(this._skipSqlTextRegex);
        this._keepSqlTextPattern = this._keepSqlTextRegex == null ? null : Pattern.compile(this._keepSqlTextRegex);
        this.atInitTestConnection("master");
        this.printConfig();
    }

    @Override
    public void printConfig() {
        int len = 60;
        _logger.info("Configuration for '" + this.getName() + "', with full class name '" + this.getClass().getName() + "'.");
        _logger.info("                   " + StringUtil.left(PROPKEY_sampleStatementDetatils, len) + " = " + this._sampleStatementDetails);
        _logger.info("                   " + StringUtil.left(PROPKEY_skipSqlTextRegex, len) + " = " + this._skipSqlTextRegex);
        _logger.info("                   " + StringUtil.left(PROPKEY_keepSqlTextRegex, len) + " = " + this._keepSqlTextRegex);
        _logger.info("                   " + StringUtil.left(PROPKEY_sleepTimeInSeconds, len) + " = " + this.getSleepTimeSec());
        _logger.info("                   " + StringUtil.left(PROPKEY_clearMonTablesOnConnect, len) + " = " + this._clearMonTablesOnConnect);
        _logger.info("                   " + StringUtil.left(PROPKEY_printGetData, len) + " = " + this._printGetData);
        this.printBaseConfig(len);
    }

    @Override
    public void onConnect(Connection conn) throws SQLException {
        this.checkAseMonitoringConfig(conn);
    }

    private void checkAseMonitoringConfig(Connection conn) throws SQLException {
        int cfg_enableMonitoring = this.getConfig().getIntProperty(PROPKEY_aseConfig_enable_monitoring, 1);
        int cfg_sqlTextPipeActive = this.getConfig().getIntProperty(PROPKEY_aseConfig_sql_text_pipe_active, 1);
        int cfg_sqlTextPipeMaxMessages = this.getConfig().getIntProperty(PROPKEY_aseConfig_sql_text_pipe_max_messages, 1000);
        int cfg_statementPipeActive = this.getConfig().getIntProperty(PROPKEY_aseConfig_statement_pipe_active, 1);
        int cfg_statementPipeMaxMessages = this.getConfig().getIntProperty(PROPKEY_aseConfig_statement_pipe_max_messages, 10000);
        int cfg_statementStatisticsActive = this.getConfig().getIntProperty(PROPKEY_aseConfig_statement_statistics_active, 1);
        int cfg_perObjectStatisticsActive = this.getConfig().getIntProperty(PROPKEY_aseConfig_per_object_statistics_active, 1);
        int ase_enableMonitoring = AseUtils.getAseConfigRunValue(conn, CFGNAME_aseConfig_enable_monitoring);
        int ase_sqlTextPipeActive = AseUtils.getAseConfigRunValue(conn, CFGNAME_aseConfig_sql_text_pipe_active);
        int ase_sqlTextPipeMaxMessages = AseUtils.getAseConfigRunValue(conn, CFGNAME_aseConfig_sql_text_pipe_max_messages);
        int ase_statementPipeActive = AseUtils.getAseConfigRunValue(conn, CFGNAME_aseConfig_statement_pipe_active);
        int ase_statementPipeMaxMessages = AseUtils.getAseConfigRunValue(conn, CFGNAME_aseConfig_statement_pipe_max_messages);
        int ase_statementStatisticsActive = AseUtils.getAseConfigRunValue(conn, CFGNAME_aseConfig_statement_statistics_active);
        int ase_perObjectStatisticsActive = AseUtils.getAseConfigRunValue(conn, CFGNAME_aseConfig_per_object_statistics_active);
        ArrayList<String> doReconfigure = new ArrayList<String>();
        if (ase_enableMonitoring < cfg_enableMonitoring) {
            doReconfigure.add(CFGNAME_aseConfig_enable_monitoring);
            _logger.warn("The ASE Configuration 'enable monitoring' is lower (currently=" + ase_enableMonitoring + ") than the suggested value '" + cfg_enableMonitoring + "'. Please Execeute: sp_configure '" + CFGNAME_aseConfig_sql_text_pipe_active + "', " + cfg_enableMonitoring);
        }
        if (ase_sqlTextPipeActive < cfg_sqlTextPipeActive) {
            doReconfigure.add(CFGNAME_aseConfig_sql_text_pipe_active);
            _logger.warn("The ASE Configuration 'sql text pipe active' is lower (currently=" + ase_sqlTextPipeActive + ") than the suggested value '" + cfg_sqlTextPipeActive + "'. Please Execeute: sp_configure '" + CFGNAME_aseConfig_sql_text_pipe_active + "', " + cfg_sqlTextPipeActive);
        }
        if (ase_sqlTextPipeMaxMessages < cfg_sqlTextPipeMaxMessages) {
            doReconfigure.add(CFGNAME_aseConfig_sql_text_pipe_max_messages);
            _logger.warn("The ASE Configuration 'sql text pipe max messages' is lower (currently=" + ase_sqlTextPipeMaxMessages + ") than the suggested value '" + cfg_sqlTextPipeMaxMessages + "'. Please Execeute: sp_configure '" + CFGNAME_aseConfig_sql_text_pipe_max_messages + "', " + cfg_sqlTextPipeMaxMessages);
        }
        if (ase_statementPipeActive < cfg_statementPipeActive) {
            doReconfigure.add(CFGNAME_aseConfig_statement_pipe_active);
            _logger.warn("The ASE Configuration 'statement pipe active' is lower (currently=" + ase_statementPipeActive + ") than the suggested value '" + cfg_statementPipeActive + "'. Please Execeute: sp_configure '" + CFGNAME_aseConfig_statement_pipe_active + "', " + cfg_statementPipeActive);
        }
        if (ase_statementPipeMaxMessages < cfg_statementPipeMaxMessages) {
            doReconfigure.add(CFGNAME_aseConfig_statement_pipe_max_messages);
            _logger.warn("The ASE Configuration 'statement pipe max messages' is lower (currently=" + ase_statementPipeMaxMessages + ") than the suggested value '" + cfg_statementPipeMaxMessages + "'. Please Execeute: sp_configure '" + CFGNAME_aseConfig_statement_pipe_max_messages + "', " + cfg_statementPipeMaxMessages);
        }
        if (ase_statementStatisticsActive < cfg_statementStatisticsActive) {
            _logger.warn("The ASE Configuration 'statement statistics active' is lower (currently=" + ase_statementStatisticsActive + ") than the NOT mandatory and suggested value '" + cfg_statementStatisticsActive + "'. Consider Execeute: sp_configure '" + CFGNAME_aseConfig_statement_statistics_active + "', " + cfg_statementStatisticsActive);
        }
        if (ase_perObjectStatisticsActive < cfg_perObjectStatisticsActive) {
            _logger.warn("The ASE Configuration 'per object statistics active' is lower (currently=" + ase_perObjectStatisticsActive + ") than the NOT mandatory and suggested value '" + cfg_perObjectStatisticsActive + "'. Consider Execeute: sp_configure '" + CFGNAME_aseConfig_per_object_statistics_active + "', " + cfg_perObjectStatisticsActive);
        }
        _logger.info("ASE Configuration " + StringUtil.left(CFGNAME_aseConfig_enable_monitoring, 30, "'") + " RunValue is set to: " + StringUtil.left(ase_enableMonitoring + "", 7) + " Smallest Recommended value: " + cfg_enableMonitoring);
        _logger.info("ASE Configuration " + StringUtil.left(CFGNAME_aseConfig_sql_text_pipe_active, 30, "'") + " RunValue is set to: " + StringUtil.left(ase_sqlTextPipeActive + "", 7) + " Smallest Recommended value: " + cfg_sqlTextPipeActive);
        _logger.info("ASE Configuration " + StringUtil.left(CFGNAME_aseConfig_sql_text_pipe_max_messages, 30, "'") + " RunValue is set to: " + StringUtil.left(ase_sqlTextPipeMaxMessages + "", 7) + " Smallest Recommended value: " + cfg_sqlTextPipeMaxMessages);
        _logger.info("ASE Configuration " + StringUtil.left(CFGNAME_aseConfig_statement_pipe_active, 30, "'") + " RunValue is set to: " + StringUtil.left(ase_statementPipeActive + "", 7) + " Smallest Recommended value: " + cfg_statementPipeActive);
        _logger.info("ASE Configuration " + StringUtil.left(CFGNAME_aseConfig_statement_pipe_max_messages, 30, "'") + " RunValue is set to: " + StringUtil.left(ase_statementPipeMaxMessages + "", 7) + " Smallest Recommended value: " + cfg_statementPipeMaxMessages);
        _logger.info("ASE Configuration " + StringUtil.left(CFGNAME_aseConfig_statement_statistics_active, 30, "'") + " RunValue is set to: " + StringUtil.left(ase_statementStatisticsActive + "", 7) + " Non-Mandatory Recommended value: " + cfg_statementStatisticsActive);
        _logger.info("ASE Configuration " + StringUtil.left(CFGNAME_aseConfig_per_object_statistics_active, 30, "'") + " RunValue is set to: " + StringUtil.left(ase_perObjectStatisticsActive + "", 7) + " Non-Mandatory Recommended value: " + cfg_perObjectStatisticsActive);
        if (!doReconfigure.isEmpty()) {
            throw new SQLException("ASE Configuration " + StringUtil.toCommaStrQuoted("'", doReconfigure) + " needs to be increased.");
        }
    }

    @Override
    protected WriterQueueContainer getData() throws SQLException, InterruptedException {
        Object batchEntry2;
        if (this._printGetData) {
            _logger.info("------------------------------------ " + this.getName() + "::getData()");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("------------------------------------ " + this.getName() + "::getData()");
        }
        Connection conn = this.getConnection("master");
        WriterQueueContainer.HeaderInfo headerInfo = new WriterQueueContainer.HeaderInfo(new Timestamp(System.currentTimeMillis()), this.getAseServerName(), this.getAseHostName());
        WriterQueueContainer container = new WriterQueueContainer(headerInfo);
        if (this._clearMonTablesOnConnect && this.isNewConnection()) {
            this.clearTable(conn, "monSysSQLText");
            this.clearTable(conn, "monSysStatement");
        }
        SpidSqlTextManager localSpidSqlTextManager = null;
        if (!this._sampleStatementDetails) {
            localSpidSqlTextManager = new SpidSqlTextManager();
        }
        String sql = "select \n     SPID \n    ,KPID \n    ,ServerLogin = suser_name(ServerUserID) \n    ,BatchID \n    ,SequenceInBatch \n    ,SQLText \nfrom master.dbo.monSysSQLText \n";
        boolean sqlMarkerWasFound = false;
        int sqlTextRowCount = 0;
        try (Statement stmnt = conn.createStatement();){
            stmnt.setQueryTimeout(1);
            try (ResultSet rs = stmnt.executeQuery(sql);){
                while (rs.next()) {
                    ++sqlTextRowCount;
                    int SPID = rs.getInt(1);
                    int KPID = rs.getInt(2);
                    String ServerLogin = rs.getString(3);
                    int BatchID = rs.getInt(4);
                    int SequenceInBatch = rs.getInt(5);
                    String SQLText = rs.getString(6);
                    if (this._mdaCheckMarker != null && this._mdaCheckMarker._sqlMarker != null && this._mdaCheckMarker._sqlMarker.equals(SQLText)) {
                        sqlMarkerWasFound = true;
                        this._mdaCheckMarker._spid = SPID;
                        this._mdaCheckMarker._kpid = KPID;
                        this._mdaCheckMarker._batchId = BatchID;
                    }
                    if (!this.includeLoginName(ServerLogin)) continue;
                    if (!this._sampleStatementDetails) {
                        localSpidSqlTextManager.addSqlText(SPID, KPID, BatchID, SequenceInBatch, SQLText, ServerLogin);
                        continue;
                    }
                    this._instanceSpidSqlTextManager.addSqlText(SPID, KPID, BatchID, SequenceInBatch, SQLText, ServerLogin);
                }
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("SQL Marker Info[monSysSQLText]: sqlMarkerWasFound=" + sqlMarkerWasFound + ", _mdaCheckMarker=" + this._mdaCheckMarker);
        }
        if (this._mdaCheckMarker != null && !sqlMarkerWasFound) {
            _logger.warn("When checking for 'SQL Marker[monSysSQLText]' previously sent... it wasn't found in 'monSysSQLText'. Searched for SQL Marker Text '" + this._mdaCheckMarker._sqlMarker + "'. Consider to increase ASE Configuration '" + CFGNAME_aseConfig_sql_text_pipe_max_messages + "'.");
            this._mdaCheckMarker = null;
        }
        if (!this._sampleStatementDetails) {
            this.sendSqlMarker(conn);
            for (SpidEntry spidEntry : localSpidSqlTextManager._spidMap.values()) {
                for (Object batchEntry2 : spidEntry._batchIdMap.values()) {
                    String sqlText;
                    if (!this.includeProgramName(conn, ((BatchIdEntry)batchEntry2)._spid, ((BatchIdEntry)batchEntry2)._kpid) || !this.includeSqlText(conn, sqlText = ((BatchIdEntry)batchEntry2).getSqlText())) continue;
                    AuditRecordSybStmnt auditRecord = new AuditRecordSybStmnt();
                    auditRecord.setSqlTextEntry(((BatchIdEntry)batchEntry2)._spid, ((BatchIdEntry)batchEntry2)._kpid, ((BatchIdEntry)batchEntry2)._batchId, ((BatchIdEntry)batchEntry2).getServerLogin(), sqlText, null);
                    auditRecord.setSybSysProcessesEntry(SybSysProcessesCache.getInstance().getRecord(conn, ((BatchIdEntry)batchEntry2)._spid, ((BatchIdEntry)batchEntry2)._kpid));
                    container.add(auditRecord);
                }
            }
            return container;
        }
        sql = AuditRecordSybStmnt.MonSqlStatementEntry.getSql();
        boolean statementMarkerWasFound = false;
        int statementRowCount = 0;
        Statement stmnt = conn.createStatement();
        batchEntry2 = null;
        try {
            stmnt.setQueryTimeout(1);
            try (ResultSet rs = stmnt.executeQuery(sql);){
                while (rs.next()) {
                    ++statementRowCount;
                    AuditRecordSybStmnt.MonSqlStatementEntry row = new AuditRecordSybStmnt.MonSqlStatementEntry(rs);
                    if (this._mdaCheckMarker != null && this._mdaCheckMarker._sqlMarker != null && this._mdaCheckMarker._spid == row.SPID && this._mdaCheckMarker._kpid == row.KPID && this._mdaCheckMarker._batchId == row.BatchID) {
                        statementMarkerWasFound = true;
                    }
                    this._instanceSpidSqlTextManager.addStatementRecord(row.SPID, row.KPID, row.BatchID, row);
                }
            }
        }
        catch (Throwable throwable) {
            batchEntry2 = throwable;
            throw throwable;
        }
        finally {
            if (stmnt != null) {
                if (batchEntry2 != null) {
                    try {
                        stmnt.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)batchEntry2).addSuppressed(throwable);
                    }
                } else {
                    stmnt.close();
                }
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("SQL Marker Info[monSysStatement]: statementMarkerWasFound=" + statementMarkerWasFound + ", _mdaCheckMarker=" + this._mdaCheckMarker);
        }
        if (this._mdaCheckMarker != null && !statementMarkerWasFound) {
            _logger.warn("When checking for 'SQL Marker[monSysStatement]' previously sent... it wasn't found in 'monSysStatement'. Searched for SQL Marker [SPID, KPID, BatchID] '" + this._mdaCheckMarker + "'. Consider to increase ASE Configuration '" + CFGNAME_aseConfig_statement_pipe_max_messages + "'.");
        }
        this.sendSqlMarker(conn);
        for (SpidEntry spidEntry : this._instanceSpidSqlTextManager._spidMap.values()) {
            for (BatchIdEntry batchEntry3 : spidEntry._batchIdMap.values()) {
                if (!this.includeProgramName(conn, batchEntry3._spid, batchEntry3._kpid)) {
                    batchEntry3.doMarkForRemoval();
                    continue;
                }
                String sqlText = batchEntry3.getSqlText();
                if (!this.includeSqlText(conn, sqlText)) {
                    batchEntry3.doMarkForRemoval();
                    continue;
                }
                boolean doSend = false;
                if (batchEntry3._batchId < spidEntry._maxBatchId) {
                    doSend = true;
                }
                if (!doSend && batchEntry3.isOkToSend()) {
                    doSend = true;
                }
                if (!SybSysProcessesCache.getInstance().exists(conn, batchEntry3._spid, batchEntry3._kpid)) {
                    doSend = true;
                }
                if (!doSend) continue;
                AuditRecordSybStmnt auditRecord = new AuditRecordSybStmnt();
                auditRecord.setSqlTextEntry(batchEntry3._spid, batchEntry3._kpid, batchEntry3._batchId, batchEntry3.getServerLogin(), sqlText, batchEntry3.getStatementRecords());
                auditRecord.setSybSysProcessesEntry(SybSysProcessesCache.getInstance().getRecord(conn, batchEntry3._spid, batchEntry3._kpid));
                container.add(auditRecord);
                batchEntry3.doMarkForRemoval();
            }
        }
        this._instanceSpidSqlTextManager.processMarkedForRemoval();
        return container;
    }

    private void sendSqlMarker(Connection conn) {
        boolean isEnabled = true;
        if (!isEnabled) {
            return;
        }
        String sqlMarker = "/*SQL-Marker:monSysSQLText: " + new Timestamp(System.currentTimeMillis()) + "*/ declare @dummy int";
        try (Statement stmnt = conn.createStatement();){
            stmnt.executeUpdate(sqlMarker);
            if (this._mdaCheckMarker == null) {
                this._mdaCheckMarker = new MdaCheckMarker();
            }
            this._mdaCheckMarker._sqlMarker = sqlMarker;
        }
        catch (SQLException ex) {
            _logger.warn("Problems executing 'MDA Check Marker' using SQL '" + sqlMarker + "'. Caught: " + AseUtils.sqlExceptionOrWarningAllToString(ex));
            this._mdaCheckMarker = null;
        }
    }

    private boolean includeSqlText(Connection conn, String sqlText) {
        if (this._skipSqlTextPattern != null && this._skipSqlTextPattern.matcher(sqlText).matches()) {
            ++this._totalSqlTextSkipCount;
            return false;
        }
        if (this._keepSqlTextPattern != null && !this._keepSqlTextPattern.matcher(sqlText).matches()) {
            ++this._totalSqlTextSkipCount;
            return false;
        }
        return true;
    }

    private void clearTable(Connection conn, String tabName) {
        String sql = "select count(*) from master.dbo." + tabName;
        _logger.info("BEGIN: Discarding everything in the transient '" + tabName + "' table in the first sample.");
        long startTime = System.currentTimeMillis();
        try (Statement stmnt = conn.createStatement();
             ResultSet rs = stmnt.executeQuery(sql);){
            int discardCount = 0;
            while (rs.next()) {
                discardCount = rs.getInt(1);
            }
            _logger.info("END:   Discarding everything in the transient '" + tabName + "' table in the first sample. discardCount=" + discardCount + ", this took " + TimeUtils.msToTimeStr(System.currentTimeMillis() - startTime) + ".");
        }
        catch (SQLException ex) {
            _logger.error("END:   Discarding everything in the transient '" + tabName + "' table in the first sample FAILED. Caught: Error=" + ex.getErrorCode() + ", Msg='" + ex.getMessage().trim() + "'");
        }
    }

    @Override
    protected String getStatisticsMessageAndReset() {
        boolean printSpidSqlTextManagerInfo = this.getConfig().getBooleanProperty(PROPKEY_statistics_printSpidSqlTextManagerInfo, false);
        if (printSpidSqlTextManagerInfo && this._instanceSpidSqlTextManager != null) {
            _logger.info("STATISTICS[" + this.getName() + "]: DEBUG: printSpidSqlTextManagerInfo: " + this._instanceSpidSqlTextManager.toString());
        }
        long tmpTotalSqlTextSkipCount = this._totalSqlTextSkipCount;
        long diffTotalSqlTextSkipCount = tmpTotalSqlTextSkipCount - this._lastSqlTextSkipCount;
        this._lastSqlTextSkipCount = tmpTotalSqlTextSkipCount;
        String superMsg = super.getStatisticsMessageAndReset();
        String thisMsg = ", TotalSqlTextSkipCount=" + tmpTotalSqlTextSkipCount + " (" + diffTotalSqlTextSkipCount + ")";
        return superMsg + thisMsg;
    }

    private static class BatchIdEntry {
        private SpidEntry _parent;
        private int _spid;
        private int _kpid;
        private int _batchId;
        private boolean _markedForRemoval = false;
        private boolean _isOkToSend = false;
        private String _dynamicSqlName;
        private String _dynamicSqlText;
        private boolean _isDynamicSqlPrepare = false;
        private StringBuilder _sqlText = new StringBuilder();
        private String _srvLogin = "";
        private List<AuditRecordSybStmnt.MonSqlStatementEntry> _mdaStatements;

        public BatchIdEntry(SpidEntry spidEntry, int spid, int kpid, int batchId) {
            this._parent = spidEntry;
            this._spid = spid;
            this._kpid = kpid;
            this._batchId = batchId;
        }

        public boolean isOkToSend() {
            return this._isOkToSend;
        }

        public void doMarkForRemoval() {
            this._markedForRemoval = true;
        }

        public boolean isMarkedForRemoval() {
            return this._markedForRemoval;
        }

        public void addStatementRecord(AuditRecordSybStmnt.MonSqlStatementEntry mdaStatement) {
            if (this._mdaStatements == null) {
                this._mdaStatements = new ArrayList<AuditRecordSybStmnt.MonSqlStatementEntry>();
            }
            this._mdaStatements.add(mdaStatement);
            if (mdaStatement.SsqlId != 0) {
                this._isOkToSend = true;
            }
            if (mdaStatement.StatementNumber == 0) {
                this._isOkToSend = true;
            }
        }

        public List<AuditRecordSybStmnt.MonSqlStatementEntry> getStatementRecords() {
            return this._mdaStatements;
        }

        public boolean isDynamicSql() {
            return this._dynamicSqlName != null;
        }

        public void addSqlText(int sequenceNum, String sqlText, String serverLogin) {
            if (sqlText == null) {
                return;
            }
            if (sqlText.startsWith("DYNAMIC_SQL ")) {
                this._dynamicSqlName = sqlText;
            }
            if (this._dynamicSqlName != null && StringUtils.startsWithIgnoreCase((CharSequence)sqlText, (CharSequence)"create proc ")) {
                this._isDynamicSqlPrepare = true;
                int startPos = StringUtils.indexOfIgnoreCase((CharSequence)sqlText, (CharSequence)" as ");
                if (startPos != -1) {
                    this._dynamicSqlText = sqlText.substring(startPos += " as ".length());
                }
            }
            if (this._isDynamicSqlPrepare && sequenceNum > 1) {
                this._dynamicSqlText = this._dynamicSqlText == null ? sqlText : this._dynamicSqlText + sqlText;
            }
            this._sqlText.append(sqlText);
            this._srvLogin = serverLogin;
        }

        public String getSqlText() {
            if (this._dynamicSqlName != null && !this._isDynamicSqlPrepare) {
                for (BatchIdEntry be : this._parent._batchIdMap.values()) {
                    if (!be._isDynamicSqlPrepare || !this._dynamicSqlName.equals(be._dynamicSqlName)) continue;
                    if (be._dynamicSqlText != null) {
                        return "/* DYNAMIC-SQL: */ " + be._dynamicSqlText;
                    }
                    return "/* DYNAMIC-SQL: */ " + be._sqlText.toString();
                }
            }
            return this._sqlText.toString();
        }

        public String getServerLogin() {
            return this._srvLogin;
        }
    }

    private static class SpidEntry {
        private int _spid;
        private int _kpid;
        private int _maxBatchId;
        private HashMap<Integer, BatchIdEntry> _batchIdMap = new HashMap();

        public SpidEntry(int spid, int kpid) {
            this._spid = spid;
            this._kpid = kpid;
        }

        public BatchIdEntry getBatchIdEntryLazy(int spid, int kpid, int batchId) {
            if (kpid != this._kpid) {
                return null;
            }
            return this._batchIdMap.get(batchId);
        }

        private BatchIdEntry getBatchIdEntry(int spid, int kpid, int batchId) {
            if (kpid != this._kpid) {
                this._batchIdMap.clear();
                this._kpid = kpid;
                this._maxBatchId = 0;
            }
            this._maxBatchId = Math.max(batchId, this._maxBatchId);
            BatchIdEntry batchIdEntry = this._batchIdMap.get(batchId);
            if (batchIdEntry == null) {
                batchIdEntry = new BatchIdEntry(this, spid, kpid, batchId);
                this._batchIdMap.put(batchId, batchIdEntry);
            }
            return batchIdEntry;
        }

        public void addSqlText(int spid, int kpid, int batchId, int sequenceNum, String sqlText, String serverLogin) {
            this.getBatchIdEntry(spid, kpid, batchId).addSqlText(sequenceNum, sqlText, serverLogin);
        }
    }

    private static class SpidSqlTextManager {
        private HashMap<Integer, SpidEntry> _spidMap = new HashMap();

        private SpidSqlTextManager() {
        }

        private SpidEntry getSpidEntry(int spid, int kpid) {
            SpidEntry spidEntry = this._spidMap.get(spid);
            if (spidEntry == null) {
                spidEntry = new SpidEntry(spid, kpid);
                this._spidMap.put(spid, spidEntry);
            }
            return spidEntry;
        }

        public void processMarkedForRemoval() {
            for (SpidEntry spidEntry2 : this._spidMap.values()) {
                spidEntry2._batchIdMap.values().removeIf(batchEntry -> batchEntry.isMarkedForRemoval());
            }
            this._spidMap.values().removeIf(spidEntry -> ((SpidEntry)spidEntry)._batchIdMap.isEmpty());
        }

        public BatchIdEntry addStatementRecord(int spid, int kpid, int batchID, AuditRecordSybStmnt.MonSqlStatementEntry mdaStatement) {
            BatchIdEntry batchEntry;
            if (mdaStatement == null) {
                return null;
            }
            SpidEntry spidEntry = this._spidMap.get(spid);
            if (spidEntry != null && (batchEntry = spidEntry.getBatchIdEntryLazy(spid, kpid, batchID)) != null) {
                batchEntry.addStatementRecord(mdaStatement);
                return batchEntry;
            }
            return null;
        }

        public void addSqlText(int spid, int kpid, int batchId, int sequenceNum, String sqlText, String serverLogin) {
            this.getSpidEntry(spid, kpid).addSqlText(spid, kpid, batchId, sequenceNum, sqlText, serverLogin);
        }

        public String toString() {
            String str = "";
            String comma = "";
            for (SpidEntry spidEntry : this._spidMap.values()) {
                str = str + comma + "{spid=" + spidEntry._spid + ", kpid=" + spidEntry._kpid + ", maxBatchId=" + spidEntry._maxBatchId + ", batchIdMap.size()=" + spidEntry._batchIdMap.size() + "}";
                comma = ", ";
            }
            return "SpidSqlTextManager: spidMap.size()=" + this._spidMap.size() + ", spidMap=" + str;
        }
    }

    private static class MdaCheckMarker {
        String _sqlMarker;
        int _spid;
        int _kpid;
        int _batchId;

        private MdaCheckMarker() {
        }

        public String toString() {
            return "MdaCheckMarker [spid=" + this._spid + ", kpid=" + this._kpid + ", batchId=" + this._batchId + ", sqlMarker='" + this._sqlMarker + "']";
        }
    }
}

