/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.collectors.records;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.collectors.SybSysProcessesCache;
import sek.ase.auditor.collectors.records.AuditRecord;
import sek.ase.auditor.utils.StringUtil;
import sek.ase.auditor.utils.TimeUtils;

public class AuditRecordSybAudit
extends AuditRecord {
    private static Logger _logger = LogManager.getLogger();
    private SybSysProcessesCache.SybSysProcessesEntry _sybSysProcessEntry;
    private SybAuditEntry _sybAuditEntry;

    public void setSybSysProcessesEntry(SybSysProcessesCache.SybSysProcessesEntry sybSysProcessEntry) {
        this._sybSysProcessEntry = sybSysProcessEntry;
    }

    public SybAuditEntry getSybAuditEntry() {
        return this._sybAuditEntry;
    }

    public void setSybAuditEntry(SybAuditEntry sybAuditEntry) {
        this._sybAuditEntry = sybAuditEntry;
    }

    public void setSybAuditEntry(String eventName, int event, int eventmod, int spid, Timestamp eventtime, int sequence, int suid, int dbid, int objid, String xactid, String loginname, String dbname, String objname, String objowner, String extrainfo, int nodeid) {
        SybAuditEntry entry = new SybAuditEntry();
        entry._eventName = eventName;
        entry._event = event;
        entry._eventmod = eventmod;
        entry._spid = spid;
        entry._eventtime = eventtime;
        entry._sequence = sequence;
        entry._suid = suid;
        entry._dbid = dbid;
        entry._objid = objid;
        entry._xactid = xactid;
        entry._loginname = loginname;
        entry._dbname = dbname;
        entry._objname = objname;
        entry._objowner = objowner;
        entry._extrainfo = extrainfo;
        entry._nodeid = nodeid;
        this.setSybAuditEntry(entry);
    }

    @Override
    public void createJsonForRecord(JsonGenerator gen) throws IOException {
        if (this._sybAuditEntry != null) {
            gen.writeFieldName("sybAudit");
            gen.writeStartObject();
            gen.writeStringField("eventName", this._sybAuditEntry._eventName);
            gen.writeNumberField("event", this._sybAuditEntry._event);
            gen.writeNumberField("eventMod", this._sybAuditEntry._eventmod);
            gen.writeNumberField("spid", this._sybAuditEntry._spid);
            gen.writeStringField("eventTime", TimeUtils.toStringIso8601(this._sybAuditEntry._eventtime));
            gen.writeNumberField("sequence", this._sybAuditEntry._sequence);
            gen.writeNumberField("suid", this._sybAuditEntry._suid);
            gen.writeNumberField("dbid", this._sybAuditEntry._dbid);
            gen.writeNumberField("objid", this._sybAuditEntry._objid);
            gen.writeStringField("xactid", this._sybAuditEntry._xactid);
            gen.writeStringField("loginName", this._sybAuditEntry._loginname);
            gen.writeStringField("dbname", this._sybAuditEntry._dbname);
            gen.writeStringField("objectName", this._sybAuditEntry._objname);
            gen.writeStringField("objectOwner", this._sybAuditEntry._objowner);
            gen.writeStringField("extraInfo", this._sybAuditEntry._extrainfo);
            gen.writeNumberField("nodeid", this._sybAuditEntry._nodeid);
            if (StringUtil.hasValue(this._sybAuditEntry._ei_fld_roles)) {
                gen.writeStringField("eiField_Roles", this._sybAuditEntry._ei_fld_roles);
            }
            if (StringUtil.hasValue(this._sybAuditEntry._ei_fld_subCommand)) {
                gen.writeStringField("eiField_SubCommand", this._sybAuditEntry._ei_fld_subCommand);
            }
            if (StringUtil.hasValue(this._sybAuditEntry._ei_fld_previousValue)) {
                gen.writeStringField("eiField_PreviousValue", this._sybAuditEntry._ei_fld_previousValue);
            }
            if (StringUtil.hasValue(this._sybAuditEntry._ei_fld_currentValue)) {
                gen.writeStringField("eiField_CurrentValue", this._sybAuditEntry._ei_fld_currentValue);
            }
            if (StringUtil.hasValue(this._sybAuditEntry._ei_fld_otherInfo)) {
                gen.writeStringField("eiField_OtherInfo", this._sybAuditEntry._ei_fld_otherInfo);
            }
            if (StringUtil.hasValue(this._sybAuditEntry._ei_fld_proxyInfo)) {
                gen.writeStringField("eiField_ProxyInfo", this._sybAuditEntry._ei_fld_proxyInfo);
            }
            if (StringUtil.hasValue(this._sybAuditEntry._ei_fld_principalInfo)) {
                gen.writeStringField("eiField_PrincipalInfo", this._sybAuditEntry._ei_fld_principalInfo);
            }
            if (StringUtil.hasValue(this._sybAuditEntry._ei_cfg_area)) {
                gen.writeStringField("eiConfig_area", this._sybAuditEntry._ei_cfg_area);
            }
            if (StringUtil.hasValue(this._sybAuditEntry._ei_cfg_type)) {
                gen.writeStringField("eiConfig_type", this._sybAuditEntry._ei_cfg_type);
            }
            if (StringUtil.hasValue(this._sybAuditEntry._ei_cfg_target)) {
                gen.writeStringField("eiConfig_target", this._sybAuditEntry._ei_cfg_target);
            }
            if (StringUtil.hasValue(this._sybAuditEntry._ei_cfg_element)) {
                gen.writeStringField("eiConfig_element", this._sybAuditEntry._ei_cfg_element);
            }
            if (StringUtil.hasValue(this._sybAuditEntry._ei_cfg_oldvalue)) {
                gen.writeStringField("eiConfig_oldvalue", this._sybAuditEntry._ei_cfg_oldvalue);
            }
            if (StringUtil.hasValue(this._sybAuditEntry._ei_cfg_newvalue)) {
                gen.writeStringField("eiConfig_newvalue", this._sybAuditEntry._ei_cfg_newvalue);
            }
            if (StringUtil.hasValue(this._sybAuditEntry._ei_cfg_mode)) {
                gen.writeStringField("eiConfig_mode", this._sybAuditEntry._ei_cfg_mode);
            }
            if (StringUtil.hasValue(this._sybAuditEntry._ei_cfg_instanceid)) {
                gen.writeStringField("eiConfig_instanceid", this._sybAuditEntry._ei_cfg_instanceid);
            }
            gen.writeEndObject();
        }
        if (this._sybSysProcessEntry != null) {
            this._sybSysProcessEntry.createJsonForRecord(gen);
        }
    }

    public static class SybAuditEntry {
        int _event;
        String _eventName;
        int _eventmod;
        int _spid;
        Timestamp _eventtime;
        int _sequence;
        int _suid;
        int _dbid;
        int _objid;
        String _xactid;
        String _loginname;
        String _dbname;
        String _objname;
        String _objowner;
        String _extrainfo;
        int _nodeid;
        String _ei_fld_roles;
        String _ei_fld_subCommand;
        String _ei_fld_previousValue;
        String _ei_fld_currentValue;
        String _ei_fld_otherInfo;
        String _ei_fld_proxyInfo;
        String _ei_fld_principalInfo;
        String _ei_cfg_area;
        String _ei_cfg_type;
        String _ei_cfg_target;
        String _ei_cfg_element;
        String _ei_cfg_oldvalue;
        String _ei_cfg_newvalue;
        String _ei_cfg_mode;
        String _ei_cfg_instanceid;

        public int getEvent() {
            return this._event;
        }

        public String getEventName() {
            return this._eventName;
        }

        public int getEventmod() {
            return this._eventmod;
        }

        public int getSpid() {
            return this._spid;
        }

        public Timestamp getEventTime() {
            return this._eventtime;
        }

        public int getSequence() {
            return this._sequence;
        }

        public int getSuid() {
            return this._suid;
        }

        public int getDbid() {
            return this._dbid;
        }

        public int getObjid() {
            return this._objid;
        }

        public String getXactid() {
            return this._xactid;
        }

        public String getLoginName() {
            return this._loginname;
        }

        public String getDbname() {
            return this._dbname;
        }

        public String getObjectname() {
            return this._objname;
        }

        public String getObjectowner() {
            return this._objowner;
        }

        public String getExtrainfo() {
            return this._extrainfo;
        }

        public int getNodeid() {
            return this._nodeid;
        }

        public void addExtraInfo(String extraInfo, int sequence) {
            this._extrainfo = this._extrainfo + extraInfo;
            this._sequence = sequence;
        }

        public void normalizeExtraInfo() {
            if (StringUtil.isNullOrBlank(this._extrainfo)) {
                return;
            }
            if (this._extrainfo.indexOf(59) == -1) {
                return;
            }
            String[] ei = this._extrainfo.split(";");
            for (int i = 0; i < ei.length; ++i) {
                if (i == 0) {
                    this._ei_fld_roles = ei[i].trim();
                }
                if (i == 1) {
                    this._ei_fld_subCommand = ei[i].trim();
                }
                if (i == 2) {
                    this._ei_fld_previousValue = ei[i].trim();
                }
                if (i == 3) {
                    this._ei_fld_currentValue = ei[i].trim();
                }
                if (i == 4) {
                    this._ei_fld_otherInfo = ei[i].trim();
                }
                if (i == 5) {
                    this._ei_fld_proxyInfo = ei[i].trim();
                }
                if (i != 6) continue;
                this._ei_fld_principalInfo = ei[i].trim();
            }
            if (this._event == 154) {
                String cfgField = this._ei_fld_otherInfo;
                this._ei_cfg_area = StringUtils.substringBetween((String)cfgField, (String)"^1", (String)"^2");
                this._ei_cfg_type = StringUtils.substringBetween((String)cfgField, (String)"^2", (String)"^3");
                this._ei_cfg_target = StringUtils.substringBetween((String)cfgField, (String)"^3", (String)"^4");
                this._ei_cfg_element = StringUtils.substringBetween((String)cfgField, (String)"^4", (String)"^5");
                this._ei_cfg_oldvalue = StringUtils.substringBetween((String)cfgField, (String)"^5", (String)"^6");
                this._ei_cfg_newvalue = StringUtils.substringBetween((String)cfgField, (String)"^6", (String)"^7");
                this._ei_cfg_mode = StringUtils.substringBetween((String)cfgField, (String)"^7", (String)"^8");
                this._ei_cfg_instanceid = StringUtils.substringBetween((String)cfgField, (String)"^8", (String)"^9");
            }
        }
    }
}

