/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.collectors.records;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.collectors.SybSysProcessesCache;
import sek.ase.auditor.collectors.records.AuditRecord;
import sek.ase.auditor.utils.AseErrorMessageDictionary;
import sek.ase.auditor.utils.Configuration;
import sek.ase.auditor.utils.TimeUtils;

public class AuditRecordSybStmnt
extends AuditRecord {
    private static Logger _logger = LogManager.getLogger();
    private SybSysProcessesCache.SybSysProcessesEntry _sybSysProcessEntry;
    private SqlTextEntry _sqlTextEntry;

    public void setSybSysProcessesEntry(SybSysProcessesCache.SybSysProcessesEntry sybSysProcessEntry) {
        this._sybSysProcessEntry = sybSysProcessEntry;
    }

    public void setSqlTextEntry(SqlTextEntry sqlTextEntry) {
        this._sqlTextEntry = sqlTextEntry;
    }

    public void setSqlTextEntry(int spid, int kpid, int batchId, String srvLogin, String sqlText, List<MonSqlStatementEntry> mdaStatementRecords) {
        this._sqlTextEntry = new SqlTextEntry(spid, kpid, batchId, srvLogin, sqlText, mdaStatementRecords);
    }

    public String toString() {
        return super.toString() + "\n      -- " + this._sqlTextEntry + ", \n      -- " + this._sybSysProcessEntry + ".";
    }

    @Override
    public void createJsonForRecord(JsonGenerator gen) throws IOException {
        if (this._sqlTextEntry != null) {
            gen.writeFieldName("sqlText");
            gen.writeStartObject();
            gen.writeNumberField("spid", this._sqlTextEntry._spid);
            gen.writeNumberField("kpid", this._sqlTextEntry._kpid);
            gen.writeNumberField("batchId", this._sqlTextEntry._batchId);
            gen.writeStringField("srvLogin", this._sqlTextEntry._srvLogin);
            gen.writeStringField("sqlText", this._sqlTextEntry._sqlText);
            if (this._sqlTextEntry._mdaStatementRecords != null && !this._sqlTextEntry._mdaStatementRecords.isEmpty()) {
                gen.writeFieldName("statementInfo");
                gen.writeStartArray();
                int stmntSeqNum = 0;
                for (MonSqlStatementEntry stmntEntry : this._sqlTextEntry._mdaStatementRecords) {
                    stmntEntry.createJsonForRecord(gen, ++stmntSeqNum);
                }
                gen.writeEndArray();
            }
            gen.writeEndObject();
        }
        if (this._sybSysProcessEntry != null) {
            this._sybSysProcessEntry.createJsonForRecord(gen);
        }
    }

    public static class MonSqlStatementEntry {
        public int SPID;
        public int KPID;
        public int BatchID;
        public Timestamp StartTime;
        public Timestamp EndTime;
        public int Elapsed_ms;
        public Timestamp sampleTime;
        public int DBID;
        public String DBName;
        public int RowsAffected;
        public int ErrorStatus;
        public int HashKey;
        public int SsqlId;
        public int ObjOwnerID;
        public int ProcedureID;
        public int PlanID;
        public int ContextID;
        public String ProcName;
        public int ProcNestLevel;
        public int StatementNumber;
        public int LineNumber;
        public long QueryOptimizationTime;
        public int PlansAltered;
        public int CpuTime;
        public int WaitTime;
        public int MemUsageKB;
        public long PhysicalReads;
        public long LogicalReads;
        public long PagesModified;
        public int PacketsSent;
        public int PacketsReceived;
        public int NetworkPacketSize;
        private static String _sql;

        public MonSqlStatementEntry(ResultSet rs) throws SQLException {
            int colNum = 1;
            this.SPID = rs.getInt(colNum++);
            this.KPID = rs.getInt(colNum++);
            this.BatchID = rs.getInt(colNum++);
            this.StartTime = rs.getTimestamp(colNum++);
            this.EndTime = rs.getTimestamp(colNum++);
            this.Elapsed_ms = rs.getInt(colNum++);
            this.sampleTime = rs.getTimestamp(colNum++);
            this.DBID = rs.getInt(colNum++);
            this.DBName = rs.getString(colNum++);
            this.RowsAffected = rs.getInt(colNum++);
            this.ErrorStatus = rs.getInt(colNum++);
            this.HashKey = rs.getInt(colNum++);
            this.SsqlId = rs.getInt(colNum++);
            this.ObjOwnerID = rs.getInt(colNum++);
            this.ProcedureID = rs.getInt(colNum++);
            this.PlanID = rs.getInt(colNum++);
            this.ContextID = rs.getInt(colNum++);
            this.ProcName = rs.getString(colNum++);
            this.ProcNestLevel = rs.getInt(colNum++);
            this.StatementNumber = rs.getInt(colNum++);
            this.LineNumber = rs.getInt(colNum++);
            this.QueryOptimizationTime = rs.getLong(colNum++);
            this.PlansAltered = rs.getInt(colNum++);
            this.CpuTime = rs.getInt(colNum++);
            this.WaitTime = rs.getInt(colNum++);
            this.MemUsageKB = rs.getInt(colNum++);
            try {
                this.PhysicalReads = rs.getLong(colNum++);
            }
            catch (SQLException ex) {
                _logger.warn("Problems reading column 'PhysicalReads', strVal='" + rs.getString(colNum - 1) + "', setting this to -1 and continuing. Caught: " + ex);
            }
            this.LogicalReads = rs.getLong(colNum++);
            this.PagesModified = rs.getLong(colNum++);
            this.PacketsSent = rs.getInt(colNum++);
            this.PacketsReceived = rs.getInt(colNum++);
            this.NetworkPacketSize = rs.getInt(colNum++);
        }

        public static String getSql() {
            if (_sql != null) {
                return _sql;
            }
            boolean collectProcName = Configuration.getCombinedConfiguration().getBooleanProperty("SybStmntCollector.sample.statement.procName", false);
            String ObjOwnerID = null;
            String ProcName = null;
            String QueryOptimizationTime = "    ,QueryOptimizationTime = -1 \n";
            if (collectProcName) {
                ObjOwnerID = "    ,ObjOwnerID = CASE WHEN SsqlId > 0 THEN 0 ELSE object_owner_id(ProcedureID, DBID) END \n";
                ProcName = "    ,ProcName   = CASE WHEN SsqlId > 0 THEN isnull(object_name(SsqlId,2), '*##'+right('0000000000'+convert(varchar(20),SsqlId),10)+'_'+right('0000000000'+convert(varchar(20),HashKey),10)+'##*') \n                       ELSE coalesce(object_name(ProcedureID,DBID), object_name(ProcedureID,2), object_name(ProcedureID,db_id('sybsystemprocs'))) \n                  END \n";
            } else {
                ObjOwnerID = "    ,ObjOwnerID = -1 \n";
                ProcName = "    ,ProcName   = 'SybStmntCollector.sample.statement.procName = false'";
                _logger.warn("When initializing SQL query for 'SybStmntCollector.sample.statement.details' we will SKIP the columns 'ProcName' and 'ObjOwnerID'. If you want to enable them set 'SybStmntCollector.sample.statement.procName = true'. NOTE: The Login that collects data needs to have 'sa_role' or access to all databases (sp_adduser -in-all-databases-).");
            }
            _sql = "select \n     SPID \n    ,KPID \n    ,BatchID \n    ,StartTime \n    ,EndTime \n    ,Elapsed_ms = CASE WHEN datediff(day, StartTime, EndTime) >= 24 THEN -1 ELSE  datediff(ms, StartTime, EndTime) END \n    ,sampleTime = getdate() \n    ,DBID \n    ,DBName \n    ,RowsAffected \n    ,ErrorStatus \n    ,HashKey \n    ,SsqlId \n" + ObjOwnerID + "    ,ProcedureID \n    ,PlanID \n    ,ContextID \n" + ProcName + "    ,ProcNestLevel \n    ,StatementNumber \n    ,LineNumber \n" + QueryOptimizationTime + "    ,PlansAltered \n    ,CpuTime \n    ,WaitTime \n    ,MemUsageKB \n    ,PhysicalReads \n    ,LogicalReads \n    ,PagesModified \n    ,PacketsSent \n    ,PacketsReceived \n    ,NetworkPacketSize \nfrom master.dbo.monSysStatement \n";
            return _sql;
        }

        public void createJsonForRecord(JsonGenerator gen, int stmntSeqNum) throws IOException {
            String errorMsg = null;
            if (this.ErrorStatus != 0) {
                errorMsg = AseErrorMessageDictionary.getInstance().getDescription(this.ErrorStatus);
            }
            gen.writeStartObject();
            if (stmntSeqNum > 0) {
                gen.writeNumberField("stmntSeqNum", stmntSeqNum);
            }
            gen.writeNumberField("spid", this.SPID);
            gen.writeNumberField("kpid", this.KPID);
            gen.writeNumberField("batchId", this.BatchID);
            gen.writeStringField("startTime", TimeUtils.toStringIso8601(this.StartTime));
            gen.writeStringField("endTime", TimeUtils.toStringIso8601(this.EndTime));
            gen.writeNumberField("elapsedMs", this.Elapsed_ms);
            gen.writeStringField("sampleTime", TimeUtils.toStringIso8601(this.sampleTime));
            gen.writeNumberField("dbid", this.DBID);
            gen.writeStringField("dbname", this.DBName);
            gen.writeNumberField("rowsAffected", this.RowsAffected);
            gen.writeNumberField("errorStatus", this.ErrorStatus);
            if (errorMsg != null) {
                gen.writeStringField("errorMsg", errorMsg);
            }
            gen.writeNumberField("hashKey", this.HashKey);
            gen.writeNumberField("ssqlId", this.SsqlId);
            gen.writeNumberField("objOwnerId", this.ObjOwnerID);
            gen.writeNumberField("procedureId", this.ProcedureID);
            gen.writeNumberField("planId", this.PlanID);
            gen.writeNumberField("contextId", this.ContextID);
            gen.writeStringField("procName", this.ProcName);
            gen.writeNumberField("procNestLevel", this.ProcNestLevel);
            gen.writeNumberField("statementNumber", this.StatementNumber);
            gen.writeNumberField("lineNumber", this.LineNumber);
            gen.writeNumberField("queryOptimizationTime", this.QueryOptimizationTime);
            gen.writeNumberField("plansAltered", this.PlansAltered);
            gen.writeNumberField("cpuTime", this.CpuTime);
            gen.writeNumberField("waitTime", this.WaitTime);
            gen.writeNumberField("memUsageKb", this.MemUsageKB);
            gen.writeNumberField("physicalReads", this.PhysicalReads);
            gen.writeNumberField("logicalReads", this.LogicalReads);
            gen.writeNumberField("pagesModified", this.PagesModified);
            gen.writeNumberField("packetsSent", this.PacketsSent);
            gen.writeNumberField("packetsReceived", this.PacketsReceived);
            gen.writeNumberField("networkPacketSize", this.NetworkPacketSize);
            gen.writeEndObject();
        }
    }

    public static class SqlTextEntry {
        int _spid;
        int _kpid;
        int _batchId;
        String _srvLogin;
        String _sqlText;
        List<MonSqlStatementEntry> _mdaStatementRecords;

        public SqlTextEntry() {
        }

        public SqlTextEntry(int spid, int kpid, int batchId, String srvLogin, String sqlText, List<MonSqlStatementEntry> mdaStatementRecords) {
            this._spid = spid;
            this._kpid = kpid;
            this._batchId = batchId;
            this._srvLogin = srvLogin;
            this._sqlText = sqlText;
            this._mdaStatementRecords = mdaStatementRecords;
        }

        public String toString() {
            return "SqlTextEntry [spid=" + this._spid + ", kpid=" + this._kpid + ", batchId=" + this._batchId + ", srvLogin='" + this._srvLogin + "', sqlText=|" + this._sqlText + "|, mdaStatementRecords.size=" + (this._mdaStatementRecords == null ? "null" : Integer.valueOf(this._mdaStatementRecords.size())) + "]";
        }
    }
}

