/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class NumberUtils {
    public static Number toNumber(Object o) {
        if (o == null) {
            throw new NumberFormatException("Sorry can't convert a 'null' value to a Number.");
        }
        if (o instanceof Number) {
            return (Number)o;
        }
        String asStr = o.toString().trim();
        if (asStr.indexOf(".") > 0) {
            return new BigDecimal(asStr);
        }
        if (asStr.length() == 10) {
            Long l = new Long(asStr);
            if (l > Integer.MAX_VALUE) {
                return l;
            }
            return new Integer(l.intValue());
        }
        if (asStr.length() > 10) {
            return new Long(asStr);
        }
        return new Integer(asStr);
    }

    public static boolean isNumber(String str) {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isNumeric(String strNum, boolean allowCommas) {
        if (strNum == null) {
            return false;
        }
        if (allowCommas) {
            strNum = strNum.replace(",", "").trim();
        }
        try {
            Double.parseDouble(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static Double round(Double value, int places) {
        if (value == null) {
            return null;
        }
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return new Double(bd.doubleValue());
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static BigDecimal roundAsBigDecimal(Double value, int places) {
        if (value == null) {
            return null;
        }
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd;
    }

    public static BigDecimal roundAsBigDecimal(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd;
    }

    public static double toKb(long bytes, int roundingDecimals) {
        return NumberUtils.round((double)bytes / 1024.0, roundingDecimals);
    }

    public static double toMb(long bytes, int roundingDecimals) {
        return NumberUtils.round((double)bytes / 1024.0 / 1024.0, roundingDecimals);
    }

    public static double toGb(long bytes, int roundingDecimals) {
        return NumberUtils.round((double)bytes / 1024.0 / 1024.0 / 1024.0, roundingDecimals);
    }

    public static Number toNumberValue(Number numberObj, int asValue) {
        if (numberObj == null) {
            throw new RuntimeException("toNumberValue() expects a 'numberObj' to decide what data type to return");
        }
        if (numberObj instanceof Integer) {
            return new Integer(asValue);
        }
        if (numberObj instanceof Long) {
            return new Long(asValue);
        }
        if (numberObj instanceof Short) {
            return new Short(asValue + "");
        }
        if (numberObj instanceof Double) {
            return new Double(asValue);
        }
        if (numberObj instanceof BigDecimal) {
            return new BigDecimal(asValue);
        }
        if (numberObj instanceof Float) {
            return new Float(asValue);
        }
        if (numberObj instanceof Byte) {
            return new Byte(asValue + "");
        }
        if (numberObj instanceof AtomicInteger) {
            return new AtomicInteger(asValue);
        }
        if (numberObj instanceof AtomicLong) {
            return new AtomicLong(asValue);
        }
        if (numberObj instanceof LongAdder) {
            return new LongAdder();
        }
        if (numberObj instanceof DoubleAdder) {
            return new DoubleAdder();
        }
        throw new RuntimeException("toNumberValue() numberObj=" + numberObj + " is of unhandled class " + numberObj.getClass().getName());
    }
}

