/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import sek.ase.auditor.utils.Pipe;

public class OSCommand {
    protected Process _process = null;
    protected String _command;
    protected InputStream _input;
    protected ByteArrayOutputStream _stdOutput = new ByteArrayOutputStream();
    protected ByteArrayOutputStream _errOutput = new ByteArrayOutputStream();
    protected Pipe _stdOutputPipe = null;
    protected Pipe _errOutputPipe = null;

    public OSCommand(String s) {
        this._command = s;
    }

    public static OSCommand execute(String cmd) throws IOException {
        OSCommand oscmd = new OSCommand(cmd);
        oscmd.execute();
        return oscmd;
    }

    public void execute() throws IOException {
        Runtime rt = Runtime.getRuntime();
        this._process = rt.exec(this._command);
        if (this._input != null) {
            new Pipe(this._input, this._process.getOutputStream());
        }
        this._stdOutputPipe = new Pipe(this._process.getInputStream(), this._stdOutput);
        this._errOutputPipe = new Pipe(this._process.getErrorStream(), this._errOutput);
    }

    public void setInput(InputStream is) {
        this._input = is;
    }

    public void setInput(String s) {
        this.setInput(new ByteArrayInputStream(s.getBytes()));
    }

    public String getErrorOutput() {
        this._errOutputPipe.waitFor();
        return this._errOutput.toString();
    }

    public String getStdOutput() {
        this._stdOutputPipe.waitFor();
        return this._stdOutput.toString();
    }

    public String getOutput() {
        String err = this.getErrorOutput();
        String std = this.getStdOutput();
        if (err.length() == 0) {
            return std;
        }
        if (std.length() == 0) {
            return err;
        }
        return err + "\n" + std;
    }

    public int returnCode() {
        try {
            this._process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this._process.exitValue();
    }

    public void close() throws IOException {
        this._process.getInputStream().close();
        this._process.getOutputStream().close();
        this._process.getErrorStream().close();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: OSCommand command1 command2 ...");
        }
        if (args[0].equals("test1")) {
            int loop = Integer.parseInt(args[1]);
            for (int i = 0; i < loop; ++i) {
                try {
                    String cmd = "echo 'loop is " + i + "'";
                    System.out.println("Command to execute: " + cmd);
                    OSCommand oscmd = new OSCommand(cmd);
                    oscmd.execute();
                    System.out.println("Return code: " + oscmd.returnCode());
                    System.out.println("Output from the command:");
                    System.out.println(oscmd.getOutput());
                    oscmd.close();
                    oscmd = null;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        } else {
            for (int i = 0; i < args.length; ++i) {
                try {
                    System.out.println("Command to execute: '" + args[i] + "'");
                    OSCommand oscmd = new OSCommand(args[i]);
                    oscmd.execute();
                    System.out.println("Return code: " + oscmd.returnCode());
                    System.out.println("Output from the command:");
                    System.out.println(oscmd.getOutput());
                    oscmd.close();
                    oscmd = null;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

