/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.utils;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.utils.Configuration;
import sek.ase.auditor.utils.JavaUtils;
import sek.ase.auditor.utils.StringUtil;
import sek.ase.auditor.utils.TimeUtils;

public class ShutdownHandler
implements Runnable {
    private static Logger _logger = LogManager.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROPKEY_maxWaitTime = "ShutdownHandler.maxWaitTime";
    public static final int DEFAULT_maxWaitTime = 60000;
    public static final int RESTART_EXIT_CODE = 8;
    private static List<Shutdownable> _handlers = new ArrayList<Shutdownable>();
    private static Thread _shutdownHook = null;
    private static long _maxWaitTime = 60000L;
    private static Object _waitforObject = new Object();
    private static boolean _withRestart = false;
    private static Configuration _shutdownConfig = null;
    private static String _shutdownReasonText = "";

    public static void installJvmShutdownHook() {
        if (_shutdownHook != null) {
            throw new RuntimeException("A shutdown hook is already installed.");
        }
        _maxWaitTime = Configuration.getCombinedConfiguration().getIntProperty(PROPKEY_maxWaitTime, 60000);
        _shutdownHook = new Thread(new ShutdownHandler());
        _shutdownHook.setName("ShutdownHandler");
        Runtime.getRuntime().addShutdownHook(_shutdownHook);
    }

    public static void removeJvmShutdownHook() {
        if (_shutdownHook == null) {
            throw new RuntimeException("Can't remove the shutdown hook, there is NONE installed");
        }
        Runtime.getRuntime().removeShutdownHook(_shutdownHook);
        _shutdownHook = null;
    }

    public static boolean hasJvmShutdownHook() {
        return _shutdownHook != null;
    }

    public static long getMaxWaitTime() {
        return _maxWaitTime;
    }

    public static void setMaxWaitTime(long maxWaitTime) {
        _maxWaitTime = maxWaitTime;
    }

    public static void addShutdownHandler(Shutdownable handler) {
        ShutdownHandler.addShutdownHandler(-1, handler);
    }

    public static void addShutdownHandler(int index, Shutdownable handler) {
        if (!ShutdownHandler.hasJvmShutdownHook()) {
            ShutdownHandler.installJvmShutdownHook();
        }
        if (index >= 0) {
            _handlers.add(index, handler);
        } else {
            _handlers.add(handler);
        }
    }

    public static void removeShutdownHandler(Shutdownable handler) {
        _handlers.remove(handler);
        if (_handlers.isEmpty()) {
            ShutdownHandler.removeJvmShutdownHook();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitforShutdown() {
        _withRestart = false;
        Object object = _waitforObject;
        synchronized (object) {
            try {
                _logger.info("Waiting for shutdown on thread '" + Thread.currentThread().getName() + "'.");
                _waitforObject.wait();
                _logger.info("AFTER-Waiting for shutdown on thread '" + Thread.currentThread().getName() + "'.");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void shutdown(String reasonText) {
        ShutdownHandler.shutdown(reasonText, false, null);
    }

    public static void shutdownWithRestart(String reasonText) {
        ShutdownHandler.shutdown(reasonText, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(String reasonText, boolean withRestart, Configuration shutdownConfig) {
        if (StringUtil.isNullOrBlank(_shutdownReasonText)) {
            _shutdownConfig = shutdownConfig;
            _withRestart = withRestart;
            _shutdownReasonText = reasonText;
        } else {
            _logger.info("The just sent shutdown request properties [reasonText='" + reasonText + "', withRestart=" + withRestart + "] wont be used... keeping first entered request with properties [reasonText='" + _shutdownReasonText + "', withRestart=" + _withRestart + "]. The shutdown request will still be done, but the shutdown properties will be discarded.");
        }
        Object object = _waitforObject;
        synchronized (object) {
            _logger.info("Shutdown was called from from thread '" + Thread.currentThread().getName() + "'. reason='" + reasonText + "'.");
            _waitforObject.notifyAll();
        }
    }

    public static boolean wasRestartSpecified() {
        return _withRestart;
    }

    public static Configuration getShutdownConfiguration() {
        if (_shutdownConfig == null) {
            return Configuration.emptyConfiguration();
        }
        return _shutdownConfig;
    }

    public static String getShutdownReason() {
        return _shutdownReasonText;
    }

    @Override
    public void run() {
        ArrayList<Thread> nonDeamonList = new ArrayList<Thread>();
        for (Thread th : Thread.getAllStackTraces().keySet()) {
            if (th == Thread.currentThread() || "DestroyJavaVM".equals(th.getName()) || this.didThreadIssueExit(th) || th.isDaemon()) continue;
            nonDeamonList.add(th);
        }
        if (nonDeamonList.isEmpty()) {
            _logger.debug("Shutdown-hook: Normal shutdown, since no 'non-daemon' thread is alive...");
            return;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Shutdown-hook: Initiating non-normal shutdown. nonDeamonList count=" + nonDeamonList.size());
            for (Thread th : nonDeamonList) {
                _logger.debug("Shutdown-hook: isDaemon=" + th.isDaemon() + ", threadName=|" + th.getName() + "|, th.getClass().getName()=|" + th.getClass().getName() + "|.");
            }
        }
        ArrayList<String> waitforThreadNames = new ArrayList<String>();
        if (!_handlers.isEmpty()) {
            _logger.info("Shutdown-hook: issuing 'systemShutdown' on " + _handlers.size() + " handlers..");
            for (int i = _handlers.size() - 1; i >= 0; --i) {
                Shutdownable handler = _handlers.get(i);
                List<String> waitList = handler.systemShutdown();
                if (waitList == null || waitList.isEmpty()) continue;
                waitforThreadNames.addAll(waitList);
            }
        }
        this.waitforThreads(waitforThreadNames);
        _logger.info("Shutdown-hook: end.");
    }

    private void waitforThreads(List<String> waitforThreadNames) {
        if (waitforThreadNames.isEmpty()) {
            _logger.info("Shutdown-hook: No threads to wait for, the waiting list is empty.");
            return;
        }
        _logger.info("Shutdown-hook: Waiting for the following thread names to terminate before JVM Shutdown: " + waitforThreadNames);
        long sleepTime = 1000L;
        long maxWaitTime = _maxWaitTime;
        long startTime = System.currentTimeMillis();
        block2: while (!waitforThreadNames.isEmpty()) {
            String waitForThreadName = waitforThreadNames.get(0);
            while (true) {
                Thread waitForThread = null;
                for (Thread th : Thread.getAllStackTraces().keySet()) {
                    if (!waitForThreadName.equals(th.getName())) continue;
                    waitForThread = th;
                }
                if (waitForThread == null) {
                    waitforThreadNames.remove(waitForThreadName);
                    continue block2;
                }
                if (this.didThreadIssueExit(waitForThread)) {
                    _logger.info("Shutdown-hook: Skip waiting for thread '" + waitForThreadName + "', which issued 'System.exit'. Removing this thread from the waiting list.");
                    waitforThreadNames.remove(waitForThreadName);
                    continue block2;
                }
                if (TimeUtils.msDiffNow(startTime) > maxWaitTime) {
                    _logger.warn("Shutdown-hook: Waited for thread '" + waitForThreadName + "' to terminate. maxWaitTime=" + maxWaitTime + " ms has been expired. STOP WAITING.");
                    _logger.warn("Shutdown-hook: Here is a stacktrace of the thread '" + waitForThreadName + "' we are waiting for:" + StringUtil.stackTraceToString(waitForThread.getStackTrace()));
                    String stackDump = JavaUtils.getStackDump(true);
                    _logger.warn("Shutdown-hook: For completeness, lets stacktrace all other threads.\n" + stackDump);
                    return;
                }
                _logger.info("Shutdown-hook: Still waiting for thread '" + waitForThreadName + "' to terminate... sleepTime=" + sleepTime + ", TotalWaitTime=" + TimeUtils.msDiffNow(startTime) + ", maxWaitTime=" + maxWaitTime);
                try {
                    waitForThread.join(sleepTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private boolean didThreadIssueExit(Thread thread) {
        boolean thraedIssuedExit = false;
        for (StackTraceElement ste : thread.getStackTrace()) {
            if (!ste.getClassName().endsWith("Shutdown") || !ste.getMethodName().equals("exit")) continue;
            thraedIssuedExit = true;
            break;
        }
        return thraedIssuedExit;
    }

    public static void main(String[] args) {
        System.out.println("START.");
        System.out.println("   to test: press ctrl-c, or kill the process in some way (kill <spid>).");
        ShutdownHandler.addShutdownHandler(new DummtWorker("TIMEOUT", 50L));
        ShutdownHandler.addShutdownHandler(new DummtWorker("xxx6", 45L));
        ShutdownHandler.addShutdownHandler(new DummtWorker("xxx5", 40L));
        ShutdownHandler.addShutdownHandler(new DummtWorker("xxx4", 35L));
        ShutdownHandler.addShutdownHandler(new DummtWorker("xxx3", 30L));
        ShutdownHandler.addShutdownHandler(new DummtWorker("xxx2", 25L));
        ShutdownHandler.addShutdownHandler(new DummtWorker("xxx1", 20L));
        if (args.length > 0) {
            throw new RuntimeException("asdfasdf");
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("END...");
    }

    private static class DummtWorker
    implements Shutdownable {
        String _tName = null;
        long _sleepTime;

        public DummtWorker(String name, long sleepTime) {
            this._tName = name;
            this._sleepTime = sleepTime;
            Thread t = new Thread(name){

                @Override
                public void run() {
                    try {
                        System.out.println("START THREAD: " + Thread.currentThread().getName() + ", sleepTime=" + _sleepTime);
                        Thread.sleep(_sleepTime * 1000L);
                        System.out.println("STOP THREAD: " + Thread.currentThread().getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            t.start();
        }

        @Override
        public List<String> systemShutdown() {
            return Arrays.asList(this._tName);
        }
    }

    public static interface Shutdownable {
        public List<String> systemShutdown();
    }
}

