/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import sek.ase.auditor.utils.Strftime;

public class TimeUtils {
    public static final SimpleDateFormat ISO8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final SimpleDateFormat ISO8601_UTC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    public static final SimpleDateFormat UTC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static HashMap<String, Long> _timeExpiredMap;
    public static final int DD_MS = 0;
    public static final int DD_MILLISECOND = 0;
    public static final int DD_SS = 1;
    public static final int DD_SECOND = 1;
    public static final int DD_MI = 2;
    public static final int DD_MINUTE = 2;
    public static final int DD_HH = 3;
    public static final int DD_HOUR = 3;
    public static final int DD_DD = 4;
    public static final int DD_DAY = 4;
    public static final int DD_WK = 5;
    public static final int DD_WEEK = 5;
    public static final int DD_MM = 6;
    public static final int DD_MONTH = 6;

    public static boolean timeExpired(String key, long timeLimitInMs) {
        Long lastCallTime = _timeExpiredMap.get(key);
        if (lastCallTime == null) {
            lastCallTime = new Long(System.currentTimeMillis());
            _timeExpiredMap.put(key, lastCallTime);
            return true;
        }
        if (System.currentTimeMillis() - lastCallTime > timeLimitInMs) {
            lastCallTime = new Long(System.currentTimeMillis());
            _timeExpiredMap.put(key, lastCallTime);
            return true;
        }
        return false;
    }

    public static boolean printMessage(String key, long timeLimitInMs) {
        return TimeUtils.timeExpired(key, timeLimitInMs);
    }

    public static void timeExpiredSetStartTime(String key) {
        _timeExpiredMap.put(key, new Long(System.currentTimeMillis()));
    }

    public static long secondsDiffNow(long startTime) {
        return (System.currentTimeMillis() - startTime) / 1000L;
    }

    public static long msDiffNow(long startTime) {
        return System.currentTimeMillis() - startTime;
    }

    public static String msDiffNowToTimeStr(long startTime) {
        long execTime = TimeUtils.msDiffNow(startTime);
        return TimeUtils.msToTimeStr(execTime);
    }

    public static String msDiffNowToTimeStr(String format, long startTime) {
        long execTime = TimeUtils.msDiffNow(startTime);
        return TimeUtils.msToTimeStr(format, execTime);
    }

    public static String msToTimeStr(long execTime) {
        String execTimeHH = "00";
        String execTimeMM = "00";
        String execTimeSS = "00";
        String execTimeMs = "000";
        execTimeMs = "000" + execTime % 1000L;
        execTimeMs = execTimeMs.substring(execTimeMs.length() - 3);
        execTimeSS = "00" + (execTime /= 1000L) % 60L;
        execTimeSS = execTimeSS.substring(execTimeSS.length() - 2);
        execTimeMM = "00" + (execTime /= 60L) % 60L;
        execTimeMM = execTimeMM.substring(execTimeMM.length() - 2);
        execTimeHH = "00" + (execTime /= 60L);
        execTimeHH = execTime < 100L ? execTimeHH.substring(execTimeHH.length() - 2) : "" + execTime;
        return execTimeHH + ":" + execTimeMM + ":" + execTimeSS + "." + execTimeMs;
    }

    public static String msToTimeStrOLD(String format, long execTime) {
        if (format == null) {
            throw new RuntimeException("msToTimeStr(): format can't be null");
        }
        if (format.trim().length() == 0) {
            throw new RuntimeException("msToTimeStr(): format can't be empty");
        }
        String execTimeHH = "00";
        String execTimeMM = "00";
        String execTimeSS = "00";
        String execTimeMs = "000";
        execTimeMs = "000" + execTime % 1000L;
        execTimeMs = execTimeMs.substring(execTimeMs.length() - 3);
        execTimeSS = "00" + (execTime /= 1000L) % 60L;
        execTimeSS = execTimeSS.substring(execTimeSS.length() - 2);
        execTimeMM = "00" + (execTime /= 60L) % 60L;
        execTimeMM = execTimeMM.substring(execTimeMM.length() - 2);
        execTimeHH = "00" + (execTime /= 60L);
        execTimeHH = execTime < 100L ? execTimeHH.substring(execTimeHH.length() - 2) : "" + execTime;
        String tagStrHH = "%?HH";
        if (format.indexOf(tagStrHH) >= 0) {
            String withinSquareBrakets = "";
            int tagStartPos = format.indexOf(tagStrHH + "[");
            if (tagStartPos >= 0) {
                int tagEndPos = format.indexOf("]", tagStartPos);
                if (tagEndPos >= 0) {
                    withinSquareBrakets = format.substring(tagStartPos + (tagStrHH + "[").length(), tagEndPos);
                }
                tagStrHH = tagStrHH + "[" + withinSquareBrakets + "]";
            }
            format = "00".equals(execTimeHH) ? format.replace(tagStrHH, "") : format.replace(tagStrHH, execTimeHH + withinSquareBrakets);
        }
        format = format.replace("%HH", execTimeHH);
        format = format.replace("%MM", execTimeMM);
        format = format.replace("%SS", execTimeSS);
        format = format.replace("%ms", execTimeMs);
        return format;
    }

    public static String secToTimeStrLong(long execTimeInSec) {
        return TimeUtils.msToTimeStr("%?DD[d ]%HH:%MM:%SS", execTimeInSec * 1000L);
    }

    public static String secToTimeStrShort(long execTimeInSec) {
        return TimeUtils.msToTimeStr("%?DD[d ]%?HH[:]%MM:%SS", execTimeInSec * 1000L);
    }

    public static String msToTimeStrLong(long execTimeInMs) {
        return TimeUtils.msToTimeStr("%?DD[d ]%HH:%MM:%SS.%ms", execTimeInMs);
    }

    public static String msToTimeStrShort(long execTimeInMs) {
        return TimeUtils.msToTimeStr("%?DD[d ]%?HH[:]%MM:%SS.%ms", execTimeInMs);
    }

    public static String usToTimeStrLong(long execTimeInUs) {
        return TimeUtils.msToTimeStr("%?DD[d ]%HH:%MM:%SS.%ms", execTimeInUs / 1000L);
    }

    public static String usToTimeStrShort(long execTimeInUs) {
        return TimeUtils.msToTimeStr("%?DD[d ]%?HH[:]%MM:%SS.%ms", execTimeInUs / 1000L);
    }

    public static String msToTimeStr(String format, long execTime) {
        String tagStrDay;
        boolean hasDaysFormat;
        if (format == null) {
            throw new RuntimeException("msToTimeStr(): format can't be null");
        }
        if (format.trim().length() == 0) {
            throw new RuntimeException("msToTimeStr(): format can't be empty");
        }
        long hoursAbs = TimeUnit.MILLISECONDS.toHours(execTime);
        long days = TimeUnit.MILLISECONDS.toDays(execTime);
        long hours = TimeUnit.MILLISECONDS.toHours(execTime) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(execTime));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(execTime) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(execTime));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(execTime) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(execTime));
        long millis = TimeUnit.MILLISECONDS.toMillis(execTime) - TimeUnit.SECONDS.toMillis(TimeUnit.MILLISECONDS.toSeconds(execTime));
        boolean bl = hasDaysFormat = format.indexOf("%DD") >= 0 || format.indexOf("%?DD") >= 0;
        if (!hasDaysFormat) {
            hours = hoursAbs;
        }
        String execTimeDD = String.format("%d", days);
        String execTimeHH = String.format("%02d", hours);
        String execTimeMM = String.format("%02d", minutes);
        String execTimeSS = String.format("%02d", seconds);
        String execTimeMs = String.format("%03d", millis);
        String tagStrHH = "%?HH";
        if (format.indexOf(tagStrHH) >= 0) {
            String withinSquareBrakets = "";
            int tagStartPos = format.indexOf(tagStrHH + "[");
            if (tagStartPos >= 0) {
                int tagEndPos = format.indexOf("]", tagStartPos);
                if (tagEndPos >= 0) {
                    withinSquareBrakets = format.substring(tagStartPos + (tagStrHH + "[").length(), tagEndPos);
                }
                tagStrHH = tagStrHH + "[" + withinSquareBrakets + "]";
            }
            format = hoursAbs == 0L ? format.replace(tagStrHH, "") : format.replace(tagStrHH, execTimeHH + withinSquareBrakets);
        }
        if (format.indexOf(tagStrDay = "%?DD") >= 0) {
            String withinSquareBrakets = "";
            int tagStartPos = format.indexOf(tagStrDay + "[");
            if (tagStartPos >= 0) {
                int tagEndPos = format.indexOf("]", tagStartPos);
                if (tagEndPos >= 0) {
                    withinSquareBrakets = format.substring(tagStartPos + (tagStrDay + "[").length(), tagEndPos);
                }
                tagStrDay = tagStrDay + "[" + withinSquareBrakets + "]";
            }
            format = days == 0L ? format.replace(tagStrDay, "") : format.replace(tagStrDay, execTimeDD + withinSquareBrakets);
        }
        format = format.replace("%DD", execTimeDD);
        format = format.replace("%HH", execTimeHH);
        format = format.replace("%MM", execTimeMM);
        format = format.replace("%SS", execTimeSS);
        format = format.replace("%ms", execTimeMs);
        return format;
    }

    public static String msToTimeStrDHMSms(long duration) {
        String res = "";
        long days = TimeUnit.MILLISECONDS.toDays(duration);
        long hours = TimeUnit.MILLISECONDS.toHours(duration) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(duration));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration));
        long millis = TimeUnit.MILLISECONDS.toMillis(duration) - TimeUnit.SECONDS.toMillis(TimeUnit.MILLISECONDS.toSeconds(duration));
        res = days == 0L ? String.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, millis) : String.format("%dd %02d:%02d:%02d.%03d", days, hours, minutes, seconds, millis);
        return res;
    }

    public static String msToTimeStrDHMS(long duration) {
        String res = "";
        long days = TimeUnit.MILLISECONDS.toDays(duration);
        long hours = TimeUnit.MILLISECONDS.toHours(duration) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(duration));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration));
        res = days == 0L ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%dd %02d:%02d:%02d", days, hours, minutes, seconds);
        return res;
    }

    public static String usToTimeStrDHMS(long duration) {
        String res = "";
        long days = TimeUnit.MICROSECONDS.toDays(duration);
        long hours = TimeUnit.MICROSECONDS.toHours(duration) - TimeUnit.DAYS.toHours(TimeUnit.MICROSECONDS.toDays(duration));
        long minutes = TimeUnit.MICROSECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MICROSECONDS.toHours(duration));
        long seconds = TimeUnit.MICROSECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MICROSECONDS.toMinutes(duration));
        res = days == 0L ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%dd %02d:%02d:%02d", days, hours, minutes, seconds);
        return res;
    }

    public static int datediff(int type, Date startDate, Date endDate) {
        return TimeUtils.datediff(type, startDate.getTime(), endDate.getTime());
    }

    public static int datediff(int type, long startDate, long endDate) {
        long diffInSec = endDate / 1000L - startDate / 1000L;
        long ret = 0L;
        switch (type) {
            case 0: {
                ret = endDate - startDate;
                break;
            }
            case 1: {
                ret = diffInSec;
                break;
            }
            case 2: {
                ret = diffInSec / 60L;
                break;
            }
            case 3: {
                ret = diffInSec / 60L / 60L;
                break;
            }
            case 4: {
                ret = diffInSec / 60L / 60L / 24L;
                break;
            }
            case 5: {
                ret = diffInSec / 60L / 60L / 24L / 7L;
                break;
            }
            case 6: {
                ret = diffInSec / 2628000L;
            }
        }
        return (int)ret;
    }

    public static Timestamp parseToTimestampX(String str) throws ParseException {
        ArrayList<String> knownPatterns = new ArrayList<String>();
        knownPatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        knownPatterns.add("yyyy-MM-dd' 'HH:mm:ss.SSS");
        knownPatterns.add("yyyy-MM-dd' 'HH:mm:ss");
        knownPatterns.add("yyyy-MM-dd' 'HH:mm");
        knownPatterns.add("yyyy-MM-dd' 'HH");
        knownPatterns.add("yyyy-MM-dd");
        for (String pattern : knownPatterns) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                Date date = sdf.parse(str);
                return new Timestamp(date.getTime());
            }
            catch (ParseException parseException) {
            }
        }
        throw new ParseException("No known Date format found for '" + str + "', tested following patterns " + knownPatterns + ".", 0);
    }

    public static Timestamp parseToTimestampNoThrow(String str, Timestamp defaultVal) {
        try {
            return TimeUtils.parseToTimestamp(str, "yyyy-MM-dd HH:mm:ss.SSS");
        }
        catch (ParseException ex) {
            return defaultVal;
        }
    }

    public static Timestamp parseToTimestamp(String str) throws ParseException {
        return TimeUtils.parseToTimestamp(str, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public static Timestamp parseToTimestamp(String str, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date date = dateFormat.parse(str);
        Timestamp ts = new Timestamp(date.getTime());
        return ts;
    }

    public static Timestamp parseToUtcTimestamp(String str, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = dateFormat.parse(str);
        Timestamp ts = new Timestamp(date.getTime());
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp parseToTimestampIso8601(String str) throws ParseException {
        SimpleDateFormat simpleDateFormat = ISO8601_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            Date date = ISO8601_DATE_FORMAT.parse(str);
            Timestamp ts = new Timestamp(date.getTime());
            return ts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toStringIso8601(Timestamp ts) {
        SimpleDateFormat simpleDateFormat = ISO8601_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return ISO8601_DATE_FORMAT.format(ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toStringIso8601(long ts) {
        SimpleDateFormat simpleDateFormat = ISO8601_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return ISO8601_DATE_FORMAT.format(new Date(ts));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Timestamp ts) {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.format(ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Date ts) {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.format(ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(long ts) {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.format(new Date(ts));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toStringUtc(long ts) {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return UTC_DATE_FORMAT.format(new Date(ts));
        }
    }

    public static String toStringYmdHm(Timestamp ts) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return sdf.format(ts);
    }

    public static String toStringYmdHms(Timestamp ts) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(ts);
    }

    public static String getCurrentTimeForFileNameYmdHmsMs(long ts) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HHmmss_SSS");
        return sdf.format(new Date(ts));
    }

    public static String getCurrentTimeForFileNameYmdHmsMs() {
        return TimeUtils.getCurrentTimeForFileNameYmdHmsMs(System.currentTimeMillis());
    }

    public static String getCurrentTimeForFileNameYmdHms(long ts) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
        return sdf.format(new Date(ts));
    }

    public static String getCurrentTimeForFileNameYmdHms() {
        return TimeUtils.getCurrentTimeForFileNameYmdHms(System.currentTimeMillis());
    }

    public static String getCurrentTimeForFileNameYmdHm(long ts) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HHmm");
        return sdf.format(new Date(ts));
    }

    public static String getCurrentTimeForFileNameYmdHm() {
        return TimeUtils.getCurrentTimeForFileNameYmdHm(System.currentTimeMillis());
    }

    public static String getCurrentTimeForFileNameYmd(long ts) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date(ts));
    }

    public static String getCurrentTimeForFileNameYmd() {
        return TimeUtils.getCurrentTimeForFileNameYmdHms(System.currentTimeMillis());
    }

    public static String getCurrentTimeForFileNameHms(long ts) {
        SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
        return sdf.format(new Date(ts));
    }

    public static String getCurrentTimeForFileNameHms() {
        return TimeUtils.getCurrentTimeForFileNameYmdHms(System.currentTimeMillis());
    }

    public static String getCurrentTimeForFileNameHm(long ts) {
        SimpleDateFormat sdf = new SimpleDateFormat("HHmm");
        return sdf.format(new Date(ts));
    }

    public static String getCurrentTimeForFileNameHm() {
        return TimeUtils.getCurrentTimeForFileNameYmdHm(System.currentTimeMillis());
    }

    public static String strftime(String string) {
        Strftime strftime = new Strftime(string);
        return strftime.format(new Date());
    }

    private static void test(String format, String expected, long ms) {
        String result = TimeUtils.msToTimeStr(format, ms);
        if (expected.equals(result)) {
            System.out.println("  OK: result '" + result + "' equals expected value '" + expected + "'.");
        } else {
            System.out.println("FAIL: result '" + result + "' IS NOT equal the expected value '" + expected + "'.");
        }
    }

    public static void main(String[] args) {
        TimeUtils.test("%MM:%SS.%ms", "00:10.000", 10000L);
        TimeUtils.test("%MM:%SS.%ms", "01:01.000", 61000L);
        TimeUtils.test("%?HH[:]%MM:%SS.%ms", "01:01.000", 61000L);
        TimeUtils.test("%?HH[:]%MM:%SS.%ms", "01:01:01.000", 3661000L);
        TimeUtils.test("%?HH[---]%MM:%SS.%ms", "01:01.000", 61000L);
        TimeUtils.test("%?HH[---]%MM:%SS.%ms", "01---01:01.000", 3661000L);
        TimeUtils.test("%?HH[---]%MM:%SS.%ms", "24---01:01.000", 86461000L);
        TimeUtils.test("%?DD[d ]%?HH[---]%MM:%SS.%ms", "1d 04---01:01.000", 100861000L);
        TimeUtils.test("%?DD[d ]%?HH[---]%MM:%SS.%ms", "7d 23---01:02.000", 687662000L);
        TimeUtils.test("%?DD[ days, ]%?HH[---]%MM:%SS.%ms", "23 days, 23---01:02.000", 2070062000L);
        TimeUtils.test("%?DD[ days, ]%?HH[---]%MM:%SS.%ms", "999 days, 23---01:02.000", 86396462000L);
        TimeUtils.test("%?DD[ days, ]%?HH[---]%MM:%SS.%ms", "01:02.000", 62000L);
        TimeUtils.test("%?DD[ days, ]%?HH[---]%HH:%MM", "00:01", 62000L);
        TimeUtils.test("%?DD[d ]%HH:%MM", "1d 01:02", 90122000L);
        TimeUtils.test("%?DD[d ]%HH:%MM", "01:02", 3722000L);
    }

    static {
        ISO8601_UTC_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        UTC_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        _timeExpiredMap = new HashMap();
    }
}

