/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.wqs;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.collectors.records.AuditRecord;

public class WriterQueueContainer {
    private static Logger _logger = LogManager.getLogger();
    protected Timestamp _mainSampleTime = null;
    protected String _serverName = null;
    protected String _onHostname = null;
    private List<AuditRecord> _auditRecords = null;

    private WriterQueueContainer(Timestamp mainSampleTime, String serverName, String onHostname) {
        this._mainSampleTime = mainSampleTime;
        this._serverName = serverName;
        this._onHostname = onHostname;
    }

    public WriterQueueContainer(HeaderInfo headerInfo) {
        this(headerInfo.getMainSampleTime(), headerInfo.getServerName(), headerInfo.getOnHostname());
    }

    public void setMainSampleTime(Timestamp mainSampleTime) {
        this._mainSampleTime = mainSampleTime;
    }

    public void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public void setOnHostname(String onHostname) {
        this._onHostname = onHostname;
    }

    public Timestamp getMainSampleTime() {
        return this._mainSampleTime;
    }

    public String getServerName() {
        return this._serverName;
    }

    public String getOnHostname() {
        return this._onHostname;
    }

    public void add(AuditRecord auditRecord) {
        if (auditRecord == null) {
            return;
        }
        auditRecord.setContainer(this);
        if (this._auditRecords == null) {
            this._auditRecords = new ArrayList<AuditRecord>(200);
        }
        this._auditRecords.add(auditRecord);
    }

    public List<AuditRecord> getAuditRecords() {
        if (this._auditRecords == null) {
            return Collections.emptyList();
        }
        return this._auditRecords;
    }

    public boolean isEmpty() {
        return this.getAuditRecords().isEmpty();
    }

    public int size() {
        return this.getAuditRecords().size();
    }

    public boolean equals(WriterQueueContainer pc) {
        if (pc == null) {
            return false;
        }
        if (this._mainSampleTime == null) {
            return false;
        }
        return this._mainSampleTime.equals(pc.getMainSampleTime());
    }

    public static class HeaderInfo {
        private Timestamp _mainSampleTime;
        private String _serverName;
        private String _onHostname;

        public HeaderInfo() {
        }

        public Timestamp getMainSampleTime() {
            return this._mainSampleTime;
        }

        public void setMainSampleTime(Timestamp ts) {
            this._mainSampleTime = ts;
        }

        public String getServerName() {
            return this._serverName;
        }

        public String getOnHostname() {
            return this._onHostname;
        }

        public HeaderInfo(Timestamp mainSampleTime, String serverName, String onHostname) {
            this._mainSampleTime = mainSampleTime;
            this._serverName = serverName;
            this._onHostname = onHostname;
        }
    }
}

