/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.wqs;

import java.sql.Timestamp;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.collectors.records.AuditRecord;
import sek.ase.auditor.utils.Configuration;
import sek.ase.auditor.utils.Memory;
import sek.ase.auditor.utils.StringUtil;
import sek.ase.auditor.utils.TimeUtils;
import sek.ase.auditor.wqs.WriterQueueContainer;
import sek.ase.auditor.wqs.WriterQueueStatistics;
import sek.ase.auditor.wqs.consumers.IWriterConsumer;

public class WriterQueueHandler
implements Runnable {
    private static Logger _logger = LogManager.getLogger();
    public static final String PROPKEY_warnQueueSizeThresh = "WriterQueueHandler.warnQueueSizeThresh";
    public static final int DEFAULT_warnQueueSizeThresh = 3;
    public static final String PROPKEY_writeInfoOnEachConsumerWrite = "WriterQueueHandler.writeInfoOnEachConsumeWrite";
    public static final boolean DEFAULT_writeInfoOnEachConsumerWrite = false;
    public static final String PROPKEY_statisticsMessagePeriodSeconds = "WriterQueueHandler.statistics.message.period.seconds";
    public static final int DEFAULT_statisticsMessagePeriodSeconds = 300;
    public static final String PROPKEY_WriterClass = "WriterQueueHandler.WriterClass";
    public static final String DEFAULT_WriterClass = null;
    private static WriterQueueHandler _instance = null;
    private boolean _initialized = false;
    private boolean _running = false;
    private Thread _thread = null;
    private Configuration _conf;
    private List<IWriterConsumer> _writerClasses = new LinkedList<IWriterConsumer>();
    private long _currentConsumeStartTime = 0L;
    private BlockingQueue<WriterQueueContainer> _containerQueue = new LinkedBlockingQueue<WriterQueueContainer>();
    private int _warnQueueSizeThresh = 3;
    private long _maxConsumeTime = 0L;
    private long _maxConsumeTimeStamp = System.currentTimeMillis();
    private boolean _writeInfoOnEachConsumerWrite = false;
    private long _statisticsMessageLastTime = System.currentTimeMillis();
    private long _statisticsMessagePeriodSec = 300L;
    private int _lowOnMemoryHandlerCalls = 0;
    private int _lowOnMemoryHandlerCallsThreshold = 20;
    private int _outOfMemoryHandlerCallCount = 0;
    Set<WriterQueueChangeListener> _queueChangeListeners = new HashSet<WriterQueueChangeListener>();
    private int _maxLenPersistWriterName = 0;
    private int _maxLenServerName = 0;

    public Configuration getConfig() {
        return this._conf;
    }

    public String getConfigStr() {
        String configStr = "";
        for (IWriterConsumer pw : this._writerClasses) {
            configStr = configStr + pw.getName() + "={" + pw.getConfigStr() + "}, ";
        }
        if (configStr.length() > 0) {
            configStr = configStr.substring(0, configStr.length() - 2);
        }
        return configStr;
    }

    public synchronized void init(Configuration props) throws Exception {
        this._conf = props;
        _logger.info("Initializing the 'Writer Queue Handler' functionality.");
        this._warnQueueSizeThresh = this._conf.getIntProperty(PROPKEY_warnQueueSizeThresh, 3);
        this._writeInfoOnEachConsumerWrite = this._conf.getBooleanProperty(PROPKEY_writeInfoOnEachConsumerWrite, false);
        this._statisticsMessagePeriodSec = this._conf.getLongProperty(PROPKEY_statisticsMessagePeriodSeconds, 300L);
        String writerClasses = this._conf.getProperty(PROPKEY_WriterClass, DEFAULT_WriterClass);
        int len = 60;
        _logger.info("Configuration for 'WriterQueueHandler', with full class name '" + this.getClass().getName() + "'.");
        _logger.info("                   " + StringUtil.left(PROPKEY_WriterClass, len) + " = " + writerClasses);
        _logger.info("                   " + StringUtil.left(PROPKEY_warnQueueSizeThresh, len) + " = " + this._warnQueueSizeThresh);
        _logger.info("                   " + StringUtil.left(PROPKEY_writeInfoOnEachConsumerWrite, len) + " = " + this._writeInfoOnEachConsumerWrite);
        _logger.info("                   " + StringUtil.left(PROPKEY_statisticsMessagePeriodSeconds, len) + " = " + this._statisticsMessagePeriodSec);
        if (writerClasses == null) {
            _logger.info("No counters will be persisted. The property 'WriterQueueHandler.WriterClass' is not found in configuration for the WriterQueueHandler module. It should contain one or several classes that implemets the IWriterConsumer interface. If you have more than one writer, specify them as a comma separated list.");
        } else {
            String[] writerClassArray = writerClasses.split(",");
            for (int i = 0; i < writerClassArray.length; ++i) {
                IWriterConsumer writerClass;
                writerClassArray[i] = writerClassArray[i].trim();
                String writerClassName = writerClassArray[i];
                _logger.debug("Instantiating and Initializing WriterClass='" + writerClassName + "'.");
                try {
                    Class<?> c = Class.forName(writerClassName);
                    writerClass = (IWriterConsumer)c.newInstance();
                    this._writerClasses.add(writerClass);
                }
                catch (ClassCastException e) {
                    throw new ClassCastException("When trying to load writerWriter class '" + writerClassName + "'. The writerWriter do not seem to follow the interface 'sek.ase.auditor.wqs.consumers.IWriterConsumer'");
                }
                catch (ClassNotFoundException e) {
                    throw new ClassNotFoundException("Tried to load writerWriter class '" + writerClassName + "'.", e);
                }
                writerClass.init(this._conf);
                writerClass.printConfig();
                writerClass.startServices();
            }
            if (this._writerClasses.size() == 0) {
                _logger.warn("No Persistent Counter Writers has been installed, NO counters will be saved.");
            }
        }
        this._initialized = true;
    }

    public static WriterQueueHandler getInstance() {
        return _instance;
    }

    public static boolean hasInstance() {
        return _instance != null;
    }

    public static void setInstance(WriterQueueHandler inst) {
        _instance = inst;
    }

    public void lowOnMemoryHandler() {
        ++this._lowOnMemoryHandlerCalls;
        if (this._lowOnMemoryHandlerCalls > this._lowOnMemoryHandlerCallsThreshold) {
            _logger.warn("Persistant Counter Handler, lowOnMemoryHandler() has now been called " + this._lowOnMemoryHandlerCalls + " times, decided to call outOfMemoryHandler() to do more extensive cleanup.");
            this.outOfMemoryHandler();
            this._lowOnMemoryHandlerCalls = 0;
            return;
        }
        boolean fire = false;
        if (fire) {
            this.fireQueueSizeChange();
        }
    }

    public void outOfMemoryHandler() {
        ++this._outOfMemoryHandlerCallCount;
        _logger.warn("Persistant Counter Handler, outOfMemoryHandler() was called. callCount=" + this._outOfMemoryHandlerCallCount + ".");
        boolean fire = false;
        if (this._outOfMemoryHandlerCallCount > 3) {
            _logger.warn("Persistant Counter Handler, outOfMemoryHandler() was called. Emtying the Counter Store/Write queue, which has " + this._containerQueue.size() + " entries.");
            this._containerQueue.clear();
            this._outOfMemoryHandlerCallCount = 0;
            fire = true;
        }
        if (fire) {
            this.fireQueueSizeChange();
        }
    }

    public void add(WriterQueueContainer cont) {
        if (this._writerClasses.size() == 0) {
            return;
        }
        if (!this.isRunning()) {
            _logger.warn("The Persistent Counter Handler is not running, discarding entry.");
            return;
        }
        int qsize = this._containerQueue.size();
        if (qsize > this._warnQueueSizeThresh) {
            long currentConsumeTimeMs = System.currentTimeMillis() - this._currentConsumeStartTime;
            String currentConsumeTimeStr = "The consumer is currently not active. ";
            if (this._currentConsumeStartTime > 0L) {
                currentConsumeTimeStr = "The current consumer has been active for " + TimeUtils.msToTimeStr(currentConsumeTimeMs) + ". ";
            }
            _logger.warn("The persistent queue has " + qsize + " entries. The persistent writer might not keep in pace. " + currentConsumeTimeStr);
            for (IWriterConsumer pw : this._writerClasses) {
                pw.queueSizeWarning(qsize, this._warnQueueSizeThresh);
            }
        }
        this._containerQueue.add(cont);
        this.fireQueueSizeChange();
    }

    private void isInitialized() {
        if (!this._initialized) {
            throw new RuntimeException("The Persistent Counter Handler module has NOT yet been initialized.");
        }
    }

    private void consume(WriterQueueContainer cont, long prevConsumeTimeMs) {
        for (IWriterConsumer pw : this._writerClasses) {
            if (!this.isRunning()) {
                _logger.info("The service is about to stop, discarding a consume(ObjectLookupQueueEntry:Input) queue entry.");
                continue;
            }
            long startTime = System.currentTimeMillis();
            try {
                pw.beginOfSample(cont);
                pw.saveSample(cont);
                for (AuditRecord alarmRecord : cont.getAuditRecords()) {
                    pw.saveRecord(alarmRecord);
                }
                pw.endOfSample(cont, false);
                long execTime = TimeUtils.msDiffNow(startTime);
                this.setConsumeTime(execTime);
                this.firePcsConsumeInfo(pw.getName(), cont.getServerName(), cont.getMainSampleTime(), (int)execTime, pw.getStatistics());
            }
            catch (Throwable t) {
                _logger.error("The Persistent Writer got runtime error in consume() in Persistent Writer named '" + pw.getName() + "'. Continuing with next Writer...", t);
                pw.endOfSample(cont, true);
            }
        }
        if (TimeUtils.secondsDiffNow(this._statisticsMessageLastTime) >= this._statisticsMessagePeriodSec) {
            this._statisticsMessageLastTime = System.currentTimeMillis();
            for (IWriterConsumer pw : this._writerClasses) {
                String writerName = pw.getName();
                WriterQueueStatistics writerStats = pw.getStatistics();
                _logger.info("STATISTICS[" + writerName + "]: " + writerStats);
            }
        }
    }

    private void setConsumeTime(long lastExecTime) {
        if (lastExecTime > this._maxConsumeTime) {
            this._maxConsumeTime = lastExecTime;
            this._maxConsumeTimeStamp = System.currentTimeMillis();
        }
    }

    public long getMaxConsumeTime() {
        return this._maxConsumeTime;
    }

    @Override
    public void run() {
        String threadName = this._thread.getName();
        _logger.info("Starting a thread for the module '" + threadName + "'.");
        this.isInitialized();
        this._running = true;
        long prevConsumeTimeMs = 0L;
        while (this.isRunning()) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Thread '" + threadName + "', waiting on queue...");
            }
            try {
                WriterQueueContainer cont = this._containerQueue.take();
                this.fireQueueSizeChange();
                if (cont == null || cont != null && cont.isEmpty()) continue;
                if (!this.isRunning()) {
                    _logger.info("The service is about to stop, discarding a consume(WriterQueueContainer) queue entry.");
                    continue;
                }
                this._currentConsumeStartTime = System.currentTimeMillis();
                long startTime = System.currentTimeMillis();
                this.consume(cont, prevConsumeTimeMs);
                long stopTime = System.currentTimeMillis();
                this._currentConsumeStartTime = 0L;
                prevConsumeTimeMs = stopTime - startTime;
                _logger.debug("It took " + prevConsumeTimeMs + " ms to persist the above information (using all writers).");
            }
            catch (InterruptedException ex) {
                this._running = false;
            }
        }
        _logger.info("Emptying the queue for module '" + threadName + "', which had " + this._containerQueue.size() + " entries.");
        this._containerQueue.clear();
        this.fireQueueSizeChange();
        _logger.info("Thread '" + threadName + "' was stopped.");
    }

    public boolean isRunning() {
        return this._running;
    }

    public void start() {
        if (this._writerClasses.size() == 0) {
            _logger.warn("No Persistent Counter Writers has been installed, The service thread will NOT be started and NO counters will be saved.");
            return;
        }
        this.isInitialized();
        this._thread = new Thread(this);
        this._thread.setName("WriterQueueHandler");
        this._thread.setDaemon(true);
        this._thread.start();
    }

    public void stop(boolean clearQueues, int maxWaitTimeInMs) {
        this._running = false;
        if (clearQueues) {
            this._containerQueue.clear();
            this.fireQueueSizeChange();
        }
        if (this._thread != null) {
            this._thread.interrupt();
        }
        for (IWriterConsumer pw : this._writerClasses) {
            pw.stopServices(maxWaitTimeInMs);
            pw.close();
        }
        try {
            this._thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._thread = null;
        _logger.info("Done Stopping all Writers.");
    }

    public boolean hasWriters() {
        return this._writerClasses.size() > 0;
    }

    public List<IWriterConsumer> getWriters() {
        return this._writerClasses;
    }

    public void addChangeListener(WriterQueueChangeListener l) {
        this._queueChangeListeners.add(l);
    }

    public void removeChangeListener(WriterQueueChangeListener l) {
        this._queueChangeListeners.remove(l);
    }

    protected void fireQueueSizeChange() {
        int pcsQueueSize = this._containerQueue.size();
        for (WriterQueueChangeListener l : this._queueChangeListeners) {
            l.queueChange(pcsQueueSize);
        }
    }

    public void firePcsConsumeInfo(String persistWriterName, String serverName, Timestamp mainSampleTime, int persistTimeInMs, WriterQueueStatistics writerQueueStatistics) {
        int pcsQueueSize = this._containerQueue.size();
        if (persistWriterName == null) {
            persistWriterName = "-unknown-";
        }
        if (serverName == null) {
            serverName = "-unknown-";
        }
        this._maxLenPersistWriterName = Math.max(this._maxLenPersistWriterName, persistWriterName.length());
        this._maxLenServerName = Math.max(this._maxLenServerName, serverName.length());
        if (this._writeInfoOnEachConsumerWrite) {
            _logger.info("Persisting Counters using " + StringUtil.left("'" + persistWriterName + "', ", this._maxLenPersistWriterName + 4) + "for serverName=" + StringUtil.left("'" + serverName + "', ", this._maxLenServerName + 4) + "mainSampleTime='" + StringUtil.left(mainSampleTime + "", 23) + "'. This persist took [" + TimeUtils.msToTimeStrShort(persistTimeInMs) + "] " + StringUtil.left(persistTimeInMs + " ms. ", 10) + "qs=" + StringUtil.left(pcsQueueSize + ".", 4) + "jvmMemoryLeftInMB=" + Memory.getMemoryLeftInMB() + ". " + (writerQueueStatistics == null ? "" : writerQueueStatistics));
        }
        for (WriterQueueChangeListener l : this._queueChangeListeners) {
            l.consumeInfo(persistWriterName, mainSampleTime, persistTimeInMs, writerQueueStatistics);
        }
    }

    public static interface WriterQueueChangeListener {
        public void queueChange(int var1);

        public void consumeInfo(String var1, Timestamp var2, int var3, WriterQueueStatistics var4);
    }
}

