/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.wqs.consumers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.Version;
import sek.ase.auditor.collectors.records.AuditRecord;
import sek.ase.auditor.utils.Configuration;
import sek.ase.auditor.utils.StringUtil;
import sek.ase.auditor.utils.TimeUtils;
import sek.ase.auditor.wqs.WriterQueueContainer;
import sek.ase.auditor.wqs.WriterQueueStatistics;
import sek.ase.auditor.wqs.consumers.IWriterConsumer;

public class WriterToFile
implements IWriterConsumer,
Runnable {
    private static Logger _logger = LogManager.getLogger();
    public static final String PROPKEY_saveThreadCount = "WriterToFile.saveThreadCount";
    public static final int DEFAULT_saveThreadCount = 1;
    public static final String PROPKEY_saveDir = "WriterToFile.saveDir";
    public static final String DEFAULT_saveDir = System.getProperty("java.io.tmpdir") + Version.getAppName() + "/WriterToFile";
    public static final String PROPKEY_jsonPrettyPrint = "WriterToFile.json.prettyPrint";
    public static final boolean DEFAULT_jsonPrettyPrint = false;
    private String _saveDir = DEFAULT_saveDir;
    private boolean _jsonPrettyPrint = false;
    private Configuration _conf;
    private int _threadCount;
    private List<FileSaver> _writers = new ArrayList<FileSaver>();
    WriterQueueStatisticsLocal _stats = new WriterQueueStatisticsLocal();
    private BlockingQueue<AuditRecord> _auditRecordQueue = new LinkedBlockingQueue<AuditRecord>();

    @Override
    public void init(Configuration conf) throws Exception {
        this._conf = conf;
        this._saveDir = this._conf.getProperty(PROPKEY_saveDir, DEFAULT_saveDir);
        this._jsonPrettyPrint = this._conf.getBooleanProperty(PROPKEY_jsonPrettyPrint, false);
        this._threadCount = this._conf.getIntProperty(PROPKEY_saveThreadCount, 1);
        if (this._threadCount <= 0) {
            throw new Exception("Number of threads cant be " + this._threadCount + ". Change this to be 1 or above. Config: " + PROPKEY_saveThreadCount + " = " + 1);
        }
        if (StringUtil.isNullOrBlank(this._saveDir)) {
            throw new Exception("Save Dir cant be empty. Config: WriterToFile.saveDir = /full/path/to/save/dir");
        }
        File f = new File(this._saveDir);
        if (!f.exists()) {
            throw new Exception("Save Directory '" + f + "' does NOT exist. Please create it.");
        }
        File tmpFileName = new File(this._saveDir, "dummyFile.deleteme");
        try {
            FileUtils.writeStringToFile((File)tmpFileName, (String)"Test String", (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new Exception("Problems writing a test file in directory '" + f + "'. Caught:" + ex, ex);
        }
        finally {
            tmpFileName.delete();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Configuration getConfig() {
        return this._conf;
    }

    @Override
    public String getConfigStr() {
        return "";
    }

    @Override
    public void printConfig() {
        int len = 40;
        _logger.info("Configuration for '" + this.getName() + "', with full class name '" + this.getClass().getName() + "'.");
        _logger.info("                   " + StringUtil.left(PROPKEY_saveDir, len) + " = " + this._saveDir);
        _logger.info("                   " + StringUtil.left(PROPKEY_jsonPrettyPrint, len) + " = " + this._jsonPrettyPrint);
        _logger.info("                   " + StringUtil.left(PROPKEY_saveThreadCount, len) + " = " + this._threadCount);
    }

    @Override
    public void beginOfSample(WriterQueueContainer cont) {
    }

    @Override
    public void saveSample(WriterQueueContainer cont) {
    }

    @Override
    public void saveRecord(AuditRecord ar) {
        this._auditRecordQueue.add(ar);
    }

    @Override
    public void endOfSample(WriterQueueContainer cont, boolean caughtErrors) {
    }

    @Override
    public void startServices() throws Exception {
        _logger.info("Starting " + this._threadCount + " FileSaver(s).");
        for (int i = 0; i < this._threadCount; ++i) {
            FileSaver fs = new FileSaver(this, i);
            fs.start();
            this._writers.add(fs);
        }
    }

    @Override
    public void stopServices(int maxWaitTimeInMs) {
        _logger.info("Stopping " + this._writers.size() + " FileSaver(s).");
        for (FileSaver splunkSender : this._writers) {
            splunkSender.stop();
        }
        for (FileSaver fileSaver : this._writers) {
            try {
                fileSaver._thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        _logger.info("Done Stopping " + this._writers.size() + " FileSaver(s).");
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void queueSizeWarning(int queueSize, int thresholdSize) {
    }

    @Override
    public WriterQueueStatistics getStatistics() {
        return this._stats;
    }

    @Override
    public void resetStatistics() {
    }

    @Override
    public void run() {
    }

    private static class FileSaver
    implements Runnable {
        private Thread _thread;
        private WriterToFile _parent;
        private int _id;
        private boolean _running;

        public String getName() {
            return "FileSaver-" + this._id;
        }

        public FileSaver(WriterToFile parent, int id) {
            this._parent = parent;
            this._id = id + 1;
        }

        public void start() {
            this._thread = new Thread((Runnable)this, this.getName());
            this._thread.setDaemon(true);
            this._thread.start();
        }

        public void stop() {
            if (this._thread != null) {
                this._thread.interrupt();
            }
        }

        public boolean isRunning() {
            return this._running;
        }

        @Override
        public void run() {
            this._running = true;
            _logger.info("Starting Thread for: " + this.getName());
            while (this._running) {
                try {
                    AuditRecord auditRecord = (AuditRecord)this._parent._auditRecordQueue.take();
                    if (auditRecord == null || auditRecord != null && auditRecord.isEmpty() || !this.isIncluded(auditRecord)) continue;
                    if (!this.isRunning()) {
                        _logger.info("The service is about to stop, discarding a consume(AuditRecord) queue entry.");
                        continue;
                    }
                    this.consume(auditRecord);
                }
                catch (InterruptedException ex) {
                    _logger.info("Received 'InterruptedException' in '" + this.getName() + "', time to stop...");
                    this._running = false;
                }
                catch (Throwable t) {
                    _logger.error("Found some issue in '" + this.getName() + "', continuing with next message. Caught: " + t, t);
                }
            }
            _logger.info("Ending Thread for " + this.getName());
        }

        private boolean isIncluded(AuditRecord auditRecord) {
            return true;
        }

        private void consume(AuditRecord auditRecord) {
            try {
                StringWriter sw = new StringWriter();
                JsonFactory jfactory = new JsonFactory();
                JsonGenerator gen = jfactory.createGenerator((Writer)sw);
                if (this._parent._jsonPrettyPrint) {
                    gen.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
                }
                gen.setCodec((ObjectCodec)new ObjectMapper(jfactory));
                auditRecord.createJson(gen);
                gen.close();
                String jsonStr = sw.toString();
                String ts = TimeUtils.getCurrentTimeForFileNameYmdHmsMs();
                long nanoTs = System.nanoTime();
                File fileName = new File(this._parent._saveDir, this.getName() + "." + ts + "." + nanoTs + ".json");
                FileUtils.writeStringToFile((File)fileName, (String)jsonStr, (Charset)StandardCharsets.UTF_8);
                _logger.info(this.getName() + ": Saved JSON content to file '" + fileName + "'.");
                this._parent._stats.incrementSaveCount();
            }
            catch (IOException ex) {
                _logger.error("Problems saving JSON message to File.", (Throwable)ex);
                this._parent._stats.incrementFailCount();
            }
        }
    }

    private static class WriterQueueStatisticsLocal
    extends WriterQueueStatistics {
        private AtomicLong _totalSaveCount = new AtomicLong();
        private AtomicLong _totalFailCount = new AtomicLong();
        private long _lastTotalSaveCount = 0L;
        private long _lastTotalFailCount = 0L;

        private WriterQueueStatisticsLocal() {
        }

        public long incrementSaveCount() {
            return this._totalSaveCount.incrementAndGet();
        }

        public long incrementFailCount() {
            return this._totalFailCount.incrementAndGet();
        }

        @Override
        public String toString() {
            long tmpTotalSaveCount = this._totalSaveCount.get();
            long tmpTotalFailCount = this._totalFailCount.get();
            long diffTotalSaveCount = tmpTotalSaveCount - this._lastTotalSaveCount;
            long diffTotalFailCount = tmpTotalFailCount - this._lastTotalFailCount;
            this._lastTotalSaveCount = tmpTotalSaveCount;
            this._lastTotalFailCount = tmpTotalFailCount;
            return "totalSendCount=" + this._totalSaveCount + " (" + diffTotalSaveCount + "), totalFailCount=" + this._totalFailCount + " (" + diffTotalFailCount + ")";
        }
    }
}

