/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.wqs.consumers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.collectors.records.AuditRecord;
import sek.ase.auditor.utils.Configuration;
import sek.ase.auditor.utils.StringUtil;
import sek.ase.auditor.wqs.WriterQueueContainer;
import sek.ase.auditor.wqs.WriterQueueStatistics;
import sek.ase.auditor.wqs.consumers.IWriterConsumer;

public class WriterToSplunk
implements IWriterConsumer,
Runnable {
    private static Logger _logger = LogManager.getLogger();
    public static final String PROPKEY_senderThreadCount = "WriterToSplunk.senderThreadCount";
    public static final int DEFAULT_senderThreadCount = 3;
    public static final String PROPKEY_splunkUrl = "WriterToSplunk.url";
    public static final String DEFAULT_splunkUrl = null;
    public static final String PROPKEY_splunkAccessToken = "WriterToSplunk.access.token";
    public static final String DEFAULT_splunkAccessToken = null;
    public static final String PROPKEY_jsonPrettyPrint = "WriterToSplunk.json.prettyPrint";
    public static final boolean DEFAULT_jsonPrettyPrint = false;
    public static final String PROPKEY_printJsonBeforeSend = "WriterToSplunk.json.printBeforeSend";
    public static final boolean DEFAULT_printJsonBeforeSend = false;
    public static final String PROPKEY_json_onErrorPrintXchars = "WriterToSplunk.json.on.error.print.numOfChars";
    public static final int DEFAULT_json_onErrorPrintXchars = 512;
    public static final String PROPKEY_httpConnPoolMaxSize = "WriterToSplunk.http.conn.pool.maxSize";
    public static final int DEFAULT_httpConnPoolMaxSize = 100;
    public static final String PROPKEY_httpConnPoolMaxSizePerRoute = "WriterToSplunk.http.conn.pool.maxSizePerRoute";
    public static final int DEFAULT_httpConnPoolMaxSizePerRoute = 20;
    private String _splunkUrl = DEFAULT_splunkUrl;
    private String _splunkAccessToken = DEFAULT_splunkAccessToken;
    private boolean _jsonPrettyPrint = false;
    private boolean _jsonPrintBeforeSend = false;
    private Configuration _conf;
    private int _threadCount;
    private List<SplunkSender> _senders = new ArrayList<SplunkSender>();
    WriterQueueStatisticsLocal _stats = new WriterQueueStatisticsLocal();
    private BlockingQueue<AuditRecord> _auditRecordQueue = new LinkedBlockingQueue<AuditRecord>();
    PoolingHttpClientConnectionManager _apacheHttpConnectionManager;

    @Override
    public void init(Configuration conf) throws Exception {
        this._conf = conf;
        this._splunkUrl = this._conf.getProperty(PROPKEY_splunkUrl, DEFAULT_splunkUrl);
        this._splunkAccessToken = this._conf.getProperty(PROPKEY_splunkAccessToken, DEFAULT_splunkAccessToken);
        this._jsonPrettyPrint = this._conf.getBooleanProperty(PROPKEY_jsonPrettyPrint, false);
        this._jsonPrintBeforeSend = this._conf.getBooleanProperty(PROPKEY_printJsonBeforeSend, false);
        this._threadCount = this._conf.getIntProperty(PROPKEY_senderThreadCount, 3);
        if (this._threadCount <= 0) {
            throw new Exception("Number of threads cant be " + this._threadCount + ". Change this to be 1 or above. Config: " + PROPKEY_senderThreadCount + " = " + 3);
        }
        if (StringUtil.isNullOrBlank(this._splunkUrl)) {
            throw new Exception("Splunk URL cant be empty. Config: WriterToSplunk.url = http://hostname:port/...");
        }
        if (StringUtil.isNullOrBlank(this._splunkAccessToken)) {
            throw new Exception("Splunk Access Token cant be empty. Config: " + DEFAULT_splunkAccessToken + " = accessToken");
        }
        this._apacheHttpConnectionManager = new PoolingHttpClientConnectionManager();
        this._apacheHttpConnectionManager.setMaxTotal(conf.getIntProperty(PROPKEY_httpConnPoolMaxSize, 100));
        this._apacheHttpConnectionManager.setDefaultMaxPerRoute(conf.getIntProperty(PROPKEY_httpConnPoolMaxSizePerRoute, 20));
    }

    @Override
    public void close() {
    }

    @Override
    public Configuration getConfig() {
        return this._conf;
    }

    @Override
    public String getConfigStr() {
        return "";
    }

    @Override
    public void printConfig() {
        int len = 60;
        _logger.info("Configuration for '" + this.getName() + "', with full class name '" + this.getClass().getName() + "'.");
        _logger.info("                   " + StringUtil.left(PROPKEY_splunkUrl, len) + " = " + this._splunkUrl);
        _logger.info("                   " + StringUtil.left(PROPKEY_splunkAccessToken, len) + " = " + this._splunkAccessToken);
        _logger.info("                   " + StringUtil.left(PROPKEY_jsonPrettyPrint, len) + " = " + this._jsonPrettyPrint);
        _logger.info("                   " + StringUtil.left(PROPKEY_printJsonBeforeSend, len) + " = " + this._jsonPrintBeforeSend);
        _logger.info("                   " + StringUtil.left(PROPKEY_senderThreadCount, len) + " = " + this._threadCount);
    }

    @Override
    public void beginOfSample(WriterQueueContainer cont) {
    }

    @Override
    public void saveSample(WriterQueueContainer cont) {
    }

    @Override
    public void saveRecord(AuditRecord ar) {
        this._auditRecordQueue.add(ar);
    }

    @Override
    public void endOfSample(WriterQueueContainer cont, boolean caughtErrors) {
    }

    @Override
    public void startServices() throws Exception {
        _logger.info("Starting " + this._threadCount + " SplunkSender(s).");
        for (int i = 0; i < this._threadCount; ++i) {
            SplunkSender sr = new SplunkSender(this, i);
            sr.start();
            this._senders.add(sr);
        }
    }

    @Override
    public void stopServices(int maxWaitTimeInMs) {
        _logger.info("Stopping " + this._senders.size() + " SplunkSender(s).");
        for (SplunkSender splunkSender : this._senders) {
            splunkSender.stop();
        }
        for (SplunkSender splunkSender : this._senders) {
            try {
                splunkSender._thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        _logger.info("Done Stopping " + this._senders.size() + " SplunkSender(s).");
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void queueSizeWarning(int queueSize, int thresholdSize) {
    }

    @Override
    public WriterQueueStatistics getStatistics() {
        return this._stats;
    }

    @Override
    public void resetStatistics() {
    }

    @Override
    public void run() {
    }

    private static class SplunkSender
    implements Runnable {
        private Thread _thread;
        private WriterToSplunk _parent;
        private int _id;
        private boolean _running;

        public String getName() {
            return "SplunkSender-" + this._id;
        }

        public SplunkSender(WriterToSplunk parent, int id) {
            this._parent = parent;
            this._id = id + 1;
        }

        public void start() {
            this._thread = new Thread((Runnable)this, this.getName());
            this._thread.setDaemon(true);
            this._thread.start();
        }

        public void stop() {
            if (this._thread != null) {
                this._thread.interrupt();
            }
        }

        public boolean isRunning() {
            return this._running;
        }

        @Override
        public void run() {
            this._running = true;
            _logger.info("Starting Thread for: " + this.getName());
            while (this._running) {
                try {
                    AuditRecord auditRecord = (AuditRecord)this._parent._auditRecordQueue.take();
                    if (auditRecord == null || auditRecord != null && auditRecord.isEmpty() || !this.isIncluded(auditRecord)) continue;
                    if (!this.isRunning()) {
                        _logger.info("The service is about to stop, discarding a consume(AuditRecord) queue entry.");
                        continue;
                    }
                    this.consume(auditRecord);
                }
                catch (InterruptedException ex) {
                    _logger.info("Received 'InterruptedException' in '" + this.getName() + "', time to stop...");
                    this._running = false;
                }
                catch (Throwable t) {
                    _logger.error("Found some issue in '" + this.getName() + "', continuing with next message. Caught: " + t, t);
                }
            }
            _logger.info("Ending Thread for " + this.getName());
        }

        private boolean isIncluded(AuditRecord auditRecord) {
            return true;
        }

        private void consume(AuditRecord auditRecord) {
            try {
                HttpUriRequest request;
                CloseableHttpClient httpclient;
                CloseableHttpResponse response;
                int statusCode;
                StringWriter sw = new StringWriter();
                JsonFactory jfactory = new JsonFactory();
                JsonGenerator gen = jfactory.createGenerator((Writer)sw);
                if (this._parent._jsonPrettyPrint) {
                    gen.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
                }
                gen.setCodec((ObjectCodec)new ObjectMapper(jfactory));
                gen.writeStartObject();
                gen.writeFieldName("event");
                auditRecord.createJson(gen);
                gen.writeEndObject();
                gen.close();
                String jsonStr = sw.toString();
                if (this._parent._jsonPrintBeforeSend) {
                    System.out.println("=================================================================\n---- " + this.getName() + " -- Print JSON Before Send \n---- " + this.getName() + " -- To Turn this off: " + WriterToSplunk.PROPKEY_printJsonBeforeSend + " = false \n-----------------------------------------------------------------\n" + jsonStr + "\n-----------------------------------------------------------------\n");
                }
                if ((statusCode = (response = (httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this._parent._apacheHttpConnectionManager).build()).execute(request = RequestBuilder.post().setUri(this._parent._splunkUrl).setHeader("Content-Type", "application/json").setHeader("Authorization", this._parent._splunkAccessToken).setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(jsonStr, StandardCharsets.UTF_8)).build())).getStatusLine().getStatusCode()) != 200) {
                    int numberOfChars = this._parent.getConfig().getIntProperty(WriterToSplunk.PROPKEY_json_onErrorPrintXchars, 512);
                    String jsonMessageFirstXChars = jsonStr.substring(0, Math.min(numberOfChars, jsonStr.length())).replace('\n', ' ').replace('\r', ' ') + "...";
                    _logger.error("HTTP Response code from Splunk was " + statusCode + ", while 200 was expected. Extra Info: Splunk URL='" + this._parent._splunkUrl + "', AccessToken='" + this._parent._splunkAccessToken + "', jsonMessageFirstXChars='" + jsonMessageFirstXChars + "'.");
                }
                this._parent._stats.setLastRetStatus(statusCode);
                String responseString = new BasicResponseHandler().handleResponse((HttpResponse)response);
                if (responseString != null && !responseString.contains("\"Success\"")) {
                    _logger.error(this.getName() + ": Unexpected responce string '" + responseString + "'.");
                }
                this._parent._stats.setLastResponceString(responseString);
                this._parent._stats.incrementSendCount();
            }
            catch (IOException ex) {
                _logger.error("Problems sending JSON message to SPLUNK at '" + this._parent._splunkUrl + "'.", (Throwable)ex);
                this._parent._stats.incrementFailCount();
            }
        }
    }

    private static class WriterQueueStatisticsLocal
    extends WriterQueueStatistics {
        private AtomicLong _totalSendCount = new AtomicLong();
        private AtomicLong _totalFailCount = new AtomicLong();
        private long _lastTotalSendCount = 0L;
        private long _lastTotalFailCount = 0L;
        private int _lastRetStatus = 0;
        private String _lastResponseString = "";

        private WriterQueueStatisticsLocal() {
        }

        public long incrementSendCount() {
            return this._totalSendCount.incrementAndGet();
        }

        public long incrementFailCount() {
            return this._totalFailCount.incrementAndGet();
        }

        public void setLastRetStatus(int status) {
            this._lastRetStatus = status;
        }

        public void setLastResponceString(String responseString) {
            this._lastResponseString = responseString;
        }

        @Override
        public String toString() {
            long tmpTotalSendCount = this._totalSendCount.get();
            long tmpTotalFailCount = this._totalFailCount.get();
            long diffTotalSendCount = tmpTotalSendCount - this._lastTotalSendCount;
            long diffTotalFailCount = tmpTotalFailCount - this._lastTotalFailCount;
            this._lastTotalSendCount = tmpTotalSendCount;
            this._lastTotalFailCount = tmpTotalFailCount;
            return "totalSendCount=" + this._totalSendCount + " (" + diffTotalSendCount + "), totalFailCount=" + this._totalFailCount + " (" + diffTotalFailCount + "), lastRetStatus=" + this._lastRetStatus + ", _lastResponseString='" + this._lastResponseString + "'";
        }
    }
}

