@echo off
setlocal
rem mode con:cols=800 lines=3000

set STARTDIR=%~dp0

rem ------------------------------------------------------------------------
rem --- move all (except the first) cmdline parameters into ARGS
rem ------------------------------------------------------------------------
rem --shift
set "CMDLINE_ARGS="
:parse_cmd_line
if "%~1" neq "" (
  set CMDLINE_ARGS=%CMDLINE_ARGS% %1
  shift
  goto :parse_cmd_line
)
if defined CMDLINE_ARGS set CMDLINE_ARGS=%CMDLINE_ARGS:~1%
echo Passed cmdline parameters: %CMDLINE_ARGS%

rem ------------------------------------------------------------------------
rem --- Set various stuff based on the passed application name
rem ------------------------------------------------------------------------
set APP_NAME="SekAseAuditor"
set JAVA_START_CLASS="sek.ase.auditor.AseAuditor"


title "%APP_NAME%-console"


rem ------------------------------------------------------------------------
rem --- set SEK_ASE_AUDITOR_HOME to current directory if NOT already set
rem --- If STARTDIR ends with \bin\ remove that part... (c:\program\asetune\bin\ -->> c:\program\asetune\)
rem ------------------------------------------------------------------------
IF "%SEK_ASE_AUDITOR_HOME%"=="" (
	set SEK_ASE_AUDITOR_HOME=%STARTDIR%
	if /i [%STARTDIR:~-5%]==[\bin\] set SEK_ASE_AUDITOR_HOME=%STARTDIR:~0,-4%
)

rem --- IF "%SYBASE%"=="" set SYBASE=c:\sybase



rem ------------------------------------------------------------------------
rem --- remove last '\' char from: SEK_ASE_AUDITOR_HOME and SYBASE
rem --- SEK_ASE_AUDITOR_HOME exists every time, while SYBASE is NOT mandatory
rem --- Also for SYBASE
rem ---    Trim begin/end Quote (") character from the SYBASE environment variable 
rem ---    The FOR command can be used to safely remove quotes surrounding a string. 
rem ---    If SYBASE does not have quotes then it will remain unchanged.
rem ---    If SYBASE is not set, it will still NOT be set after this
rem --- Tested the below with SYBASE set to:
rem --- set SYBASE=
rem --- set SYBASE=c:\Program Files\sybase
rem --- set SYBASE=c:\Program Files\sybase\
rem --- set SYBASE="c:\Program Files\sybase"
rem --- set SYBASE="c:\Program Files\sybase\"
rem --- set SYBASE=c:\sybase
rem ------------------------------------------------------------------------
IF %SEK_ASE_AUDITOR_HOME:~-1%==\ SET SEK_ASE_AUDITOR_HOME=%SEK_ASE_AUDITOR_HOME:~0,-1%

IF NOT DEFINED SYBASE goto afterStripSybase
for /f "useback tokens=*" %%a in ('%SYBASE%') do set SYBASE=%%~a
IF %SYBASE:~-1%==\ SET SYBASE=%SYBASE:~0,-1%
:afterStripSybase



rem ------------------------------------------------------------------------
rem --- set some CONSOLE windows and buffer size
rem ------------------------------------------------------------------------
rem ---set /a "winsize=(64 << 16) + 80"
rem ---set /a "bufsize=(3000 << 16) + 800"
rem --->nul reg add "hkcu\console\%title%" /v WindowSize /t REG_DWORD /d "%winsize%" /f
rem --->nul reg add "hkcu\console\%title%" /v ScreenBufferSize /t REG_DWORD /d "%bufsize%" /f



rem ------------------------------------------------------------------------
rem --- set some default environment variables
rem ------------------------------------------------------------------------
set APPL_HOME=%SEK_ASE_AUDITOR_HOME%

rem set JAVA_HOME=%SYBASE_JRE%
rem set JAVA_HOME=%SYBASE%\shared-1_0\JRE-1_4
rem set JAVA_HOME=C:\Program Files\Java\jdk1.6.0_07


rem ------------------------------------------------------------------------
rem --- set JVM MEMORY parameters
rem ------------------------------------------------------------------------
echo NOTE: Set/Change JVM Memory parameters by setting Environment variable: SEK_ASE_AUDITOR_JVM_MEMORY_PARAMS which may be stored in %SEK_ASE_AUDITOR_JVM_PARAMETER_FILE%

set JVM_MEMORY_PARAMS_32=-Xmx1024m -Xms64m
set JVM_MEMORY_PARAMS_64=-Xmx4096m -Xms64m

IF DEFINED SEK_ASE_AUDITOR_JVM_MEMORY_PARAMS set JVM_MEMORY_PARAMS_32=%SEK_ASE_AUDITOR_JVM_MEMORY_PARAMS%
IF DEFINED SEK_ASE_AUDITOR_JVM_MEMORY_PARAMS set JVM_MEMORY_PARAMS_64=%SEK_ASE_AUDITOR_JVM_MEMORY_PARAMS%


rem ------------------------------------------------------------------------
rem --- set JVM GARBAGE COLLECTION parameters
rem ------------------------------------------------------------------------
set JVM_GC_PARAMS_32=
set JVM_GC_PARAMS_64=

IF DEFINED SEK_ASE_AUDITOR_JVM_GC_PARAMS set JVM_GC_PARAMS_32=%SEK_ASE_AUDITOR_JVM_GC_PARAMS%
IF DEFINED SEK_ASE_AUDITOR_JVM_GC_PARAMS set JVM_GC_PARAMS_64=%SEK_ASE_AUDITOR_JVM_GC_PARAMS%


rem ------------------------------------------------------------------------
rem --- set OTHER JVM parameters   and   DEBUG stuff
rem --- -noverify is to get around: 'Caught: java.lang.VerifyError: Inconsistent stackmap frames at branch target 39' when kicking off SQL-Window from the context menu...
rem ------------------------------------------------------------------------
rem --- set JVM_PARAMS=%JVM_PARAMS% -verbose:gc -XX:+PrintGCDetails -XX:+PrintGCTimeStamps
rem --- set JVM_PARAMS=%JVM_PARAMS% -Xrunhprof:cpu=samples,depth=16
rem --- set JVM_PARAMS=%JVM_PARAMS% -Dhttp.proxyHost=www-proxy.domain.com -Dhttp.proxyPort=8080
rem --- set JVM_PARAMS=%JVM_PARAMS% -Djava.net.useSystemProxies=true
rem --- set JVM_PARAMS=-noverify

set EXTRA=%NOGUI%
rem --- set DEBUG_OPTIONS=-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,address=2323,server=y,suspend=n
rem --- set DEBUG_OPTIONS=-agentlib:hprof=cpu=samples,interval=20,depth=50
rem --- set DEBUG_OPTIONS=-agentlib:hprof=cpu=times
set DEBUG_OPTIONS=



rem ------------------------------------------------------------------------
rem --- if environment is not properly set, do something about it
rem --- this might mean goto an exit point
rem ------------------------------------------------------------------------
rem IF NOT DEFINED SYBASE GOTO no_sybase
IF NOT DEFINED SEK_ASE_AUDITOR_HOME GOTO no_home
rem IF NOT DEFINED JAVA_HOME GOTO no_javahome


rem ------------------------------------------------------------------------
rem --- remove the SPLASH if -n or -noGui command line switch is specified
rem --- You got to "love" DOS for being CRYPTICAL... or NOT...
rem ------------------------------------------------------------------------
rem --- for %%c in (%*) do (
rem --- 	echo(%%c|findstr /r /c:"^-n.*"      >nul && ( set SPLASH= )
rem --- 	echo(%%c|findstr /r /c:"^--noGui.*" >nul && ( set SPLASH= )
rem --- )


rem ------------------------------------------------------------------------
rem --- setup the CLASSPATH
rem ------------------------------------------------------------------------
set classpath=%APPL_HOME%\classes
set classpath=%classpath%;%APPL_HOME%\lib\sek_ase_auditor.jar
set classpath=%classpath%;%APPL_HOME%\lib\jconn4.jar
set classpath=%classpath%;%APPL_HOME%\lib\dsparser.jar
set classpath=%classpath%;%APPL_HOME%\lib\log4j-api-2.20.0.jar
set classpath=%classpath%;%APPL_HOME%\lib\log4j-core-2.20.0.jar
set classpath=%classpath%;%APPL_HOME%\lib\commons-cli-1.5.0.jar
set classpath=%classpath%;%APPL_HOME%\lib\commons-codec-1.15.jar
set classpath=%classpath%;%APPL_HOME%\lib\commons-lang3-3.12.0.jar
set classpath=%classpath%;%APPL_HOME%\lib\commons-io-2.11.0.jar
set classpath=%classpath%;%APPL_HOME%\lib\httpclient-4.5.14.jar
set classpath=%classpath%;%APPL_HOME%\lib\httpcore-4.4.16.jar
set classpath=%classpath%;%APPL_HOME%\lib\commons-logging-1.2.jar
set classpath=%classpath%;%APPL_HOME%\lib\jackson-annotations-2.15.0.jar
set classpath=%classpath%;%APPL_HOME%\lib\jackson-core-2.15.0.jar
set classpath=%classpath%;%APPL_HOME%\lib\jackson-databind-2.15.0.jar
set classpath=%classpath%;%APPL_HOME%\lib\dsparser.jar
set classpath=%classpath%;%APPL_HOME%\lib\bcprov-jdk18on-1.73.jar
set classpath=%classpath%;%EXTRA_JDBC_DRIVERS%

echo %CLASSPATH%
rem --- echo %CLASSPATH%



rem ------------------------------------------------------------------------
rem --- set PATH, just add JAVA_HOME at the start
rem ------------------------------------------------------------------------
set PATH=%SEK_ASE_AUDITOR_JAVA_HOME%\bin;%JAVA_HOME%\bin;%PATH%



rem ------------------------------------------------------------------------
rem --- Just for informational purposes, print out the Java Version we are using
rem ------------------------------------------------------------------------
java -version



rem ------------------------------------------------------------------------
rem --- CHECK current Java Version
rem ------------------------------------------------------------------------
rem java se.maxm.admin.utils.JavaVersion 7
rem IF %ERRORLEVEL% NEQ 0 GOTO to_low_java_version



rem ------------------------------------------------------------------------
rem --- SET memory parameters, if 64 bit java: add more memory
rem ------------------------------------------------------------------------
java sek.ase.auditor.utils.JavaBitness
set JavaBitness=%ERRORLEVEL%
rem ---echo Java Bitness: %JavaBitness%

set JVM_MEMORY_PARAMS=%JVM_MEMORY_PARAMS_32%
set JVM_GC_PARAMS=%JVM_GC_PARAMS_32%
if %JavaBitness% == 64 (
	set JVM_MEMORY_PARAMS=%JVM_MEMORY_PARAMS_64%
	set JVM_GC_PARAMS=%JVM_GC_PARAMS_64%
	echo NOTE: Java is a 64 bit, %APP_NAME% will be allowed to use more memory
)
echo JVM_MEMORY_PARAMS=%JVM_MEMORY_PARAMS%
echo JVM_GC_PARAMS=%JVM_GC_PARAMS%



rem ------------------------------------------------------------------------
rem --- SET JVM Debugging parameters, so we can attach to it
rem ------------------------------------------------------------------------
rem set JVM_DEBUG_PROPS=%JVM_DEBUG_PROPS% -Dcom.sun.management.jmxremote=true
rem set JVM_DEBUG_PROPS=%JVM_DEBUG_PROPS% -Djava.rmi.server.hostname=192.168.0.198 
rem set JVM_DEBUG_PROPS=%JVM_DEBUG_PROPS% -Dcom.sun.management.jmxremote.port=5656
rem set JVM_DEBUG_PROPS=%JVM_DEBUG_PROPS% -Dcom.sun.management.jmxremote.authenticate=false
rem set JVM_DEBUG_PROPS=%JVM_DEBUG_PROPS% -Dcom.sun.management.jmxremote.ssl=false
rem set JVM_DEBUG_PROPS=%JVM_DEBUG_PROPS% -Dcom.sun.management.jmxremote.local.only=false


rem ------------------------------------------------------------------------
rem --- Set Log4J config file
rem ------------------------------------------------------------------------
set LOG4J_CFG_FILE=-Dlog4j2.configurationFile=%APPL_HOME%\conf\log4j2.xml


rem ------------------------------------------------------------------------
rem --- START: just call java, it should have been added to the path priviously
rem --- pushd \\192.168.0.130\xxx\yyy     if it's a UNC path like the example, pushd will map a network drive, which will be unmounted at popd
rem ------------------------------------------------------------------------
pushd %SEK_ASE_AUDITOR_HOME%
REM echo %CLASSPATH%

echo java %JVM_MEMORY_PARAMS% %JVM_GC_PARAMS% %JVM_PARAMS% %JVM_DEBUG_PROPS% %LOG4J_CFG_FILE% -XX:AutoBoxCacheMax=2048 -Duser.language=en -Dsybase.home="%SYBASE%" -DSYBASE="%SYBASE%" -DAPPL_HOME="%APPL_HOME%" -DSEK_ASE_AUDITOR_HOME="%SEK_ASE_AUDITOR_HOME%" %SEK_ASE_AUDITOR_SYSTEM_PROPS% %EXTRA% %DEBUG_OPTIONS% %SPLASH% %JAVA_START_CLASS% %CMDLINE_ARGS%
     java %JVM_MEMORY_PARAMS% %JVM_GC_PARAMS% %JVM_PARAMS% %JVM_DEBUG_PROPS% %LOG4J_CFG_FILE% -XX:AutoBoxCacheMax=2048 -Duser.language=en -Dsybase.home="%SYBASE%" -DSYBASE="%SYBASE%" -DAPPL_HOME="%APPL_HOME%" -DSEK_ASE_AUDITOR_HOME="%SEK_ASE_AUDITOR_HOME%" %SEK_ASE_AUDITOR_SYSTEM_PROPS% %EXTRA% %DEBUG_OPTIONS% %SPLASH% %JAVA_START_CLASS% %CMDLINE_ARGS%

IF %ERRORLEVEL% NEQ 0 GOTO unexpected_error
goto exit_batFile



rem ------------------------------------------------------------------------
rem --- Various exit points
rem ------------------------------------------------------------------------

:no_home
echo -----------------------------------------------------------------------
echo Error: no SEK_ASE_AUDITOR_HOME environment variable.
echo -----------------------------------------------------------------------
echo Must set the SEK_ASE_AUDITOR_HOME variable to the place where you installed %APP_NAME%.
echo -----------------------------------------------------------------------
goto exit_batFile

:no_javahome
echo -----------------------------------------------------------------------
echo Error: no JAVA_HOME environment variable.
echo -----------------------------------------------------------------------
echo Must set the JAVA_HOME variable to the place where JDK or JRE is installed.
echo -----------------------------------------------------------------------
goto exit_batFile

:to_low_java_version
echo -----------------------------------------------------------------------
echo Error: Use a higher java version.
echo -----------------------------------------------------------------------
echo The java installation can be pointed out using the variable JAVA_HOME
echo Current SEK_ASE_AUDITOR_JAVA_HOME variable is set to %SEK_ASE_AUDITOR_JAVA_HOME%
echo Current JAVA_HOME                   variable is set to %JAVA_HOME%
echo -----------------------------------------------------------------------
goto exit_batFile

:unexpected_error
echo .
echo -----------------------------------------------------------------------
echo Unexpected Error: Return code from java was NOT 0
echo -----------------------------------------------------------------------
echo If you have problems to start the tool, please email me the above output
echo And I will make sure to solve the issue for you!
echo -----------------------------------------------------------------------
echo Mail to: goran_schwarz@hotmail.com
echo Subject: %APP_NAME% starting problem
echo -----------------------------------------------------------------------
echo .
goto exit_batFile

:no_sybase
echo -----------------------------------------------------------------------
echo Error: no SYBASE environment variable.
echo -----------------------------------------------------------------------
echo 1: Set the env variable SYBASE to where sybase software is installed
echo 2: If you do not have sybase software on this machine, 'set SYBASE=c:\sybase' or any directory
echo    The SYBASE variable is just a pointer where to find the sql.ini file.
echo .
echo If you have a sql.ini file somewhere, %APP_NAME% looks for it under %%SYBASE%%\ini\sql.ini.
echo If you do not have a sql.ini file, just set SYBASE=c:\whatever
echo    and then you can to specify to what host and port when connecting to the ASE server.
echo -----------------------------------------------------------------------
goto exit_batFile

:exit_batFile
popd

pause
endlocal
