#! /bin/bash
#=======================================================================
# NOTE: This one needs more work...
#-----------------------------------------------------------------------
scriptPath="$( cd -P "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

javaMainClass=sek.ase.auditor.AseAuditor

#----------------------------------
#--- XXX_HOME
#----------------------------------
APPL_HOME_propName="SEK_ASE_AUDITOR_HOME"

## If SEK_ASE_AUDITOR_HOME is not set, set it to the same as the script dir
## and if the script dir is '/bin' remove that part
if [ -z "${SEK_ASE_AUDITOR_HOME}" ]
then
	export SEK_ASE_AUDITOR_HOME=${scriptPath}
	if [[ "${scriptPath}" == */bin ]]
	then
		export SEK_ASE_AUDITOR_HOME=${scriptPath::${#scriptPath}-4}
	fi
fi
export APPL_HOME=${SEK_ASE_AUDITOR_HOME}

#----------------------------------
#--- Java
#----------------------------------
#export JAVA_HOME=${JAVA_HOME:-$SAP_JRE8}

echo "NOTE: Set/Change JVM Memory parameters by setting Environment variable: SEK_ASE_AUDITOR_JVM_MEMORY_PARAMS" 

export JVM_MEMORY_PARAMS_32=${SEK_ASE_AUDITOR_JVM_MEMORY_PARAMS:-"-Xmx1024m -Xms64m"}
export JVM_MEMORY_PARAMS_64=${SEK_ASE_AUDITOR_JVM_MEMORY_PARAMS:-"-Xmx2048m -Xms64m"}

export JVM_GC_PARAMS_32=${SEK_ASE_AUDITOR_JVM_GC_PARAMS:-""}
export JVM_GC_PARAMS_64=${SEK_ASE_AUDITOR_JVM_GC_PARAMS:-""}

#export JVM_PARAMS=${SEK_ASE_AUDITOR_JVM_PARAMS:-"-noverify"}

export EXTRA=
#export DEBUG_OPTIONS=-agentlib:hprof=cpu=samples,interval=20,depth=50
#export DEBUG_OPTIONS=-agentlib:hprof=cpu=times
export DEBUG_OPTIONS=

export SPLASH=-splash:${javaSplashScreen}

export CLASSPATH=${APPL_HOME}/classes
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/sek_ase_auditor.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/jconn4.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/dsparser.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/log4j-api-2.20.0.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/log4j-core-2.20.0.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/commons-cli-1.5.0.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/commons-codec-1.15.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/commons-lang3-3.12.0.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/commons-io-2.11.0.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/httpclient-4.5.14.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/httpcore-4.4.16.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/commons-logging-1.2.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/jackson-annotations-2.15.0.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/jackson-core-2.15.0.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/jackson-databind-2.15.0.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/dsparser.jar
export CLASSPATH=${CLASSPATH}:${APPL_HOME}/lib/bcprov-jdk18on-1.73.jar

export PATH=${SEK_ASE_AUDITOR_JAVA_HOME}/bin:${JAVA_HOME}/bin:${PATH}:${SAP_JRE8}/bin
cd ${APPL_HOME}


#------------------------------------------------------------------------
#--- Set Log4j config file
#------------------------------------------------------------------------
export LOG4J_CFG_FILE=-Dlog4j2.configurationFile=${APPL_HOME}/conf/log4j2.xml


#------------------------------------------------------------------------
#--- CHECK if 'java' is in the path
#------------------------------------------------------------------------
command -v java >/dev/null 2>&1 || { echo " *** This require java but it's not installed.  Aborting." >&2; exit 1; }

echo "================================================================"
echo "Information about some environment variables"
echo "----------------------------------------------------------------"
echo "SYBASE=${SYBASE}"
echo "${APPL_HOME_propName}=${APPL_HOME}"
echo "CLASSPATH=${CLASSPATH}"
echo "SEK_ASE_AUDITOR_JAVA_HOME=${SEK_ASE_AUDITOR_JAVA_HOME}"
echo "LOG4J_CFG_FILE=${LOG4J_CFG_FILE}"
echo "JAVA_HOME=${JAVA_HOME}"
echo "JAVA Location: $(which java)"
java -version
echo "----------------------------------------------------------------"

#------------------------------------------------------------------------
#--- CHECK current Java Version
#------------------------------------------------------------------------
#java com.asetune.utils.JavaVersion 7
#if [ $? -ne 0 ]
#then
#	echo "-----------------------------------------------------------------------"
#	echo "Error: Use a higher java version."
#	echo "-----------------------------------------------------------------------"
#	echo "The java installation can be pointed out using the variable JAVA_HOME"
#	echo "Current SEK_ASE_AUDITOR_JAVA_HOME variable is set to ${SEK_ASE_AUDITOR_JAVA_HOME}"
#	echo "Current JAVA_HOME         variable is set to ${JAVA_HOME}"
#	echo "-----------------------------------------------------------------------"
#	
#	exit 1
#fi

#------------------------------------------------------------------------
#--- Parse some command line parameters
#--- - reset SPLASH if we have -noGui command line switch
#------------------------------------------------------------------------
#for arg in "$@"
#do
#	case "$arg" in
#	-n*)      export SPLASH="";;
#	--noGui*) export SPLASH="";;
#	esac
#done

#------------------------------------------------------------------------
#--- SET memory parameters, if 64 bit java: add more memory
#------------------------------------------------------------------------
export JVM_MEMORY_PARAMS=${JVM_MEMORY_PARAMS_32}
export JVM_GC_PARAMS=${JVM_GC_PARAMS_32}
java sek.ase.auditor.utils.JavaBitness
if [ $? -eq 64 ]
then
	export JVM_MEMORY_PARAMS=${JVM_MEMORY_PARAMS_64}
	export JVM_GC_PARAMS=${JVM_GC_PARAMS_64}
	echo "NOTE: Java is a 64 bit, AseTune will be allowed to use more memory"
fi
echo "JVM_MEMORY_PARAMS=${JVM_MEMORY_PARAMS}"
echo "JVM_GC_PARAMS=${JVM_GC_PARAMS}"

#------------------------------------------------------------------------
#--- Add various command line switches depending on platform
#------------------------------------------------------------------------
#OS=`uname`
#if [ "${OS}" == "Darwin" ]
#then
#	echo "================================================================"
#	echo "Mac OS: doing some specific settings for Java/Swing on Mac"
#	echo "----------------------------------------------------------------"
#	OS=mac
#	export JVM_PARAMS="$JVM_PARAMS -Xdock:name=${longAppName}"
#	export JVM_PARAMS="$JVM_PARAMS -Xdock:icon=${APPL_HOME}/lib/${shortAppName}_icon_32.gif"
#	export JVM_PARAMS="$JVM_PARAMS -Dapple.laf.useScreenMenuBar=true"
#	export JVM_PARAMS="$JVM_PARAMS -Dcom.apple.mrj.application.apple.menu.about.name=${longAppName}"
##	export JVM_PARAMS="$JVM_PARAMS -Dapple.awt.brushMetalLook=true"
#	export JVM_PARAMS="$JVM_PARAMS -Dapple.awt.textantialiasing=true"
#	export JVM_PARAMS="$JVM_PARAMS -Dcom.apple.macos.smallTabs=true"
#fi
#echo "JVM_PARAMS=${JVM_PARAMS}"


#echo "CLASSPATH: ${CLASSPATH}"

echo java ${JVM_MEMORY_PARAMS} ${JVM_GC_PARAMS} ${JVM_PARAMS} ${LOG4J_CFG_FILE} -XX:AutoBoxCacheMax=2048 -Duser.language=en -Dsybase.home="${SYBASE}" -DSYBASE="${SYBASE}" -DAPPL_HOME=${APPL_HOME} -D${APPL_HOME_propName}="${APPL_HOME}" ${EXTRA} ${DEBUG_OPTIONS} ${SPLASH} ${javaMainClass} $@
     java ${JVM_MEMORY_PARAMS} ${JVM_GC_PARAMS} ${JVM_PARAMS} ${LOG4J_CFG_FILE} -XX:AutoBoxCacheMax=2048 -Duser.language=en -Dsybase.home="${SYBASE}" -DSYBASE="${SYBASE}" -DAPPL_HOME=${APPL_HOME} -D${APPL_HOME_propName}="${APPL_HOME}" ${EXTRA} ${DEBUG_OPTIONS} ${SPLASH} ${javaMainClass} $@

	  
#echo "Press any key to continue... or wait 30 seconds."
#read -t 30