/*******************************************************************************
 * SEK ASE Auditor -- Created by: goran.schwarz@executeit.se
 ******************************************************************************/
package sek.ase.auditor.collectors.records;

import java.io.IOException;
import java.sql.Timestamp;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.fasterxml.jackson.core.JsonGenerator;

import sek.ase.auditor.collectors.SybSysProcessesCache.SybSysProcessesEntry;
import sek.ase.auditor.utils.StringUtil;
import sek.ase.auditor.utils.TimeUtils;

public class AuditRecordSybAudit
extends AuditRecord
{
	private static Logger _logger = LogManager.getLogger();

	private SybSysProcessesEntry _sybSysProcessEntry;
	private SybAuditEntry        _sybAuditEntry;

	public void setSybSysProcessesEntry(SybSysProcessesEntry sybSysProcessEntry)
	{
		_sybSysProcessEntry = sybSysProcessEntry;
	}

	public SybAuditEntry getSybAuditEntry()
	{
		return _sybAuditEntry;
	}

	public void setSybAuditEntry(SybAuditEntry sybAuditEntry)
	{
		_sybAuditEntry = sybAuditEntry;
	}

	public void setSybAuditEntry(
		String    eventName,
		int       event,
		int       eventmod,
		int       spid,
		Timestamp eventtime,
		int       sequence,
		int       suid,
		int       dbid,
		int       objid,
		String    xactid,
		String    loginname,
		String    dbname,
		String    objname,
		String    objowner,
		String    extrainfo,
		int       nodeid
	)
	{
		SybAuditEntry entry = new SybAuditEntry();

		entry._eventName = eventName;
		entry._event     = event    ;
		entry._eventmod  = eventmod ;
		entry._spid      = spid     ;
		entry._eventtime = eventtime;
		entry._sequence  = sequence ; // if we have several rows for an event, this will reflect the *LAST* read sequence number... see: addExtraInfo()
		entry._suid      = suid     ;
		entry._dbid      = dbid     ;
		entry._objid     = objid    ;
		entry._xactid    = xactid   ;
		entry._loginname = loginname;
		entry._dbname    = dbname   ;
		entry._objname   = objname  ;
		entry._objowner  = objowner ;
		entry._extrainfo = extrainfo;
		entry._nodeid    = nodeid   ;
		
		setSybAuditEntry(entry);
	}

	
	@Override
	public void createJsonForRecord(JsonGenerator gen) throws IOException
	{
		if (_sybAuditEntry != null)
		{
			gen.writeFieldName("sybAudit");
			gen.writeStartObject();
				gen.writeStringField("eventName"   , _sybAuditEntry._eventName);
				gen.writeNumberField("event"       , _sybAuditEntry._event    );
				gen.writeNumberField("eventMod"    , _sybAuditEntry._eventmod );
				gen.writeNumberField("spid"        , _sybAuditEntry._spid     );
				gen.writeStringField("eventTime"   , TimeUtils.toStringIso8601(_sybAuditEntry._eventtime));
				gen.writeNumberField("sequence"    , _sybAuditEntry._sequence );
				gen.writeNumberField("suid"        , _sybAuditEntry._suid     );
				gen.writeNumberField("dbid"        , _sybAuditEntry._dbid     );
				gen.writeNumberField("objid"       , _sybAuditEntry._objid    );
				gen.writeStringField("xactid"      , _sybAuditEntry._xactid   );
				gen.writeStringField("loginName"   , _sybAuditEntry._loginname);
				gen.writeStringField("dbname"      , _sybAuditEntry._dbname   );
				gen.writeStringField("objectName"  , _sybAuditEntry._objname  );
				gen.writeStringField("objectOwner" , _sybAuditEntry._objowner );
				gen.writeStringField("extraInfo"   , _sybAuditEntry._extrainfo);
				gen.writeNumberField("nodeid"      , _sybAuditEntry._nodeid   );

				// If we Split the extraInfo into separate fields, done by: normalizeExtraInfo()
				if (StringUtil.hasValue(_sybAuditEntry._ei_fld_roles        )) gen.writeStringField("eiField_Roles"            , _sybAuditEntry._ei_fld_roles        );
				if (StringUtil.hasValue(_sybAuditEntry._ei_fld_subCommand   )) gen.writeStringField("eiField_SubCommand"       , _sybAuditEntry._ei_fld_subCommand   );
				if (StringUtil.hasValue(_sybAuditEntry._ei_fld_previousValue)) gen.writeStringField("eiField_PreviousValue"    , _sybAuditEntry._ei_fld_previousValue);
				if (StringUtil.hasValue(_sybAuditEntry._ei_fld_currentValue )) gen.writeStringField("eiField_CurrentValue"     , _sybAuditEntry._ei_fld_currentValue );
				if (StringUtil.hasValue(_sybAuditEntry._ei_fld_otherInfo    )) gen.writeStringField("eiField_OtherInfo"        , _sybAuditEntry._ei_fld_otherInfo    );
				if (StringUtil.hasValue(_sybAuditEntry._ei_fld_proxyInfo    )) gen.writeStringField("eiField_ProxyInfo"        , _sybAuditEntry._ei_fld_proxyInfo    );
				if (StringUtil.hasValue(_sybAuditEntry._ei_fld_principalInfo)) gen.writeStringField("eiField_PrincipalInfo"    , _sybAuditEntry._ei_fld_principalInfo);

				// If we Split the "eiFld#", which might hold Configuration History... into separate fields, also done by: normalizeExtraInfo()
				if (StringUtil.hasValue(_sybAuditEntry._ei_cfg_area         )) gen.writeStringField("eiConfig_area"            , _sybAuditEntry._ei_cfg_area      );
				if (StringUtil.hasValue(_sybAuditEntry._ei_cfg_type         )) gen.writeStringField("eiConfig_type"            , _sybAuditEntry._ei_cfg_type      );
				if (StringUtil.hasValue(_sybAuditEntry._ei_cfg_target       )) gen.writeStringField("eiConfig_target"          , _sybAuditEntry._ei_cfg_target    );
				if (StringUtil.hasValue(_sybAuditEntry._ei_cfg_element      )) gen.writeStringField("eiConfig_element"         , _sybAuditEntry._ei_cfg_element   );
				if (StringUtil.hasValue(_sybAuditEntry._ei_cfg_oldvalue     )) gen.writeStringField("eiConfig_oldvalue"        , _sybAuditEntry._ei_cfg_oldvalue  );
				if (StringUtil.hasValue(_sybAuditEntry._ei_cfg_newvalue     )) gen.writeStringField("eiConfig_newvalue"        , _sybAuditEntry._ei_cfg_newvalue  );
				if (StringUtil.hasValue(_sybAuditEntry._ei_cfg_mode         )) gen.writeStringField("eiConfig_mode"            , _sybAuditEntry._ei_cfg_mode      );
				if (StringUtil.hasValue(_sybAuditEntry._ei_cfg_instanceid   )) gen.writeStringField("eiConfig_instanceid"      , _sybAuditEntry._ei_cfg_instanceid);
				
			gen.writeEndObject();
		}

		if (_sybSysProcessEntry != null)
		{
			_sybSysProcessEntry.createJsonForRecord(gen);
		}
	}

	public static class SybAuditEntry
	{
		int       _event     ;
		String    _eventName ;
		int       _eventmod  ;
		int       _spid      ;
		Timestamp _eventtime ;
		int       _sequence  ;
		int       _suid      ;
		int       _dbid      ;
		int       _objid     ;
		String    _xactid    ;
		String    _loginname ;
		String    _dbname    ;
		String    _objname   ;
		String    _objowner  ;
		String    _extrainfo ;
		int       _nodeid    ;

		String    _ei_fld_roles        ; // roles
		String    _ei_fld_subCommand   ; // subCommand
		String    _ei_fld_previousValue; // previousValue         
		String    _ei_fld_currentValue ; // currentValue          
		String    _ei_fld_otherInfo    ; // otherInfo      
		String    _ei_fld_proxyInfo    ; // proxyInfo      
		String    _ei_fld_principalInfo; // principalInfo  

		String    _ei_cfg_area         ; // area
		String    _ei_cfg_type         ; // type
		String    _ei_cfg_target       ; // target
		String    _ei_cfg_element      ; // element
		String    _ei_cfg_oldvalue     ; // oldvalue
		String    _ei_cfg_newvalue     ; // newvalue
		String    _ei_cfg_mode         ; // mode
		String    _ei_cfg_instanceid   ; // instanceid

//		int       _nodeid    ;

		public int       getEvent      () { return _event    ; }
		public String    getEventName  () { return _eventName; }
		public int       getEventmod   () { return _eventmod ; }
		public int       getSpid       () { return _spid     ; }
		public Timestamp getEventTime  () { return _eventtime; }
		public int       getSequence   () { return _sequence ; }
		public int       getSuid       () { return _suid     ; }
		public int       getDbid       () { return _dbid     ; }
		public int       getObjid      () { return _objid    ; }
		public String    getXactid     () { return _xactid   ; }
		public String    getLoginName  () { return _loginname; }
		public String    getDbname     () { return _dbname   ; }
		public String    getObjectname () { return _objname  ; }
		public String    getObjectowner() { return _objowner ; }
		public String    getExtrainfo  () { return _extrainfo; }
		public int       getNodeid     () { return _nodeid   ; }
		
		public void addExtraInfo(String extraInfo, int sequence) 
		{ 
			_extrainfo += extraInfo; 
			_sequence  =  sequence; 
		}
		
		public void normalizeExtraInfo()
		{
			if (StringUtil.isNullOrBlank(_extrainfo))
				return;
			
			if (_extrainfo.indexOf(';') == -1)
				return;
			
			String[] ei = _extrainfo.split(";");
			for (int i=0; i<ei.length; i++)
			{
				if (i == 0) _ei_fld_roles         = ei[i].trim();
				if (i == 1) _ei_fld_subCommand    = ei[i].trim();
				if (i == 2) _ei_fld_previousValue = ei[i].trim();
				if (i == 3) _ei_fld_currentValue  = ei[i].trim();
				if (i == 4) _ei_fld_otherInfo     = ei[i].trim();
				if (i == 5) _ei_fld_proxyInfo     = ei[i].trim();
				if (i == 6) _ei_fld_principalInfo = ei[i].trim();
			}
			
			// event 154 == Configuration History
			if (_event == 154)
			{
				String cfgField = _ei_fld_otherInfo;

				_ei_cfg_area       = StringUtils.substringBetween(cfgField, "^1", "^2");
				_ei_cfg_type       = StringUtils.substringBetween(cfgField, "^2", "^3");
				_ei_cfg_target     = StringUtils.substringBetween(cfgField, "^3", "^4");
				_ei_cfg_element    = StringUtils.substringBetween(cfgField, "^4", "^5");
				_ei_cfg_oldvalue   = StringUtils.substringBetween(cfgField, "^5", "^6");
				_ei_cfg_newvalue   = StringUtils.substringBetween(cfgField, "^6", "^7");
				_ei_cfg_mode       = StringUtils.substringBetween(cfgField, "^7", "^8");
				_ei_cfg_instanceid = StringUtils.substringBetween(cfgField, "^8", "^9");

				//				String[] cfg = _ei_fld5.split("\\^");
//				for (int i=0; i<ei.length; i++)
//				{
//					if (i == 0) _ei_cfg1 = cfg[i].trim();
//					if (i == 1) _ei_cfg2 = cfg[i].trim();
//					if (i == 2) _ei_cfg3 = cfg[i].trim();
//					if (i == 3) _ei_cfg4 = cfg[i].trim();
//					if (i == 4) _ei_cfg5 = cfg[i].trim();
//					if (i == 5) _ei_cfg6 = cfg[i].trim();
//					if (i == 6) _ei_cfg7 = cfg[i].trim();
//					if (i == 7) _ei_cfg8 = cfg[i].trim();
//					if (i == 8) _ei_cfg9 = cfg[i].trim();
//				}
			}
		}
		
	}

//	RS> Col# Label     JDBC Type Name           Guessed DBMS type Source Table                
//	RS> ---- --------- ------------------------ ----------------- ----------------------------
//	RS> 1    event     java.sql.Types.SMALLINT  smallint          sybsecurity.dbo.sysaudits_01
//	RS> 2    eventmod  java.sql.Types.SMALLINT  smallint          sybsecurity.dbo.sysaudits_01
//	RS> 3    spid      java.sql.Types.SMALLINT  smallint          sybsecurity.dbo.sysaudits_01
//	RS> 4    eventtime java.sql.Types.TIMESTAMP datetime          sybsecurity.dbo.sysaudits_01
//	RS> 5    sequence  java.sql.Types.SMALLINT  smallint          sybsecurity.dbo.sysaudits_01
//	RS> 6    suid      java.sql.Types.INTEGER   int               sybsecurity.dbo.sysaudits_01
//	RS> 7    dbid      java.sql.Types.SMALLINT  smallint          sybsecurity.dbo.sysaudits_01
//	RS> 8    objid     java.sql.Types.INTEGER   int               sybsecurity.dbo.sysaudits_01
//	RS> 9    xactid    java.sql.Types.BINARY    binary(6)         sybsecurity.dbo.sysaudits_01
//	RS> 10   loginname java.sql.Types.VARCHAR   varchar(30)       sybsecurity.dbo.sysaudits_01
//	RS> 11   dbname    java.sql.Types.VARCHAR   varchar(30)       sybsecurity.dbo.sysaudits_01
//	RS> 12   objname   java.sql.Types.VARCHAR   varchar(255)      sybsecurity.dbo.sysaudits_01
//	RS> 13   objowner  java.sql.Types.VARCHAR   varchar(30)       sybsecurity.dbo.sysaudits_01
//	RS> 14   extrainfo java.sql.Types.VARCHAR   varchar(255)      sybsecurity.dbo.sysaudits_01
//	RS> 15   nodeid    java.sql.Types.TINYINT   tinyint           sybsecurity.dbo.sysaudits_01

	
//	https://help.sap.com/docs/SAP_ASE/ad4a1ddf1bf34768841bd09d1eddf434/ab8f037ebc2b1014bfeaf4629c68b930.html
//	+------------+----------------------------------------+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//	| Name       | Datatype                               | Description                                                                                                                                                                                                                                                                                  |
//	+------------+----------------------------------------+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//	| event      | smallint                               | Type of event being audited.                                                                                                                                                                                                                                                                 |
//	| eventmod   | smallint                               | Further information about the event. Possible values are:                                                                                                                                                                                                                                    |
//	|            |                                        |    0 = no modifier for this event.                                                                                                                                                                                                                                                           |
//	|            |                                        |    1 = the event passed permission checking.                                                                                                                                                                                                                                                 |
//	|            |                                        |    2 = the event failed permission checking.                                                                                                                                                                                                                                                 |
//	| spid       | smallint int for the Cluster Edition   | Server process ID of the process that caused the audit record to be written.                                                                                                                                                                                                                 |
//	| eventtime  | datetime                               | Date and time of the audited event.                                                                                                                                                                                                                                                          |
//	| sequence   | smallint                               | Sequence number of the record within a single event; some events require more than one audit record.                                                                                                                                                                                         |
//	| suid       | smallint                               | Server login ID of the user who performed the audited event.                                                                                                                                                                                                                                 |
//	| dbid       | int null                               | Database ID in which the audited event occurred or the object/stored procedure/trigger resides, depending on the type of event.                                                                                                                                                              |
//	| objid      | int null                               | ID of the accessed object or stored procedure/trigger.                                                                                                                                                                                                                                       |
//	| xactid     | binary(6) null                         | ID of the transaction containing the audited event. For a multidatabase transaction, this is the transaction ID from the database where the transaction originated.                                                                                                                          |
//	| loginname  | varchar(30) null                       | Login name corresponding to the suid.                                                                                                                                                                                                                                                        |
//	| dbname     | varchar(30) null                       | Database name corresponding to the dbid.                                                                                                                                                                                                                                                     |
//	| objname    | varchar(255) null                      | Object name corresponding to the objid.                                                                                                                                                                                                                                                      |
//	| objowner   | varchar(30) null                       | Name of the owner of objid.                                                                                                                                                                                                                                                                  |
//	| extrainfo  | varchar(255) null                      | Additional information about the audited event. The extrainfo column contains a sequence of items separated by semicolons:                                                                                                                                                                   |
//	|            |                                        |    * Roles                  lists the roles that are active. The roles are separated by blanks.                                                                                                                                                                                             |
//	|            |                                        |    * For commands supported by full text auditing, full text of an audited command. For other commands, the name of the keyword or command option that was used for the event. Multiple keywords or options are separated by commas.                                                         |
//	|            |                                        |    * Previous value         the value prior to the update if the event resulted in the update of a value.                                                                                                                                                                                   |
//	|            |                                        |    * Current value          the new value if the event resulted in the update of a value.                                                                                                                                                                                                   |
//	|            |                                        |    * Other information      additional security-relevant information that is recorded for the event. For example, parameter names and values can be recorded here.                                                                                                                          |
//	|            |                                        |                              When auditing the execution of a stored procedure through sp_audit and option exec_procedure, the database ID dbid and the database name dbname from where the stored procedure is executed are recorded.                                                       |
//	|            |                                        |    * Proxy information      the original login name, if the event occurred while a set proxy was in effect.                                                                                                                                                                                 |
//	|            |                                        |    * Principal information  the principal name from the underlying security mechanism, if the users login is the secure default login, and the user logged in to the SAP ASE server using unified login. The value of this field is NULL, if the secure default login is not being used.   |
//	| nodeid     | tinyint null                           | Reserved for future use (not available for cluster environments)                                                                                                                                                                                                                             |
//	| instanceid | tinyint                                | ID of the instance (available only for cluster environments)                                                                                                                                                                                                                                 |
//	+------------+----------------------------------------+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
	
	
//	/**
//	 * The below translation is from https://help.sap.com/docs/SAP_ASE/2705a3b1e3df4514ab089cfedf87750d/74502d341ad041c1a0e819663ec9d648.html?q=auditing
//	 * @param id
//	 * @return a text representation of the ID
//	 */
//	public static String auditIdToString(int id)
//	{
//		switch (id)
//		{
//		case   1: return "ad hoc audit record";
//		case   2: return "alter database";
//		case   3: return "alter table";
//		case   4: return "bcp in";
//		case   5: return "Reserved";
//		case   6: return "sp_bindefault";
//		case   7: return "sp_bindmsg";
//		case   8: return "sp_bindrule";
//		case   9: return "create database";
//		case  10: return "create table";
//		case  11: return "create procedure, create service";
//		case  12: return "create trigger";
//		case  13: return "create rule";
//		case  14: return "create default";
//		case  15: return "sp_addmessage";
//		case  16: return "create view";
//		case  17: return "Access to database by any user";
//		case  18: return "delete from a table";
//		case  19: return "delete from a view";
//		case  20: return "disk init";
//		case  21: return "disk refit";
//		case  22: return "disk reinit";
//		case  23: return "disk mirror";
//		case  24: return "disk unmirror";
//		case  25: return "disk remirror";
//		case  26: return "drop database";
//		case  27: return "drop table";
//		case  28: return "drop procedure, drop service";
//		case  29: return "drop trigger";
//		case  30: return "drop rule";
//		case  31: return "drop default";
//		case  32: return "sp_dropmessage";
//		case  33: return "drop view";
//		case  34: return "dump database";
//		case  35: return "dump transaction";
//		case  36: return "Fatal error";
//		case  37: return "Non-fatal error";
//		case  38: return "Execution of stored procedure";
//		case  39: return "Execution of trigger";
//		case  40: return "grant";
//		case  41: return "insert into a table";
//		case  42: return "insert into a view";
//		case  43: return "load database";
//		case  44: return "load transaction";
//		case  45: return "login";
//		case  46: return "logout";
//		case  47: return "revoke";
//		case  48: return "rpc in";
//		case  49: return "rpc out";
//		case  50: return "Server start";
//		case  51: return "Server shutdown";
//		case  52: return "Reserved";
//		case  53: return "Reserved";
//		case  54: return "Reserved";
//		case  55: return "Role toggling";
//		case  56: return "Reserved";
//		case  57: return "Reserved";
//		case  58: return "Audit table truncation";
//		case  59: return "Reserved";
//		case  60: return "Reserved";
//		case  61: return "Access to audit table";
//		case  62: return "select from table";
//		case  63: return "select from view";
//		case  64: return "truncate table";
//		case  65: return "Reserved";
//		case  66: return "Reserved";
//		case  67: return "sp_unbindefault";
//		case  68: return "sp_unbindrule";
//		case  69: return "sp_unbindmsg";
//		case  70: return "update table";
//		case  71: return "update view";
//		case  72: return "Reserved";
//		case  73: return "Auditing enabled (sp_configure 'auditing', 1)";
//		case  74: return "Auditing disabled (sp_configure 'auditing', 0)";
//		case  75: return "Reserved";
//		case  76: return "Regeneration of password by an SSO";
//		case  77: return "Audit table change";
//		case  78: return "Applies only to SAP ASE Cluster Edition";
//		case  79: return "Reserved";
//		case  80: return "Role check performed (Authorization checks that are performed inside system stored procedures)";
//		case  81: return "dbcc";
//		case  82: return "sp_configure";
//		case  83: return "online database";
//		case  84: return "setuser command";
//		case  85: return "alter role, create role, drop role, grant role, or revoke role";
//		case  86: return "Built-in functions";
//		case  87: return "Reserved";
//		case  88: return "set proxy, set session authorization";
//		case  89: return "kill";
//		case  90: return "connect to";
//		case  91: return "Creation of references to tables";
//		case  92: return "Command text";
//		case  93: return "installjava";
//		case  94: return "remove java";
//		case  95: return "Unlock admin account";
//		case  96: return "quiesce database, prepare database";
//		case  97: return "create function (SQLJ)";
//		case  98: return "drop function (SQLJ)";
//		case  99: return "sp_ssladmin";
//		case 100: return "disk resize";
//		case 101: return "mount database";
//		case 102: return "unmount database";
//		case 103: return "create login";
//		case 104: return "create index";
//		case 105: return "drop index";
//		case 106: return "sp_encryption";
//		case 107: return "create encryption key";
//		case 108: return "alter encryption key as | not default";
//		case 109: return "drop encryption key";
//		case 110: return "sp_webservices (deploy)";
//		case 111: return "sp_webservices (undeploy)";
//		case 112: return "Login locked due to exceeding the configured number of failed attempts";
//		case 113: return "quiesce database..hold security";
//		case 114: return "quiesce database..release";
//		case 115: return "sp_passwordpolicy and all of its actions except 'list'";
//		case 116: return "create manifest file";
//		case 117: return "Regeneration of asymmetric keypairs for network password encryption by system or sp_passwordpolicy";
//		case 118: return "alter encryption key modify encryption";
//		case 119: return "alter encryption key add encryption";
//		case 120: return "alter encryption key drop encryption";
//		case 121: return "Reserved";
//		case 122: return "alter encryption key recover encryption";
//		case 123: return "LDAP state changes";
//		case 124: return "Cluster commands";
//		case 125: return "When sp_passwordpolicy 'set', 'disallow simple passwords', 1, and a login with a simple password is created using create login.";
//		case 126: return "Reserved";
//		case 127: return "Errorlog administration with sp_errorlog";
//		case 128: return "Reserved";
//		case 129: return "Reserved";
//		case 130: return "Reserved";
//		case 131: return "Reserved";
//		case 132: return "alter...modify owner";
//		case 133: return "alter role..lock";
//		case 134: return "alter role..add passwd, alter role..drop passwd, create role..with passwd";
//		case 135: return "alter encryption key..regenerate key";
//		case 136: return "transfer table";
//		case 137: return "create login profile";
//		case 138: return "alter login";
//		case 139: return "drop login";
//		case 140: return "alter login profile";
//		case 141: return "drop login profile";
//		case 142: return "create thread pool";
//		case 143: return "alter thread pool";
//		case 144: return "drop thread pool";
//		case 145: return "sp_hidetext";
//		case 146: return "sproc_auth";
//		case 147: return "Reserved";
//		case 148: return "Reserved";
//		case 149: return "dump configuration to";
//		case 150: return "dump database..cumulative to";
//		case 151: return "load database..cumulative from";
//		case 152: return "Reserved";
//		case 153: return "Reserved";
//		case 154: return "Configuration history";
//		case 155: return "alter index";
//		case 156: return "-";
//		case 157: return "Reserved";
//		case 158: return "Reserved";
//		case 159: return "Reserved";
//		case 160: return "?";              // Not in the manual
//		case 161: return "?";              // Not in the manual
//		case 162: return "?";              // Not in the manual
//		case 163: return "deny";
//		case 164: return "allow";
//
//		default:
//			return "id=" + id +" [UNKNOWN]";
//		}
//	}
}

// 1> select * from sybsecurity.dbo.sysaudits_01
// RS> Col# Label     JDBC Type Name           Guessed DBMS type Source Table                
// RS> ---- --------- ------------------------ ----------------- ----------------------------
// RS> 1    event     java.sql.Types.SMALLINT  smallint          sybsecurity.dbo.sysaudits_01
// RS> 2    eventmod  java.sql.Types.SMALLINT  smallint          sybsecurity.dbo.sysaudits_01
// RS> 3    spid      java.sql.Types.SMALLINT  smallint          sybsecurity.dbo.sysaudits_01
// RS> 4    eventtime java.sql.Types.TIMESTAMP datetime          sybsecurity.dbo.sysaudits_01
// RS> 5    sequence  java.sql.Types.SMALLINT  smallint          sybsecurity.dbo.sysaudits_01
// RS> 6    suid      java.sql.Types.INTEGER   int               sybsecurity.dbo.sysaudits_01
// RS> 7    dbid      java.sql.Types.SMALLINT  smallint          sybsecurity.dbo.sysaudits_01
// RS> 8    objid     java.sql.Types.INTEGER   int               sybsecurity.dbo.sysaudits_01
// RS> 9    xactid    java.sql.Types.BINARY    binary(6)         sybsecurity.dbo.sysaudits_01
// RS> 10   loginname java.sql.Types.VARCHAR   varchar(30)       sybsecurity.dbo.sysaudits_01
// RS> 11   dbname    java.sql.Types.VARCHAR   varchar(30)       sybsecurity.dbo.sysaudits_01
// RS> 12   objname   java.sql.Types.VARCHAR   varchar(255)      sybsecurity.dbo.sysaudits_01
// RS> 13   objowner  java.sql.Types.VARCHAR   varchar(30)       sybsecurity.dbo.sysaudits_01
// RS> 14   extrainfo java.sql.Types.VARCHAR   varchar(255)      sybsecurity.dbo.sysaudits_01
// RS> 15   nodeid    java.sql.Types.TINYINT   tinyint           sybsecurity.dbo.sysaudits_01
// +-----+--------+----+-----------------------+--------+----+------+------+--------------+---------+------+-------+--------+---------------------------------------------------------------------------------------------------------------+------+
// |event|eventmod|spid|eventtime              |sequence|suid|dbid  |objid |xactid        |loginname|dbname|objname|objowner|extrainfo                                                                                                      |nodeid|
// +-----+--------+----+-----------------------+--------+----+------+------+--------------+---------+------+-------+--------+---------------------------------------------------------------------------------------------------------------+------+
// |  154|       0|  36|2023-04-19 18:22:17.996|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 36, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  41|2023-04-19 18:50:14.446|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 41, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  43|2023-04-19 19:26:14.453|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 43, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  49|2023-04-19 19:52:44.75 |       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 49, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  53|2023-04-19 20:30:21.686|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 53, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  22|2023-04-19 20:38:10.433|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 22, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  58|2023-04-19 20:53:32.053|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 58, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  62|2023-04-19 21:02:11.26 |       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 62, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  66|2023-04-19 21:12:13.406|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 66, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  70|2023-04-19 21:23:30.93 |       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 70, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  74|2023-04-19 21:36:56.216|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 74, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|   2|2023-04-20 23:21:46.53 |       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 2, no_info^5Old Value:off^6New Value:on^7^8^9; ; ; |(NULL)|
// |  154|       0|  18|2023-04-21 18:39:24.22 |       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 18, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  25|2023-04-23 23:49:08.45 |       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 25, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  28|2023-04-24 23:40:37.02 |       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 28, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  33|2023-04-26 15:20:43.383|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 33, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  39|2023-04-26 17:08:23.023|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 39, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  38|2023-04-26 17:28:09.97 |       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 38, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  45|2023-04-26 17:55:27.476|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 45, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  50|2023-04-26 18:51:55.57 |       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 50, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  54|2023-04-26 19:04:10.583|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 54, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  21|2023-04-26 19:16:29.726|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 21, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  57|2023-04-26 19:31:40.153|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 57, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  63|2023-04-26 19:39:39.426|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 63, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  65|2023-04-26 19:52:39.433|       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 65, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  68|2023-04-27 17:58:39.39 |       1|   1|(NULL)|(NULL)|(NULL)        |sa       |master|(NULL) |(NULL)  |; ; ; ; ^01^1TRACEFLAG^2set switch^33604^4session-specific: 68, no_info^5Old Value:off^6New Value:on^7^8^9; ; ;|(NULL)|
// |  154|       0|  71|2023-04-27 18:02:18.723|       1|   1|(NULL)|(NULL)|0xa09400000500|sa       |tempdb|(NULL) |(NULL)  |; ; ; ; ^01^1AUDIT^2global auditing^3^4^5Old Value:on^6New Value:off^7^8^9; ; ;                                |(NULL)|
// |   74|       0|  71|2023-04-27 18:02:18.723|       1|   1|(NULL)|(NULL)|0xa09400000500|sa       |(NULL)|(NULL) |(NULL)  |sa_role sso_role oper_role sybase_ts_role replication_role mon_role; ; ; ; ; ; sa/ase;                         |(NULL)|
// |   73|       0|  71|2023-04-27 18:02:25.98 |       1|   1|(NULL)|(NULL)|0xa09400000800|sa       |(NULL)|(NULL) |(NULL)  |sa_role sso_role oper_role sybase_ts_role replication_role mon_role; ; ; ; ; ; sa/ase;                         |(NULL)|
// |  154|       0|  71|2023-04-27 18:02:25.98 |       1|   1|(NULL)|(NULL)|0xa09400000800|sa       |tempdb|(NULL) |(NULL)  |; ; ; ; ^01^1AUDIT^2global auditing^3^4^5Old Value:off^6New Value:on^7^8^9; ; ;                                |(NULL)|
// +-----+--------+----+-----------------------+--------+----+------+------+--------------+---------+------+-------+--------+---------------------------------------------------------------------------------------------------------------+------+
// Rows 30
// Discarded 1762 first rows from the ResultSet, and only keeping the last 30 records.
// Client Exec Time: 00:00.018 (sqlExec=00:00.002, readResults=00:00.008, other=00:00.008), at '2023-04-28 22:54:47.418', for SQL starting at Line 13146
