/*******************************************************************************
 * Copyright (C) 2010-2020 Goran Schwarz
 * 
 * This file is part of DbxTune
 * DbxTune is a family of sub-products *Tune, hence the Dbx
 * Here are some of the tools: AseTune, IqTune, RsTune, RaxTune, HanaTune, 
 *          SqlServerTune, PostgresTune, MySqlTune, MariaDbTune, Db2Tune, ...
 * 
 * DbxTune is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 * 
 * DbxTune is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DbxTune.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * NOTE: SEK is ALLOWED to use this utility file for SEK ASE Auditor Project
 *       This is cleared by Goran Schwarz, the author of DbxTune
 ******************************************************************************/
package sek.ase.auditor.utils;

import java.util.HashMap;

/**
 * Static copy of ASE: master.dbo.sysmessages <br>'
 * This so we can enhance some messages... <br>
 * 
 * Used in DailyReport for AseTune
 * 
 * @author gorans
 *
 */
public class AseErrorMessageDictionary
{
	/** Instance variable */
	private static AseErrorMessageDictionary _instance = null;

	private HashMap<Integer,AseErrorMessageEntry> _messages = new HashMap<Integer,AseErrorMessageEntry>();

	public class AseErrorMessageEntry
	{
		private int    _msgNum;
		private int    _severity;
		private String _description;

		public AseErrorMessageEntry(int msgNum, int severity, String description)
		{
			_msgNum      = msgNum;
			_severity    = severity;
			_description = description;
		}
		
		@Override
		public String toString()
		{
			return StringUtil.left(_msgNum+"", 5) + " - " + _description;
		}
		
		public String getDescription()
		{
			return _description;
		}
	}


	public AseErrorMessageDictionary()
	{
		// I had to break into several init methods... compiler complained about "to large" code section 65K
		init1();
		init2();
		init3();
		init4();
		init5();
	}

	public static AseErrorMessageDictionary getInstance()
	{
		if (_instance == null)
			_instance = new AseErrorMessageDictionary();
		return _instance;
	}

	public String getDescription(int msgNum)
	{
		AseErrorMessageEntry rec = _messages.get(msgNum);
		if (rec != null)
		{
			//return rec.toString();
			return rec.getDescription();
		}

		// Compose an empty one
		return "Error Number '"+msgNum+"' not found in dictionary.";
	}


	private void add(AseErrorMessageEntry entry)
	{
		if ( _messages.containsKey(entry._msgNum))
			System.out.println("Error Number '"+entry._msgNum+"' already exists. It will be overwritten.");

		_messages.put(entry._msgNum, entry);
	}

	private void add(int msgNum, int severity, String description)
	{
		add(new AseErrorMessageEntry(msgNum, severity, description));
	}

	/*----------------------------------------------------------------------------
	 * Below values was extracted from: 
	 *     ASE 16.0 SP3 PL6
	 * Using:
	 *     select 'add('
	 * 	          + convert(char(6), error) + ', '
	 * 	          + convert(char(3), severity) + ', "'
	 * 	          + str_replace(description,char(10), " ") + '");'
	 *     from master.dbo.sysmessages 
	 *     where langid is null
	 * 
	 * at 2019-05-20
	 *----------------------------------------------------------------------------
	 */
	private void init1()
	{
		add(1     , 10 , "Version Date of last upgrade: 92/01/11 13:59:19");
		add(21    , 10 , "WARNING - Fatal Error %ld occurred at %S_DATE.  Please note the error and time, and contact a user with System Administrator (SA) authorization.");
		add(101   , 15 , "Line %d: SQL syntax error.");
		add(102   , 15 , "Incorrect syntax near '%.*s'.");
		add(103   , 15 , "The %S_MSG that starts with '%.*s' is too long. Maximum length is %d.");
		add(104   , 15 , "Order-by items must appear in the select-list if the statement contains set operators.");
		add(105   , 15 , "Unclosed quote before the character string '%.*s'.");
		add(106   , 16 , "Too many table names in the query.  The maximum allowable is %d.");
		add(107   , 15 , "The column prefix '%.*s' does not match with a table name or alias name used in the query. Either the table is not specified in the FROM clause or it has a correlation name which must be used instead.");
		add(108   , 15 , "The order-by position number '%ld' is out of range of the number of items in the select-list.");
		add(109   , 15 , "There are more columns in the INSERT statement than values specified in the VALUES clause.  The number of values in the VALUES clause must match the number of columns specified in the INSERT statement.");
		add(110   , 15 , "There are fewer columns in the INSERT statement than values specified in the VALUES clause.  The number of values in the VALUES clause must match the number of columns specified in the INSERT statement.");
		add(111   , 15 , "%s must be the first command in a query batch.");
		add(112   , 15 , "Variables are not allowed in %s statement.");
		add(113   , 15 , "Missing end comment mark ''.");
		add(114   , 15 , "'%.*s' is not a recognized DUMP DATABASE/TRANSACTION truncation option.");
		add(115   , 15 , "The offset '%d' given in a CONTROLROW command does not correspond to the beginning of a statement.");
		add(116   , 15 , "The symbol '*' can only be used for a subquery select list when the subquery is introduced with EXISTS or NOT EXISTS.");
		add(117   , 15 , "The %S_MSG name '%.*s' contains more than the maximum number of prefixes.  The maximum is %d.");
		add(118   , 15 , "'%.*s' option name length plus value string length must total less than %d characters.");
		add(119   , 15 , "Must pass parameter number %d and subsequent parameters as '@name = value'.  Once the form '@name = value' has been used, all subsequent parameters must be passed in the form '@name = value'.");
		add(120   , 15 , "The SELECT list for the INSERT statement contains fewer items than the INSERT list.  The number of SELECT values must match the number of INSERT columns.");
		add(121   , 15 , "The SELECT list for the INSERT statement contains more items than the INSERT list.  The number of SELECT values must match the number of INSERT columns.");
		add(122   , 15 , "The debug option '%d' is larger than the maximum allowed.  The highest option available is %d.");
		add(123   , 15 , "Must attach a value to the binary prefix '0x'; zero-length binary value is not allowed.");
		add(124   , 15 , "CREATE PROCEDURE contains no statements.");
		add(126   , 15 , "Cannot nest CREATE PROCEDURE statements.");
		add(127   , 15 , "This CREATE may only contain 1 statement.");
		add(128   , 15 , "The name '%.*s' is illegal in this context. Only constants, constant expressions, or variables allowed here.  Column names are illegal.");
		add(129   , 15 , "Fillfactor '%d' is not a valid percentage; fillfactor must be between 1 and 100.");
		add(130   , 15 , "The comparison operator '= ALL' is not currently supported.");
		add(131   , 15 , "The size (%d) given to the %S_MSG '%.*s' exceeds the maximum.  The largest size allowed is %d.");
		add(132   , 15 , "The label '%.*s': has already been declared. Label names must be unique within a query batch or stored procedure");
		add(133   , 15 , "A GOTO statment references the label '%.*s' but the label has not been declared.");
		add(134   , 15 , "The variable name '%.*s' has already been declared.  Variable names must be unique within a query batch or stored procedure.");
		add(135   , 15 , "Cannot use a BREAK statement outside the scope of a WHILE statement.");
		add(136   , 15 , "Cannot use a CONTINUE statement outside the scope of a WHILE statement.");
		add(137   , 15 , "Must declare variable '%.*s'.");
		add(138   , 15 , "Illegal correlation clause in a subquery.");
		add(139   , 15 , "Cannot assign a default value to a local variable.");
		add(140   , 15 , "Can only use IF UPDATE within a CREATE TRIGGER.");
		add(141   , 15 , "A SELECT statement that assigns a value to a variable must not be combined with data-retrieval operations.");
		add(143   , 15 , "A compute-by item was not found in the order-by list.  All expressions in the compute-by list must also be present in the order-by list");
		add(144   , 15 , "Cannot use an aggregate in an expression used for the by-list of a GROUP BY clause.");
		add(145   , 15 , "A subquery with no aggregate functions may only contain expressions in its GROUP BY clause that are in the select-list.");
		add(146   , 15 , "Cannot perform an aggregate function on a column from a table not declared in the same subquery.");
		add(147   , 15 , "An aggregate function may not appear in a WHERE clause unless it is in a subquery that is in a HAVING clause, and the column being aggregated is in a table named in a FROM clause outside of the subquery.");
		add(148   , 15 , "Incorrect time syntax in time string '%.*s' used with WAITFOR.");
		add(149   , 15 , "Time value '%.*s' used with WAITFOR is not a legal value.  Check date/time syntax.");
		add(150   , 15 , "Both terms of an outer join must contain columns.");
		add(151   , 15 , "'%.*s' is an invalid money value.");
		add(152   , 15 , "Subqueries that use DISTINCT with a GROUP BY clause are not currently supported.");
		add(153   , 16 , "Variables/Parameters are not allowed in the ORDER BY clause.");
		add(154   , 15 , "%S_MSG is not allowed in %S_MSG.");
		add(155   , 15 , "'%.*s' is not a recognized %s option.");
		add(156   , 15 , "Incorrect syntax near the keyword '%.*s'.");
		add(158   , 15 , "Too many ORDER BY expressions.  The maximum is %d.");
		add(159   , 15 , "For DROP INDEX, must give both the table and the index name, in the form tablename.indexname");
		add(160   , 15 , "Rule does not contain a variable.");
		add(161   , 15 , "Rule contains more than one variable.");
		add(162   , 15 , "The select list item identified by the order by number '%ld' is a '*', rather than a column name.  When ordering by column number, a column name must appear in the select list position that corresponds to the order by number.");
		add(163   , 15 , "The COMPUTE BY list does not match the ORDER BY list.");
		add(164   , 15 , "GROUP BY expressions must refer to column names.");
		add(165   , 16 , "Privilege %s may not be GRANTed or REVOKEd.");
		add(166   , 15 , "%s does not allow specifying the database name as a prefix to the object name.");
		add(167   , 16 , "May not create a trigger on a temporary object.");
		add(168   , 15 , "The %S_MSG '%.*s' is out of the range of machine representation (%d bytes).");
		add(169   , 15 , "Expression '%d' and '%d' in the ORDER BY list are same. Expressions in the ORDER BY list must be unique.");
		add(171   , 15 , "Can't use SELECT INTO in Browse Mode.");
		add(172   , 15 , "Can't use HOLDLOCK in Browse Mode");
		add(173   , 15 , "The definition for column '%.*s' must include a datatype.");
		add(174   , 15 , "The function '%.*s' requires %d arguments.");
		add(175   , 15 , "Functions may only be nested to level %d.");
		add(176   , 15 , "Function '%.*s' is not yet implemented.");
		add(177   , 15 , "%s cannot create a temporary object (with '#' as the first character name.");
		add(178   , 15 , "A RETURN statement with a return status may only be used in a SQL stored procedure.");
		add(179   , 15 , "Can't use the OUTPUT option when passing a constant to a stored procedure.");
		add(180   , 15 , "There are too many parameters in this '%.*s' statement. The maximum number is %d.");
		add(181   , 15 , "Can't use the OUTPUT option in a DECLARE statement.");
		add(182   , 15 , "Table and column names must be supplied for the READTEXT or WRITETEXT utility.");
		add(183   , 15 , "The scale (%d) for column '%.*s' must be within the range %d to %d.");
		add(184   , 15 , "Invalid money datatype specification for column '%.*s'. Only money(19, 4) is allowed for non-external tables.");
		add(185   , 15 , "Data stream is invalid for WRITETEXT command in bulk form.");
		add(186   , 15 , "Data stream missing from WRITETEXT command.");
		add(187   , 15 , "Odd number of bytes in IMAGE data.");
		add(188   , 15 , "Can't specify a log-device in a CREATE DATABASE statement without also specifying at least one non-log-device.");
		add(189   , 15 , "Function '%.*s' requires %d to %d arguments.");
		add(190   , 15 , "Can not update the global variable '%.*s'.");
		add(191   , 15 , "Some part of your SQL statement is nested too deeply. Please re-write the query or break it up into smaller queries.");
		add(192   , 15 , "Can't create a view inside a stored procedure.");
		add(193   , 15 , "The object or column name starting with '%.*s' is too long.  The maximum length is %d characters.");
		add(194   , 10 , "Warning: Precomputed result set is being created with %s option, so it will not be %s.");
		add(195   , 15 , "'%.*s' is not a recognized %S_MSG.");
		add(196   , 15 , "SELECT INTO must be the first query in a SQL statement containing set operators.");
		add(197   , 15 , "WITH CHECK OPTION is not allowed in the definition of a union view.");
		add(198   , 15 , "Browse mode is invalid for statements containing set operators.");
		add(199   , 15 , "An INSERT statement may not contain a SELECT statement that assigns values to a variable.");
		add(201   , 16 , "Procedure %.*s expects parameter %.*s, which was not supplied.");
		add(202   , 11 , "Internal error -- Unable to open table at query execution time.");
		add(203   , 16 , "The name '%.*s' is not a valid identifier.");
		add(204   , 20 , "Normalization error; node %s");
		add(205   , 16 , "All queries in a SQL statement containing set operators must have an equal number of expressions in their target lists.");
		add(206   , 16 , "Operand type clash: %s is incompatible with %s");
		add(207   , 16 , "Invalid column name '%.*s'.");
		add(208   , 16 , "%.*s not found. Specify owner.objectname or use sp_help to check whether the object exists (sp_help may produce lots of output).");
		add(209   , 16 , "Ambiguous column name %.*s");
		add(210   , 16 , "Syntax error converting DATETIME from BINARY/VARBINARY string.");
		add(211   , 16 , "Syntax error converting SMALLDATETIME from BINARY/VARBINARY string.");
		add(212   , 16 , "Expression result length exceeds maximum: max - %d  found - %d");
		add(213   , 16 , "Insert error: column name or number of supplied values does not match table definition.");
		add(214   , 16 , "Cannot convert parameter %.*s to type %.*s expected by procedure.");
		add(216   , 20 , "Attempt to automatically drop temporary table failed.");
		add(217   , 16 , "Maximum stored procedure nesting level exceeded (limit %d). Please use sp_configure to increase the 'max nesting level'.");
		add(218   , 16 , "Given parameter %.*s is too large; maximum size for this parameter is %d bytes.");
		add(219   , 16 , "Print format failed to match with a result column.");
		add(220   , 16 , "Arithmetic overflow error for type %s, value =  %ld.");
		add(221   , 16 , "Column of type (%s) does not allow nulls. It may not be compared with null.");
		add(222   , 20 , "Unintelligible query plan step encountered.");
		add(223   , 11 , "Object %ld specified as a default for tabid %ld, colid %d is missing or not of type default.");
		add(224   , 11 , "Object %ld specified as a rule/check constraint for tabid %ld, colid %d is missing or not of type default.");
		add(225   , 11 , "Cannot run query--referenced object (name %.*s) dropped during query optimization.");
		add(226   , 16 , "%s command not allowed within multi-statement transaction.");
		add(227   , 16 , "Arithmetic overflow error ocurred while converting the string '%.*s' to type %s.");
		add(228   , 14 , "Query is based on a view that no longer exists (id = %ld)--cannot run.");
		add(229   , 14 , "%s permission denied on object %S_OBJID, database %S_DBID, owner %.*s");
		add(230   , 14 , "%s permission denied on column %.*s of object %S_OBJID, database %S_DBID, owner %.*s");
		add(231   , 11 , "Getdefault: no such default. id=%ld dbid=%d");
		add(232   , 16 , "Arithmetic overflow error for type %s, value = %f.");
		add(233   , 16 , "The column %.*s in table %.*s does not allow null values.%S_EED");
		add(234   , 16 , "There is insufficient result space to convert MONEY value to CHAR.");
		add(235   , 16 , "Precision error during %S_MSG conversion of %s value '%s' to a %s field.");
		add(236   , 16 , "The conversion from CHAR to MONEY resulted in a MONEY overflow error.");
		add(237   , 16 , "There is insufficient result space to convert MONEY value to %s.");
		add(238   , 16 , "There is insufficient result space to convert %s value (= %d) to MONEY.");
		add(239   , 16 , "Table '%.*s' does not exist.  Please refer to sysobjects for correct name.");
		add(240   , 16 , "There is insufficient result space to convert DATETIME value to CHAR.");
		add(241   , 16 , "Scale error during %S_MSG conversion of %s value '%s' to a %s field.");
		add(242   , 16 , "The conversion of CHAR to DATETIME resulted in a DATETIME value out of range.");
		add(243   , 16 , "Type '%.*s' is not a defined system type.");
		add(244   , 16 , "The conversion of CHAR value '%.*s' overflowed an INT1 field, use a larger integer field.");
		add(245   , 16 , "Domain error during %S_MSG conversion of %s value '%s' to a %s field.");
		add(246   , 16 , "The conversion of CHAR value '%.*s' overflowed an INT2 field, use a larger integer field.");
		add(247   , 16 , "Arithmetic overflow during %S_MSG conversion of %s value '%s' to a %s field .");
		add(248   , 16 , "The conversion of CHAR value '%.*s' overflowed an INT4 field. Maximum integer value exceeded.");
		add(249   , 16 , "Syntax error during %S_MSG conversion of %s value '%s' to a %s field.");
		add(251   , 16 , "Unable to allocate ancillary table for query optimization.  Maximum number of tables in a query (%d) exceeded.");
		add(252   , 16 , "Can't group by a bit field.");
		add(253   , 16 , "Maximum number of group-by expressions exceeded. Limit is %d, found %d aggregate expressions.");
		add(254   , 16 , "Maximum number of columns in a work table (%d) exceeded.");
		add(255   , 16 , "Size of row in the worktable for grouped aggregate, %d bytes, exceeds the maximum row size (%d bytes). Cannot run this query.");
		add(256   , 16 , "The data type '%s' is invalid for the %s function.  Allowed types are: CHAR/VARCHAR and BINARY/VARBINARY.");
		add(257   , 16 , "Implicit conversion from datatype '%s' to '%s' is not allowed.  Use the CONVERT function to run this query.");
		add(258   , 20 , "Database '%.*s' missing during query recompile.");
		add(259   , 16 , "Ad-hoc updates to system catalogs not enabled. A user with System Security Officer (SSO) role must reconfigure system to allow this.");
		add(261   , 16 , "'%.*s' is not a recognized global variable.");
		add(262   , 16 , "%s permission denied, database %S_DBID, owner %.*s");
		add(263   , 16 , "Must specify table to SELECT * FROM.");
		add(264   , 16 , "Column name %.*s appears more than once in the result column list.");
		add(265   , 16 , "Insufficient result space for %S_MSG conversion of %s value '%s' to a %s field.");
		add(266   , 16 , "Transaction count after EXECUTE indicates that a COMMIT or ROLLBACK TRAN is missing. Previous count = %d, Current count = %ld.");
		add(267   , 16 , "Object '%.*s' cannot be found.");
		add(268   , 16 , "You can't run SELECT INTO in this database. Please check with the Database Owner.");
		add(269   , 16 , "NULL value cannot be specified for conversion from datatype '%s' to '%s'.");
		add(270   , 16 , "Table '%.*s' can't be modified.");
		add(272   , 16 , "Can't update a TIMESTAMP column.");
		add(273   , 10 , "Warning: A non-null value cannot be inserted into a TIMESTAMP column by the user. The database timestamp value has been inserted into the TIMESTAMP field instead.");
		add(274   , 20 , "A SYSTEM exception was raised with an unrecognized minor number %d.");
		add(276   , 16 , "The parameter '%.*s' in the procedure '%.*s' was not declared as an OUTPUT parameter.");
		add(277   , 16 , "There was a transaction active when exiting the stored procedure '%.*s'. The temporary table '%.*s' was dropped in this transaction either explicitly or implicitly. This transaction has been aborted to prevent database corruption.");
		add(278   , 16 , "TEXT, IMAGE, UNITEXT and off-row Java datatypes may not be used in a GROUP BY clause.");
		add(279   , 16 , "TEXT, IMAGE, UNITEXT and off-row Java datatypes are invalid in this subquery or aggregate expression.");
		add(280   , 16 , "Only columns of TEXT, IMAGE and UNITEXT datatypes are valid with the TEXTPTR function.");
		add(281   , 16 , "%d is not a valid style number when converting from DATETIME to a character string.");
		add(282   , 10 , "Procedure '%.*s' attempted to return a status of NULL, which is not allowed.  A status of 0 will be returned instead.");
		add(283   , 16 , "You can't use browse mode with DBLIB 2.0 -- you must upgrade to DBLIB 4.0 in order to run this query.");
		add(284   , 16 , "Rules may not be bound to TEXT, IMAGE or UNITEXT datatypes.");
		add(285   , 16 , "READTEXT and WRITETEXT commands may not be used with views.");
		add(286   , 16 , "The logical tables INSERTED and DELETED may not be updated.");
		add(287   , 16 , "%s command not allowed within a trigger.");
		add(288   , 16 , "The PATINDEX function operates on CHAR, VARCHAR, UNICHAR, UNIVARCHAR, TEXT and UNITEXT datatypes only.");
		add(290   , 16 , "Trace 3604 is illegal within a stored procedure.");
		add(291   , 16 , "Access to %s is disallowed.");
		add(292   , 16 , "There is insufficient result space to convert SMALLMONEY value to CHAR.");
		add(293   , 16 , "Precomputed result set error: At least one of the base table is owned by a different user; only manual PRS is allowed on table owned by a different user.");
		add(294   , 16 , "The conversion from CHAR to SMALLMONEY resulted in a SMALLMONEY overflow error.");
		add(295   , 16 , "Cannot refresh '%.*s' because it is not a %S_MSG.");
		add(296   , 16 , "The conversion of CHAR to SMALLDATETIME resulted in a SMALLDATETIME value out of range.");
		add(297   , 16 , "There is insufficient result space to convert SMALLDATETIME value to CHAR.");
		add(298   , 16 , "The conversion from DATETIME to SMALLDATETIME resulted in a SMALLDATETIME overflow error.");
		add(299   , 16 , "The symbol '*' can only be used for a subquery select list when the subquery is introduced with EXISTS or NOT EXISTS or the subquery references a single table and column.");
		add(301   , 16 , "Query contains an illegal outer-join request.");
		add(303   , 16 , "The table '%.*s' is an inner member of an outer-join clause. This is not allowed if the table also participates in a regular join clause.");
		add(304   , 16 , "The table '%.*s' is outer-joined with itself.");
		add(305   , 16 , "The column '%.*s' (user type:%.*s) is joined with '%.*s' (user type:%.*s).  The user types are not compatible:  underlying types must be identical in order to join.");
		add(306   , 16 , "TEXT, IMAGE and UNITEXT datatypes may not be used in a WHERE clause, except with the LIKE expression and IS [NOT] NULL predicate on columns.");
		add(307   , 10 , "Index '%.*s' specified as optimizer hint in the FROM clause of table '%.*s' does not exist.  Optimizer will choose another index instead.");
		add(308   , 20 , "Table not open for range table entry '%d', objid '%ld', dbid '%d'.");
		add(309   , 20 , "Wrong sdes for range table entry '%d'. Expected object '%ld', dbid '%d', got object '%ld', dbid '%d'.");
		add(310   , 10 , "Index id %d on table id %ld cannot be used in the optimization of a query as it is SUSPECT. Please have the SA run DBCC REINDEX on the specified table.");
		add(311   , 16 , "The optimizer could not find a unique index which it could use to scan table '%.*s' for cursor '%.*s'.");
		add(312   , 16 , "Index id %d on table '%.*s' is explicitly specified in cursor '%.*s' declared for update. This index is either not unique or its key includes a column in the for update of list. This cursor my be closed on an update or a delete.");
		add(313   , 16 , "The optimizer could not find a unique index which it could use to perform an isolation level 0 scan on table '%.*s'.");
		add(314   , 16 , "WARNING: A non-unique clustered index has been forced on an isolation level 0 scan on table '%.*s'.  If the scan must restart, the scan will be repositioned at the beginning of the duplicate key group.  Thus, it is possible that this can infinitely loop.");
		add(315   , 18 , "Internal error - ASE was unable to find a join order to run this query. Please inform technical support.");
		add(316   , 17 , "Cannot compile the query because the space required for the search arguments (%d bytes) exceeds the maximum amount of memory that can be granted.  Try reducing the number of search arguments.");
		add(317   , 16 , "A subquery in this query is correlated to an inner table of an outerjoin. This is not allowed in TSQL semantics.");
		add(318   , 18 , "sysstatistics catalog was read and an inconsistency was found, please run update statistics and contact SAP Technical Support");
		add(319   , 18 , "Statistics cannot be read for table '%.*s', column '%.*s' due to previous errors");
		add(320   , 10 , "Index id %d on table id %ld cannot be used in the optimization of a query as it is SUSPECT. Please drop and re-create the index on the specified table.");
		add(321   , 18 , "Internal statistics calculation inconsistency. Please contact SAP Technical Support");
		add(322   , 18 , "Internal error: systabstats statistics could not be read, please contact SAP Technical Support.");
		add(323   , 10 , "WARNING: Edited statistics are overwritten. %S_PTNINFO. column: '%.*s'.");
		add(324   , 10 , "Invalid simulated value (%ld) ignored for %S_MSG '%.*s'. Actual value (%ld) used instead.");
		add(325   , 18 , "Adaptive Server finds no legal query plan for this statement. If an Abstract Plan is forcing the query plan, check its correspondence to the query. If not, please contact SAP Technical Support.");
		add(326   , 16 , "ALTER TABLE '%.*s' failed. The table is %d-way partitioned, and a %d-way parallel plan was generated due to lack of parallel resources. Increase the value of 'max parallel degree' and 'number of worker processes' to at least %d, and try again.");
		add(327   , 16 , "Option '%.*s' is not a valid option for the derived_stat function.");
		add(328   , 10 , "The query optimizer could not find a suitable plan for the current setting of the parallel degree. This query would run best if the parallel degree is increased to %d");
		add(329   , 10 , "The degree (%d) forced by user exceeds the stored partitioning degree (%d) of the table '%.*s'. The optimizer is ignoring the forced degree.");
		add(330   , 10 , "You have specified an invalid value %d as the optimization timeout limit in the abstract plan. A valid value is from 0 to 1000. Ignoring this value and using the default value of %d.");
		add(331   , 16 , "Query is too complex and has exhausted the name space for Ordering IDs, please breakup query into simpler components.");
		add(332   , 16 , "Schema for table '%.*s' has changed during optimization of this query. Please re-execute query.");
		add(333   , 10 , "You have specified an invalid value %d as the optimization timeout limit in the abstract plan inside a stored procedure. A valid value is from 0 to 4000. Ignoring this value and using the default value of %d.");
		add(334   , 10 , "Index hint is not supported on Virtually hashed tables.");
		add(335   , 20 , "Internal error: bitmap allocation inconsistency, please contact SAP Technical Support.");
		add(336   , 16 , "GROUP BY column count of %d exceeded maximum of %d columns.");
		add(337   , 16 , "Internal limits such as row width for the GROUP BY ALL with outer join has been exceeded");
		add(338   , 20 , "An internal error occurred when processing a GROUP BY ALL with an outer join, please refer this issue to SAP Technical Support");
		add(339   , 18 , "An internal overflow error occurred with the creation of an ordering list, please refer this issue to SAP Technical Support");
		add(340   , 18 , "Internal error: cannot determine the matched and the not matched value, please contact SAP Technical Support.");
		add(401   , 16 , "Unimplemented command or expression %s.");
		add(403   , 16 , "Invalid operator for datatype op: %s type: %s.");
		add(405   , 20 , "Cannot route query results - query internal representation corrupted - for operation %s, datatype %s.");
		add(406   , 23 , "Ord_needed: Can't find index for varno=%d, objid=%ld.");
		add(407   , 19 , "You query creates too many internal work tables and/or user tables: the maximum is %d. Simplify the query and try again.");
		add(408   , 20 , "Is_var: Unknown data type %d.");
		add(409   , 16 , "The %s operation cannot take a %s datatype as an argument.");
		add(410   , 20 , "Compute clause #%d, 'by' expression #%d is not in the order-by list.");
		add(411   , 20 , "Compute clause #%d, aggregate expression #%d is not in the select list.");
		add(412   , 16 , "Cannot update more than 1 sysindexes row at a time.");
		add(413   , 17 , "Maximum procedure %s count exceeded.  Limit is %d. Modify the procedure to use fewer %ss.");
		add(414   , 16 , "The current query would generate a key size of %d for a work table.  This exceeds the maximum allowable limit of %d.");
		add(415   , 16 , "The current query would require an index on a work table to be built with %d keys.  The maximum allowable number of keys is %d.");
		add(416   , 16 , "Create of work table failed because row size would be %d.  This exceeds the maximum allowable size of a row in a table, %d.");
		add(418   , 20 , "Can't find the real column name corresponding to the column heading '%.*s'.");
		add(420   , 16 , "The TEXT, IMAGE and UNITEXT datatypes cannot be used in an ORDER BY clause or in the select list of a query in a UNION statement.");
		add(421   , 16 , "TEXT, IMAGE, UNITEXT and off-row Java datatypes may not be selected as DISTINCT.");
		add(422   , 19 , "Too many nested expressions or logical operators to compile. Try splitting query or limiting ANDs and ORs.");
		add(423   , 20 , "Table referenced in a foreign key constraint is missing, database = '%S_DBID', table = '%S_OBJID'.");
		add(424   , 20 , "Failed to enforce a referential constraint, database = '%S_DBID', table = '%S_OBJID'.");
		add(425   , 20 , "Referencing table in a foreign key constraint is missing, database = '%S_DBID', table = '%S_OBJID'.");
		add(426   , 20 , "Primary key column referenced  in a foreign key constraint is missing, database = '%S_DBID', table = '%S_OBJID'.");
		add(427   , 20 , "Referencing column in a foreign key constraint is missing from system catalog, database = '%S_DBID', table = '%S_OBJID'.");
		add(428   , 20 , "There are more than %d referential constraints on table %.*s. Please reduce the number of referential constraints before trying this query.");
		add(429   , 18 , "Invalid constraint type passed to compile referential constraint.  This is an internal error.");
		add(430   , 18 , "Constraint id info in the resvar for check constraints is missing.  This is an internal error, database = '%S_DBID', table = '%S_OBJID'.");
		add(431   , 26 , "Node off RESDOM is not MULTARG as expected.");
		add(432   , 16 , "Security Label datatypes may not be used in an ORDER BY clause.");
		add(433   , 17 , "Unable to allocate work table to process referential constraint. Query exceeds the maximum limit (%d) of work tables. Either simplify the query or reduce the number of referential constraints on the tables involved in the query.");
		add(434   , 16 , "Work table cannot be allocated for processing the order by clause which requires a sort. Maximum limit (%d) of work tables is exceeded while processing this query. Simplify the query and retry.");
		add(435   , 16 , "Database '%.*s' is not available.  The '%s' statement will not be executed because the cross-database referential constraint on table '%.*s' cannot be enforced. Contact your System Administrator about the availability of database '%.*s'.");
		add(436   , 16 , "The '%s' statement will not be executed because the cross-database referential constraint on table '%.*s' cannot be enforced. A table or constraint definition is missing in database '%.*s'. Contact your System Administrator.");
		add(441   , 18 , "Deadlock occurred in SQL Process %d, While accessing referencing tables.");
		add(442   , 16 , "Maximum number of user tables under all sides of a UNION statement can not exceed %d. Please simplify the query and retry.");
		add(444   , 16 , "The index %d for the table %ld was not found in database %d. The index may have been dropped while this query was being compiled.");
		add(445   , 16 , "Compute clause referenced too many variable length columns; note that each aggregate occupies 2 columns, except for the AVG which occupies 4 columns. The maximum number of variable length columns is %d");
		add(446   , 16 , "The COMPUTE clause #%d, aggregate expression #%d may produce a result that is wider than 255 bytes, the maximum computed result allowed.");
		add(448   , 11 , "The %S_MSG created on %S_MSG '%.*s' is invalid because this %S_MSG no longer exist in %S_MSG '%S_DBID'.");
		add(449   , 16 , "UPDATE is not allowed because the statement updates view '%.*s' which participates in a join and has an INSTEAD OF UPDATE trigger.");
		add(450   , 16 , "DELETE is not allowed because the statement deletes view '%.*s' which participates in a join and has an INSTEAD OF DELETE trigger.");
		add(451   , 16 , "MERGE is not allowed because different MERGE actions are referenced in the same WHEN [NOT] MATCHED clause.");
		add(452   , 16 , "Abstract plan(AP) is not allowed in INSERT VALUES for non-dynamic batch insert case.");
		add(453   , 16 , "Invalid datatype for limit value, only INTEGER/INT can be used.");
		add(501   , 20 , "There is no result-list for a SELECT statement.");
		add(502   , 18 , "Internal error encountered in merging rows; resubmit query batch.");
		add(504   , 11 , "Stored procedure '%.*s' not found.");
		add(508   , 20 , "No begin-row pointer found in plan.");
		add(509   , 11 , "User name '%.*s' not found.");
		add(510   , 20 , "Bad eop type 0x%x .");
		add(511   , 16 , "Attempt to update or insert row failed because resultant row of size %d bytes is larger than the maximum size (%d bytes) allowed for this table.");
		add(512   , 16 , "Subquery returned more than 1 value.  This is illegal when the subquery follows =, !=, <, <= , >, >=, or when the subquery is used as an expression.");
		add(513   , 16 , "A column insert or update conflicts with a rule imposed by a previous CREATE RULE command. The command was aborted. The conflict occurred in database '%S_DBID', table '%S_OBJID', column '%.*s'");
		add(514   , 20 , "Expression stack overflow.  Usually this is because built-in functions have been nested too deeply.  Try to rephrase the query using less deeply nested functions.");
		add(515   , 16 , "Attempt to insert NULL value into column '%.*s', table '%.*s'; column does not allow nulls. Update fails.%S_EED");
		add(516   , 18 , "Attempt to get system date/time failed.");
		add(517   , 16 , "Adding a value to a %s field caused overflow.");
		add(518   , 16 , "Cannot convert type '%s' to type '%s'.");
		add(519   , 16 , "Overflow resulted from MONEY multiplication.");
		add(520   , 16 , "Overflow resulted from MONEY division.");
		add(521   , 16 , "Overflow resulted from MONEY addition.");
		add(522   , 16 , "Overflow resulted from MONEY subtraction.");
		add(523   , 16 , "Overflow resulted from %s minus operation.");
		add(524   , 16 , "Overflow resulted from MONEY remainder (modulo) operation.");
		add(526   , 18 , "ASE has run out of alarms. Re-run your command when there are fewer users running WAITFOR, or ask your System Administrator to raise the configuration parameter 'number of alarms'.");
		add(527   , 20 , "Cannot remove alarm.");
		add(528   , 20 , "System error detected during attempt to use upsleep system call.");
		add(529   , 16 , "Explicit conversion from datatype '%s' to '%s' is not allowed.");
		add(530   , 16 , "Attempt to insert NULL value into column %d in work table (table id %ld); column does not allow NULLS.  UPDATE fails.");
		add(532   , 16 , "The timestamp (changed to %.*s) shows that the row has been updated by another user.");
		add(533   , 20 , "Can't find a range table entry for range %d.");
		add(534   , 16 , "TEXT and IMAGE datatypes require DBLIB version 4.0 or greater.");
		add(535   , 16 , "Difference of two datetime fields caused overflow at runtime.");
		add(536   , 16 , "Invalid length parameter with value of %d passed to the substring function.");
		add(537   , 16 , "Overflow resulted from a SMALLMONEY remainder operation.");
		add(538   , 16 , "'%.*s' cannot be found.  This language might have been dropped.  Please contact a user with System Administrator (SA) role.");
		add(539   , 20 , "Unexpected internal access methods error %d, state %d. Please report to Technical Support the following information: dbid=%d, objectid=%d, curcmd=%d, plasterror=%d, pstat=0x%x, p2stat=0x%x, xactid=(%d, %d).");
		add(540   , 16 , "Schema for database object '%.*s' has changed since compilation of this query. Please re-execute query.");
		add(541   , 18 , "An unknown arithmetic exception type was reported.  The transaction has been aborted.  This is an internal system error.  Please contact a user with System Administrator (SA) role.");
		add(542   , 16 , "An invalid datetime value was encountered. Value exceeds year 9999.");
		add(543   , 18 , "Constraint id information not found upon constraint violation, dbname = '%S_DBID', table name = '%.*s'.  This is an internal error.");
		add(544   , 16 , "Unknown Constraint violation occurred, database =  '%.*s', table name = '%.*s', constraint name = '%.*s'.");
		add(545   , 18 , "Constraint violation occurred, entry for the constraint missing from system catalog, database =  '%.*s', table name = '%.*s', constraint name = '%.*s'.");
		add(546   , 16 , "Foreign key constraint violation occurred, dbname =  '%.*s', table name = '%.*s', constraint name = '%.*s'.%S_EED");
		add(547   , 16 , "Dependent foreign key constraint violation in a referential integrity constraint. dbname =  '%.*s', table name = '%.*s', constraint name = '%.*s'.%S_EED");
		add(548   , 16 , "Check constraint violation occurred, dbname =  '%.*s', table name = '%.*s', constraint name = '%.*s'.%S_EED");
		add(549   , 18 , "Constraint violation occurred, bad constraint type passed to the exception handler.");
		add(550   , 16 , "The attempted insert or update failed because the target view was either created WITH CHECK OPTION or spans another view created WITH CHECK OPTION.  At least one resultant row from the command would not qualify under the CHECK OPTION constraint.");
		add(551   , 20 , "An unknown EVAL was sent to the execution module.");
		add(552   , 16 , "A column insert or update conflicts with a rule bound to the column. The command is aborted. The conflict occured in database '%.*s', table '%.*s', rule '%.*s', column '%.*s'.%S_EED");
		add(553   , 16 , "The number of parameters/variables in the FETCH INTO clause does not match the number of columns in cursor '%.*s' result set.");
		add(554   , 16 , "The UPDATE/DELETE WHERE CURRENT OF to the cursor '%.*s' failed because the row has changed since it was fetched.");
		add(555   , 16 , "The UPDATE/DELETE WHERE CURRENT OF to the cursor '%.*s' failed because the key of the row used in identifying the row changed since it was fetched.");
		add(556   , 16 , "The table referenced in the UPDATE/DELETE WHERE CURRENT OF is not part of the result set tables of cursor '%.*s'.");
		add(557   , 16 , "The cursor '%.*s' can not be used as it could not be found. It is possible that either it was not declared or it is not available in the current context.");
		add(558   , 16 , "Attempt to open cursor '%.*s' which is already open.");
		add(559   , 16 , "Attempt to use a cursor '%.*s' which is not open. Use the system stored procedure sp_cursorinfo for more information.");
		add(560   , 16 , "The UPDATE/DELETE WHERE CURRENT OF failed for the cursor '%.*s' because it is not positioned on a row.");
		add(562   , 16 , "The CURINFO datastream was not sent before the cursor command so no current cursor context is available.");
		add(563   , 16 , "There is already another cursor with the name '%.*s' at the nesting level '%ld'.");
		add(564   , 16 , "The cursor identifiers are not available.");
		add(565   , 16 , "The open processing for cursor '%.*s' did not stop anywhere. The DECLARE CURSOR could have been an invalid statement or there is some internal problem.");
		add(566   , 26 , "The procedure buffer is not linked to the procedure header for an execute cursor '%.*s'. This is probably an internal system problem.");
		add(567   , 14 , "You must have the following role(s) to execute this command/procedure: '%.*s'. Please contact a user with the appropriate role for help.");
		add(568   , 14 , "The caller does not have the required System Security Officer (SSO) role. Please contact a user with System Security Officer (SSO) role for help.");
		add(569   , 16 , "The specified object with object ID '%d' is not found.");
		add(570   , 14 , "Only a person with System Security Officer (SSO) role can change another person's password.");
		add(571   , 16 , "Invalid user specified, password left unchanged.");
		add(572   , 14 , "Invalid caller's password specified, password left unchanged.");
		add(573   , 16 , "New password specified is too short. Minimum length of acceptable passwords is 6 characters.");
		add(574   , 16 , "New password supplied is the same as the previous password.  Please supply a different new password.");
		add(575   , 16 , "Error occured in internal encryptionroutines.");
		add(576   , 18 , "Access was denied into the master database.  Password left unchanged.");
		add(577   , 18 , "The caller of the set_password builtin was not found!  Password left unchanged.");
		add(578   , 18 , "Date acquisition function failed.  Unable to retrieve the correct date in the set_password builtin function.  Password left unchanged.");
		add(579   , 18 , "Unable to start a transaction in the set_password builtin. Password left unchanged.");
		add(580   , 18 , "Unable to update Syslogins in the set_password builtin.  Password left unchanged.");
		add(581   , 18 , "Unable to open Syslogins table in the set_password builtin.  Password left unchanged.");
		add(582   , 16 , "Cursor '%.*s' was closed implicitly because the current cursor position was deleted due to an update or a delete. The cursor scan position could not be recovered. This happens for cursors which reference more than one table.");
		add(583   , 16 , "The cursor '%.*s' had it's current scan position deleted either because of a DELETE/UPDATE WHERE CURRENT OF or a regular searched DELETE/UPDATE. You must do a new FETCH before doing an UPDATE or DELETE WHERE CURRENT OF.");
		add(584   , 16 , "Explicit value specified for identity field in table '%.*s' when '%s' is OFF.");
		add(585   , 16 , "Explicit value must be specified for identity field in table '%.*s' when IDENTITY_INSERT or IDENTITY_UPDATE is ON.");
		add(586   , 16 , "Illegal identity value specified for identity field '%.*s' in table '%.*s'.");
		add(587   , 16 , "Identity value overflow for field '%.*s' in table '%.*s'.");
		add(588   , 20 , "Failure adding identity column to table '%.*s' via select into.");
		add(589   , 16 , "Invalid role string received.");
		add(590   , 16 , "Dynamic SQL error - Prepared statement '%.*s' does not exist.");
		add(591   , 16 , "Dynamic SQL error - Prepared statement '%.*s' is already being used by a cursor.");
		add(592   , 16 , "The DELETE WHERE CURRENT OF to the cursor '%.*s' failed because the cursor is on a join.");
		add(593   , 16 , "The UPDATE WHERE CURRENT OF to the cursor '%.*s' failed because column '%.*s' being updated was not specified in the FOR UPDATE OF list.");
		add(594   , 16 , "The UPDATE WHERE CURRENT OF to the cursor '%.*s' failed because column '%.*s' being updated was not specified in the SELECT list.");
		add(595   , 16 , "Trying to return NULL from stored procedure for bit variable '%.*s'");
		add(596   , 17 , "Your query overflowed the space allocated for aligning internal data structures. Please simplify your query by breaking it up into a series of shorter queries.");
		add(599   , 16 , "The procedure, '%.*s', that cursor '%.*s' is declared on has been dropped and recreated since the first time the cursor was opened.");
		add(601   , 21 , "Descriptor for system table '%ld' in database '%d' not found in the descriptor hash table.");
		add(602   , 21 , "Could not find row in sysindexes for dbid '%d', object '%ld',index '%d'. Run DBCC CHECKTABLE on sysindexes.");
		add(603   , 17 , "There are not enough system session descriptors available to run this query. Raise the value of the configuration parameter 'number of aux scan descriptors' or retry your query later.");
		add(604   , 21 , "Could not find row in sysobjects for object '%ld' in database '%.*s'.  Run DBCC checktable on sysobjects.");
		add(605   , 21 , "An attempt was made to fetch logical page '%u' from cache '%.*s'. Page belongs to %S_PTNINFO and not to %S_PTNINFO.");
		add(607   , 21 , "Insufficient room was allocated in the session descriptor for object '%.*s' for search arguments. Only %d search arguments were anticipated.");
		add(610   , 19 , "Maximum number of databases that may be accessed by a transaction is 16. This number has been exceeded by this query.");
		add(611   , 21 , "Attempt made to end a transaction that is idle or in the middle of an update.");
		add(612   , 21 , "Attempt made to log a row of unknown type %d.");
		add(613   , 21 , "Request made to retrieve more rows from an already completed scan  of object '%.*s' in database '%.*s'.");
		add(614   , 21 , "Adaptive Server accessed a row that has an illegal length of %d while in data base '%.*s'. %S_PAGE. The minimum row length is %d. The page size is %d.");
		add(615   , 21 , "Unable to find database table.");
		add(616   , 20 , "Attempt to hash a previously hashed descriptor for object '%.*s'  in database '%.*s'.");
		add(617   , 20 , "Descriptor for object '%ld' in database '%d' not found in the hash table during attempt to unhash it.");
		add(618   , 21 , "A varno of %d was passed to opentable - the largest valid value is %d.");
		add(619   , 20 , "A deferred update was requested but the query is not one of INSERT, DELETE or UPDATE.");
		add(620   , 21 , "Log record encountered at deferred update time with either a row length of less than 2 or an invalid log type. The log type was %d and the row length was %d.");
		add(621   , 21 , "A log record was encountered of type %d that is not one of the valid  deallocation types.");
		add(622   , 20 , "Opentable was passed a varno of %d. Object '%.*s' in database '%.*s' already has that session descriptor in use. This occured while opening object id %d in database id %d.");
		add(623   , 21 , "Adaptive Server failed to retrieve a row via its RID in database '%.*s' because the target page is not a data page. %S_RID. %S_PAGE.");
		add(624   , 21 , "Adaptive Server failed to retrieve a row via its RID in database '%.*s' because the requested RID has a higher number than the last RID on the page. %S_RID. %S_PAGE.");
		add(625   , 21 , "Adaptive Server failed to retrieve a row via its RID in database '%.*s' because the entry in the offset table for that RID is less than or equal to 0. %S_RID. %S_PAGE.");
		add(627   , 20 , "A transaction tried to call beginupdate while in state 'prepare'.");
		add(628   , 13 , "Attempt to issue 'SAVE TRANsaction' when there is no active transaction.");
		add(629   , 21 , "Clustered index row entry for data page %u is missing in index page %u of table '%S_OBJID' in database '%S_DBID'; index row contains data page %u instead. You can recreate the clustered index to fix this error. Xactid is (%u,%d).");
		add(630   , 21 , "The end of page limit has been exceeded while building an offset table for object %d on page %u, page addr 0x%lx, eop addr 0x%lx, sargptr addr 0x%lx.");
		add(631   , 21 , "The length of %d passed to delete row routine for the row at offset %d is incorrect on the following page of database '%S_DBID': %S_PAGE. The expected row length is %d. The offset should be no greater than %d.");
		add(632   , 20 , "Attempt to move memory with an incorrect length of %d. Maximum allowed length is %d.");
		add(633   , 21 , "The PG_DEALLOC bit set by recovery is on at runtime on the following page. %S_PAGE.");
		add(634   , 20 , "Memmove() was called with an address of 0x%lx and a length of %d - which would cross the boundary address of 0x%lx.");
		add(635   , 20 , "Process %d tried to remove DES resource lock that it doesn't hold  - %S_DES .");
		add(637   , 20 , "Index shrink program returned invalid status of 0.");
		add(638   , 20 , "Memmove() was called with an address of 0x%lx - which is not allocated memory.");
		add(639   , 21 , "Attempt to fetch logical page %u dbid %d failed - page is not currently allocated.");
		add(640   , 21 , "Attempt to insert/delete row on wrong type of page. %S_PAGE.");
		add(641   , 21 , "Attempt to add BEGINUPDATE record in transaction %S_RID that already has an active CMD.");
		add(642   , 20 , "Attempt to begin update in transaction %S_RID which already has an active transaction.");
		add(643   , 20 , "Attempt to read page %u in database '%.*s' which is not allocated.");
		add(644   , 21 , "Index row entry for data row id (%u, %d) is missing from index page %u of index id %d of table '%S_OBJID' in database '%S_DBID'. Xactid is (%u,%d). Drop and re-create the index.");
		add(649   , 21 , "Could not find the clustered index entry for Page %u Objid %d status 0x%x. Index page %u was searched for this entry in database '%.*s'.");
		add(650   , 26 , "Page %u of table '%.*s' (id = %d) in dbid %d not locked.");
		add(651   , 26 , "Startscan was called with an illegal combination of index and scan mode.");
		add(652   , 20 , "The buffer 0x%lx should be kept in sdes 0x%lx on entry to this function and it is not.");
		add(653   , 26 , "Buffer not rlocked. %S_BUF. %S_PAGE.");
		add(654   , 26 , "Page %u, dbid %d not exclusive locked.");
		add(655   , 26 , "Page should be marked as having overflow page: %S_PAGE.");
		add(656   , 26 , "Locking not stipulated while attempting to modify page.  %S_PAGE.");
		add(657   , 26 , "Passed buffer pointer for previous page is for page %u, when the actual previous page is %u. These pages are in database '%*.s'.");
		add(658   , 22 , "Last log page in database '%.*s' incorrectly identified as page %u. Run DBCC checktable on syslogs.");
		add(659   , 16 , "Table id %ld contains suspect indexes. This table is only available for read-only purposes until the DBCC REINDEX command has been run on the indicated table to rebuild its suspect indexes.");
		add(660   , 10 , "Index id %d cannot be used to access table id %d as it is SUSPECT. Please have the SA run the DBCC REINDEX command on the specified table.");
		add(661   , 21 , "As part of a transaction rollback, an attempt was made to modify object '%S_OBJID' in database '%.*s', even though the current session is not holding an exclusive lock on that object.");
		add(662   , 18 , "The index with index id '%d' on object with object id = '%d' was not found during cursor scan fixups. The fixup was being done for cursor '%.*s'. This is an internal error.");
		add(663   , 18 , "The lock on page '%u' for object with object id = '%d' could not be obtained during cursor scan fixups. The fixup was being done for cursor '%.*s'. This is an internal error.");
		add(664   , 18 , "The parameters passed to cursfix_main() were not correct. This is an internal error.");
		add(665   , 18 , "The cursor fixup is being done for the pre delete case with the data row for a scan using a non-clustered index and there was no fixup done for pre-delete of the non-clustered index row. This is an internal error.");
		add(666   , 18 , "The current position deleted bit is set for an SDES but there is no fixup information saved. This is an internal error.");
		add(667   , 26 , "Illegal locking strategy encountered at scan initialization.  Object %S_OBJID, database %S_DBID.  This is an internal error.");
		add(668   , 18 , "The cursor '%.*s' which is scanning a list of rids i.e a work table is having it's tables changed. This cursor should be read only and the tables should be private to it's query. This is an internal error.");
		add(669   , 18 , "The length computation of the row %d is wrong. Ensure that row-length is no greater than max possible size of %d. This error was detected during cursor scan fixups for cursor '%.*s'. This is an internal error.");
		add(670   , 16 , "Out of bound insert attempted on table '%.*s'.");
		add(671   , 14 , "Writetext is not allowed in reclassify mode.");
		add(672   , 16 , "Out of bound update attempted on table '%.*s'.");
		add(673   , 16 , "Out of bound delete attempted on table '%.*s'.");
		add(674   , 20 , "Invalid Buffer Cache Access: Attempt to locate page '%u', database '%d' in cache failed because the cache id '%d' in scan_context is invalid. scan_context={objid '%d', indid '%d', cid '%d'}. Contact Technical Support for assistance.");
		add(675   , 20 , "Invalid Buffer Cache Access: Attempt to locate page '%u', database '%d' in cache failed because no object id was specified. scan_context={objid '%d', indid '%d', cid '%d'}. Contact Technical Support for Assistance.");
		add(676   , 21 , "NULL cache id specified in log record.");
		add(677   , 20 , "Invalid Buffer Cache Access: Attempt to locate page '%u', dbid '%d', objid '%d', indid '%d' in cache failed because the cache ID was not set in the scan_context structure. Contact Technical Support for assistance.");
		add(678   , 20 , "Invalid Buffer Cache Access: Could not open object '%ld' in database '%d'");
		add(679   , 20 , "Inconsistent update state found during expensive direct update of object '%ld'.");
		add(680   , 20 , "Attempt to extend the log in database '%.*s' failed due to an internal error. The returned status was %d.");
		add(682   , 20 , "The buffer 0x%lx , page number '%u' for object '%.*s' in database '%.*s' should be latched on entry to this function and it is not.");
		add(683   , 20 , "Failed to get lock on data page '%u' row '%d' for object '%.*s' in database '%.*s'.");
		add(684   , 26 , "Page %u, Row %d, for object '%.*s' in database '%.*s' is not exclusive locked.");
		add(685   , 21 , "Expected page %u to be in cache '%.*s' for object id %d, index id %d, database id %d. Instead, the server brought the page into wrong cache '%.*s'.");
		add(686   , 20 , "Page %u is corrupted.");
		add(688   , 21 , "Insufficient CFS while redo of expanding update on page %u belonging to object %d. CFS - %d, length of new row - %d");
		add(689   , 10 , "An unexpected log record (log op %d) was encountered when scanning the log for a trigger.");
		add(690   , 20 , "Pageno in lk_pglocked (%u) different from lockobj (%u).");
		add(691   , 20 , "Encountered invalid logical page '%u' while accessing %S_PTNINFO. This is an internal system error. Please contact SAP Technical Support.");
		add(692   , 20 , "Uninitialized logical page '%u' was read while accessing %S_PTNINFO. Please contact SAP Technical Support.");
		add(693   , 20 , "Multiple copies of logical page '%u' from %S_PTNINFO reside in more than one cache. This is an internal system error. Please contact SAP Technical Support.");
		add(694   , 24 , "An attempt was made to read logical page '%u', virtpage '%d' from virtual device '%d' for %S_PTNINFO. The page was not read successfully. You may have a device problem or an operating system problem.");
		add(695   , 21 , "An attempt was made to read logical page '%u' for %S_PTNINFO from disk. Wrong logical page '%u' was brought into cache '%.*s'. If pages are being signed, this may indicate a signature check failure.");
		add(696   , 21 , "An attempt was made to fetch logical page '%u' from cache '%.*s'. Page belongs to %S_PTNINFO and not to %S_PTNINFO. Restart of ASE will clear the error. Please contact your System Administrator for help.");
		add(697   , 21 , "An attempt was made to fetch logical page '%u' for %S_PTNINFO from cache '%.*s'. Wrong logical page '%u' was found in cache.");
		add(698   , 21 , "An attempt was made to access row from cache '%.*s'. It belongs to row id ('%u', '%u') %S_PTNINFO and not to row id ('%u', '%u') %S_PTNINFO.");
		add(701   , 17 , "There is not enough procedure cache to run this procedure, trigger, or SQL batch. Retry later, or ask your SA to reconfigure ASE with more procedure cache.");
		add(702   , 20 , "Memory request for %d bytes exceeds the size of single page of %d bytes.");
		add(703   , 17 , "You cannot run this procedure, trigger, or SQL batch because it requires more than %ld pages of memory. Break it up into shorter queries, if possible.");
		add(704   , 20 , "Tried to free procedure header 0x%lx, but it's still in use by procedure '%.*s' at procedure buffer 0x%lx.");
		add(705   , 19 , "There is no room for process %d to store PROC_HDR 0x%lx in Pss.");
		add(706   , 20 , "Process %d tried to remove PROC_HDR 0x%lx that it does not hold in Pss.");
		add(707   , 20 , "System error detected during attempt to free memory at address 0x%lx. Please consult the ASE error log for more details.");
		add(708   , 17 , "There is insufficient system memory to run kernel task.  spid %d, kpid %d.");
		add(709   , 17 , "There is insufficient system memory to continue login process for spid %d.");
		add(710   , 20 , "Memory request for %d bytes is too small.");
		add(711   , 17 , "There is presently insufficient system memory to allocate %d bytes for new structures. Please try again when there is less activity on the system.");
		add(712   , 17 , "There is insufficient heap memory to allocate %ld bytes. Please increase configuration parameter 'heap memory per user' or try again when there is less activity on the system.");
		add(713   , 16 , "Sort failed because there is insufficient procedure cache for the configured number of sort buffers. Please retry the query after configuring lesser number of sort buffers.");
		add(714   , 20 , "Unable to locate a procedure cache memory control descriptor for memory '0x%p' allocated by process %d.");
		add(715   , 20 , "Unable to locate a procedure cache memory control descriptor for memory '0x%p' in the global list.");
		add(716   , 16 , "Unable to allocate memory of size %d bytes from the '%S_MSG' pool.");
		add(717   , 20 , "The last prochdr associated with the passed in main prochdr is incorrect. Last prochdr: '0x%p'. Main prochdr: '0x%p'. This is an Adaptive Server internal error. Please report the problem to SAP Techincal Support.");
		add(718   , 20 , "Memory allocation from process private memory is being performed by an incorrect process. Current Spid: '%d'. Owning Spid: '%d'. Memory: '0x%p'. This is an Adaptive Server internal error. Please contact SAP Tech Support.");
		add(719   , 20 , "The last prochdr value is not available for the prochdr '0x%p'. This is an Adaptive Server internal error. Please contact SAP Tech Support.");
		add(720   , 17 , "Unable to allocate a procedure memory control descriptor. Please increase the value of the configuration parameter '%s' or try again when there is less activity on the system.");
		add(721   , 20 , "The prochdr '0x%p' has large allocation enabled incorrectly. This is an Adaptive Server internal error. Please contact SAP Tech Support.");
		add(722   , 17 , "Procedure cache exhausted before a query plan could be found.");
		add(724   , 20 , "Internal Error: Function '%s' was passed an illegal size value (%d).");
		add(725   , 17 , "%s: failed to allocate %u bytes from Adaptive Server's main memory pool.");
		add(726   , 20 , "Unallocated %s memory at 0x%p is being used, Memory deallocated at file=%s, line=%d.");
		add(727   , 20 , "Access to memory outside the %s boundary. %s at 0x%p of Size = %d, Memory Accessed 0x%p at Offset = %d for size = %d, Memory allocated at file=%s, line=%d.");
		add(728   , 17 , "Allocation of size %d bytes from the row storage cache, '%.*s', failed as there is not enough memory available in the cache. Please increase the cache size. Memory allocator information = 0x%x, object ID = %d, partition ID = %d, request type = %d (%s).");
		add(729   , 10 , "%s could not clean %d bytes from the row storage cache, '%.*s'. Please drop and recreate the cache before reusing it.");
		add(801   , 20 , "Process %d tried to remove resource lock it doesn't hold on buffer 0x%lx - %S_PAGE in cache %s.");
		add(803   , 20 , "Unable to place buffer '0x%lx' from cache '%.*s' holding logical page '%u' in sdes for object '%.*s' - either there is no room in sdes or buffer already in requested slot.");
		add(804   , 20 , "Unable to find buffer '0x%lx' from cache '%.*s' holding logical page '%u' in sdes '0x%lx' kept buffer pool for object '%.*s'.");
		add(805   , 21 , "Unable to find descriptor for object '%.*s' in database '%.*s' in hash table when marking buffer dirty or flushing syslogs.");
		add(806   , 21 , "Could not find virtual page for logical page %u in database '%S_DBID'.");
		add(807   , 10 , "Logical page %u in buffer 0x%lx already kept in SDES for object '%.*s' in database '%.*s'.");
		add(808   , 20 , "Alloc page buffer pool in Pss is full - logical pages %u, %u, and %u in respective databases '%.*s', '%.*s' and '%.*s' are already held there. Cannot add logical page %u in database '%.*s'.");
		add(809   , 20 , "Buffer 0x%lx, alloc pg %u, in database '%.*s' not in alloc buf pool in Pss.");
		add(810   , 20 , "Attempt to pin log page buffer.");
		add(811   , 21 , "Attempt to grab buffer (from cache '%.*s') which is on descriptor chain.");
		add(812   , 21 , "Attempt to grab a pinned buffer.");
		add(813   , 20 , "Logical page '%u' in database '%S_DBID', cache '%.*s' is already hashed.");
		add(814   , 20 , "Keep count of buffer '0x%lx' in cache '%.*s' holding logical page '%u' in database '%.*s' has become negative.");
		add(815   , 21 , "Unable to find buffer holding sysindexes page in the cache - pageno = %u dbid = %d.");
		add(816   , 20 , "Process %d tried to remove a buffer resource lock %S_BUF that it does not hold in SDES %S_SDES.");
		add(817   , 20 , "Process %d tried to remove a buffer resource lock %S_BUF that it does not hold in Pss 0x%lx.");
		add(818   , 19 , "There is no room to hold the buffer resource lock %S_BUF in SDES %S_SDES.");
		add(819   , 19 , "There is no room for process %d to hold buffer resource lock %S_BUF in Pss.");
		add(820   , 21 , "Attempt to dirty non-log buffer %S_BUF which is in I/O.");
		add(821   , 20 , "Attempt to unhash buffer in cache '%.*s' at '0x%lx' with a buffer pageno of '%u' and database id '%d' with HASHED status set failed - buffer was not found. '%S_PAGE'.");
		add(822   , 21 , "Could not start I/O for request BLKIO flags = 0x%lx, size = %ld, errcode = 0x%lx, %S_BUF.");
		add(823   , 24 , "I/O error detected during %S_MSG for %S_BUF.");
		add(824   , 21 , "Attempt made to write page in buffer in database that has no entry in sysdatabases. %S_BUF.");
		add(825   , 21 , "Attempt made to write page in buffer in database with no DBTABLE structure - sysdatabases row marked as in use by process %d. %S_BUF.");
		add(826   , 20 , "Attempt made to hold allocation page %u that is already in Pss pool. Database '%.*s'.");
		add(827   , 20 , "Attempt to re-link buffer %p, page ptr: %p, dbid: %d, pageno: %u already present in des dirty chain.");
		add(829   , 21 , "A problem with ordered writes was detected. Please call SAP.");
		add(830   , 20 , "Invalid magic number %ld for aux kept buffer structure 0x%x, for sdes 0x%x, object id %ld.");
		add(831   , 20 , "Unable to find buffer 0x%x holding logical page %u in sdes 0x%x, aux keep struct 0x%x, for object '%.*s'.");
		add(832   , 20 , "Unable to place buffer 0x%x holding logical page %u in sdes for object '%.*s' - there is no room in sdes aux keep pool.");
		add(833   , 20 , "Attempt to read logical page %u, database '%S_DBID' into buffer 0x%x that is hashed.");
		add(834   , 20 , "Illegal attempt to clean buffer: %S_BUF.");
		add(835   , 20 , "Illegal attempt to change contents of buffer: %S_BUF.");
		add(836   , 21 , "Attempted to grab lru header.");
		add(837   , 21 , "Attempted to grab wash header.");
		add(838   , 21 , "Grabbed buffer not marked in wash: %S_BUF.");
		add(839   , 21 , "Grabbed buffer dirty but not writing: %S_BUF.");
		add(840   , 17 , "Device '%.*s' (with physical name '%.*s', and virtual device number %d) has not been correctly activated at startup time.  Please contact a user with System Administrator (SA) role.");
		add(841   , 10 , "Attempt to set bufreserves in RESOURCE structure to negative value while unclaiming cache.");
		add(842   , 20 , "Attempt to set bufclaims in PSS structure for process %d to negative value while unclaiming cache.");
		add(843   , 20 , "Unable to find original instance of buffer '0x%x' holding logical page '%u' in cache '%.*s' for object '%.*s'.");
		add(844   , 20 , "Attempt to unpredirty buffer %S_BUF which is %s.");
		add(845   , 20 , "Attempt to do a large I/O for page %u in database '%.*s' with buffer 0x%x, which is not a large buffer.");
		add(846   , 10 , "Hardware error detected writing logical page %u, device %d, virtual page %d for dbid %d, cache '%.*s'. The user process will sleep until write completes successfully.");
		add(847   , 10 , "Checkpoint process detected hardware error writing logical page '%u', device %d, virtual page %d for dbid %d, cache '%.*s'. It will sleep until write completes successfully.");
		add(848   , 21 , "Could not start I/O for device '%.*s' (with physical name '%.*s', and virtual device number %d).  Operating system error %d.");
		add(849   , 21 , "I/O error detected for device '%.*s' (with physical name '%.*s', and virtual device number %d).");
		add(850   , 20 , "Wrong cache descriptor in buffer '0x%x', page '%u', dbid '%d'. Cache descriptor points to cache '%.*s'.");
		add(851   , 20 , "Wrong cluster mask for cache '%.*s', mask encountered = %d, should = %d.");
		add(852   , 20 , "Command Failed: Invalid request to move '%ld' buffers from the '%ld'K pool of the '%.*s' cache to the '%ld'K pool.  Source pool only contains '%ld' buffers.  Retry the command specifying fewer buffers.");
		add(853   , 16 , "Invalid Configuration: Unable to start ASE since no information is available for configuring the data cache. The server may be started with a default configuration using the -c startserver option.");
		add(854   , 20 , "Fatal buffer pool error. Please contact SAP Technical Support.");
		add(855   , 16 , "Bad prefetch size of %d encountered.");
		add(856   , 16 , "Command Failed: Cannot move buffers from the '%ld'K pool to the '%ldK' pool. '%ld'K pool does not exist.  Please specify a valid buffer pool.");
		add(857   , 16 , "Command Failed: Cannot bind or unbind database '%S_DBID' to or from a cache as it is currently in use. If it is a user created temporary database, it is considered to be in use if some session is assigned to it. Refer to the users manual for more detail.");
		add(858   , 16 , "Cache '%.*s' does not exist.");
		add(859   , 20 , "Invalid Buffer Cache Access: Attempt to locate page '%u', database '%d' in cache failed because the cache id '%d' in scan_context is invalid. Scan_context = {objid '%d', indid '%d', cid '%d'}. Contact Technical Support for assistance.");
		add(860   , 20 , "Invalid Buffer Cache Access: Attempt to locate page '%u', dbid '%d' objid '%d', indid '%d' in cache failed because the cache ID was not set in the scan_context structure. Contact Technical Support for assistance.");
		add(861   , 16 , "Command Failed: Cannot bind object '%ld', dbid '%d' to cache because you have an open cursor on the target object.  Retry the command after closing the cursor.");
		add(862   , 16 , "Command Failed: Database '%d' must be in single user mode to bind target object.");
		add(863   , 17 , "Buffer resources in cache %s, id %d are unavailable. Please re-run this query or ask the system administrator to re-configure buffer cache memory.");
		add(864   , 16 , "Command Failed: Cannot bind object '%ld', dbid '%d' to cache because you have active level0 scans on the target object. Retry the command after terminating the scans.");
		add(865   , 21 , "Error deleting row from Sysattributes during cache binding validation.");
		add(866   , 21 , "Error inserting row into Sysattributes during cache binding validation.");
		add(867   , 16 , "The system table Sysattributes or its indices may not be bound to a named cache.");
		add(868   , 16 , "The system table Sysallocpg may not be bound to a named cache.");
		add(869   , 21 , "Error updating row %S_RID in Sysattributes during cache binding validation.");
		add(870   , 10 , "WARNING!!! You may have to change the log I/O size for the database '%.*s'. Current setting is '%dK' and the cache '%.*s' does not have a '%dK' memory pool.");
		add(871   , 20 , "Process %d is trying to release a latch on buffer 0x%x (dbid: %d, pageno: %u) without holding a latch on the buffer.");
		add(872   , 20 , "Process %d is trying to get a %s latch on buffer 0x%p (dbid: %d, pageno: %u) while already holding a %s latch on the buffer.");
		add(873   , 20 , "Process %d is requesting %s latch on buffer 0x%x (dbid: %d, pageno: %d) while holding %d latches. A process can hold only %d latches at a time.");
		add(874   , 20 , "Process %d is trying to unkeep buffer 0x%x (dbid: %d, pageno: %d) without releasing the %s latch it holds on the buffer.");
		add(875   , 20 , "Unable to grab a buffer to allocate a page to the log in database id %d. Tried %d buffers in the wash but found them to be pinned (either directly or indirectly). See the error log for more information.");
		add(876   , 20 , "The process is holding log semaphore on database %d and is about to sleep on mass=0x%x with stat=0x%x for page=%u which is being written by some other process that needs the log semaphore. This causes a deadlock, and can only be cleared by a reboot.");
		add(878   , 21 , "Task %d was expected to hold latch on buffer 0x%x of page %u in database %d.");
		add(879   , 21 , "Task %d was expected to hold exclusive latch on buffer 0x%x of page %u in database %d.");
		add(880   , 10 , "Your query is blocked because it tried to write and database '%.*s' is in a quiesced state. Your query will proceed after the DBA performs QUIESCE/PREPARE DATABASE RELEASE.");
		add(881   , 20 , "Could not start I/O for request for a page in extended cache BLKIO flags = 0x%lx, size = %ld, errcode = 0x%lx, %S_BUF.");
		add(882   , 10 , "Extended cache memory is too fragmented. Delete and re-create the cache of the required size.");
		add(883   , 26 , "Unable to set value for the page %u in database with dbid %d and cache id %d. Internal Error.");
		add(884   , 20 , "Unable to configure DMA key for the object lock for database (%.*s) dbid (%d). The command will be aborted.");
		add(885   , 20 , "Synchronization error while getting the last log page for database (%.*s) dbid %d. Contact SAP support for help.");
		add(886   , 20 , "Internal Error!! Contact SAP Technical Support for help. Physical lock synchronization error. Release not expected on %d %d %d.");
		add(887   , 20 , "Internal Error!! Contact SAP Technical Support for help. Too many tries for physical lock on %d %d %d");
		add(889   , 20 , "Internal error. Contact SAP Technical Support for help. BCM thread found MASS 0x%p in database '%.*s' (%d) and cache '%.*s' (%d) in an unexpected state (0x%lx).");
		add(890   , 20 , "The mass containing the buffer '%S_BUF' should not be written in its current state. This is an Adaptive Server internal error. Please contact SAP Technical Support.");
		add(891   , 20 , "Trying to unhash a buffer which is in Dirty state for dbid %d pageno %u is illegal. Please contact SAP Technical Support.");
		add(892   , 20 , "Process %d is holding a latch on buffer 0x%x (dbid: %d, pageno: %u) without holding a physical lock on the buffer.");
		add(893   , 20 , "Fatal Error: Physical lock on page %u, dbid %d is being downgraded while the buffer is in dirty state. Please contact SAP Technical Support.");
		add(894   , 10 , "Warning: Specified named cache '%.*s' does not exist in any instance of the cluster.");
		add(895   , 20 , "Failover recovery has removed the buffer 0x%lx for dbid %d, pageno %u from the large buffer pool, aborting the transaction. Try re-running the transaction.");
		add(896   , 20 , "Server %d cannot allocate object in the remote page request pool.");
		add(897   , 20 , "Internal Error: Server %d was unable to allocate DMA key for dbid %d page %u. Please contact SAP Technical Support for further assistance.");
		add(898   , 20 , "Server %d found dirty buffers in cache %s marked deleted. Delete operation did not complete successfully. Try the delete operation again.");
		add(899   , 20 , "The page %u requested for in-memory %S_OBJINFO was not found in in-memory storage cache '%.*s' (id %d). Please contact SAP Technical Support.");
		add(902   , 24 , "Hardware error detected reading logical page %u, virtual page %d in database '%.*s'.");
		add(903   , 23 , "Unable to find row in sysindexes for clustered index on system catalog %d in database %d. This index should exist in all databases.  Run DBCC CHECKTABLE on sysindexes in the database.");
		add(904   , 22 , "Unable to find master database row in sysdatabases. Cannot open master database.");
		add(905   , 17 , "Unable to allocate a DBTABLE descriptor to open database '%S_DBID'. Close or drop another database before opening this one, or ask your System Administrator to raise the configuration parameter 'number of open databases'.");
		add(906   , 23 , "Could not locate row in sysobjects for system catalog %d in database %d.  This system catalog should exist in all databases.  Run DBCC CHECKTABLE on sysindexes in the database.");
		add(908   , 22 , "Unable to find any entries in sysusages for dbid '%d', database '%S_DBID'. Run DBCC CHECKTABLE on sysusages in the master database.");
		add(909   , 21 , "More than %d entries required to build the logical-virtual translation table for database '%S_DBID'. The database is too fragmented.");
		add(910   , 17 , "Could not allocate a new object descriptor for required system catalog in database '%d'. Another database must be closed or objects in another database dropped in order to open this database.");
		add(911   , 16 , "Attempt to locate entry in sysdatabases for database '%.*s' by name failed - no entry found under that name. Make sure that name is entered properly.");
		add(912   , 21 , "DBTABLE descriptor cannot be found for database '%.*s' which is supposed to be already open.");
		add(913   , 11 , "Could not find row in sysdatabases with database id %d.");
		add(915   , 21 , "Descriptor for system catalog '%.*s' not found in DBTABLE chain for database '%.*s' - all system catalogs should reside permanently in this chain.");
		add(916   , 14 , "Server user id %d is not a valid user in database '%.*s'");
		add(917   , 20 , "Illegal attempt to close the master database for the last time - this database must always be open.");
		add(918   , 14 , "Database '%.*s' has not yet been recovered - please wait before accessing this database.");
		add(919   , 21 , "Database '%.*s' was marked 'suspect' by an earlier attempt at recovery. Check the ASE errorlog for information as to the cause.");
		add(920   , 22 , "Could not find syslogs row in sysindexes for database '%.*s'. Run DBCC CHECKTABLE on this system catalog.");
		add(921   , 14 , "Database '%.*s' has not been recovered yet - please wait and try again.");
		add(922   , 14 , "Database '%.*s' is being recovered - will wait until recovery is finished.");
		add(923   , 14 , "User %d not allowed in database '%.*s' - only the owner of this database can access it.");
		add(924   , 14 , "Database '%.*s' is already open and can only have one user at a time.");
		add(925   , 19 , "Maximum number of used databases for each query has been exceeded. The maximum allowed is %d.");
		add(926   , 14 , "Database '%.*s' cannot be opened. An earlier attempt at recovery marked it 'suspect'. Check the ASE errorlog for information as to the cause.");
		add(927   , 14 , "Database <%d> cannot be opened - it is in the middle of a load.");
		add(928   , 14 , "Database '%.*s' cannot be opened - it is currently being created.  Wait and try query again.");
		add(929   , 21 , "Attempting to close a database which is not open. Please contact Technical support.");
		add(930   , 14 , "Database '%.*s' cannot be opened because either an earlier system termination left LOAD DATABASE incomplete or the database is created with 'for load' option. Load the database or contact a user with System Administrator (SA) role.");
		add(931   , 21 , "Database '%.*s' cannot be opened because of a failure to initialize the global timestamp.  This indicates that a problem exists in the log for the current database.  Please contact Technical support for assistance.");
		add(932   , 22 , "Database '%.*s' cannot be opened because the log for the current database is corrupt. Page %u of the log is linked to a page that belongs to a database object with id %d. Please contact Technical support for assistance.");
		add(933   , 22 , "Logical page %u of the log encountered while retrieving highest timestamp in database '%.*s' is not the last page of the log and we are not currently recovering that database.");
		add(934   , 21 , "Fatal error encountered while freeing up DBTABLE structure.");
		add(935   , 10 , "WARNING - the timestamp in database '%.*s' (0x%04x, 0x%08x) %s the maximum allowed. %d.%d%% of the emergency reserve timestamps remain before the database is shut down automatically. Please contact SAP Technical Support.");
		add(936   , 14 , "The model database is unavailable. It is being used to create a new database.");
		add(937   , 14 , "Database '%.*s' is unavailable. It is undergoing LOAD DATABASE.");
		add(938   , 14 , "Database '%.*s' is unavailable.  It is undergoing LOAD TRANSACTION.");
		add(939   , 20 , "Illegal dbtable unlock: %S_DBT.");
		add(940   , 26 , "Dbtable in wrong state for operation: %S_DBT.");
		add(941   , 20 , "Illegal database context operation.");
		add(942   , 20 , "Database '%.*s' cannot be opened because the system descriptor for table ID %d cannot be installed.");
		add(943   , 14 , "Database '%.*s' cannot be opened since an attempt to upgrade it was unsuccessful.");
		add(944   , 20 , "Function %s requires that the user be in the database being worked on.  Process %d passed it a dbtable for database %d, but is using database %d.");
		add(945   , 21 , "Unable to locate page %u for database id %d in the in-memory copy of Sysusages (spid=%d). This is an internal error. Please contact SAP Technical Support.");
		add(946   , 10 , "A %S_MSG has prevented Sysusages changes for database %.*s from being copied into memory.  Please run sp_dbremap to complete database space changes.");
		add(947   , 14 , "Database '%.*s' has been marked as having corrupt security labels. Please contact a user with the System Administrator, System Security Officer, or Oper role or the Database Owner.");
		add(948   , 14 , "Database '%.*s' is unavailable. It is undergoing a security label consistency fix.");
		add(949   , 14 , "Database '%.*s' is unavailable.  It is being bound to a named cache.");
		add(950   , 14 , "Database '%.*s' is currently offline. Please wait and try your command again later.");
		add(951   , 14 , "Database identity for server user id %d changed after permission checking in database '%.*s'.  Please try again.");
		add(952   , 20 , "Database '%.*s' cannot be opened because the system index descriptor for table ID %d cannot be installed.");
		add(953   , 11 , "Page '%u', passed to curunreservedpgs built-in function, is an invalid page number in database ID '%d'. The highest page number in this database is '%u'.");
		add(954   , 10 , "Warning: The database '%.*s' is using an unsafe virtual device '%.*s'. The recovery of this database can not be guaranteed.");
		add(955   , 16 , "This command attempts to modify data in database '%.*s', dbid '%d'. Modifications are not allowed in this database.");
		add(956   , 16 , "The database '%.*s' does not have separate log segment. Log pre-allocation is not feasible for this database.");
		add(957   , 16 , "Server wide log pre-allocation is disabled. Log pre-allocation is not possible at this time.");
		add(959   , 14 , "Database '%.*s' cannot be opened because an earlier system termination left DROP DATABASE incomplete. Drop the database or run 'DBCC CHECKALLOC' to correct allocation information.");
		add(960   , 16 , "Operation '%S_MSG' is not currently supported for database '%.*s'.");
		add(961   , 14 , "Database '%.*s' is temporarily unavailable.");
		add(962   , 14 , "Database with ID '%d' is not available. Please try again later.");
		add(963   , 14 , "Database '%.*s' is unavailable. It is undergoing ONLINE DATABASE.");
		add(964   , 17 , "Insufficient memory to create the database map for the archive database '%.*s'.");
		add(965   , 21 , "Unable to create the database disk map for the archive database '%d'.");
		add(966   , 14 , "The archive database with id '%d' is unavailable as it is yet to be loaded.");
		add(967   , 10 , "The database map has not been loaded correctly for the database '%.*s'. Please run sp_dbremap to complete changes to the database space.");
		add(968   , 16 , "Database '%S_DBINFO' is not upgraded and hence is not available for access. Please retry your query after database has been upgraded.");
		add(969   , 16 , "You can access database '%.*s' only from its owner instance '%.*s'. You cannot access local temporary databases from non-owner instances except to use CREATE DATABASE and DROP DATABASE with local system temporary databases.");
		add(970   , 16 , "You cannot access local temporary databases simultaneously from more than one instance; local temporary database '%.*s' is currently in use on another cluster instance.");
		add(971   , 14 , "Database '%.*s' is currently unavailable. It is undergoing recovery of a critical database operation due to failure of a cluster instance. Wait and retry later.");
		add(972   , 14 , "Database '%.*s' cannot be opened on instance %d ('%.*s'). This instance joined the cluster during an ongoing QUIESCE DATABASE HOLD command. Execute QUIESCE DATABASE RELEASE, then retry using the database from instance %d ('%.*s').");
		add(973   , 14 , "The database '%.*s' is currently unavailable. It is being used to create a new database.");
		add(974   , 16 , "The configuration parameter '%.*s' has an invalid value '%.*s' equal to binary value '%.*x'.");
		add(975   , 17 , "The database '%.*s' is encrypted.");
		add(976   , 16 , "Single Instance Database '%.*s' is skipped for this operation. The database is accessible from the owner instance %d only.");
		add(977   , 16 , "This operation is not allowed on Single Instance Database '%.*s' with no owner node. Please assign an owner node to database '%.*s', then retry from the owner node.");
		add(978   , 16 , "You can access Single Instance database '%.*s' only from its owner instance '%.*s'. You cannot access Single Instance databases from non-owner instances.");
		add(979   , 17 , "Aborting this command for Single Instance database '%.*s'. An alarm function cannot be installed.");
		add(980   , 17 , "%s could not acquire '%.*s' lock needed for this command.");
		add(981   , 20 , "Unable to put process %d to sleep. Aborting '%.*s' command.");
		add(982   , 16 , "Aborting the '%.*s' command as transactions in a prepared state did not finish within the prescribed time limit.");
		add(983   , 10 , "Waiting for multi-database transactions in a prepared state to complete. Retry count = %d.");
		add(984   , 16 , "This operation is not allowed on Single instance database '%.*s' while it is still bound to logical cluster '%.*s'. Please unbind the database and retry.");
		add(985   , 16 , "Invalid command. Database '%.*s' is already a Single instance database.");
		add(986   , 16 , "Invalid command. Database '%.*s' is already a normal cluster database and accessible on all cluster nodes.");
		add(987   , 21 , "IMRS Garbage Collector or Pack Task for Database '%.*s' failed to %S_MSG with code %d.");
		add(988   , 18 , "%s failed with code %d, imrs gc spid %d exits.");
		add(989   , 16 , "Warning: There is a mismatch between the number of unreserved log pages %d and the number stored in the threshold cache %u in database '%.*s'. Execute DBCC DBREPAIR('%.*s', 'fixlogfreespace', 'scanlogchain') in single user mode to correct the counts.");
		add(1000  , 18 , "Abstract Plan (AP) Internal Error : An error occurred while looking for the AP group ID in sysattributes. If the error persists, please contact SAP Technical Support.");
		add(1001  , 18 , "Abstract Plan Internal Error : Attempting to hard-cast the non-object data structure at %1! as an APOM object. Please contact SAP Technical Support.");
		add(1002  , 16 , "Abstract Plan (AP) : The query does not contain an UNION operator to match the one in the AP expression. The AP will not be applied. Check the AP syntax and its correspondence to the query.");
		add(1003  , 16 , "Abstract Plan (AP) : The number of operands of the UNION operator in the AP differs from the number of sides of the UNION SQL query. The extra items will be ignored. Check the AP syntax and its correspondence to the query.");
		add(1004  , 16 , "Abstract Plan (AP) : The AP expression does not contain an UNION operator to match the one in the SQL query. The AP will not be applied. Check the AP syntax and its correspondence to the query.");
		add(1005  , 16 , "Abstract Plan (AP) : The number of operands of the PLAN operator in the AP differs from the number of steps needed to compute the query. The extra items will be ignored. Check the AP syntax and its correspondence to the query.");
		add(1006  , 16 , "Abstract Plan (AP) : The SQL query step does not create a work table matching the one described by the corresponding STORE operator in the AP. This part of the AP will not be applied. Check the AP syntax and its correspondence to the query.");
		add(1007  , 16 , "Abstract Plan (AP) : The AP expression describes a bushy join tree, while the Server only supports left deep join trees. The bushy right join operand will not be applied. Check the AP syntax.");
		add(1008  , 16 , "Abstract Plan (AP) : The SQL query step does not contain a subquery to match the subquery %d described in the AP. The subquery will be ignored. Check the AP syntax and its correspondence to the query.");
		add(1009  , 16 , "Abstract Plan (AP) : The SQL query does not contain a base table to match the base table '%.*s' described in the AP. The base table will be ignored. Check the AP syntax and its correspondence to the query.");
		add(1010  , 16 , "Abstract Plan (AP) : The SQL query step does not contain a work table to match the work table '%.*s' described in the AP. The work table will be ignored. Check the AP syntax and its correspondence to the query.");
		add(1011  , 16 , "Abstract Plan (AP) : The AP expression uses the work table '%.*s', but does not define it through a STORE operator. The table will be ignored. Check the AP syntax.");
		add(1012  , 16 , "Abstract Plan (AP) : The AP expression describes the materialization of a join, while the Server only supports single table reformatting. The operand of the STORE operator will be ignored. Check the AP syntax.");
		add(1013  , 16 , "Abstract Plan (AP) : %s; line %d, occurring near '%.*s'. Check the AP syntax.");
		add(1014  , 16 , "Abstract Plan (AP) : The correlation name '%.*s' is used in the AP expression for the table '%.*s' and in the SQL query for the table '%.*s'. The table will be ignored. Check the AP syntax and its correspondence to the query.");
		add(1015  , 16 , "Abstract Plan (AP) : You cannot use a variable of type %s. Use CHAR, VARCHAR or TEXT instead.");
		add(1016  , 16 , "Abstract Plan (AP) : There is no destination group for the new AP. The AP was not created. Specify a destination group within the statement or enable the AP capture mode.");
		add(1017  , 18 , "Abstract Plan (AP) : sysqueryplans manager error. The operation was aborted, no AP was created or deleted.");
		add(1018  , 16 , "Abstract Plan (AP) : There is no AP group with the name '%.*s'. The AP mode settings will not be changed.");
		add(1019  , 16 , "Abstract Plan (AP) : The %s mode is already enabled for group '%.*s'. The AP mode settings will not be changed. To enable the LOAD mode for another group, disable it first.");
		add(1020  , 16 , "Abstract Plan (AP) : The REPLACE sub-mode is already enabled.");
		add(1021  , 16 , "Abstract Plan (AP) : The DUMP mode is not enabled. Adaptive Server cannot enable the REPLACE sub-mode. Enable the DUMP mode first.");
		add(1022  , 16 , "Abstract Plan (AP) : The %s mode is not currently enabled. The AP mode settings will not be changed.");
		add(1023  , 0  , "Abstract Plan (AP) : The LOAD mode is not enabled. Adaptive Server cannot enable the EXISTS CHECK sub-mode. Enable the LOAD mode first.");
		add(1024  , 20 , "Abstract Plan (AP) : Fatal error in the lexer while scanning the Abstract Plan. Please contact SAP Technical Support.");
		add(1025  , 16 , "Abstract Plan (AP) Warning : An error occured while applying the AP:");
		add(1026  , 16 , "to the SQL query:");
		add(1027  , 16 , "The following template can be used as a basis for a valid AP:");
		add(1028  , 16 , "Failed to apply the top operator '%s' of the following AP fragment:");
		add(1029  , 16 , "%.*s");
		add(1030  , 16 , "Abstract Plan (AP) Internal Error: An error occured while applying an internally generated AP. The AP implements the SQL level forced options, as forced index, FORCEPLAN, etc. If the error persists, please contact SAP Technical Support.");
		add(1031  , 10 , "The optimizer will try to complete the compilation of this query; on success, the query will be executed normally.");
		add(1032  , 16 , "The query contains no %s that matches the '%s' AP operator at this point.");
		add(1033  , 16 , "The %s in the query expects %d children but the '%s' AP operator has %d children.");
		add(1034  , 16 , "The children of the '%s' operator don't have the required properties, as ordering, partitioning. The logical relational operation is valid at this point but it can not be implemented by this physical operator.");
		add(1035  , 16 , "The AP property enforcer operators 'sort', 'xchg' or 'enforce' can be used to create the needed physical properties.");
		add(1036  , 16 , "The following AP operators are legal at this point: %s.");
		add(1037  , 16 , "When an ordering is missing, the %s peer physical operators that don't need an ordering can be used.");
		add(1038  , 16 , "Abstract Plan (AP) Warning: all FROM clause forced options (and their internally generated AP, given below) were ignored.");
		add(1039  , 16 , "Abstract Plan (AP) Warning: the FORCEPLAN and any FROM clause forced options (and their internally generated AP, given below) were ignored.");
		add(1040  , 16 , "The following AP, given in the PLAN clause, was used by the optimizer:");
		add(1041  , 16 , "The following AP, loaded from SYSQUERYPLANS, was used by the optimizer:");
		add(1042  , 16 , "The Abstract Plan (AP) of the final query execution plan:");
		add(1043  , 16 , "To experiment with the optimizer behavior, this AP can be modified and then passed to the optimizer using the PLAN clause: SELECT/INSERT/DELETE/UPDATE ... PLAN '( ... )'.");
		add(1101  , 17 , "Unable to allocate new page for database '%.*s'. There are no more pages available on valid allocation pages. Space can be created by dropping objects, extending the database, or dumping the log with no_log.");
		add(1102  , 22 , "Unable to locate allocation page %u for database '%.*s'. This allocation page contains the extent that the target allocation page is in, but the allocation page is not in the translation table in the DBTABLE. Run DBCC CHECKTABLE on sysusages.");
		add(1103  , 21 , "Allocation page %u in database '%.*s' has different segment id than that of the object to which we are allocating. Run DBCC CHECKALLOC.");
		add(1104  , 20 , "Conflict between number of extents marked in log record in the allocation bitmap and the allocation count. Allocation count is %d. Bitmap is 0x%lx 0x%lx 0x%lx 0x%lx.");
		add(1105  , 17 , "Can't allocate space for object '%.*s' in database '%.*s' because '%.*s' segment is full/has no free extents. If you ran out of space in syslogs, dump the transaction log. Otherwise, use ALTER DATABASE to increase the size of the segment.");
		add(1106  , 20 , "First pass through allocation page %u found %d free extents. After logging, only found %d free extents.");
		add(1108  , 21 , "Cannot deallocate extent %u, database %d. Object id %d, index id %d, status %d in extent does not match object id %d, index id %d, status %d in object being deallocated. Run DBCC CHECKALLOC.");
		add(1109  , 21 , "Attempt to read allocation page %u failed either because object ID is not correct (%d) or the page ID is not correct (%u).");
		add(1110  , 20 , "Attempt to resource lock allocation page %u in database '%.*s' by process %d while allocating to non-syslogs object '%.*s'.");
		add(1111  , 20 , "Extent bitmap on allocation page %u in database '%.*s' does not have extents marked that are being removed.");
		add(1112  , 20 , "Extent bitmap on allocation page %u in database '%.*s' already has extents marked that are being added.");
		add(1113  , 20 , "Extent %u already locked while allocating it in database '%.*s'.");
		add(1114  , 20 , "Attempt to resource lock page %u in database '%.*s' by process %d failed because lock is already held by process %d.");
		add(1115  , 20 , "Attempt to transfer a resource lock to process ID 0 on allocation page %u in database '%.*s'.");
		add(1116  , 20 , "Attempt to backout the allocation of LOG page %u, in database '%.*s'.");
		add(1117  , 21 , "Extent chain for object %ld is not correctly linked.");
		add(1120  , 20 , "Adaptive Server failed to access page %u in database '%.*s' because it is not an allocation page.");
		add(1122  , 20 , "Attempt to read allocation page before openning SYSALLOCPGS.");
		add(1123  , 20 , "Failed to get lock on OAM pg.");
		add(1124  , 20 , "Failed to get lock on allocation page %u.");
		add(1125  , 20 , "Attempting to allocate page %u in database %d to extent %u which belongs to another object. Object id and index id in page are %d, %d. Object id and index id in extent are %d, %d.");
		add(1127  , 20 , "Internal Error:  The OAM has no room for new inserts.  Check OAM for object %ld, index %d.");
		add(1128  , 22 , "The OAM entry for allocation page %u is missing from the OAM which starts on page %u.");
		add(1129  , 10 , "The requested update to the OAM for object %d, dbid %ld, index %d, oam page %u, would cause a negative page count. allocation page: %u, oamarray used: %u, oamarray unused: %u, deltaused: %d, deltaunused: %d, spid: %d. Contact your System Admin.");
		add(1130  , 22 , "A dealloc log record has been detected which does not have an OAM page supplied.");
		add(1131  , 22 , "The OAM page %u does not belong to object with index %d, partition %d. It is currently allocated to database %d, object %d, index %d, partition id %d.");
		add(1132  , 22 , "Attempted to log allocation to the log.");
		add(1133  , 22 , "Page %u was expected to be an OAM page for %d and it is not.");
		add(1134  , 20 , "Failed to get lock on OAM page %u. This should never happen.");
		add(1135  , 10 , "Page %u was given as a target page for allocation to object %d index id %d and there is no entry in the OAM for this page. This may indicate corruption of the OAM. Please run checkalloc on database %.*s.");
		add(1136  , 21 , "'Please run the upgrade38 utility before attempting to upgrade your database to MP.'");
		add(1137  , 21 , "'There is insufficient space in database %.*s to run this upgrade.'");
		add(1138  , 21 , "'Failed to complete allocation of SYSGAMS in database %.*s.'");
		add(1139  , 20 , "Impossible deadlock on page mgr lock.");
		add(1140  , 20 , "'Page mgr lock should not already be held.'");
		add(1141  , 20 , "Unexpected value returned to page manager routine: %ld.");
		add(1142  , 22 , "Invalid OAM Page %u. Found pstat=0x%x, object=%d, database=%d, indid=%d.");
		add(1143  , 22 , "Invalid OAM Page %u. Expected object=%d. Found object=%d, database=%d, pstat=0x%x, indid=%d.");
		add(1144  , 21 , "Page number %u is higher than the highest page in database '%.*s': %u.");
		add(1145  , 20 , "ss %d was expected to hold logical lock on page %u.");
		add(1146  , 20 , "Process %d was expected to hold logical lock on object %ld.");
		add(1147  , 20 , "Process %d trying to do a logged operation on a non-logged object %ld.");
		add(1148  , 16 , "Error: %d, Severity: %d, State: %dn");
		add(1149  , 21 , "A Log Run Deallocation routine was passed one or more bad parameters. The bad parameter is either %ld or %ld.");
		add(1150  , 20 , "Failed to get intent lock on object %ld.");
		add(1151  , 11 , "Object %ld passed to OAM builtin function no longer exists in database %d.");
		add(1152  , 11 , "Page %u passed to OAM builtin function is not an OAM page for object %d in database %d.");
		add(1153  , 11 , "OAM page %u passed to rowcnt function is an unallocated page in database %d.");
		add(1154  , 16 , "WARNING!!! Attempt to do a prefetch of size %dK is not allowed. The prefetch request is reset to the maximum prefetch size of %dK.");
		add(1155  , 20 , "Invalid page validation type, %d, requested for page %u, object %S_OBJID, indid %d in database %S_DBID.");
		add(1156  , 20 , "Unable to update the page linkage status for the data only locked table %ld in database %d due to an internal error.");
		add(1157  , 10 , "Insert free space value %d in page header of DOL datapage %u belonging to object id %d in database '%.*s' is incorrect. It has been recomputed and is now %d.");
		add(1158  , 20 , "Invalid attempt to allocate a page for object '%S_OBJID' (ID %d) in database '%S_DBID' (ID %d) while large allocation is active for object '%S_OBJID' (ID %d) in database '%S_DBID' (ID %d).");
		add(1159  , 20 , "Attempt to locate LSA extent partition control block failed for dbid '%d', objid '%d', indid '%d' and partition id '%d'.");
		add(1160  , 20 , "Internal Error: The OAM page %u for object %d does not have attribute space reserved.");
		add(1161  , 20 , "Invalid OAM entry found at slot %d in OAM page %u for table ID %d with index ID %d in database '%.*s' (ID %d). This entry is either out of order or its allocation page number is wrong.");
		add(1162  , 21 , "The cached sysgams information for '%.*s' (dbid = %d) is incorrect on %S_INSTID and cannot be communicated across the cluster.");
		add(1163  , 21 , "The space allocated to the sysgams table in database '%.*s' (dbid = %d) must be at least %d pages. Use 'DBCC GAM(%d,-1,-1, 'fix')' to increase the allocation.");
		add(1164  , 21 , "Updates to sysgams information for database '%.*s' (dbid =%d) could not be propagated across the cluster. Use 'DBCC GAM(%d,-1,-1, 'fix')' to fix this.");
		add(1166  , 16 , "You cannot execute the command '%s' on database '%S_DBID' because it was created with asynchronous initialization and it has not been fully initialized. Retry the command later.");
		add(1167  , 16 , "Updates to SYSDAMS for database '%.*s' (dbid =%d) could not be propagated across the cluster.");
		add(1168  , 16 , "The table %s in database '%.*s' has %u extents allocated, but the maximum number allowed for this table is %u. Please contact Technical Support for assistance.");
		add(1169  , 20 , "Failed to cleanup preallocated log pages for database '%.*s' (dbid = %d) due to internal error.");
		add(1201  , 20 , "lock_logical was called with illegal locktype %d.");
		add(1203  , 20 , "Caller of lock manager is incorrectly trying to release or downgrade a lock which it doesn't hold. spid=%d locktype=%d dbid=%d page number (or objid for table lock)=%u, objid (if not a table lock)=%d, row number=%d.");
		add(1204  , 17 , "ASE has run out of LOCKS. Re-run your command when there are fewer active users, or contact a user with System Administrator (SA) role to reconfigure ASE with more LOCKS.");
		add(1205  , 13 , "Your server command (family id #%d, process id #%d) encountered a deadlock situation. Please re-run your command.");
		add(1221  , 26 , "Lock free chain linkage has been corrupted.");
		add(1222  , 26 , "A non lock is linked on the free chain.");
		add(1223  , 26 , "Lock hash table linkage has been corrupted.");
		add(1224  , 26 , "A structure from outside the lock area has been linked onto a lock hash chain.");
		add(1225  , 26 , "Lock record chain linkage has been corrupted.");
		add(1226  , 26 , "A non lock record is linked onto a semaphore cursor.");
		add(1227  , 26 , "Semaphore cursor chain linkage has been corrupted.");
		add(1228  , 26 , "A non semaphore cursor is linked onto a semaphore.");
		add(1229  , 26 , "The actual number of free locks does not match the free lock count.");
		add(1230  , 26 , "A semaphore cursor has no lock records linked to it.");
		add(1231  , 26 , "An incorrect lock structure is linked on the free chain.");
		add(1232  , 26 , "An incorrect lock structure is linked onto a hash chain.");
		add(1233  , 26 , "An incorrect lock structure is linked a chain of lock structures.");
		add(1234  , 26 , "An incorrect lock structure is linked to a semaphore.");
		add(1235  , 26 , "A semaphore cursor at the head of a semaphore queue is marked as waiting.");
		add(1236  , 26 , "A semaphore cursor not at the head of a semaphore queue is marked as not waiting.");
		add(1237  , 26 , "A semaphore cursor has mutually incompatible lock records linked to it.");
		add(1238  , 26 , "%d locks not accounted for.");
		add(1239  , 26 , "%d extra locks found.");
		add(1241  , 26 , "A semaphore cursor refers to a different semaphore than the one it is linked to.");
		add(1242  , 26 , "A lock record refers to a different semaphore cursor than the one it is linked to.");
		add(1243  , 26 , "Couldn't find object to be released.");
		add(1244  , 20 , "Could not find address lock at address 0x%lx while trying to release it.");
		add(1245  , 26 , "Lock record and process disagree.");
		add(1246  , 26 , "Process attempting to wait on a lock that does not belong to it.");
		add(1247  , 26 , "Process attempting to wait on a lock that has already been waited for.");
		add(1249  , 20 , "Process became runnable before lock it was waiting for was released.");
		add(1250  , 26 , "A non-preallocated semaphore cursor encountered while trying to obtain a semaphore.");
		add(1251  , 26 , "An in-use preallocated semaphore cursor was encountered.");
		add(1252  , 26 , "Lock header linkage has been corrupted.");
		add(1253  , 26 , "The wrong number of lock records was found on a semaphore cursor.");
		add(1254  , 26 , "While following the lock record chain for a process, a lock record belonging to a different process was encountered.");
		add(1255  , 26 , "Unlinking a duplicate lock caused a task to be awakened.");
		add(1256  , 26 , "Encountered a non-preallocated semaphore cursor on a chain that should only have preallocated semaphore cursors.");
		add(1258  , 26 , "A process is not waiting for a lock that it should be waiting for.");
		add(1259  , 26 , "A process is waiting for a lock that has been granted.");
		add(1260  , 26 , "A process is waiting for a lock that it did not request.");
		add(1261  , 20 , "Attempt to promote from page to table locking on objid %d encountered an internal error.");
		add(1262  , 20 , "No matching xdes found. Lock was requested for objid %d, dbid %d, type %d, by process %d.");
		add(1263  , 26 , "A process was found to be waiting for the same object twice.");
		add(1265  , 20 , "An illegal attempt was made to release an invalid lock or a lock that is not owned by the process family (lr=0x%p, lrmagic=%c).");
		add(1266  , 20 , "Upgrade of lock on object id or page number %u left the lock ungranted.");
		add(1267  , 26 , "A lock record at the head of a semaphore queue is not marked as granted.");
		add(1268  , 26 , "A lock record is marked as granted, but isn't at the head of the semaphore queue.");
		add(1269  , 10 , "Temporary buffer overflow occurred while scanning the lock table.  Rows will be missing in syslocks for one or more objects.");
		add(1270  , 26 , "A task attempted to release a semaphore that it had not previously obtained.");
		add(1271  , 26 , "A task attempted to acquire a semaphore with a preallocated semaphore cursor that did not belong to it.");
		add(1272  , 20 , "Invalid parameter(s) passed to lock manager.");
		add(1273  , 16 , "Syntax error at line %d of file %s starting at '%s'.");
		add(1274  , 16 , "Error with input file %s: %s.");
		add(1275  , 16 , "The lock unit test can only be run with a single engine on line.");
		add(1276  , 26 , "Attempt to acquire a lock in dbid %d while in an internal transaction.  This is an internal error.");
		add(1277  , 20 , "In a call to lock_multiple(), the lock requests were out of order.  They should be sorted by object id, dbid.");
		add(1278  , 26 , "This semawait (1st) should only have one lockrec.");
		add(1280  , 26 , "Lock sleeptask (or waittask) chain has been corrupted.");
		add(1281  , 26 , "A structure of the wrong type is linked to the lock sleeptask (or waittask) chain.");
		add(1282  , 26 , "An incorrect lock sleeptask structure is linked to the Lock Sleeptask chain.");
		add(1283  , 10 , "Could not change deadlock checking period because ASE has run out of alarms. Please retry the command later.");
		add(1284  , 26 , "Used Lock Sleeptask Entry not in Chain.");
		add(1285  , 26 , "Un-used Lock Sleeptask Entry in Lock Sleeptask Chain.");
		add(1286  , 26 , "Missing Preallocated Lock Sleeptask Entry.");
		add(1289  , 20 , "Internal Error in lock manager routine: Invalid lock mode %s, requested by task (family id %d, spid %d) conflicts with existing family request mode %s belonging to task (family id %d, spid %d).");
		add(1290  , 20 , "Internal Error in lock manager routine: Attempted lock upgrade from %s to %s in parallel query thread (family id %d, spid %d) is Illegal.");
		add(1291  , 20 , "Internal Error in lock manager routine: Attempted lock anti-inheritance is an illegal operation for a non-parent thread (fid %d, spid %d).");
		add(1292  , 20 , "Internal Error in lock manager routine: Thread (fid %d, spid %d) incorrectly attempted to acquire a non-queueing %s lock when thread (fid %d, spid %d) in its family already holds an insufficient %s lock on objid %d, dbid %d.");
		add(1293  , 20 , "Internal Error in lock manager routine: Process (fid %d, spid %d) incorrectly attempted to transfer locks to itself, from a process (fid %d, spid %d) belonging to a different family.");
		add(1294  , 26 , "Lock_logical was called with an illegal 'op' parameter: %d.");
		add(1295  , 26 , "Unconditional lock request for table or page %u, dbid %d was made while holding a latch.");
		add(1298  , 26 , "Unexpected position for NKL semawait. This indicates a programmer error.");
		add(1299  , 26 , "NKL semawait is at an improper position in the queue.");
		add(1301  , 16 , "The Propagation Context Data entry could not be saved.  There is already an entry with the same key values for the context provided.");
		add(1302  , 16 , "A Propagation Context Data value could not be returned in parameter %d because the datatype of the return parameter does not match the datatype of the stored field.");
		add(1303  , 16 , "The second argument for this Propagation Context Data built-in command specifies the number of keys supplied with the call.  This argument must be of datatype 'integer'.");
		add(1304  , 16 , "This Propagation Context Data built-in function requires at least %d arguments.");
		add(1305  , 16 , "This Propagation Context Data built-in function requires one argument.");
		add(1306  , 16 , "The second argument for this Propagation Context Data built-in command specifies the number of keys supplied with the call.  The value '%d' supplied is more than the keys given.  At most '%d' arguments may be keys for this call.");
		add(1307  , 18 , "Internal Error in Propagation Context routines: An invalid or garbaged command 0x%x was seen by pcxt__cmdinit().");
		add(1308  , 18 , "Internal Error in Propagation Context routines: pcxt__nodenew(PCXT_NODE_ENTRY) copied %d arguments, expected %d arguments.");
		add(1309  , 18 , "Internal Error in Propagation Context routines: An invalid or garbaged node type 0x%x tried to free memory at 0x%x in pcxt__nodefree().  The request was ignored.");
		add(1310  , 18 , "Internal Error in Propagation Context routines: The memory tracking fields in the PCD resource structure are inconsistent: inuse %d, free %d.  Some PCD memory may not be reclaimed until the login session ends.");
		add(1311  , 18 , "Internal Error in Propagation Context routines: An invalid or garbaged node type 0x%x was seen by pcxt__nodedup().");
		add(1312  , 18 , "Internal Error in Propagation Context routines: An invalid or garbaged node type 0x%x was seen by pcxt__nodenew().");
		add(1313  , 18 , "Internal Error in Propagation Context routines: An invalid or garbaged event type 0x%x was seen by pcxt_event().");
		add(1314  , 16 , "The built-in function requested %d data fields as return parameters.  The Propagation Context Data entry that was selected contains only %d data fields.  It is an error to request more data fields than exist in the entry.");
		add(1315  , 16 , "Argument %d of this Propagation Context Data built-in command must be of datatype 'integer'.");
		add(1316  , 10 , "Context Name is (%.*s)");
		add(1317  , 10 , "Attribute Name (%.*s) Value (%.*s)");
		add(1318  , 16 , "Attributes in SYS_SESSION cannot be set.");
		add(1501  , 20 , "Sort failure");
		add(1502  , 20 , "Sort Internal Error: Bad Sort Descriptor!!");
		add(1503  , 20 , "Sort Internal Error: The Root page of right/left sub-index tree is missing.");
		add(1504  , 20 , "Internal Sort Error. Empty Index Page found.");
		add(1505  , 14 , "Create unique index aborted on duplicate key.  Primary key is '%S_KEY'");
		add(1506  , 20 , "'%s' command in database '%.*s' encountered an internal error in logging state. Error code : %d. Transaction ID: (%d, %d). Object ID of target table: (%d).");
		add(1507  , 10 , "Warning: deleted duplicate row.  Primary key is '%S_KEY'");
		add(1508  , 14 , "Create index aborted on duplicate rows.  Primary key is '%S_KEY'");
		add(1509  , 20 , "Row compare failure of RIDs (%ld, %d) and (%ld, %d), keycnt = %ld, compflags = %ld, rowformat = %ld, minlen = %ld.");
		add(1510  , 17 , "Sort failed: Out of space in database '%.*s'");
		add(1511  , 20 , "Sort cannot be reconciled with transaction log");
		add(1513  , 20 , "Reuse of extent failed in sort");
		add(1514  , 21 , "Sort failed because it attempted to allocate page %u and found that the page was busy. Buffer %S_BUF contains a cached and referenced page with ptnid %d indid %d and status 0x%x.");
		add(1515  , 20 , "Bad session descriptor for sort");
		add(1519  , 20 , "Internal Sort Error. A transaction that is involved in Parallel Sort is being redone.");
		add(1520  , 18 , "Sort failed for table '%.*s' in database '%.*s' because internal count of used pages is incorrect. Run DBCC TABLEALLOC to correct the value.");
		add(1521  , 18 , "Sort failed because a table in tempdb used for the processing of the query had a bad data page count.  Tempdb should not have been damaged.");
		add(1522  , 20 , "Sort failure.  Prevented overwriting of allocation page in database '%S_DBID' by aborting sort.");
		add(1523  , 20 , "Sort failure.  Prevented incorrect extent deallocation by aborting sort.");
		add(1525  , 21 , "Sort Failure. Rollforward of sort encountered sort descriptor timestamps out of sequence. Old timestamp in log: %04x %08lx. New timestamp in log: %04x %08lx. Timestamp in sort descriptor: %04x %08lx.");
		add(1526  , 17 , "Sort failure. The configure size for data cache (%.*s) is not sufficient to handle the sort buffers (%d) requested. Please reconfigure the data cache or sort buffers and try the command again.");
		add(1527  , 20 , "Sort failure.  Unknown exception returned from bufclaimcache:  %d.");
		add(1528  , 21 , "Character data comparison failure.  An unrecognized Sort-Map-Element type (%d) was found in the server-wide default sort table at SMEL entry [%d].");
		add(1529  , 21 , "Character data comparison failure.  A list of Sort-Map-Elements from the server-wide default sort table does not end properly.  This list begins at SMEL entry [%d].");
		add(1530  , 16 , "Create index with sorted_data was aborted because of row out of order.  Primary key of first out of order row is '%S_KEY'");
		add(1531  , 16 , "The sorted_data option cannot be used for a nonclustered index if the keys are not unique within the table.  Create index was aborted because of duplicate keys.  Primary key is '%S_KEY'.");
		add(1532  , 20 , "Invalid merge page. %s on page %u.");
		add(1533  , 20 , "Internal Sort error. Extend read returns an invalid page. Requested pageno=%u Read pageno=%u.");
		add(1534  , 20 , "Internal Sort error: Attempt to split presorted clustered data page failed. Attempted to split page, pageno = %u.");
		add(1535  , 20 , "Internal Sort error: Attempt to split presorted clustered data page failed. Split page, pageno = %u.");
		add(1536  , 20 , "Internal Sort error. Presorted clustered data page invalid. Page, pageno = %u, parm1 = %d, parm2 = %d.");
		add(1537  , 17 , "Cannot create clustered index on partition table due to not enough sort buffers. Configure at least %ld sortbuffers to create the clustered index on partition table.");
		add(1538  , 17 , "max utility parallel degree %ld is less than the required 'max utility parallel degree' %ld to create clustered index on partition table. Change the parallel degree to required parallel degree and retry.");
		add(1539  , 17 , "Only %d worker processes are available when %d worker processes are required. Process aborted.");
		add(1540  , 10 , "Warning: Only %d worker processes are available when %d worker processes are required.");
		add(1541  , 10 , "Internal sort error: cannot allocate memory in data sampling.");
		add(1542  , 10 , "Internal sort error: Too small a sample set!");
		add(1543  , 20 , "Cannot create a pipe group for sorting in parallel.");
		add(1544  , 20 , "Parallel Sort: Cannot initiate producers and consumers.");
		add(1545  , 20 , "Parallel sort parent driver cannot send message to child thread.");
		add(1546  , 20 , "Parallel sort parent driver cannot receive message from child threads.");
		add(1547  , 20 , "Parallel sort parent driver error in waiting for child threads");
		add(1548  , 10 , "The sort is performed using Serial sort.");
		add(1549  , 10 , "Partition Element: %ld");
		add(1550  , 10 , "Sort buffer size: %ld");
		add(1551  , 10 , "Parallel degree: %ld");
		add(1552  , 10 , "Number of producer threads: %ld");
		add(1553  , 10 , "Number of consumer threads: %ld");
		add(1554  , 10 , "Number of output devices: %ld");
		add(1555  , 10 , "Number of sampled records: %ld");
		add(1556  , 16 , "No such message! ");
		add(1557  , 10 , "Inconsistent distribution map (%d elements without element information)!");
		add(1558  , 10 , "Empty distribution map");
		add(1559  , 10 , "The distribution map contains %d element(s) for %d partitions.");
		add(1560  , 10 , "Warning: Number of filled elements differs from the data structure.");
		add(1561  , 20 , "Producer cannot insert rows into pipe buffers.");
		add(1562  , 10 , "The sort for Worktable%d is done in %s  ");
		add(1563  , 10 , "The sort for %.*s is done in %s  ");
		add(1564  , 10 , "Psort option is not enabled in this database. Create Index will be done using Serial Sort");
		add(1565  , 20 , "The database option pllsort option is not enabled in this database. Create Clustered Index on partition table cannot be done using Serial Sort. Set the pllsort database option and rerun.");
		add(1566  , 10 , "Warning: Attempt to create a clustered index on partitioned table '%.*s' with sampled distinct key values less than number of partitions. Some partitions may be empty. To get a more even distribution, re-create index after loading more data.");
		add(1567  , 20 , "Create Index Internal Error %ld detected");
		add(1568  , 16 , "Unable to find sort order. Please check sort order ID or name.");
		add(1569  , 17 , "Unable to get a conversion handler for the built-in sort function.");
		add(1570  , 10 , "The generated sortkey has been truncated.");
		add(1571  , 10 , "Unknown sort order ID %ld. Using binary sort order instead.");
		add(1572  , 16 , "Unknown sort order file name '%.*s' or Unicode cache is full (Please increase 'size of unilib cache' setting).");
		add(1573  , 20 , "Can't open the directory '%s'.");
		add(1574  , 20 , "Begin transaction failed when attempting to update syscharsets sort order information.");
		add(1575  , 20 , "Unable to open syscharsets table to update sort order information.");
		add(1576  , 20 , "Unable to lock syscharsets table to update sort order information.");
		add(1577  , 20 , "Update of sort order informarion in syscharsets failed.");
		add(1578  , 20 , "Unable to insert sort order information into syscharsets.");
		add(1579  , 16 , "Error converting characters into Unicode to generate sort keys. There maybe illegal byte(s) in source string, or failure to allocate memory.");
		add(1580  , 16 , "Unable to generate sortkey.");
		add(1581  , 16 , "Create index was aborted because pages in the data only locked table are not linked.");
		add(1582  , 17 , "Failed to allocate memory for %ld auxiliary keep buffers. Try this operation when there is enough memory in the procedure cache, or increase the procedure cache memory and retry the sort operation.");
		add(1583  , 20 , "Found a rowlen of %ld, from the merge, while building index on %.*s. The maximum row length is %ld. Please contact SAP Technical Support.");
		add(1584  , 20 , "Unable to build the parent page at level %d while building index on %.*s. Please contact SAP Technical Support.");
		add(1585  , 20 , "Validation of datapage %u in table %.*s failed. Please contact SAP Technical Support.");
		add(1586  , 20 , "Internal Sort Error. Attempt to hash a buffer from cache %.*s, cachelet id: %d into cache %.*s, cachelet id: %d. Please contact SAP Technical Support.");
		add(1587  , 20 , "Empty buffer 0x%lx or mismatch in page or row number. SDES page=%u, rownum=%d, RID page=%u, rownum=%d. Please contact SAP Technical Support.");
		add(1588  , 20 , "Attempt to create an index with sorted data option failed. Please contact SAP Technical Support.");
		add(1589  , 20 , "Found bad merge type %d while merging sub-indexes. Please contact SAP Technical Support.");
		add(1590  , 20 , "Internal error. Pipe create operation failed. Please report this to SAP Technical Support staff.");
		add(1591  , 20 , "Internal error. Pipe destroy operation failed. Please report this to SAP Technical Support staff.");
		add(1592  , 20 , "Internal error. Pipe open operation failed. Please report this to SAP Technical Support staff.");
		add(1593  , 20 , "Internal error. Pipe close operation failed. Please report this to SAP Technical Support staff.");
		add(1594  , 20 , "Internal error. Pipe read operation failed. Please report this to SAP Technical Support staff.");
		add(1595  , 20 , "Internal error. Pipe write operation failed. Please report this to SAP Technical Support staff.");
		add(1596  , 20 , "Internal error. Pipe buffer group destroy operation failed. Please report this to SAP Technical Support staff.");
		add(1597  , 17 , "Sort failure: Number of available sort buffers (%d) is less than the number required (%d) for executing this query. Contact your system administrator to reconfigure the number of sort buffers and try the query again.");
		add(1598  , 21 , "Can not use Unilib Thai Dictionary Sort Order because dataserver may have memory corruption.");
		add(1599  , 21 , "Can not use Unilib Thai Dictionary Sort order because the conversion handle needed is NULL. Please check server's error log file.");
		add(1601  , 21 , "There are not enough 'user connections' available to start a new process. Retry when there are fewer active users, or ask your System Administrator to reconfigure ASE with more user connections.");
		add(1602  , 21 , "Unable to initialize network %d");
		add(1603  , 21 , "Process priority %d invalid or no process slots available");
		add(1604  , 21 , "Process not runnable or kpid %d not within range");
		add(1605  , 21 , "Failed to open virtual socket for new connections");
		add(1606  , 21 , "Failed to initialize network receive buffer");
		add(1607  , 21 , "Failed to initialize network send buffer");
		add(1608  , 18 , "A client process exited abnormally, or a network error was encountered. Unless other errors occurred, continue processing normally.");
		add(1609  , 21 , "Kpid %d out of range");
		add(1610  , 21 , "Could not kill process %d");
		add(1611  , 21 , "Could not install quit function");
		add(1612  , 21 , "Could not install attention function");
		add(1613  , 21 , "Could not close network %d connection for server process %d.");
		add(1614  , 21 , "Could not yield process");
		add(1615  , 21 , "Process unable to sleep");
		add(1616  , 21 , "Failed to flush receive stream buffer");
		add(1617  , 21 , "Could not infect process %d");
		add(1618  , 21 , "Could not spawn the checkpoint process, unable to continue.");
		add(1619  , 21 , "Could not open TEMPDB, unable to continue.");
		add(1620  , 21 , "Failure to open master db for the first time");
		add(1621  , 18 , "Type '%x' not allowed before login.");
		add(1622  , 18 , "Type '%x' not implemented.");
		add(1623  , 21 , "Warning: dataserver -p option fails.  Please check for state '%d' to see where it fails.");
		add(1624  , 18 , "Warning: Errors occured while initializing thresholds on tempdb. Trying to continue the startup. Thresholds might not be active on tempdb.");
		add(1625  , 21 , "Warning: dataserver -u option failed. Please check for state '%d' to see where it failed.");
		add(1637  , 16 , "Could not initialize SSL master context.");
		add(1638  , 16 , "Execution of login script '%.*s' failed with last error = %d. See server errorlog for details.");
		add(1639  , 16 , "Login script '%.*s' does not allow you to login to the server. Contact your database administrator.");
		add(1640  , 16 , "Adaptive Server requires encryption of the login password on the network.");
		add(1641  , 16 , "Local system temporary database for the instance '%s' (id %d) does not exist. Use CREATE DATABASE command to create a local system temporary database for each cluster instance.");
		add(1642  , 16 , "The local system temporary database %.*s (dbid %d) exists for the instance '%s' (id %d) but it cannot be used because it is marked for drop.");
		add(1643  , 21 , "Could not open local system temporary database %.*s (dbid %d) of the instance '%s' (id %d).");
		add(1644  , 21 , "Could not open database 'model' as it is not recovered yet. Aborting the boot of cluster instance '%s' (id %d).");
		add(1645  , 10 , "The signature in the server certificate '%s' is invalid. Error %s.");
		add(1646  , 16 , "Warning: command 'addcert' adds cartificate path '%s' that has invalid dates.");
		add(1647  , 16 , "The certificate path '%s' that is entered for the command 'addcert' doesn't exist. Error '%s'.");
		add(1648  , 16 , "The trusted file path '%s' doesn't exist. Error '%s'.");
		add(1649  , 16 , "The Common Name in the SSL Certificate '%s' exceeds the Sybase limit of '%d'. Error '%s'.");
		add(1701  , 16 , "Creating table '%.*s' failed because the minimum row size would be %d bytes. This exceeds the maximum allowable size of a row for this table, %d bytes.");
		add(1702  , 16 , "%s failed because definition of column '%.*s' in table '%.*s' exceeds the limit of %d columns per table.");
		add(1703  , 17 , "Failed to allocate disk space for a work table in database '%.*s'.  You may be able to free up space by using the DUMP TRANsaction command, or you may want to extend the size of the database by using the ALTER DATABASE command.");
		add(1704  , 16 , "Only the SA can create the system table '%.*s'.");
		add(1705  , 16 , "Must create system table '%.*s' in the Master Database.");
		add(1706  , 16 , "System table '%.*s' was not created, because ad-hoc updates to system catalogs are not enabled.");
		add(1707  , 18 , "Could not create system table '%.*s'.");
		add(1708  , 16 , "Warning: Row size (%d bytes) could exceed row size limit, which is %d bytes.");
		add(1709  , 16 , "Referenced table name missing in a referential constraint declaration on table '%.*s'.");
		add(1710  , 16 , "Referenced table '%.*s' specified in a referential constraint declared on '%.*s' does not exist in the database '%.*s'.");
		add(1711  , 16 , "There is no unique constraint on the referenced columns in the referenced table '%.*s' specified in referential constraint declaration on the table '%.*s'.");
		add(1712  , 18 , "Internal inconsistency - constraint exists in sysconstraints table, but not sysobjects table, id = %d.");
		add(1713  , 16 , "Unable to create table '%.*s' as source table '%.*s' is a '%.*s'.");
		add(1714  , 16 , "Exceeded maximum allowed referenced columns, %d, in a single referential constraint declaration, table = '%.*s', database = '%.*s'.");
		add(1715  , 16 , "The number of columns in a foreign key column list and primary key/referenced column list not the same in referential constraint declaration on table '%.*s', in database '%.*s'.");
		add(1716  , 18 , "Invalid system table given for status update, this is an internal error.");
		add(1717  , 16 , "System catalog column/table specified for status change not found.");
		add(1718  , 16 , "The number of columns in a foreign key column list is less than a primary/referential column list in a referential constraint declaration, table = '%.*s', data base = '%.*s'.");
		add(1719  , 16 , "Primary key does not exist for the table referenced in a referential constraint declaration, table = '%.*s', data base =  '%.*s'.");
		add(1720  , 16 , "A column referenced in a referential constraint declaration does not exist, referencing table = '%.*s', data base =  '%.*s'.");
		add(1721  , 16 , "Column types of referencing and referenced columns don't match. referencing column = '%.*s', referenced column = '%.*s'.");
		add(1722  , 16 , "Column lengths of string type referencing and referenced columns don't match. referencing column = '%.*s', referenced column = '%.*s'.");
		add(1723  , 16 , "Column precision and scale of numeric referencing and referenced columns don't match. referencing column = '%.*s', referenced column = '%.*s'.");
		add(1724  , 16 , "The number of columns in a foreign key column list is greater than a primary/referential column list in a referential constraint declaration, table = '%.*s', data base = '%.*s'.");
		add(1725  , 16 , "SELECT INTO failed because column %d in table '%.*s' has a null column name. Null column names are not allowed.");
		add(1726  , 18 , "Internal inconsistency:  database id %d sent to crt_main() does not match Pss->pcurdb value of %d.");
		add(1727  , 20 , "The crt_main() function is trying to put too many lock requests in the lock_requests[] array.");
		add(1729  , 10 , "An object with the same name, but owned by a different user, is already being replicated. The table '%.*s' is not marked as replicated.");
		add(1730  , 10 , "Due to an internal error the table '%.*s' is not marked as replicated. Please contact your System Administrator (SA) for help.");
		add(1732  , 20 , "Failed to reserve/initialize allocation hints space in table '%.*s'.");
		add(1734  , 16 , "You cannot specify both a default value of NULL and a NOT NULL constraint for column '%.*s' in table '%.*s'. Retry your command with only one of these column options.");
		add(1736  , 16 , "Cannot create auditing-related tables in any database other than sybsecurity database.");
		add(1737  , 16 , "Cannot create tables starting with 'sysaudits_'.");
		add(1738  , 16 , "Creating this referential constraint would result in the total number of referential constraints of table %.*s exceeding %d. Please run: 'sp_helpconstraint %.*s' to find out the number of referential constraints that this table has.");
		add(1739  , 10 , "Warning: Parameter 'exp_row_size' is not applicable to table '%.*s' in allpages locking scheme");
		add(1740  , 10 , "Warning: Parameter 'max_rows_per_page' is not applicable to table '%.*s' in 'datapages' or 'datarows' locking scheme");
		add(1741  , 10 , "Warning: Parameters 'exp_row_size' and 'max_rows_per_page' both specified for table '%.*s'. Only parameter appropriate to lock scheme specified will be used internally, but both are stored. See users manual for more information.");
		add(1742  , 16 , "Expected row size specified on table '%.*s' is invalid. Expected row size should be either 0, 1 or between minrow length %d and maxrow length %d");
		add(1743  , 10 , "Multiple lock schemes specified on the table '%.*s'. Lock scheme has to unique.");
		add(1744  , 10 , "Internal error: Dataonly Lock scheme is not supported on this system table '%.*s'. Contact SAP Technical Support for help.");
		add(1750  , 20 , "Failed to reserve attribute space for table '%.*s'.");
		add(1751  , 20 , "Failed to initialize attribute space for table '%.*s'.");
		add(1752  , 16 , "Table '%.*s' has fixed length schema. Parameter 'exp_row_size' is not applicable to tables with fixed length schema.");
		add(1753  , 16 , "DELETE STATISTICS failed on table '%.*s' see error log for more information.");
		add(1754  , 16 , "DELETE STATISTICS duplicate column '%.*s' specified, column can only be referenced once.");
		add(1755  , 16 , "DELETE STATISTICS column name '%.*s' not found.");
		add(1756  , 18 , "syscolumns cannot be read.");
		add(1757  , 10 , "UPDATE STATISTICS - could not obtain required locks on table '%.*s");
		add(1758  , 10 , "UPDATE STATISTICS failed to complete on table '%.*s");
		add(1759  , 16 , "Command '%s' number of step values requested '%d' must be greater than or equal to '%d' values");
		add(1760  , 16 , "UPDATE STATISTICS - index and column list cannot be specified at the same time");
		add(1761  , 13 , "Deadlock detected on '%.*s' while processing statistics");
		add(1762  , 18 , "Cannot insert rows into sysstatistics");
		add(1763  , 18 , "Cannot insert rows into sysstatistics, due to multiple equal frequency values, please contact SAP Technical Support");
		add(1764  , 18 , "Failed to insert row into worktable, when projecting base table on to work table for collecting statistics.");
		add(1765  , 10 , "Unable to start a level zero scan on table '%.*s' for UPDATE STATISTICS. This can happen if some DDL command like ALTER/CREATE INDEX/REORG/DROP is active on the table.");
		add(1766  , 16 , "Cannot create syscoordinations tables in any database other than sybsystemdb.");
		add(1767  , 16 , "Number of variable length columns exceeds limit of %d for allpage locked tables. %s for '%.*s' failed.");
		add(1768  , 10 , "Warning: Potential offset of column '%.*s' (%d bytes) and subsequent variable-length columns in table %.*s exceeds limit of %d bytes for column-offset of variable-length columns in DOL tables. Future inserts to this table may fail.");
		add(1769  , 16 , "Variable-length column '%.*s' starts at column-offset %d bytes and is non-nullable. This will prevent inserting any data into that column as the column offset exceeds the limit of %d bytes for column-offsets in DOL tables. %s '%.*s' failed.");
		add(1770  , 16 , "%s failed. Addition of column '%.*s' to table '%.*s' exceeds maximum row width. Rows must be between %d bytes and %d bytes.");
		add(1771  , 10 , "Warning: Maximum row size exceeds allowable width. It is being rounded down to %d bytes.");
		add(1772  , 10 , "Warning: Update of SYSSTATISTICS row (sequence no %d, format ID %d, column IDs: %s) failed. Statistics row deleted. Regenerate statistics for these columns.");
		add(1774  , 16 , "Incorrect UPDATE STATISTICS sampling percent '%d' requested. Enter a value between '0' and '100'.");
		add(1775  , 16 , "Temporary tables may not have referential integrity constraints.");
		add(1776  , 16 , "Virtual computed column '%.*s' cannot be referenced in any constraints.");
		add(1777  , 16 , "Cannot create index on a virtual computed column (%.*s). Modify it to materialized using the ALTER TABLE MODIFY commmand first and retry.");
		add(1778  , 16 , "Referenced database '%.*s' specified in a referential constraint declared on '%.*s' does not exist.");
		add(1779  , 16 , "You cannot preallocate %d pages for Virtually hashed table '%.*s'.");
		add(1780  , 17 , "Cannot allocate a worktable object id because all valid object id values are already in use.");
		add(1781  , 16 , "Creation of a proxy table across instances within the same cluster is not allowed.");
		add(1787  , 16 , "Only the database owner or a user with System Administrator privilege may create table '%.*s'.");
		add(1788  , 16 , "Cannot create referential integrity constraint on tables set up with minimal logging for data manipulation statements.");
		add(1789  , 16 , "You cannot delete system thread pools.");
		add(1790  , 16 , "Table '%.*s' cannot be compressed; none of the columns are compressible.");
		add(1791  , 16 , "NOT COMPRESSED option is not applicable on columns that can be compressed or in a table that has no table level compression schema or compressed partitions.");
		add(1792  , 16 , "You cannot use '%s' clause for column '%.*s' as it is not a LOB column.");
		add(1794  , 16 , "The previous 'alter thread pool %.*s' command is still in progress, hence the current command is aborted. Please try again !");
		add(1795  , 20 , "The command '%s' failed because the dataserver was unable to allocate space for deferred table '%.*s' in database '%.*s'.");
		add(1796  , 10 , "In-row length %d derived for column '%.*s' is greater than the maximum possible allowed, %d, for %s datatype. In-row LOB length will be set to %d.");
		add(1797  , 16 , "Cannot resolve column name '%.*s' for table '%.*s'. The column grouping syntax is either '(col1[,col2]...])' or '(col1)[,(col2)]...]'.");
		add(1798  , 10 , "Column tuple such as (col_1, col_2, ... ) is not supported by hashed based statistics.");
		add(1801  , 16 , "Database '%.*s' already exists");
		add(1802  , 11 , "CREATE DATABASE failed. Some disk names listed in command were not found. Check that names exist and are spelled correctly before re-running");
		add(1803  , 17 , "CREATE DATABASE failed. Could not allocate enough disk space for a new database on the disks named in the command. Total space allocated must be at least %d Mbytes (%ld logical pages) to accommodate copy of Model Database.");
		add(1804  , 10 , "There is no disk named '%.*s'. Checking other disk names.");
		add(1805  , 10 , "CREATE DATABASE: allocating %u logical pages (%d.%d megabytes) on disk '%.*s' (%u logical pages requested).");
		add(1806  , 21 , "Crdb_dbrow: Getnext SCAN_NOINDEX on sysdatabases.dbid failed to find row for MODELDBID.");
		add(1807  , 17 , "MODEL database in use, cannot create new database. Contact a user with System Administrator (SA) role before re-running CREATE DATABASE.");
		add(1808  , 21 , "Crdb_disk: Getnext SCAN_NOINDEX on sysdevices.status=DEFAULT failed to find default rows");
		add(1809  , 14 , "CREATE DATABASE must be preceded by a 'USE master' command.  Check with your DBO <or a user with System Administrator (SA) role> if you do not have permission to USE master.");
		add(1810  , 16 , "CREATE DATABASE failed because of incorrectly specified or unavailable space. Total number of megabytes specified and available must be at least %d megabytes so Model Database can be copied to the new database.");
		add(1811  , 16 , "'%.*s' is the wrong type of device for CREATE or ALTER database. Please check sysdevices. The CREATE or ALTER is aborted.");
		add(1813  , 16 , "Cannot open new database '%.*s'. CREATE DATABASE is aborted.");
		add(1814  , 0  , "Could not create temporary database (dbid = %d). If out of space, please extend and reboot. Otherwise contact SAP Technical Support.");
		add(1816  , 16 , "CREATE or ALTER DATABASE failed because the device '%.*s' has no space available either for log or for data.");
		add(1817  , 17 , "The allocation of extents for %s in database '%.*s' failed.");
		add(1818  , 17 , "CREATE DATABASE failed because the device '%.*s' is not online.");
		add(1820  , 20 , "This command adds %S_MSG space to disk '%.*s', which previously contained only %S_MSG.  You must specify WITH OVERRIDE to force this allocation.");
		add(1822  , 16 , "Invalid database maxhold provided.");
		add(1823  , 16 , "Invalid label provided.  Dbmaxhold must be dominated by your maxwrite.");
		add(1824  , 16 , "Invalid label provided.  Dbmaxhold must dominate your minwrite.");
		add(1825  , 14 , "Invalid curwrite label for creating sybsecurity database, label must be DATA_HIGH.");
		add(1828  , 16 , "Cannot create sybsecurity with the log segment and the default segment on the same device.");
		add(1829  , 16 , "CREATE DATABASE failed because there is no space left on any of the data disk(s) specified.");
		add(1830  , 16 , "Cannot create a proxy database without a storage location defined: create database <dbname> with default_location = 'pathname' for proxy_update");
		add(1831  , 16 , "Cannot create this database since system proxy databases are enabled on the companion server in failed over mode.");
		add(1832  , 16 , "Disk '%.*s' is failed over. The CREATE or ALTER database command is aborted.");
		add(1833  , 0  , "Cannot create a system proxy database through T-SQL.");
		add(1834  , 16 , "CREATE DATABASE of '%.*s' failed because the name is reserved for failed over system database.");
		add(1835  , 16 , "Arithmetic overflow error for parameter '%s'.");
		add(1836  , 10 , "Warning: creating a proxy database whose estimated space requirements are %u pages, yet only %u pages are available.");
		add(1837  , 16 , "CREATE DATABASE failed to create a dedicated data segment. The specified data segment size is too small to accommodate the data from the model database.");
		add(1838  , 16 , "Cannot create the proxy database of database '%.*s' on the remote server under HA. The local database '%.*s' will be dropped.");
		add(1839  , 16 , "CREATE DATABASE of '%.*s' under HA failed. If the database '%.*s' exists, please use DROP DATABASE command to drop it first, then try CREATE DATABASE later.");
		add(1840  , 16 , "CREATE DATABASE failed. A temporary database cannot be created with the 'for load' option.");
		add(1841  , 10 , "Database '%.*s' does not exist. ASE will create it.");
		add(1842  , 16 , "%s failed. Database id %d is already in use in this server or is reserved for use in a HA configuration.");
		add(1843  , 16 , "%s failed. Database id must be less than %d because a non-system database is being created.");
		add(1844  , 16 , "%s failed. Database id must be greater than %d.");
		add(1845  , 16 , "%s failed. Database id is invalid. It must be less than maximum database id %d.");
		add(1846  , 16 , "CREATE DATABASE did not create local system temporary database '%.*s' because another local system temporary database '%.*s' already exists for cluster instance '%.*s'.");
		add(1847  , 16 , "CREATE or ALTER DATABASE failed. Private device '%.*s' can be used only for local user tempdb of the owning instance '%.*s'.");
		add(1848  , 16 , "%s failed. Device '%.*s' is a disk device. You cannot create or alter in-memory databases on disk-based devices.");
		add(1849  , 16 , "%s failed. You cannot create or alter in-memory databases on default devices.");
		add(1850  , 16 , "Failed to bind in-memory database to the in-memory storage cache '%.*s'.");
		add(1851  , 16 , "%s failed; cannot locate the template database '%.*s'.");
		add(1852  , 16 , "The database '%.*s' could be neither created nor altered because its template database '%.*s' is in use.");
		add(1853  , 16 , "%s failed. Template database '%.*s' is either offline or marked as suspect.");
		add(1854  , 16 , "%s failed because of incorrectly specified or unavailable space. Total number of megabytes specified and available must be at least %d Mb so Template Database can be copied to the new database.");
		add(1855  , 16 , "%s failed because '%.*s', the template database you specified, is either an in-memory row storage-enabled database, or is not a disk-resident, local, user database with FULL durability.");
		add(1856  , 16 , "%s failed. Template database support is only applicable for databases with durability 'NO_RECOVERY'.");
		add(1857  , 16 , "%s failed. You can not create a database using both 'for load' and 'template' options.");
		add(1858  , 16 , "%s failed. You cannot create or alter database '%.*s' on multiple virtual cache devices that have been created from different in-memory storage caches.");
		add(1859  , 16 , "%s failed. Cache '%.*s' associated with virtual cache device '%.*s' is already bound to database with ID %d.");
		add(1860  , 16 , "%s failed because you can specify only one of the options '%s'.");
		add(1861  , 16 , "%s failed; Template database support is not available for temporary databases.");
		add(1862  , 16 , "%s failed. Failed to maintain attributes in database '%.*s' which are inherited from template database '%.*s'.");
		add(1863  , 16 , "%s failed. Alter the database '%.*s' to remove the TEMPLATE attribute before changing its durability to '%s'.");
		add(1864  , 16 , "dbid '%d' is unavailable until ASE finishes cleaning up locks belonging to a recently dropped database. Use a different dbid or try running the command later.");
		add(1865  , 16 , "Extending a database onto '%.*s' is not allowed because the database has mixed data and log segments.");
		add(1866  , 10 , "The request to create or alter the database '%.*s' asynchronously was ignored either because the database type does not support it, or it is being created or altered with the FOR LOAD option.");
		add(1867  , 16 , "Database '%.*s' is already at its maximum possible size. It cannot be made larger.");
		add(1869  , 16 , "%s failed. Device '%.*s' is not a valid imrslog device.");
		add(1870  , 16 , "%s failed. You cannot create or alter the on-disk row storage log on default devices.");
		add(1871  , 16 , "%s failed. Database '%.*s' does not have %s defined.");
		add(1872  , 16 , "Internal error: Unable to insert %s fragments in the database diskmap. Please contact SAP technical support.");
		add(1873  , 16 , "%s failed. The specified cache '%.*s' must be of type %s.");
		add(1874  , 16 , "%s failed. Increase the size of the specified %s cache '%.*s' to at least %u MB for database binding to succeed.");
		add(1875  , 16 , "Creating %S_MSG database '%.*s' requires more large disk i/o buffers. The total number of buffers is controlled by the configuration parameter 'number of large i/o buffers'.");
		add(1876  , 18 , "The attempt to load database '%.*s' failed. It could not create the template database, required due to a previously unsuccessful database load. Before performing another load, drop and re-create the database.");
		add(1877  , 10 , "Warning: The imrslog fragments in database '%.*s' will be initialized synchronously because asynchronous initialization is not currently supported for imrslog.");
		add(1878  , 16 , "%s failed because the maximum number of devices per database (%d) has been exceeded.");
		add(1901  , 16 , "Column '%.*s' -- Can't create index on a column of BIT data type.");
		add(1902  , 16 , "Cannot create more than one clustered index on table '%.*s'.  Drop the existing clustered index '%.*s' before creating another");
		add(1903  , 16 , "%d is the maximum allowable size of an index.  Composite index specified is %d bytes.");
		add(1904  , 16 , "Cannot specify more than %d column names for index key list. %d specified.");
		add(1905  , 21 , "Could not find 'zero' row for index '%.*s' the table in sysindexes.");
		add(1906  , 11 , "Cannot create an index on table '%.*s', because this table does not exist in database '%S_DBID'.");
		add(1907  , 10 , "Create index on non-empty table not supported yet");
		add(1908  , 16 , "Too many parameters -- symbol table overflow.");
		add(1909  , 16 , "Can't use duplicate column names in index key list. Column name '%.*s' listed more than once.");
		add(1910  , 16 , "Cannot create more than %d indexes on one table.");
		add(1913  , 16 , "There is already an index on table '%.*s' named '%.*s'");
		add(1914  , 16 , "Cannot create index on object '%.*s' because it is not a user table.");
		add(1915  , 14 , "Only the owner of table '%.*s' or a user with System Administrator (SA) role can create an index on it.");
		add(1916  , 16 , "CREATE INDEX options %s and %s are mutually exclusive.");
		add(1918  , 10 , "Non-clustered index (index id = %d) is being rebuilt.");
		add(1919  , 16 , "Column '%.*s' -- Can't create index on a column of TEXT, IMAGE or UNITEXT data type.");
		add(1920  , 16 , "Column '%.*s' is part of a primary key constraint and cannot be null.");
		add(1921  , 16 , "An index with the same columns in the same order already exists on the table '%.*s'.");
		add(1922  , 16 , "An unknown index creation error occurred: %d.");
		add(1923  , 16 , "A table cannot have more than one primary key, attempt to define a second primary key failed on table '%.*s'.");
		add(1924  , 16 , "You cannot create an index on the sysaudits table.");
		add(1927  , 16 , "Create Index failed because user curwrite level is not equal to the level of table '%.*s'.");
		add(1928  , 16 , "Cannot create clustered index '%.*s' on '%.*s' which has %d partitions because the maximum number of partitions allowed on a table with clustered index is %d.");
		add(1929  , 20 , "Failed to reserve/initialize allocation hints space in index '%.*s' on table '%.*s' partition ID %ld.");
		add(1930  , 16 , "Cannot specify more than %d column names for index key list. %d specified. Check sp_dboption for nonunique index option, it has added an extra key for indentity coulumn.");
		add(1931  , 16 , "You cannot re-create the same non-clustered index (ID %d) for object ID %ld in database '%.*s' because you dropped it twice in a single transaction. Transaction rolled back.");
		add(1932  , 16 , "You cannot re-create the same clustered index for object ID %ld in database '%.*s' more than once in a single transaction. Transaction rolled back.");
		add(1933  , 12 , "The object `%.*s' is not a partitioned table. UPDATE PARTITION STATISTICS can only be run on partitioned tables.");
		add(1934  , 16 , "Invalid partition number %d. Valid partition number is a positive integer.");
		add(1936  , 10 , "Warning: Clustered index '%.*s' has been created on the empty partitioned table '%.*s'. All insertions will be unevenly distributed. To balance the data distribution in all the partitions, re-create the clustered index after loading the data.");
		add(1937  , 10 , "Warning: Clustered index '%.*s' has been created on the partitioned table '%.*s' with %d partitions using the segment %d with %d devices. For complete I/O parallelism, each partition should be on a separate device.");
		add(1938  , 16 , "Cannot create index or unique constraint because cursor '%.*s' is still open. Close the cursor(s) before creating index or constraint.");
		add(1939  , 16 , "Cannot create a clustered index with sorted_data option on the 11.0 partitioned table '%.*s'. This option isn't allowed. To create the index do not use this option.");
		add(1940  , 16 , "Cannot create clustered index on table '%.*s' because there are one or more isolation level 0 scans, or REORG command, active on the table.");
		add(1941  , 10 , "Warning: Clustered index '%.*s' has been created with ignore_dup_row on table '%.*s', which uses data-only locking. ignore_dup_row cannot be enforced for subsequent insertions and updates.");
		add(1942  , 16 , "You cannot drop and re-create the same clustered index with sorted data for object ID %ld in database '%.*s' in a single transaction. Transaction rolled back.");
		add(1944  , 16 , "The clustered index cannot be created on a partitioned table using serial sort. The CONSUMER value specified in the CREATE INDEX command must be greater than 1.");
		add(1945  , 16 , "Cannot create unique index '%.*s' on table '%.*s' as a local index. The table partition condition and the specified index keys make it impossible to enforce index uniqueness across partitions with a local index.");
		add(1946  , 16 , "The table partition condition make it impossible to check for duplicate rows across partitions. As a result, ignore_dup_row or allow_dup_row option for index '%.*s' on table '%.*s' can be enforced on rows in each partition, but not across partitions.");
		add(1947  , 16 , "CREATE NONCLUSTERED INDEX failed because object ID %ld in database '%.*s' has more than %d indexes. When 'ddl in tran' is on, metadata for dropped indexes is cleaned up after the transaction has committed.");
		add(1948  , 16 , "Clustered function-based index is not supported.");
		add(1949  , 16 , "Cannot create local index with more partitions (%d) than the number of table partitions (%d).");
		add(1950  , 16 , "Partitioned global index currently not supported.");
		add(1951  , 16 , "Cannot create a function-based index with %.*s option. This option is not allowed.");
		add(1952  , 16 , "Cannot create index on encrypted column '%.*s', due to an initialization vector, or random padding.");
		add(1953  , 16 , "Cannot create global clustered/placement index on Round Robin table with more than 255 partitions. Please create local clustered/placement index instead.");
		add(1954  , 16 , "Cannot create index on '%.*s' which has suspect partitions. This table is only available for read-only purposes until the REORG REBUILD or Repartition (ALTER TABLE PARTITION BY) command has been run on the indicated table to repair the partitions.");
		add(1955  , 0  , "Internal coding error. An error occurred when attempting to create an index for replication. Please contact SAP Technical Support.");
		add(1956  , 10 , "Creating unique local index '%.*s' on partitioned table '%.*s' does not guarantee the uniqueness of an index key value across partitions.");
		add(1957  , 16 , "A create index DDL cluster notification error has happened - Create Index DDL operation on table '%.*s' is rolled back.");
		add(1958  , 20 , "%s %s on '%.*s' did not apply the log record %S_RID in database '%.*s' due to one or more preceding errors. Transaction has been rolled back.");
		add(1959  , 0  , "%s %s on '%.*s' cannot extract the log record %S_RID associated with CLR %S_RID in database '%.*s'. Transaction has been rolled back. Please contact SAP Technical Support for assistance.");
		add(1960  , 20 , "Cannot get the consolidated state of the descriptor associated with table '%.*s' in database '%.*s'. The command has been aborted.");
		add(1961  , 16 , "Local or partial index '%.*s' not created, because data partition '%.*s' in table '%.*s' does not exist in database '%.*s'. Verify the data partition name.");
		add(1962  , 20 , "%s %s on '%.*s' cannot apply the CLR %S_RID in database '%.*s' as the correct row version cannnot be determined. Transaction has been rolled back. Please retry the command.");
		add(1963  , 16 , "You cannot create an Online index with '%.*s' option.");
		add(1964  , 16 , "You cannot create an Online index when '%.*s' option is ON.");
		add(1965  , 10 , "Create index with hash-based stats is not supported on proxy table.");
		add(1966  , 10 , "Create index with hash-based stats on LOCAL index is not supported in parallel mode.");
		add(1967  , 10 , "Create index hash-based stats on column '%.*s' (column id = %d) are partially completed or missing.");
		add(1968  , 10 , "Warning: '%s' will be performed in offline mode because object '%.*s' does not have any physical storage.");
		add(1969  , 10 , "Create clustered index with hash-based stats on round-robin table partition is not supported in parallel mode.");
		add(1970  , 10 , "Create Index %.*s.");
		add(1971  , 10 , "Compressed index can not be created on encrypted columns, the index will be created as normal index.");
		add(1972  , 10 , "Index '%.*s' can not be create as compressed, it will be created as normal index.");
		add(1973  , 16 , "Create index with option '%s' is not supported on %s table.");
		add(1974  , 16 , "Create index with '%s' is not supported in %s database.");
		add(1975  , 16 , "Index partition of index '%.*s' for data partition '%.*s' of table '%.*s' has existed.");
		add(1976  , 16 , "Create partial index only supports to create index partition for one data partition.");
		add(1977  , 16 , "Create partial index fails because current CREATE INDEX has different index keys or options with others. Details: %s.");
		add(1978  , 16 , "Command '%s' can't be performed for %s '%.*s' if any partial index exists for it. Please retry after dropping the partial index or creating index partitions on all data partitions for partial index. sp_helpindex can report partial indexes for it.");
		add(1979  , 16 , "Create index '%.*s' on table '%.*s' failed, because CREATE CLUSTERED INDEX WITH DEFER_RECOVERY is not supported. Either retry without the WITH DEFER_RECOVERY clause or create a non-clustered index instead.");
		add(1980  , 10 , "Warning: Index '%.*s' on table '%.*s' with deferred recovery option has not been recreated or dropped at ONLINE DATABASE time.");
		add(1981  , 10 , "Warning: Deferred recovery indices created with either the AUTO or the NONE option in database '%.*s' could not be recreated or dropped during ONLINE DATABASE time.");
		add(1982  , 10 , "index id = %d could not be restored for object '%.*s' in dbid %d.");
		add(1983  , 10 , "Warning: Deferred recovery indices in database '%.*s' could not be recreated or dropped or listed during ONLINE DATABASE time, because the database is not writable.");
		add(1984  , 10 , "Index '%.*s' can not be created as latch free, it will be created without latch free functionality.");
		add(1985  , 10 , "Latch free index can not be created on encrypted columns, it will be created without latch free functionality.");
		add(1986  , 10 , "Index '%.*s' on table '%.*s' has been created with the database default of WITH DEFER_RECOVERY = %s.");
		add(1987  , 10 , "%s index '%.*s' on table '%.*s' has not been created with the database default of WITH DEFER_RECOVERY = %s.");
		add(1988  , 16 , "You cannot create an index with '%s' option on table '%.*s' enabled with '%s' when there are rows cached for it. Please retry without this option.");
		add(1989  , 10 , "Warning: %s clause is not specified, value %u will be used as the bucket count of hash table.");
		add(1990  , 16 , "The %s clause must be specified when a value is specified for the %s clause.");
		add(1992  , 16 , "The clustered/placement index '%s' cannot be created on a round-robin partitioned table '%.*s' using serial sort. The database option 'enforce dump tran sequence' prevents creating the index using parallel sort.");
		add(2001  , 10 , "Cannot use duplicate parameter names. Parameter name '%.*s' listed more than once.");
		add(2002  , 10 , "Cannot use variable  '%.*s' without first declaring it.");
		add(2004  , 16 , "Procedure '%.*s' has already been created with group number %d - create procedure with an unused group number");
		add(2005  , 18 , "Maximum procedure %s count exceeded.  Limit is %d.  Modify the procedure to use fewer %ss.");
		add(2007  , 11 , "Cannot add rows to sysdepends for the current stored procedure because it depends on the missing object '%.*s'. The stored procedure will still be created.");
		add(2008  , 16 , "The object '%.*s' is not a procedure so you cannot create another procedure under that group name.");
		add(2009  , 16 , "Group number not allowed in ESP creation.");
		add(2010  , 16 , "A procedure by that name already exists.");
		add(2011  , 16 , "System stored procedures (that is, stored procedures beginning with 'xp_' or 'sp_' and which are owned by the dbo) can only be created in either 'master' or 'sybsystemprocs'.");
		add(2012  , 16 , "The maximum number of available id's (%d) for LWP's is reached. Deallocate dynamic SQL statements to free ids.");
		add(2013  , 16 , "TIMESTAMP is an invalid parameter type in scalar SQL functions.");
		add(2014  , 16 , "Cannot replace view definition for '%.*s' due to column level permissions granted on the view.");
		add(2015  , 16 , "The object '%.*s' is not a %S_MSG. Cannot replace an object of a different type.");
		add(2016  , 16 , "Cannot replace individual procedures within the group");
		add(2017  , 16 , "Cannot replace an access rule with a domain rule or a domain rule with an access rule.");
		add(2103  , 16 , "Cannot create a trigger on a view, name: %.*s");
		add(2106  , 11 , "Cannot create a trigger on table '%.*s', because this  table does not exist in database '%S_DBID'.");
		add(2108  , 16 , "Cannot CREATE TRIGGER on table '%.*s',because you can only create a trigger on a table in the current database.");
		add(2109  , 16 , "Cannot CREATE TRIGGER on table '%.*s', that accesses 'inserted' or 'deleted' because the table was created with the no_log option");
		add(2110  , 20 , "The proccreate() function is trying to put too many lock requests in the lock_requests[] array.");
		add(2111  , 16 , "Create trigger aborted. User's cuwrite is not equal to the hurdle of table '%.*s'.");
		add(2112  , 16 , "CREATE TRIGGER failed on table '%.*s' because it is a system table. Triggers are not allowed on system tables.");
		add(2113  , 16 , "Can not create an instead of trigger on a table, name: %.*s");
		add(2114  , 16 , "Can't create an INSTEAD OF trigger on view %.*s since the view is defined with CHECK OPTION.");
		add(2115  , 16 , "Warning: Although minimal logging is enabled for this table, %s operation on table '%.*s' will be fully logged if this trigger '%.*s' is enabled.");
		add(2116  , 16 , "CREATE TRIGGER failed because selecting from a TEXT, IMAGE, UNITEXT or off-row Java datatype column of the inserted or deleted table is not supported.");
		add(2117  , 16 , "Cannot create trigger on %S_MSG.");
		add(2119  , 16 , "Cannot replace trigger '%.*s' on table '%.*s' because the trigger has been created on a different table.");
		add(2120  , 16 , "There is already a trigger with order number %d defined on table '%.*s'. Choose a different order number for trigger '%.*s'.");
		add(2121  , 16 , "Trigger creation fails. You have already created the maximum number of triggers for the %S_MSG action on the %.*s table.");
		add(2200  , 10 , "System databases that did not fail over cannot be shut down.");
		add(2201  , 11 , "Unable to find database %.*s in sysdatabases. Cannot shut down the database.");
		add(2202  , 16 , "You cannot start database shutdown from the database to be shut down.");
		add(2203  , 18 , "Warning: HA Subsystem Internal Error - unable to spawn thread  executing database shutdown in synchronous mode.");
		add(2204  , 16 , "Database %.*s  dbid %d  was found to be in use after it was marked for shutdown.");
		add(2205  , 18 , "Warning: HA Subsystem Internal Error - child thread suicide failed.");
		add(2206  , 10 , "Database %.*s with dbid %d is already shut down.");
		add(2207  , 10 , "DBS_DEBUG_MSG: after cleaning the buffers");
		add(2208  , 10 , "DBS_DEBUG_MSG: asking all tasks to reach 1st barrier");
		add(2209  , 10 , "DBS_DEBUG_MSG: **** stopped %d");
		add(2210  , 10 , "DBS_DEBUG_MSG: waiting for tasks to reach 1st barrier");
		add(2211  , 10 , "DBS_DEBUG_MSG: terminating %d");
		add(2212  , 10 , "DBS_DEBUG_MSG: Wait on dbt keep count and freeing of resources done in asynchronous mode by the dbshutdown process: %d");
		add(2213  , 10 , "DBS_DEBUG_MSG: Wait on dbt keep count and freeing of resources done in synchronous mode by the dbshutdown process: %d");
		add(2214  , 10 , "DBS_DEBUG_MSG: now waiting for dbtable keeps to drain out");
		add(2215  , 10 , "DBS_DEBUG_MSG: final checks");
		add(2217  , 10 , "DBS_DEBUG_MSG: dbshutdown completed for database %.*s with dbid %d");
		add(2218  , 10 , "DBS_DEBUG_MSG: child process %d is executing failover dbshutdown asynchronously");
		add(2219  , 20 , "Warning: HA Subsystem Internal Error - database shutdown was not attempted because the name change of the proxy databases failed.");
		add(2220  , 20 , "Unable to spawn QUIESCE/PREPARE DATABASE Agent. Aborting %.*s command.");
		add(2221  , 16 , "%.*s Error: Tag name %.*s is already in use. Use a different name.");
		add(2222  , 16 , "%.*s with RELEASE option failed. No agent process with tag name %.*s exists or it is being released by another process.");
		add(2223  , 20 , "Unable to put process %ld to sleep. Aborting %.*s command.");
		add(2224  , 16 , "Invalid option for %.*s.");
		add(2225  , 16 , "Only %d databases are allowed in a single %.*s command.");
		add(2226  , 16 , "Only %d simultaneous executions of both QUIESCE DATABASE and PREPARE DATABASE commands allowed. Try your command later.");
		add(2227  , 10 , "Process %ld successfully executed %.*s with HOLD option for tag %.*s.");
		add(2228  , 10 , "%.*s command with tag %.*s is being executed by process %ld.");
		add(2229  , 10 , "Process %d successfully executed %.*s with RELEASE option for tag %.*s.");
		add(2230  , 17 , "QUIESCE/PREPARE DATABASE: Failed to allocate %d bytes of memory.");
		add(2231  , 16 , "Permission denied. You do not have privilege to execute the %.*s command.");
		add(2232  , 16 , "%.*s Error: Database %.*s does not exist.");
		add(2233  , 16 , "%.*s Error: Database %.*s is already quiesced or it is currently being quiesced by another process.");
		add(2234  , 18 , "%.*s is unable to start a transaction.");
		add(2235  , 16 , "Database %.*s is already specified earlier in this %.*s command.");
		add(2236  , 16 , "Process %ld is aborted by %.*s, as transactions in a prepare state did not finish within the prescribed time limit.");
		add(2237  , 10 , "%.*s: Waiting for multi-database prepared transactions to complete. Retry count: %d.");
		add(2238  , 18 , "%.*s: Could not acquire %.*s due to %.*s.");
		add(2239  , 16 , "%.*s Error: The user has aborted this transaction.");
		add(2240  , 10 , "Warning: master database is in a quiesced state, sp_helpdb on database %.*s may not reflect its status change. Please use dbcc dbtable command (status3 field) to inspect the correct status.");
		add(2242  , 10 , "QUIESCE/PREPARE DATABASE is in progress on database %.*s. After it completes, this dump will resume automatically.");
		add(2243  , 16 , "%.*s failed with error %d. See the error log for more detail.");
		add(2244  , 16 , "%.*s Error: Unable to open database %.*s.");
		add(2245  , 16 , "%.*s Error: Unable to issue a checkpoint on database %.*s because it is in a quiesced state.");
		add(2248  , 16 , "Prepared transactions were found in the system. Reissue the command after the prepared transactions are completed or consult a System Administrator.");
		add(2249  , 16 , "Waiting for prepared transactions to complete...");
		add(2250  , 17 , "Warning: dbshutdown failed on database %.*s with dbid %d because the tasks using this database could not be terminated within the timeout period.");
		add(2251  , 17 , "Warning: HA Subsystem Internal Error - dbshutdown failed on database %.*s with dbid %d because the database was found to be in use after it was marked for shutdown.");
		add(2252  , 16 , "Cannot restart database %.*s with dbid %d because it has not been shut down successfully or it is a HA proxy database.");
		add(2253  , 10 , "Deleting a stale row with session ID %d from syssessions.");
		add(2254  , 10 , "Unable to delete a stale row with session ID %d from syssessions.");
		add(2255  , 10 , "Unable to commit the deletion of stale rows from syssessions.");
		add(2256  , 16 , "Unable to shut down database '%.*s' with dbid %d because another database shutdown or restart is executing. Try your command later.");
		add(2257  , 0  , "Internal Error - Validation of database keep counts failed during database shutdown of database '%.*s' with dbid %d. Please contact SAP Technical Support.");
		add(2258  , 0  , "Internal Error - Process %d has kept some database eventhough it is terminating. Please contact SAP Technical Support.");
		add(2259  , 16 , "Warning: %s process %d is using the database '%.*s', dbid %d while a database shutdown is being attempted. If the database shutdown is unsuccessful, retry it later.");
		add(2260  , 16 , "Warning: spid %d is performing a QUIESCE/PREPARE command in the database '%.*s', dbid %d while a database shutdown is being attempted. If the database shutdown is unsuccessful, retry it later after QUIESCE/PREPARE DATABASE RELEASE.");
		add(2261  , 10 , "Dbshutdown in progress for database %.*s with dbid %d. Timeout left %d secs. Please wait.");
		add(2262  , 10 , "%.*s HOLD was invoked with FOR EXTERNAL DUMP. DUMP TRANSACTION in database '%.*s' has been re-enabled. For subsequent transaction dumps, LOAD TRANSACTION will require the externally-produced copy you have just created as a target.");
		add(2263  , 17 , "%s for tag name '%s' failed: an alarm function could not be installed.");
		add(2264  , 16 , "%.*s HOLD for tag name %s has not finished yet.");
		add(2265  , 16 , "The PREPARE DATABASE command must either have a FOR EXTERNAL DUMP or a WITH QUIESCE clause.");
		add(2266  , 10 , "Unable to write statistics for all indexes of object %ld in database %ld. Run UPDATE STATISTICS on all indexes after booting against the external copy created during the quiesced state, and onlining the database for write access.");
		add(2267  , 10 , "Unable to write statistics for index %ld of object %ld in database %ld. Run UPDATE STATISTICS on this index after booting against the external copy created during the quiesced state, and onlining the database for write access.");
		add(2268  , 20 , "%s for tag name '%s' failed to remove alarm with ID = %d.");
		add(2269  , 16 , "%.*s Error: Unable to proceed with database %.*s because it is being unmounted.");
		add(2270  , 10 , "Unused");
		add(2271  , 10 , "Unused");
		add(2272  , 10 , "Unused");
		add(2273  , 10 , "Unused");
		add(2274  , 16 , "Unused");
		add(2275  , 16 , "Unused");
		add(2276  , 16 , "Process %ld is aborted by '%.*s as transactions in the 'master' database did not finish within the prescribed time limit.");
		add(2277  , 10 , "%.*s: Waiting for at least one transaction%s in the 'master' database to complete. Retry count: %d.");
		add(2278  , 16 , "Unable to shut down the database '%.*s' while making use of it.");
		add(2279  , 16 , "Warning: A system database cannot be shut down.");
		add(2281  , 16 , "Instance failover recovery or shutdown in progress. Aborting QUIESCE DATABASE command with tag name %.*s. Reissue command when recovery or shutdown completes.");
		add(2282  , 16 , "QUIESCE DATABASE: Instance failover recovery or shutdown in progress. New QUIESCE DATABASE commands are aborted during this state. Reissue command again when recovery or shutdown is complete.");
		add(2283  , 18 , "QUIESCE DATABASE: Instance %d failed to perform requested task. See the instance's error log for more detail. Aborting command with tag name %.*s. Try the command again.");
		add(2284  , 20 , "QUIESCE DATABASE: Internal error while communicating with other instances.");
		add(2285  , 18 , "QUIESCE DATABASE command with RELEASE option and tag name %.*s failed. Instance that issued the %.*s command with HOLD option is down. Recovery process will release the command for tag name %.*s.");
		add(2286  , 16 , "QUIESCE DATABASE: New instance join is in progress. HOLD command involving master database has been aborted. Reissue the HOLD command involving the master database when instance join is complete.");
		add(2287  , 10 , "Remote %S_INSTID successfully executed QUIESCE DATABASE with RELEASE option for tag name %.*s. See the %S_INSTID error log for more detail.");
		add(2288  , 18 , "QUIESCE/PREPARE Agent for the given tag name %.*s is present on remote %S_INSTID. Remote %S_INSTID failed to execute QUIESCE DATABASE with RELEASE option for tag name %.*s. See the %S_INSTID error log for more detail.");
		add(2289  , 16 , "Another database operation is already in progress in database '%.*s'. Retry QUIESCE DATABASE later.");
		add(2290  , 10 , "The database '%S_DBID' with durability NO_RECOVERY does not require recovery and is available for use by 'dbo' only.");
		add(2291  , 16 , "Instance failover recovery in progress; new database shutdown commands are not allowed. Reissue the shutdown command after recovery is complete.");
		add(2292  , 18 , "Aborting %s. Remote instance failed to perform the task requested by database shutdown on database %.*s (dbid %d). Try the command again.");
		add(2293  , 16 , "Instance failover recovery in progress; aborting database shutdown command on database %.*s. Reissue database shutdown command after recovery completes.");
		add(2294  , 10 , "Warning: A mounted copy of the database '%.*s' with durability level %s may not be consistent or recoverable. To prevent this from happening alter the database durability to FULL before %.*s.");
		add(2295  , 10 , "DBS_DEBUG_MSG: Database '%.*s'. %s.");
		add(2296  , 0  , "Database '%.*s' has been shut down successfully and is now re-starting in read-only mode. Do not use sp_dboption to clear the 'read only' status without first consulting SAP Technical Support.");
		add(2297  , 16 , "Permission denied. You do not have privilege to execute the '%.*s' command.");
		add(2298  , 16 , "The FOR clause is required in the PREPARE DATABASE command.");
		add(2299  , 10 , "Processes trying to issue an I/O operation on the quiesced database(s) will be suspended until the user executes a %.*s command with the RELEASE option.");
		add(2300  , 10 , "HA Config successfully loaded the HA Services Library for NT version '%s'.");
		add(2301  , 16 , "HA Config Error: The ha_add_companion() built-in function was called with null parameter(s). Retry with non-null parameter value(s).");
		add(2302  , 16 , "HA Config Error: The cluster login '%s' in server '%s' is invalid or does not have ha_role.");
		add(2303  , 10 , "HA Config Warning: The cluster login '%s' in server '%s' has sa_role - this is a potential security problem.");
		add(2304  , 16 , "HA Config Error: The resource '%s' is already managing the ASE server '%s' as a clustered server in the MSCS cluster.");
		add(2305  , 16 , "HA Config Error: Failed to create MSCS cluster group '%s' (operating system error %d - does a group of this name exist already?).");
		add(2306  , 10 , "Creating MSCS cluster group '%s'.");
		add(2307  , 10 , "Creating MSCS cluster resource '%s'.");
		add(2308  , 16 , "HA Config Error: Failed to create MSCS cluster resource '%s' (operating system error %d - does a resource of this name exist already?).");
		add(2309  , 16 , "HA Config Error: Failed to obtain the state for cluster resource '%s' (operating system error %d).");
		add(2310  , 16 , "HA Config Error: Failed to open cluster group '%s' containing the cluster resource for the ASE server (operating system error %d).");
		add(2311  , 16 , "HA Config Internal Error: Unable to initialize and allocate memory. Try restarting the server.");
		add(2312  , 16 , "HA Config Error: Unable to write cluster resource properties for ASE server '%s' (operating system error %d).");
		add(2313  , 16 , "HA Config Error: The ha_remove_companion() built-in function was called with null parameter(s). Retry with non-null parameters(s).");
		add(2314  , 10 , "Successfully removed cluster resource '%s'.");
		add(2315  , 16 , "HA Config Error: The ha_failback() built-in function was called with null parameter(s). Retry with non-null parameter(s).");
		add(2316  , 16 , "HA Config Error: An error was encountered when moving group '%s' (operating system error %d).");
		add(2317  , 10 , "Successfully moved group '%s'.");
		add(2318  , 16 , "HA Config Error: The ha_checkalive() built-in function was called with null parameter(s). Retry with non-null parameter(s).");
		add(2319  , 16 , "HA Config Error: Unable to open cluster resource '%s' managing the ASE server (operating system error %d).");
		add(2320  , 16 , "HA Config Error: Preexisting cluster resource '%s' is not of type '%s' (did this resource exist before configuration began?).");
		add(2321  , 16 , "HA Config Error: Could not find the cluster node where the ASE server '%s' is installed (operating system error %d - is the ASE server running under an NT domain administration account?).");
		add(2322  , 16 , "HA Config Error: Unable to open the cluster node name '%s' in order to move the ASE server's group to it (operating system error %d).");
		add(2323  , 16 , "HA Config Error: Failed to move cluster group '%s' to node '%s' (operating system error %d).");
		add(2324  , 16 , "HA Config Error: Unable to set the owning node of cluster group '%s' to '%s' (operating system error %d).");
		add(2325  , 10 , "Checking administration and cluster logins have correct ASE server roles.");
		add(2326  , 10 , "Checking if the ASE server '%s' is already managed by a cluster resource.");
		add(2327  , 10 , "Creating cluster resource and cluster group to manage ASE server.");
		add(2328  , 10 , "Moving new cluster group '%s' to primary cluster node '%s'.");
		add(2329  , 20 , "HAPC Internal Error: Invalid input %d to internal functions.");
		add(2330  , 17 , "HAPC Internal Error: Invalid rpc(%d) request.");
		add(2331  , 17 , "HACFG Internal Error: This dbcc command is not applicable for Table '%.*s' in database '%.*s'.");
		add(2332  , 17 , "HACFG Internal Error: Internal SQL failed. Unable to execute dbcc command.");
		add(2333  , 17 , "HACFG Internal Error: The sub command '%.*s' for ha_admin() dbcc command is either not implemented or invalid in database '%.*s'.");
		add(2334  , 17 , "CP Error: The dbcc command conncheck failed. Received message '%.*s' while expected msg '%.*s'.");
		add(2335  , 10 , "Unable to obtain lock on the server state. Either lock was left behind by previous HA configuration command or, currently it is locked by another HA configuration operation. See System Administration Manual for details.");
		add(2336  , 10 , "HACFG Internal Error: State machine error. Current states of local(%d) and remote(%d) server are incompatible for operation %d.");
		add(2337  , 10 , "HACFG Internal Error: State machine error. Invalid operation (%d) on the current server state (%d).");
		add(2338  , 10 , "HACFG Internal Error: State machine error. Next states of local(%d) and remote(%d) server are incompatible for operation %d.");
		add(2339  , 10 , "HACFG Internal Error: State machine error. Unable to set the state.");
		add(2340  , 10 , "HACFG Internal Error: State machine error. Unable to get the state.");
		add(2341  , 10 , "Pathname check failed. Pathname '%.*s' exists in companion servers.");
		add(2342  , 10 , "HACFG Internal error: Pathname check failed. Invalid device type(%d) specified.");
		add(2343  , 16 , "HA system is not enabled. Cannot accept any ha services commands. Please refer to System Administration guide to enable HA services.");
		add(2344  , 10 , "HACFG: Handshake failed. Could not receive the Node Id from the Handshake Initiator.");
		add(2345  , 10 , "HACFG Internal error: Could not find Sysattributes row in database (%d) for HA state information.");
		add(2346  , 10 , "HACFG Internal Error: State machine error. Current state (%d) and next state (%d) are incompatible for operation %d.");
		add(2347  , 10 , "HACFG Internal Error: State machine error. Invalid state (%d).");
		add(2348  , 10 , "HACFG Internal Error: State machine error. Current state(%d) and next state(%d) are same.");
		add(2349  , 10 , "HACFG Internal Warning: The store procedure '%.*s' can't be found in the HA Restriction Class table.");
		add(2350  , 10 , "HACFG Internal Warning: The store procedure '%.*s' is not allowed at the restriction class (%d).");
		add(2351  , 10 , "HACFG Internal Warning: The restriction class (%d) is invalid.");
		add(2352  , 10 , "Writing new cluster resource's properties");
		add(2353  , 10 , "Checking ASE server has the correct set of physical disks in its cluster group.");
		add(2354  , 10 , "Found existing resource '%s' for ASE server in group '%s'.");
		add(2355  , 16 , "HA Config Error: Unable to bring cluster resource '%s' online (operating system error %d).");
		add(2356  , 10 , "Bringing cluster resource online.");
		add(2357  , 10 , "Locating the cluster node for the primary ASE server.");
		add(2358  , 10 , "HA Error: You must be in the master database to execute stored procedure '%.*s'.");
		add(2360  , 16 , "HA Config Error: Could not find servername '%s' in interfaces file.");
		add(2361  , 16 , "HA Config Error: Server '%s' currently not running on a cluster.");
		add(2362  , 16 , "HA Config Error: Server '%s' and server '%s' are not running on the same cluster; companionship setup failed.");
		add(2363  , 16 , "HA Config Error: Failed to open temporary file '%s'.");
		add(2364  , 10 , "HA Config Warning: Failed to remove temporary file '%s'. Please remove it manually to prevent possible permission problem later.");
		add(2365  , 16 , "HA Config Error: System command '%s' failed.");
		add(2366  , 16 , "HA Config Error: Resource group '%s' does not seem to be running on any node at all. Please check its status manually before rerunning this command.");
		add(2367  , 16 , "HA Config Error: Resource '%s' is running but not on node '%s'.");
		add(2368  , 16 , "HA Config Error: Could not find useful information from the output of system command '%s'.");
		add(2369  , 10 , "HA Config Warning: Could not set the PendingTimeout and RestartThreshold properties for cluster resource '%s'. These properties may need set manually by the cluster administrator.");
		add(2370  , 10 , "Setting new cluster resource's PendingTimeout to %d and RestartThreshold to %d.");
		add(2371  , 16 , "HA Config Error: Unable to obtain path to the '%s' device. Please check the path and ensure that it is less than '%d' characters.");
		add(2372  , 16 , "HA Config error: Server mismatch. Local server version is '%d', remote server version is '%d'. The server versions must be the same.");
		add(2373  , 16 , "HA configuration error: The logical page size of this Adaptive Server is '%d'. The logical page size of the remote Adaptive Server is '%d'. To configure for HA, the two servers must have the same logical page size.");
		add(2374  , 16 , "HA Config Error: Cannot encrypt the username and password for the file '%s'. Check the error log and make sure the SSL Plus security modules are successfully loaded. Error=%d.");
		add(2375  , 10 , "HA Config Warning: Creating '%s' with clear text username and password. Encrypt the credentials using haisql utility and replace the clear text credentials. Change the login type from 'normal' to 'encrypted'.");
		add(2376  , 10 , "Server %s has been promoted to primary role.");
		add(2377  , 10 , "The primary member is undergoing deactivation.");
		add(2378  , 10 , "Deactivation has been canceled and the primary server is restored to active state.");
		add(2379  , 10 , "The primary server has been successfully deactivated.");
		add(2380  , 10 , "The primary server has been reactivated.");
		add(2381  , 16 , "%s is not enabled on the server. Please refer to System Administration guide to enable '%s'.");
		add(2382  , 16 , "Config Error: Failed to update config parameter '%s' to '%s'.");
		add(2383  , 16 , "Activation failed due to secondary truncation point issues or unable to start RepAgents.");
		add(2384  , 16 , "You cannot run '%s' as the log drain is in progress. Please retry the command later.");
		add(2401  , 11 , "Character set conversion is not available between client character set '%.*s' and server character set '%.*s'.");
		add(2402  , 16 , "Error converting characters into server's character set. Some character(s) could not be converted.");
		add(2403  , 10 , "WARNING!  Some character(s) could not be converted into client's character set.  Unconverted bytes were changed to question marks ('?').");
		add(2404  , 18 , "Buffer overflow converting characters from client into server's character set.");
		add(2405  , 18 , "Internal error occurred while converting characters.");
		add(2406  , 16 , "Cannot use SET CHAR_CONVERT ON, since this session has never had codeset conversions turned on.");
		add(2407  , 17 , "Cannot use the requested character set since the character set cache is full.");
		add(2408  , 11 , "Cannot find the requested character set in Syscharsets:  id = %d.");
		add(2409  , 11 , "Cannot find the requested character set in Syscharsets:  name = '%.*s'.");
		add(2410  , 18 , "Unexpected error returned from the Character Set Manager:  return value = %d.");
		add(2411  , 10 , "No conversions will be done.");
		add(2412  , 10 , "Existing character conversions (if any) will remain in effect.");
		add(2414  , 10 , "Since only 7-bit ASCII characters are allowed with the special character set 'ascii_7', the language for this session is being forced to 'us_english'.");
		add(2415  , 10 , "Due to previous errors, the language for this session is being forced to 'us_english'.");
		add(2416  , 10 , "Due to codeset conversion errors in the remote servername/password list of the LOGINREC, remote procedure calls to other servers may not work.");
		add(2417  , 11 , "Unable to use Unicode-based character set conversion - client character set '%.*s' and server character set '%.*s' are incompatible.");
		add(2418  , 11 , "Unable to load Unicode-based character set conversion table '%.*s' - table not found.");
		add(2419  , 11 , "Unable to load Unicode-based character set conversion table '%.*s' - the conversion table is corrupted. Please notify your system administrator.");
		add(2420  , 17 , "Unable to load Unicode-based character set conversion table '%.*s' - Unicode conversion cache is full. Please notify your system administrator to add more unicode buffers.");
		add(2421  , 11 , "Unable to use Unicode-based character set conversion - The requested character set is not supported: id = %d.");
		add(2422  , 11 , "Unable to use Unicode-based character set conversion - The requested character set is not supported: name = '%.*s'.");
		add(2423  , 18 , "Unexpected error returned from Unilib functions: return value = %d.");
		add(2424  , 16 , "TEXT data not supported when data size is changing between the '%.*s' and '%.*s' character sets due to character set conversion. The conversion ratio is %d:%d. Please connect again with conversions off, or use client-side conversions.");
		add(2425  , 18 , "Unable to use Unicode-based character set conversion - Can not get conversion handle for server's default character set. Please check server's error log file.");
		add(2426  , 10 , "LONGCHAR datatype not allowed on output because client does not support it.");
		add(2427  , 10 , "LONGCHAR datatype not allowed on output because unicode conversions have not been enabled. Please see the System Administrator for asistance.");
		add(2428  , 10 , "Unrecongnized server or client unilib character set ID. Expansion factor is set to 1.");
		add(2429  , 10 , "No matched unilib character set ID for the server or client character set ID. Expansion factor is set to 1.");
		add(2431  , 10 , "WARNING! Some character(s) in the source string are considered illegal bytes in server's character set. All bytes after the first illegal bytes are truncated.");
		add(2432  , 16 , "Illegal byte sequence encountered in Unicode data during %S_MSG conversion of %s value '%s' to a %s field.");
		add(2433  , 16 , "Illegal byte sequence encountered in Unicode data.");
		add(2435  , 18 , "Server Unicode comparison routine optimized for iso1 range chars gets different result from Unilib comparison routine. The first string in its binary format is '%s'. The second string in its binary format is '%s'.");
		add(2436  , 17 , "This is not enough unilib cache memory to initialize the sortkey speedup map. Increase the configuration parameter 'size of unilib cache'.");
		add(2501  , 16 , "Table named %.*s not found; check sysobjects");
		add(2502  , 16 , "Table Corrupt: A page is linked in more than one chain; check this page: page number=%u allocation status=%d");
		add(2503  , 16 , "Table Corrupt: Page linkage is not consistent. Check the following pages: current page number = %u, partition ID = %d; page number of the page pointing to this page = %u; previous page number indicated in this page = %u.");
		add(2504  , 16 , "Table Corrupt: The index id in alloc page does not match the index id in sysindexes (alloc page#=%u; extent id=%u; index id in alloc=%d; index id in sysindexes=%d)");
		add(2505  , 16 , "Table Corrupt: Free offset in page header is incorrect; should be >= %d and <= %d. Check page number %u, partition ID %d, and the offset (free offset on the page header=%d).");
		add(2506  , 16 , "Table Corrupt: The values in adjust table should be in ascending order starting from the end of the table (page#=%u row#=%d); check adjust table in this row");
		add(2507  , 16 , "Table Corrupt: Offset table is incorrect (page number %u, partition ID %d; row number %d; offset in the offset table is %d; the correct offset is %d).");
		add(2508  , 16 , "Table Corrupt: Row length is incorrect (page number %u, partition ID %d; row number %d; minimum row length = %d; row length = %d).");
		add(2509  , 16 , "Table Corrupt: The row number and offset of each row in the page should have a matching entry in the row number table. Check page number %u, partition ID %d (row number %d, offset in row number table is %d).");
		add(2510  , 16 , "Key mismatch between index page %u, partition ID %d; at offset %d; and data page %u (row ID %d), partition ID %d. Drop and re-create index ID %d of table '%.*s' in database '%.*s'.");
		add(2511  , 16 , "Keys of index ID %d for table '%.*s' in %S_MSG are not in the correct order. Drop and re-create the index (index page %u, partition ID %d).");
		add(2512  , 16 , "Table Corrupt: Cannot find the specified row number %d, in index page %u, partition ID %d, on data page %u.");
		add(2513  , 16 , "Table Corrupt: Object id %d (object name = %S_OBJID) does not match between %.*s and %.*s");
		add(2514  , 16 , "Table Corrupt: Type id %d (type name = %.*s) does not match between %.*s and %.*s");
		add(2516  , 16 , "Table Corrupt: Segment number %d does not match between %.*s and %.*s");
		add(2517  , 16 , "Table Corrupt: Procedure id %d (procedure name = %S_OBJID) does not match between %.*s and %.*s");
		add(2518  , 16 , "Database Corrupt: Incorrect last checkpoint in syslogs");
		add(2519  , 16 , "Database Corrupt: The last checkpoint in sysdatabases is incorrect.  Syslogs recorded a different checkpoint");
		add(2520  , 16 , "Database named %.*s not found; check sysdatabases");
		add(2521  , 16 , "Table Corrupt: Page is linked but not allocated. Run DBCC %s to correct the problem. (allocation page#=%u, extent id=%u, logical page#=%u, object id in extent=%d, object name=%S_OBJID, index id in extent=%d)");
		add(2522  , 16 , "Table Corrupt: The object id %d (object name = %.*s) in page %u is different from the object id %d (object name = %.*s) in sysindexes.");
		add(2523  , 16 , "Table Corrupt: Page number %u is out of range for this database %S_DBID. The maximum page number in this database is %u");
		add(2524  , 16 , "Table Corrupt: Row length is inconsistent between the computed row length (%d) and the row length (%d) recorded on the page. Check row number %d and page number %u, partition ID %d.");
		add(2525  , 16 , "Table Corrupt: Object id wrong: alloc page=%u extent id=%u page#=%u objid in ext=%d (name = %S_OBJID) objid in page=%d (name = %S_OBJID) objid in sysindexes=%d (name = %S_OBJID)");
		add(2526  , 16 , "Incorrect DBCC command: Please see the ASE Reference Manual for DBCC commands and options.");
		add(2527  , 10 , "DBCC detected internal database inconsistancy; contact a user with System Administrator (SA) role.");
		add(2528  , 10 , "DBCC execution completed. If DBCC printed error messages, contact a user with System Administrator (SA) role.");
		add(2529  , 16 , "Table Corrupt: Attempted to get page %u, partition ID %d; got page %u, partition ID %d.");
		add(2531  , 16 , "Table Corrupt: Index id on extent should be 0; check the following page and ids: alloc page=%u extent=%u index id on extent=%d");
		add(2532  , 16 , "Table Corrupt: No syslogs entry in sysindexes.");
		add(2533  , 16 , "Table Corrupt: Incorrect index key length %d in internal (sarg) structure.");
		add(2534  , 16 , "Table Corrupt: No keys found on index page %u. Offset for the free space: (freeoff=%d)");
		add(2535  , 16 , "Table Corrupt: Page# %u belongs to object id %d (object name = %.*s) not object id %d (object name = %.*s)");
		add(2536  , 10 , "Checking %.*s: Logical pagesize is %d bytes");
		add(2537  , 10 , "Checking %d");
		add(2538  , 10 , "Alloc page %u (# of extent=%d used pages=%d ref pages=%d)");
		add(2539  , 10 , "Total (# of extent=%u used pages=%u ref pages=%u) in this database");
		add(2540  , 16 , "Table Corrupt: Page is allocated but not linked. Run DBCC %s to correct the problem. (allocation page#=%u, extent id=%u, logical page#=%u, object id in extent=%d, object name=%S_OBJID, index id in extent=%d)");
		add(2541  , 16 , "Table Corrupt: object id does not match between extent in allocation page and sysindexes; check the following extent: alloc pg#=%u extent#=%u object id on extent=%d (object name = %.*s) object id in sysindexes=%d (object name = %.*s)");
		add(2542  , 16 , "Table Corrupt: Extent is linked in more than one chain. Check the following allocation page and extent: alloc pg#=%u extent#=%u status=%d");
		add(2543  , 16 , "Table Corrupt: Extent structures are linked incorrectly; check the following extent: alloc pg#=%u extent#=%u previous extent# on this extent=%u previous extent should be=%u");
		add(2544  , 16 , "Table Corrupt: Extent id %u on allocation pg# %u had object id %d (object name = %.*s) on but used bit off");
		add(2545  , 16 , "Table Corrupt: Extent#=%u on allocation pg#=%u was used but object id was 0,");
		add(2546  , 16 , "Table Corrupt: Extent id %u on allocation pg# %u has objid %d, indid %d, and used bit on, but reference bit off.");
		add(2547  , 16 , "Table Corrupt: Segment number %d specified for use in the segment map in sysusages has no entry in syssegments. The entry in sysusages is for dbid %d (db name = %S_DBID), with a virtual starting address of %d.");
		add(2548  , 16 , "There is no default segment specified in syssegments.");
		add(2549  , 10 , "The object '%s' in database '%.*s' was successfully dropped.");
		add(2550  , 16 , "Missing segment in sysusages segmap.");
		add(2551  , 10 , "The following segments have been defined for database %d (database name %S_DBID).");
		add(2552  , 10 , "virtual device number    virtual start addr     size (logical pages)      segments");
		add(2553  , 10 , "---------------------    --------------------    ----------------------    --------------------");
		add(2554  , 10 , "%s");
		add(2555  , 10 , "                                                    %d");
		add(2556  , 20 , "Page #%u of sysindexes in database %d not found in cache after read.");
		add(2557  , 14 , "Only the owner of object '%.*s' or a user with System Administrator (SA) role can run DBCC %s on it.");
		add(2558  , 16 , "Extent not within segment: Object %d, indid %d, partition %d includes extents on allocation page %u which is not in segment %d.");
		add(2559  , 16 , "Data page number %u, partition ID %d, is empty but is not the first page. Status = 0x%x.");
		add(2560  , 16 , "Incorrect parameter passed to DBCC command.");
		add(2561  , 16 , "Unable to open log for database %d.");
		add(2562  , 16 , "%s cannot access object '%.*s' because it is not a table.");
		add(2563  , 14 , "Only the DBO of database %S_DBID or a user with System Administrator (SA) role can run the DBCC CHECKCATALOG command.");
		add(2564  , 14 , "Only the DBO of database %S_DBID or a user with System Administrator (SA) role can run the DBCC CHECKDB command.");
		add(2565  , 14 , "Only the DBO of database %S_DBID or a user with System Administrator (SA) role can run the DBCC CHECKALLOC command.");
		add(2567  , 14 , "Only the DBO of database %S_DBID or a user with System Administrator (SA) role can run the DBCC DBREPAIR command.");
		add(2568  , 16 , "Page %u is out of range for this database");
		add(2570  , 10 , "Warning - Page %u has DEALLOC bit on - indid %d, status 0x%x");
		add(2571  , 10 , "The object '%s' in database '%.*s' was successfully created.");
		add(2572  , 10 , "Database '%S_DBID' is not in single user mode - may find spurious allocation problems due to transactions in progress.");
		add(2573  , 16 , "Database '%.*s' is not marked suspect. You cannot drop it with DBCC.");
		add(2574  , 16 , "Index page number %u, partition ID %d, is empty. Status = 0x%x.");
		add(2575  , 16 , "The last page of table '%.*s' is recorded in sysindexes as page number %u, partition ID %d. In its header, this page has page number %u as its 'next page'; however, the 'next page' value should be NULL. Check sysindexes.");
		add(2576  , 16 , "The %S_MSG page %u specified in sysindexes for table '%.*s' can not be found. Please check sysindexes.");
		add(2577  , 16 , "The root page of table '%.*s' is recorded in sysindexes as page number %u, partition ID %d. In its header, this page has page numbers %u and %u as its 'next page' and 'previous page' values, respectively; however, both should be NULL. Check sysindexes.");
		add(2578  , 16 , "The first page %u in sysindexes for table '%.*s' has previous page # %u in its page header. The previous page # should be NULL. Please check sysindexes.");
		add(2579  , 10 , "The total number of data pages in this table is %u.");
		add(2580  , 16 , "The clustered index page %S_PAGE, partition ID %d, has an unexpected key pointer to an overflow data page (page %S_PAGE, partition ID %d). Check page status.");
		add(2581  , 16 , "Data page %S_PAGE, partition ID %d, indicates that an overflow page is linked to it; however, the next page (page %S_PAGE, partition ID %d) has not been marked as an overflow page. Check page status.");
		add(2582  , 16 , "Data page %S_PAGE, partition ID %d, has been marked as an overflow page; however, the previous page (page %S_PAGE, partition ID %d) does not indicate that an overflow page is linked to it.");
		add(2583  , 10 , "Number of data pages (%u) counted by DBCC differs from count in the data OAM (%u) for dbid %d object %d.");
		add(2584  , 16 , "The last key in the previous page (page %S_PAGE, partition ID %d) is equal to the first key in the current page (page %S_PAGE, partition ID %d); however, the status of current page does not indicate that it is an overflow page.");
		add(2585  , 16 , "The last key in the previous page (page %S_PAGE, partition ID %d) is equal to the first key in the current page (page %S_PAGE, partition ID %d); however, the status of previous page indicates that there is a disconnected overflow page.");
		add(2586  , 16 , "The last key in the previous page (page %S_PAGE, partition ID %d) is equal to the first key in the current page (page %S_PAGE, partition ID %d); however, the status of the previous page indicates there is no overflow page.");
		add(2587  , 16 , "The first key of the current overflow page (page %S_PAGE, partition ID %d) is not equal to the last key of the previous page (page %S_PAGE, partition ID %d), whose status indicates no disconnected overflow page.");
		add(2589  , 16 , "Object '%.*s' must have its status updated in sysobjects, to reflect the intent of repairing the index on it.");
		add(2590  , 16 , "DBCC option available for system tables only.");
		add(2591  , 16 , "Could not find index row which has id %d for table '%.*s'.");
		add(2592  , 10 , "%s index '%.*s' (ID = %d) successfully restored for object '%.*s' in '%.*s' database.");
		add(2593  , 10 , "There are %.*s rows in %d pages for object '%.*s'.");
		add(2594  , 16 , "Invalid index id specified (index id = %d).");
		add(2595  , 16 , "Database '%.*s' must be set to single-user mode before executing this command.");
		add(2596  , 16 , "Page %S_PAGE, partition ID %d, has an incorrect 'pgfreeoff' value of %d. The offset should be %d.");
		add(2597  , 16 , "The database is not open. Please issue a 'use %.*s' and re-run the DBCC command.");
		add(2598  , 16 , "Indexes on sysobjects and sysindexes cannot be recreated.");
		add(2599  , 16 , "Invalid monitor group specified: '%.*s'. Please re-enter.");
		add(2601  , 14 , "Attempt to insert duplicate key row in object '%.*s' with unique index '%.*s'%S_EED");
		add(2603  , 21 , "Insufficient space (%d bytes) on logical page %u of %S_PTNINFO when inserting row of length %d bytes on index page.");
		add(2610  , 22 , "Could not find leaf row in nonclustered index partition %S_PTNINFO page %u that corresponds to data row from logical data page %u, row offset %d during update index attempt after data page split.");
		add(2613  , 20 , "Attempt to remove resource lock on buffer holding logical page %u failed - the buffer was not resource locked.");
		add(2615  , 14 , "Attempt to insert duplicate row in %S_PTNINFO. Could drop and recreate index with ignore duprow or allow duprow.");
		add(2616  , 20 , "Buffer holding logical page %u cannot move to slot 1 since buffer holding logical page %u is already there.");
		add(2617  , 20 , "Buffer holding logical page %u not found in keep pool in SDES for object '%.*s");
		add(2618  , 20 , "Couldn't find dupkey group starting at offset %d on page %u.");
		add(2619  , 20 , "Keys did not match overflow page when inserting row at end of page (%S_PAGE) that has overflow page (%S_PAGE) that is not disconnected in dbid = %d.");
		add(2620  , 21 , "The offset of the row number at offset %d does not match the entry in the offset table of the following page: %S_PAGE.");
		add(2621  , 20 , "Process %d already has the buffer we are using for an allocation resource locked: %S_PAGE.");
		add(2622  , 21 , "Insufficient room on this page to insert a row of length %d. %S_PAGE.");
		add(2623  , 21 , "The PG_DEALLOC bit is on in this page at runtime - should have been turned off by deallocating page in recovery. %S_PAGE.");
		add(2624  , 21 , "Insert into table %S_DES fails because rowlength %d is less than minlen %d.");
		add(2625  , 20 , "Deadlock encountered in log allocation for database '%.*s'. This state should not be reached.");
		add(2626  , 21 , "Illegal attempt to insert duplicate key row in the clustered index partition %S_PTNINFO.");
		add(2627  , 22 , "Leaf page %u in %S_PTNINFO is empty - please rebuild the index.");
		add(2628  , 0  , "In database '%.*s', page %u is linked forward to page %u, but that page is linked backward to page %u. Please report this internal error to SAP Technical Support.");
		add(2630  , 0  , "In database '%.*s', page %u is linked backward to page %u, but that page is linked forward to page %u. Please report this internal error to SAP Technical Support.");
		add(2631  , 19 , "The maximum number of index levels '%d' has been reached for index %S_PTNINFO. Drop and re-create the index with a smaller key.");
		add(2632  , 10 , "Maximum number of deadlock avoidance split retries for page %u of APL index indid %d on object %d exceeded. Please rerun your command.");
		add(2633  , 20 , "%s failed to insert a row to table '%.*s'. The indicated error was %d.");
		add(2701  , 10 , "Database name '%.*s' ignored, creating table in temporary database '%.*s'.");
		add(2702  , 16 , "Database '%.*s' does not exist.");
		add(2703  , 16 , "Segment '%.*s' does not exist.");
		add(2705  , 16 , "Column names in each table must be unique. Column name '%.*s' in table '%.*s' is specified more than once.");
		add(2706  , 11 , "Table '%.*s' does not exist.");
		add(2710  , 16 , "You are not the owner specified for the object named '%.*s' in this command (CREATE, ALTER, TRUNCATE, UPDATE STATISTICS, or BULK INSERT).  The database owner can use the SETUSER command to assume the identity of another user.");
		add(2711  , 10 , "Precomputed result set cannot be created as some options have an inappropriate setting. Set ansinull on, arithabort on, arithignore off and string_rtruncation on.");
		add(2714  , 16 , "There is already an object named '%.*s' in the database.");
		add(2715  , 16 , "Can't find type '%.*s'.");
		add(2716  , 16 , "Can't specify a length, scale or storage property on type '%.*s'.");
		add(2717  , 16 , "Specified length is too large for type '%.*s'.");
		add(2718  , 16 , "Column or parameter #%d:  -- can't specify Null values on a column of type BIT.");
		add(2719  , 14 , "You must be the owner of table '%.*s' or a System Administrator to update the table's statistics.");
		add(2721  , 11 , "Could not find a default segment to create the table on.  Contact a user with System administrator (SA) role to specify a default segment in syssegments.");
		add(2724  , 10 , "Parameter '%.*s' has an invalid data type.");
		add(2727  , 11 , "Cannot find index '%.*s'.");
		add(2728  , 21 , "Could not find sysobjects row for table '%.*s'.");
		add(2729  , 16 , "Procedure '%.*s' group number 1 already exists in the database.  Choose another procedure name or procedure number.");
		add(2730  , 11 , "Cannot create procedure '%.*s' with a group number of %d because a procedure with the same name and a group number of 1 does not currently exist in the database.  Must CREATE PROCEDURE '%.*s';1 first.");
		add(2731  , 16 , "Column or parameter #%d: -- can't specify column width of zero for '%.*s'.");
		add(2732  , 16 , "User error number %ld is invalid. Number must be between %d and %d.");
		add(2734  , 16 , "User name %.*s does not exist in sysusers.");
		add(2735  , 16 , "Object text is too long. Please shorten the object text or split into multiple objects. Text which caused overflow starts at: '%.*s'.");
		add(2736  , 16 , "Owner name that was specified is a group name.  Objects cannot be owned by groups.");
		add(2737  , 16 , "Message passed to %s must be of type CHAR or VARCHAR.");
		add(2738  , 16 , "A table can only have one timestamp column.  Since table '%.*s' already has one, you can't add the column '%.*s'.");
		add(2739  , 16 , "TEXT, IMAGE and UNITEXT datatypes are invalid for parameters or local variables.");
		add(2740  , 16 , "SET LANGUAGE failed because '%.*s' is not an official language name or a language alias on this ASE.");
		add(2741  , 16 , "SET DATEFORMAT date order '%.*s' is invalid.");
		add(2742  , 16 , "SET DATEFIRST %d is out of range.");
		add(2743  , 16 , "%s command requires %S_MSG parameter.");
		add(2744  , 16 , "Index distribution page was %u, now %u. Perhaps another UPDATE STATISTICS command is currently running. Retry your command.");
		add(2745  , 16 , "%s command is missing an argument position specifier.");
		add(2746  , 16 , "Duplicate position specifier in format string of %s command.");
		add(2747  , 16 , "Incorrect position specifier in format string of %s command.");
		add(2748  , 16 , "Message number %ld, passed to RAISERROR, does not exist in the %s catalog.");
		add(2749  , 16 , "Number of argument position specifiers in %s command is greater than the number of arguments passed.");
		add(2750  , 16 , "Can not have more than %d arguments in a call to %s.");
		add(2751  , 16 , "%s command failed because the resulting string exceeded the maximum length of %d bytes.");
		add(2752  , 20 , "The PRINT/RAISERROR function received an illegal datatype of '%s'.");
		add(2753  , 20 , "Received an error code of '%d' from 'intl_strblist()'.");
		add(2754  , 16 , "There is an argument position specifier that is out of range in a call to %s.  Valid argument position specifiers must be in the range from 1 to %d.");
		add(2756  , 16 , "Specified type precision %d more than the maximum precision %d.");
		add(2757  , 16 , "Specified scale %d more than the specified precision %d.");
		add(2758  , 16 , "Resdom says that column or parameter has no arguments but the length is non-zero. Given length %d.");
		add(2759  , 10 , "Internal error: illegal tree encountered.");
		add(2760  , 10 , "Column name '%.*s' does not exist in target table.");
		add(2761  , 10 , "Failed to create declarative constraints on table '%.*s' in database '%.*s'.");
		add(2762  , 16 , "The '%s' command is not allowed within a multi-statement transaction in the '%.*s' database.");
		add(2763  , 16 , "An attempt to grant CREATE TABLE permission to PUBLIC in tempdb failed.");
		add(2764  , 16 , "Identity field '%.*s' must be a numeric with a scale of 0. It may not be nullable or encrypted.");
		add(2765  , 16 , "A table can only have one identity column. Since table '%.*s' already has one, you can't add the column '%.*s'.");
		add(2766  , 16 , "Cannot use logsegment to create a user table or an index.");
		add(2767  , 16 , "The table with id=<%ld> in dbid=<%d> does not exist. It may have been created in a concurrently running transaction that rolled back and is now inaccessible.");
		add(2768  , 16 , "SET label (CURREAD, CURWRITE) failed because new value is an invalid label, or new value doesn't satisfy the dominance relationships among session labels.");
		add(2769  , 16 , "Invalid maxhold label specified for the table.");
		add(2770  , 16 , "Invalid minhold label specified for the table.");
		add(2771  , 16 , "Invalid hold label specified.  A table's maxhold label should always dominate it's minhold label.");
		add(2772  , 16 , "Invalid hold label specified.  Only labels below your @@maxwrite are acceptable.");
		add(2773  , 16 , "Invalid hold label specified.  Only labels above your @@minwrite are acceptable.");
		add(2774  , 16 , "Hold label provided is above database maxhold.  Please provide a label below the database maxhold.");
		add(2775  , 20 , "Object is not a table, or table has NULL maxhold and/or minhold value.");
		add(2776  , 16 , "The 'set update_mode' command only takes in a CHAR or VARCHAR argument.");
		add(2777  , 16 , "Invalid update_mode provided. The only allowable update modes are: reclassify, over_range, and standard.");
		add(2778  , 12 , "The object '%.*s' is not a table. Update statistics can be used only on user tables or system tables");
		add(2779  , 20 , "Lock request count has overrun the lock request array boundary. This is an internal error.");
		add(2780  , 20 , "maxlen (%d) is less than length (%d)");
		add(2781  , 18 , "Internal Error.  Master to DB SLID conversion failed.");
		add(2782  , 16 , "An untyped variable in the PREPARE statement '%.*s' is being resolved to a TEXT, IMAGE or UNITEXT type. This is illegal in a dynamic PREPARE statement.");
		add(2783  , 14 , "The user's curwrite needs to be at the table's hurdle when updating a table's statistics.");
		add(2784  , 18 , "Internal row labeling error occured.");
		add(2786  , 16 , "%s value of %d is invalid. It must be between %d and %d.");
		add(2787  , 16 , "Cache, %s, cannot be found in sysconfigures.");
		add(2788  , 16 , "Unable to create global temporary table '%s', please use different name.");
		add(2789  , 16 , "Invalid command. The DROP/ALTER on '%s' is not allowed.");
		add(2792  , 16 , "Cannot change curread label with open cursors. Please contact a user with System Security Officer (SSO) role for help.");
		add(2793  , 16 , "User error number %ld is of invalid type. Number must be an integer.");
		add(2794  , 16 , "SET PROCESS_LIMIT_ACTION { ABORT | QUIET | WARNING } failed because '%.*s' is not a valid parameter.");
		add(2795  , 10 , "The value of 'parallel_degree' (`%d') cannot be larger than the value of configuration parameter 'max parallel degree' (`%d'). The value '%d' is used for 'parallel_degree'.");
		add(2796  , 16 , "The values of 'parallel_degree','scan_parallel_degree','repartition_degree' or 'resource_granularity' cannot be less than zero.");
		add(2797  , 10 , "The value of 'parallel_degree' (`%d') cannot be larger than the value of 'parallel_degree' set by a calling procedure. The value '%d' is used.");
		add(2798  , 10 , "The value of 'scan_parallel_degree' (`%d') cannot be larger than the lesser of the configuration parameter 'max scan parallel degree' (`%d') and current 'parallel_degree' (`%d'). The value `%d' is used for 'scan_parallel_degree'.");
		add(2799  , 16 , "'%s' command failed because '%s' is not enabled. A user with System Administrator (SA) role must reconfigure '%s' to 1.");
		add(2801  , 20 , "Bad procedure status: 0x%x.");
		add(2802  , 20 , "Both the tree and plan pointer are set; Ambiguous procedure.");
		add(2803  , 20 , "Bad pointer encountered during remapping: 0x%x.");
		add(2804  , 20 , "Stored procedure '%.*s' is out of sync with its own procedure header.");
		add(2805  , 0  , "Bad pointer 0x%p encountered while remapping stored procedure '%.*s'. Must re-create or replace procedure.");
		add(2806  , 20 , "Stored procedure '%.*s' is corrupted.  Must re-create procedure.");
		add(2807  , 18 , "Process %d could not unlock stored procedure '%.*s' because the procedure is not currently locked by that process.");
		add(2808  , 18 , "Incorrect object structure returned from getobject.");
		add(2809  , 18 , "The request for %S_MSG '%.*s' failed because '%.*s' is a %S_MSG object.");
		add(2810  , 18 , "Cache reports negative usage count for procedure '%.*s'.");
		add(2811  , 0  , "Cannot create or replace procedure dbid %d, objid %d, with a group number of %d.");
		add(2812  , 16 , "Stored procedure '%.*s' not found. Specify owner.objectname or use sp_help to check whether the object exists (sp_help may produce lots of output).");
		add(2813  , 0  , "Procedure %.*s in procedure buffer 0x%p not properly linked with procedure header 0x%p.");
		add(2814  , 0  , "Procedure %.*s in procedure buffer 0x%p does not contain the same object id as procedure header 0x%p.");
		add(2815  , 0  , "Procedure %.*s in procedure buffer 0x%p contains page address 0x%p which is not aligned on a 2K boundary.");
		add(2816  , 0  , "Procedure %.*s in procedure buffer 0x%p contains page address 0x%p which is not within any memory map.");
		add(2817  , 0  , "Procedure %.*s in procedure buffer 0x%p contains page address 0x%p which should be allocated.");
		add(2818  , 20 , "You must provide both name and object id in order to install a procedure.");
		add(2819  , 20 , "You must provide both name and object id in order to remove a procedure.");
		add(2820  , 20 , "You must provide procedure buffer to remove the procedure %.*x.");
		add(2821  , 16 , "You must drop and recreate procedure %.*s.");
		add(2822  , 20 , "Bad version number encountered for procedure %.*s.");
		add(2823  , 0  , "Process %d tried to remove a PROC_BUF 0x%p named '%.*s' that it does not hold in the hold procedure linked list.");
		add(2824  , 0  , "Process %d cannot hold PROC_BUF 0x%p named '%.*s' because it holds another PROC_BUF 0x%p named '%.*s'. A process can only hold one view, rule, or default at a time.");
		add(2825  , 0  , "Process %d tried to remove a PROC_BUF 0x%p named '%.*s' that it does not hold.");
		add(2826  , 0  , "Process %d has held the PROC_BUF 0x%p named '%.*s' in the hold procedure linked list already; Check your procedure cache.");
		add(2827  , 0  , "Procedure '%.*s' in procedure buffer 0x%p is not properly hashed.");
		add(2832  , 17 , "There are no more available procedure buffers. Configure your system for more.");
		add(2833  , 26 , "While cleaning up descriptor for object %d, a procedure buffer was found in use (use count = %d)");
		add(2834  , 26 , "Expected to find procedure buffer with usage count of %d and not %d.");
		add(2835  , 16 , "The procedure tree is old.  Use the sp_remap procedure to remap all the procedures in this database.");
		add(2836  , 26 , "The cursor '%.*s' is already tracking another procedure. This is an internal error.");
		add(2837  , 16 , "The object '%.*s' must be recompiled.  Use 'sp_recompile %.*s', then rerun your command.");
		add(2838  , 16 , "Invalid procedure name");
		add(2841  , 16 , "The text for the object '%.*s' is missing in syscomments. This object can not be accessed.");
		add(2843  , 16 , "The dynamic statement '%.*s' could not be found. This may be due to insufficient metadata descriptors. Increase the serverwide '%s' parameter or the '%s' parameter.");
		add(2844  , 0  , "The procedure header size was expected to be '%d' memory pages instead of '%d' memory pages. This is an internal error. Please contact SAP Technical Support.");
		add(2845  , 20 , "PCM notification for removing procbuf (dbid = %d, objid = %d, objtype = %d) failed.");
		add(2846  , 16 , "SQL function '%.*s' not found. Specify owner.objectname or use sp_help to checkwhether the object exists (sp_help may produce lots of output)");
		add(2847  , 16 , "The object '%.*s' is not a SQLJ function. If this is a SQL function, specify owner.objectname.");
		add(2849  , 16 , "EXECUTE AS OWNER procedures cannot be executed if created by an alias or with the %s command when the procedure has SQL statements that reference objects across databases. Drop and recreate the procedure from a non-impersonated session.");
		add(2850  , 16 , "%s command is not allowed inside an EXECUTE AS OWNER procedure. Drop and recreate the stored procedure without the %s statement.");
		add(2851  , 16 , "Cannot create or replace system extended stored procedure '%.*s' in database '%.*s'. Dynamic linked library '%.*s' may only be referenced in %.*s system extended stored procedures created by the database owner of '%s'.");
		add(2852  , 16 , "Cannot execute system extended stored procedure '%.*s' in database '%.*s'. Dynamic linked library '%.*s' may only be referenced in %.*s system extended stored procedures created by the database owner of '%s'. Please drop the procedure.");
		add(2901  , 19 , "Exception stack limit (%d) exceeded.");
		add(2902  , 10 , "Simulating error %d, state %d, at line %d in file %.*s.");
		add(2903  , 20 , "While processing an exception, another exception occurred, which could result in some internal resources not being released.");
		add(2904  , 16 , "This 'error' has been raised to test exception handling. It was induced by trace flag %d. It is not a real error in ASE.");
		add(2906  , 16 , "You cannot create/modify encryption key '%.*s' for dual_control when it is protected by the system encryption password.");
		add(2907  , 16 , "You cannot modify the dual_control property of a key copy or a service key.");
		add(2910  , 16 , "An internal error occurred when updating the dual control property of key copies for key '%.*s'. This event should be reported to the key custodian.");
		add(2911  , 16 , "You cannot regenerate encryption key '%.*s'. You may drop and recreate it.");
		add(2912  , 18 , "Cannot %s master key startup file '%s' due to system error '%s'.");
		add(2913  , 16 , "The master key startup file path has not been set.");
		add(2915  , 16 , "Cannot add/drop automatic_startup copy for key '%.*s'. Only master keys can have automatic_startup key copies.");
		add(2916  , 16 , "An automatic_startup copy of the %S_MSG already exists.");
		add(2917  , 16 , "Failed to set the master key encrytion key for the %S_MSG in memory. You should report this incident to the Key Custodian.");
		add(2918  , 16 , "You must configure 'automatic master key access' in Adaptive Server to execute the %s command or option.");
		add(2919  , 16 , "There is no automatic_startup copy for the %S_MSG in database '%S_DBID'.");
		add(2920  , 16 , "A service key '%.*s' already exists for this database. Use ALTER ENCRYPTION KEY to regenerate this key.");
		add(2921  , 16 , "You cannot grant predicated privileges on %s.");
		add(2922  , 16 , "The service key '%.*s' does not exist in database %s. Use CREATE ENCRYPTION KEY to create one if it is needed.");
		add(2923  , 16 , "Static encryption version '%d' is not supported by the current server.");
		add(2924  , 16 , "Cannot create encryption keys in a local temporary database.");
		add(2925  , 16 , "Cannot set the system encryption password in a local temporary database.");
		add(2926  , 16 , "Failed to set the password for the %S_MSG in memory. You should report this incident to the Key Custodian.");
		add(2927  , 16 , "Failed to write/update the master key encryption key for the %S_MSG in the master key startup file. You should report this incident to the Key Custodian.");
		add(2928  , 16 , "Failed to clean up the global password vault entry in memory and/or the master key encryption key entry in the master key startup file for database '%S_DBID'. You should report this incident to the Key Custodian.");
		add(2929  , 16 , "Access rule %ld specified cannot be attached to tabid %ld, colid %d as the column is encrypted and the ciphertext setting is on.");
		add(2930  , 16 , "Failed to store the master key startup file on quorum device.");
		add(2931  , 16 , "Failed to extract the master key startup file from quorum device.");
		add(2932  , 16 , "Failed to get the inode structure of the master key startup file on quorum device.");
		add(2933  , 16 , "You are not allowed to set the master key startup file path in cluster with private installation.");
		add(2934  , 16 , "Option 'sync_with_mem' is not valid in cluster with private installation.");
		add(2935  , 16 , "Option 'sync_with_qrm' is only valid in cluster with private installation.");
		add(2936  , 16 , "Failed to unset the existing default syscomment service key.");
		add(2937  , 10 , "The requested password is encrypted but the key to decrypt it is not available from database '%S_DBID'. The key custodian enables access to the key.");
		add(2938  , 10 , "Failed to %s %s password.");
		add(2939  , 16 , "It is not allowed to delete default hidden text service key '%.*s'.");
		add(2940  , 16 , "Password is too long. The maximum character length for a stored external password is %d bytes.");
		add(2941  , 16 , "Invalid option '%s' specified to modify key '%.*s'.");
		add(2942  , 16 , "Processed %d objects.");
		add(2943  , 16 , "The encryption type '%d' is invalid.");
		add(2944  , 16 , "Conversion from encryption type '%d' to '%d' is not allowed.");
		add(2945  , 16 , "Failed to decrypt %s password.");
		add(2946  , 16 , "Failed to %s service key %s.");
		add(2947  , 16 , "Failed to modify the %S_MSG. Master key can only be encrypted by user password or external key while dual master key can only be encrypted by user password.");
		add(2948  , 10 , "Password service key was dropped and related external passwords were downgraded successfully. User has to reset Replication Agent password, CIS and RTMS external login passwords manually if they are available in order to finish the downgrade process.");
		add(2949  , 16 , "%s password has been removed by the system. The password must be reset.");
		add(2950  , 16 , "The %S_MSG copy for user '%.*s' does not exist in database '%S_DBID'. This may also indicate a wrong encryption password setting for the key in server memory. This event should be reported to the key custodian.");
		add(2951  , 16 , "To set encryption password for the %S_MSG you must be the owner of the base key or the assignee of a regular key copy of the key.");
		add(2952  , 16 , "You cannot reference views or derived tables in predicates.");
		add(2953  , 16 , "Failed to re-encrypt external passwords in database %s.");
		add(2954  , 16 , "Cannot set session authorization within a stored procedure created with execute as owner.");
		add(2955  , 16 , "Encryption key '%.*s' has already been proteced with %S_MSG.");
		add(2956  , 20 , "Unable to grab a buffer to encrypt logical page %d in database %d. Increase the size of the %dK buffer pool in the buffer cache '%.*s'.");
		add(2957  , 20 , "Unable to grab a buffer to decrypt logical page %d in database %d. Increase the size of the %dK buffer pool in the buffer cache '%.*s'.");
		add(2958  , 16 , "Failed to encrypt page: pageno %d, dbid %d.");
		add(2959  , 16 , "Failed to decrypt page: pageno %d, dbid %d.");
		add(2960  , 16 , "Columns in a table for table variable cannot be encrypted.");
		add(2961  , 16 , "The current password for base encryption key '%.*s' is required to add a key copy.");
		add(2962  , 16 , "Invalid option '%s' specified to recover the encryption key '%.*s'. Use key copies protected with user encryption password for key recovery.");
		add(2963  , 17 , "Unable to grab a buffer to do consolidation for logical page %d in database %d. Increase the size of the %dK buffer pool in the buffer cache '%.*s'.");
		add(2964  , 16 , "Failed to set the master key in memory. You should report this incident to the Key Custodian.");
		add(3001  , 17 , "%.*s failed: insufficient memory to allocate backout structure. Raise the value of the configuration parameter 'procedure cache size'.");
		add(3003  , 20 , "DUMP DATABASE failed to establish a connection to the Backup Server.  Attempt to dump database '%.*s' has failed.");
		add(3004  , 14 , "You must be the DBO of database %.*s or have Operator (OPER) role to run DUMP DATABASE.");
		add(3005  , 10 , "DUMP DATABASE failed to end flushlist synchronisation.  In database '%.*s', some transactions may be suspended and further DUMP DATABASEs blocked, requiring reboot of the SQLServer.");
		add(3015  , 10 , "WARNING: In order to LOAD the master database, the ASE must run in single-user mode. If the master database dump uses multiple volumes, you must execute sp_volchanged on another ASE at LOAD time in order to signal volume changes.");
		add(3016  , 17 , "DUMP DATABASE for '%S_DBID' cannot continue because of insufficient log space. Free some log space with DUMP TRANSACTION or turn off replication.");
		add(3019  , 0  , "Unable to write statistics for object %d in database %d. Please run update statistics on this table after loading this database or prior to accessing the table in the loaded database.");
		add(3020  , 0  , "Unable to write statistics for index %d of object %d in database %d. Please run update statistics on this index after loading this database or prior to using this index in the loaded database.");
		add(3021  , 0  , "Unable to write statistics for all indexes of object %d in database %d. Please run update statistics on all indexes after loading this database or prior to using the indexes in the loaded database.");
		add(3022  , 16 , "Invalid Password length, valid length is between %d and %d.");
		add(3023  , 16 , "Dump is not password-protected, password not required.");
		add(3024  , 16 , "Invalid password.");
		add(3025  , 16 , "Dump is password-protected, a valid password is required.");
		add(3026  , 17 , "DUMP DATABASE for database '%.*s' [sid='%d'] failed at distributed dump operation '%s' on instance '%d' due to PCM error while receiving reply message or message status from remote instance '%d'.");
		add(3027  , 17 , "DUMP DATABASE for database '%.*s' [sid='%d'] failed : Distributed dump operation '%s' on instance '%d' detected remote instance '%d' to be down.");
		add(3028  , 17 , "DUMP DATABASE: Distributed dump operation did not find the dbtable on the remote instance. Dump failed.");
		add(3029  , 17 , "DUMP DATABASE: unable to spawn or start remote dump thread.");
		add(3030  , 16 , "Backup Server start-up file %s does not exist or does not have execute permission.");
		add(3031  , 16 , "Cannot start Backup Server. See the Configuration Guide for information about manually starting Backup Server.");
		add(3032  , 10 , "Backup Server %s started successfully.");
		add(3033  , 17 , "DUMP DATABASE for database '%.*s' [sid='%d'] on instance '%d' was aborted due to error '%d' on instance '%d'. See the instance error log for more detail.");
		add(3034  , 17 , "DUMP DATABASE for database '%.*s' [sid='%d'] failed at distributed dump operation '%s' on instance '%d' due to error '%d' on remote instance '%d'. See the instance error log for more detail.");
		add(3036  , 17 , "DUMP DATABASE with dbid %d failed because of the error: %s.");
		add(3037  , 10 , "Command %s waits for cluster failover to complete and retry to get ocm lock.");
		add(3038  , 16 , "Backup Server start-up file is %s.");
		add(3039  , 16 , "SYBASE_ASE environment variable not set.");
		add(3040  , 10 , "Backup Server '%s' is already down.");
		add(3041  , 10 , "Attempting to shut down Backup Server '%s'.");
		add(3042  , 10 , "Multiple Backup Servers are enabled with '%s' policy. Backup Server '%s' is being used for connection.");
		add(3043  , 18 , "DUMP DATABASE failed to log information about deallocated pages generated by active minimally-logged transactions in database '%.*s'. Retry DUMP DATABASE later when there is no active minimally-logged transaction.");
		add(3044  , 18 , "DUMP DATABASE failed to restore the original database fragments and the logical space that was marked as deleted has been permanently deleted.");
		add(3045  , 18 , "The WITH SHRINK_%s option has broken the dump sequence. When restoring the sequence, this database dump must be loaded prior to loading the transaction log that follows it.");
		add(3046  , 10 , "Could not get '%.*s' lock. Lock status is %s.");
		add(3047  , 16 , "Specify the value for the '%.*s' option.");
		add(3048  , 16 , "The option '%s' is ignored because the database '%.*s' is %S_MSG.");
		add(3049  , 16 , "Option '%s': File '%s' does not exist.");
		add(3050  , 10 , "Option '%s': File dumped to '%s' successfully.");
		add(3051  , 16 , "The dump configuration '%s' supplied for %s is invalid.");
		add(3052  , 16 , "%s requires a dump configuration name because the configuration option '%s' is enabled.");
		add(3055  , 18 , "Dump configuration for '%s' failed.");
		add(3056  , 16 , "You cannot execute an incremental dump before a full database dump.");
		add(3057  , 16 , "You cannot execute an incremental dump because the option 'allow incremental dumps' is not enabled in this database.");
		add(3058  , 16 , "Unable to allocate %d bytes required by the option 'optimize dump for faster load' from the procedure cache.");
		add(3059  , 16 , "Unable to add ENCRYPTION resdom for encrypted database.");
		add(3060  , 18 , "Warning: Unable to spawn a service task for DUMP DATABASE to flush unlogged updates.");
		add(3061  , 10 , "Dump history file %s has been initialized. The file was backed up to %s prior to initialization.");
		add(3062  , 16 , "Database encrypted with random database encryption key is not allowed to be dumped.");
		add(3063  , 18 , "DUMP DATABASE for database '%.*s' failed.");
		add(3101  , 16 , "Database in use.  A user with System Administrator (SA) role must have exclusive use of database to run load.");
		add(3102  , 16 , "Specified file '%.*s' is not in valid dump database %s format.");
		add(3103  , 17 , "LOAD DATABASE for database '%.*s' failed: insufficient memory to allocate backout structure. Raise the value of the configuration parameter 'procedure cache size'.");
		add(3105  , 16 , "Data on dump will not fit into current database. Need %d Mbyte database.");
		add(3108  , 16 , "LOAD DATABASE must be used in single user mode if trying to restore the Master database.");
		add(3109  , 16 , "This dump was created from the Master database. A dump from Master can only be loaded as part of the Restore Master procedure.");
		add(3110  , 14 , "You must be the DBO of database %.*s or have Operator (OPER) role to run LOAD DATABASE.");
		add(3111  , 16 , "This dump was not created from the Master database. Master can only be loaded from a dump of the Master database.");
		add(3112  , 16 , "Cannot load any database other than Master when server in single-user mode.");
		add(3113  , 21 , "Database %.*s does not have an entry in SYSUSERS for the DBO.");
		add(3114  , 21 , "Database %.*s does not have an entry in Sysdatabases.");
		add(3115  , 10 , "User %.*s in database %.*s has suid %d, which is the same as the suid of the DBO (as defined in Sysdatabases).  User %.*s will be given suid %d.");
		add(3116  , 10 , "When all load transactions have been completed for database %.*s, user %.*s should be given the next available suid.");
		add(3117  , 10 , "Database %.*s already has a user with suid %d.  Please call Technical Support.");
		add(3118  , 16 , "LOAD DATABASE has been interrupted by a USER ATTENTION signal.  A LOAD DATABASE must be completed in this database before it will be accessible.");
		add(3120  , 16 , "The database you are attempting to LOAD was DUMPed under a different sort order ID (%d) or character set ID (%d) than the ones running on this server (SortOrd = %d, CharSet = %d). If the sort orders differ, at least one of them is non-binary.");
		add(3121  , 0  , "Index %s.%s (objid=%d, indid=%d) may be invalid. It uses CHAR or VARCHAR columns in its key and was created under a different sort order ID (%d) or charset ID (%d) than the ones on this server (SortOrd=%d, CharSet=%d).");
		add(3122  , 21 , "Failed to patch the transaction log for database '%.*s'.");
		add(3123  , 0  , "The dump header contains an invalid dump type code: %d. This is not a valid transaction log dump or database dump.");
		add(3124  , 0  , "This is a %S_MSG dump of database ID %d, name '%.*s', from %S_DATE. ASE version: %.*s. Backup Server version: %.*s. Database page size is %d.");
		add(3125  , 0  , "Database contains %u pages; checkpoint RID=(%S_RID); next object ID=%d; sort order ID=%d, status=%d; charset ID=%d.");
		add(3126  , 10 , "Log begins on page %u; checkpoint RID=%S_RID; previous BEGIN XACT RID=(%S_RID); sequence dates: (old=%S_DATE_LONG, new=%S_DATE_LONG); truncation page=%u; %u pages deallocated; requires database with %u pages.");
		add(3127  , 0  , "All dumped pages have been loaded. ASE is now clearing pages above page %u, which were not present in the database just loaded.");
		add(3128  , 10 , "ASE has finished clearing database pages.");
		add(3129  , 10 , "Failed to clear in-load status bit for database '%.*s'.");
		add(3130  , 16 , "Database maxhold label found in dump is an invalid security label.  Discontinuing load.");
		add(3131  , 16 , "Database hurdle label found in dump is an invalid security label.  Discontinuing load.");
		add(3132  , 16 , "Server Data Low label found in dump is an invalid sensitivity label.  Discontinuing load.");
		add(3133  , 16 , "Server Data High label found in dump is an invalid sensitivity label.  Discontinuing load.");
		add(3134  , 10 , "Security label consistency check failed.  Please run DBCC SECURITY (LABEL_CHECK, '%S_DBID', {FULL | NOREPORT}, FIX) after all loads have been performed in order to make this database usable.");
		add(3135  , 10 , "Please run DBCC SECURITY (LABEL_CHECK, , [FULL | NOREPORT], FIX) after all loads have been performed.");
		add(3136  , 0  , "Database log version=%d; database upgrade version=%d; database durability=%s.");
		add(3137  , 10 , "Use the ONLINE DATABASE command to bring this database online; ASE will not bring it online automatically.");
		add(3138  , 10 , "User defined role '%.*s' used in database '%.*s' does not exist in this server. Use CREATE ROLE to create this role after the database online.");
		add(3139  , 10 , "The user name, '%.*s', in SYSUSERS is the same as a role name in this Server. See the Security Administration Guide for information on how to resolve this naming conflict.");
		add(3140  , 10 , "The group name, '%.*s', in SYSUSERS is the same as a role name in this server. See the Security Administration Guide for information on how to resolve this naming conflict.");
		add(3141  , 16 , "Object '%.*s' in database '%.*s' is owned by login '%.*s' who does not exist in this server.");
		add(3142  , 16 , "Cannot load database '%.*s' because it is failed over.");
		add(3143  , 16 , "The master database you are attempting to load was dumped under a different sort order id (%d) or character set id (%d) than the ones running on this server (sort order id = %d, character set id = %d).");
		add(3144  , 0  , "Since this load may render the master database unusable, this load will only be permitted under the 3100 traceflag. Please contact SAP Technical Support regarding the correct usage of this traceflag.");
		add(3146  , 0  , "ASE cannot load this database dump because the version in the dump is newer than the version in the database. Database: log version=%d, upgrade version=%d. Dump: log version=%d, upgrade version=%d.");
		add(3147  , 0  , "Temporary databases cannot be loaded.");
		add(3148  , 18 , "Unable to verify that the creator of object id '%d' in 'sysobjects' has a valid login in master.dbo.syslogins.");
		add(3149  , 18 , "Unable to verify that the role in 'sysusers' with uid '%d' has a corresponding role in master.dbo.syssrvroles.");
		add(3150  , 18 , "Unable to verify that there is no user or group in 'sysusers' with the same name as the role with srid '%d' in 'master.dbo.syssrvroles'.");
		add(3151  , 16 , "Adaptive Server cannot load this database because the database that was dumped was not quiescent when the dump was performed. Run sp_flushstats before DUMP DATABASE and ensure that the database is not updated during the dump.");
		add(3152  , 10 , "Started cross-platform conversion for database %.*s.");
		add(3153  , 10 , "Started cross-platform conversion for system objects.");
		add(3154  , 10 , "Completed cross-platform conversion for system objects.");
		add(3155  , 10 , "Started cross-platform conversion for user objects.");
		add(3156  , 10 , "Completed cross-platform conversion for user objects.");
		add(3157  , 10 , "Started cross-platform conversion for log records.");
		add(3158  , 10 , "Completed cross-platform conversion for log records.");
		add(3159  , 10 , "Completed cross-platform conversion for database %.*s.");
		add(3160  , 0  , "Cross-platform conversion for database %.*s: %u pages completed.");
		add(3161  , 17 , "LOAD DATABASE for database '%.*s' failed during cross-platform conversion: insufficient memory to allocate context structure. Raise the value of the configuration parameter 'procedure cache size'.");
		add(3162  , 17 , "LOAD DATABASE for database '%.*s' failed during cross-platform conversion: insufficient memory to allocate translation dictionary. Raise the value of the configuration parameter 'procedure cache size'.");
		add(3163  , 10 , "WARNING: One or more indexes on user tables may have been marked as 'suspect' making these indexes unusable. Use the sp_post_xpload stored procedure to check and rebuild these indexes.");
		add(3164  , 16 , "LOAD DATABASE for the master database is not allowed across platforms.");
		add(3165  , 0  , "LOAD DATABASE across platform is not supported for this database dump version of ASE. Upgrade version of this dump is %d.");
		add(3166  , 0  , "segmap: 0x%08x lstart=%u vstart=[vpgdevno=%d vpvpn=%d] lsize=%u unrsvd=%u");
		add(3167  , 16 , "DUMP DATABASE/TRANSACTION is not currently supported on archive databases.");
		add(3168  , 10 , "The archive database '%.*s' has been brought online automatically. It may have some inconsistencies as a result of not running recovery.");
		add(3169  , 10 , "Compression Level: %d; Compression Format: '%s'; ANSI Standard Version: %d; Block Size: %d; Zone Size: %d; Number of Stripes: %d; Stripe Creation Date: %S_DATE.");
		add(3170  , 16 , "The option WITH VERIFY[ONLY] is not allowed in cross-platform loads.");
		add(3171  , 16 , "LOAD DATABASE for database '%.*s' cannot start because cluster is in failover");
		add(3172  , 16 , "Adaptive Server cannot load this dump because its version is incompatible with the version of this server. Database: version=%d, Dump: version=%d.");
		add(3173  , 16 , "The dump cannot be loaded into database '%.*s' because the durability level (%d) of the database that was dumped is not supported.");
		add(3175  , 10 , "The database contains %u logical pages (%d MB) and %u physical pages (%d MB).");
		add(3176  , 10 , "Unavailable disk fragment: lstart=%u lsize=%u");
		add(3177  , 10 , "proxy_update: default_location='%.*s'.");
		add(3178  , 10 , "dbdevinfo: devtype=%d vdevno=%d devname=%.*s physname=%.*s devsize=%d dbdevsize=%d vstart=%d devstat=%d devstat2=%d");
		add(3179  , 10 , "cachedevinfo: devtype=%d cachename=%.*s cachesize=%d dbcachesize=%d cache_status=%d cache_partition=%d");
		add(3180  , 10 , "%s %s DATABASE %.*s");
		add(3181  , 10 , "%s %s = %s");
		add(3182  , 16 , "The dump image specified does not contain information for any of the database devices. You can not generate creation scripts from this dump image.");
		add(3183  , 16 , "The dump header does not contain device information for device number %d.");
		add(3184  , 16 , "LOAD DATABASE across platforms is not allowed for this database, because the database contains compressed tables.");
		add(3185  , 16 , "The %s segment in the target database '%.*s' is too small (%d MB) to accommodate the %s segment from the dumped database (%d MB).");
		add(3186  , 16 , "A call to %s failed while attempting to %s dump history file %s.");
		add(3187  , 16 , "Purge date ''%s'' is invalid.");
		add(3188  , 16 , "No records found for database %s.");
		add(3189  , 16 , "An invalid date, %s, was encountered in the dump history file.");
		add(3190  , 10 , "Warning. Unable to generate the load sequence until '%s' because no transaction log dumps were taken between '%s' and '%s'.");
		add(3191  , 10 , "Warning. Unable to generate the load sequence until '%s' because the database dump that meets the search criteria also contains transactions from '%s' until '%s'.");
		add(3192  , 16 , "The dump history file version is missing or invalid.");
		add(3193  , 16 , "Database '%s' does not have space allocated for page %u from the dump. Extend the database by %u MB and retry the command.");
		add(3194  , 16 , "Either target or dumped database is encrypted.");
		add(3195  , 16 , "Database encryption key of dumped and target databases are not same.");
		add(3196  , 16 , "Could not verify the database encryption key of dumped and target databases.");
		add(3197  , 10 , "%s %.*s");
		add(3198  , 16 , "This operation is not allowed on encrypted database.");
		add(3199  , 16 , "This operation is not allowed on Single Instance database '%.*s' belonging to remote node with instanceid=%d. Please retry on owner node.");
		add(3201  , 16 , "No dump device has been specified.");
		add(3202  , 16 , "Received MULTARG is not for device name as expected.");
		add(3203  , 16 , "Backup Server has detected an ASE error.");
		add(3204  , 16 , "User aborted DUMP or LOAD for database '%S_DBID'.");
		add(3205  , 26 , "DUMP failed in database '%S_DBID': attempt to add run to full run list.");
		add(3206  , 20 , "Backup Server has returned an unexpected status to ASE: %d.");
		add(3207  , 16 , "More parameters have been specified to DUMP or LOAD than can be passed to the Backup Server.");
		add(3208  , 16 , "Unexpected end of file while reading beginning of dump. Please confirm that dump media contains a valid ASE dump. The ASE error log may contain more information on the problem.");
		add(3209  , 16 , "'%.*s' is not a DUMP or LOAD device. Please check sysdevices.");
		add(3210  , 20 , "DUMP or LOAD of database '%.*s' encountered lock denial on SYSDEVICES to prevent deadlock.  Deadlock should not have been possible.");
		add(3211  , 20 , "DUMP failed in database %.*s:  error occurred executing RPC.");
		add(3212  , 17 , "DUMP failed in database %.*s:  unexpected status executing RPC: %d.");
		add(3214  , 0  , "%s: virtual page %d does not belong to any valid disk device.");
		add(3216  , 0  , "Backup Server session id is: %d. Use this value when executing the 'sp_volchanged' system stored procedure after fulfilling any volume change request from the Backup Server.");
		add(3217  , 17 , "%s for database '%.*s' failed to write the dump header.");
		add(3218  , 21 , "%s for database '%.*s' failed to write the dump trailer.");
		add(3219  , 21 , "The Backup Server encountered an invalid dump trailer page, so ASE is not able to correctly recover database '%.*s'. Because of this error, the database is now suspect.");
		add(3220  , 17 , "Could not establish communication with Backup Server '%.*s'.  Please make sure that there is an entry in Sysservers for this server, and that the correct server is running.");
		add(3221  , 0  , "Could not install a function required to create a %S_MSG; returned error code is %d.");
		add(3222  , 0  , "Attempt to write a %S_MSG failed; returned error code is %d.");
		add(3223  , 0  , "Attempt to read a %S_MSG failed; returned error code is %d.");
		add(3224  , 20 , "INTERNAL ERROR: function '%s' was passed an invalid dump type code: %d.");
		add(3225  , 0  , "I/O failed while attempting to clear pages starting at page %d of disk number %d.");
		add(3226  , 21 , "Attempt to allocate a %s failed -- there are none available. ASE is unable to clear unused pages in the database being loaded. Because of this error, the database is unusable.");
		add(3227  , 0  , "No large buffers were available, so pages are being cleared by writing each page separately. Please be patient; %d pages are being written, which may take a substantial amount of time. (Rough estimate: %d minutes.)");
		add(3228  , 17 , "Insufficient contiguous ASE memory to allocate DB disk status array; %d bytes were required. Raise the value of the configuration parameter 'procedure cache size'.");
		add(3229  , 10 , "For logical disk device '%.*s', primary device '%.*s' is not active.  Secondary device '%.*s' will be used.");
		add(3230  , 24 , "For logical disk device '%.*s', neither primary device '%.*s' nor secondary device '%.*s' is active.  %s cannot continue.");
		add(3231  , 20 , "Invalid disk side token: %d.");
		add(3232  , 17 , "For logical disk device '%.*s', %S_MSG physical disk device '%.*s' has become unmirrored since the start of %s.  Resulting work is invalid.");
		add(3233  , 17 , "%s for database '%S_DBID' failed:  an alarm function could not be installed.");
		add(3234  , 20 , "%s for database '%S_DBID' failed to remove alarm with ID = %d.");
		add(3235  , 20 , "For logical disk '%.*s', %S_MSG physical device is internally designated DB device for %s, but Sysdevices.status value '0x%x' conflicts.");
		add(3236  , 10 , "Remirroring the affected portions of the usage map that are on mirrored devices.");
		add(3237  , 0  , "%s failed to find disk status entry for virtual page '%d'.");
		add(3238  , 0  , "Internal I/O error on %S_MSG pysical device on virtual page number '%d' while %s was remirroring loaded database.");
		add(3239  , 17 , "%s could not allocate a large IO buffer.  Try again later.");
		add(3240  , 20 , "Unable to obtain the ASE's current working directory. The ASE must have search permission on its current working directory and the name must be shorter than %d bytes.");
		add(3241  , 20 , "Unable to get IO access type for device '%.*s'.");
		add(3242  , 20 , "Internal sensitivity label inconsistency encountered during dump.  Conversion of Data High, Data Low, database maxhold, or database hurdle to human-readable string failed.");
		add(3243  , 10 , "Loading a dump from a non-B1 ASE into a B1 ASE is not allowed.");
		add(3244  , 0  , "%s failed for database '%S_DBID' with an internal transaction logging system failure; returned error code is %d.");
		add(3246  , 18 , "Unable to update the sysdatabases.dumptrdate column for dbid %d. The next DUMP TRANSACTION on the database will automatically correct this.");
		add(3247  , 16 , "%s for database '%.*s' failed: connection to %S_MSG failed. %S_MSG may have been shut down with no wait, or killed with an operating system command.");
		add(3248  , 0  , "LOAD DATABASE / TRANSACTION failed because of page size incompatibility. The current page size is %d, and the page size in the dump is %d.");
		add(3250  , 16 , "The devices '%.*s' and '%.*s' specified in the command should be different.");
		add(3251  , 16 , "The maximum number of stripes allowed in a DUMP/LOAD command is %d.");
		add(3252  , 16 , "%s is not allowed when multiple instances are active. Number of active instances = %d.");
		add(3253  , 17 , "There are not enough Backup Server connections available to use %d stripes because %d are required and there are only %d available. The configuration paramater 'number of backup connections' is set to %d and %d are in use.");
		add(3254  , 16 , "The shared memory address '%.*s' received as a parameter of the native RPC '%s' is invalid.");
		add(3255  , 0  , "Backup Server is trying to load %u pages in database %S_DBID starting at page %u, but the highest page in the database is %u.");
		add(3256  , 0  , "Backup Server has requested loading page %u in database %S_DBID, but the page in the archive shows ID %u in the header. Run DBCC consistency checks after the load completes. Please contact SAP Technical Support if any error is detected.");
		add(3257  , 10 , "Adaptive Server has received a duplicate request to attach to the shared memory region with ID = '%.*s'. The request is being ignored.");
		add(3258  , 16 , "Failed to execute '%s' in the database '%.*s' because this native RPC is applicable only to in-memory databases.");
		add(3259  , 18 , "A request to attach to the shared memory segment with ID = '%*.s' has failed.");
		add(3260  , 16 , "You must have license '%s' to perform DUMP or LOAD commands using Tivoli Storage Manager.");
		add(3261  , 16 , "You cannot load this dump because it contains functionality (feature ID %d) that is available only on the server on which it was dumped.");
		add(3262  , 16 , "This dump's header shows it contains a database version, %d, that this server cannot read. This server can only read versions up to %d. This server cannot load this dump.");
		add(3263  , 10 , "Warning: An unknown element with ID '%d' was found while processing the dump header or trailer item with ID '%d' and it will be skipped.");
		add(3264  , 16 , "Invalid length %d (maximum length %d) found for element with ID '%d' when processing dump header or trailer item with ID '%d'.");
		add(3265  , 16 , "The dump header has an expected device/cache count of %d but contains information for %d retrieved devices/caches.");
		add(3266  , 16 , "The devices '%.*s' is not supported for LOAD ... WITH COPYONLY.");
		add(3267  , 18 , "The option 'optimize dump for faster load' cannot be applied due to previous errors.");
		add(3268  , 16 , "Invalid option encountered in '%s'. Valid values are '%s'.");
		add(3301  , 21 , "Invalid log record found in syslogs (logop %d).");
		add(3303  , 21 , "Failed to find SAVEPT in log for xact %S_RID, current number is %d, looking for %d.");
		add(3305  , 0  , "Page %u in database '%.*s' read in during LOAD TRANSACTION recovery was uninitialized.");
		add(3306  , 0  , "Process %d was expected to hold logical lock on page %u instead of process %d.");
		add(3307  , 0  , "Process %d was expected to hold logical lock on page %u in database %S_DBID for object %S_OBJID, index number %d.");
		add(3308  , 0  , "Page %u was expected to have %s lock on it.");
		add(3309  , 0  , "While in backout, process %d was chosen as deadlock victim while waiting for a resource lock on page %u.");
		add(3310  , 0  , "Cannot find log record with RID: (%d, %d).");
		add(3311  , 0  , "Space left (%d bytes) on page %u is insufficient to move data of %d length.");
		add(3312  , 0  , "Free offset %d is invalid on page %u. It must be within %d and %d.");
		add(3313  , 10 , "Error while redoing log row in database '%S_DBID'.  %S_RID.");
		add(3314  , 10 , "Error while undoing log row in database '%.*s'.  %S_RID.");
		add(3315  , 21 , "While redoing a transaction, the end of the log was encountered before the endxact record.");
		add(3316  , 21 , "While redoing a transaction, an attempt to reget an XCMD row failed.");
		add(3317  , 16 , "ROLLBACK TRIGGER can only be executed when a trigger is executing.  It may be called directly by the trigger, or from a stored procedure executed directly or indirectly from a trigger.");
		add(3318  , 0  , "Failed to start a scan on %s due to error number %d.");
		add(3321  , 21 , "Redo of CREATE INDEX in transaction ID (%d,%d) for table name '%.*s', object ID '%d', failed to find sort partition log record. Recovery of database '%.*s' cannot continue.");
		add(3322  , 21 , "In redo of sort, the number of partitions expected (%d) does not equal the number of partitions logged (%d) by transaction ID (%d,%d) operating on table '%.*s', object ID '%.*s'. Recovery of database '%.*s' cannot continue.");
		add(3323  , 17 , "Unable to allocate memory in order that recovery can perform post-commit cleanup. Please run DBCC checks on the database '%S_DBID' after recovery has completed.");
		add(3324  , 18 , "Internal error occurred while attempting to perform post-commit cleanup (%p, %x, %x).");
		add(3325  , 18 , "Recovery is unable to perform post-commit cleanup. Please run DBCC checks on the database '%S_DBID' after recovery has completed.");
		add(3327  , 0  , "During redo, the page timestamp check found page %u needs redo when the log record is before the first log record in phase 1 that needs redo. page timestamp=%04x %08x. Log timestamp used for comparison=%04x %08x. Log record marker = (%u, %d).");
		add(3328  , 21 , "Redo of '%s' in transaction ID (%d,%d) for table name '%.*s', object ID '%d' did not find '%s' system catalog log record. Recovery of database '%.*s' cannot continue.");
		add(3329  , 21 , "Redo of '%s' for table '%.*s', object ID '%d' did not build compression information. Recovery of database '%.*s' cannot continue.");
		add(3330  , 20 , "Cannot find object ID '%d' while redoing '%s' command. Recovery of database '%.*s' cannot continue.");
		add(3331  , 0  , "Page '%u' compression for object ID '%d' cannot be redone because its redo log record has compression version '%d' which is not supported by this ASE version. Recovery of database '%.*s' cannot continue.");
		add(3332  , 10 , "The log for database '%.*s' includes a %s operation that is incompatible with this server version and operating environment.");
		add(3333  , 20 , "Failed to get a log marker for scan to undo transaction (%S_RID) in database '%.*s' due to error %d.");
		add(3401  , 21 , "Rec_logbounds: getnext SCAN_RID of last checkpoint failed on Rid from sysdatabases. %S_RID.");
		add(3403  , 0  , "During recovery initialization, page %u was encountered. This page belongs to object %d, not the log.");
		add(3404  , 21 , "Rec_complete: Could not open controlling database (id %d) of controlling database in multi-db transaction.");
		add(3405  , 10 , "Recovering database '%.*s'.");
		add(3406  , 10 , "%d transactions rolled forward.");
		add(3407  , 10 , "%d transactions rolled back.");
		add(3408  , 10 , "Recovery complete.");
		add(3409  , 10 , "Roll forward transaction '%.*s'.");
		add(3410  , 10 , "Roll back transaction '%.*s' -- was aborted.");
		add(3411  , 10 , "Roll back transaction '%.*s' -- no 'end transaction'.");
		add(3412  , 0  , "Database %d, table %d. Attempt to mark table as suspect. Getnext SCAN_CLUST on sysobjects.objid failed.");
		add(3413  , 21 , "Attempt to mark the database with id '%d' as not recovered or suspect failed.");
		add(3414  , 10 , "Database '%.*s' (dbid %d): Recovery failed. Check the ASE errorlog for further information as to the cause.");
		add(3415  , 20 , "Database '%.*s' (dbid %d): BEGIN TRAN failed. This operation cannot continue.");
		add(3416  , 20 , "Database '%.*s' (dbid %d): COMMIT TRAN failed. This operation cannot continue.");
		add(3417  , 21 , "Cannot recover the master database, exiting.");
		add(3418  , 21 , "Not enough deses to open '%.*s'.");
		add(3419  , 16 , "Unable to proceed with the recovery of dbid <%d> because of previous errors.");
		add(3420  , 10 , "This database requires upgrade, but its log is nearly full. Extend the log, or try 'DUMP TRAN %.*s WITH NO_LOG', then retry ONLINE DATABASE.");
		add(3421  , 21 , "Unable to recover database '%.*s' because of a failure to initialize the global timestamp.  This indicates that a problem exists in the log for the current database.  Please contact Technical support for assistance.");
		add(3422  , 20 , "Database '%.*s' (dbid %d): failed to open table ID %d, for which a row exists in %.*s.");
		add(3423  , 21 , "Error recovering database '%.*s' - could not find expected BEGIN TRANSACTION record at location: %S_RID.");
		add(3424  , 0  , "No more room in transaction table for transaction (%d, %d).");
		add(3425  , 0  , "Transaction (%d, %d) not found in transaction table.");
		add(3426  , 10 , "Could not make log consistent during special recovery of database %d.  Please contact Technical support for assistance.");
		add(3429  , 21 , "Error recovering database '%.*s' - could not connect to commit service to check completion status of xact: %S_RID.");
		add(3430  , 16 , "Could not add a checkpoint record during special recovery of database %d. If you intend to do updates in this database, first free up space by running DUMP TRANasction WITH NO_LOG, and then checkpoint the database.");
		add(3431  , 10 , "Could not build an allocation map for the database %.*s. It does not have a DBINFO structure");
		add(3433  , 16 , "Name is truncated to '%.*s'.  The maximum name length is %d.");
		add(3434  , 20 , "Cannot change sortorder. Server shutting down.  Restart to continue with sortorder unchanged.");
		add(3435  , 20 , "Sortorder cannot be changed because user objects or user databases exist.");
		add(3436  , 20 , "Cannot rebuild index %d for the '%.*s' table in the '%.*s' database.");
		add(3437  , 10 , "Please run sp_dbupgrade in database %.*s to update system catalogs.");
		add(3438  , 21 , "Function %s was called by process %d, which is not the recovery process.");
		add(3439  , 10 , "Database '%S_DBID' has inconsistent security labels.  Disabling use of database.");
		add(3440  , 10 , "System stored procedures are not currently accessible due to a recovery error. Please consult the errorlog. You may need to drop and re-create the sybsystemprocs database and re-run the installmaster SQL script if the error is unrecoverable.");
		add(3442  , 10 , "Started flushing modified pages to disk for database '%.*s' (dbid = %d) on %S_INSTID.");
		add(3443  , 16 , "Invalid log version found for database '%S_DBID': '%d'. A log version greater than '%d' is from an later, incompatible version of ASE. Database cannot be opened.");
		add(3444  , 10 , "Database '%.*s' is now online.");
		add(3445  , 10 , "ASE could not bring database '%.*s' online.");
		add(3446  , 16 , "You do not have privilege to bring database '%.*s' online.");
		add(3447  , 10 , "Database '%.*s' appears to be in the process of being loaded; ASE will not bring it online automatically. Use the ONLINE DATABASE command to bring this database online.");
		add(3448  , 10 , "Database '%.*s' appears to be at an older version '%s' than the present installation at version '%s'; ASE will assess it, and upgrade it as required.");
		add(3449  , 10 , "Database '%.*s': beginning upgrade step [ID %5d]: %S_MSG %s");
		add(3450  , 0  , "Database '%.*s': upgrade item %d contains a bad action identifier, %d. Please report this internal error to SAP Technical Support.");
		add(3451  , 20 , "Database '%.*s': upgrade has failed for this database.  Please refer to previous messages for the cause of the failure, correct the problem and try again.");
		add(3452  , 20 , "Database '%.*s': upgrade item %d depends on item %d, which could not be installed. Please refer to previous messages for the cause of the failure, correct the problem and try again.");
		add(3453  , 20 , "Database '%.*s': upgrade failed to open table %d.  This table should exist in every database.");
		add(3454  , 10 , "Database '%.*s': ASE could not completely upgrade this database; upgrade item %d could not be installed.");
		add(3455  , 0  , "Database '%.*s': ASE could not find its internal description of system table '%.*s'. Please report this internal error to SAP Technical Support.");
		add(3456  , 20 , "Database '%.*s': during an upgrade, ASE could not create table '%.*s'.");
		add(3457  , 0  , "Database '%.*s': the dependency list for upgrade item %d contains an invalid identifier, %d. Please report this internal error to SAP Technical Support.");
		add(3458  , 0  , "Database '%.*s': upgrade was asked to locate column '%.*s' for table '%s'; this column does not exist. Please report this internal error to SAP Technical Support.");
		add(3459  , 20 , "Database '%.*s': upgrade could not determine the name of table ID '%d'. Please refer to previous error messages to determine the problem.  Fix the problem, then try again.");
		add(3460  , 20 , "Database '%.*s': upgrade could not record the installation of upgrade item '%d'. Please refer to previous error messages to determine the problem. Fix the problem, then try again.");
		add(3461  , 20 , "Database '%.*s': upgrade could not install required upgrade item '%d'. Please refer to previous error messages to determine the problem. Fix the problem, then try again.");
		add(3462  , 10 , "Database '%.*s': upgrade could not install optional upgrade item '%d'. Please refer to previous error messages to determine the problem. Upgrade will continue.");
		add(3463  , 0  , "Database '%.*s': upgrade was asked to create an index on table '%s'; this table does not exist. Please report this internal error to SAP Technical Support.");
		add(3464  , 0  , "Database '%.*s': upgrade item %d has a bad format: info=%d, data='%s'. Please report this internal error to SAP Technical Support.");
		add(3465  , 20 , "Database '%.*s': upgrade could not locate a row in systypes with usertype=%d and type=%d. Please report this internal error to SAP Technical Support.");
		add(3466  , 20 , "Database '%.*s': upgrade could not locate systypes.name where usertype=%d and type=%d. Please report this internal error to SAP Technical Support.");
		add(3467  , 20 , "Database '%.*s': Index '%s.%s' has id %d in Sysindexes, but %d in our internal description. Please report this internal error to SAP Technical Support.");
		add(3468  , 20 , "Database '%.*s': upgrade was asked to create index %d on table '%s', but there is no such index. Please report this internal error to SAP Technical Support.");
		add(3469  , 20 , "Database '%.*s': upgrade failed to create index %d on table '%s'. Please refer to previous error messages to determine the problem. Fix the problem, then try again.");
		add(3470  , 10 , "ASE could not completely upgrade database '%.*s', but the database was online when upgrade began, so it will be left online.");
		add(3471  , 10 , "Database '%.*s' cannot be brought online because it has replicated tables that may not be completely transferred. After making sure that your replication is in sync, use dbcc dbrepair to remove the secondary truncpt.");
		add(3472  , 21 , "Unable to access database '%.*s' (dbid %d): recovery failed, please contact SAP Technical Support.");
		add(3473  , 21 , "There is no space available in SYSLOGS for process %d to log a record for which space has been reserved. It may be necessary to add space to the log segment. The internal error number is %d.");
		add(3474  , 0  , "During redo the page timestamp value is less than old timestamp from log. Page #=%u, object id = %d, page timestamp=%04x %08x. Log old timestamp=%04x %08x. Log record marker = (%d, %d). Transaction ID = (%d, %d).");
		add(3475  , 21 , "There is no space available in SYSLOGS to log a record for which space has been reserved in database '%.*s' (id %d). This process will retry at intervals of one minute.");
		add(3476  , 10 , "Redo pass for database '%.*s': %d records done (%d%%); %d records left.");
		add(3477  , 10 , "Undo pass for database '%.*s': %d records done (%d%%); %d records left.");
		add(3478  , 0  , "During undo the page timestamp value is less than new timestamp from log. Page #=%u, object id = %d, page timestamp=%04x %08x. Log new timestamp=%04x %08x. Log record marker = (%u, %d).");
		add(3479  , 10 , "Redo pass of recovery has processed %d committed and %d aborted transactions.");
		add(3480  , 10 , "Undo pass of recovery has processed %d incomplete transactions.");
		add(3481  , 10 , "Undo pass of recovery has processed %d incomplete nested top actions.");
		add(3482  , 10 , "Redo pass of recovery has reinstantiated %d prepared transactions");
		add(3483  , 10 , "Undo pass of recovery has resolved %d prepared transactions");
		add(3484  , 21 , "Recovery encountered error %d while acquiring lock type %s, value (0x%lx, %d, %d) for transaction (%d, %d) in dbid %d. Log record marker = (%d, %d). Please consult the Adaptive Server error log for further information as to the cause.");
		add(3485  , 21 , "Recovery encountered an error while reserving space for log records for which space had already been reserved during run time. Please consult the Adaptive Server errorlog for further information as to the cause.");
		add(3486  , 21 , "Recovery failed to open a session with the transaction log during transaction reinstantiation. Please consult the Adaptive Server errorlog for further information as to the cause.");
		add(3487  , 21 , "Recovery detected an incorrect internal transaction state during transaction reinstantiation. Please consult the Adaptive Server errorlog for further information as to the cause.");
		add(3488  , 21 , "Recovery encountered an internal error during transaction reinstantiation. Please consult the Adaptive Server errorlog for further information as to the cause.");
		add(3489  , 10 , "Warning: A transaction '%.*s' that updated system tables was found to be in a prepared state, and is being unconditionally rolled back. Please consult your System Administrator.");
		add(3490  , 16 , "This error message number is reserved for a recovery message that must also be printable as a kernel message. Recovery error messages not to be printed as kernel messages are added under the RECOVER2 major error number.");
		add(3491  , 16 , "This error message number is reserved for a recovery message that must also be printable as a kernel message. Recovery error messages not to be printed as kernel messages are added under the RECOVER2 major error number.");
		add(3492  , 16 , "This error message number is reserved for a recovery message that must also be printable as a kernel message. Recovery error messages not to be printed as kernel messages are added under the RECOVER2 major error number.");
		add(3493  , 16 , "This error message number is reserved for a recovery message that must also be printable as a kernel message. Recovery error messages not to be printed as kernel messages are added under the RECOVER2 major error number.");
		add(3494  , 16 , "This error message number is reserved for a recovery message that must also be printable as a kernel message. Recovery error messages not to be printed as kernel messages are added under the RECOVER2 major error number.");
		add(3495  , 16 , "This error message number is reserved for a recovery message that must also be printable as a kernel message. Recovery error messages not to be printed as kernel messages are added under the RECOVER2 major error number.");
		add(3496  , 16 , "This error message number is reserved for a recovery message that must also be printable as a kernel message. Recovery error messages not to be printed as kernel messages are added under the RECOVER2 major error number.");
		add(3497  , 16 , "This error message number is reserved for a recovery message that must also be printable as a kernel message. Recovery error messages not to be printed as kernel messages are added under the RECOVER2 major error number.");
		add(3498  , 16 , "This error message number is reserved for a recovery message that must also be printable as a kernel message. Recovery error messages not to be printed as kernel messages are added under the RECOVER2 major error number.");
		add(3499  , 16 , "This error message number is reserved for a recovery message that must also be printable as a kernel message. Recovery error messages not to be printed as kernel messages are added under the RECOVER2 major error number.");
		add(3501  , 21 , "Could not get sysdatabases row for database '%d' at checkpoint time.");
		add(3502  , 21 , "No checkpoint records found in syslogs for database '%.*s'.");
		add(3505  , 14 , "Only the DBO of database %S_DBID or a user with System Administrator (SA) role may run the checkpoint command.");
		add(3508  , 0  , "Attempt to set '%.*s' database to single user mode failed because the usage count is %d. Make sure that no other users are currently using this database and rerun CHECKPOINT.");
		add(3510  , 10 , "NULL is an invalid value for the database name.");
		add(3511  , 18 , "CHECKPOINT ALL command has been aborted.");
		add(3512  , 10 , "Cannot checkpoint database '%S_DBID' because its status is: %s.");
		add(3513  , 0  , "Cannot set database '%.*s' in read-only mode because it has %d active transaction(s). Verify that no transaction is using this database, then retry the command.");
		add(3514  , 17 , "Command %s is aborted because of the error: %s.");
		add(3515  , 10 , "Attempt to set database '%.*s' to single user mode failed because cluster is in failover. Please try again after cluster failover is completed.");
		add(3516  , 10 , "Distributed checkpoint cannot proceed. Command %s needs to wait for cluster failover to complete and retry.");
		add(3517  , 10 , "Remote Checkpoint failed on instance %d for dbid %d with reply_status %d, reply_plasterror %d.");
		add(3519  , 18 , "Unable to checkpoint the database '%.*s'.");
		add(3520  , 16 , "The checkpoint log record in database '%.*s' is missing. ASE will use the first syslogs row ID (%u, %u) instead.");
		add(3601  , 10 , "Statement has been rolled back. Transaction is unaffected.");
		add(3602  , 10 , "Transaction has been rolled back.");
		add(3603  , 10 , "Single-statement transaction has been rolled back.");
		add(3604  , 10 , "Duplicate key was ignored.");
		add(3605  , 10 , "Duplicate row was ignored.");
		add(3606  , 10 , "Arithmetic overflow occurred.");
		add(3607  , 10 , "Divide by zero occurred.");
		add(3608  , 10 , "Null value used in an expression.");
		add(3612  , 0  , "Execution Time %d.");
		add(3613  , 0  , "Parse and Compile Time %d.");
		add(3614  , 0  , "Total writes for this command: %d");
		add(3615  , 0  , "Table: %.*s scan count %d, logical reads: (regular=%d apf=%d total=%d), physical reads: (regular=%d apf=%d total=%d), apf IOs used=%d");
		add(3616  , 0  , "Non-leaf page %u in table %d, index %d is empty - please rebuild the index.");
		add(3618  , 10 , "Transaction has been aborted.");
		add(3619  , 10 , "Unable to write CHECKPOINT record in database %d because the log is out of space.");
		add(3620  , 10 , "Automatic checkpointing is disabled in database '%.*s' because the log is out of space. It will continue when the DBO successfully checkpoints the database. Please free up some space or extend the database and then run CHECKPOINT.");
		add(3621  , 10 , "Command has been aborted.");
		add(3622  , 10 , "Domain error occurred.");
		add(3623  , 10 , "A transaction on a no_log table was undone. Check the errorlog file in the ASE directory for details.");
		add(3624  , 10 , "Truncation error occurred.");
		add(3625  , 0  , "Table: %.*s scan count %u, logical reads: %u, physical reads: %u, estimated I/O cost: %u.");
		add(3626  , 17 , "The transaction was aborted because it used too much stack space. Either use sp_configure to increase the stack size, or break the query into smaller pieces. spid: %d, suid: %d, hostname: %.*s, application name: %.*s");
		add(3627  , 10 , "Conversion of char/varchar datatype to security label datatype failed.");
		add(3628  , 10 , "Conversion of security label datatype to char/varchar datatype failed.");
		add(3629  , 10 , "Statement: %d  Subquery: %d  cache size: %d  hits: %d  misses: %d");
		add(3630  , 0  , "Total estimated I/O cost for statement %u (at line %u): %d.");
		add(3631  , 10 , "Total actual I/O cost for this command: %d.");
		add(3632  , 10 , "Command batch has been aborted.");
		add(3634  , 20 , "Task %d is trying to release a latch 0x%x which is already free.");
		add(3640  , 16 , "%s");
		add(3641  , 17 , "Failed to set alarm.Please try increasing the number of alarms in the configuration file.");
		add(3642  , 17 , "Unable to start flusher thread.");
		add(3643  , 17 , "Unable to start log writer thread.");
		add(3644  , 17 , "Unable to start Asynchronous logging service.");
		add(3645  , 10 , "Asynchronous Logging Service is started.");
		add(3646  , 17 , "FATAL Error: Asynchrounous logging server is stopped. You may have to terminate the user connections which seems be hanging.");
		add(3647  , 10 , "Cannot put database '%.*s' in single-user mode. Wait until all users have logged out of the database and issue a CHECKPOINT to disable 'async log service'.");
		add(3648  , 17 , "Async log service threads encountered a FATAL error while serving database '%.*s'. Database Log is locked and will not be released. Please look in the errorlog for more information or contact SAP Technical Support.");
		add(3649  , 17 , "Asynchronous Logging service is disabled for the database '%.*s'.");
		add(3650  , 0  , "Large buffers: configured %d, maximum possible %d, requested %d, used %d.");
		add(3651  , 16 , "This transaction has been rolled back, rather than only the current statement.");
		add(3652  , 10 , "Statement: %d Subquery: %d Nesting Level: %d cache size: %d hits: %d misses: %d");
		add(3653  , 20 , "Invalid object coherency block number %d specified");
		add(3654  , 20 , "Invalid object coherency manager command type %d specified");
		add(3656  , 16 , "Cannot open tracefile.");
		add(3657  , 10 , "The target spid %d no longer exists.");
		add(3658  , 10 , "Use SET TRACEFILE OFF to disable the tracing.");
		add(3659  , 16 , "The spid %d does not exist.");
		add(3660  , 16 , "Application tracing is not active on the target spid.");
		add(3661  , 16 , "Cannot close tracefile for the target spid.");
		add(3662  , 16 , "Application tracing rebind is not permitted for the current spid.");
		add(3663  , 16 , "Multiple tracing from the same session is not allowed. To close the earlier tracing or for the necessary clean-up, use 'set tracefile off' command first.");
		add(3664  , 16 , "Only users with SA and SSO roles can run the application tracing for other spids.");
		add(3665  , 16 , "Application tracing is not allowed on system tasks.");
		add(3666  , 20 , "ASE is going to shutdown due to the expiry of license ASE_CORE\n");
		add(3667  , 20 , "ASE is going to shutdown due to the expiry of graced license ASE_CORE\n");
		add(3668  , 17 , "ASE will shutdown, if suitable license is not obtained before the specified expiry period\n");
		add(3669  , 17 , "ASE will shutdown, if suitable license is not obtained before the specified grace period\n");
		add(3670  , 17 , "ASE will shutdown, if suitable license is not obtained before the specified support-grace period\n");
		add(3673  , 10 , "%.*s: logical reads: (regular=%d apf=%d total=%d), physical reads: (regular=%d apf=%d total=%d)");
		add(3674  , 16 , "File %s already exists.");
		add(3675  , 16 , "The pathname length must be %d characters or less.");
		add(3676  , 17 , "Connection has been aborted.");
		add(3677  , 10 , "Statement: %d Compile time resource usage: (est worker processes=%d proccache=%lu), Execution time resource usage: (worker processes=%d auxsdesc=%d plansize=%d proccache=%lu proccache hwm=%lu tempdb hwm=%d)");
		add(3678  , 18 , "%s: Operating system error %d in file %s at line %d.");
		add(3679  , 16 , "Cannot set this command on/off while tracing another session with spid %d");
		add(3681  , 10 , "The asynchronous log service has been disabled for database '%.*s' because the 'user log cache queue size' is not set to '0'.");
		add(3687  , 10 , "Table: %.*s scan count %d, Rows: in-memory=%d, migrated=%d, page-store=%d");
		add(3688  , 10 , "Table: %.*s scan count %d, Sysversions: logical reads: (regular=%d apf=%d total=%d), physical reads: (regular=%d apf=%d total=%d), apf IOs used=%d");
		add(3701  , 11 , "Cannot drop the %S_MSG '%.*s', because it doesn't exist in the system catalogs.");
		add(3702  , 16 , "Cannot drop or replace the %S_MSG '%.*s' because it is currently in use.");
		add(3703  , 11 , "Cannot drop the %S_MSG with object-id %d in database %d, because it doesn't exist in the system catalogs.");
		add(3704  , 16 , "Cannot drop the %S_MSG '%.*s' because you are not the owner or a user with System Administrator (SA) role.");
		add(3705  , 16 , "Cannot use DROP %s with '%.*s' because '%.*s' is a %S_MSG. Use DROP %s.");
		add(3708  , 16 , "Cannot drop the %S_MSG '%.*s' because it is a system %S_MSG.");
		add(3709  , 16 , "Cannot drop '%.*s' because you are not currently in the master database.");
		add(3710  , 16 , "Cannot use DROP or REPLACE with '%.*s' because '%.*s' is a %S_MSG. Use ALTER TABLE.");
		add(3711  , 16 , "Cannot use ALTER TABLE with '%.*s' because '%.*s' is a %S_MSG. Use DROP %s.");
		add(3712  , 16 , "Cannot drop %S_MSG '%.*s' because it still has referential integrity constraints.");
		add(3716  , 16 , "The %S_MSG '%.*s' cannot be dropped because it is bound to one or more %S_MSG.");
		add(3718  , 11 , "Could not drop index '%.*s' because the table/clustered index entry cannot be found in the sysindexes system catalog.");
		add(3723  , 16 , "The table '%.*s' does not have the %S_MSG '%.*s'.  Cannot drop.");
		add(3724  , 16 , "Level of table or object '%.*s' does not match user's curwrite level.  Cannot drop.");
		add(3725  , 16 , "Level of index '%.*s' does not match user's curwrite level.  Cannot drop.");
		add(3726  , 16 , "Level of database '%.*s' does not match user's curwrite level.  Cannot drop.");
		add(3727  , 16 , "Can not drop the database '%.*s' because cursor '%.*s' is still open. Close the cursor(s) before dropping the database.");
		add(3728  , 16 , "Cannot drop this database '%S_DBID' as it has some dependencies (referential constraints) from database '%S_DBID'.  Drop the referencing database first, before dropping the referenced database (dependent database).");
		add(3729  , 20 , "The dropo() function is trying to put too many lock requests in the lock_requests[] array.");
		add(3730  , 16 , "Can not drop index '%.*s' because cursor '%.*s' is open.  Close the cursor(s) before dropping the index.");
		add(3731  , 16 , "Cannot drop table '%.*s' because it is partitioned.");
		add(3732  , 16 , "Cannot %s index '%.*s' because there are one or more isolation level 0 scans, or REORG command, active on table.");
		add(3733  , 10 , "Warning: There is an invalid cross-database reference in the system catalogs. The referenced database '%.*s' does not exist.");
		add(3734  , 10 , "Warning: There is an invalid cross-database reference in the system catalogs. The referencing database '%.*s' does not exist.");
		add(3735  , 10 , "Warning: There is an invalid cross-database reference in the system catalogs. A referenced table, id %d, in database '%.*s' does not exist.");
		add(3736  , 10 , "Warning: There is a missing referential constraint catalog entry in database '%.*s'.");
		add(3738  , 16 , "Drop index error: %S_MSG '%.*s' does not have any indexes. Only tables have indexes.");
		add(3741  , 16 , "Cannot drop object '%.*s' because it is tagged as partitioned (# of slices=%d) although it shouldn't.");
		add(3742  , 11 , "Cannot drop the lightweight procedure '%.*s' because it doesn't exist.");
		add(3743  , 16 , "Can not drop the database '%.*s' because is is a system proxy database. Use the primary server, and drop the primary database.");
		add(3744  , 16 , "Can not drop the database '%.*s' because it is a failed over database.");
		add(3745  , 16 , "Cannot drop the database '%.*s' because it contains one or more Java classes that are being used as datatypes for columns in table '%.*s'. Drop the table before dropping the database.");
		add(3746  , 16 , "Cannot drop table '%.*s' because option '%s' is set in database '%.*s'.");
		add(3748  , 16 , "Stored procedure %.*s is being used as automatic login script.");
		add(3749  , 16 , "Database '%.*s' was incompletely dropped; see preceding error. Either re-run the 'DROP DATABASE' command or run 'DBCC CHECKALLOC' to fix allocation information.");
		add(3750  , 16 , "Unable to drop %S_MSG with object ID %d in database %d, because locks could not be acquired on system tables. Retrying.");
		add(3751  , 0  , "Cannot drop the temporary database '%.*s'. Either the database is a member of a group or there are bindings to this database.");
		add(3752  , 0  , "Cannot drop the temporary database '%.*s'. There are active sessions bound to this database.");
		add(3753  , 16 , "Cannot drop the 'sybsecurity' database because auditing is active. Use sp_configure 'auditing', 0 to disable auditing and retry the command.");
		add(3754  , 16 , "Cannot drop or replace the %S_MSG '%.*s' because it is referenced by a computed column.");
		add(3755  , 16 , "Cross-database encryption key references do not allow execution of '%s' command . See previous error messages.");
		add(3756  , 16 , "You cannot manually drop an index for replication. Either turn off replication on the column, or run DBCC REINDEX.");
		add(3757  , 16 , "A drop index DDL cluster notification error has happened - Drop Index DDL operation on table '%.*s' is rolled back.");
		add(3758  , 21 , "Cannot drop this database because ASE cannot determine its status. Please use DBCC DBREPAIR(%.*s, DROPDB) to drop this database.");
		add(3759  , 16 , "Cannot drop the local temporary database '%.*s' when the cluster instance that owns it is running.");
		add(3760  , 16 , "Cannot drop index '%.*s', as dropping clustered index on virtually hashed tables is not allowed.");
		add(3761  , 16 , "Drop database '%.*s' is aborted because cluster is in failover");
		add(3762  , 18 , "The decrypt_default for column id %d was not found in the system catalogs.");
		add(3765  , 16 , "Unable to drop database because locks could not be acquired on system tables.");
		add(3766  , 16 , "%s failed. Database '%.*s' is used as template database.");
		add(3767  , 16 , "%s failed. The relationship between in-memory database '%.*s' and its template database '%.*s' has not been cleared.");
		add(3768  , 16 , "The DROP %S_MSG '%.*s' failed. Use the OVERRIDE option to bypass consistency checks in unavailable databases.");
		add(3769  , 10 , "Warning: The are some database(s) which is (are) currently not available and cannot be checked for login references. The request to ignore this error may leave users for this login in the database(s).");
		add(3770  , 16 , "The DROP %S_MSG '%.*s' failed. See previous messages for more information.");
		add(3771  , 16 , "Cannot drop the replication filter '%.*s' because it is currently in use by a Replication Agent.");
		add(3772  , 16 , "Cannot drop the single instance database '%.*s' from non-owner node, when the cluster instance that owns it is running.");
		add(3773  , 16 , "Cannot drop the schema '%.*s' because it is not empty. Drop all the objects in the schema before dropping the schema.");
		add(3774  , 16 , "Can't drop with RESTRICT specification: %.*s.");
		add(3775  , 16 , "Unable to drop global temporary table '%.*s' as it is in use");
		add(3778  , 16 , "Cannot drop %S_MSG %S_MSG '%.*s' on table '%.*s' with NOWAIT. Please don't use NOWAIT option.");
		add(3779  , 16 , "Cannot drop index '%.*s' on table '%.*s' with NOWAIT, because store information about objid '%d', indid '%d' failed. Please don't use NOWAIT option.");
		add(3780  , 10 , "The index id %d for object id %d is undergoing drop with NOWAIT option, hence index extents allocations may be inconsistent.");
		add(3781  , 16 , "Cannot drop index '%.*s' on table '%.*s' in %S_MSG database. Please don't use NOWAIT option.");
		add(3782  , 18 , "Internal error: An attempt to delete records from the dump history failed.");
		add(3783  , 10 , "%d records have been deleted from '%s'.");
		add(3784  , 16 , "Cannot execute '%S_MSG' in database '%.*s' while an index is dropped with NOWAIT option. Please retry your command later when no sysattributes rows for class=%d are reported.");
		add(3785  , 16 , "Cannot drop %S_MSG '%.*s' on table '%.*s' using the NOWAIT option.");
		add(3801  , 16 , "There is no host variable corresponding to the one specified by the PARAM datastream. This means that this variable '%.*s' was not used in the preceding DECLARE CURSOR or SQL command.");
		add(3802  , 18 , "There is no cursor information given with the current datstream. A cursor id of zero was specified and no name was specified. The current batch of commands is being aborted. This is an internal error.");
		add(3803  , 16 , "The statement used to define the cursor '%.*s' is neither a SELECT nor an EXECUTE.");
		add(3804  , 16 , "More than one SELECT statement is used to define the cursor '%.*s'.");
		add(3805  , 18 , "The token datastream length was not correct. This is an internal protocol error.");
		add(3806  , 16 , "Both the READ ONLY and the FOR UPDATE options have been specified for cursor '%.*s'.");
		add(3807  , 18 , "The datastream specifies a wrong option or command. The datastream is '%s'. This is an internal error.");
		add(3808  , 18 , "The column is not part of the RESDOM column list. This means the plan for the cursor is corrupted. This is an internal error.");
		add(3809  , 18 , "Unknown datatype token '%d' has been sent to the server. This is an internal error.");
		add(3811  , 18 , "A wrong datastream has been sent to the server. The server was expecting token %d but got the token %d. This is an internal error.");
		add(3812  , 18 , "The datastream for token %d should only be sent after other datastreams. It can not be a command datastream on it's own. This is an internal error.");
		add(3813  , 18 , "A wrong datastream has been sent to the server. The server was expecting a dynamic sql command token but got the token %d. This is an internal error.");
		add(3814  , 16 , "The parameter of type %d did not have a valid value.");
		add(3816  , 18 , "Internal Syslabels manager Error.");
		add(3819  , 16 , "The dynamic PREPARE statement '%.*s' failed because of an internal problem while sending the input parameters formats to the client.");
		add(3820  , 16 , "The datastream length for the '%s' token exceeds the allowable maximum of 65535 bytes. This can happen when Adaptive Server is sending a large number of columns or parameters to a pre-12.5 client or remote server.");
		add(3821  , 16 , "The rpc name '%s' is too long which exceeds the allowable maximum of 255 bytes from remote server.");
		add(3822  , 16 , "The TDS datastream token '%s' is invalid.");
		add(3902  , 13 , "The commit transaction request has no corresponding BEGIN TRANSACTION.");
		add(3903  , 13 , "The rollback transaction request has no corresponding BEGIN TRANSACTION.");
		add(3904  , 0  , "Can't unsplit logical page %u in %S_PTNINFO - both pages together contain more data than will fit on one page.");
		add(3905  , 0  , "Can't unsplit logical page %u in %S_PTNINFO - row number %d is used on both pages.");
		add(3906  , 16 , "Attempt to BEGIN TRANSACTION in database '%S_DBID' failed because database is READ ONLY.");
		add(3907  , 21 , "Failed to receive results from PROBE. The distributed transaction named %.*s has not been committed and data may be inconsistent across databases.");
		add(3908  , 16 , "Attempt to BEGIN TRANSACTION in database '%S_DBID' failed because database is in BYPASS RECOVERY mode.");
		add(3909  , 18 , "While closing a transaction, it was found not to have marked its corresponding database as being kept.");
		add(3913  , 26 , "Attempt to use an inactive internal transaction.  This is an internal system error.");
		add(3914  , 26 , "Illegal internal transaction status.  This is an internal system error.");
		add(3915  , 26 , "Attempt to make a transaction in dbid %d internal.  This is an internal system error.");
		add(3916  , 26 , "Internal transaction lock context chains mixed up.  This is an internal system error.");
		add(3917  , 16 , "An attempt was made to startup a multi-database update in database '%S_DBID' after starting up the master transaction in a temporary database. This could render the database '%S_DBID' unrecoverable and this update is therefore not allowed.");
		add(3921  , 14 , "You cannot start a %s transaction in master, model, or sybsystemdb.");
		add(3922  , 26 , "Attempt to start a sub transaction without a parent transaction. This is an internal system error.");
		add(3923  , 26 , "Attempt to set parallel status on transaction by non-parent thread. This is an internal error.");
		add(3924  , 26 , "Illegal attempt to start sub-transaction by a parent thread. This is an internal error.");
		add(3925  , 26 , "Attempt to set parallel status on transaction that is not in CMD mode. This is an internal error.");
		add(3926  , 26 , "Empty Parent Session Id passed to start a sub transaction. This is an internal system error.");
		add(3927  , 17 , "Could not find an available transaction descriptor. Raise the value of the configuration parameter 'txn to pss ratio'.");
		add(3928  , 16 , "An attempt was made by this thread (spid=%d) to attach to a transaction. This is illegal because this thread is already associated with a transaction. Use systransactions to find out more information.");
		add(3929  , 16 , "An attempt was made by this task (spid=%d) to detach from a transaction. This is illegal because this task is currently not associated with the transaction. Use systransactions table to obtain more information.");
		add(3930  , 20 , "Systransactions system table does not exist in this database. You need to upgrade to the correct version. The command is aborted.");
		add(3931  , 16 , "Transaction Manager API '%.*s' failed. It was invoked with a wrong transaction type '%d'.");
		add(3932  , 16 , "Attempt to begin a multi database transaction failed. It is illegal to begin a subordinate transaction in the master database.");
		add(3933  , 16 , "Attempt to start an external transaction failed. It is illegal to begin an external transaction from within the scope of a local transaction.");
		add(3934  , 16 , "Transaction manager has detected a nesting failure. Number of BEGIN TRAN commands (issued after an attach operation) do not match the number of COMMIT TRAN commands (issued before a detach operation).");
		add(3935  , 20 , "Fatal protocol error. xact_beginupdate() API was invoked in the wrong context. The transaction is currently in '%s' state.");
		add(3936  , 0  , "Heuristic completion of transaction did not succeed. After ensuring that everything is ok, use dbcc forget_xact() command to delete the entry from systransactions system table.");
		add(3938  , 20 , "Fatal protocol error. xact_begin() API was invoked in the wrong context. The distributed transaction is currently in '%s' state.");
		add(3939  , 10 , "Illegal attempt to rollback transaction (xactname '%.*s') that has already committed in database '%.*s', spid %d.");
		add(3940  , 10 , "The MSDTC Service is not enabled. Please consult the errorlog and restart the MSDTC Service.");
		add(3941  , 10 , "The MSDTC Interface %s failed with error 0x%x -- %s.");
		add(3942  , 16 , "Database %s is not allowed to participate in a distributed transaction.");
		add(3943  , 14 , "%s' transactions are not allowed in an HA configuration.");
		add(3944  , 16 , "Attempt to BEGIN TRANSACTION in database '%S_DBID' failed because the database is in standby access mode.");
		add(3945  , 16 , "You cannot begin an external transaction for a server that is in single-user mode.");
		add(3946  , 16 , "Cannot start external transaction without a DTM license.");
		add(3947  , 16 , "A heuristic completion related operation failed. Please see errorlog for more details.");
		add(3948  , 16 , "Cannot execute the command '%s' as the set option 'explicit_transaction_required' is on and no transaction is active.");
		add(3949  , 20 , "An illegal attempt was made to update '%.*s' in database '%S_DBID' using a transaction that was started in database '%S_DBID' (mode: %d, type: %d).");
		add(3950  , 10 , "Your query is blocked because it tried to start a transaction in the 'master' database which is in a quiesced state. Your query will proceed after the DBA performs a QUIESCE/PREPARE DATABASE RELEASE.");
		add(3951  , 10 , "Warning: Post-commit processing for transaction (%d,%d) in database %.*s did not complete.");
		add(3952  , 16 , "Command not allowed. You cannot start a multi-database operation in database '%S_DBID' after starting the master transaction in '%S_DBID' as it may render the database '%S_DBID' unrecoverable.");
		add(3953  , 16 , "Cannot execute the command '%s' (spid '%d') because the external transaction has been rolled back.");
		add(3954  , 10 , "Operating on the table '%.*s', database '%.*s' (owner ID %d) in '%s' logging mode by user ID %d.");
		add(3955  , 10 , "Warning: Cannot perform minimally logged operations in database '%.*s' because the database option '%s' is not enabled. Full logging will be done for these operations.");
		add(3956  , 10 , "Warning: Only fully logged operations of this transaction will be rolled back. Minimally logged operations will not be rolled back.");
		add(3957  , 10 , "New transaction cannot be started due to an ongoing HADR deactivate operation. The command could not be completed.");
		add(3958  , 10 , "Ongoing transactions have been rolled back due to HADR deactivate.");
		add(3959  , 10 , "New transaction cannot be started as Adaptive Server is in 'Inactive' HADR state. The command could not be completed.");
		add(3960  , 16 , "Cannot execute the '%s' command because DML is not permitted on IMRS-enabled tables (suid '%d', objid '%d') in a distributed transaction. The transaction has been rolled back.");
		add(4001  , 11 , "Cannot open default database '%.*s'.");
		add(4002  , 14 , "Login failed.");
		add(4013  , 14 , "Login failed - not a secure ASE.");
		add(4016  , 16 , "Language name in login record '%.*s' is not an official name on this ASE. Using default '%.*s' from syslogins instead.");
		add(4017  , 16 , "Neither language name in login record '%.*s' nor language name in syslogins '%.*s' is an official language name on this ASE. Using server-wide default '%.*s' instead.");
		add(4018  , 16 , "Your default language name from syslogins '%.*s' is not an official language name on this ASE. Using server-wide default '%.*s' instead.");
		add(4019  , 16 , "Default date order '%.*s' for language '%.*s' is invalid.  Using 'mdy' instead.");
		add(4020  , 20 , "While reading characters from the client, the receiving buffer has been detected to be too small.");
		add(4022  , 10 , "The password has expired, but you are still allowed to log in. You must change your password before you can continue. If a login trigger is set, it will not be executed.");
		add(4023  , 10 , "Your password will expire in %s days.");
		add(4024  , 10 , "The packet size (%d) specified at login time is illegal. Legal values are between 512 and %d.");
		add(4025  , 10 , "A serious error was encountered while attempting to increase the packet size specified for spid %d. The Network memory map maybe corrupt. Call Technical Support for further assistance.");
		add(4027  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4028  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4029  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4030  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4031  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4032  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4033  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4034  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4035  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4036  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4037  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4038  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4039  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4040  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4041  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4042  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4043  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4044  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4045  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4046  , 0  , "Reservation for Microsoft Secure SQL Server");
		add(4050  , 11 , "Component Integration Services not enabled or not installed.");
		add(4051  , 14 , "Security Control Layer has not been initialized. Security session cannot be established.");
		add(4052  , 14 , "Failed to allocate data structure for use by the Security Control Layer. Cannot establish a security session.");
		add(4053  , 14 , "Security session setup failed during security session establishment.");
		add(4054  , 14 , "Protocol negotiation failed during security session establishment.");
		add(4055  , 0  , "Unified Login through the underlying security mechanism is required to connect to the ASE.");
		add(4056  , 16 , "Login name %.*s not found. Check and make sure an entry exists in Syslogins.");
		add(4057  , 16 , "Login name %.*s not a user in the current database.");
		add(4058  , 16 , "Login currently under set session authorization. It is required to go back to the original identity before performing another set session authorization.");
		add(4059  , 16 , "Set session authorization requires a target identity. Please specify a valid login name.");
		add(4060  , 16 , "Login name not found for suid %d. Check and make sure an entry exists in Syslogins.");
		add(4061  , 0  , "The ASE is using the default authentication information file for it's authentication information.");
		add(4062  , 10 , "Some of the requested security services are not supported by the underlying security mechanism. Please contact a user with SSO_ROLE.");
		add(4063  , 0  , "Security services being used for this connection are inadequate as per ASE's security configuration requirements. Please contact a user with SSO_ROLE.");
		add(4064  , 16 , "Invalid security service requested.");
		add(4066  , 16 , "Login account %.*s is locked. Please contact a person with SA or SSO role.");
		add(4067  , 14 , "Login failed because an incorrect password was supplied.");
		add(4068  , 14 , "HA Login failed. Session handle not found (sys:%d ses:%d).");
		add(4069  , 14 , "HA Login failed. Session handle issued to different user: '%.*s'.");
		add(4070  , 14 , "HA Login failed. There is no failover in progress.");
		add(4071  , 14 , "HA Login failed. Failover timeout.");
		add(4072  , 14 , "HA Login failed. Failback timeout.");
		add(4073  , 14 , "HA Login failed. Server not in HA primary configuration.");
		add(4074  , 14 , "HA Login failed. Server not in HA secondary configuration.");
		add(4078  , 16 , "Enterprise java bean server is up and running.");
		add(4079  , 16 , "Enterprise java bean server is down.");
		add(4086  , 10 , "Could not execute login script for user %.*s");
		add(4087  , 16 , "Unable to open ejb server property file %s.");
		add(4088  , 16 , "Unable to open the listener property file %s.");
		add(4090  , 10 , "There is no valid license for ASE_EJB hence the EJB Server feature is not enabled.");
		add(4092  , 10 , "The 'enable enterprise java beans' configuration option needs to be set to execute this command.");
		add(4093  , 10 , "SSL Plus security modules loaded successfully. ");
		add(4094  , 10 , "The Enterprise Java Bean feature is not supported on this platform.");
		add(4095  , 14 , "LDAP User Authentication failed with ldap error: '%s'.");
		add(4096  , 10 , "There are not enough user connections available; you are being connected using a temporary administrative connection which will time out after '%d' minutes. Increase the value of the '%s' parameter.");
		add(4097  , 10 , "There is no valid license for ASE_JS hence the Job Scheduler Task feature is not enabled.");
		add(4098  , 10 , "Global login trigger '%.*s' not found.");
		add(4099  , 14 , "Your LDAP password has expired.");
		add(4201  , 17 , "DUMP TRANSACTION for database '%.*s' failed: insufficient memory to allocate backout structure. Raise the value of the configuration parameter 'procedure cache size'.");
		add(4204  , 17 , "Unable to continue logged version of DUMP TRAN. No space left in database; use NO_LOG option or run ALTER DATABASE. Else, an old transaction may be active; see Syslogshold table.");
		add(4205  , 0  , "Syslogs does not exist in its own segment in database '%S_DBID' with segmap '%d' with logical start page number of '%u'. You cannot use DUMP TRANSACTION in this case, use DUMP DATABASE instead.");
		add(4206  , 16 , "You cannot run DUMP TRANsaction WITH NO_LOG inside a user transaction.");
		add(4207  , 16 , "Dump transaction is not allowed because a non-logged operation was performed on the database. Dump your database or use dump transaction with truncate_only until you can dump your database.");
		add(4208  , 16 , "DUMP TRANsaction to a dump device is not allowed while the trunc. log on chkpt. option is enabled.  Disable the option with sp_dboption, then use DUMP DATABASE, before trying again.");
		add(4210  , 16 , "While attempting DUMP TRANsaction WITH NO_TRUNCATE, couldn't find database %.*s.");
		add(4211  , 0  , "Couldn't complete DUMP TRANsaction WITH NO_TRUNCATE on database '%.*s', because the log pointer in sysdatabases (page number %u) is not accurate.");
		add(4212  , 0  , "Page %u in database '%.*s' cannot be used as a truncation page because the page belongs to object ID %d and not to the log. Choose another page.");
		add(4213  , 0  , "Page %u in database '%.*s' cannot be used as a truncation page because the page is not allocated. Choose another page.");
		add(4214  , 0  , "Cannot use page %u in database '%.*s' as the trunc page because the LTM trunc state is not set to TRUNC_VALID. Set LTM trunc state to TRUNC_VALID with DBCC SETTRUNC.");
		add(4215  , 0  , "%s failed in database %.*s: %u not first log page in serially allocated log extent or allocation page. Should be: %u. Previous log record in scan: %u.");
		add(4216  , 0  , "%s failed in database %.*s: unexpected end of log encountered on page %u while scanning for page %u.");
		add(4217  , 26 , "Failure during DUMP TRANSACTION in database '%S_DBID': caller does not possess dump lock.");
		add(4218  , 0  , "Failure during DUMP of database '%.*s': serial log page allocation rules broken. Current page: %u; next page: %u; piece end: %u; end-of-scan: %u.");
		add(4219  , 0  , "DUMP TRANsaction encountered an unexpected end to the log page chain. Last page in log as scanned: %u.");
		add(4220  , 14 , "You must be the DBO of database %.*s or have Operator (OPER) role to run DUMP TRANSACTION.");
		add(4221  , 16 , "DUMP TRANsaction to a dump device is not allowed where a truncate-only transaction dump has been performed after the last DUMP DATABASE.  Use DUMP DATABASE instead.");
		add(4222  , 0  , "DUMP TRANSACTION for database '%S_DBID' failed: log page (%u) is on a data-only segment. This is probably due to an incomplete move of the log to a device separate from the data. Complete the log migration or contact the System Administrator.");
		add(4223  , 18 , "Deadlock occurred in SQL Process %d.");
		add(4224  , 16 , "An interruption occurred in process %d due to USER ATTENTION or connection failure.");
		add(4225  , 16 , "This database has not been dumped since it was created, altered or upgraded or a transaction dump may have been loaded using the UNTIL_TIME clause. You must perform a DUMP DATABASE before you can dump its transaction log.");
		add(4226  , 0  , "Logged DUMP TRANSACTION cannot run in database %.*s, because that databases's log version (%d) disagrees with the ASE's log version (%d); use DUMP TRANSACTION WITH NO_LOG. Versions will agree once ONLINE DATABASE has run.");
		add(4227  , 17 , "No space left in database master; creating user objects in master database not recommended. Else, an old transaction may be active; see Syslogshold table.");
		add(4228  , 17 , "No space left in database '%S_DBID'; Use ALTER DATABASE to increase size of database. Else, an old transaction may be active; see Syslogshold table.");
		add(4233  , 19 , "%s failed in database %.*s: Unable to find quiescent point in the log. Log backward scan start marker (%d, %d) and end marker (%d, %d).");
		add(4234  , 0  , "%s failed on database %.*s: Unable to get the secondary truncation page %u.");
		add(4235  , 20 , "%s failed in database %.*s: Bad quiescent point was found.");
		add(4236  , 10 , "%s for database '%.*s' could not truncate the log. Either extend the log using ALTER DATABASE ... LOG ON command or eliminate the oldest active transaction in database '%.*s' shown in syslogshold table.");
		add(4237  , 16 , "Cannot dump %s database's log as distributed transaction resolution is not complete yet. Please retry later.");
		add(4238  , 10 , "DUMP TRANSACTION is not supported on the temporary database '%.*s'.");
		add(4239  , 17 , "DUMP TRANsaction failed because of the error: %s.");
		add(4240  , 18 , "Adaptive Server cannot truncate the log because it was unable to determine the start of the active portion of the log in the database '%.*s' on instance '%d'.");
		add(4241  , 18 , "DUMP TRANSACTION WITH NO_LOG of the database '%.*s' cannot be performed because this session is already using the log. Retry the command at a later time.");
		add(4242  , 10 , "Warning: DUMP TRANSACTION WITH NO_LOG on database '%.*s', instance '%d' was unable to save information about free log space in the database. This will be saved when the next checkpoint is done.");
		add(4243  , 16 , "The command %s is not allowed in database '%.*s' while the 'enforce dump tran sequence' database option is enabled. Use sp_dboption to disable the option, then retry your command.");
		add(4244  , 10 , "WARNING: The transaction log for database '%.*s' (dbid %d) can no longer be dumped due to user '%.*s' (suid %d) executing %s.");
		add(4245  , 16 , "DUMP TRANSACTION in database '%.*s' failed after the database has been marked suspect due to a fatal error during rollback of a transaction. The failure is because DUMP TRAN is not able to find the XREC_BEGINXACT marker for this failed transaction.");
		add(4246  , 16 , "Warning: You cannot run DUMP TRANSACTION WITH NO_LOG for a database that is in bypass recovery mode because this can cause data inconsistency. Use the command 'dump tran %.*s with no_log, force_key=%d' to bypass this restriction.");
		add(4301  , 16 , "Database in use.  A user with System Administrator (SA) role must have exclusive use of DB to load transaction.");
		add(4302  , 16 , "Specified file '%.*s' is not in valid dump transaction format.");
		add(4305  , 16 , "Specified file '%.*s' is out of sequence. Current time stamp is %S_DATE_LONG while dump was from %S_DATE_LONG.");
		add(4306  , 16 , "There was activity on database since last load, unable to load. Must restart load sequence with the load database to continue.");
		add(4312  , 14 , "You must be the DBO of database %.*s or have Operator (OPER) role to run LOAD TRANSACTION.");
		add(4313  , 20 , "Recreate index failed for table %d, index %d. The table has been left in an inconsistent state, and the index is missing, so LOAD TRANSACTION errors may result. Run DBCC CHECKTABLE on the table if LOAD TRANSACTION succeeds.");
		add(4314  , 20 , "Cannot find table %d to recreate index %d.");
		add(4315  , 20 , "Log scan for recreate index failed.");
		add(4316  , 16 , "Can only LOAD TRANsaction in master if ASE is in single-user mode.");
		add(4317  , 0  , "Could not read log page %u for database '%*s'; the DBINFO structure for this database is invalid, or the page chain is corrupt. Cannot proceed with LOAD TRANSACTION.");
		add(4318  , 0  , "Last log page 'next free byte' value is out of range: %d; should be no greater than %d.");
		add(4319  , 21 , "Failed to patch the transaction log for database '%.*s'.");
		add(4320  , 16 , "Dump or load commands require a logical dump device name from the sysdevices system table.  Use sp_addumpdevice to add '%.*s' to sysdevices.");
		add(4321  , 0  , "ASE can not load this transaction log dump because version information in the dump does not match information in the database. Database: log version=%d, upgrade version=%d. Dump: log version=%d, upgrade version=%d.");
		add(4322  , 0  , "ASE cannot load a dump of the master database that was dumped from an older version of ASE. The current master database upgrade version is %d, the dump master database upgrade version is %d.");
		add(4323  , 16 , "The specified RID (%d,%d) was not found in the transaction log.");
		add(4324  , 20 , "The transaction log could not be opened for point in time recovery.");
		add(4325  , 16 , "The specified recovery date (%S_DATE_LONG) is not between the start (%S_DATE_LONG) and end (%S_DATE_LONG) date.");
		add(4327  , 10 , "A load transaction to a point in time will reset the transaction log sequence. A database dump is required to restart the log sequence.");
		add(4328  , 10 , "An early end-of-log has been forced in database '%.*s' prior to the end of the loaded transaction log. The load sequence has been broken. Another LOAD TRANSACTION cannot be performed without a preceding LOAD DATABASE.");
		add(4329  , 10 , "The end of this transaction dump (%d, %d) was earlier than the current last log marker in the database (%d, %d) so the only effect of this LOAD TRANSACTION command was to enable the load of the subsequent transaction dump.");
		add(4330  , 10 , "ONLINE DATABASE FOR STANDBY_ACCESS cannot be performed on database '%.*s' until a subsequent standby_access transaction dump has been loaded.");
		add(4331  , 16 , "Cannot load transaction log for database '%.*s' because cluster is in failover");
		add(4332  , 16 , "Cannot LOAD TRANSACTION WITH UNTIL_TIME because transaction dump was made with NO_TRUNCATE.");
		add(4334  , 16 , "Specified file is out of sequence. The timestamp in this dump '%04x %08x' is smaller than or equal to the database %s dump timestamp '%04x %08x'.");
		add(4335  , 16 , "Specified sybdumptran dump is out of sequence. The first page in this dump '%u' does not match the truncation page of the previous dump '%u'.");
		add(4336  , 16 , "LOAD DATABASE across platforms is not allowed for encrypted database.");
		add(4337  , 16 , "The '%s' command across platforms is not allowed.");
		add(4338  , 16 , "Database '%.*s' cannot be brought online by spid '%d' because it appears to be in the process of being onlined by another session already.");
		add(4339  , 20 , "Unable to link imrslog fragments. This is an internal error. Please contact SAP technical support.");
		add(4340  , 16 , "The imrslog fragments in the target database and the dump do not match, but a remapping cannot be done because, either trace flag 3103 is enabled, or the log in the dump or the target is not segregated. Correct the problem and retry the load");
		add(4341  , 16 , "Cannot load the database '%.*s' because the row storage cache doesn't exist. Please, create a row storage cache with at least %u MB and retry the command.");
		add(4342  , 16 , "Cannot load the database '%.*s' because the row storage cache high watermark size %u KB is smaller than the database dump cache size %u KB. Please, increase the cache size and retry.");
		add(4343  , 22 , "An error occured when converting the row offset table in the page %u of object ID %d. Either the number of rows, %u, or the free offset in the page, %u, is incorrect. The conversion will be skipped. Please, contact SAP product support.");
		add(4344  , 16 , "The '%s' command across platforms on databases with imrslog is not allowed.");
		add(4345  , 18 , "The full logging mode in database '%S_DBID' could not be restored because there was an error when trying to update the table SYSATTRIBUTES in the master database.");
		add(4346  , 16 , "ASE cannot load a delta transaction log onto a database that is logically smaller (%u physical pages, %u logical pages) than the source database(%u physical pages, %u logical pages). Recreate the database '%.*s' with at least %d physical log pages.");
		add(4347  , 10 , "The dump history file '%s' is being updated from version '%s' to version '%s'. The previous file will be renamed as '%s'.");
		add(4348  , 18 , "The upgrade of the dump history file '%s' from version '%s' to version '%s' has failed. Please retry using the command sp_dump_history 'upgrade'.");
		add(4349  , 16 , "The configuration option '%s' has been disabled.");
		add(4350  , 22 , "The data chain for object '%s' with ID %d could not be backed up although the %s command has completed. Contact SAP Technical Support for assistance.");
		add(4401  , 16 , "View '%.*s' no longer exists.");
		add(4402  , 16 , "Infinite loop in view definition.  Cannot resolve the view definitions in the query to the underlying tables.");
		add(4403  , 16 , "View '%.*s' is not updatable because it contains external aggregates , or group by clauses , or internal aggregates . Internal aggregates may be generated by certain subqueries .");
		add(4404  , 16 , "View '%.*s' is not updatable because either the view definition contains DISTINCT or the view is built upon a view created with DISTINCT option.");
		add(4405  , 16 , "View '%.*s' is not updatable because the FROM clause names multiple tables.");
		add(4406  , 16 , "View '%.*s' is not updatable because a field of the view is derived or constant.");
		add(4408  , 16 , "The query and the views (or predicates) in it exceed the limit of %d tables.");
		add(4409  , 20 , "The columns in the query definition and the view definition do not match.");
		add(4411  , 16 , "View '%.*s' does not allow this UPDATE because either it was created WITH CHECK OPTION or it spans another view created WITH CHECK OPTION, and one of the update columns appears in a multi-table expression in the WHERE clause of a CHECK OPTION view.");
		add(4412  , 16 , "View '%.*s's definition contains '%.*s', which is a temporary object.  Views can only be based on permanent objects.");
		add(4413  , 16 , "View resolution could not succeed because the previously mentioned objects, upon which the view '%.*s' directly or indirectly relies, do not currently exist. These objects need to be recreated for the view to be usable.");
		add(4414  , 16 , "View '%.*s' does not allow INSERT because it is derived from more than one object and it was either created WITH CHECK OPTION or it spans another view created WITH CHECK OPTION.");
		add(4415  , 18 , "Internal system error:  corrupt sequence tree encountered while processing the DISTINCT view '%.*s'.  Notify a user with System Administrator (SA) role.");
		add(4416  , 19 , "Could not allocate a work table while processing views (or derived tables). The total number of work tables generated by the query exceeds the limit (%d) of work tables. Simplify the query or the views (or derived tables) referenced in the query.");
		add(4417  , 16 , "The view (or derived table) '%.*s' has one or more tables with any of the keywords HOLDLOCK/NOHOLDLOCK that conflicts with the query to be run AT ISOLATION 0.");
		add(4418  , 16 , "Query has too many subqueries when all views (or derived tables or predicates) are taken into account. Error found on view (or derived table or predicate) '%.*s'. The limit is %d subqueries.");
		add(4420  , 16 , "View '%.*s' is not updatable, possibly due to an outer join being in the view, or due to a subquery being in the select list of the view.");
		add(4422  , 16 , "View '%.*s' cannot be updated since no underlying tables are referenced.");
		add(4423  , 16 , "View '%.*s' cannot be updated since view is the inner table of an outer join.");
		add(4424  , 16 , "View '%.*s' contains a table being updated, and this table is referenced elsewhere in the query which is not allowed if create view WITH CHECK OPTION is used.");
		add(4425  , 16 , "View '%.*s' cannot have WITH CHECK OPTION applied since it contains subqueries.");
		add(4426  , 16 , "This query cannot be processed because it contains TEXT, IMAGE, UNITEXT or off-row Java columns and references a view defined with a subquery, an outer join, or a distinct clause.");
		add(4427  , 16 , "View '%.*s' cannot be updated since the view definition contains a UNION operator.");
		add(4428  , 20 , "Column(s) '%.*s' in the outer query do not appear in the derived table expression.");
		add(4429  , 16 , "View '%.*s' cannot be resolved since the view contains a derived table which is not supported in this release.");
		add(4430  , 0  , "The number of tables including the derived tables in the query exceeded the limit of %d tables.");
		add(4431  , 16 , "View '%.*s' is not updatable because a field of the view is XMLTABLE.");
		add(4432  , 16 , "The number of outer joins in the query has exceeded the %d limit.");
		add(4501  , 16 , "View '%.*s' has more columns defined than column names given.");
		add(4502  , 16 , "View '%.*s' has more column names specified than columns defined.");
		add(4503  , 20 , "The create view tree has a resdom with no right hand side. View '%.*s', resdom '%.*s'.");
		add(4504  , 16 , "CREATE TABLE failed because there was not enough space to allocate memory for the table.");
		add(4505  , 16 , "CREATE VIEW failed because column '%.*s' in view '%.*s' exceeds the maximum of %d columns.");
		add(4506  , 16 , "Column names in each view must be unique. Column name '%.*s' in view '%.*s' is specified more than once.");
		add(4507  , 16 , "Column '%.*s' specifies storage type %d, which does not currently exist.");
		add(4508  , 16 , "Views are not allowed on temporary tables. Table names that begin with '#' denote temporary tables.");
		add(4509  , 16 , "Column names in each view must be unique.  An unnamed column is specified more than once in view '%.*s'.");
		add(4511  , 16 , "CREATE PARTITION VIEW failed to create view '%.*s'. Recheck the definition of the view.");
		add(4512  , 16 , "Definition of a CREATE PARTITION VIEW has either zero or more than one table in its definition for a given side of the UNION node in the view");
		add(4513  , 16 , "Nesting of views not allowed inside the definition of a create partitioned view.");
		add(4514  , 16 , "Subqueries are not allowed in the definition of a partitioned view");
		add(4515  , 16 , "Aggregates are not allowed inside the definition of a partitioned view");
		add(4516  , 16 , "No qualification predicates of any kind are allowed inside the definition of a partitioned view. The view definition must correspond to select .. from table1 union all select .. from table2 [union all select .. from table3..]");
		add(4517  , 16 , "Check constraint definition for a partitioned view is eithe missing or the user tables could not be opened to read the constraint definition");
		add(4518  , 16 , "The check constraint definition for the partitioned view does not conform to a range partitioning as expected");
		add(4519  , 16 , "Queries involving partitioned views can only be accessed in parallel mode. Please reconfigure the server for parallelism and re-run your query.");
		add(4520  , 16 , "Partition key for a partitioned view cannot be updated because rows could migrate to other partitions. This is not supported in this version of ASE.");
		add(4521  , 16 , "Adaptive Server failed to allocate memory for a system-wide datatype dictionary cache. The requested size was %d bytes, with a minimum permitted allocation of %d bytes.");
		add(4522  , 17 , "Adaptive Server failed to allocate %d bytes of memory for a column default dictionary entry. Without this memory, the table cannot be used.");
		add(4523  , 16 , "Columns of type '%s' may not be declared as %s.");
		add(4601  , 14 , "This permission can only be GRANTed or REVOKEd by owner '%.*s' of object '%S_OBJID', or by a user with GRANTable privileges in database '%S_DBID'");
		add(4602  , 14 , "Permission denied.  Only users with System Administrator (SA) role can GRANT/REVOKE CREATE DATABASE permission.");
		add(4603  , 14 , "Only owner of current database may GRANT/REVOKE this permission.");
		add(4604  , 16 , "There is no such user %.*s.");
		add(4606  , 16 , "GRANTed/REVOKEd privilege %s not compatible with object.");
		add(4607  , 16 , "Privilege %s may not be GRANTed or REVOKEd.");
		add(4608  , 16 , "Only users with System Administrator (SA) role can GRANT/REVOKE ALTER DATABASE permission, and only to/from users with CREATE DATABASE permission.");
		add(4609  , 16 , "You cannot specify a column list for permission '%s'.");
		add(4610  , 16 , "You may only GRANT or REVOKE permission on objects in the current database.");
		add(4611  , 16 , "The user '%.*s' has granted this privilege to other users. You must use REVOKE WITH CASCADE to revoke privileges for '%.*s' as well as the other users.");
		add(4612  , 16 , "Too many users to revoke privileges from,due to cascading GRANT WITH GRANT. To continue, use REVOKE WITH CASCADE on user '%.*s'.");
		add(4613  , 16 , "WITH GRANT OPTION does not apply to groups, roles, and grants with predicates.");
		add(4614  , 16 , "Column list may be specified either with the privileges or with the table. It cannot be specified in both places.");
		add(4615  , 16 , "Permissions may not be revoked from either the DBO or the object owner.");
		add(4616  , 16 , "Public has been granted permission on the object with the  grant option. Please revoke the GRANT WITH GRANT option from public before revoking from any user/group.");
		add(4617  , 16 , "Public has GRANT WITH GRANT permission on at least one of the columns you are trying to revoke. Please revoke the GRANT WITH GRANT option from public before revoking from the users/groups.");
		add(4618  , 16 , "The user's curwrite must be at the security label of an object in order for that user to grant/revoke access to that object.");
		add(4619  , 16 , "The user's curwrite must be at Data Low in order to grant/revoke create database permission.");
		add(4620  , 16 , "The user must be in the master database in order to grant/revoke server-wide privilege '%s'.");
		add(4621  , 10 , "Warning. All permissions except CREATE DATABASE are granted/revoked. Only System Administrator can grant/revoke CREATE DATABASE permission.");
		add(4622  , 10 , "Some or all of the specified privileges were not revoked because, they were not granted, or they were granted by some other user.");
		add(4623  , 18 , "Error encountered while retrieving column information.  Aborting grant/revoke command.");
		add(4624  , 16 , "The user must be in the master database in order to grant/revoke connect access.");
		add(4625  , 16 , "The user must be in the master database in order to grant/revoke set session authorization access.");
		add(4626  , 16 , "DBCC command '%s' cannot be assigned at the database-level.");
		add(4627  , 16 , "The user must be in the %.*s database to GRANT/REVOKE this command.");
		add(4628  , 16 , "GRANT/REVOKE DBCC does not apply to groups or PUBLIC.");
		add(4629  , 16 , "DBCC command '%s' is a database-level command and ON <database | ALL> is mandatory.");
		add(4630  , 16 , "You must be in the the default database for the user '%.*s' (the '%S_DBID' database) in order to GRANT or REVOKE builtin access.");
		add(4631  , 16 , "Role activation predicates are not allowed on role-to-role grants.");
		add(4632  , 16 , "The user must be in the master database in order to grant/revoke SET TRACING permission for access to SET PLAN FOR SHOW..., SET OPTION ..., and DBCC TRACEON/TRACEOFF(3604,3605)");
		add(4633  , 16 , "This permission on object '%S_OBJID' can only be granted or revoked by users with '%.*s', or by a user with grantable privileges in database '%S_DBID'.");
		add(4636  , 16 , "Cannot specify a predicated grant on a built-in.");
		add(4637  , 16 , "Predicated grants are allowed only for select, delete and update actions.");
		add(4638  , 16 , "Correlation names are allowed only for predicated grants.");
		add(4639  , 16 , "You must be a valid user in the master database to specify an activation predicate on the grant role statement.");
		add(4641  , 16 , "GRANT/REMOVE ALL does not apply to non-object permissions when 'enable granular permissions' is ON.");
		add(4642  , 14 , "You cannot directly call the rm_predicate built-in function. Use sp_changegroup to remove a predicate.");
		add(4643  , 16 , "Failed to %s predicate on table %s.");
		add(4644  , 16 , "Do not mix roles and users/groups when using grant/revoke while replicating from the master database.");
		add(4645  , 16 , "Select permission cannot be granted or revoked on built-in function %.*s.");
		add(4646  , 16 , "You must be in the master database to grant a role with an activation predicate");
		add(4647  , 16 , "Operation failed. There must be at least one unlocked login with privilege MANAGE SECRUITY PERMISSIONS and at least one unlocked login with privilege MANAGE SERVER PERMISSIONS after this operation.");
		add(4648  , 16 , "Privilege %s may not be DENYed or ALLOWed.");
		add(4649  , 14 , "The permission can only be DENYed or ALLOWed by a user with privilege MANAGE ANY OBJECT PERMISSION.");
		add(4650  , 10 , "Number of roles granted to user with suid '%d' exceeds the permissible limit of '%d'. Ignoring some of the roles granted to the user. There may be corruption in system catalog sysloginroles. Please contact a user with System Administrator (SA) role.");
		add(4701  , 11 , "Cannot truncate table '%.*s', because this table does not exist in database '%S_DBID'.");
		add(4706  , 17 , "Could not truncate table '%.*s' because there is not enough room in the log to record the deallocation of all of the index and data pages.");
		add(4708  , 16 , "Could not truncate object '%.*s' because it is not a table.");
		add(4709  , 16 , "You are not allowed to truncate the system table '%.*s'.");
		add(4710  , 16 , "Cannot truncate table '%.*s' because you are not the owner or a user with System Administrator (SA) role.");
		add(4711  , 14 , "Permission denied.  @@curread does not dominate the maxhold of table '%.*s'.");
		add(4712  , 14 , "Permission denied.  @@maxwrite does not dominate the maxhold of table '%.*s'.");
		add(4713  , 14 , "Permission denied.  The minhold of table '%.*s' does not dominate @@minwrite.");
		add(4714  , 14 , "Permission denied.  Only users possessing the SSO role can truncate the audit log.");
		add(4715  , 14 , "Permission denied.  The hurdle of table '%.*s' does not equal @@curwrite.");
		add(4716  , 16 , "Cannot truncate table '%.*s' because it is partitioned.");
		add(4717  , 16 , "Could not truncate table '%.*s' because there are referential constraints defined on it and there are data rows in some of the referencing tables.");
		add(4718  , 17 , "Failed to write the TRUNCTAB log record for the execution of truncation of table '%.*s' in database '%S_DBID'. The 'truncate table' command is aborted.");
		add(4719  , 20 , "TRUNCATE TABLE aborted due to an internal error. Failed to obtain the owner name information associated with object ID %d in database '%S_DBID'. Please contact SAP Technical Support.");
		add(4720  , 16 , "Cannot truncate table '%.*s' because there are one or more isolation level 0 scans, or REORG command, active on the table.");
		add(4721  , 16 , "Cannot truncate table '%.*s' because option '%s' is set in database '%.*s'.");
		add(4722  , 16 , "Cannot truncate partition '%.*s' of table '%.*s' because the specified partition was not found.");
		add(4723  , 16 , "Cannot truncate table '%.*s', as truncating virtually hashed tables is not allowed. Use DELETE to delete all the rows from table.");
		add(4724  , 16 , "Cannot truncate '%.*s' because it is not a %S_MSG.");
		add(4725  , 20 , "Cannot truncate partition '%.*s' of table '%.*s' because this command is not allowed when replication is enabled on a hash or round-robin partitioned table.");
		add(4801  , 20 , "Bulk_main: opentable on BULK INSERT table failed. Dbid=%d name='%.*s'.");
		add(4802  , 21 , "Bulk_main: getindex of primary index row failed on BULK INSERT table.");
		add(4804  , 21 , "Premature end-of-message while reading current row from host. Host program may have died.");
		add(4805  , 17 , "The front end tool you are using does not support the feature of bulk insert from host, please use the proper tools for this command.");
		add(4806  , 16 , "You cannot run the non-logged version of bulk copy in this database. Please check with the DBO.");
		add(4808  , 10 , "The bulk copy of this table has been aborted because the CHECKPOINT record could not be written in the log. Please free up space in the database.");
		add(4809  , 20 , "Unable to open SYSCOLUMNS in dbid %d to retrieve table schema information.");
		add(4810  , 16 , "Expected TEXT token in data stream for bulk copy of text data.");
		add(4811  , 16 , "Expected column offset in data stream for bulk copy of text data.");
		add(4812  , 16 , "Expected row offset in data stream for bulk copy of text data.");
		add(4813  , 16 , "Expected text length in data stream for bulk copy of text data.");
		add(4814  , 20 , "Bulk_getschema: Unable to open the system catalog SYSCOLUMNS in database '%.*s' while attempting to retrieve table schema information. Run DBCC CHECKTABLE on sysobjects in '%.*s'.");
		add(4818  , 11 , "Error encountered while retrieving table schema information for object '%.*s' in database '%.*s'. Re-check the schema for the table.");
		add(4819  , 16 , "You cannot BCP into the sysaudits table.");
		add(4820  , 16 , "Illegal identity value specified for identity column in table '%.*s' through BCP.");
		add(4821  , 16 , "Identity value overflow while inserting into table '%.*s' through BCP.");
		add(4822  , 14 , "You do not have the role required to run bcp in with the labelled option.");
		add(4823  , 16 , "Sensitivity label out of range for some row(s).");
		add(4824  , 16 , "Invalid sensitivity label for some row(s).");
		add(4825  , 16 , "Some row(s) not copied.");
		add(4826  , 16 , "Expected sensitivity label length in data stream for bulk copy of sensitivity label data.");
		add(4827  , 16 , "Expected row offset in data stream for bulk copy of sensitivity label data.");
		add(4828  , 16 , "Expected sensitivity label data in data stream for bulk copy of sensitivity label data.");
		add(4829  , 16 , "Attempt to copy in row sensitivity labels without using bulk copy labelled option. Labels will be overwritten.");
		add(4830  , 16 , "The labelled option was specified, but row sensitivity labels were not passed in.");
		add(4831  , 16 , "Expected TEXT or SENSITIVITY token in data stream for bulk copy of text or sensitivity label data.");
		add(4832  , 16 , "You cannot use a pre-10.0 client to bulk copy into a Secure ASE.");
		add(4833  , 16 , "Expected text data in data stream for bulk copy.");
		add(4834  , 17 , "Bulk copy failed due to insufficient ASE memory. Please retry later when there is less load/users on the ASE, or ask your System Administrator to reconfigure ASE with more memory.");
		add(4835  , 18 , "Failed to update the identity pre-burn factor for table '%.*s' through BCP. Please re-try the operation or contact your SA for details.");
		add(4836  , 18 , "Error occurred while creating the identity value for table '%.*s' through BCP. Please re-try the operation or contact your SA for details.");
		add(4837  , 16 , "Bad row data received from the client while bulk copying into object %d partition %d in database %d. Received a row of length %d whilst maximum or expected row length is %d.");
		add(4838  , 16 , "You cannot BCP into a view.");
		add(4839  , 18 , "Server has encountered badly formatted rows from bulk copy. Could not locate the row position reserved for the insertion of the identity value.");
		add(4840  , 16 , "Bulk copy failed. You cannot specify a partition ID when doing BCP into table '%.*s' because it has a clustered index.");
		add(4841  , 16 , "Bulk copy failed. Partition number %d does not exist in table '%.*s'.");
		add(4842  , 16 , "Bulk copy failed. Partition number %d was specified for table '%.*s', but that table is not partitioned.");
		add(4843  , 10 , "Slow bulk copy is being used because table '%.*s' has triggers or indexes.");
		add(4844  , 16 , "Bulk copy failed. Identity start value %S_NUME was specified for table '%.*s', but that table does not have an identity column.");
		add(4845  , 16 , "Bulk copy failed. Client does not have the capability to bulk copy into the data-only locked table '%.*s'.");
		add(4846  , 20 , "Bulk copy failed. Error occurred while updating the last page of the table.");
		add(4847  , 16 , "BCP insert operation is disabled when data size is changing between client and server character sets. Please use BCP's -Y option to invoke client-side conversion.");
		add(4848  , 16 , "Bulk copy failed. Table '%.*s' is not a round robin partitioned table.");
		add(4849  , 16 , "Bulk copy failed. Some rows do not belong to partition '%.*s' of table '%.*s'.");
		add(4850  , 16 , "Bulk copy failed. Partition name '%.*s' does not exist in table '%.*s'.");
		add(4851  , 16 , "BULK COPY IN failed. One or more rows do not belong to any partition of table '%.*s'.");
		add(4852  , 10 , "Performing slow bcp on table '%s'. To enable fast bcp please turn on 'select into/bulkcopy' option on the database '%s'.");
		add(4853  , 16 , "Server has encountered badly formatted rows during bulk insert. The bulk client may be too old to format rows properly for this server version.");
		add(4854  , 16 , "Failed to start bulk insert on table '%.*s' because there are one or more active scans using snapshot isolation level. Please retry later.");
		add(4901  , 16 , "ALTER TABLE only allows columns to be added which can contain nulls.  Column '%.*s' cannot be added to table '%.*s' because it does not allow nulls.");
		add(4902  , 11 , "Cannot alter table '%.*s', because this table does not exist in database '%S_DBID'.");
		add(4905  , 0  , "ALTER TABLE failed because page %u of the system catalog sysindexes in database '%.*s' is not in the cache.");
		add(4906  , 16 , "Cannot alter '%.*s' because it is not a %S_MSG.");
		add(4909  , 16 , "Can't alter %.*s because it is not a table.");
		add(4910  , 16 , "Cannot alter table '%.*s' because you are not the owner or a user with System Administrator (SA) role.");
		add(4912  , 16 , "Cannot replace default to '%.*s.%.*s' because it already has a default bound using sp_bindefault.");
		add(4913  , 16 , "Alter table command has unrecognized action. Cannot process.");
		add(4914  , 16 , "Cannot alter table '%.*s' because the alter table statement contains multiple identity fields.");
		add(4915  , 16 , "Cannot add new identity field to '%.*s' via alter table because the table already contains an identity field.");
		add(4916  , 0  , "Cannot add new identity field to '%.*s' via alter table because the number of existing rows (%d) exceeds the maximum value for the specified precision (%d).");
		add(4917  , 20 , "Failure adding identity column '%.*s' to table '%.*s'.");
		add(4918  , 16 , "Row length (%d) exceeds maximum row length (%d) when adding identity column '%.*s' to table '%.*s'.");
		add(4919  , 16 , "Identity value overflow when adding column '%.*s' to table '%.*s'.");
		add(4920  , 16 , "Permission denied.  A table can only be altered if the table's hurdle equals the user's curwrite.");
		add(4921  , 14 , "Permission denied.  A table's labels cannot be altered while it is in use.");
		add(4922  , 14 , "Invalid hold label specified.");
		add(4923  , 14 , "Permission denied.  A table's maxhold should always dominate its minhold.");
		add(4924  , 14 , "Permission denied.  A table's maxhold should always be dominated by the maxhold of the database that contains it.");
		add(4925  , 14 , "Permission denied.  User maxwrite does not dominate specified maxhold.");
		add(4926  , 14 , "Permission denied. User minhold does not dominate specified minwrite.");
		add(4927  , 14 , "Permission denied.  Maxhold label specified is below previous table maxhold.");
		add(4928  , 14 , "Permission denied.  Minhold label specified is above previous table minhold.");
		add(4929  , 14 , "Permission denied.  User minwrite is not dominated by specified maxhold.");
		add(4930  , 14 , "Permission denied.  User maxwrite does not dominate specified minhold.");
		add(4931  , 16 , "Cannot alter the table '%.*s' because it is a system table.");
		add(4932  , 16 , "Dropping a column from a system table is not allowed.");
		add(4933  , 16 , "Dropping a column from a replicated table is not allowed.");
		add(4934  , 16 , "A column by this name doesn't exist in the table '%.*s'.");
		add(4935  , 16 , "Dropping the only column in a table is not allowed.");
		add(4936  , 0  , "Dropping the column failed while reformatting data on page %u, row %d. This command is being rolled back.");
		add(4937  , 17 , "Deleting text pages failed. This command is being rolled back.");
		add(4938  , 20 , "Cannot undo a drop column command because the number of rows on the log record does not match the number of rows on the data page.");
		add(4939  , 16 , "ALTER TABLE '%.*s' failed. You cannot drop column '%.*s' because it is being used by an index. Drop the index '%.*s' before dropping this column.");
		add(4940  , 16 , "ALTER TABLE failed. Dropping an identity column is not allowed.");
		add(4941  , 16 , "ALTER TABLE '%.*s' failed. You cannot drop a column on which constraints are defined. Drop the constraints before dropping this column.");
		add(4942  , 0  , "ALTER TABLE '%.*s' failed. You cannot drop column '%.*s' which has a default bound to it. Unbind the default (object id '%d') before dropping this column.");
		add(4943  , 0  , "Dropping a column which is a primary key is not allowed. Drop the constraint (object id '%d') before dropping this column.");
		add(4944  , 0  , "Dropping a column which is a foreign key is not allowed. Drop the constraint (object id '%d') before dropping this column.");
		add(4945  , 16 , "Cannot drop the column because cursor '%.*s' is still open. Close the cursor(s) before dropping the column.");
		add(4946  , 0  , "Dropping a column from a table which has a constraint associated with it is not allowed. Drop the constraint (object id '%d') before dropping this column.");
		add(4947  , 16 , "Dropping an identity column from a table while identity_insert is 'on' is not allowed. Set identity_insert to 'off' before dropping this column.");
		add(4948  , 0  , "Dropping the column failed while logging data from page %u. This command is being rolled back.");
		add(4949  , 20 , "The alttab_begin() function is trying to put too many lock requests in the lock_requests[] array.");
		add(4950  , 16 , "Cannot partition table '%.*s' because it is a system table.");
		add(4951  , 16 , "Cannot create %d partitions on the table '%.*s' with clustered index because the maximum number of partitions allowed on a table with clustered index is %d.");
		add(4952  , 16 , "Column compression modification is not applicable to columns of not compressible datatype.");
		add(4953  , 16 , "Cannot partition table '%.*s' because the command is only supported on unpartitioned roundrobin tables. Please use the ALTER TABLE ... PARTITION BY command to repartition the table.");
		add(4954  , 16 , "Cannot unpartition table '%.*s' because it is not partitioned.");
		add(4955  , 16 , "Number of partitions must be greater than one");
		add(4956  , 16 , "Cannot alter table if REORG command or level 0 scans are active.");
		add(4957  , 16 , "Column compression modification is not applicable to table that was not created as compressed or that does not have any compressed partitions.");
		add(4958  , 16 , "Cannot partition table '%.*s' because it is in a pre-System 11 database.");
		add(4960  , 16 , "Lock scheme currently on the table '%.*s' is corrupted. For this version of ASE it should have been set properly.");
		add(4961  , 16 , "Cannot partition table '%.*s' because it has been partitioned and unpartitioned too many times.");
		add(4962  , 16 , "To partition: bcp the data out of the table, drop and recreate the table, and then bcp into a partitioned/unpartitioned table.");
		add(4963  , 16 , "Table '%.*s' is already locked in the desired locking scheme.");
		add(4964  , 17 , "Lock scheme conversion failed due to insufficient ASE memory. Please retry later when there is less load/users on the ASE, or ask your System Administrator to reconfigure ASE with more memory.");
		add(4965  , 16 , "Lock scheme conversion on system tables not supported.");
		add(4966  , 10 , "Warning: Table '%.*s' with a clustered index has been partitioned. All data rows are in the first partition and all data insertions will go to the first partition. To distribute the data to all the partitions, re-create the clustered index.");
		add(4967  , 16 , "Cannot execute '%.*s' command on table '%.*s', because this table does not exist in database '%S_DBID'.");
		add(4968  , 16 , "The table '%.*s' you've specified is a system table. Executing the '%.*s' command is not permitted on system tables.");
		add(4969  , 16 , "The table '%.*s' you've specified is a temporary table. Executing the '%.*s' command is not permitted on temporary tables.");
		add(4970  , 16 , "Cannot unlock this table because the table is not locked in that mode.");
		add(4971  , 16 , "This table cannot be locked in '%.*s' mode because it was already locked in '%.*s' mode.");
		add(4972  , 10 , "Warning: Empty Table '%.*s' with a clustered index has been partitioned. All data insertions will go to the first partition. To distribute the data to all the partitions, re-create the clustered index after loading the data.");
		add(4973  , 20 , "Row size (%d bytes) exceeded the maximum row size limit (%d bytes) for data only locked format while changing the lock scheme from ALLPAGES to DATAONLY for object '%.*s' (ID %d) in database '%.*s' (ID %d). The lock scheme for the object was not changed.");
		add(4974  , 0  , "Process %d was expected to hold logical lock on object %d.");
		add(4975  , 16 , "Cannot alter table for schema change because cursor '%.*s' is still open. Close the cursor(s) before this schema change operation.");
		add(4977  , 16 , "You cannot run ALTER TABLE LOCK in this database because the 'select into/bulkcopy' option is off. Please check with the DBO.");
		add(4978  , 16 , "User aborted ALTER TABLE LOCK change command for table %.*s");
		add(4979  , 17 , "ALTER TABLE LOCK change for table '%.*s' failed: insufficient memory to allocate backout structure. Raise the value of the configuration parameter 'procedure cache size'.");
		add(4980  , 17 , "No space left in database '%S_DBID'; Use ALTER DATABASE to increase size of database. Else, an old transaction may be active; see Syslogshold table.");
		add(4981  , 16 , "Column offset, %d bytes, for variable-length column number %d exceeds the maximum start offset for variable-length columns in DOL tables (%d bytes). The lock scheme for the object '%.*s' was not changed.");
		add(4982  , 10 , "Due to an internal error the table '%.*s' can not be converted to new lock scheme . Please contact your System Administrator (SA) for help");
		add(4983  , 10 , "Primary index (indid = %d) is suspect for table '%.*s'. Please check and reissue the lock change command.");
		add(4984  , 10 , "Computed effective expected row size value(%d) for the table '%.*s' with the expected row size value(%d) is invalid. Forcing the default value.");
		add(4985  , 10 , "Warning: trigger '%.*s' is already enabled.");
		add(4986  , 10 , "Warning: trigger '%.*s' is already disabled.");
		add(4987  , 10 , "Enabling trigger '%.*s'.");
		add(4988  , 10 , "Disabling trigger '%.*s'.");
		add(4989  , 16 , "The trigger you specified ('%.*s') does not exist. The ALTER TABLE command is being terminated.");
		add(4990  , 17 , "ALTER TABLE '%.*s' failed due to insufficient procedure cache. Retry later when there is less load/users on Adaptive Server, or ask your System Administrator to reconfigure Adaptive Server with more procedure cache.");
		add(4991  , 10 , "ALTER TABLE '%S_OBJID' in database %S_DBID (objectid %d) failed due to an internal error. Please contact SAP Technical Support.");
		add(4993  , 16 , "ALTER TABLE '%.*s' failed. Dropping all columns in a table is not allowed.");
		add(4994  , 16 , "ALTER TABLE '%.*s' failed. The number of columns in the resultant table (%d) exceeds the current limit %d.");
		add(4995  , 16 , "ALTER TABLE '%.*s' failed. Multiple references to the same column in ALTER TABLE statements are not allowed.");
		add(4996  , 16 , "ALTER TABLE '%.*s' failed. Adding non-NULL timestamp column '%.*s' is not allowed.");
		add(4997  , 16 , "ALTER TABLE '%.*s' failed. Default clause is required in order to add non-NULL column '%.*s'.");
		add(4998  , 16 , "ALTER TABLE '%.*s' failed. Default value cannot be NULL when adding a non-NULL column.");
		add(4999  , 16 , "ALTER TABLE '%.*s' failed. You cannot drop column '%.*s' on which a primary or foreign key constraint is defined.");
	}
	private void init2()
	{
		add(5001  , 16 , "User must be in Master Database.");
		add(5002  , 16 , "Database %.*s does not exist; check sysdatabases.");
		add(5004  , 16 , "%s failed. The size value is invalid.");
		add(5005  , 0  , "Extending database by %u pages (%d.%d megabytes) on disk %.*s");
		add(5006  , 16 , "Could not find enough space on disks to extend database %.*s.");
		add(5008  , 16 , "System does not support Deextend Database currently.");
		add(5009  , 16 , "ALTER DATABASE failed. Some disk names listed in command were not found. Check that names exist and are spelled correctly before re-running command.");
		add(5011  , 14 , "Only the owner of database %.*s or a user with System Administrator (SA) role can ALTER it.");
		add(5013  , 16 , "Cannot extend the MASTER database onto any device other than 'master'. The ALTER DATABASE was aborted.");
		add(5015  , 16 , "CREATE or ALTER DATABASE failed. The size specified must be %d kilobyte(s) or greater.");
		add(5016  , 0  , "ALTER DATABASE failed. The model database may not be larger than the smallest temporary database. Alter temporary database (dbid = %d) first.");
		add(5017  , 16 , "ALTER DATABASE failed. Database %.*s not created with 'for load' option.");
		add(5018  , 10 , "Caution:  You have set up this database to include space on disk %d for both data and the transaction log.  This can make recovery impossible if that disk fails.");
		add(5020  , 16 , "Database '%.*s' cannot be extended. It has reached its maximum possible size.");
		add(5021  , 10 , "Device '%.*s' is not affected by this %s command.");
		add(5022  , 16 , "%s failed to allocate %u bytes of memory. This operation cannot continue.");
		add(5023  , 16 , "%s cannot move the active part of the transaction log. Dump the transaction log in database '%.*s', and try again. If replication is running, let it catch up in this database.");
		add(5024  , 10 , "A database level command is already in progress on database '%.*s'. This %s command cannot proceed.");
		add(5025  , 10 , "No information is available for a previous %s command. The command cannot be restarted.");
		add(5026  , 10 , "Updating database maxhold.");
		add(5028  , 16 , "ALTER DATABASE failed. This command will not make changes to a database that would cause the number of device fragments to exceed the maximum of 128. Recreate the database and try again.");
		add(5029  , 16 , "ALTER DATABASE failed. Log space in master database has reached the last chance threshold. Please free-up log space in master database and try again.");
		add(5030  , 16 , "The database %S_DBID is in the middle of a load sequence. Altering it will not let you load other transaction dumps in the dump-set. If you still prefer to do it please use OVERRIDE option.");
		add(5031  , 10 , "Database %S_DBID which is currently offline has been altered from size %d logical pages (%d physical pages) to %d logical pages (%d physical pages).");
		add(5032  , 10 , "Alter database on '%S_DBID' broke the load sequence for that database.");
		add(5033  , 16 , "Attempt to alter database '%S_DBID' failed because it is in read-only mode.");
		add(5036  , 16 , "ALTER DATABASE failed either because the database is failed over or system proxy databases are enabled on the server in failed over mode.");
		add(5037  , 17 , "ALTER DATABASE for database '%S_DBID' was unsuccessful; it failed to update log space values in internal persistent data structure.");
		add(5038  , 10 , "Warning: Using ALTER DATABASE to extend the log segment will cause user thresholds on the log segment within 128 pages of the last chance threshold to be disabled.");
		add(5039  , 16 , "ALTER DATABASE for database '%.*s', was unable to update 'master.dbo.sysusages' with the new space.");
		add(5040  , 16 , "Cannot alter database '%.*s' to set minimal DML logging because this database is marked for replication. Remove replication and try again.");
		add(5041  , 10 , "Warning: Database '%.*s' has objects marked for replication. Replicated objects will continue to use full DML logging.");
		add(5042  , 10 , "Property %s of %S_MSG set to %s.");
		add(5043  , 10 , "Property %s of %S_MSG is not changing, and is left unaffected.");
		add(5044  , 16 , "%s failed. Database '%.*s' cannot be larger than the smallest database ('%S_DBID') that uses it as a template.");
		add(5045  , 16 , "You cannot shrink database '%.*s' because the database either has reduced durability or is being used as a template.");
		add(5046  , 10 , "The page '%u' is not an allocation page. The page number used is '%u'.");
		add(5047  , 16 , "You can remove only log fragments from a database. The requested fragment contains segment '%.*s' (%d).");
		add(5048  , 16 , "Internal error: An attempt to restore the original database diskmap has failed. Please, report to Tech Support.");
		add(5049  , 16 , "The log in database '%.*s' cannot be locked. The error returned is '%s'.");
		add(5050  , 16 , "You cannot shrink the log because at least one stranded object (with partition ID %d) is allocated in the requested page range.");
		add(5051  , 16 , "The attempt to ALTER DATABASE '%.*s' has failed because an error occured when trying to extend the log in a new device fragment.");
		add(5052  , 16 , "You cannot shrink the log in database '%.*s' because there is at least one page to be removed (%d) that is part of the log. Wait until all currently active transactions have completed, dump the transaction log, and retry the ALTER DATABASE command.");
		add(5053  , 16 , "You cannot shrink the log in database '%.*s' because there is at least one page to be removed (%d) that is part of the log. Dump the transaction log and retry the ALTER DATABASE command.");
		add(5054  , 16 , "You cannot remove %d log pages (%d MB) from database '%.*s' because the log size is %d (%d MB).");
		add(5055  , 16 , "You cannot remove %d log pages (%d MB) from the database '%.*s' because the amount of free log space remaining (%d pages, %d MB) would fall below last chance threshold (%d pages, %d MB).");
		add(5056  , 16 , "You cannot remove %d pages (%d MB) from database '%.*s'; only %d unreserved pages (%d MB) are available.");
		add(5057  , 16 , "The free space counts for the log are incorrect as the amount of free space for the log (%d pages, %d MB) for database '%.*s' is greater than the total log size (%d, %d MB). Execute DBCC DBREPAIR(%.*s, fixlogfreespace, scanlogchain [, 1]).");
		add(5058  , 16 , "You cannot use database '%.*s' as a template, because some logical pages are physically unavailable.");
		add(5059  , 16 , "You can only remove space from the log segment (segment map %u) in database '%.*s'. The page range between %u and %u belongs to the segment with segment map %u.");
		add(5060  , 18 , "Warning: ALTER DATABASE cannot fully clean up the space removed from database '%.*s'; execution of a DISK REFIT command will incorrectly include some or all of this space when it re-creates the database.");
		add(5061  , 16 , "There are no pages that satisfy the ALTER DATABASE request.");
		add(5062  , 10 , "Removing %d pages (%d.%d MB) from disk '%.*s' in database '%.*s'.");
		add(5063  , 16 , "You must have the database '%.*s' in single-user mode to perform an operation that either partially fills a hole or removes a partial disk fragment from the database.");
		add(5064  , 18 , "ALTER DATABASE on %S_INSTID failed to communicate with another instance to restore the database '%.*s' disk map due to internal error %d. To fix this problem try executing DBCC DBREPAIR(%.*s,'remap').");
		add(5065  , 16 , "%s option '%s' cannot be used with option '%s'.");
		add(5066  , 16 , "Table '%.*s' contains off-row columns that do not link back to their owning rows. Run dbcc shrinkdb_setup to set up back links for this database.");
		add(5067  , 10 , "%s with %s is complete. The check found %d problem(s).");
		add(5068  , 10 , "%s: checking %S_MSG '%.*s'.");
		add(5069  , 16 , "Pages for object ID %d must be relocated as contiguous groups of 8 pages. ASE was not able to allocate enough contiguous space to perform this move. Please make more space available, then try this command again.");
		add(5070  , 16 , "%s: this command is not allowed in database '%.*s'.");
		add(5071  , 16 , "This %s command is not valid in database 'master' or a master-type database.");
		add(5072  , 16 , "%s cannot remove the first 256 pages of a database.");
		add(5073  , 16 , "%s cannot execute as a background task. Please try your command again when the system is less loaded, or omit the 'as background task' qualifier.");
		add(5074  , 16 , "Segment %.*s has objects bound to it, so you cannot drop it. Use ALTER TABLE to relocate the bound objects, then try your command again.");
		add(5075  , 16 , "%s failed to drop segment '%.*s'.");
		add(5076  , 16 , "%s failed to insert a disk map entry.");
		add(5077  , 16 , "%s failed to insert a segment entry.");
		add(5078  , 16 , "Database '%.*s' has too many segments. You must drop at least one segment before you can create more.");
		add(5079  , 16 , "This %s command cannot run in database '%.*s' unless either the database or the server is in single-user mode.");
		add(5080  , 16 , "A block of %u pages starting at logical page %u in database '%.*s' cannot be moved because there is no acceptable target location. Use %s to extend the database to receive these pages.");
		add(5081  , 16 , "'%s' command for database '%.*s' failed, data cannot be totally moved off from allocation unit %d");
		add(5082  , 18 , "Shrink database was interrupted and table suspect status has been set with table id %d in database id %d. Run DBCC DBREPAIR command on the database to fix the possible table corruption.");
		add(5083  , 16 , "Table '%.*s' in database '%.*s' uses indexes on text columns. These indexes must be removed before this %s command can execute successfully.");
		add(5084  , 16 , "%s encountered pages from table '%s'. These pages cannot be moved while incremental dumps are enabled. Disable incremental dumps, then retry your command.");
		add(5085  , 16 , "ALTER DATABASE on %S_INSTID failed to communicate with another instance to inform the database '%.*s' to cleanup/modify shrink due to internal error %d. To fix this problem try this command again.");
		add(5086  , 16 , "This operation requires %d worker processes. Existing worker processes are not sufficient to serve the request. Please configure 'number of worker processes' accordingly.");
		add(5087  , 10 , "%s received an interrupt. This command will stop.");
		add(5088  , 10 , "%s has finished in database '%.*s'. This command processed %d allocation units of %d requested.");
		add(5089  , 10 , "%s is starting in database '%.*s'. This command will process %d allocation units.");
		add(5090  , 16 , "Failed to scan datatabase devices.");
		add(5091  , 10 , "%s: index %.*s of table %.*s may have many duplicated keys. Consider dropping this index before the operation, and recreating it later.");
		add(5092  , 10 , "%s: index '%.*s' of table '%.*s' has no statistics available. We cannot tell whether it might have many duplicated keys.");
		add(5093  , 10 , "%s: segment '%.*s' (ID %d) in database '%.*s' does not have enough free space to receive data that must be moved.");
		add(5094  , 18 , "A request to get an exclusive lock on the database disk fragments map has timed out. The %S_MSG operation has been aborted. Retry the command later or execute DBCC DISKMAP('lock_check', '%.*s') and contact SAP product support if the problem persists.");
		add(5095  , 16 , "Only temporary database can be encrypted or decrypted with random key.");
		add(5096  , 16 , "%s failed. A database cannot have more than one in-memory row storage cache.");
		add(5097  , 16 , "The IMRSLOG fragments cannot be removed if the row cache is active in this database. Execute ALTER DATABASE ROW STORAGE OFF and retry the command.");
		add(5098  , 10 , "Configuration option '%s' has been ignored because database option 'enforce dump tran sequence' is enabled in database '%.*s'.");
		add(5101  , 15 , "Must give parameters for 'DISK %s' command. Usage: %s.");
		add(5102  , 15 , "No such command: 'DISK %.*s'.");
		add(5103  , 16 , "Illegal disk address range. The sum of VSTART and SIZE must be less than 16777216 (0x1000000).");
		add(5104  , 16 , "Device number %d already used.");
		add(5105  , 16 , "Device activation error.  PHYSNAME '%.*s' may be incorrect.");
		add(5106  , 15 , "Parameter '%s' requires value of type '%s'.");
		add(5107  , 15 , "Value is wrong type for parameter '%s' (requires type '%s').");
		add(5108  , 15 , "Parameter '%s' does not take a value.");
		add(5109  , 16 , "No such parameter: '%.*s'.");
		add(5113  , 17 , "Disk update for logical device = '%.*s' with physical path '%.*s' and virtual device number %d failed. Please refer to ASE errorlog for more information.");
		add(5114  , 16 , "Unable to execute 'DISK REINIT' on '%.*s' because it's still active. Please, drop the device and recreate it using DISK INIT.");
		add(5115  , 0  , "I/O error during disk initialization. PHYSNAME '%.*s' may be incorrect or %d (VSTART + SIZE) may exceed the size of the device. Please consult the ASE error log for more details.");
		add(5116  , 14 , "Permission denied.  Only users with System Administrator (SA) role can run DISK commands.");
		add(5117  , 16 , "Unable to run DISK %.*s command. Must be in master database to run this command.");
		add(5118  , 16 , "Unable to run DISK REFIT. ASE must be booted with the -m option. Please see your System Administration guide about the Restore Master procedure.");
		add(5119  , 18 , "Unable to reserve a buffer, aborting DISK REFIT command.  Please retry Restore Master procedure.");
		add(5120  , 0  , "Bad segment map (%d) in sysusages for row with Dbid = %d, Logical Start = 0x%x, Virtual Start = 0x%x, and Size = 0x%x. Recommend you patch this value with correct information after Disk Refit completes.");
		add(5121  , 10 , "Warning: Disk Refit may not have the correct segment map information in sysusages.  Please review these after the command completes to verify their accuracy.");
		add(5122  , 10 , "The disk size must be >= %d device pages (%d MB).");
		add(5123  , 16 , "DISK INIT encountered an error while attempting to open/create the physical file for device '%.*s'. Consult the Adaptive Server error log for more details. For the Cluster Edition, check the error log of each instance.");
		add(5124  , 10 , "Activating disk '%.*s' of size %u KB.");
		add(5125  , 10 , "Failed to complete unmirror of logical device '%.*s' after recovery of the master database.");
		add(5126  , 16 , "The logical device '%.*s' does not exist in SYSDEVICES.");
		add(5127  , 16 , "The device '%.*s' is already mirrored and mirroring is enabled.");
		add(5128  , 16 , "The device '%.*s' is already mirrored but mirroring is disabled. Use the DISK REMIRROR command to enable mirroring or unmirror the device.");
		add(5129  , 16 , "Syntax error detected in the value for parameter 'mirror'.  You must provide a valid physical device/file name for this parameter.");
		add(5130  , 16 , "The value for parameter 'mirror' translates to the same name as that for the primary device.  Use another physical device for the mirror.");
		add(5131  , 16 , "The device '%.*s' is not currently mirrored.");
		add(5132  , 10 , "DISK MIRROR encountered an error while attempting to create the physical file '%.*s'. Please consult the ASE error log for more details.");
		add(5133  , 10 , "Unable to start i/o to '%.*s'. Please consult the ASE error log for details.");
		add(5134  , 10 , "Dynamic mirroring failed for logical device '%.*s'. Check the ASE error log for more information.");
		add(5135  , 0  , "Starting Dynamic Mirroring of %d pages for logical device '%.*s'.");
		add(5136  , 10 , "%*.d pages mirrored...");
		add(5137  , 10 , "Failed to mirror device '%.*s'.");
		add(5138  , 10 , "Failed to unmirror device '%.*s'.");
		add(5139  , 10 , "Failed to remirror device '%.*s'.");
		add(5140  , 10 , "Creating the physical file for the mirror...");
		add(5141  , 17 , "Unable to start Dynamic Mirroring because an i/o buffer is not currently available. Try the command again later.");
		add(5142  , 16 , "Mirroring for device '%.*s' is not currently enabled.");
		add(5143  , 0  , "The remaining %d pages are currently unallocated and will be mirrored as they are allocated.");
		add(5144  , 16 , "You can't remove the secondary physical device for virtual device '%.*s' since it is currently the only operational device.  Use the SIDE=PRIMARY qualifier for the DISK UNMIRROR COMMAND.");
		add(5145  , 16 , "Error re-initializing device '%.*s'. Check the Adaptive Server error log for more details. For the Cluster Edition, check the error log of each instance.");
		add(5146  , 0  , "The VDEVNO of %d is out of range. The maximum VDEVNO allowed is %d.");
		add(5147  , 0  , "Device size set to %d blocks.");
		add(5148  , 16 , "Device '%.*s' already exists.");
		add(5149  , 16 , "You cannot remove the primary physical device for virtual device '%.*s' since it is currently the only operational device.  Use the SIDE=SECONDARY qualifier for the DISK UNMIRROR COMMAND.");
		add(5150  , 16 , "DISK UNMIRROR cannot be performed, because database '%S_DBID' is currently undergoing DUMP or LOAD.  Either wait for that command to complete, or abort it.");
		add(5151  , 16 , "PHYSNAME '%.*s' is already in use.");
		add(5152  , 16 , "DISK REFIT failed. Either the database is corrupted or the value of the VSTART parameter supplied to DISK INIT and DISK REINIT were different.");
		add(5153  , 16 , "Device '%.*s' cannot be released since it is in use by database id '%S_DBID'. Drop that database and retry.");
		add(5154  , 16 , "Device '%.*s' is not a valid database device.");
		add(5155  , 16 , "The command 'DISK %s' cannot be executed since disk mirroring has been disabled. In order to enable disk mirroring, use: sp_configure 'disable disk mirroring',0 and restart the server.");
		add(5156  , 16 , "DISK INIT failed. All disks are either in use or reserved for failover of companion server");
		add(5157  , 16 , "Disk refit command is not allowed within the failed over mode of the companion server");
		add(5158  , 16 , "DISK INIT of '%.*s' failed because this name is reserved for failed over device.");
		add(5159  , 16 , "Only the master database can be recovered when attempting to use the DISK REFIT command. Restart the server using trace flag 3608.");
		add(5160  , 16 , "Arithmetic overflow error for parameter '%s'.");
		add(5161  , 16 , "There are no available device numbers. ASE allows a maximum of %d devices and all the device numbers upto the maximum have been used.");
		add(5162  , 16 , "The maximum number %d of configured devices has already been reached. Please reconfigure 'number of devices' to a larger value and retry disk initialization.");
		add(5163  , 16 , "Disk initialization for logical device '%.*s' failed as a virtual disk descriptor could not be allocated, possibly due to shortage of memory.");
		add(5164  , 0  , "Initializing %d pages only; insufficient disk space.");
		add(5165  , 16 , "DISK RESIZE can proceed only when mirroring is permanently disabled. UNMIRROR %S_MSG with mode = 'REMOVE' and reexecute command.");
		add(5166  , 16 , "DISK RESIZE encountered an error while attempting to open/resize the physical file '%s'. Please consult the ASE error log (in the ASE boot directory) for more details.");
		add(5167  , 16 , "Total device size would exceed the limit of %d MB for ASE %s. Please retry your command with a smaller size (current total device size = %d MB).");
		add(5168  , 10 , "Warning: Relative path name '%s' used for physical device. Device may become unavailable if the server's current directory changes.");
		add(5169  , 16 , "The DSYNC and DIRECTIO options are mutually exclusive. Both can not be set to true for the same device.");
		add(5170  , 16 , "The '%s' option is currently not supported by this platform.");
		add(5171  , 10 , "Warning: The 'skip_alloc' option of disk init/disk resize command is turned on, and does not ensure allocation of the specified number of pages. Please make sure file system has enough space for future operations.");
		add(5172  , 10 , "Warning: Ignoring the 'skip_alloc' option for device '%.*s' as it is not applicable to the special devices.");
		add(5173  , 10 , "The physical device '%.*s' has been automatically assigned the logical device name '%.*s'.");
		add(5174  , 16 , "Unable to create the generated device name '%.*s' because the resultant device name is too long.");
		add(5175  , 16 , "Unable to create the generated device name '<vdn>$%.*s' because the virtual device number is too big.");
		add(5176  , 10 , "Warning: SAP recommends not to use '%s' as a database device, because it is a block device and may cause data loss in case of system failure.");
		add(5177  , 16 , "Parameter '%s' is valid only with the '%s' command.");
		add(5178  , 16 , "Device '%.*s' is a private device. The command is not valid for private devices.");
		add(5179  , 16 , "Instance '%.*s' that owns the private device '%.*s' is down and can not process the command.");
		add(5180  , 16 , "DISK %s for private device '%.*s' encountered an error. Please consult the ASE error log of the owning instance '%.*s' for more details.");
		add(5181  , 10 , "Disk initialization for logical device '%.*s' (physical path '%.*s') failed due to I/O fencing error and prevented %S_INSTID from joining the cluster. Refer to the instance error log for additional information.");
		add(5182  , 10 , "DISK REFIT has no private devices to refit for the current instance.");
		add(5183  , 10 , "Starting DISK REFIT for the cluster.");
		add(5184  , 10 , "DISK REFIT for the cluster is now complete.");
		add(5185  , 10 , "WARNING: DISK REFIT for the cluster is not yet complete. DISK REFIT needs to be run on %d other instance(s) in the cluster that have private devices.");
		add(5186  , 10 , "WARNING: Please run DISK REFIT on instance '%.*s' to complete DISK REFIT for the cluster.");
		add(5187  , 10 , "Starting DISK REFIT for the instance '%.*s'.");
		add(5188  , 10 , "The Adaptive Server disk mirroring feature is not supported in this edition.");
		add(5189  , 10 , "The logical device '%.*s' (physical path '%.*s') could not be activated on the %S_INSTID. The instance cannot join the cluster.");
		add(5190  , 16 , "Cannot clear the REFIT PENDING status for the logical device '%.*s'.");
		add(5191  , 16 , "Cannot set the REFIT PENDING status for the logical device '%.*s'.");
		add(5192  , 10 , "Skipping disk '%.*s' activation because the device is disabled at the coordinator %S_INSTID.");
		add(5193  , 16 , "You cannot set option %s for raw device '%s'.");
		add(5194  , 16 , "Virtual cache device '%.*s' not created. Cache '%.*s' does not exist in the server.");
		add(5195  , 16 , "Virtual cache device '%.*s' not created; requested device size %d is greater than the available space in cache '%.*s'.");
		add(5196  , 16 , "Failed to create the virtual cache device; cache '%.*s' is not an in-memory storage cache.");
		add(5197  , 16 , "Command %s %.*s is not applicable to virtual cache devices.");
		add(5198  , 16 , "The following options are not applicable to a virtual cache device when used with the %s%s command: %s.");
		add(5199  , 10 , "Virtual cache device '%.*s' of size = %d MB has been created on cache '%.*s'.");
		add(5201  , 26 , "Failure concurrent with dump in database %d:  DFL Manager caller must be DUMP DATABASE;  instead, command token was %d.");
		add(5202  , 26 , "DUMP DATABASE for database %d failed:  DFL synchronisation is prematurely set.");
		add(5203  , 17 , "DUMP DATABASE for database %d failed: insufficient memory to allocate DFL. Raise the value of the configuration parameter 'procedure cache size'.");
		add(5204  , 26 , "DUMP DATABASE for database %d failed:  initial DFL allocation will not fit in initial memory block.");
		add(5205  , 26 , "DUMP DATABASE for database %d failed:  duplicate dflheader found.");
		add(5206  , 26 , "DUMP DATABASE for database %d failed:  dump flushlist structures have not been allocated.");
		add(5207  , 26 , "DUMP DATABASE for database %d failed:  DFL synchronisation is not set.");
		add(5208  , 10 , "User aborted DUMP DATABASE for database %d.");
		add(5209  , 26 , "Failure during concurrent dump in database %d:  DFL Manager caller must not be DUMP DATABASE, but is.");
		add(5210  , 26 , "Failure during dump in database %d:  caller does not possess dump lock.");
		add(5211  , 26 , "Failure concurrent with dump in database %d:  caller does not possess flushlist lock.");
		add(5212  , 26 , "Failure concurrent with dump in database %d:  no DFL pieces on not-full list.");
		add(5213  , 26 , "Failure concurrent with dump in database %d:  caller improperly holds flushlist lock.");
		add(5214  , 20 , "During DUMP DATABASE for database %d, flushlist closure not complete at end of synchronisation.");
		add(5215  , 26 , "DUMP DATABASE for database %d failed:  could not find dflinfohead to deallocate.");
		add(5216  , 26 , "DUMP DATABASE for database %d failed:  trailing piece in not-full list proved not-empty.");
		add(5217  , 20 , "DFL Manager failed to sleep.");
		add(5600  , 20 , "Adaptive Server internal error: Did not expect to find distributed transaction participant descriptor for local participant.");
		add(5601  , 20 , "Adaptive Server internal error: invalid input %d to internal functions.");
		add(5602  , 17 , "Could not find an available distributed transaction participant descriptor. Retry later or please contact a user with System Administrator (SA) role to increase the configuration parameter 'number of dtx participants'.");
		add(5603  , 16 , "Adaptive Server cannot accept distributed transactions as transaction coordinator is not enabled. Please contact a user with System Administrator (SA) role.");
		add(5604  , 16 , "Adaptive Server internal error: Cannot register a remote distributed transaction participant when process is not within a transaction.");
		add(5605  , 16 , "%s RPC to the remote server '%S_SRVID' failed. Transaction key '%.*s'. Return status %d.");
		add(5606  , 20 , "Adaptive Server internal error: Transaction coordinator setup failed during alarm initialization.");
		add(5607  , 16 , "Could not reserve log space in sybsystemdb database. Retry your transaction later, or please contact a user with System Administrator role.");
		add(5608  , 16 , "The remote server '%S_SRVID' does not support distributed transactions.");
		add(5609  , 16 , "The sybsystemdb database is not available.");
		add(5610  , 16 , "The syscoordinations table in sybsystemdb database is not available.");
		add(5611  , 21 , "Adaptive Server internal error: distributed transaction recovery boot count error. Transaction boot count is %d, Server current boot count is %d.");
		add(5612  , 16 , "System database %s is not allowed to participate in a distributed transaction.");
		add(5613  , 20 , "Adaptive Server internal error: Could not release distributed transaction participant descriptor to the free pool.");
		add(5614  , 16 , "Cannot start a remote distributed transaction participant on server '%d' as server does not does not exist. Please contact a user with System Administrator role.");
		add(5615  , 21 , "Adaptive Server internal error: ASTC task state %d is incorrect.");
		add(5616  , 20 , "Adaptive Server internal error: invalid distributed transaction participant work identifier %d for participant %d. Transaction key '%.*s'.");
		add(5617  , 17 , "Adaptive Server internal error. Could not change engine affinity.");
		add(5618  , 21 , "Adaptive Server internal error. Could not resolve distributed transaction states where system database '%s' was a participant.");
		add(5619  , 21 , "Adaptive Server internal error. Could not obtain count of in-doubt transactions for space reservation.");
		add(5620  , 21 , "Adaptive Server internal error. Could not reserve space for in-doubt transactions.");
		add(5621  , 16 , "You cannot start non-transactional work on the remote server. 'enable xact coordination' is off and the task enabled 'strict dtm enforcment', which requires transactional work.");
		add(5622  , 21 , "Adaptive Server Internal Error. Cannot allocate memory for transaction coordinator processes.");
		add(5623  , 21 , "Adaptive Server Internal Error: Cannot start transaction coordinator process.");
		add(5624  , 20 , "Adaptive Server Internal Error: transaction coordinator protocol mismatch error.");
		add(5625  , 20 , "Adaptive Server Internal Error: transaction coordinator was passed an invalid transaction identifier length of '%d'.");
		add(5626  , 17 , "Cannot allocate a gtrid object descriptor. Retry later or please contact a user with System Administrator (SA) role to increase the configuration parameter 'number of dtx participants'.");
		add(5627  , 20 , "Adaptive Server Internal Error: Cannot release gtrid object descriptor to the free pool.");
		add(5628  , 20 , "Adaptive Server Internal Error: A distributed transaction descriptor was found in the wrong state. state %d, status %d.");
		add(5629  , 16 , "Cannot start a remote distributed transaction participant as the local server is not named. Please contact a user with System Administrator role.");
		add(5630  , 16 , "Transactional connection to remote server '%S_SRVID' has been invalidated. Aborting the distributed transaction. Transaction key '%.*s.");
		add(5631  , 16 , "Adaptive Server Internal Error. New transactional connection to server '%S_SRVID' is being passed while there is an existing transactional connection to the same server in the same transaction. Aborting the distributed transaction. Transaction key '%.*s.");
		add(5632  , 16 , "This operation is invalid when the run value of configuration parameter 'enable xact coordination' is on. Please retry after disabling this configuration parameter.");
		add(5633  , 20 , "Instance cannot determine the status of the ASTC subsystem on the cluster coordinator, so it cannot join the cluster.");
		add(5634  , 10 , "ASTC subsystem cannot be initialized on this instance, as the subsystem is not running on the cluster coordinator.");
		add(5635  , 10 , "Instance cannot be booted as ASTC subsystem cannot be booted on this instance whereas it is running on other instances in the cluster.");
		add(5636  , 10 , "ASTC task cannot perform failover work.");
		add(5701  , 10 , "Changed database context to '%.*s'.");
		add(5702  , 10 , "ASE is terminating this process.");
		add(5703  , 10 , "Changed language setting to '%.*s'.");
		add(5704  , 10 , "Changed client character set setting to '%.*s'.");
		add(5803  , 10 , "Unknown config number in sysconfigures, config = %d.");
		add(5804  , 16 , "The value for '%s' must not exceed '%s' or '%s'.");
		add(5805  , 16 , "Warning: The next configuration change will overwrite '%s'. To avoid this rename, move, or delete old configuration files. See System Administration Guide for details.");
		add(5806  , 16 , "Warning: The file '%s' has been overwritten. To prevent this rename, move, or delete old configuration files. See System Administration Guide for details.");
		add(5807  , 10 , "Invalid memory move request encountered for the '%dK' pool in cache '%s'. Move should equal at least 1 buffer of size '%dK'.");
		add(5808  , 10 , "WARNING: Dynamic loading of caches and pools through loading a new file are not supported. However, the loadfile '%s' will be inspected for consistency. Refer to 'sp_cacheconfig' and 'sp_poolconfig' to create or alter pools and caches.");
		add(5809  , 16 , "Less memory moved than requested in cache %s cache. Requested size = %d kb from pool %d, actual memory moved = %d kb.");
		add(5810  , 16 , "new (%d) buffer pool of size %d for cache %s is being created");
		add(5811  , 16 , "The new load file does not have the cache %s definition. Cache type, size and number of caches should match the running values. Use sp_cacheconfig to determine the running value");
		add(5812  , 16 , "The new load file has %d caches defined against running %d cache definitions.Cache type, size and number of caches should match the running values. Use sp_cacheconfig to determine the running value.");
		add(5813  , 16 , "The new load file has duplicate %s cache definitions, caches should be uniqueue.");
		add(5816  , 16 , "Legal values for the number of remote logins are 0 or positive numbers.");
		add(5817  , 16 , "Legal values for the number of remote sites are 0 or positive numbers.");
		add(5818  , 16 , "Legal values for the number of remote connections are 0 or positive numbers.");
		add(5819  , 16 , "Legal values for the number of pre-read packets per remote connection are 0 or positive numbers.");
		add(5820  , 16 , "Number of remote logins should be greater than the number of remote sites.");
		add(5821  , 16 , "Number of remote connections should be greater than the number of remote sites.");
		add(5822  , 16 , "Version number should be between 0 and 10000.");
		add(5824  , 16 , "Cannot reconfigure server to use sort order ID %d, because the row for its underlying character set (ID %d) does not exist in syscharsets.");
		add(5825  , 16 , "Cannot reconfigure the server's sort order since the syscharsets table does not exist.  You must upgrade your server prior to attempting this.");
		add(5826  , 10 , "You have just reconfigured ASE's default sort order. System table indexes will be rebuilt when you reboot ASE.");
		add(5827  , 10 , "In changing the default sort order, you have also reconfigured ASE's default character set.");
		add(5828  , 16 , "Legal values for number of user connections are 1 through %d.");
		add(5829  , 16 , "Do not recommend more than %d engines on-line.  Use override option to force this option.");
		add(5830  , 16 , "Must configure with at least %d engine(s) on-line.");
		add(5831  , 16 , "Cannot reconfigure the server's character set with out of bounds character set ID %d.");
		add(5832  , 10 , "The stack size must be a multiple of the page size. It has been rounded from %d to %d.");
		add(5833  , 16 , "Cannot reconfigure the server with an out-of-bound, illegal value for Systemwide Password Expiration Interval.");
		add(5835  , 16 , "Cannot reconfigure the server with an out-of-range audit queue size.  The valid range is %d to %d inclusive.");
		add(5836  , 10 , "The additional network memory size must be a multiple of 2048 bytes. It has been rounded down from %d to %d.");
		add(5837  , 10 , "The default network packet size must be a multiple of 512. It has been rounded down from %d to %d.");
		add(5838  , 10 , "The maximum network packet size must be a multiple of 512. It has been rounded down from %d to %d.");
		add(5839  , 0  , "The value of 'max network packet size', '%d', must be greater than or equal to the value of the 'default network packet size', '%d'.");
		add(5840  , 0  , "Illegal value (%d) specified for the number of large extents.");
		add(5841  , 16 , "Cannot reconfigure the server's sort order with an out of bounds sort order set ID %d.");
		add(5842  , 16 , "Number of cleanup blocks should be at least as great as the number of users. The number of users currently configured is %d.");
		add(5843  , 0  , "Invalid Configuration: Cache alignment '%d' is invalid. Alignment must be a power of 2 greater than or equal to 2048. Retry the command with a legal value.");
		add(5844  , 16 , "Cannot reconfigure the auto identity column size to be %d because the minimum precision of a numeric is 1.");
		add(5845  , 16 , "Invalid value configured for lock promotion threshold = %d. Configured value must be greater than or equal to %d.");
		add(5846  , 0  , "Illegal value '%d' specified for configuration option '%s'. The legal values are between '%d' and '%d'.");
		add(5847  , 16 , "Configuration Error: Configuration file '%s' does not exist or you do not have the required read/write permission for the file.");
		add(5848  , 0  , "Warning: Unknown parameter '%s' found on line '%d' of configuration file '%s'. This parameter was removed or corrected from the configuration file successfully.");
		add(5849  , 16 , "Verification failed for parameter '%s'.");
		add(5850  , 16 , "Notification failed for parameter '%s'.");
		add(5851  , 16 , "Configuration Error: Configuration file '%s' has an unknown format on line %d.");
		add(5852  , 16 , "Changing the value of '%s' is not allowed since it is a static option.");
		add(5853  , 0  , "%s' has been modified from '%d' to '%d' by the verification routine.");
		add(5854  , 18 , "Configuration Error: Cannot %s file '%s' due to system error '%s' (status = %d).");
		add(5855  , 16 , "Cannot change any of the configuration parameters since the 'sysconfigures' table was not updated during startup.");
		add(5856  , 16 , "The configuration parameter '%s' can only be changed via the stored procedure 'sp_configure'.");
		add(5857  , 0  , "Changing the value of '%s' is not allowed since its value is calculated or is read only.");
		add(5858  , 0  , "The configuration option '%s' has been changed by '%s' from '%d' to '%d'.");
		add(5859  , 16 , "The configuration number '%d' is invalid.");
		add(5860  , 18 , "Invalid datatype encountered for parameter '%s'.");
		add(5861  , 0  , "The current 'max memory' value '%d', is not sufficient to change the parameter '%s' to '%d'. 'max memory' should be greater than 'total logical memory' '%d' required for the configuration.");
		add(5862  , 18 , "Invalid portion encountered.");
		add(5863  , 18 , "Invalid group encountered.");
		add(5864  , 0  , "Invalid option encountered in '%s'.");
		add(5865  , 18 , "error in os_get_cpu_count: %d");
		add(5866  , 10 , "Configuration file '%s' has been written and the previous version has been renamed to '%s'.");
		add(5867  , 16 , "The wash size for the %dk buffer pool in cache %s has been incorrectly configured. It must be a minimum of %d buffers and a maximum of %d percent of the number of buffers in the pool.");
		add(5868  , 16 , "Invalid type configured for cache %s. Cache type may be one of mixed OR log only but NOT both.");
		add(5869  , 16 , "Invalid buffer size of %dk for cache %s. Valid buffer sizes are powers of 2 between %dk and %dk inclusive.");
		add(5870  , 16 , "An invalid buffer size of %dk was encounterd in cache %s. Valid buffer sizes for caches are powers of 2 between %dk and %dk inclusive.");
		add(5871  , 16 , "Invalid pool size of %dk (%d buffers) encountered for the %dk pool in cache %s. Buffer pools must have a minimum total size of %dk or %d buffers, whichever is greater.");
		add(5872  , 16 , "The total size of the configured pools (%dk) in cache %s is greater than the total size (%dk) of the cache.");
		add(5873  , 16 , "Invalid configuration for the default %dk pool in cache %s. The default %dk pool must be a minimum of %dk.");
		add(5874  , 16 , "The total size of all configured caches (%dk) is greater than the memory available for caches (%dk).");
		add(5875  , 16 , "The cache type for the default data cache cannot be modified.");
		add(5876  , 16 , "Multiple pools containing buffer sizes of %dk encountered in cache %s. Buffer sizes in a cache must be unique.");
		add(5877  , 16 , "Bad alignment value of %d encountered. Valid cache alignment values are powers of 2 in between %dK and %dK inclusive. The units of this value are in bytes.");
		add(5878  , 14 , "Permission denied. Only users with role '%.*s' can change configuration option '%s'.");
		add(5879  , 0  , "The 'reconfigure' command is no longer needed and supported since its functionality has been migrated into the 'sp_configure' command. Please refer to the Reference Manual for details.");
		add(5880  , 16 , "Warning: The operating system setting for file descriptors, %d, is not large enough to configure 'user connections' to %d, 'devices' to %d, and 'remote sites' to %d.");
		add(5881  , 0  , "The value of 'default network packet size', '%d', must be less than or equal to the value of the 'max network packet size', '%d'.");
		add(5882  , 16 , "A cache alignment factor of %dk was specified but no buffer pool containing %dk buffers has been configured. An attempt will be made to create this pool with extra memory (%dk bytes) from cache %s.");
		add(5883  , 0  , "The value of 'number of locks', '%d', is not enough to configure 'user connections' to '%d'. 'number of locks' should be at least twice the value of 'user connections'.");
		add(5884  , 10 , "%s");
		add(5885  , 0  , "The '%slock promotion HWM'= '%d' cannot be less than '%slock promotion LWM' = '%d'.");
		add(5886  , 0  , "The '%slock promotion LWM'= '%d', cannot be greater than the '%slock promotion HWM'= '%d'.");
		add(5887  , 16 , "Configuration Error: Duplicate Named Cache '%s' found around line '%d' in the configuration file.");
		add(5888  , 16 , "Configuration Error: Two Named Caches with the 'cache status' defined as 'default data cache' is not allowed.");
		add(5889  , 16 , "Configuration Error: Unknown cache status '%s' defined for cache '%s'.");
		add(5890  , 16 , "Configuration Error: A Named Cache with 'cache status=default data cache' does not exist in the configuration file.");
		add(5891  , 16 , "Named cache '%s' has been configured too small. The minimum size of a named cache is %d Kilobytes.");
		add(5892  , 16 , "You cannot use 'allow sendmsg' option because syb_sendmsg() builtin is not supported on this platform.");
		add(5893  , 16 , "The sum, (%s) + (%s %s) + (%s) + (%s) + (%s) + (%s), must be no greater than '%d'.");
		add(5894  , 16 , "Configuration Error: Duplicate pool size definition of '%s' for Named Cache '%s'.");
		add(5895  , 16 , "Configuration Error: Duplicate wash size definition of '%s' for Named Cache '%s'.");
		add(5897  , 16 , "The Adaptive Server Enterprise Express Edition does not allow you to set this configuration parameter to a value higher than %d.");
		add(5898  , 0  , "WARNING!!! %dK buffer pool has been deleted. The log I/O size for the following databases have been set to %dk. You must change the log I/O size to an existing pool size.");
		add(5899  , 16 , "The value of the 'max memory' parameter (%d) defined in the configuration file is not high enough to set the other parameter values specified in the configuration file.");
		add(5901  , 20 , "Was unable to get an alarm, the background checkpoint process is unable to run.");
		add(5902  , 20 , "Serious kernel error reported on upsleep call, unwilling to continue.  Aborting the background checkpoint process.");
		add(5903  , 16 , "Unable to open database with id = %d, suspect inconsistency in sysdatabases table.");
		add(5904  , 10 , "Ckptproc waits for cluster failover to complete and retry.");
		add(6001  , 10 , "SHUTDOWN is waiting for %d process(es) to complete.");
		add(6002  , 10 , "A SHUTDOWN command is already in progress. Please log off.");
		add(6003  , 10 , "This process terminated by SHUTDOWN command.");
		add(6004  , 14 , "Permission denied.  Only users with System Administrator (SA) role can run the SHUTDOWN command.");
		add(6005  , 10 , "A SHUTDOWN is in progress.");
		add(6006  , 10 , "Server SHUTDOWN by request.");
		add(6008  , 10 , "Unable to write statistics for object %d in database %d. Please run update statistics on this table after boot-up or prior to accessing the table next time.");
		add(6009  , 10 , "Unable to write statistics for all objects in database %d. Please run update statistics on all objects in this database after boot-up or after loading this database.");
		add(6010  , 10 , "Unable to write statistics for index %d of object %d in database %d. Please run update statistics on this index after boot-up or prior to using this index.");
		add(6011  , 10 , "Unable to write statistics for all indexes of object %d in database %d. Please run update statistics on all indexes after boot-up or prior to using the indexes next.");
		add(6101  , 16 , "Process '%d' is not a valid process number.  Choose a number between 1 and '%d'.");
		add(6102  , 14 , "Permission denied.  Only users with System Administrator (SA) role can run the KILL command.");
		add(6103  , 17 , "Unable to do cleanup for the killed process; received Msg %d.");
		add(6104  , 16 , "You cannot use KILL to kill your own process.");
		add(6106  , 16 , "Process '%d' is not an active process number.");
		add(6107  , 14 , "Only User processes can be KILLed or SYB_TERMINATEd.");
		add(6108  , 16 , "Process '%d' is not sleeping under a valid KILL condition, and therefore cannot be KILLed.");
		add(6109  , 16 , "The KILL command is not legal in a user transaction.");
		add(6110  , 16 , "You cannot kill spid '%d' as it is performing SHUTDOWN, a critical system task.");
		add(6112  , 10 , "spid: %d Transaction rollback in progress. Estimated rollback completion: %d%% Estimated time left: %d seconds");
		add(6113  , 10 , "Status report cannot be obtained. ROLLBACK for spid:%d is not in progress.");
		add(6114  , 10 , "Killing spid: %d will not be immediate because it is waiting for a latch held by spid: %d.");
		add(6115  , 10 , "The Allocation Unit Initializer process (spid %d) has been requested to finish.");
		add(6116  , 10 , "The Allocation Unit Initializer process (spid %d) has not finished in the requested time. You can retry using DBCC DBREPAIR(%.*s, restart_au_init, 'kill').");
		add(6117  , 10 , "Transaction rollback in progress for spid %d for %d seconds. Estimated remaining rollback time is %d seconds.");
		add(6118  , 10 , "Completed scanning: %u / %u log records (%d%%); %u MB / %u MB log space (%d%%).");
		add(6119  , 10 , "%s rollback in progress for spid %d for %d seconds.");
		add(6120  , 10 , "Transaction rollback in progress for spid %d for %d seconds.");
		add(6121  , 10 , "Completed scanning: %u log records; %u MB log space.");
		add(6122  , 16 , "You cannot kill spid '%d' with force option as it is holding spinlock(s).");
		add(6201  , 10 , "    STEP %d");
		add(6202  , 10 , "        The type of query is SELECT (into Worktable%d).");
		add(6203  , 10 , "        The type of query is %s.");
		add(6204  , 10 , "%s  The update mode is direct.");
		add(6205  , 10 , "%s  The update mode is deferred.");
		add(6206  , 10 , "%s  GROUP BY");
		add(6207  , 10 , "        Vector Aggregate");
		add(6208  , 10 , "Scalar Aggregate");
		add(6209  , 10 , "%s  This step involves sorting.");
		add(6210  , 10 , "        Worktable%d created, in %s locking mode, for ORDER BY.");
		add(6211  , 10 , "        Worktable%d created, in %s locking mode, for DISTINCT.");
		add(6212  , 10 , "%s  Worktable%d created, in %s locking mode, for REFORMATTING.");
		add(6213  , 10 , "        Worktable%d created for SELECT_INTO.");
		add(6214  , 10 , "%s  TO TABLE");
		add(6215  , 10 , "%s  FROM TABLE");
		add(6216  , 10 , "%s  Worktable%d.");
		add(6217  , 10 , "%s  %.*s");
		add(6218  , 10 , "        DISJOINT TABLE : nested iteration.");
		add(6219  , 10 , "        Nested iteration.");
		add(6220  , 10 , "        EXISTS TABLE : nested iteration.");
		add(6221  , 10 , "        Using GETSORTED");
		add(6222  , 10 , "%s  Using Dynamic Index.");
		add(6223  , 10 , "%s  Table Scan.");
		add(6224  , 10 , "%s  Using Clustered Index.");
		add(6225  , 10 , "%s  Index : %.*s");
		add(6226  , 10 , "%s  Index name not found.");
		add(6227  , 10 , "%s  Log Scan.");
		add(6228  , 10 , "Cursor name '%.*s' is declared on procedure '%.*s'.");
		add(6229  , 10 , "Cursor name '%.*s' is declared at nesting level '%d'.");
		add(6230  , 10 , "The cursor is positioned after the last row.");
		add(6231  , 10 , "The current cursor position has been deleted.");
		add(6232  , 10 , "The cursor is positioned before the next row.");
		add(6233  , 10 , "The cursor is positioned on a row.");
		add(6234  , 10 , "There have been %d rows read, %d rows updated and %d rows deleted through this cursor.");
		add(6235  , 10 , "The cursor is not open.");
		add(6236  , 10 , "The cursor will be closed if the current position is deleted.");
		add(6237  , 10 , "The cursor will be closed when a transaction is committed or rolled back.");
		add(6238  , 10 , "The cursor will remain open when a transaction is committed or rolled back.");
		add(6239  , 10 , "The number of rows returned for each FETCH is %d.");
		add(6240  , 10 , "The cursor is read only.");
		add(6241  , 10 , "The cursor is updatable.");
		add(6242  , 10 , "There are %d columns returned by this cursor.");
		add(6243  , 10 , "The result columns are:");
		add(6245  , 10 , "Name = '%.*s', 'Expression Result', Type = %s, Length = %d (%S_MSG)");
		add(6246  , 10 , "Name = '%.*s', Table = '%.*s', Type = %s, Length = %d (%S_MSG)");
		add(6247  , 10 , "The cursor was opened with these parameters:");
		add(6248  , 10 , "%s");
		add(6249  , 10 , "There are no active cursors.");
		add(6250  , 10 , "There are no active cursors that match the search criteria.");
		add(6251  , 10 , "This cursor is declared within a stored procedure. The cursor's memory usage cannot be distinguished from that of the procedure as a whole.");
		add(6252  , 10 , "This cursor is declared on a stored procedure. It is presently using '%d' bytes. However, the memory usage will increase when the cursor is opened because the query plan will be associated with the cursor at that time.");
		add(6253  , 10 , "This cursor is declared on a stored procedure. It is using %d bytes of memory. The procedure's plan (%d bytes) will be returned to the procedure cache when the cursor is closed.");
		add(6254  , 10 , "This cursor is using %d bytes of memory.");
		add(6255  , 10 , "The cursor id is %d.");
		add(6256  , 10 , "The cursor has been successfully opened %d times.");
		add(6257  , 10 , "The cursor was closed by a CLOSE CURSOR statement.");
		add(6259  , 10 , "The cursor was closed because its current scan position could not be maintained following a delete, update or insert.");
		add(6260  , 10 , "The cursor was closed because it was declared on a join and its current position was deleted.");
		add(6261  , 10 , "The cursor was closed due to an error on the OPEN CURSOR statement.");
		add(6262  , 10 , "The cursor was closed because CLOSE ON ENDTRAN was SET ON and the transaction containing the cursor ended.");
		add(6263  , 10 , "The cursor is read only because it is declared on a union.");
		add(6264  , 10 , "The cursor is read only because it is declared on a group by or its plan includes a group by operation.");
		add(6265  , 10 , "The cursor is read only because it contains a DISTINCT.");
		add(6266  , 10 , "The cursor is read only because it contains an aggregate.");
		add(6267  , 10 , "The cursor is read only because it contains an ORDER BY clause.");
		add(6268  , 10 , "Showplan output for the cursor:");
		add(6269  , 10 , "The cursor is currently scanning at isolation level 0.");
		add(6270  , 10 , "The cursor is currently scanning at a nonzero isolation level.");
		add(6271  , 10 , "The cursor was compiled at isolation level %d.");
		add(6272  , 10 , "%s  Using I/O Size %d Kbytes for index leaf pages.");
		add(6273  , 10 , "%s  With %S_MSG Buffer Replacement Strategy for index leaf pages.");
		add(6274  , 10 , "%s  Evaluate Grouped %s.");
		add(6275  , 10 , "%s  Evaluate Ungrouped %s.");
		add(6276  , 10 , "%s  Forward Scan.");
		add(6277  , 10 , "%s  Backward scan.");
		add(6278  , 10 , "%s  Positioning at start of table.");
		add(6279  , 10 , "%s  Positioning at end of table.");
		add(6280  , 10 , "%s  Positioning by Row IDentifier (RID).");
		add(6281  , 10 , "%s  Positioning by key.");
		add(6282  , 10 , "%s  Positioning at index start.");
		add(6283  , 10 , "%s  Positioning at index end.");
		add(6284  , 10 , "%s  Scanning only the last page of the table.");
		add(6285  , 10 , "%s  Scanning only up to the first qualifying row.");
		add(6286  , 10 , "%s  Index contains all needed columns. Base table will not be read.");
		add(6287  , 10 , "%s  Keys are:");
		add(6288  , 10 , "%s    %.*s %S_MSG");
		add(6289  , 10 , "QUERY PLAN FOR STATEMENT %d (at line %d).");
		add(6290  , 10 , "MRU");
		add(6291  , 10 , "LRU");
		add(6292  , 10 , "        Using %d Matching Index Scans");
		add(6401  , 16 , "Cannot rollback %.*s - no transaction or savepoint of that name found.");
		add(6402  , 20 , "Inconsistency in rollback logic. ROLLBACK finds no matching SAVE TRANsaction or BEGIN TRANsaction. ROLLBACK aborted.");
		add(6403  , 20 , "No matching savexact record found when rolling back the subordinate transaction %.*s.");
		add(6404  , 18 , "Process %d in database '%.*s' was aborted. The transaction was rolled back, but an ENDXACT record was not written, probably because the log is full.");
		add(6405  , 16 , "The timestamp (%d) in the page header, partition ID %d is incorrect. This value cannot be more than current database timestamp.");
		add(6406  , 10 , "Processed %d/%d extents. %d%% completed.");
		add(6500  , 10 , "DB Mount: Unable to locate device with virtual device number %d in sysdevices table of database '%.*s'.");
		add(6501  , 10 , "DB Mount: Unable to locate a device '%.*s' in sysdevices table of database '%.*s'.");
		add(6502  , 10 , "DB Mount: Unable to use database in boot sequence for database '%.*s' on the device with virtual device number %d.");
		add(6503  , 10 , "DB Mount: Unable to open the table '%.*s' in database '%.*s'.");
		add(6504  , 10 , "DB Mount: Unable to lock the sysusages table in database '%.*s'.");
		add(6505  , 10 , "DB Mount: Unable to begin a transaction in database '%.*s'.");
		add(6506  , 10 , "DB Mount: Unable to insert row in table '%.*s' of database '%.*s'.");
		add(6507  , 10 , "DB Mount: Unable to update table '%.*s' of database '%.*s'.");
		add(6508  , 10 , "DB Mount: Unable to start transaction in database '%.*s'.");
		add(6509  , 10 , "DB Mount: Unable to update the sysusages table during mount operation.");
		add(6510  , 10 , "DB Mount: Unable to update for database %d the sysattributes table of database '%.*s'.");
		add(6511  , 10 , "DB Mount: Unable to recover or bring online the database '%.*s' after mount operation.");
		add(6512  , 10 , "DB Mount: The device name '%.*s' must be less than 23 characters.");
		add(6513  , 10 , "DB Mount: Unable to open the device '%.*s'.");
		add(6514  , 10 , "DB Mount: Unable to extract metadata from device '%.*s'.");
		add(6515  , 10 , "DB Mount: No virtual devices are available.");
		add(6516  , 10 , "DB Mount: Unable to locate the master device in the virtual device number %d.");
		add(6517  , 10 , "DB Mount: Unable to locate master database in virtual device number %d.");
		add(6518  , 10 , "DB Mount: This option is not supported.");
		add(6519  , 10 , "DB Mount: Unable to find the database name '%.*s' in mounted master '%.*s'.");
		add(6520  , 10 , "DB Mount:  Not all devices needed for the database '%.*s' are active.");
		add(6521  , 10 , "DB Mount: Performing initial disk init of device '%.*s' for metadata extraction required for mount.");
		add(6522  , 10 , "DB Mount: Performing disk init of device as '%.*s'.");
		add(6523  , 10 , "DB Mount: Database of type master is mounted as '%.*s'.");
		add(6524  , 10 , "DB Mount: Unable to mount database '%.*s' of type master.");
		add(6525  , 10 , "DB Mount: Mounting all the databases in the database '%.*s' of type master.");
		add(6526  , 10 , "DB Mount: Mounting database '%.*s' from database '%.*s' of type master.");
		add(6527  , 10 , "DB Mount: Recovering all mounted databases in the database '%.*s' of type master.");
		add(6528  , 10 , "DB Mount: Recovering mounted database '%.*s'.");
		add(6529  , 10 , "DB Mount: Recovery of mounted database '%.*s' is complete.");
		add(6530  , 10 , "DB Mount: Recovery of mounted database '%.*s' failed.");
		add(6531  , 10 , "DB Mount: Starting failover of companion server.");
		add(6532  , 10 , "DB Mount: Mount of companion master successful.");
		add(6533  , 10 , "DB Mount: Mount of all the database in master_companion is complete.");
		add(6534  , 10 , "DB Mount: Failover of companion server is completed successfully.");
		add(6535  , 10 , "DB Mount: Mount of companion master failed.");
		add(6536  , 10 , "DB Mount: Mount of database in master_companion failed.");
		add(6537  , 10 , "DB Mount: Failover of companion server failed.");
		add(6538  , 10 , "DB Mount: Unable to map %d from sysdevices table in '%.*s' to database '%.*s'.");
		add(6539  , 10 , "DB Mount: Mount of database '%.*s' is complete.");
		add(6540  , 10 , "DB Mount: Unable to read system tables.");
		add(6541  , 10 , "DB Mount: Use database of '%.*s' failed.");
		add(6542  , 10 , "DB Mount: Unable to find the database id %d in mounted master '%.*s'.");
		add(6600  , 16 , "inappropriate variable name: do not allow '' or '_SYS_' prefix for the name of variable or parameter: %.*s.");
		add(6601  , 16 , "You cannot execute a query involving access from T-SQL database and SQLScript database at the same time.");
		add(6701  , 16 , "Could not open dbid %d, object %d.");
		add(6702  , 20 , "Protection hash chain corrupt: element of type UNUSED found in hash chain (dbid %d, object %d, protection type %d, protection status %d, column map %d)");
		add(6706  , 17 , "Insufficient permission cache entries to execute the current statement. Use sp_configure to increase the number of entries.");
		add(6800  , 20 , "Failed to %s '%.*s' for database '%.*s' (dbid %d). Error code = %d. Transaction will be aborted.");
		add(6801  , 20 , "Failed to get a buffer for the new page %u for %.*s in database '%.*s' (dbid %d). Transaction will be aborted.");
		add(6802  , 17 , "Failed to reserve transaction block in %.*s that is %d pages after the last page %u in database '%.*s' because the %s is full (firstpg on disk=%u, lastpg on disk=%u). Use %s to free up some space in the segment, or use %s to increase the size of the %s.");
		add(6803  , 20 , "Failed to reserve or fill the transaction block in database '%.*s' (dbid %d). The transaction (ID=(%u,%d)) will be aborted.");
		add(6804  , 10 , "%s was unable to truncate %s in database '%.*s'. No space was freed.");
		add(6805  , 20 , "Internal Error: Inconsistency was found during parallel query execution with In Memory Row Storage, worker process with spid %d and parent spid %d in database '%.*s'. Please contact SAP technical support.");
		add(6806  , 10 , "The current task (spid %d) needs to allocate %u pages in the %S_MSG for database '%.*s', but only %u pages are available before its last-chance threshold will be crossed. The task will sleep until enough space becomes available.");
		add(6807  , 16 , "Initialization of the cache, '%.*s', failed due to insufficient memory available to allocate %d bytes. Increase the value of 'max memory' configuration parameter and retry.");
		add(6808  , 16 , "Command %s affecting the cache, '%.*s', failed due to insufficient memory available to allocate %lu bytes. Increase the value of 'max memory' configuration parameter and retry.");
		add(6809  , 16 , "Command %s affecting the cache, '%.*s', failed because the cache is in an unexpected state: '%s'.");
		add(6810  , 10 , "Processed ROW STORAGE OFF for %d tables. %d%% completed.");
		add(6811  , 16 , "%s of %s rows failed for partition '%.*s' with partition id %d and indid %d of table '%.*s'.");
		add(6812  , 16 , "Failed to PACK %ld inserted and %ld migrated rows in IMRS for partition '%.*s' with partition id %d and indid %d of table '%.*s'.");
		add(6813  , 10 , "Altered the specified in-memory row storage property (%.*s) for %d tables. %d%% completed.");
		add(6814  , 17 , "Failed to alter the specified in-memory row storage property (%.*s) for table '%.*s.%.*s'. Pending alter for %d tables out of %d tables. Please retry the command.");
		add(6816  , 20 , "Internal error: Data row id (%u, %u) of table '%.*s' in database '%.*s' found in unexpected state '%u'. Please contact SAP technical support.");
		add(6817  , 18 , "In-memory row storage row with '%S_RID' is not a valid %s version.");
		add(6818  , 18 , "In-memory row storage %s with %s ID %d does not exist in RIDMAP page %d.");
		add(6819  , 18 , "In-memory row storage RIDMAP check failed with %ld error(s).");
		add(6820  , 18 , "Expected in-memory row storage %s row with '%S_RID' to not be deleted.");
		add(6821  , 18 , "In-memory row storage allocation page %d does not match the expected value %d in %s structure.");
		add(6822  , 10 , "Processed %d inserted rows, %d migrated rows and %d cached rows in in-memory row storage %s %s.");
		add(6823  , 16 , "%s with the specified or inherited '%s' property is not allowed as either ALTER DATABASE ROW STORAGE OFF or ALTER DATABASE VERSION STORAGE OFF is in progress for this database.");
		add(6901  , 21 , "Overflow on High component of timestamp occurred in database %d. Database table possibly corrupt.");
		add(6902  , 21 , "Page timestamp value falls between the old and new timestamps from log. Page #=%u, object id = %d, page timestamp=%04x %08x. Log: old timestamp=%04x %08x, new timestamp=%04x %08x. Log record marker = (%u, %d).");
		add(6903  , 21 , "High order of timestamp indicates that timestamp structure may be incorrect.");
		add(6904  , 21 , "Mismatch between database table passed and the one found in the system structure when requesting new database timestamp. Database id passed in : %d. System database id : %d.");
		add(6908  , 21 , "During redo the page timestamp value is less than old timestamp from log. Page #=%u, object id = %d, page timestamp=%04x %08x. Log old timestamp=%04x %08x.");
		add(6909  , 21 , "The timestamp (%04x, %08lx) of the transaction that started at date (%S_DATE_LONG) in database '%.*s' (database id '%d') is earlier than the timestamp (%04x, %08lx) of the most recently started transaction.");
		add(6910  , 21 , "The timestamp of database '%.*s' has reached the maximum allowed. The database will be shut down to prevent its timestamp from overflowing. Please contact SAP Technical Support.");
		add(6911  , 16 , "The database option 'allow incremental dumps' cannot be changed while DUMP DATABASE is running. Please, retry when the dump has finished.");
		add(6912  , 16 , "The option 'allow incremental dumps' cannot be changed in master, archive, proxy, imrslog enabled nor temporary databases.");
		add(6913  , 16 , "DUMP DATABASE %.*s FULL is unable to clear the list of changed database pages. Future incremental dumps will be unnecessarily large until the next successful full DUMP DATABASE.");
		add(6914  , 16 , "The parameter '%.*s' is not a valid dump type.");
		add(6915  , 16 , "The paramater '%.*s' is not a valid built-in operation.");
		add(6916  , 16 , "This command can only be executed on a database where 'allow incremental dumps' is enabled and the database has been fully dumped at least once.");
		add(6917  , 16 , "Internal Error: Process %d attempted to get a lock on SYSDAMS while holding %d already. A process can hold a maximum of %d locks of this type.");
		add(6918  , 21 , "The SYSDAMS page that stores the state of page %d in database '%.*s' could not be found. The option 'allow incremental dumps' will be disabled because ASE cannot continue recording page modifications. Please contact SAP Technical Support.");
		add(6919  , 16 , "The allocation of new extents for %s has failed in database '%.*s'. The option 'allow incremental dumps' will be disabled because ASE cannot continue recording page modifications. Please contact SAP Technical Support.");
		add(6920  , 18 , "The SYSDAM manager has failed to allocate %d bytes. The option 'allow incremental dumps' will be disabled because ASE has missed recording some page modifications. Please contact SAP Technical Support.");
		add(6921  , 16 , "Internal Error: Process %d attempted to get a lock on SYSIMRSLOGS while holding %d already. A process can hold a maximum of %d locks of this type.");
		add(6922  , 16 , "Page %u is not a valid %s page.");
		add(6923  , 18 , "DUMP DATABASE %.*s is unable to initialize the list of changed database pages. It will not be possible to perform any incremental dump until the next successful full DUMP DATABASE.");
		add(6924  , 22 , "The chain of database fragments used by the Sysimrslogs table seems corrupted. A scan of the table would result in an infinite loop. The command will be aborted. Please contact SAP Technical Support.");
		add(6925  , 18 , "Internal error: The command has been aborted because we failed to acquire a lock on SYSIMRSLOGS.");
		add(6926  , 18 , "The command has been aborted because some concurrent operation has invalidated the database disk map. Please, retry the command later.");
		add(6927  , 18 , "The command has been aborted because we could not save the database disk map in SYSUSAGES in the master database.");
		add(6928  , 18 , "Internal error: The entry %d in the array of unreserved pages that corresponds to the disk fragment starting at page %u is missing.");
		add(6929  , 16 , "The oldest inserted transaction id (%u, %u) in database '%.*s' is not valid. DUMP TRAN will not deallocate unused SYSIMRSLOGS pages. This value has been set to th e beginning of SYSIMRSLOGS to avoid further errors.");
		add(6930  , 16 , "The expected imrslog segment map %d has been reused while the database '%.*s' was being created. This is fatal error and the database will be dropped. Please, retry the command.");
		add(6931  , 22 , "The table '%s' with ID %d in database '%.*s' is corrupt. Page %u is linked to page %u that either is out of the database boundary or belongs to an invalid fragment. Contact SAP Technical support for assistance.");
		add(6932  , 16 , "Warning: The table %s in database '%.*s' has %d extents allocated, but the database size indicates %d extents are needed. Please contact Technical Support for assistance.");
		add(6933  , 21 , "Internal error occurred when trying to log %d bytes for an %s record in page %u at offset %d in database '%.*s'. The highest usable offset for transaction ID %S_SID is %d. Contact SAP Technical Support for assistance.");
		add(7001  , 16 , "A transaction attempted on external table.");
		add(7002  , 16 , "Attempt to open VOS file failed");
		add(7003  , 16 , "Attempt to close VOS file failed");
		add(7004  , 16 , "Attempt to sequential_read VOS file failed");
		add(7005  , 16 , "Segment names must be non-null.");
		add(7006  , 16 , "External table file name error");
		add(7007  , 16 , "Illegal datatype for external table");
		add(7008  , 16 , "NULL not allowed for external table");
		add(7009  , 16 , "Create unique index and create clustered index are not allowed for external tables.");
		add(7010  , 16 , "No index named '%.*s' exists on the OS file for external table '%.*s'.");
		add(7011  , 16 , "Attempt to get file status for external table failed.");
		add(7012  , 16 , "External table - skipped.");
		add(7013  , 10 , "Create database feature is disabled.");
		add(7014  , 10 , "Drop database feature is disabled.");
		add(7015  , 10 , "Alter database feature is disabled.");
		add(7016  , 10 , "Only money(19, 4) is allowed for non-external tables.");
		add(7017  , 10 , "The %s (%d) for datatype '%.*s' must be within the range %d to %d.");
		add(7018  , 20 , "Bad offset (%d) should be (%d) for external table column.");
		add(7019  , 20 , "No conversion buffer available for conversion, fatal error.");
		add(7020  , 16 , "Attempt to bulk copy into an external table.");
		add(7021  , 16 , "The embedded_key index type must be used when creating a VOS index for external tables.");
		add(7022  , 16 , "Descending order not allowed in the VOS index used for external tables, use ascending order.");
		add(7023  , 16 , "The argument duplicates_allowed must be true in the VOS index for external tables.");
		add(7024  , 16 , "The collation_code argument must be ascii or numeric when creating a VOS index for extgernal tables.");
		add(7025  , 20 , "Process not running on engine with attached ports for external table during external table scan.");
		add(7026  , 16 , "External tables index file name '%.*s' is too long. Maximum length is %d.");
		add(7027  , 16 , "Signature '%08x' in file '%.*s' is not valid. This file appears to be corrupt.");
		add(7028  , 20 , "I/O failure: %S_MSG '%.*s' failed.");
		add(7029  , 16 , "Data for %S_MSG '%.*s' is incompatible between file and table. This file cannot be used to load this table.");
		add(7101  , 17 , "Unable to allocate new text value, dbid %d.");
		add(7105  , 22 , "TEXT/IMAGE/UNITEXT page %u does not have a next page. Either there is a suspect text page chain, or transaction isolation level 'read uncommitted' has been set. Database %.*s, table %.*s, first text page %u.");
		add(7109  , 22 , "Unexpected log record of type %d found while processing TEXT/IMAGE/UNITEXT data.");
		add(7112  , 16 , "Deadlock occurred while trying to lock page %u, which is held by process %d.");
		add(7114  , 22 , "Page %u is not a valid text page, which belongs to object ID %d, database ID %d.");
		add(7120  , 22 , "Log record %d:%d was not found in the LOG.");
		add(7121  , 22 , "Free offset %d is invalid on page %u.");
		add(7123  , 16 , "Invalid text pointer value %s. This text pointer references first text page %u, which belongs to object ID %d.");
		add(7124  , 16 , "The offset and length specified in the READTEXT command is greater than the actual data length of %d.");
		add(7125  , 16 , "Text pointer value %s conflicts with the column name specified. This text pointer references first text page %u, which belongs to object ID %d.");
		add(7126  , 16 , "Text pointer value %s references a data page with an invalid text status. This text pointer references first text page %u, which belongs to object ID %d.");
		add(7127  , 16 , "Text pointer value %s references a data page with an invalid time stamp. This text pointer references first text page %u, which belongs to object ID %d.");
		add(7128  , 16 , "Text pointer value %s references a data page which is no longer allocated. This text pointer references first text page %u, which belongs to object ID %d.");
		add(7129  , 16 , "Synchronization time stamp does not agree with text data page value.");
		add(7130  , 16 , "WRITETEXT with no log is not valid at this time. Database %.*s must first be configured for this.");
		add(7131  , 16 , "Invalid table and column name specified in textvalid function.");
		add(7132  , 16 , "Selection of TEXT and IMAGE datatypes require DBLIB 4.0 or greater.");
		add(7133  , 16 , "NULL textptr passed to %s function.");
		add(7134  , 16 , "The text table and the table referenced by the text pointer value %s disagree. This text pointer references first text page %u, which belongs to object ID %d.");
		add(7136  , 16 , "ASE is now using a multi-byte character set, and the TEXT character counts have not been re-calculated using this character set for table '%.*s'. Use DBCC FIX_TEXT on this table before running the query again.");
		add(7137  , 20 , "Textptr Write Failed: An error occured while attempting to write TEXT/IMAGE/UNITEXT replication information for database %.*s, table %.*s, column %.*s. Please contact SAP Technical Support for assistance. ( page %u, datapage %u, datarow %d )");
		add(7138  , 20 , "Text/Image Replication Failure: A memory allocation error occured during replication of table %.*s, in database %.*s. Try restarting ASE with a larger procedure cache, or contact SAP Technical Support.");
		add(7139  , 16 , "Insert to a TEXT/IMAGE column from a non TEXT/IMAGE field which involves internal worktable (eg. orderby, groupby) processing is not supported. Rewrite your query to avoid conversion from non TEXT/IMAGE datatype to TEXT/IMAGE datatype.");
		add(7140  , 16 , "A deadlock was detected while attempting to lock the first text page for text pointer %s.");
		add(7141  , 16 , "A lock request was interrupted while attempting to lock the first text page for text pointer %s.");
		add(7142  , 16 , "The text pointer %s refers to a TEXT/IMAGE/UNITEXT page that has been allocated to a different row. This occurred because the original row was updated or deleted during an internal deadlock avoidance manuever.");
		add(7144  , 16 , "Mime pointer %s does not point to a multi-part message.");
		add(7145  , 16 , "Message pointed to by mime pointer %s has less than %d parts.");
		add(7146  , 16 , "Non-zero starting offset can not be used with MIME type.");
		add(7147  , 16 , "Retrieval of partial MIME messages is not supported.");
		add(7148  , 16 , "Feature %s is not implemented.");
		add(7149  , 16 , "Invalid input value (%s) for parameter %s");
		add(7150  , 16 , "MIME message malformed - can't find concluding boundary '--%.*s--'. Insert/Update is aborted.");
		add(7151  , 22 , "Selected message has %d bytes less than expected. Message is probably corrupt. Please contact your system administrator.");
		add(7152  , 16 , "Boundary string specified in 'content-type' header is too long. Maximum allowable length is 70 characters.");
		add(7153  , 16 , "Premature end-of-message received while reading text data from network. Host program may have stopped responding or may be sending text data containing a partial character at the end.");
		add(7154  , 0  , "Unable to log the class/jar definition into the current database's transaction log for replication. Please check the space available in the transaction log.");
		add(7155  , 22 , "The st-node page linkage appears to be broken or corrupt. The command 'dbcc rebuild_text (%d, %d, %d)' can be executed to repair the st-node. (objid=%d, colid=%d, FTP=%d).");
		add(7156  , 16 , "Cannot read text value starting on page %u because it has a different character set than is currently installed. This row needs to be re-inserted to convert it to the current character set. (CSID from tipsa %d, current CSID %d).");
		add(7157  , 16 , "You cannot run the non-logged version of dbcc rebuild_text in this database. Please check with the DBO.");
		add(7158  , 10 , "Non-logged version of dbcc rebuild_text is complete. Please dump your database to ensure recoverability.");
		add(7159  , 10 , "Completed rebuild_text for table '%.*s'.");
		add(7160  , 16 , "The extent for text/image page %u was found to belong to partition ID %d which does not match the expected partition ID %d for this text partition in %S_PTNINFO.");
		add(7163  , 10 , "TEXT/IMAGE data for table '%.*s.%.*s.%.*s' was truncated while processing an isolation level 0 query.");
		add(7164  , 16 , "Text/Image Replication Failure: An index for replication is missing or is in suspect state for column ID = %d, table %.*s, in database %.*s. Run DBCC REINDEX to fix this error.");
		add(7165  , 16 , "Text/Image Replication Failure: Table %.*s, column ID = %d, database %.*s datarow for textpointer %s is missing. Run %s to fix this error.");
		add(7166  , 16 , "Text/Image Replication Failure: Cannot drop index %.*s.%.*s in database %.*s.");
		add(7169  , 18 , "An internal error occurred while decrypting text page %u. Please contact SAP Technical Support.");
		add(7170  , 16 , "You cannot use %s on encrypted TEXT/IMAGE/UNITEXT columns when the CIPHERTEXT option is on.");
		add(7171  , 18 , "The length of encrypted data (%d) on page %u is invalid.");
		add(7172  , 18 , "An internal error occurred while compressing the text value for table %.*s in database %.*s, error code %d (%s). Please contact SAP Technical Support.");
		add(7173  , 18 , "Internal error while decompressing the text value on page %u, dbid %d, error code %d (%s). Please contact SAP Technical Support.");
		add(7174  , 16 , "Create timestamp in textptr (%s) for an in row lob does not match with the create timestamp of the column in the datarow.");
		add(7175  , 16 , "Textptr (%s) for an in row lob either contains an invalid datarow RID or the datarow cannot be read.");
		add(7176  , 16 , "Attempt to insert compressed LOB data into column '%.*s' (colid %d), table '%.*s', database '%.*s' failed because the source data contains invalid attributes (status %d, character set id %d).");
		add(7178  , 16 , "Back link is not set for table %.*s, it must be set for MVCC enabled table to execute readtext/writetext.");
		add(7179  , 20 , "Failed to deallocate text pages starting from page %u.");
		add(7180  , 16 , "Text pointer value %s for column %.*s in table %.*s contains an invalid datarow RID.");
		add(7181  , 10 , "Warning : Database '%.*s' may have text pages with uninitialized TIPSA flags. Run DBCC CHECKDB or DBCC CHECKSTORAGE to validate it.");
		add(7182  , 10 , "Total of %u LOB data versions (%s MB) were removed, %u LOB data versions (%s MB) were skipped.");
		add(7183  , 18 , "LOB garbage collection task failed to read text page ID %d for table '%.*s' with ID %d in database '%.*s'. Execute DBCC IMRS('purge', 'lobvers', '%.*s', 'full') command to reclaim unused space or contact SAP Technical Support for assistance.");
		add(7201  , 17 , "Can't open a connection to site '%S_SRVID' because there are no remote sites available.  Rerun when there are fewer active remote sites, or contact a user with System Administrator (SA) role.");
		add(7202  , 17 , "Can't open a connection to site '%S_SRVID' because there are no available PSS structures.");
		add(7203  , 17 , "Can't open a connection to site '%.*s' because ASE is not configured for enough user connections. See the error log file in the ASE boot directory.");
		add(7204  , 18 , "Can't open a connection to site '%.*s' because the site is already active.");
		add(7205  , 18 , "Can't open a connection to site '%S_SRVID'. See the error log file in the ASE boot directory.");
		add(7206  , 17 , "Can't open a connection to site '%S_SRVID' because all channel numbers are in use.");
		add(7207  , 17 , "Can't open a connection to site '%S_SRVID' because there are no remote connections available. Rerun when there are fewer remote users and/or fewer local users making remote accesses, or contact a user with System Administrator (SA) role.");
		add(7208  , 17 , "Can't open a connection to site '%S_SRVID' because there are no remote logins available.  Rerun when there are fewer local users making remote accesses, or contact a user with System Administrator (SA) role.");
		add(7209  , 17 , "Cannot open a connection to site '%S_SRVID' because %S_MSG buffer could not be initialized.");
		add(7210  , 18 , "Can't open a connection to site '%S_SRVID' because 'set up channel' message could not be sent.");
		add(7211  , 18 , "Can't open a connection to site '%S_SRVID' because 'set up channel' message was not acknowledged.");
		add(7212  , 11 , "Can't close connection %d on site '%S_SRVID' because it is not active.");
		add(7213  , 18 , "Can't remove site '%.*s' from list of active sites because it is missing.");
		add(7214  , 11 , "No site name received in server login packet.  Server login rejected.");
		add(7215  , 18 , "Can't send to site '%S_SRVID'.");
		add(7216  , 18 , "Can't read from site '%.*s'.");
		add(7217  , 18 , "Echo failed from site '%.*s'.");
		add(7218  , 11 , "Site '%.*s' not found in sysservers.");
		add(7219  , 11 , "Site %d not found in sysservers.");
		add(7220  , 11 , "Site '%s' not found in interfaces file.");
		add(7221  , 14 , "Login to site '%S_SRVID' failed.");
		add(7222  , 18 , "Received bad token 0x%x from site '%S_SRVID'.");
		add(7223  , 16 , "Cannot %S_MSG site '%S_SRVID'.");
		add(7224  , 16 , "Unexpected end-of-message encountered in RPC response from site '%S_SRVID'.");
		add(7225  , 16 , "Unknown datatype token %d '%s' encountered.");
		add(7226  , 16 , "Alternate row received for id %d with no corresponding format information.");
		add(7227  , 17 , "Can't open a connection to site '%S_SRVID' because ASE is not configured for remote access. Ask a user with System Administrator (SA) role to reconfigure ASE to allow remote access.");
		add(7228  , 18 , "Received a final DONE packet with DONE_ACK on site '%.*s'.");
		add(7229  , 18 , "Unable to obtain the remote Server's OS Session Label.");
		add(7230  , 18 , "The OS Session Label of the remote Server process does not equal the connection level assigned to it.");
		add(7231  , 18 , "The OS Session Label, curread and curwrite labels of the Client do not equal the connection level for the remote Server.");
		add(7232  , 18 , "Internal MAC Subsystem error. OS Binary to Master SLID Conversion failed.");
		add(7233  , 18 , "Internal MAC Subsystem error. Master SLID to OS Binary Conversion failed.");
		add(7234  , 10 , "Failed to connect to remote server %s %s %s %s %s for site %s. Trying the next query entry of this server, if any.");
		add(7235  , 17 , "No other query entry found for the remote server %s - site %s. Aborting this site handler, as no remote server responded. Please make sure the remote server is accepting connections.");
		add(7238  , 11 , "There was no security mechanism listed in Sysservers catalog for site %s.");
		add(7239  , 17 , "Failed to allocate a security session structure for site %s.");
		add(7240  , 18 , "Mechanism %s is not enabled for use for RPC Model B because the Security Control Layer has not been initialized.");
		add(7241  , 18 , "Security Session establishment failed during Secured RPC Model B login.");
		add(7242  , 18 , "Security Negotiation failed during Secured RPC Model B login.");
		add(7301  , 15 , "FOR UPDATE has been incorrectly specified for a READ ONLY cursor.");
		add(7302  , 15 , "The row number specification for a SET CURSOR ROWS statement must be an integer value greater than 0.The given value is '%d'.");
		add(7303  , 15 , "FOR BROWSE can not be used in the declaration of a cursor.");
		add(7304  , 15 , "FOR READ ONLY can not be used in a SELECT which is not part of the declaration of a cursor or which is not inside a stored procedure.");
		add(7305  , 15 , "FOR UPDATE can not be used in a SELECT which is not part of the declaration of a cursor or which is not inside a stored procedure.");
		add(7306  , 15 , "Table User-Defined Function '%.*s' not found.");
		add(7307  , 15 , "COMPUTE clause can not be used in the declaration of a cursor.");
		add(7308  , 15 , "SELECT-INTO can not be used in the declaration of a cursor.");
		add(7309  , 10 , "SQL statement on line number %d contains %S_MSG. The error is caused due to the use of %s.");
		add(7310  , 10 , "SQL statement on line number %d contains %S_MSG. The error is caused due to the use of non-ANSI option: %S_MSG.");
		add(7311  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of Sybase declared global/local variables.");
		add(7312  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of Sybase built-in function: %.*s.");
		add(7313  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of non-standard control flow: %s.");
		add(7314  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of non-standard transaction key word(s): %S_MSG.");
		add(7315  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of Non-ANSI conversion function(s).");
		add(7316  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of database prefix.");
		add(7317  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of %S_MSG %S_MSG.");
		add(7318  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of Non-ANSI drop object functionality: %S_MSG.");
		add(7319  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of Non-ANSI operator: %S_MSG.");
		add(7320  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of Non-ANSI pattern matching character(s).");
		add(7321  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of column name(s) in a select list with aggregates but column name(s) not in group by list.");
		add(7322  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of set operations in an insert select: %S_MSG.");
		add(7323  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of column headings.");
		add(7324  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of compute statement.");
		add(7325  , 16 , "Nulls not allowed in a primary key column.");
		add(7326  , 10 , "Line number %d contains %S_MSG. The error is caused due to the use of Non-ANSI escaping of '[' or ']' in a LIKE ESCAPE.");
		add(7327  , 10 , "Length or precision specification %d is not within the range of 1 to %d.");
		add(7328  , 10 , "Specified scale %d is not within the range of 0 to 255.");
		add(7329  , 15 , "There are too many parameters given with function '%.*s'.  The maximum number of parameters allowed is %d.");
		add(7330  , 15 , "Within %s, you are not allowed to specify the database name prefix for the new object name in %s.  All new objects must be created in the current database.");
		add(7331  , 15 , "Within %s, you can't create an object owned by another user. The specified object owner is '%.*s', but the schema authorization id is '%.*s'.");
		add(7332  , 15 , "%S_MSG is allowed only in %S_MSG");
		add(7333  , 15 , "%s does not allow specifying the user name as a prefix to the object name.");
		add(7334  , 16 , "Subqueries are not allowed in a RAISERROR.");
		add(7335  , 15 , "A SELECT statement that assigns a value to a variable must not be combined with a COMPUTE clause.");
		add(7336  , 10 , "Line number %d contains non-ANSI identifier. Length of identifier '%.*s' is greater than 18.");
		add(7337  , 10 , "FIPS WARNING: Truncation when inserting long char/varchar/unichar/univarchar into shorter char/varchar/unichar/univarchar.");
		add(7338  , 10 , "FIPS WARNING: Union of exact numeric with different precision or scale.");
		add(7339  , 10 , "FIPS WARNING: Union of chars or of literals with different lengths.");
		add(7340  , 10 , "FIPS WARNING: Union of chars with literal.");
		add(7341  , 10 , "FIPS WARNING: Inserted approximate numeric into exact numeric.");
		add(7342  , 15 , "Keyword SHARED can not be used in a SELECT statement which is not part of the declaration of a cursor.");
		add(7343  , 15 , " The value (%d) given to the %S_MSG is not within the allowed range. The allowed range is between %d and %d.");
		add(7344  , 16 , "DECLARE CURSOR must be the only statement in a query batch.");
		add(7345  , 16 , "SELECT is not allowed in a dynamic EXECUTE IMMEDIATE statement.");
		add(7346  , 16 , "Invalid arguments for RAISERROR extended error data.");
		add(7347  , 16 , "The IDENTITY function should be used only when the SELECT statement has an INTO clause.");
		add(7348  , 16 , "Select expression results in more than one column having same name. Column name '%.*s' is specified more than once");
		add(7349  , 16 , "FIPS WARNING: Due to usage of the name of an expression in the ORDER BY clause which has a correlation name in the select list");
		add(7350  , 16 , "FIPS_WARNING: Use of implicit or explicit ALL in COUNT aggregate function. Only COUNT(*) or COUNT( DISTINCT <expression> ) is allowed.");
		add(7351  , 16 , "Local or global variables not allowed in %S_MSG");
		add(7352  , 16 , "The SET option with ARITH_OVERFLOW is allowed only in SET ARITHABORT or SET ARITHIGNORE.");
		add(7353  , 16 , "The SET option with NUMERIC_TRUNCATION is allowed only in SET ARITHABORT.");
		add(7354  , 16 , "The SET can have option restrictions only when there is one option in the command.");
		add(7355  , 16 , "Table (or view) '%.*s' created by SELECT INTO or CREATE VIEW results in a column with no name.  Please specify a column name for computed columns.");
		add(7356  , 16 , "Aggregates or subqueries are not allowed in check constraints.");
		add(7357  , 15 , "Label options (CURREAD, CURWRITE) cannot be used with non-label SET options in a single SET commmand.");
		add(7358  , 16 , "Invalid type argument specified for the %s builtin function. Argument must either be SENSITIVITY or SENSITIVITY_BOUNDARY.");
		add(7359  , 16 , "SYB_IDENTITY is not allowed in READ or WRITE TEXT commands.");
		add(7360  , 16 , "Explicit updates/inserts cannot be done on sensitivity or information columns.");
		add(7361  , 16 , "FIPS WARNING: GROUP BY clause specified when all the items in select list are aggregate functions or none of the items in select list are aggregate functions.");
		add(7362  , 16 , "FIPS WARNING: Select list contains aggregate function(s) but GROUP BY clause not specified.");
		add(7363  , 16 , "You can not have variable assignments in a SELECT statement with the UNION operation.");
		add(7364  , 16 , "Tables '%.*s' and '%.*s' have same exposed names. Use correlation names to distinguish them.");
		add(7365  , 16 , "A column in the FOR UPDATE OF list can only be qualified by a table or correlation name. Column '%.*s' is qualified by an table owner and/or database name.");
		add(7366  , 16 , "A column in the FOR UPDATE OF list can only be qualified by an exposed table or correlation name. '%.*s' is not an exposed name in the select statement.");
		add(7367  , 16 , "Expected row size '%d' is not a valid value; expected row size must be greater than 9 or can be either 0 or 1.");
		add(7368  , 16 , "Can not create column by name 'SYB_IDENTITY_COL'. This name has special meaning when 'auto_identity' option is ON.");
		add(7369  , 15 , "Procedure Grouping is not allowed.");
		add(7370  , 16 , "Specified precision %d is more than the maximum precision %d.");
		add(7371  , 16 , "Specified scale %d is more than the specified precision %d.");
		add(7372  , 15 , "A SELECT FOR UPDATE statement within or outside of a cursor context cannot be specified at isolation level 0.");
		add(7373  , 15 , "Browse mode cannot be specified at isolation level 0.");
		add(7374  , 15 , "Invalid isolation level specified.");
		add(7375  , 15 , "SELECT INTO cannot be specified with isolation level clause.");
		add(7376  , 15 , "Select in a CREATE VIEW cannot be specified with isolation level clause.");
		add(7377  , 15 , "SELECT INSERT cannot be specified with isolation level clause.");
		add(7378  , 15 , "HOLDLOCK/NOHOLDLOCK/SHARED/READPAST conflicts with AT ISOLATION LEVEL 0.");
		add(7379  , 14 , "Permission denied. You must have the 'Replication' role to set %.*s ON or OFF. Please contact a user with System Security Officer (SSO) role for help.");
		add(7380  , 10 , "WARNING: Line %d. Invalid value for '%S_MSG' specified.  This value will be ignored, default value will be used instead.");
		add(7381  , 10 , "prefetch size");
		add(7382  , 16 , "Subqueries are not allowed in an ORDER BY clause.");
		add(7383  , 16 , "Subqueries are not allowed in a GROUP BY clause.");
		add(7384  , 16 , "Subqueries are not allowed in a COMPUTE clause.");
		add(7385  , 16 , "The number of subqueries in the query exceeds the maximum allowed (%d).");
		add(7386  , 10 , "Set dup_in_subquery is no longer supported. To get similar performance and semantics, rewrite the subquery as a join.");
		add(7387  , 15 , "The maximum number of parameters in a dynamic SQL statement is %d.");
		add(7388  , 16 , "An aggregate of an aggregate produces a scalar value. Any further nesting of aggregates has no effect. Remove the aggregates beyond level two.");
		add(7389  , 16 , "A HAVING clause with aggregates of different levels is not allowed.");
		add(7391  , 15 , "The table count specification for a SET TABLE COUNT statement must be an integer value greater than 0. The given value is '%d'.");
		add(7392  , 15 , "Procedure Grouping is not allowed. Please contact a user with System Security Officer (SSO) role for help.");
		add(7393  , 16 , "The value of forced parallel degree cannot be negative.");
		add(7394  , 15 , "Duplicate specification of '%S_MSG' clauses for one table is not allowed.");
		add(7395  , 10 , "forced index");
		add(7396  , 10 , "forced parallel");
		add(7397  , 10 , "forced lru/mru");
		add(7398  , 10 , "forced prefetch");
		add(7399  , 15 , "Reserved page gap '%d' is not a valid value; reserved page gap must be between 0 and 255");
		add(7401  , 10 , "Could not allocate memory for the threshold task's argument list; threshold task cannot be spawned for database %d, segment %d, free space %u.");
		add(7402  , 10 , "Could not spawn the threshold handler procedure for database %d, segment %d, when only %u free pages were left in the segment.");
		add(7403  , 10 , "Threshold task could not use database %d, and so cannot execute the threshold procedure for segment %d, free space %u.");
		add(7404  , 10 , "Could not find row in systhresholds for database %.*s describing segment %d, free space %u.");
		add(7405  , 10 , "Threshold procedure name is missing from the systhresholds row in database %.*s for segment %d, free space %u.");
		add(7406  , 16 , "%s: unknown option: %.*s");
		add(7407  , 10 , "Failed to execute the threshold procedure for database %d, segment %d, free space %u.");
		add(7408  , 20 , "Could not find a dbtable for database %d.");
		add(7409  , 20 , "This task tried to sleep waiting for space to become available in the segment '%.*s', but could not. The current command is being aborted because no further database changes can be logged.");
		add(7410  , 26 , "%s: function called with invalid argument.");
		add(7411  , 18 , "The 'Systhresholds' table in database '%.*s' is not in its correct sort order. Its clustered index needs to be rebuilt using 'sp_fixindex'. Only the last chance threshold has been activated.");
		add(7412  , 10 , "Space available in segment '%.*s' has fallen critically low in database '%.*s'. All future modifications to this database will be %S_MSG until the %S_MSG is successfully dumped and space becomes available.");
		add(7413  , 10 , "%d task(s) are sleeping waiting for space to become available in the segment '%.*s' for database '%.*s'.");
		add(7414  , 10 , "Threshold procedure '%.*s' returned an error indication (@status=%d) when called for database '%.*s', segment '%.*s', free_space %u.");
		add(7415  , 10 , "The %S_MSG in database %.*s is almost full. Your transaction is being %S_MSG until space is made available in the log.");
		add(7416  , 20 , "Could not open Systhresholds table for database %.*s.");
		add(7417  , 21 , "The last chance threshold entry for logsegment is not present in threshold cache for database '%S_DBID'. Please use 'dbcc thresholds' to see the threshold cache contents and contact your system administrator.");
		add(7418  , 22 , "The last chance threshold entry for logsegment is not present in systhresholds table for database '%S_DBID'. Please contact your system administrator.");
		add(7419  , 16 , "lct_admin(abort): Process %d that you are trying to abort is not a valid process. Choose a process with id between %d and %d.");
		add(7420  , 16 , "lct_admin(abort): Cannot abort yourself. Your process id %d and the given process id %d.");
		add(7421  , 16 , "lct_admin(abort): Process %d is not an active process. Cannot abort it.");
		add(7422  , 16 , "lct_admin(abort): Process %d is not an user process. Only an user process waiting on log-suspend mode can be aborted.");
		add(7423  , 10 , "lct_admin(abort): Process %d waiting on log-suspend state on database '%S_DBID is being aborted.");
		add(7424  , 16 , "lct_admin(abort): Cannot abort process %d, as it is not sleeping on log-suspend state in database '%S_DBID'.");
		add(7425  , 16 , "lct_admin(unsuspend): This command is not supported anymore. If you want to abort the tasks sleeping on log-suspend state, please consider using lct_admin(abort).");
		add(7426  , 16 , "lct_admin(abort): Database '%S_DBID' did not reach the last chance threshold. This command will have no effect on the database.");
		add(7428  , 17 , "Could not add the last chance threshold for database '%S_DBID'.");
		add(7429  , 16 , "Database '%.*s' contains too many thresholds. It may contain at most %d thresholds. Drop thresholds as required to bring the database below the limit.");
		add(7433  , 10 , "Hit %s on database '%S_DBID' for %s segment during upgrade. Not spawning threshold action procedure.");
		add(7434  , 16 , "lct_admin('unsuspend') is no longer supported. We recommend that you use the KILL command to stop suspended processes. You may wake individual processes using lct_admin('wakeup', <spid>).");
		add(7435  , 16 , "lct_admin(abort): Process %d is a child-process. Cannot abort it.");
		add(7436  , 18 , "lct_admin(abort): Unable to obtain DBTABLE for process %d. Cannot abort it.");
		add(7437  , 16 , "lct_admin(abort): Your process, with process ID %d, is now being aborted by administrator request. It has been waiting in log-suspend state in database '%S_DBID'.");
		add(7438  , 21 , "The threshold cache for the database '%.*s' (%d) is corrupt. Please use dbcc dbrepair with option 'newthreshold' to rebuild the threshold cache of the database.");
		add(7440  , 20 , "Command aborted due to failure to allocate a message on %S_INSTID for peer-to-peer communication. Increase the 'cipc regular message pool size' configuration parameter and reissue the command.");
		add(7441  , 18 , "Warning: Cluster threshold manager failed to send multicast message '%s' from %S_INSTID to instance map %p because one of the destination instances failed. The free space counts will be recovered as part of instance failure recovery.");
		add(7442  , 18 , "Warning: Cluster threshold manager failed to send message '%s' from %S_INSTID to %S_INSTID because destination instance failed. Free space counts will be recovered by instance failure recovery.");
		add(7443  , 20 , "Cluster threshold manager failed to acquire %s due to %s in database %.*s (%d) on %S_INSTID. This may cause incorrect free space counts in the database. To rebuild free space counts, use DBCC DBREPAIR with the 'remap' option.");
		add(7444  , 20 , "Cluster threshold manager on %S_INSTID failed to communicate with other instance to perform %s due to internal error %d for database %.*s (%d). To rebuild free space counts, use DBCC DBREPAIR with the 'remap' option.");
		add(7445  , 20 , "Cluster threshold manager failed to perform requested task %s on %S_INSTID for database %.*s (%d) due to error %d. See the instance error log for more detail.");
		add(7446  , 17 , "Cluster threshold manager failed to allocate %d bytes of memory on %S_INSTID to hold the transferred data for database %.*s (%d).");
		add(7447  , 17 , "Cluster threshold manager: Cannot open database %d on %S_INSTID to %s.");
		add(7448  , 18 , "Warning: Cluster threshold manager failed to rebuild segment free page counts for database %.*s (%d) because an instance failure occurred in the cluster. The free space counts will be recovered as part of instance failure recovery.");
		add(7449  , 20 , "Cluster threshold manager failed to open transaction for database %S_DBID. Command aborted.");
		add(7450  , 20 , "Cluster threshold manager failed to get exclusive access to end of log for database %S_DBID. Command aborted.");
		add(7451  , 20 , "Cluster threshold manager failed to rebuild log segment free page counts for database %.*s(%d) because log space info on dbinfo page is invalid. To rebuild free space counts, use DBCC DBREPAIR with the 'findstranded' option.");
		add(7452  , 10 , "Failed to find specified threshold in threshold cache on instance %d for database %.*s (%d), segment %d, free space %u. Use 'dbcc thresholds' to see the threshold cache contents.");
		add(7453  , 20 , "The cluster threshold manager on %S_INSTID failed to communicate with another instance to perform %s due to internal error %d.");
		add(7454  , 20 , "Cluster threshold manager failed to perform requested task %s on %S_INSTID due to error %d. See the instance error log for more detail.");
		add(7455  , 13 , "Your server command (family id #%d, process id #%d) has encountered a deadlock because threshold manager recovery has not completed yet for database %.*s (%d) following an instance failure. Re-run your command when recovery has finished.");
		add(7456  , 10 , "The 'enforce dump tran sequence' database option is invalid for the mixed log-and-data database '%.*s' and will be turned off.");
		add(7457  , 18 , "An incorrect page count in one or more OAM entries has forced the free space counts for the data segment to be calculated using a less optimal method. Run DBCC CHECKALLOC(%.*s, fix) to fix the OAM counts.");
		add(7458  , 10 , "An incorrect page count in one or more OAM entries was found when calculating free space. Run DBCC CHECKALLOC(%.*s, fix) to fix the OAM counts.");
		add(7459  , 16 , "The attempt to create the stored procedure '%.*s' has failed.");
		add(7460  , 16 , "The update of a threshold in database '%.*s' for segment '%.*s', threshold procedure '%.*s', at free space %d pages, has failed.");
		add(7601  , 14 , "Permission denied.  System Security Officer (SSO) role is required to open an auditing system table.");
		add(7602  , 16 , "There is no such audit option. If you received this message while executing a SAP-supplied auditing stored procedure, this is a system error, and you should contact a user with System Administrator (SA) role.");
		add(7603  , 14 , "The ad_hoc_audit builtin function cannot be called directly.  You must use sp_addauditrecord to send an ad-hoc audit record.");
		add(7604  , 20 , "An unknown audit event type was received.  This is a system error.  Contact a user with System Security Officer (SSO) role.");
		add(7605  , 20 , "An attempt to send a message to the audit process has failed.  This is a system error.  Contact a user with System Security Officer (SSO) role.");
		add(7606  , 20 , "An attempt to allocate memory for the audit %S_MSG has failed. This is a system error. Contact a user with System Security Officer (SSO) role.");
		add(7607  , 20 , "An attempt to establish a system mailbox for the audit process has failed.  This is a system error.  Contact a user with System Security Officer (SSO) role.");
		add(7608  , 20 , "An attempt to open the sybsecurity database has failed.  This is a system error.  Contact a user with System Security Officer (SSO) role.");
		add(7609  , 20 , "An attempt to load the global audit options into sysauditoptions has failed.  This is a system error.  Contact a user with System Security Officer (SSO) role.");
		add(7610  , 20 , "An attempt to open the sysaudits table has failed.  This is a system error.  Contact a user with System Security Officer (SSO) role.");
		add(7611  , 20 , "An attempt to awaken the server initialization process has failed.  This is a system error.  Contact a user with System Security Officer (SSO) role.");
		add(7612  , 20 , "An attempt to get an audit record from the audit queue has failed.  This is a system error.  Contact a user with System Security Officer (SSO) role.");
		add(7613  , 14 , "Permission denied.  System Security Officer (SSO) role is required to create or drop the sybsecurity database.");
		add(7614  , 14 , "Permission denied.  System Security Officer (SSO) role is required to create an auditing system table.");
		add(7615  , 16 , "The auditing system tables can only be created in the sybsecurity database.");
		add(7616  , 16 , "You can only use SELECT or SELECT INTO with the sysaudits table.");
		add(7617  , 20 , "An attempt to get a free audit record buffer from the audit queue has failed.  This is a system error.  Contact a user with System Security Officer (SSO) role.");
		add(7618  , 20 , "The audit process is not currently active. Contact a user with System Administrator (SA) or System Security Officer (SSO) role.");
		add(7619  , 20 , "An insert to the sysaudits table has failed. This is a serious error, and you should contact a user with System Administrator (SA) or System Security Officer (SSO) role.");
		add(7620  , 14 , "You must use one of the SAP-supplied auditing stored procedures to change audit options.");
		add(7623  , 20 , "Auditing: Fatal error - unable to get object owner name to fill in the audit record. This is an internal error.");
		add(7624  , 20 , "Auditing: Fatal error - unable to get audit creation flags in the database with dbid '%d'. This is an internal error.");
		add(7625  , 20 , "Audit table number '%d' is invalid.");
		add(7626  , 20 , "Auditing: Internal erorr - could not get the next audit table number.");
		add(7627  , 20 , "Auditing: Fatal error - current audit table is full and server is configured to suspend auditing when device is full, but it failed to suspend the audit process. This is an internal error.");
		add(7628  , 16 , "Invalid value for audit related configuration parameter because the audit subsystem is not running. Contact a user with System Security Officer (SSO) Role.");
		add(7629  , 18 , "Auditing: Internal error - current audit table config parameter value may not be updated in the configuration file and in sysconfigures system table. Accurate value of this parameter is in syscurconfigs system table. This is not a critical error.");
		add(7631  , 16 , "Current audit table can not be changed to '%d' because it is not empty.");
		add(7632  , 16 , "Cannot enable auditing because the 'sybsecurity' database is read-only.");
		add(7633  , 10 , "%s: Could not acquire audit lock. Lock status is %s.");
		add(7634  , 10 , "%s: Audit lock has been granted.");
		add(7635  , 10 , "%s: Audit lock has been released.");
		add(7636  , 16 , "Failed to apply auditing setting on all cluster instances. Please retry your command.");
		add(7701  , 16 , "Overflow when converting from char to type %s, value = '%.*s'.");
		add(7702  , 16 , "Overflow when converting from numeric(%d,%d) to type %s'%.*s', value = '%.*s'.");
		add(7703  , 16 , "Overflow when converting from decimal(%d,%d) to type %s'%.*s', value = '%.*s'.");
		add(7704  , 16 , "Truncation error when converting to exact numeric(%d,%d) from type %s'%.*s', value = '%.*s'.");
		add(7705  , 10 , "Invalid pattern string. The character following the escape character must be percent sign, underscore, left square bracket, right square bracket, or the escape character.");
		add(7706  , 10 , "Pattern string is too long. The given pattern string '%.*s' is converted using the escape character '%.*s'. The converted string is longer than %d bytes.");
		add(7707  , 10 , "Illegal escape character found. There are fewer bytes than necessary to form a valid character.");
		add(7708  , 10 , "Pattern string is too complex. There are too many blocks requiring special attention for right bracket (]), circumflex (^), or dash (-).");
		add(7709  , 20 , "Server-initiated remote procedure call state error.");
		add(7710  , 20 , "Attempt to retrieve a returned parameter length from a server-initiated stored procedure without specifying the parameter name.");
		add(7711  , 20 , "Parameter not found while trying to retrieve the returned parameter length from a server-initiated stored procedure.");
		add(7712  , 16 , "Stored procedure '%.*s' may be run only in chained transaction mode. The 'SET CHAINED ON' command will cause the current session to use chained transaction mode.");
		add(7713  , 16 , "Stored procedure '%.*s' may be run only in unchained transaction mode. The 'SET CHAINED OFF' command will cause the current session to use unchained transaction mode.");
		add(7714  , 16 , "In a CREATE SCHEMA statement, the authorization id must match the current user name. The supplied authorization id, '%.*s', does not match the current user name, '%.*s'.");
		add(7715  , 18 , "Object '%d' specified as a rule for tabid '%d', colid '%d' does not have a variable node in the tree.");
		add(7716  , 16 , "Cannot convert CHAR value to REAL. The CHAR value has incorrect syntax.");
		add(7717  , 20 , "Attempted to drop temporary table with object id %d, which is not in the temporary object lists for this task.");
		add(7718  , 16 , "The '%s' command is not allowed within a multi-statement transaction in the '%.*s' database.");
		add(7719  , 17 , "There is no memory available to save the current sequencer state -- cannot continue processing this query.");
		add(7720  , 16 , "Update/Delete from a table which is the inner table of an outerjoin is not allowed.  Command aborted.");
		add(7721  , 16 , "Precomputed result set definition error: %s is/are invalid or not allowed; no PRS has been created.");
		add(7722  , 16 , "INSERT/UPDATE/DELETE/SELECT INTO are not allowed on %S_MSG.");
		add(7723  , 16 , "Precomputed result set '%.*s' is marked as suspect and cannot be refreshed. Drop and re-create it.");
		add(7725  , 16 , "Cursor '%.*s' was declared with a FOR UPDATE clause. This cursor was found to be read only.");
		add(7726  , 16 , "Execute cursor '%.*s' is declared on a procedure which has more than one SQL statement. For the declaration of this cursor to be legal the procedure should have a single SELECT statement clause.");
		add(7727  , 26 , "An internal error occurred for the cursor variable '%.*s'. It could not be found on any variable list of the procedure.");
		add(7728  , 14 , "Permission denied.  You must have the following role(s) to execute %.*s :  '%.*s' .  Please contact a user with the appropriate role for help.");
		add(7729  , 16 , "Invalid role string '%.*s' entered.");
		add(7730  , 14 , "SET ROLE fails.  The caller is not granted with the specified '%.*s' role.  Please contact a user with System Security Officer (SSO) role for help.");
		add(7731  , 16 , "SET ROLE fails.  The caller cannot assume the new user identity (uid) in the current database.  Please contact a user with System Security Officer (SSO) role for help.");
		add(7732  , 16 , "The UPDATE/DELETE WHERE CURRENT OF failed for cursor '%.*s' because the cursor is read only.");
		add(7733  , 18 , "Unable to locate the base procedure header (Pss->phdr) which had been switched earlier.");
		add(7734  , 18 , "The search for table name when adding a resdom in s_addident() failed. The resdom for the column '%.*s' did not contain the table name. This is an internal error.");
		add(7735  , 16 , "The specfied row count '%d' for the cursor '%.*s' is invalid. The rowcount should always be greater than zero.");
		add(7736  , 20 , "Unable to find lock request for tabid %d dbid %d. This is an internal error.");
		add(7739  , 18 , "Internal error - SELECT INTO not found, perhaps tree corrupted.");
		add(7740  , 18 , "The declaration for cursor '%.*s' has the column '%.*s' in it's FOR UPDATE list which is not part of the SELECT list for the cursor. Either select that column or remove it from the FOR UPDATE list.");
		add(7741  , 18 , "Internal error - Both SHARED AND UPDLOCK have been set on table '%.s'.");
		add(7742  , 16 , "You must change your password using the ALTER LOGIN command before you can continue.");
		add(7743  , 16 , "An explicit value for the identity field in %.*s '%.*s' can only be specified in an insert statement when a field list is used.");
		add(7744  , 16 , "Illegal attempt to update identity field '%.*s'.");
		add(7745  , 16 , "Attempting to add a new identity field to a table '%.*s', via select into, which would have a field '%.*s' that inherits the identity property.");
		add(7746  , 16 , "Attempting to add more than 1 new identity field to a table '%.*s', via  select into.");
		add(7747  , 16 , "Unable to '%s' for table '%.*s' because IDENTITY_INSERT or IDENTITY_UPDATE is already ON for the table '%.*s' in database '%.*s'.");
		add(7748  , 16 , "Pseudo-column 'SYB_IDENTITY' used incorrectly. No table in the query has the identity property.");
		add(7749  , 16 , "Pseudo-column 'SYB_IDENTITY' used ambiguously. Multiple tables in the query have the identity property.");
		add(7750  , 16 , "Argument type '%s' is invalid for argument %d of '%s' function.");
		add(7751  , 16 , "Unable to '%s' to ON/OFF for table '%.*s' because the object either does not exist or cannot be opened.");
		add(7752  , 16 , "Unable to SET IDENTITY_INSERT or IDENTITY_UPDATE to ON/OFF for table '%.*s' because you are neither the DBO nor the object owner.");
		add(7753  , 16 , "Unable to '%s' to ON/OFF for object '%.*s' because the object is not a user table.");
		add(7754  , 16 , "Operand data type '%s' is invalid for '%s' operator.");
		add(7755  , 18 , "Attempt to switch base procedure header (Pss->phdr) more than once.This is an internal error.");
		add(7756  , 16 , "Cannot use '%s' for table '%.*s' because the table does not have the identity property.");
		add(7757  , 16 , "The order-by position number '%d' is out of range of the number of items in the select-list.");
		add(7758  , 16 , "The declaration for cursor '%.*s' has the column '%.*s' in it's FOR UPDATE OF list which is not updatable after view resolution.");
		add(7759  , 16 , "The declaration for cursor '%.*s' has the column '%.*s' in it's FOR UPDATE OF list which is not updatable because it has the identity property.");
		add(7760  , 16 , "Conversion of security label datatype to char/varchar datatype failed.");
		add(7761  , 16 , "The data type '%s' is invalid for the %s function. Allowed types are: CHAR/VARCHAR and SENSITIVITY/SENSITIVITY_BOUNDARY.");
		add(7762  , 16 , "Trigger label configuration incompatible with user's profile.");
		add(7763  , 16 , "Procedure label configuration incompatible with user's profile.");
		add(7764  , 23 , "Sysobjects entry NOT found for procedure buffer entry.");
		add(7765  , 23 , "Invalid owner curread for view, procedure, or trigger in sysobjects entry.");
		add(7766  , 16 , "A conversion from '%s' label to character string resulted in an overflow.");
		add(7767  , 16 , "THe user's curread label does not dominate the converted label.");
		add(7768  , 16 , "Invalid label syntax.");
		add(7769  , 18 , "Internal conversion error detected while converting to/from '%s' label datatypes.");
		add(7770  , 10 , "Warning: There are other roles currently active.");
		add(7771  , 16 , "Insert into the sensitivity column of table '%.*s' attempted. Explicit inserts into the sensitivity column are not allowed.");
		add(7772  , 18 , "Internal error encountered while processing @@update_mode global variable.");
		add(7773  , 16 , "Execute cursor '%.*s' is declared on a procedure which contains a non-SELECT or a SELECT with a COMPUTE clause. For the declaration of this cursor to be legal it should have a single SELECT statement without a COMPUTE clause.");
		add(7774  , 16 , "The procedure '%.*s' contains a select statement with FOR UPDATE clause. This should be the only statement in the procedure.");
		add(7775  , 16 , "The column '%.*s' in FOR UPDATE list is not part of the SELECT list. Either select that column or remove it from the FOR UPDATE list.");
		add(7776  , 16 , "Transaction to update certification state of object  %S_OBJID, database %S_DBID failed.");
		add(7777  , 16 , "Changing certification state of object %S_OBJID, database %S_DBID to SUSPECT because of change in state of dependent object %.*s (previous object id %d), database %S_DBID.");
		add(7778  , 16 , "Suspect procedure %S_OBJID, database %S_DBID found. Cannot execute query.");
		add(7779  , 16 , "UNCERTIFIED object %S_OBJID, database %S_DBID accessed by CERTIFIED object %S_OBJID, database %S_DBID. Cannot execute query.");
		add(7780  , 16 , "Procedure %S_OBJID, database %S_DBID with labels found UNCERTIFIED. Cannot execute query.");
		add(7781  , 16 , "Suspect view %S_OBJID, database %S_DBID found. Cannot execute query.");
		add(7782  , 16 , "Remote procedure call from within CERTIFIED stored procedure %S_OBJID, database %S_DBID not allowed. Cannot execute query.");
		add(7783  , 10 , "Internal error -- server failed to do garbage collection on this procedure, id = %d. Please save the query tree and procedure text and inform the technical support. This is not a critical error, so server continues processing.");
		add(7784  , 16 , "Illegal escape character found. There are fewer bytes than necessary to form a valid character.");
		add(7785  , 16 , "Attempting to create a table '%.*s', via select into, with column '%.*s' whose numeric precision, %d, exceeds the maximum allowed precision (%d).");
		add(7786  , 16 , "Unable to turn role off as user (suid=%d) is not a valid user in the current database.");
		add(7787  , 16 , "Sensitivity column of view '%.*s' accessed. A view's sensitivity column is not user accessible.");
		add(7788  , 10 , "WARNING: An explicit or implicit HOLDLOCK/NOHOLDLOCK/READPAST was specified for table '%.*s'; however, since this is an isolation level 0 scan, the HOLDLOCK/NOHOLDLOCK/READPAST is ignored.");
		add(7789  , 16 , "Unable to allocate work table for processing group by or distinct clause during query optimization. Maximum limit (%d) of work tables is exceeded. Simplify the query and retry.");
		add(7790  , 18 , "Non-fatal internal error - Unable to remap cursor '%.*s' to cursor '%.*s' during recompilation.");
		add(7791  , 16 , "Unable to remap lockid for table %.*s in database %S_DBID. Printing diagnostic information: tobjp: 0x%p, lkr: 0x%p, rgtabid: %d.");
		add(7792  , 16 , "An isolation level %d scan is being attempted on cursor '%.*s', but the cursor was declared at isolation level %d. You must re-declare the cursor at isolation level %d.");
		add(7793  , 16 , "An isolation level '%d' scan is being attempted by an ad hoc query, but the query was compiled in the batch at isolation level '%d'.");
		add(7794  , 16 , "You cannot scan table '%.*s' at isolation level 0 because another process is running a utility command that is incompatible with level 0 scans. Please retry later.");
		add(7795  , 17 , "Internal error - Unable to process subqueries during transformations. Maximum limit (%d) of subqueries is exceeded. Please save the DBCC TRACE(100) output and inform technical support.");
		add(7796  , 18 , "Internal error - Unable to process subqueries during transformations due to a corrupt query tree. Please save the output from DBCC TRACE(100) and inform technical support.");
		add(7901  , 16 , "Page %u, partition ID %d, is expected to be the first page of a text/image/unitext value.");
		add(7902  , 16 , "Data size mismatch while checking text/image/unitext values. The first page for this value is %u, partition ID %d. %d bytes found; however, the expected data length is %d bytes.");
		add(7903  , 16 , "Link number %d does not indicate that page %u, partition ID %d, is a TEXT/IMAGE page, as expected.");
		add(7904  , 10 , "The total number of TEXT/IMAGE/UNITEXT pages in this table is %d.");
		add(7905  , 10 , "The number of rows in sysindexes for this table was %d. It has been corrected to %d.");
		add(7906  , 10 , "The number of data pages in sysindexes for this table was %d. It has been corrected to %d.");
		add(7907  , 16 , "The status in the first page (%u) of the no_log table %.*s does not match the status in the object's sysobjects row.");
		add(7908  , 10 , "The table %.*s was created with the no_log option.");
		add(7909  , 10 , "The attempt to create object '%s' in database '%.*s' has failed.");
		add(7910  , 16 , "Page %u allocated (Alloc page: %u Extent ID: %u Alloc mask: 0x%x)");
		add(7911  , 16 , "Page %u deallocated (Alloc page: %u Extent ID: %u Alloc mask: 0x%x)");
		add(7912  , 16 , "EXTID:%u (Alloc page: %u) was initialized but not referenced. DBCC has deallocated it. Extent follows:");
		add(7913  , 16 , "PTNID=%d SPARE=%d OBJID=%d RESERVE=0x%x FORWARD=0x%x ALLOC=0x%x DEALLOC=0x%x INDID=%d STATUS=0x%x");
		add(7914  , 10 , "Allocation page %u extid %u is not referenced, but there are referenced pages within this extent. Contact Technical Support for assistance on object %d.");
		add(7915  , 10 , "Allocation page %u extid %u is referenced, but there are no referenced pages within this extent. Contact Technical Support for assistance on object %d.");
		add(7916  , 10 , "Total (# alloc pages = %d, # of alloc pages modified = %d).");
		add(7917  , 16 , "Total (# pages allocated=%d pages deallocated=%d extents deleted=%d).");
		add(7918  , 16 , "Alloc page %u (pgs allocated=%d pgs deallocated=%d extents deleted=%d).");
		add(7919  , 16 , "Fix_al not processed.  Database needs to be in SINGLE USER mode.");
		add(7920  , 16 , "Processed %d entries in sysindexes for dbid %d.");
		add(7921  , 16 , "Found %d bad entries in sysindexes.");
		add(7922  , 16 , "***************************************************************");
		add(7923  , 16 , "TABLE: %.*s OBJID = %d");
		add(7924  , 16 , "PARTITION ID=%d FIRST=%u ROOT=%u SORT=%d");
		add(7925  , 16 , "Indid : %d, partition : %d. %d Index pages allocated and %d Extents allocated.");
		add(7926  , 16 , "Data level: indid %d, partition %d. %d Data pages allocated and %d Extents allocated.");
		add(7927  , 16 , "TOTAL # of extents = %d");
		add(7928  , 16 , "Index %.*s is not consistent; found %s leaf rows but %s data rows. Drop and recreate the index.");
		add(7929  , 16 , "Table has %s data rows.");
		add(7930  , 16 , "Table Corrupt: Keys in the left child page do not precede the parent key; check page %u, partition ID %d.");
		add(7931  , 16 , "Table Corrupt: Keys in the right child page precede the parent key; check page %u, partition ID %d.");
		add(7932  , 16 , "The indexes for '%.*s' are already correct.  They will not be rebuilt.");
		add(7933  , 16 , "One or more indexes are corrupt.  They will be rebuilt.");
		add(7934  , 16 , "The table '%.*s' has no indexes.");
		add(7935  , 16 , "REINDEX received an exception - command aborted.");
		add(7936  , 10 , "Checktable on sysgams is not allowed.");
		add(7937  , 16 , "The data in table '%.*s' is possibly corrupt - DBCC REINDEX aborted.  Run DBCC CHECKTABLE and report errors to a user with System Administrator (SA) role.");
		add(7938  , 16 , "Table Corrupt: The oam entry for object %d, indid %d, alloc pg %d, has a used count of %d and an unused count of %d. The used count should be %d and the unused count should be %d.");
		add(7939  , 16 , "Table Corrupt: The entry is missing from the OAM for object id %d indid %d partition %d for allocation page %u.");
		add(7940  , 22 , "The counts in the OAM are incorrect.  This implies that there are entries missing.  Run tablealloc utility with the FIX option on the table with the inaccurate OAM counts.");
		add(7941  , 16 , "Couldn't find table %.*s.");
		add(7942  , 10 , "The missing OAM entry has been inserted.");
		add(7943  , 10 , "Attempt to insert missing OAM entry failed.");
		add(7944  , 10 , "*** NOTICE: Space used on the log segment is %s pages (%s MB), %s%%.");
		add(7945  , 10 , "*** NOTICE: Space free on the log segment is %s pages (%s MB), %s%%.");
		add(7946  , 10 , "*** NOTICE:  Notification of log space used/free cannot be reported because the log segment is not on its own device.");
		add(7947  , 16 , "The sortorder and character set ID's for index %d on this table were %d:%d in sysindexes.  They have been corrected to %d:%d.");
		add(7948  , 16 , "Page %u, object %d, partition %d, index %d, level %d, was found with fixed-row status improperly set. That status has been cleared by DBCC.");
		add(7949  , 16 , "The number of pages used and unused for object %d index %d partition %d on allocation page %u do not match the counts in the OAM entry. Actual used/unused counts: [%u, %u]. Used/unused counts in OAM entry: [%u, %u].");
		add(7950  , 16 , "Unable to %.*s engine.  Check sysengines count and max online engines config value.");
		add(7951  , 16 , "Data size mismatch while checking a text value. The first page for this value is %u, partition ID %d. %d characters were found; however, the expected length is %d characters.");
		add(7952  , 10 , "A text value with an invalid MAGIC NUMBER has been found on page %u, partition ID %d. Text values will not be checked for this table and the text page count will be inaccurate. Use DBCC FIX_TEXT to fix the text values.");
		add(7953  , 10 , "Unable to acquire an exclusive lock on text page %u. This text value has not been recalculated. In order to recalculate those TEXT pages you must release the lock and reissue the DBCC FIX_TEXT command.");
		add(7954  , 10 , "There are no TEXT pages in table %.*s to be updated.");
		add(7955  , 10 , "Not all of the TEXT pages in table %.*s have been successfully updated, however, DBCC FIX_TEXT is restartable. Please issue the command again once any other errors have been addressed.");
		add(7956  , 16 , "Remapping utility - Column descriptor should have been remapped earlier. This is an internal system error.");
		add(7957  , 18 , "Remapping utility - procedure is corrupted in Sysprocedures. Recreate this procedure.");
		add(7958  , 16 , "Remapping utility - a pointer exists in a tree when it should not.");
		add(7959  , 16 , "Remapping utility - unable to locate the given procedure %.*s in Sysprocedures.");
		add(7960  , 16 , "Remapping utility - Procedure needs to be recreated for this port.");
		add(7961  , 16 , "Remapping utility - Wrong kind of node passed to tree remapping. This is an internal system error.");
		add(7962  , 16 , "Upgrade requires ASE to be booted in single user mode. Reboot ASE with the -m flag.");
		add(7963  , 16 , "Upgrade encountered a fatal error. Please check the ASE errorlog.");
		add(7964  , 14 , "Permission denied. You do not have the necessary role to run this command. Please contact SAP Technical Support for assistance in running this command.");
		add(7965  , 10 , "The 'fix' option has been ignored for this command. To use the 'fix' option with system tables, run the command from the database where the table is located. The database must be in single user mode.");
		add(7966  , 20 , "The global space allocation report requires an exclusive lock on object 99.  This process does not hold this lock in database %d.  This report is cancelled.");
		add(7967  , 20 , "Allocation page %u in database %d does not hold the address lock required for initializing the diagnostic bitmaps or correcting its allocation errors.");
		add(7968  , 20 , "The object allocation map for tabid %d indid %d partition %d is corrupt, therefore the optimized report cannot be generated. Contact Technical Support for assistance.");
		add(7969  , 10 , "Allocation reports cannot be generated for object %d in database %d.");
		add(7970  , 10 , "The default report option of %.*s is used for this run.");
		add(7971  , 10 , "The default fix option of %.*s is used for this run.");
		add(7972  , 10 , "The OAM counts for objid %d indid %d are corrected.");
		add(7973  , 10 , "The optimized report may generate erroneous messages due to the missing OAM entry.  Run the optimized report with the fix option, to correct this error.");
		add(7974  , 16 , "ILLEGAL use of module %.*s.  See the errorlog for detail information.");
		add(7975  , 20 , "System catalog entrie(s) for Object %d, Database %d are corrupted.");
		add(7976  , 16 , "Object %d in database %d does not have any TEXT/IMAGE/UNITEXT data.");
		add(7977  , 16 , "First page %u and Root page %u are not same.");
		add(7978  , 20 , "One or more text chain(s) for object %d in database %d is corrupt.");
		add(7979  , 16 , "Text chain linkage corrupted for Page %u of Object %d.");
		add(7980  , 16 , "Unreferenced text chain found for page %u, nextpage %u, prevpage %u.");
		add(7981  , 16 , "The new procedure execution mode must be 'unchained', 'chained', 'anymode' or '[not] dynamic [ownership chain]'.");
		add(7982  , 16 , "The specified object '%.*s' is not a stored procedure in database '%.*s'.");
		add(7983  , 16 , "You must be either the system administrator (SA), the database administrator (dbo), or the owner of this stored procedure to change its transaction mode.");
		add(7985  , 16 , "Server name '%.*s' not found in system catalog.");
		add(7986  , 16 , "You can not change the mode of a remote stored procedure.");
		add(7987  , 16 , "User named '%.*s' not found; check sysusers.");
		add(7988  , 16 , "The specified object '%.*s' is not found in database '%.*s'.  Check sysobjects to make sure you own the object.");
		add(7989  , 16 , "The serial allocation flag was found to be improperly set in allocation unit %u, at extent ID %u, with alloc map = %d and objid = %d. This flag has been cleared by DBCC.");
		add(7990  , 16 , "Permission denied.  User's operating system session label must dominate database maxhold to use the DBCC command '%.*s'.");
		add(7991  , 18 , "Label consistency check for database '%S_DBID' failed.");
		add(7992  , 14 , "The user needs to be in the master database to execute this command.");
		add(7993  , 18 , "Either the execution of the 'DBCC SECURITY (LABEL_CHECK)' command failed or one or more databases have been detected to have inconsistent security labels.");
		add(7994  , 16 , "Database '%.*s' has references to other databases. Drop those references and try again");
		add(7995  , 14 , "Permission denied. Only the Database Owner (DBO) or a user with the System Administrator (SA), System Security Officer (SSO), or Oper role can execute this command for database '%S_DBID'.");
		add(7996  , 14 , "Permission denied.  Object '%S_OBJID' not found.");
		add(7997  , 14 , "Permission denied.  User's curwrite does not match the sensitivity label of object '%S_OBJID'.");
		add(7998  , 14 , "Permission denied.  Database '%S_DBID' not found.");
		add(7999  , 14 , "Permission denied.  User's curwrite does not match the sensitivity label of database '%S_DBID'.");
		add(8002  , 15 , "Parameter number %d and subsequent parameters must be passed as '@name = value'.  Once the form '@name = value' has been used, all subsequent parameters must be passed in the form '@name = value'.");
		add(8003  , 15 , "There are too many parameters in this CREATE PROCEDURE statement.  The maximum number is %d.");
		add(8004  , 16 , "Received an unrecognized datatype %d from TDS datastream.");
		add(8005  , 15 , "Received a procedure name length of %d. The TDS datastream is incorrect.");
		add(8006  , 20 , "ASE error detected by %S_MSG. Refer to the preceding %S_MSG message.");
		add(8007  , 20 , "Unknown token returned by %S_MSG:  %d.");
		add(8008  , 16 , "Parameter no. %d, of type %d, did not have a valid value.");
		add(8009  , 16 , "Error encountered by %S_MSG.  Please refer to %S_MSG messages for details.");
		add(8010  , 16 , "datalen (%d) must be less than maxlen (%d) for rpc parameter %d");
		add(8011  , 16 , "Parameter %d has datatype %s. This datatype is not valid for use in parameters for an RPC.");
		add(8012  , 16 , "Adaptive Server internal error: Received internal error %d from the remote server '%S_SRVID'.");
		add(8013  , 16 , "A CT-Lib operation failed during a native RPC.");
		add(8014  , 16 , "You cannot start a non-transactional RPC when the 'strict dtm enforcment' option is enabled for the session.");
		add(8015  , 10 , "Adaptive Server has truncated parameter number %d passed to rpc '%.*s' on server '%.*s'. The remote server does not support character or binary data wider than 255 bytes.");
		add(8016  , 10 , "Remote procedure call to servers of category ASAnywhere or ASIQ is not supported through site handler. Enable cis_rpc_handling.");
		add(8201  , 26 , "Keep count of descriptor (objid=%d, dbid=%d) was expected to be %d. Instead %d was found.");
		add(8203  , 26 , "Expected to find the descriptor for object %d in database %d in %s state.");
		add(8204  , 20 , "Expected to receive system catalog id. Instead %d was received.");
		add(8205  , 20 , "Invalid field token passed to descriptor (id = %d, field = %d).");
		add(8206  , 21 , "Object %d was not found in %s.");
		add(8207  , 17 , "Couldn't find an available descriptor for an object. Raise the value of the configuration parameter 'number of open objects' for more descriptors.");
		add(8208  , 21 , "Descriptor for object %d in database %d was notfound in the expected dbtable.");
		add(8209  , 26 , "Descriptor found was not expected to have %s state.");
		add(8210  , 21 , "Duplicate of work table descriptor found in the id hash table for temporary object %d.");
		add(8211  , 26 , "Mismatch found between the name and id descriptor hash table for table '%.*s', objid = %d. Descriptor hashed by name = 0x%0x and hashed by id = 0x%0x.");
		add(8213  , 20 , "Failed to acquire address lock on object %.*s");
		add(8215  , 14 , "An attempt was made to drop the DES of object %d, which is not a user-defined object.");
		add(8216  , 20 , "Failed to acquire table lock on object %.*s");
		add(8219  , 18 , "Couldn't compute lock promotion level in DES for object %d in database %d. Using default level = %d.");
		add(8221  , 20 , "Couldn't find the identity column for object %.*s.");
		add(8223  , 21 , "As part of a transaction rollback, an attempt was made to modify object '%S_OBJID' in database '%.*s', even though the current session is not holding an exclusive lock on that object.");
		add(8224  , 21 , "Internal error: could not save description of lightweight procedure '%.*s'.");
		add(8225  , 16 , "Invalid object '%.*s' in dbid %d");
		add(8226  , 16 , "Operation not allowed. System table '%.*s' cannot be bound/unbound.");
		add(8227  , 16 , "Trying to bind/unbind an already bound/unbound object '%.*s' in database %d");
		add(8228  , 16 , "Cannot do an unbind at this time. The database %d is in use. Try doing unbind when there are no users using the database.");
		add(8229  , 16 , "Trying to bind/unbind objects to dbid=%d. Bind/Unbind objects not allowed in master and tempdb.");
		add(8230  , 16 , "Trying to turn on/off greedy allocation for object in database with dbid=%d. Turning on/off greedy allocation for objects not allowed in databases master and tempdb.");
		add(8231  , 16 , "Operation not allowed. Cannot turn on/off greedy allocation for system or partitioned table '%.*s'.");
		add(8232  , 16 , "The server failed to record a version change for syscolumns in database '%.*s'. The version indicator should be %d. Due to this error, the database cannot be upgraded.");
		add(8233  , 16 , "%s operation is in progress on the object '%.*s' in database '%.*s'. Retry your query later.");
		add(8235  , 16 , "Optimistic index locking is not allowed on objects in system databases.");
		add(8236  , 16 , "Optimistic index locking cannot be turned on or off on system table '%.*s'.");
		add(8239  , 20 , "Not enough memory to create the cache binding information for '%.*s' in database '%.*s'.");
		add(8240  , 16 , "The table '%.*s' in database '%.*s' is being created and the transaction has not been committed yet. Please retry the query later.");
		add(8241  , 21 , "Fatal internal error encountered while instantiating DBTABLE for database '%.*s'. Database is unusable. Please contact SAP Technical Support for assistance.");
		add(8242  , 16 , "The table '%S_OBJID' in database '%S_DBID' is bound to metadata cache memory. Unbind the table and retry the query later.");
		add(8243  , 16 , "The object '%.*s' in database '%.*s' is created for loading the data using fast load mechanism and is available only to 'bcp in' and 'alter table unparition'. Please retry your query after 'alter table unpartition' on the object.");
		add(8245  , 16 , "Object '%.*s' in database '%.*s' uses features from a later version of ASE that the current binary version does not support. See the installation guide for information about downgrading Adaptive Server.");
		add(8246  , 16 , "Cannot do an bind at this time. The table '%.*s' in database %d is in use. Try doing bind when there are no users for the table.");
		add(8247  , 16 , "Cannot bind table '%.*s' in database %d. Retry the command when there are no active isolation level 0 scans being performed on the table.");
		add(8248  , 16 , "Descriptor of the table '%.*s' needs to be refreshed after completion of utility like alter table. However refresh failed due to an active task on the table. Please retry your query later.");
		add(8249  , 16 , "Optimistic dol root index is not allowed on objects in temporary databases.");
		add(8250  , 16 , "Optimistic dol root index cannot be turned on or off on system table '%.*s'.");
		add(8251  , 16 , "Optimistic dol root index cannot be turned on or off on cluster database.");
		add(8401  , 21 , "Object with id of %d was not found in database number %d.");
		add(8402  , 21 , "Index row for object %d (index id %d) was not found in database %d.");
		add(8403  , 21 , "Index tag structure doesn't contain the search mode executed.");
		add(8404  , 21 , "Index tag structure indicates fast and slow search modes.");
		add(8405  , 21 , "No modify lock was acquired for an index row %s.");
		add(8406  , 21 , "Insert of sysindexes row failed.");
		add(8407  , 21 , "Delete of sysindexes row failed.");
		add(8408  , 21 , "Didn't expect to find active modify lock for sysindexes.");
		add(8409  , 21 , "Invalid status found in sysindexes tag structure. Expected status: %s.");
		add(8410  , 21 , "Expected to find search lock during sysindexes scan.");
		add(8411  , 21 , "Invalid setup status found in sysindexes Manager during a call to: %s.");
		add(8412  , 21 , "No object id specified in sysindexes Manager call to: %s.");
		add(8414  , 21 , "Copy of sysindexes row failed.");
		add(8415  , 21 , "Unexpected value '%d' returned from lock manager after waiting for lock on page %u, dbid %d.");
		add(8416  , 20 , "Invalid scan type %d specified");
		add(8417  , 20 , "Internal error occurred while running the sysindexes exerciser.");
		add(8418  , 20 , "Invalid index descriptor field (%d) specified within sysindexes manager.");
		add(8419  , 21 , "Could not find index descriptor for objid %d, indid %d in dbid %d.");
		add(8420  , 20 , "Could not install index descriptor for objid %d, indid %d in dbid %d.");
		add(8421  , 20 , "Invalid input to sysindexes manager. Expected valid session descriptor for sysindexes system table.");
		add(8422  , 21 , "Indid mismatch between index descriptor 0x%x (indid %d) and page 0x%x (indid %d) for objid %d in dbid %d.");
		add(8423  , 21 , "Expected table descriptor to be set for objid %d in dbid %d.");
		add(8424  , 17 , "Cannot find an available index descriptor for an index. Increase the value of 'number of open indexes'. If sp_configure fails due to lack of index descriptors, edit the configuration file and restart the server.");
		add(8425  , 21 , "Couldn't find an available index descriptor for system objects.");
		add(8426  , 26 , "Index descriptor 0x%x is already installed on the hash table for objid %d, indid %d in dbid %d.");
		add(8427  , 20 , "Invalid input to sysindexes manager. Expected to have dbid or dbtable pointer set.");
		add(8428  , 26 , "Unexpected keep count %d of index descriptor. Expected %d.");
		add(8429  , 20 , "Object with objid %d in dbid %d is not a table.");
		add(8430  , 10 , "Did not find table descriptor linked to process slot structure 0x%x when ASE tried to release it.");
		add(8431  , 20 , "Invalid transaction descriptor passed to the sysindexes manager internal function.");
		add(8432  , 20 , "Invalid object descriptor passed to the sysindexes manager internal function.");
		add(8433  , 20 , "Table descriptor (0x%x) for objid %d in dbid %d is already linked to another transaction.");
		add(8434  , 20 , "Invalid initialization flag %d specified within sysindexes manager.");
		add(8435  , 26 , "Expected to find the index descriptor for objid %d indid %d in dbid %d, in a %s state (found state %d instead).");
		add(8436  , 26 , "Index descriptor found was not expected to be in a %s state.");
		add(8437  , 20 , "Update failed. ASE could not find field '%d' within index descriptor/buffer.");
		add(8438  , 21 , "Updating wrong indexrow in dbid %d. Objid for actual row updated is %d, objid for intended row was %d. Index id for intended row was %d. Index page is %u, field updated is %d. Index row address is %p, row number is %d.");
		add(8439  , 16 , "Cannot install an index descriptor for an index for objid %d as a dbshutdown for the dbid %d is in progress.");
		add(8440  , 21 , "Internal error. DBINFO update at offset %d bytes for length %d bytes will exceed the current size, %d bytes, of DBINFO. DBINFO update in dbid %d failed.");
		add(8441  , 21 , "Column sysindexes.%s has length '%d', should be '%d'. The sysindexes row is for %S_INDINFO.");
		add(8442  , 21 , "Expected sysindexes log record to be time stamped in %S_DBINFO.");
		add(8443  , 10 , "Index (objid %d, indid %d) in dbid %d is not get enough benefit, will never try to compress this index.");
		add(8444  , 10 , "Index partition (objid %d, ptnid %d, indid %d) in dbid %d is not get enough benefit, will never try to compress this index.");
		add(8501  , 26 , "Object id's are not the same during an abort: %d and %d.");
		add(8502  , 21 , "Invalid record type passed to abort: %d.");
		add(8503  , 10 , "The data to be sorted has approximately %s rows, %d used pages (%d KB) and %d unused pages (%d KB).");
		add(8504  , 10 , "Index '%.*s' (ID %d) has %u index pages, and %u of them contain(s) %s updating deltas.");
		add(8505  , 10 , "Index partition '%.*s' (ID %d) of index '%.*s' (ID %d) has %u index pages, and %u of them contain(s) %s updating deltas.");
		add(8506  , 16 , "The number of latch free index pages in database '%.*s' as indicated by the value %u in DBTABLE does not match the computed value %u.");
		add(8507  , 16 , "Warnig: DBCC FIX_TEXT updates some in-memory data rows without logging, please rerun this command when error 7136 occurs.");
		add(8508  , 16 , "Table Corrupt: Entry for '%.*s' is not found in %.*s.");
		add(8509  , 16 , "Table Corrupt: Entry for IMRS LOG device (virtual device number %d) is not found in sysdevices.");
		add(8510  , 16 , "Table Corrupt: %.*s for database ID %d is not found in sysdatabases.");
		add(8514  , 16 , "Key mismatch found in hash node 0x%p (hashcode = %u, RID = (%u, %d), bucket = %u) for partition %d of index %d of table '%S_OBJID' with ID %d.");
		add(8515  , 16 , "Hash code of node 0x%p (hashcode = %u, RID = (%u, %d), bucket = %u) for partition %d of index %d of table '%S_OBJID' with ID %d does not match the computed one from data row.");
		add(8516  , 16 , "Hash node 0x%p (hashcode = %u, RID = (%u, %d), bucket = %u) for partition %d of index %d of table '%S_OBJID' with ID %d is not in proper order.");
		add(8517  , 16 , "Sysversions row for rid (%u, %u) has dbid = %d, objid = %d, ptnid = %d doesn't have the corresponding IMRVERS structure in IMRS Cache.");
		add(8518  , 16 , "IMRVERS structure with dbid = %d, objid = %d, ptnid = %d, RID = (%u, %u) is mismatched with the sysversions row with dbid = %d, objid = %d, ptnid = %d, RID = (%u, %u).");
		add(8519  , 16 , "IMRS version with rid = (%u, %u) contains %d entries in IMRV list but %d entries in sysversions table.");
		add(8520  , 16 , "Data row ID in hash node 0x%p (hashcode = %u, RID = (%u, %d), bucket = %u) for partition %d of index %d of table '%S_OBJID' with ID %d is invalid.");
		add(8601  , 20 , "Process %d tried to keep the PSS for process %d when it already had the PSS for process %d kept.");
		add(8602  , 16 , "Unable to initialize worker thread %x because parent %x has an invalid PSS.");
		add(8603  , 16 , "Warning: worker thread %x already has a PSS allocated; initialization will proceed.");
		add(8604  , 16 , "An attention condition occurred in worker thread %x. The last return value is %d, and the last recorded error was %d. Terminating the worker thread.");
		add(8608  , 18 , "pss=0x%p has been marked sick. pss->p3stat=0x%x pss->pspid=%d pss->pkspid=%d pss->pmasterxact=0x%x. There might be open xdes/sdes associated with the pss. Please report this problem to SAP Tech. Support.");
		add(8609  , 18 , "%s encountered a PCM error (%d) while sending a remote command. The current command will be aborted.");
		add(8701  , 26 , "Sitebuf has invalid state or keepcount. sitebuf=0x%p, state=%d, keepcount=%d.");
		add(8702  , 26 , "Sitebuf has invalid state. sitebuf=0x%p, state=%d.");
		add(8703  , 26 , "Invalid keep count in sitebuf. sitebuf=0x%p, keepcount=%d.");
		add(8704  , 26 , "Could not get the address lock. address=0x%p, status=%d.");
		add(8705  , 26 , "Remotely started site handler.");
		add(8706  , 26 , "Invalid keep count in sitebuf. sitebuf=0x%p, keepcount=%d, lcfreed=%d.");
		add(8707  , 20 , "Incorrect Non-Volatile Cache buffer linkage found between nvbp %S_NVBUF and bp %S_BUF");
		add(8708  , 20 , "An attempt was made to read logical page '%u' from Non-Volatile Cache '%.*s' using buffer %p. Logical page '%u' read from cache device. %S_NVBUF. %S_PAGE.");
		add(8709  , 20 , "Non-Volatile Cache operation '%s' failed on cache '%.*s' due to '%s'.");
		add(8710  , 20 , "Could not start I/O for logical page '%u' belonging to Non-Volatile Cache '%.*s'. BLKIO flags=0x%lx, size = %ld, errcode= 0x%lx. %S_NVBUF.");
		add(8711  , 20 , "Cannot bind Non-Volatile Cache '%.*s' to dbid '%d' as the db is bound to data cache '%.*s', which has large buffer pool(s) configured. Large buffer pools with Non-Volatile Caches are not supported.");
		add(8712  , 20 , "Cannot bind data cache '%.*s' to dbid '%d' as it has large buffer pool(s) and the db is already bound to Non-Volatile Cache '%.*s'. Large buffer pools with Non-Volatile Caches are not supported.");
		add(8713  , 20 , "Cannot unbind data cache '%.*s' from dbid '%d' as db is bound to Non-Volatile Cache '%.*s'. Either remove large buffer pool(s) from 'default data cache' or unbind the Non-Volatile Cache. Large buffer pools with Non-Volatile Caches are not supported.");
		add(8714  , 20 , "Cannot create large buffer pool for data cache '%.*s' as dbid '%d' bound to the data cache is also bound to Non-Volatile Cache '%.*s'. Large buffer pools with Non-Volatile Caches are not supported.");
		add(8715  , 20 , "Aborting server boot. Large pools found in data cache '%.*s' which is conflicting with Non-Volatile Cache '%.*s' due to binding with dbid '%d'. Large buffer pools with Non-Volatile Caches are not supported.");
		add(8801  , 26 , "Logconn has invalid state or keepcount. logconn=0x%p, state=%d, keepcount=%d.");
		add(8802  , 26 , "Logconn has invalid state. logconn=0x%p, state=%d.");
		add(8803  , 26 , "Missing sitebuf for siteid %d.");
		add(8804  , 26 , "Packet acknowledgment is neither read nor write. rdwr=%d.");
		add(8805  , 26 , "Invalid set parameter to lc_wconnstat. set=%d.");
		add(8806  , 26 , "Corrupted pre-read data list in lc__flush. logconn=0x%p, dtbeg=0x%p, dtend=0x%p.");
		add(8901  , 26 , "Databuf has invalid state. databuf=0x%p, state=%d.");
		add(8902  , 26 , "Logconn has invalid state or keepcount. logconn=0x%p, state=%d, keepcount=%d.");
		add(8903  , 26 , "Invalid state in logconn. logconn=0x%p, state=%d.");
		add(8904  , 26 , "Invalid state in databuf or corrupted databuf chain. databuf=0x%p, state=%d, dnext=0x%p.");
		add(9001  , 20 , "Process %d has requested a memory size %d that is greater than the memory size %d in the disk buffer 0x%X, dbid %d.");
		add(9002  , 20 , "Process %d is accessing disk buffer 0x%X, in dbid %d that has been freed.  The current status of the DSKBUF is 0x%X.");
		add(9003  , 20 , "Could not start I/O for request %S_BLKIOPTR.");
		add(9004  , 20 , "I/O error detected on disk buffer 0x%p for page request %u, dbid %d.");
		add(9005  , 20 , "Process %d is requesting an illegal I/O type of 0x%x.");
		add(9006  , 20 , "Process %d is attempting to free a disk buffer that is already freed.  Disk buffer address 0x%X, dbid %d.");
		add(9007  , 10 , "Overlapping fragments of disk space have been found in database '%d' (virtual device number '%d' with starting page' %u' and virtual device number '%d' with starting page '%u'). The database has been marked as suspect.");
		add(9008  , 16 , "Attempt to open device '%.*s' failed. When opening a device which does not support 'directio' with 'dsync' explicitly set to FALSE, 'directio' needs to be explicitly set to FALSE too.");
		add(9009  , 16 , "DISK RESIZE cannot shrink the device '%s' by '%d Kb' as space at the end of this device is occupied by database with dbid %d.");
		add(9010  , 10 , "WARNING: DISK RESIZE is only able to shrink the device '%s' by '%d Kb', as space at the end of this device is occupied by database with dbid %d.");
		add(9011  , 16 , "Truncation of file %s failed. Please refer to ASE errorlog for more information.");
		add(9012  , 10 , "Successfully resized the device '%s' to %ld kilobytes.");
		add(9013  , 10 , "WARNING: Device '%s' with physical path '%s' is a special device. Hence, it cannot be truncated.");
		add(9014  , 17 , "Unable to run DISK RESIZE command on logical device = '%.*s' with physical path '%.*s' and virtual device number %d. There may be an inconsistency between the size reported by OS and ASE. Please address previous error messages and try the command again.");
		add(9101  , 16 , "The total size of all parameter values for stored procedure '%.*s' exceeds maximum size (%d bytes) allowed for replication. Stored procedure '%.*s' is not replicated.");
		add(9102  , 16 , "Failed to convert the %s log record into row format for database '%.*s', XACT ID %S_RID, RID %S_RID.  Information associated with the %s log record is not replicated.");
		add(9103  , 16 , "Failed to send the %s log record for database '%.*s', XACT ID %S_RID, RID %S_RID.  Information associated with the %s log record is not replicated.");
		add(9104  , 16 , "Cannot identify the object on the %s log record for database '%.*s', XACT ID %S_RID, RID %S_RID.  Information associated with the %s log record is not replicated.");
		add(9105  , 16 , "A missing log record indicates a prematurely truncated log or a corrupt log.  The %s log record in database '%.*s', XACT ID %S_RID, is not replicated.");
		add(9106  , 10 , "The deferred insert (INOOP) log record referenced by the insert indirect (INSIND) log record was not found as expected at RID %S_RID.");
		add(9107  , 16 , "Unexpected function return value %d while processing the %s log record of database '%.*s', XACT ID %S_RID, RID %S_RID.  The %s log record may not have been replicated.");
		add(9108  , 10 , "Number of qualifiers supplied to the DBCC LOGTRANSFER command exceeds limit of %d.  The DBCC LOGTRANSFER command is not executed.");
		add(9109  , 10 , "Cannot find user name for user ID %d while sending the %s log record for database '%.*s', XACT ID %S_RID, RID %S_RID.  The user ID will be used instead of the user name.");
		add(9110  , 10 , "Found an ENDXACT log record before finding an expected INSERT log record in database '%.*s', XACT ID %S_RID, RID %S_RID.");
		add(9111  , 10 , "Failed to send the LTM truncation point information for database '%.*s'.  The DBCC GETTRUNC command fails during execution.");
		add(9112  , 16 , "The DBCC LOGTRANSFER command must be invoked with at least %d parameters.  The DBCC LOGTRANSFER command is not executed.");
		add(9113  , 16 , "%.*s' is not a valid %s for the DBCC LOGTRANSFER command. The DBCC LOGTRANSFER command is not executed.");
		add(9114  , 16 , "No message.");
		add(9115  , 16 , "No message.");
		add(9116  , 16 , "'%d' is not a valid numeric value for the specified QUALIFIER.  The DBCC LOGTRANSFER command is not executed.");
		add(9117  , 16 , "The DBCC LOGTRANSFER command was invoked with an invalid combination of QUALIFIERs.  The DBCC LOGTRANSFER command is not executed.");
		add(9118  , 16 , "The specified COMMAND requires additional QUALIFIERS.  The DBCC LOGTRANSFER command is not executed.");
		add(9119  , 17 , "Execution of the the %s command fails due to insufficient memory.");
		add(9120  , 16 , "The log transfer context for database '%.*s' has not been reserved with the DBCC LOGTRANSFER ('reserve', 'context') command.  The specified DBCC command is not executed.");
		add(9121  , 16 , "The log transfer context for the current database is already reserved by ASE process %d. The log transfer context for the current database is not reserved.");
		add(9122  , 21 , "The log transfer process lost its connection to the LTM for database '%.*s'. Once the LTM re-establishes the connection, replication will continue with no data loss.");
		add(9123  , 17 , "Unable to set a wakeup alarm for the log transfer process.  The log transfer scan of database '%S_DBID' will not honor the specified timeout of %d seconds.");
		add(9124  , 16 , "INTERNAL CODING ERROR. Log record ID %d is not valid. Please contact SAP Technical Support.");
		add(9125  , 16 , "Usage: DBCC SETTRUNC('ltm', { 'valid' | 'ignore' | 'pageid', page number | 'pageid_sysimrslogs', page number | 'gen_id', {0-65535} })");
		add(9126  , 16 , "Usage: DBCC GETTRUNC()");
		add(9127  , 16 , "INTERNAL CODING ERROR. The building of an internal data structure required more memory than anticipated. Please contact SAP Technical Support.");
		add(9128  , 16 , "Ran out of memory trying to send an UPDATE command's DELETE/INSERT log record pair for database '%.*s', XACT ID %S_RID, RID %S_RID.  The %s log record is not replicated.");
		add(9129  , 16 , "Unable to determine the end of the log for database '%.*s'.  The log transfer scan of database '%.*s' is aborted.");
		add(9130  , 16 , "The BEGINXACT log record referenced by the CHECKPOINT log record for database '%.*s', XACT ID %S_RID, RID %S_RID, was not found at RID %S_RID as expected.");
		add(9131  , 21 , "The log transfer context for the current database is already reserved by your ASE process. The DBCC LOGTRANSFER ('reserve', 'context') command is ignored.");
		add(9132  , 16 , "Failed to write the log record for the execution of stored procedure '%.*s' in database '%.*s'.  Stored procedure '%.*s' is not replicated.");
		add(9133  , 16 , "ASE was not started with the proper command line option to enable Replication Server support. The DBCC command is not executed.");
		add(9134  , 16 , "The DBCC LOGTRANSFER ('setqual', ...) command was invoked with parameters of incorrect type.  The DBCC LOGTRANSFER ('setqual', ...) command is not executed.");
		add(9135  , 16 , "Usage: DBCC LOGTRANSFER('scan', { 'normal' | 'repeat' | 'continue' })");
		add(9136  , 16 , "Unable to find the RID of the last ENDXACT or CHECKPOINT log record.  The log transfer context for the current database is not reserved.");
		add(9137  , 16 , "LTM trunc. point not yet established with DBCC SETTRUNC().  Until the LTM trunc. point is established, changes to the object '%.*s' may not be replicated.");
		add(9138  , 16 , "Even though Replication Server support is disabled, database '%S_DBID' contains a valid LTM trunc. point which prevents the complete truncation of all expendable log pages.");
		add(9139  , 17 , "Failed to free allocated but unused memory in order to satisfy memory allocation request.  Memory allocation request fails.");
		add(9140  , 17 , "Memory allocator used for Replication Server support failed to fulfill memory allocation request.");
		add(9141  , 16 , "The stored proc. '%.*s' associated with the %s log record in database '%.*s', XACT ID %S_RID, RID %S_RID, was dropped after the log record was written.  The %s log record is not replicated.");
		add(9142  , 16 , "Usage: DBCC REPLICATE_TXTCOL (objid, colid, { always_replicate | replicate_if_changed | do_not_replicate }, index_flag )");
		add(9143  , 16 , "'%.*s' is not a valid replication status. The DBCC REPLICATE_TXTCOL command is not executed.");
		add(9144  , 16 , "The requested column cannot be located. Check the objid and colid specified. The DBCC REPLICATE_TXTCOL command is not executed.");
		add(9145  , 16 , "The datatype of the specified column must be TEXT, IMAGE, UNITEXT or offrow object. The DBCC REPLICATE_TXTCOL command is not executed.");
		add(9146  , 20 , "The excution of DBCC REPLICATE_TXTCOL failed due to an internal error. Please contact your System Administrator (SA) for help.");
		add(9147  , 16 , "Replication Not Enabled: Replication on table %.*s in database %.*s, has not been enabled yet. Run sp_setreplicate or sp_setrepcol before calling DBCC REPLICATE_TXTCOL, the DBCC REPLICATE_TXTCOL command is not executed. (objid %d)");
		add(9148  , 20 , "Replication server could not send log records for log version change processing in database '%.*s' because the log processing functions returned internal error %d.");
		add(9149  , 10 , "LTM Truncation point has not been established with DBCC SETTRUNC. Changes to the objects in the database may not be replicated until the truncation point is set.");
		add(9150  , 16 , "The log transfer context for the current database cannot be reserved because the current database has been enabled for a Rep Agent Thread.");
		add(9151  , 16 , "Permission denied. User cannot execute the built-in function '%.*s' in database '%d'.");
		add(9152  , 19 , "The data or object identifier at (%d, %d) has been truncated because the LTI version level does not support wide data or large identifier.");
		add(9153  , 19 , "The data or object identifier at (%d, %d) is too wide or large to be handled by the current LTI version level.");
		add(9154  , 19 , "Skipping (%d, %d) because it contains data or object identifier that are wider or larger than the LTI version level allows.");
		add(9155  , 10 , "The date column at (%d, %d) is too small to be converted to a datetime, the date portion will default to 'Jan 1, 1900'.");
		add(9156  , 10 , "An error occurred when attempting to drop indexes for replication. Run DBCC REINDEX to drop any orphan replication indexes.");
		add(9157  , 10 , "An error occurred when attempting to create indexes for replication. Please contact SAP Technical Support.");
		add(9158  , 19 , "One or more columns were skipped while processing (%d,%d). The identifier length is wider than the length supported by the LTI version.");
		add(9159  , 16 , "Set the replication status for '%.*s' to '%s' before setting '%s'");
		add(9160  , 16 , "The object '%.*s' is not a user table. This replication attribute can only be set on user tables.");
		add(9161  , 16 , "The SQL statement replication log threshold must be in the range %d to %d.");
		add(9162  , 18 , "ASE has encountered an internal error while attempting to set the SQL statement replication threshold. Please contact SAP Technical Support.");
		add(9163  , 0  , "Stored procedures with LOB or object parameters cannot be marked for replication at this time.");
		add(9164  , 11 , "Unknown dbid '%d' specified. Please check the dbid specified.");
		add(9165  , 16 , "Cannot set replication for database '%.*s' as it is minimally logged. Use ALTER DATABASE to set full DML logging and try again.");
		add(9166  , 10 , "Warning: '%.*s' is using minimal logging. Replicated objects will continue to use full DML logging.");
		add(9167  , 16 , "Cannot set replication for table '%.*s' because it is using minimal DML logging. Use ALTER TABLE to set full logging and try again.");
		add(9168  , 10 , "Warning: Database '%.*s' has tables that use minimal DML logging. These tables will not be replicated");
		add(9169  , 16 , "The DBCC LOGTRANSFER (%s) command has been invoked with log record type '%.*s', which is not supported. The command did not execute.");
		add(9170  , 16 , "Only user tables and user stored procedures created on user databases can be bound to replication paths.");
		add(9171  , 16 , "Unknown action '%.*s' specified for the built-in '%.*s'(). Verify the parameter name and placement.");
		add(9172  , 20 , "%S_REPAGNT: The default date order '%.*s' is invalid.");
		add(9173  , 16 , "No %.*s named '%.*s' exists in the current database.");
		add(9174  , 16 , "Path named %.*s already exists in the current database.");
		add(9175  , 16 , "Objects of type %.*s cannot be bound to paths.");
		add(9176  , 16 , "The 'logical' keyword is required to manage this path.");
		add(9177  , 16 , "The path '%.*s' is still a member of one or more logical paths.");
		add(9178  , 16 , "The path %.*s cannot be dropped because it still has objects bound to it.");
		add(9179  , 10 , "Warning: adding this path increases the number of configured paths to greater than the value specified by the 'max number replication paths' property.");
		add(9180  , 16 , "Cannot set the value of 'max number replication paths' to %d since it is less than the total number of existing paths %d.");
		add(9181  , 16 , "The path '%.*s' is already an element of the logical path '%.*s'.");
		add(9182  , 10 , "The object '%.*s' is already bound to the path '%.*s'.");
		add(9183  , 10 , "The object '%.*s' is not bound to the path '%.*s'.");
		add(9184  , 16 , "There is no element named '%.*s' in the logical path '%.*s'.");
		add(9185  , 16 , "The 'logical' keyword cannot be used with this path.");
		add(9186  , 16 , "The '%.*s' configuration parameter cannot be modified using the %.*s stored procedure.");
		add(9187  , 20 , "Path loading terminated: Rep Server name missing for physical path %d.");
		add(9188  , 20 , "Path loading terminated: Rep Server user name missing for Rep Server %s physical path %d.");
		add(9189  , 20 , "Path loading terminated: Rep Server password missing for Rep Server %s physical path: %d.");
		add(9190  , 20 , "Unable to assign one or more rep paths to senders, stored rep paths and configured rep paths do not match.");
		add(9191  , 20 , "Sender for database %d has received a different maint user. Sender will be terminated.");
		add(9192  , 10 , "Replication Agent path configuration changed for database '%.*s'. The changes will take effect the next time the Replication Agent thread is started.");
		add(9193  , 10 , "Warning: The object '%.*s' being bound to path '%.*s' is not currently marked for replication.");
		add(9194  , 16 , "Cannot change the configuration of a logical path. Configure the underlying path instead.");
		add(9195  , 10 , "Warning: Maximum number of replication paths is set to 1. All bindings for database ID '%d' will go to the default path despite the presence of %d physical paths.");
		add(9197  , 10 , "Warning: Distribution model is 'connection'. All bindings are ignored.");
		add(9198  , 16 , "No underlying table '%.*s' exists for filter '%.*s!' in the current database.");
		add(9199  , 10 , "Warning: Under the current '%.*s' distribution model this binding will be ignored.");
		add(9201  , 10 , "Rep Agent on database '%.*s' did wake-up after sleeping on memory not being available. Memory is now available and replication continues.");
		add(9202  , 20 , "%S_REPAGNT: Nested replicated stored procedure detected. Transaction log may be corrupt. Please contact SAP Technical Support. (current marker = %d, %d)");
		add(9203  , 20 , "%S_REPAGNT: Encountered an End Transaction that was not in abort state while locating after image for Delete at (%d, %d), transaction = (%d, %d).");
		add(9204  , 20 , "%S_REPAGNT: Could not locate schema for object with id = (%d), current marker (%d, %d).");
		add(9205  , 20 , "%S_REPAGNT: A replicated End Stored Procedure Execution log record was found without a Begin. Transaction log may be corrupt. Please contact SAP Technical Support. objid = (%d), current marker = (%d, %d)");
		add(9206  , 20 , "%S_REPAGNT: Error initializing the Rep Agent. Could not set affinity to engine (%d).");
		add(9207  , 20 , "%S_REPAGNT: Could not re-read XCMDTEXT log record at (%d, %d), current marker (%d, %d).");
		add(9208  , 20 , "%S_REPAGNT: Update detected within a subscribable function. Transaction log may be corrupt. Please contact SAP Technical Support. (current marker = (%d, %d)).");
		add(9209  , 20 , "%S_REPAGNT: Missing datarow in TEXT/IMAGE/UNITEXT insert log record. Transaction log may be corrupt. Please contact SAP Technical Support. (current marker = (%d, %d)).");
		add(9210  , 20 , "%S_REPAGNT: Fatal error from CT-Lib. (CT-Lib command = %s, return status = %d).");
		add(9211  , 20 , "%S_REPAGNT: Received the following error message from the Replication Server: Msg %d. %.*s.");
		add(9212  , 20 , "%S_REPAGNT: Received the following communications error message: Msg %s: %.*s.");
		add(9213  , 16 , "%S_REPAGNT: The version of this Rep Agent, is not supported by the Replication Server specified. After fixing this problem, restart the Rep Agent for this database. (Rep Agent version = %d, Rep Server version = %d, Rep Server = %.*s).");
		add(9214  , 16 , "%S_REPAGNT: Failed to connect to Replication Server. Please check the Replication Server, username, and password specified to sp_config_rep_agent. RepSvr = %.*s, user = %.*s).");
		add(9215  , 16 , "%S_REPAGNT: The Secondary Truncation Point is not valid. Please make sure that the Secondary Truncation Point is valid, and then restart the Rep Agent Thread for this database.");
		add(9216  , 10 , "%S_REPAGNT: The Rep Agent Thread will retry the connection to the Replication Server every %d second(s). (RepSvr = %.*s).");
		add(9217  , 10 , "%S_REPAGNT: Trace log file set to `%s'.");
		add(9218  , 16 , "Database %S_DBID has not been enabled yet for an integrated Rep Agent Thread. Run sp_config_rep_agent to enable Rep Agent in the database.");
		add(9219  , 20 , "%S_REPAGNT: Internal coding error.");
		add(9220  , 16 , "%S_REPAGNT: The Rep Agent Thread context for database %S_DBID has already been reserved by another session.");
		add(9221  , 16 , "Parameter count/type mismatch. Please check the number and types of the parameters passed to the builtin function, '%.*s'.");
		add(9222  , 16 , "You must be SA, DBO, or have REPLICATION role to execute the builtin function, '%.*s'. Please check your current roles.");
		add(9223  , 16 , "Unknown %s, '%.*s', specified to builtin function %s(). Please check parameter spelling and placement.");
		add(9224  , 16 , "No message.");
		add(9225  , 16 , "No message.");
		add(9226  , 16 , "Database %S_DBID has already been enabled to use a Rep Agent thread.");
		add(9227  , 17 , "%S_REPAGNT. Could not allocate memory to spawn Rep Agent thread. (size=%d)");
		add(9228  , 17 , "%S_REPAGNT. Could not spawn Rep Agent Thread.");
		add(9229  , 16 , "%S_REPAGNT. Could not change to database, %S_DBID.");
		add(9230  , 16 , "The Rep Agent Thread for database, %S_DBID, is not running. Please retry this command after starting the Rep Agent Thread for this database.");
		add(9231  , 16 , "%S_REPAGNT. The Connect Dataserver name was not specified via 'sp_start_rep_agent', nor was a legal value found in sysattributes or sysservers. Execute sp_addserver lname, local [, pname] and ensure that pname is no longer than 30 characters.");
		add(9232  , 16 , "%S_REPAGNT. The Connect Database name was not found in sysattributes, or sysdatabases.");
		add(9233  , 17 , "%S_REPAGNT. Could not allocate %d bytes from the procedure cache. Please retry the last operation when more memory is available, or re-configure the server with a larger procedure cache.");
		add(9234  , 17 , "%S_REPAGNT. Could not start Rep Agent Thread.");
		add(9235  , 17 , "Could not allocate memory for gettrunc. Please retry gettrunc() later when more memory is available, or re-configure the server with a larger procedure cache.");
		add(9236  , 11 , "Unknown dbid '%d' specified. Please check the dbid specified.");
		add(9237  , 16 , "%S_REPAGNT. The row for %.*s could not be found in sysattributes. Please check the configuration properties for this database with 'sp_config_rep_agent' or 'sp_help_rep_agent'.");
		add(9238  , 16 , "Settrunc() is not permitted when a Rep Agent Thread is currently running on the database.");
		add(9239  , 10 , "%S_REPAGNT: Cannot allocate %d bytes of memory and will sleep until memory becomes available. Rep Agent Thread: %s, status: %s / %s. Contact a user with System Administrator (SA) role to reconfigure Adaptive Server with more memory for Replication.");
		add(9240  , 17 , "%S_REPAGNT: Could not allocate an alarm. Try restarting this Rep Agent Thread after freeing up some alarms, or restart the server with more alarms allocated.");
		add(9241  , 20 , "%S_REPAGNT: Failure initializing the Rep Agent Context.");
		add(9242  , 20 , "%S_REPAGNT: Underflow or overflow of state stack occurred.");
		add(9243  , 20 , "%S_REPAGNT: Interface error with the Replication Server. The Rep Agent may not be compatible with the Replication Server.");
		add(9245  , 20 , "Failure during update/insert/delete from sysattributes.");
		add(9249  , 17 , "Failed to reserve context in shared mode.");
		add(9250  , 10 , "%S_REPAGNT Failed to open trace file, '%.*s'. Trace messages will go to stdout of the server.");
		add(9251  , 20 , "%S_REPAGNT Write to trace file, '%.*s', failed");
		add(9252  , 20 , "Internal coding error in builtin function, '%.*s'.");
		add(9253  , 20 , "Failed to get secondary truncation point.");
		add(9254  , 20 , "%S_REPAGNT: Could not locate schema version for object id '%d' in the transaction log.");
		add(9255  , 20 , "%S_REPAGNT: Rewrite of PREPARE log record failed at (%d, %d).");
		add(9256  , 20 , "%S_REPAGNT: Could not read INOOP log record at (%d, %d), current marker (%d, %d).");
		add(9257  , 20 , "%S_REPAGNT: Could not read ROWIMAGE log record at (%d, %d), current marker (%d, %d).");
		add(9258  , 20 , "%S_REPAGNT: Could not re-read EXECBEGIN log record at (%d, %d), current marker (%d, %d).");
		add(9259  , 20 , "%S_REPAGNT: Could not read TEXTINSERT/INOOPTEXT log record at (%d, %d), current marker (%d, %d).");
		add(9261  , 20 , "%S_REPAGNT: This Rep Agent Thread is aborting due to an unrecoverable communications or Replication Server error.");
		add(9262  , 16 , "A Rep Agent Thread for database '%.*s' (dbid=%d) is already running.");
		add(9263  , 10 , "%S_REPAGNT: Turning Batch mode on.");
		add(9264  , 10 , "%S_REPAGNT: Turning Batch mode off.");
		add(9265  , 10 , "%S_REPAGNT: Ignoring LTL errors.");
		add(9266  , 10 , "%S_REPAGNT: Error in passthru packet: '%.*s'.");
		add(9267  , 20 , "%S_REPAGNT: A security mechanism was specified, but no security service(s) were specified. Please use 'sp_config_rep_agent' to specify which security service(s) to use when connecting to the Replication Server.");
		add(9268  , 20 , "%S_REPAGNT: The security service '%.*s' was specified, but it is not supported by the security mechanism. Please check the security service(s) and/or security mechanism specified to sp_config_rep_agent. (CT-lib error %d).");
		add(9269  , 20 , "%S_REPAGNT: Failure initializing the security mechanism '%.*s'. Please check the 'security mechanism' specified to sp_config_rep_agent. (CT-lib error %d).");
		add(9270  , 10 , "%S_REPAGNT: Using default security mechanism.");
		add(9271  , 20 , "%S_REPAGNT: Failure initializing the default security mechanism. Please check that a security mechanism has been properly configered. (CT-lib error %d).");
		add(9272  , 20 , "%S_REPAGNT: Failure specifying the keytab filename. Please check that the keytab file '%.*s', exists and is accessable. (CT-lib error %d).");
		add(9273  , 10 , "%S_REPAGNT: Using default keytab file because security mechanism requires a keytab file, but the no keytab file was specified at server startup.");
		add(9274  , 16 , "Cannot disable the RepAgent thread for database %S_DBID, because the RepAgent is still running. Please stop the RepAgent on that database with 'sp_stop_rep_agent' before re-issuing 'sp_config_rep_agent disable'.");
		add(9275  , 20 , "%S_REPAGNT: Could not locate the %s image for the %s log record at (%d,%d).");
		add(9276  , 20 , "Error executing the command 'set proxy %.*s'.");
		add(9277  , 20 , "%S_REPAGNT: The security mechanism configured requires a keytab file. Check that the a keytab file was specified at server startup, and that 'use security services' has been configured.");
		add(9278  , 0  , "%S_REPAGNT: Encountered a feature that cannot be supported by the current Replication Server version. Upgrade the Replication Server version to a higher level, or use sp_config_rep_agent to set the 'skip unsupported features' option.");
		add(9279  , 0  , "%S_REPAGNT: Connecting to a Replication Server that supports a lower LTL version. Features that are not supported by the lower LTL version may cause the RepAgent to shutdown. Set the 'skip unsupported features' configuration option to prevent shutdown.");
		add(9280  , 10 , "%S_REPAGNT: Unable to start RepAgent on database %S_DBID, because that database has not been recovered and/or is not online. Please start the RepAgent manually using sp_start_rep_agent when it is ready.");
		add(9281  , 10 , "%S_REPAGNT: The Replication Server LTL version should be at least %d for full support of features. (Replication server LTL version %d, Rep Agent LTL version %d).");
		add(9282  , 20 , "%S_REPAGNT: No free file descriptors available.");
		add(9283  , 20 , "%S_REPAGNT: Aborting because a cross database stored procedure execution was detected. This event needs to be manually applied, and skipped before restarting the RepAgent. (sproc dbid %d, sproc objid %d, current marker (%d, %d))");
		add(9284  , 17 , "%S_REPAGNT. Cannot allocate %d bytes of memory. You may need to reconfigure the parameter 'replication agent memory size' with more memory.");
		add(9285  , 19 , "%S_REPAGNT. The data or object identifier at (%d, %d) is truncated because the Replication Server, '%.*s', cannot handle wide data or large identifiers. Check the 'data limits filter mode' configuration parameter.");
		add(9286  , 19 , "%S_REPAGNT. The data or identifier for object id (%d) at (%d, %d) is too wide for the Replication Server, '%.*s', to handle. Check the 'data limits filter mode' configuration parameter.");
		add(9287  , 19 , "%S_REPAGNT. The data at (%d, %d) is skipped because it contains data or object identifiers wider than the Replication Server, '%.*s', can handle. Check the 'data limits filter mode' configuration parameter.");
		add(9288  , 10 , "%S_REPAGNT. The date column at (%d, %d) is too small to be converted to a datetime, the date portion will default to 'Jan 1, 1900'.");
		add(9289  , 20 , "%S_REPAGNT. Log record (%d, %d) for object = %d contains inconsistent data. Transaction log may be corrupt. Please contact SAP Technical Support.");
		add(9290  , 18 , "%S_REPAGNT. Log record (%d,%d) for object = %d contains inconsistent data. Rep Agent will try to extract the information read and continue replication. Unexpected data may be replicated.");
		add(9291  , 16 , "Replication Agent configuration parameter '%s' must be in the range %d to %d.");
		add(9292  , 10 , "%S_REPAGNT: Delay %d seconds before starting replication agent.");
		add(9293  , 10 , "%S_REPAGNT. Starting recovery, processing log records between (%d, %d) and (%d, %d).");
		add(9294  , 10 , "%S_REPAGNT. Processed %d log records.");
		add(9295  , 10 , "%S_REPAGNT. Processed %d log records, recovery complete.");
		add(9297  , 16 , "%S_REPAGNT. Cannot bind Rep Agent to engine number %d as the engine is currently offline. Rep Agent will continue running on the next available engine.");
		add(9298  , 20 , "The generation number cannot be automatically set, because the locater in Replication Server is zero. Use DBCC SETTRUNC('ltm','gen_id',<number>) to manually increase the generation number. Then restart Replication Agent.");
		add(9299  , 20 , "The generation number cannot be automatically set, because Replication Agent has reached the maximum value of 65534. Please contact SAP Technical Support.");
		add(9400  , 16 , "Dummy message");
		add(9401  , 20 , "%S_REPAGNT: Internal Error. Rep Agent streaming replication configuration handle does not exist.");
		add(9402  , 10 , "%S_REPAGNT: Warning: number of mutex retries for mutex %s exceeds %ld at (%d).");
		add(9403  , 10 , "%S_REPAGNT: Last warning printed: number of mutex retries for mutex %s exceeds %ld at (%d).");
		add(9404  , 10 , "%S_REPAGNT: Warning: mutex %s is acquired after %ld retries at (%d).");
		add(9405  , 10 , "%S_REPAGNT: Internal Error in module '%s' at line %d. The total number of columns in RA_OBJ (%d) for object '%.*s' (ID=%d) does not match the number of elements in RA_COL list (%d).");
		add(9406  , 16 , "%S_REPAGNT: Streaming Replication cannot be enabled on ASE Cluster Edition.");
		add(9407  , 20 , "%S_REPAGNT: the CI library reported error %d when attempting to open a replication stream.");
		add(9408  , 20 , "The CI library received the following message from Replication Server: %s, %d, %d, %d, %s, %x%x%x.");
		add(9409  , 10 , "Current transaction ID (%d,%d) in database '%.*s' (dbid = %d): commit wait %s.");
		add(9410  , 20 , "Internal error: RAT CI exception handling was called from an unknown context.");
		add(9411  , 20 , "%S_REPAGNT: Streaming replication internal error (%d) when loading or closing the CI library. Check the ASE errorlog for further information as to the cause.");
		add(9412  , 20 , "%S_REPAGNT: Streaming replication internal error (signal %d) caused by a CI library fatal error. Check the ASE errorlog for further information as to the cause.");
		add(9413  , 20 , "%S_REPAGNT: Streaming replication internal error %d at line %d in file %s.");
		add(9414  , 20 , "%S_REPAGNT: Streaming replication %s CI Library error %d with severity %d and message '%s'. Rep Agent detected error %d with message '%.*s' at line %d in file %s.");
		add(9415  , 10 , "%S_REPAGNT: Warning: The size of the stream buffer is too small (%d bytes). Use sp_config_rep_agent '%.*s', 'stream buffer size', '<new_value>' to increase it.");
		add(9416  , 16 , "Rep Agent on database '%.*s' switched from mode '%s' to mode '%s' because %s.");
		add(9417  , 17 , "%S_REPAGNT: CI-resource '%s' is insufficiently configured, please use 'sp_config_rep_agent' to change the configuration value of '%s'.");
		add(9418  , 16 , "Warning: Rep Agent on database '%.*s' received an invalid truncation page from Replication Server. The received truncation page %d has a lower timestamp than the current truncation page %d and will be ignored.");
		add(9419  , 16 , "Rep Agent on database '%.*s' has received an invalid Maintenance User: '%.*s'. This is a fatal error.");
		add(9420  , 10 , "Warning: The stored procedure '%.*s', which is marked for replication as 'table', will not be replicated while 'stream replication' is enabled.");
		add(9421  , 20 , "Current transaction ID (%d,%d) in database '%.*s' (dbid = %d): failed to replicate the log operation (%d) in %s mode.");
		add(9422  , 17 , "%S_REPAGNT: Autoscaling: Error, the allocated buffer pool size is:%d, which is incorrect. Use sp_config_rep_agent '%.*s', 'buffer pool size' to check or correct the value.");
		add(9423  , 10 , "%S_REPAGNT: Autoscaling: Warning: The configured buffer pool size:%d is different from the allocated buffer pool size:%d. The used size is:%d.");
		add(9424  , 10 , "%S_REPAGNT: Autoscaling: Warning: The maximum configured buffer pool size:%d is less than the allocated buffer pool size:%d. The maximum is set to %d.");
		add(9425  , 10 , "%S_REPAGNT: Autoscaling: Warning: The buffer pool could not be increased to size: %d. Continuing using the previous size: %d.");
		add(9426  , 10 , "%S_REPAGNT: Autoscaling: Warning: The buffer pool could not shrink to size: %d. Continuing using the previous size: %d.");
		add(9427  , 10 , "%S_REPAGNT: Autoscaling: Warning: The 'buffer pool' cannot grow any further and the scanner will sleep on packages becoming available.");
		add(9428  , 20 , "%S_REPAGNT: In-memory row storage is enabled for this database, streaming replication must be enabled to support replication on this database. Run sp_config_rep_agent to enable streaming replication for this database.");
		add(9501  , 10 , "Warning - null value eliminated in set function");
		add(9502  , 16 , "Data exception - string data right truncated");
		add(9503  , 14 , "You must have one of the following role(s) to execute this command/procedure:  '%.*s'.  Please contact a user with the appropriate role(s) for help.");
		add(9504  , 16 , "An isolation level 0 cursor scan has failed on an attempted restart for cursor '%.*s', table '%.*s', index id '%d'.  The cursor is being closed.");
		add(9505  , 16 , "An isolation level 0 scan has failed on an attempted restart on table '%.*s', index id '%d'.");
		add(9506  , 10 , "Warning: Using only the first %d characters for password");
		add(9507  , 18 , "The builtin function 'syb_sendmsg' is not supported.");
		add(9508  , 16 , "The builtin function 'syb_sendmsg' failed to send the message '%.*s' to the destination address '%.*s' at port number %d, because the length of the Internet address is greater than the server limits. Please provide a valid destination address and retry.");
		add(9509  , 16 , "The builtin 'syb_sendmsg' failed to send the message '%.*s' to the destination address '%.*s' at port number %d, because the port number is not valid. Please enter a valid (positive integer value between 0 and 65535) port number and retry.");
		add(9510  , 16 , "The builtin function 'syb_sendmsg' failed to send the message '%.*s' to destination '%.*s' at port number %d because the Internet address is incorrectly formed or is non-existent. Please enter the Internet address in its correct form and retry.");
		add(9511  , 18 , "The builtin function 'syb_sendmsg' failed to send the message '%.*s' to the destination address '%.*s' at port number %d due to an internal error which required the message to be sent atomically. Please report this error to your Systems Administrator.");
		add(9512  , 18 , "The builtin 'syb_sendmsg' failed to send the message '%.*s' to destination '%.*s' at port number %d due to failure in opening or setting the socket to non-blocking mode. Please report this internal error to your Systems Administrator.");
		add(9513  , 18 , "The builtin function 'syb_sendmsg' failed to send the message '%.*s' to the destination address '%.*s' due to a failure to bind the socket to a local port number %d provided by using dbcc tune. Please report this error to your Systems Administrator.");
		add(9514  , 18 , "The builtin function 'syb_sendmsg' failed to send the message '%.*s' to the destination address '%.*s' at port number %d due to an internal error while doing the actual send. Please report this error to your Systems Administrator.");
		add(9515  , 16 , "The UPDATE/DELETE WHERE CURRENT OF to the cursor '%.*s' failed because the isolation level is at 0.");
		add(9516  , 16 , "%d is an invalid spid. You could use sp_who to identify the correct spid.");
		add(9517  , 16 , "Table '%.*s' does not exist in the database.");
		add(9518  , 17 , "Insert into work table (for deferred processing) failed while enforcing referential constraints. Check previous errors for possible causes. dbname = '%.*s', table name = '%.*s', constraint name = '%.*s'.%S_EED");
		add(9519  , 18 , "Failed to update the identity pre-burn factor for field '%.*s' in table '%.*s'. Please re-try the operation or contact your SA for details.");
		add(9520  , 18 , "Error occurred while creating the identity value for field '%.*s' in table '%.*s'. Please re-try the operation or contact your SA for details.");
		add(9521  , 16 , "The parameter that specifies the number of rows in a SET CURSOR ROWS statement must be an integer with a value greater than 0.");
		add(9522  , 16 , "The parameter that specifies the number of rows in a SET ROWCOUNT statement must be an integer with a value greater than 0.");
		add(9523  , 18 , "The builtin 'syb_sendmsg' is not currently enabled. Please contact your Systems Administrator for more information.");
		add(9524  , 16 , "SELECT is not allowed in a dynamic EXECUTE IMMEDIATE statement. This SELECT may have been part of a stored procedure or a trigger.");
		add(9525  , 16 , "A positioned update/delete on a row in table '%.*s' failed. This is because cursor '%.*s' does not point to a valid row in an inner(outer) table of an outer(inner) join used in the query.");
		add(9526  , 16 , "The dynamic sql operation is not allowed with cursor '%.*s'.");
		add(9527  , 20 , "Attempt to acquire lock on wrong merge area during parallel merge. This is an internal error. Contact a system administrator and SET PARALLEL_DEGREE 1 for this query.");
		add(9529  , 20 , "Deadlock during parallel merge. This is an internal error. Use SET PARALLEL_DEGREE 1 to run this query, and contact SAP Technical Support to report the problem.");
		add(9532  , 20 , "Internal error: unable to locate an extra SDES for cursor '%.*s'. The cursor was probably compiled with the incorrect locking scheme for the target table.");
		add(9533  , 20 , "Internal error: unable to locate a temporary object during preprocessing.");
		add(9534  , 20 , "Interal error: could not determine the configuration value for parameter '%s'.");
		add(9536  , 18 , "Unable to obtain lock on system table.");
		add(9537  , 17 , "Insufficient number of worker processes to execute this parallel query. Increase the value of the configuration parameter 'number of worker processes'.");
		add(9538  , 17 , "Insufficient number of mailboxes to execute this parallel query. Increase the value of the configuration parameter 'number of mailboxes'.");
		add(9539  , 17 , "Insufficient amount of memory per worker process to execute this parallel query. Increase the value of the configuration parameter 'memory per worker process'.");
		add(9540  , 17 , "Insufficient number of messages to execute this parallel query. Increase the value of the configuration parameter 'number of messages'.");
		add(9541  , 18 , "Worker Process API internal error %d. Consider running this query serially by setting the session parameter 'parallel_degree' to 1. Please contact SAP Technical SUpport.");
		add(9543  , 16 , "Parameter passed to %s has an invalid type. It must be of type %s.");
		add(9544  , 16 , "Invalid time syntax in parameter for %s: '%.*s'.");
		add(9545  , 16 , "Invalid time value in parameter for %s: '%.*s'.");
		add(9546  , 10 , "AN ADJUSTED QUERY PLAN IS BEING USED FOR STATEMENT %d BECAUSE");
		add(9547  , 10 , "NOT ENOUGH WORKER PROCESSES ARE CURRENTLY AVAILABLE.");
		add(9548  , 10 , "ADJUSTED QUERY PLAN:");
		add(9549  , 17 , "Worker process (fid=%d, spid=%d) encountered error: %d, severity: %d, state: %d during parallel query initialization. If the problem persists, consider setting the value of session parameter 'parallel_degree' to 1 and rerunning the query.");
		add(9550  , 16 , "The lightweight procedure '%.*s' cannot be executed because it does not exist.");
		add(9551  , 16 , "The specified password does not have any numeric characters. New passwords must have at least one numeric character.");
		add(9552  , 16 , "The identity gap '%d' specified is too large for the identity column's precision of '%d'.");
		add(9553  , 16 , "No Unicode character returned for the range 0xD800..0xDFFF (surrogates) because it is not permitted to create Unicode expression with only half of a surrogate pair.");
		add(9554  , 16 , "No Unicode character defined for this integer expression.");
		add(9555  , 16 , "No Unicode scalar value returned for unmatched surrogate half.");
		add(9556  , 16 , "The position parameter passed in falls outside the source string.");
		add(9557  , 16 , "The server failed to create or update a row in table '%.*s' because a varying-length column would start at offset %d. This starting location cannot be represented accurately in the table's row format.");
		add(9558  , 10 , "Character or binary data returned from Adaptive Server has been truncated. The client application does not support more than 255 bytes of data as a result column or output parameter.");
		add(9559  , 14 , "Table(s) in the current query have access rules but the row level access configuration option 'enable row level access' is not enabled. Please enable row level access option to run the query with access rules.");
		add(9560  , 10 , "The ordinal number of a column in the ORDER BY clause exceeds 255. The client application does not support column numbers over 255.");
		add(9561  , 20 , "An insert or update to table '%.*s' places column '%.*s' at offset %d, ending at offset %d. The maximum permitted ending offset for this column is %d. This is a server internal error.");
		add(9562  , 16 , "The command '%s' is not allowed when the set option '%s' is on.");
		add(9563  , 10 , "The current identity value ('%s') of table '%.*s' is the identity burn max value. Next identity value will cause overflow.");
		add(9565  , 17 , "The value of 'max parallel degree' ('%d') is smaller than the parallel degree required by this query ('%d'), and there are insufficient available worker processes. Change 'max parallel degree' and retry the query.");
		add(9566  , 20 , "Worker Process internal plan copy error for EVAL %s. Consider running this query serially by setting the session parameter 'parallel_degree' to 1. Please contact SAP Technical Support.");
		add(9567  , 16 , "The fetch type '%.*s' can only be used with scrollable cursors.");
		add(9568  , 16 , "Invalid authorization mechanism '%.*s'.");
		add(9569  , 10 , "%.*s is an unknown module option for optimizer tracing for the showplan_in_xml() and will be ignored by the optimizer. Please consult your manual for valid module names and options.");
		add(9570  , 16 , "The option %.*s is invalid for the builtin showplan_in_xml. The only valid options are 'query plan' and 'optimizer trace'. Please re-submit your query with the correct option.");
		add(9571  , 10 , "The built-in function '%s' has been deprecated. Use the new built-in function '%s' instead. Deprecated function returns value of 0.");
		add(9572  , 16 , "The option '%d' is invalid for the built-in function '%s', the valid option is larger than or equal to %d and less than or equal to %d.");
		add(9573  , 16 , "The server failed to create or update a row in table '%.*s' because the values of the row's partition-key columns do not fit into any of the table's partitions.");
		add(9574  , 16 , "The FETCH offset must be either an integer value, or a numeric/decimal value with a scale of zero.");
		add(9575  , 16 , "Row size of %d exceeds the maximum allowable size of row in a memory cache, %d.");
		add(9577  , 16 , "Password contains login name substring.");
		add(9578  , 16 , "The specified password must contain at least %d %S_MSG.");
		add(9579  , 16 , "The specified password must not contain any %S_MSG.");
		add(9580  , 10 , "An error occurred while attempting to retrieve rows for table '%.*s' from other instances in the cluster. Therefore the result set may be incomplete. See the ASE error log for more information.");
		add(9582  , 16 , "Warning: The sum of the minimum numbers of alphabetic characters, digits, and special characters in a password is greater than the minimum length of the password.");
		add(9583  , 16 , "Warning: The sum of minimum number of uppercase characters and minimum number of lowercase characters in the password is greater than the minimum number of alphabetic characters.");
		add(9584  , 16 , "Warning: You have set the password expiration warning interval before setting the password expiration interval.");
		add(9585  , 16 , "Warning: You have set the password expiration warning interval to a value that exceeds the time to password expiration.");
		add(9586  , 16 , "password_admin Built-in error: %S_MSG");
		add(9587  , 16 , "The range for '%s' is %d to %d.");
		add(9588  , 16 , "You entered an invalid option name. No change was made.");
		add(9589  , 16 , "Illegal identity reservation value specified for table '%.*s'.");
		add(9590  , 16 , "Identity reservation value overflow for table '%.*s'.");
		add(9591  , 16 , "The specified identity reservation size for table '%.*s' exceeds the maximum reservation size. Please use sp_configure to increase the 'identity reservation size'.");
		add(9592  , 16 , "You can only set %s to %d.");
		add(9593  , 16 , "Conversion of input string to date format failed for parameter '%.*s'.");
		add(9594  , 10 , "Update to %s in set_password builtin has failed.For proper functioning of Sybase failover Update this file with new password as described in 'Using SybaseFailover in a High Availability System.' Password successfully changed.");
		add(9595  , 10 , "Old password encryption algorithm found for login name %.*s, suid %d, ver1 = %d, ver2 = %d, resetting password to %s");
		add(9596  , 10 , "Old password encryption algorithm found for login name %.*s, suid %d, ver1 = %d, ver2 = %d, failed to reset password.");
		add(9597  , 16 , "Failed to eliminate old password encryption algorithm use from syslogins, no changes committed.");
		add(9598  , 10 , "Old password encryption algorithm usage eliminated from %d login accounts, changes are committed.");
		add(9602  , 17 , "Adaptive Server has run out of CLEANUP ITEM BLOCKS. Re-run your command when there are fewer active users, or contact a user with System Administrator (SA) role to reconfigure Adaptive Server with more CLEANUP ITEM BLOCKS.");
		add(9605  , 10 , "Completed flushing modified pages to disk for database '%.*s' (dbid = %d) on %S_INSTID.");
		add(9606  , 10 , "Database '%.*s' is being downgraded.");
		add(9607  , 20 , "Downgrade has failed for '%.*s' database.");
		add(9608  , 10 , "Downgrade will remove some stale local language messages if their English message text change, please re-install these localized messages later.");
		add(9609  , 20 , "Please run previously saved restore_msgs.ebf or instmsgs.ebf from the version downgraded to if none were saved before running installmaster.");
		add(9610  , 16 , "The log for database '%.*s' includes a transaction (%s) that cannot be recovered by this server version.");
		add(9611  , 16 , "Cannot alter the table '%.*s' to set minimal DML logging because this table is marked for replication. Remove replication and try again.");
		add(9612  , 10 , "Cannot upgrade database '%.*s' because it is either marked 'read only', or there is no tempdb, or it is in the middle of a load sequence.");
		add(9613  , 18 , "The durability change for database '%.*s' failed.");
		add(9614  , 16 , "Warning: table '%.*s' already has 'transfer table' set '%S_MSG', ALTER TABLE was aborted.");
		add(9615  , 21 , "Failed to determine the log record at which recovery of transaction (%d,%d) should start.");
		add(9616  , 16 , "Database '%.*s' is at an older version '%d' than ASE server version '%d'.");
		add(9617  , 16 , "ALTER TABLE '%.*s' failed. You cannot alter a roundrobin partitioned table with transfer table on and a local clustered or placement index when the operation requires data copy. Drop the index and try again.");
		add(9618  , 16 , "You can use ALTER TABLE SET HASHKEYVALUES only on a dynamic hash table.");
		add(9619  , 17 , "%S_REPAGNT. Fatal error. The Rep Agent sender thread is no longer available; the Rep Agent scanner thread will stop.");
		add(9620  , 16 , "Cannot use ALTER TABLE with ADD CONSTRAINT to define dynamic hash key column. Use CREATE TABLE.");
		add(9621  , 16 , "ALTER TABLE '%.*s' failed. You cannot drop column '%.*s' because it is being used by dynamic hash key definition '%.*s'.");
		add(9622  , 16 , "ALTER TABLE failed. Parameter '%s' is not allowed on dynamic hash table.");
		add(9623  , 21 , "Attempt to read invalid log page %u (timestamp={0x%04x,0x%08x}, first log page timestamp={0x%04x,0x%08x}) in database '%.*s'. Re-run the query or restart the Adaptive Server instance.");
		add(9624  , 10 , "Failed to send the OAM recount list for database '%.*s' to other nodes. If there is a node failure before the oam recount is complete, then run the DBCC CHECKALLOC(%.*s, fix) command to manually recover these OAM counts.");
		add(9625  , 10 , "Failed to insert the object (objid %d, ptnid %d, indid %d) in the OAM recount list for database '%.*s' (%d). Run the DBCC TABLEALLOC(%d, full, fix) command to manually recover the OAM counts for this object.");
		add(9626  , 21 , "Cannot create page %u in database '%.*s' from its compressed page image (error: %d) in log record (%u,%d).");
		add(9627  , 19 , "Cannot allocate memory for the decompresion buffer in database '%.*s'. Database will not be recovered. Retry the command later.");
		add(9628  , 10 , "Warning: Cannot allocate memory to compress page image for fully logged SELECT INTO for database '%.*s'. For some pages, uncompressed data will be logged instead.");
		add(9629  , 18 , "Warning: Cannot compress page %u in database '%.*s' for fully logged SELECT INTO (error: %d). Uncompressed data will be logged instead.");
		add(9630  , 16 , "ALTER TABLE '%.*s' failed. You must specify a compression level for TEXT/IMAGE/UNITEXT column '%.*s'.");
		add(9631  , 16 , "%s failed. You cannot decrease the in-row length of column '%.*s'.");
		add(9632  , 16 , "ALTER TABLE '%s' failed. Table '%.*s' already has allocated space.");
		add(9633  , 20 , "%S_REPAGNT: Cannot authenticate Replication Server '%.*s' to use multiple replication paths.");
		add(9634  , 16 , "Rep Agent cannot decompress the row for object = %d in log record (%d,%d). Rep Agent will skip this row and continue replication.");
		add(9635  , 10 , "Suppress the job scheduler message about js maxtask.");
		add(9636  , 10 , "Job Scheduler job output line width.");
		add(9637  , 16 , "Ownership change failed. You can only change ownership of objects in the current database.");
		add(9638  , 16 , "A replication filter can only be created on a table object with local storage.");
		add(9639  , 16 , "A replication filter may not contain a computed column.");
		add(9640  , 16 , "A replication filter may not contain a user-defined function.");
		add(9641  , 16 , "A replication filter may not contain a TEXT/IMAGE/UNITEXT column.");
		add(9642  , 10 , "Enable async database init enables the asynchronous initialization of database pages at CREATE or ALTER DATABASE time. The default value is 0.");
		add(9643  , 10 , "enable dump history enables or disables the dump history feature for integrated dump/load. Adaptive Server will record dumps in the dump history file for generating load commands. The default value is 0 (disabled). This is a dynamic option.");
		add(9644  , 10 , "dump history filename sets the name of the dump history file. The default value is 'dumphist'. This is a dynamic option.");
		add(9645  , 10 , "enable concurrent dump tran enables or disables concurrent transaction dumps. Adaptive Server will allow transaction dumps to occur during a database dump. The default value is 0 (disabled). This is a dynamic option.");
		add(9646  , 10 , "enforce dump configuration enables or disables enforcement of using a dump configuration when invoking dumps. The default value is 0 (disabled). This is a dynamic option.");
		add(9647  , 16 , "Alter table drop column with no datacopy is not allowed for '%.*s'('%.*s'). The command will be aborted.");
		add(9648  , 16 , "This command requires datacopy that conflicts with the Alter table drop column command with 'with no datacopy' syntax. The command will be aborted.");
		add(9649  , 10 , "Started creating indexes for replication for %u table(s).");
		add(9650  , 10 , "Started updating first text pages for %u table(s).");
		add(9651  , 10 , "Completed creating indexes for replication for %u table(s).");
		add(9652  , 10 , "Completed updating first text pages for %u table(s).");
		add(9653  , 10 , "Started logging schemas for %u table(s).");
		add(9654  , 10 , "Completed logging schemas for %u table(s).");
		add(9655  , 10 , "Started dropping indexes for replication for %u table(s).");
		add(9656  , 10 , "Completed dropping indexes for replication for %u table(s).");
		add(9657  , 10 , "%u table(s) of %u processed. %d%% completed.");
		add(9658  , 16 , "Run reorg/rebuild for table '%.*s' before attempting '%.*s'.");
		add(9659  , 16 , "The 'filter' distribution model requires multiple scanners to be configured ('max number scanners per path' = 1).");
		add(9660  , 16 , "ALTER TABLE '%.*s' failed. You must drop the dependent replication filter '%.*s' before altering this table column.");
		add(9661  , 16 , "Ownership change failed. The new owner must have %S_MSG '%s'.");
		add(9662  , 16 , "Unable to issue a checkpoint on database '%.*s'.");
		add(9663  , 16 , "The RepAgent Thread for database '%.*s' is not running.");
		add(9664  , 16 , "At least one RepAgent Thread did not complete its processing of the transaction log.");
		add(9665  , 14 , "Adaptive Server is running in 'Standby' mode. You do not have the necessary role or privilege to login while the server is running in this mode.");
		add(9666  , 14 , "Adaptive Server is running in 'Primary Inactive' mode. You do not have the necessary role or privilege to login while the server is running in this mode.");
		add(9667  , 14 , "Adaptive Server is running in 'Primary Deactivating' mode. You do not have the necessary role or privilege to login while the server is running in this mode.");
		add(9668  , 14 , "Login failed. Adaptive Server is running in 'Standby' mode. You do not have the necessary role or privilege to login while the server is running in this mode and login redirection cannot occur since there is no Active Primary.");
		add(9669  , 10 , "enables/disables aggressive task stealing. Default is 1 (aggressive task stealing enabled)");
		add(9670  , 16 , "The truncation point of database '%.*s' has not been established with DBCC SETTRUNC.");
		add(9671  , 16 , "Deactivation failed due to %s. Resetting state to %s.");
		add(9672  , 16 , "Server reached INACTIVE state.");
		add(9673  , 16 , "Initiating log drain mechanism.");
		add(9674  , 16 , "User connections statistics:: %d in xact, %d in chained mode, %d in unchained mode, %d holding server side cursors.");
		add(9675  , 16 , "Max utility parallel degree is the maximum number of worker processes that can be used by create index or update statistics under parallel mode.");
		add(9676  , 20 , "%S_REPAGNT: multiple replication paths cannot be used with HADR. Please use 'sp_config_rep_agent' to set the 'number of replication paths' to 1.");
		add(9677  , 16 , "Recovery of database '%.*s' was unable to reconcile the disk map stored in 'master.dbo.sysusages' with the one stored in the dump.");
		add(9678  , 16 , "Cannot promote the server to PRIMARY mode due to split brain check error. Use the 'force' option to force the promotion.");
		add(9679  , 16 , "WARNING: split brain check refused to allow this server to become Primary.");
		add(9680  , 10 , "Maximum attempts to restart Job Scheduler after abnormal shutdown.");
		add(9681  , 10 , "Enable/Disable Job Scheduler Agent core dump.");
		add(9682  , 10 , "Enable/Disable Job Scheduler diagnostics logging after auto restart.");
		add(9683  , 10 , "ASE checks Job Scheduler Agent health after jsagent heartbeat interval duration (in minutes)");
		add(9684  , 17 , "%S_REPAGNT: CI-resource '%s' is insufficiently configured, please use 'sp_config_rep_agent' to change the configuration value of '%s'.");
		add(9685  , 16 , "Rep Agent on database '%.*s' switched from mode '%s' to mode '%s' because %s.");
		add(9686  , 10 , "The 'optimize dump for faster load' parameter specifies the percentage of the database used data that needs to be changed during the database dump to force the updated pages to be resent to the backup server.");
		add(9687  , 10 , "Object %.*s has been dropped. The show_condensed_text() function will return NULL.");
		add(9688  , 16 , "%s '%.*s' is already set to the desired compression level.");
		add(9689  , 10 , "Recovery prefetch size is %d log records.");
		add(9690  , 16 , "Index '%.*s' cannot be altered to set compression property.");
		add(9691  , 16 , "Index named '%.*s' not found; check sysindexes.");
		add(9692  , 16 , "Startup node for rep_agent for single instance databases can't be set or modified.");
		add(9693  , 16 , "Synchronously replicated multidatabase coordinating transaction (%d, %d) in database '%.*s' forcibly rolled back; however, subordinate transaction branches may have committed.");
		add(9694  , 16 , "Synchronously replicated multidatabase subordinate transaction (%d, %d) in database '%.*s' forcibly rolled back; however, the coordinating transaction may have committed.");
		add(9695  , 10 , "Warning: The stored procedure '%.*s', which is marked for replication as 'table', will not be replicated while 'stream replication' is enabled.");
		add(9696  , 17 , "Recovery failed to get the last oqid for database '%.*s' from SAP Replication Server because it was either unable to connect or it received an error.");
		add(9697  , 16 , "Warning: Rep Agent on database '%.*s' received an invalid truncation page from Replication Server. The received truncation page %d has a lower timestamp than the current truncation page %d and will be ignored.");
		add(9698  , 16 , "Rep Agent on database '%.*s' has received an invalid Maintenance User: '%.*s'. This is a fatal error.");
		add(9699  , 16 , "Shutdown failed: the primary server has not been deactivated. Please use sp_hadr_admin to deactivate the primary server and drain the transaction logs or use the shutdown option nowait_hadr.");
		add(9701  , 16 , "Parameter '%.*s' has an invalid type.");
		add(9702  , 16 , "Parameter '%.*s' is invalid.");
		add(9703  , 16 , "'%.*s' is not a valid account name.");
		add(9704  , 16 , "Unable to get ASE security information.");
		add(9705  , 16 , "Unable to set ASE security information.");
		add(9706  , 16 , "ASE's user account cannot be modified.");
		add(9707  , 16 , "No privilege to revoke.");
		add(9708  , 16 , "The account name provided is a domain. Unable to grant privileges to a domain.");
		add(9709  , 16 , "The account name provided is a deleted account. Unable to grant privileges to a deleted account.");
		add(9710  , 16 , "There must be at least one account with '%.*s' privilege.");
		add(9711  , 16 , "There must be at least one account with '%.*s' privilege other than the '%.*s'.");
		add(9712  , 16 , "Access granted.");
		add(9713  , 16 , "Access revoked.");
		add(9714  , 16 , "login mode");
		add(9715  , 16 , "default account");
		add(9716  , 16 , "default domain");
		add(9717  , 16 , "set host");
		add(9718  , 16 , "key _");
		add(9719  , 16 , "key $");
		add(9720  , 16 , "key @");
		add(9721  , 16 , "key #");
		add(9722  , 16 , "name");
		add(9723  , 16 , "config_item");
		add(9724  , 16 , "standard");
		add(9725  , 16 , "integrated");
		add(9726  , 16 , "mixed");
		add(9727  , 16 , "unknown mode");
		add(9728  , 16 , "true");
		add(9729  , 16 , "false");
		add(9730  , 16 , "space");
		add(9731  , 16 , "domain separator");
		add(9732  , 16 , "null");
		add(9733  , 16 , "Out of stack space. Check ASE error log for further details");
		add(9734  , 16 , "Access Control List is full (max 1000 entries). Consider granting access via groups instead");
		add(9802  , 20 , "Deletion of row in SYSPARTITIONS failed. Database id %d, Object id %d, Partition number %d.");
		add(9803  , 21 , "Missing row in SYSPARTITIONS. Database id %d, Object id %d, Partition number %d.");
		add(9805  , 10 , "Partition number %d for object id %d in database %d does not exist.");
		add(9807  , 20 , "Process %d encountered deadlock while trying to lock control page %u of partition %d for object id %d.");
		add(9809  , 21 , "Control page %u specified for partition number %d of object id %d in database %d does not exist.");
		add(9810  , 21 , "Control page %u specified for partition number %d for object id %d in database %d is corrupt.");
		add(9814  , 21 , "SYSPARTITIONS table is missing in database %d.");
		add(9816  , 17 , "Unable to allocate an in-memory partition structure for object id %d in database %d. To increase the number of available partitions update the 'partition groups' configuration parameter.");
		add(9817  , 16 , "Invalid object ID %d. Valid user object ID is a positive integer.");
		add(9818  , 16 , "Invalid partition number %d. Valid partition number is a positive integer.");
		add(9819  , 11 , "Object ID %d does not exist in database `%.*s'.");
		add(9820  , 11 , "Partition number %d for object ID %d in database `%.*s' does not exist.");
		add(9821  , 12 , "The object `%.*s' is not a partitioned table.");
		add(9822  , 21 , "An error occured during an update to a control page. The old last page ID %u does not match the last page ID of any partition for object `%.*s' (ID %d) in database `%.*s' (ID %d). The transaction is being rolled back.");
		add(9823  , 20 , "Insert new partition row in SYSPARTITIONS failed for slice number %d. Database id %d, Object id %d, Total number of slices %d.");
		add(9824  , 20 , "Update row in SYSPARTITIONS failed. Database id %d, Object id %d, Partition number %d");
		add(9826  , 16 , "The number of data pages in partition number %d for table '%.*s' in database '%.*s' could not be determined because the table is currently being altered.");
		add(9827  , 10 , "Warning: Control page %u upgrade for partition number %d for object ID %d in database '%S_DBID' may not have been done correctly. Please run sp_helpartition on this table and, if necessary, correct the values with UPDATE PARTITION STATISTICS.");
		add(9828  , 10 , "Warning: Column '%.*s' is being created as an %s column.");
		add(9829  , 22 , "Compressed data row %p in objid %d, dbid %d is corrupted.");
		add(9830  , 16 , "Compression version '%d' is invalid for table '%.*s' (ID %d), database '%.*s' while compressing page %u.");
		add(9831  , 16 , "%s thread pool command failed on %s instance. For the Cluster Edition, check the error log of each instance.");
		add(9832  , 10 , "WITH HASHING does not support WITH SAMPLING = %ld PERCENT, sampling phrase is ignored.");
		add(9835  , 16 , "Illegal value '%d' specified for '%s' command option '%s'. The legal values are between '%d' and '%d'.");
		add(9837  , 16 , "max_resource_granularity is not supported for UPDATE STATISTICS of proxy tables.");
		add(9838  , 16 , "Hashing options are not supported for UPDATE STATISTICS of proxy tables.");
		add(9839  , 16 , "Not enough tempdb buffer cache memory available for operation.");
		add(9840  , 20 , "Internal hash based statistics collection error on column (%.*s). Contact SAP Technical Support for help.");
		add(9841  , 10 , "Update Statistics %.*s.");
		add(9842  , 10 , "Update Statistics index scan started on index '%.*s'.");
		add(9843  , 10 , "Update Statistics index scan started on index '%.*s', partition '%.*s'.");
		add(9844  , 10 , "Update Statistics table scan started on table '%.*s'.");
		add(9845  , 10 , "Update Statistics table scan started on table '%.*s' for summary statistics.");
		add(9846  , 10 , "...Sorting started for column tuple.");
		add(9847  , 10 , "...Sorting started for column '%.*s' (column id = %d).");
		add(9848  , 10 , "...Column '%.*s' (column id = %d) is moved from hashing to sorting.");
		add(9849  , 10 , "...It is using existing scan to hash column '%.*s' (column id = %d).");
		add(9850  , 10 , "...Column '%*s' (column id = %d) is picked as hash victim due to limited resource.");
		add(9851  , 10 , "Update Statistics table scan started on table '%.*s', partition '%.*s'.");
		add(9852  , 10 , "Update Statistics table scan started on table '%.*s', partition '%.*s' for summary statistics.");
		add(9853  , 16 , "Index name '%.*s' already specified.");
		add(9854  , 16 , "User '%.*s' can not own any objects.");
		add(9855  , 18 , "Internal statistics collection error on object (%.*s) column (%.*s). Contact SAP Technical Support for help.");
		add(9856  , 16 , "The option '%.*s' cannot be used for data partitions.");
		add(9857  , 16 , "%s using the %s parameter not allowed on columns");
		add(9858  , 16 , "In the %s command, you cannot specify histogram options at the same time as %s parameters.");
		add(9859  , 16 , "A DDL command like ALTER/TRUNCATE TABLE is active on partition '%.*s' of object '%.*s' in database '%.*s'. Please retry your query later.");
		add(9860  , 16 , "%s %s failed on '%.*s' in database '%.*s' as partition level locking is not enabled.");
		add(9861  , 10 , "%s attribute disabled for table '%.*s' in database '%.*s' as '%s' command leaves table with only one partition.");
		add(9862  , 16 , "Shutdown failed: the primary server transaction logs have not been drained. Please use sp_hadr_admin to drain the transaction logs or use the shutdown option nowait_hadr.");
		add(9863  , 16 , "%s operations cannot be specified on table with %s lockscheme.");
		add(9864  , 16 , "%s failed. Turn %s for '%.*s' before running %s.");
		add(9865  , 16 , "%s failed. %s is not supported for %s table '%.*s'.");
		add(9866  , 16 , "Statistics not found in column '%.*s' (column id = %d) specified in the dynamic_histogram option.");
		add(9867  , 16 , "Column '%.*s' (column id = %d) has already been configured for dynamic histogram.");
		add(9868  , 16 , "Column '%.*s' (column id = %d) contains all NULLs.");
		add(9869  , 16 , "The dynamic_histogram option is not permitted on system tables.");
		add(9870  , 20 , "Dynamic histogram mismatch between catalog histogram maximum and cached value maximum for database '%.*s' table '%.*s', column '%.*s'.");
		add(9871  , 20 , "Dynamic histogram internal error for database '%.*s' table '%.*s', column '%.*s'.");
		add(9872  , 20 , "Dynamic histogram internal error, mismatch between systabstats and cached DES values for database '%.*s' table '%.*s' '.");
		add(9873  , 16 , "Dynamic histogram error, unexpectedly large colid for database '%.*s' table '%.*s', column '%.*s'.");
		add(9874  , 20 , "Dynamic histogram internal error during DES initialization for database id=%d table id=%d, column id=%d");
		add(9875  , 20 , "Dynamic histogram internal error for database id=%d table id=%d");
		add(9876  , 16 , "Dynamic histogram requires new histogram with rowcount for database '%.*s' table '%.*s', column '%.*s'.");
		add(9877  , 16 , "Update statistics transaction failure for database '%.*s' table '%.*s', column '%.*s'.");
		add(9878  , 16 , "Dynamic histogram inconsistency corrected for database '%.*s' table '%.*s', column '%.*s'.");
		add(9879  , 16 , "Database '%.*s' Table '%.*s' Column '%.*s' (column id = %d) is not configured with the dynamic histogram option.");
		add(9880  , 16 , "You cannot specify the join_skew_threshold histogram option at the same time as 'partition name', or other options. Only a list of columns (col1), (col2), etc is allowed.");
		add(9881  , 16 , "The setting of the join_skew_threshold value failed. The column does not have any existing histogram statistics.");
		add(9882  , 16 , "Failed to set the join_skew_threshold due to unexpected catalog activity, try again.");
		add(9883  , 16 , "'%s' failed because the license '%s' has expired or following configuration option is not enabled: %s.");
		add(9884  , 16 , "Failed to open the database '%.*s");
		add(9885  , 10 , "The %S_MSG of %d devices in database '%.*s' has finished.");
		add(9886  , 10 , "The %S_MSG of database '%.*s' has finished.");
		add(9887  , 10 , "The %S_MSG of database '%.*s' has started.");
		add(9888  , 16 , "%s operations cannot be specified on non-unique index.");
		add(9889  , 10 , "Output files are required to be placed under directory '%.*s'.");
		add(9890  , 10 , "Output files may not be placed under directory '%.*s'.");
		add(9901  , 14 , "Permission denied.  Only a user with curread set to @@data_high can perform the DBCC command '%.*s'.");
		add(9902  , 14 , "Only users with SA and SSO roles can run this dbcc dbrepair command for the database %S_DBID.");
		add(9903  , 14 , "Only users with SA and SSO roles having their curread dominating the maxhold of the database can run this dbcc dbrepair command for the database '%S_DBID'.");
		add(9904  , 10 , "Total (# of text chains = %d text pages = %d) in this table.");
		add(9905  , 10 , "Processed %d tables. Found %d good text entries, %d bad text entries in this database");
		add(9906  , 16 , "Unrecognized option.  Available options: dbcc engine(net, show, engine#), dbcc engine(net, showall), dbcc engine(net, netengine)");
		add(9908  , 16 , "Syspartitions system table does not exist in database id %S_DBID.");
		add(9909  , 10 , "The total number of data pages in partition '%.*s' (partition ID %d) is %d.");
		add(9911  , 10 , "Object %d has one row in Syspartitions");
		add(9912  , 10 , "Object %d has partition %d instead of %d in Syspartitions");
		add(9913  , 16 , "MAX_ROWS_PER_PAGE value of %d is invalid. It must be between 0 and %d.");
		add(9914  , 16 , "Amount of memory transferred (%dk) is less than the amount of memory requested (%dk).");
		add(9915  , 16 , "I/O size must be a power of 2.");
		add(9916  , 16 , "I/O size must be a power of 2.");
		add(9917  , 16 , "Can't find database id for %.*s. Check that this database exists and re-run the command.");
		add(9918  , 16 , "Encountered error using dbid %d.");
		add(9919  , 16 , "Can't find object id for %.*s.  Check the object name and re-run this command.");
		add(9920  , 16 , "Index id %d not found for object id %d, dbid %d.");
		add(9921  , 16 , "Index %.*s not found for object id %d dbid %d.");
		add(9922  , 16 , "The first page %u in sysindexes for table '%.*s' does not match with first page %u for the table's first partition in Syspartitions.");
		add(9923  , 16 , "The first page %u in syspartitions for partition %d of table '%.*s' has previous page # %u in its page header. The previous page # should be NULL.");
		add(9924  , 16 , "The last page %u in syspartitions for partition %d of table '%.*s' has next page # %u in its page header. The next page number should be NULL.");
		add(9926  , 16 , "This option has been converted to the configuration parameter '%s'. Use 'sp_configure' to set it.");
		add(9927  , 16 , "This option requries a table name as the third parameter. Use 'sp_configure '%s'' to set the option serverwide.");
		add(9928  , 16 , "This option has been disabled. Use 'sp_poolconfig' instead.");
		add(9929  , 14 , "Only the DBO of database %S_DBID or a user with System Administrator (SA) role can run DBCC TEXTALLOC command.");
		add(9931  , 22 , "The %S_MSG page (%u) found in the page chain does not match with the %S_MSG page (%u) found in the slice control page (%u), for table '%.*s', on slice %d. The table may be corrupt.");
		add(9932  , 22 , "The %S_MSG page (%u) found in the page chain doesn't match with the %S_MSG page (%u) stored in the Sysindexes for table '%.*s'. The table may be corrupt.");
		add(9934  , 16 , "Invalid index ID %d. Values for index ID must be between 0 and %d.");
		add(9935  , 10 , "ASE will not refresh index descriptor as the object descriptor for objid %d in dbid %d is not installed in cache.");
		add(9936  , 20 , "Error while trying to refresh sysindexes row within index descriptor with indid %d objid %d and dbid %d.");
		add(9938  , 16 , "Table with ID %d not found; check sysobjects.");
		add(9939  , 16 , "DBCC %s command is not supported anymore.");
		add(9940  , 16 , "The source text of object named '%s' with object id '%d' has already been hidden.");
		add(9941  , 16 , "The source text of object named '%s' with object id '%d' is missing and it is not hidden.");
		add(9942  , 16 , "Failed to hide the source text.");
		add(9943  , 16 , "The hidden text of object named '%s' with object id '%d' does not exist.");
		add(9944  , 10 , "Too many errors have been detected on device '%.*s' (physical device: %.*s). Page and object checking on that device has been discontinued. (The CHECKSTORAGE operation stops when more than 25%% of the checks are abandoned.)");
		add(9945  , 10 , "Too many errors have been detected on table '%.*s' index '%.*s'. Checking for that object will be discontinued. (The CHECKSTORAGE operation stops when more than 25 %% of the checks are abandoned.)");
		add(9946  , 17 , "An attempt to reserve a %dK buffer failed. Increase the size of the %dK buffer pool in the buffer cache '%.*s'.");
		add(9947  , 17 , "An attempt to allocate memory failed due to insufficient ASE memory.");
		add(9948  , 17 , "The CHECKSTORAGE operation failed to cache a scan workspace row because of a cache overflow. This is an internal error. Please contact SAP Technical Support.");
		add(9949  , 24 , "An I/O in a workspace failed, page %u in database %d. Check your hardware for problems that could cause I/O failures.");
		add(9950  , 17 , "Workspace '%.*s' is incorrectly allocated. Use sp_dbcc_createws to create a new workspace.");
		add(9951  , 17 , "Workspace '%.*s' is too fragmented to be used. Use sp_dbcc_createws and sp_dbcc_updateconfig to correct the problem.");
		add(9952  , 17 , "Workspace '%.*s' is too small to permit the CHECKSTORAGE operation to proceed. Use sp_dbcc_alterws and sp_dbcc_updateconfig to correct the problem.");
		add(9953  , 20 , "ASE failed to synchronize the activity of a worker process with the coordinating process. This is an internal error. Please contact SAP Technical Support.");
		add(9954  , 10 , "Storage checks for '%.*s' are complete. DBCC is now recording the results in the dbccdb database.");
		add(9955  , 20 , "A worker process could not access database '%.*s'. This is an internal error. Please contact SAP Technical support.");
		add(9956  , 10 , "A worker process failed to complete its assigned work during the scan phase. The results of the CHECKSTORAGE operation will be incomplete.");
		add(9957  , 10 , "A worker process failed to complete its assigned work during the page chain check phase. The results of the CHECKSTORAGE operation will be incomplete.");
		add(9958  , 10 , "A worker process failed to complete its assigned work during the OAM check phase. The results of the CHECKSTORAGE operation will be incomplete.");
		add(9959  , 20 , "The CHECKSTORAGE operation has aborted.");
		add(9960  , 20 , "A non-recoverable error has occurred in the CHECKSTORAGE operation. The operation has been aborted.");
		add(9961  , 17 , "DBCC failed to connect to the requested number of worker processes. The number of workers configured is insufficient, or the number of workers exceeds 128. Use sp_dbcc_updateconfig to reduce 'max worker processes' for this database.");
		add(9962  , 17 , "Access to table '%.*s' index '%.*s' in the target database failed.");
		add(9963  , 16 , "An error occurred while attempting to insert a row into the dbcc_faults table or the dbcc_fault_params table.");
		add(9964  , 16 , "Database '%.*s' was not found. Use sp_helpdb to list the available databases.");
		add(9965  , 16 , "The entries in dbcc_config for database '%.*s' are either missing or invalid. Use sp_dbcc_evaluatedb to determine appropriate values for the entries and sp_dbcc_updateconfig to set them.");
		add(9966  , 11 , "DBCC could not access the scan workspace '%.*s'. Verify that the workspace exists.");
		add(9967  , 11 , "DBCC could not access the text workspace '%.*s'. Verify that the workspace exists.");
		add(9968  , 16 , "DBCC could not evaluate ASE's device configuration. Check the contents of the dbcc_dev_info table.");
		add(9969  , 20 , "The operation sequence number update for database '%.*s' in the dbcc_config table failed.");
		add(9970  , 20 , "DBCC cannot update the finish time in dbcc_operation_log table for this operation(opid = '%d'%s) of database '%.*s'. This can be patched by executing sp_dbcc_patch_finishtime.");
		add(9971  , 20 , "DBCC failed to schedule work for the worker processes. This is an internal error. Please contact SAP Technical Support.");
		add(9972  , 20 , "An error %d occurred while inserting the results into the dbcc_counters table.");
		add(9973  , 20 , "An error occurred while inserting the results into the dbcc_operation_results table.");
		add(9974  , 10 , "DBCC CHECKSTORAGE for database '%.*s' sequence %d completed at %s. %d faults and %d suspect conditions were located. %d checks were aborted. You should investigate the recorded faults, and plan a course of action that will correct them.");
		add(9975  , 10 , "DBCC CHECKSTORAGE for database '%.*s' encountered an error. Some results may not be available. Correct the problems reported and reexecute the CHECKSTORAGE command.");
		add(9976  , 10 , "There is an inconsistency between the dbcc_dev_info table and the sysdevices table. Use DBCC CHECKDEVINFO to regenerate the dbcc_dev_info table.");
		add(9977  , 17 , "The cache '%.*s' specified in the dbcc_config table does not exist.");
		add(9978  , 17 , "The %dK buffer pool in the configured cache '%.*s' is too small. %dK is the minimum size.");
		add(9979  , 10 , "Too many worker processes (%d) are configured for the available %dK buffer pool. This buffer pool can only support %d workers.");
		add(9980  , 10 , "%d text column values were not checked because the text workspace was too small. Use sp_dbcc_alterws to increase its size by %dK.");
		add(9981  , 16 , "Correct syntax is:tdbcc createws({dbccdb|dbccalt}, segment name, workspace name, {scan|text}, size) tdbcc alterws({dbccdb|dbccalt}, workspace name, {scan|text}, size)");
		add(9982  , 16 , "The minimum size for a DBCC workspace is %d pages.");
		add(9983  , 16 , "DBCC failed to create the workspace '%.*s'.");
		add(9984  , 16 , "DBCC could not expand the size of workspace '%.*s' in database '%.*s' to %d pages.");
		add(9985  , 16 , "DBCC could not truncate the size of workspace '%.*s' in database '%.*s' by %d pages.");
		add(9986  , 10 , "Suspect conditions are to be treated as faults if the same suspect condition persists in subsequent CHECKSTORAGE operations, or if they are also detected by other DBCC functions.");
		add(9987  , 16 , "Extended header bits are set incorrectly for object %d, DOL datapage %d, partition ID %d.");
		add(9988  , 16 , "DOL datapage %u, partition ID %d contains the NCFS value %d, which is larger than the page's available space (%d).");
		add(9989  , 16 , "The number of deleted rows (%d) in the page header of DOL datapage %u, partition ID %d is incorrect. This value cannot be negative.");
		add(9990  , 16 , "The insert free space value (%d) in the page header of DOL datapage %u, partition ID %d is greater than the sum of cfs and ncfs (%d) in the page.");
		add(9991  , 16 , "Page %u, partition ID %d, of object %d, contains an orphan row at offset %d which must be marked committed delete and is not.");
		add(9992  , 16 , "The actual number of rows (%d) in DOL datapage %d, partition ID %d, and count of #rows - 'nextrno' - %d in the page header, do not match.");
		add(9993  , 16 , "Mismatch between the 'ncfs counter' value (%d) in the page header of DOL datapage %u, partition ID %d, and the actual amount of garbage (%d) in the page.");
		add(9994  , 16 , "Mismatch between the 'deleted row count' value (%d) in the page header of DOL datapage %u, partition ID %d, and the actual number of deleted rows (%d) in the page.");
		add(9995  , 16 , "Mismatch between the 'insert free space' value (%d) in the page header of DOL datapage %u, partition ID %d, and the actual amount of 'insert free space' (%d) computed from the page with an 'expected rowsize' value of %d.");
		add(9996  , 16 , "Keys of index id %d for table '%.*s' in %S_MSG not in proper order. Drop and recreate the index. (index page %u)");
		add(9997  , 16 , "Root page %u in index id %d of object id %d does not have BT_ROOT bit set");
		add(9998  , 16 , "Index page %u has object id %d which is different from object id %d");
		add(9999  , 16 , "Rids not in ascending order in index page %u for row %d at offset %d (indid %d, object %d). Drop and recreate the index.");
	}
	private void init3()
	{
		add(10101 , 16 , "The object_type column cannot be NULL.");
		add(10102 , 16 , "The attrib_notify() function can only be used from a system stored procedure or with ad hoc updates enabled.");
		add(10104 , 16 , "Class %d is not a valid attribute class.");
		add(10105 , 16 , "Attribute %d is not a valid attribute within class %d.");
		add(10106 , 16 , "Class cannot be NULL.");
		add(10107 , 16 , "Attribute cannot be NULL.");
		add(10108 , 16 , "The 'action' parameter cannot be NULL.");
		add(10109 , 16 , "The value of the parameter '%s' is '%d'. The value should be between %d and %d.");
		add(10110 , 10 , "The entry being added will have no effect due to precedence or scope rules.");
		add(10111 , 10 , "The entry being dropped is preceded by another specification; dropping the entry will have no effect.");
		add(10201 , 10 , "NESTING LEVEL %u SUBQUERIES FOR STATEMENT %u.");
		add(10202 , 10 , "%s  QUERY PLAN FOR SUBQUERY %u (at nesting level %u and at line %u).");
		add(10203 , 10 , "%s   Subquery under an IN predicate.");
		add(10204 , 10 , "%s   Subquery under an ANY predicate.");
		add(10205 , 10 , "%s   Subquery under an ALL predicate.");
		add(10206 , 10 , "%s   Subquery under an EXISTS predicate.");
		add(10207 , 10 , "%s   Subquery under an EXPRESSION predicate.");
		add(10208 , 10 , "%s   Correlated Subquery.");
		add(10209 , 10 , "%s   Non-correlated Subquery.");
		add(10210 , 10 , "%s  END OF QUERY PLAN FOR SUBQUERY %u.");
		add(10211 , 10 , "%s  Run subquery %u (at nesting level %u).");
		add(10212 , 10 , "The cursor is read only because it contains a subquery.");
		add(10213 , 10 , "%s  The update mode is deferred_varcol.");
		add(10214 , 10 , "%s  The update mode is deferred_index.");
		add(10215 , 10 , "There have been %d scan fixups and %d matching search argument fixups for this cursor.");
		add(10216 , 10 , "The cursor is read only because it is referencing a dynamic table.");
		add(10217 , 10 , "        Executed by coordinating process.");
		add(10218 , 10 , "Executed in parallel by coordinating process and %d worker processes.");
		add(10219 , 10 , "Executed in parallel by %d worker processes.");
		add(10220 , 10 , "%s Executed in parallel with a %d-way partition scan.");
		add(10221 , 10 , "Executed in parallel by coordinating process and %d worker processes.");
		add(10222 , 10 , "        Parallel work table merge.");
		add(10223 , 10 , "        Parallel network buffer merge.");
		add(10224 , 10 , "        Parallel result buffer merge.");
		add(10225 , 10 , "Auxiliary scan descriptors required: %d");
		add(10226 , 10 , "The specified spid value '%d' is out of range. It must be positive and not exceed the maximum number of user connections.");
		add(10227 , 10 , "There is no active server process for the specified spid value '%d'.  Possibly the user connection has terminated.");
		add(10228 , 10 , "The specified spid value '%d' applies to a server internal process, which does not execute a query plan.");
		add(10229 , 10 , "The process with the specified spid value '%d' has not been assigned an sqltext structure.  Query plan retrieval cannot continue.");
		add(10230 , 10 , "The query plan for spid '%d' is unavailable. Possibly the query has not started or has finished executing.");
		add(10231 , 10 , "The current batch id '%u' does not match the specified batch id '%d'. Specify just the spid value to obtain the current batch id.");
		add(10232 , 10 , "The current context id '%d' does not match the specified context id '%d'. Specify just the spid value to obtain the current context id.");
		add(10233 , 10 , "The specified statement number '%d' is greater than the number of statements in the batch or procedure. Specify just the spid value to obtain the current statement number.");
		add(10234 , 10 , "The SQL batch contains '%d' bytes. Text is '%.*s'.");
		add(10235 , 10 , "The cursor was closed because the object associated with it has been dropped.");
		add(10236 , 10 , "Executed by %d worker processes.");
		add(10237 , 10 , "%s Executed in parallel with a %d-way hash scan.");
		add(10239 , 10 , "%s  With %S_MSG Buffer Replacement Strategy for data pages.");
		add(10240 , 10 , "%s  Using I/O Size %d Kbytes for data pages.");
		add(10241 , 10 , "ASC");
		add(10242 , 10 , "DESC");
		add(10243 , 10 , "        Index key order not found.");
		add(10244 , 10 , "Optimized using simulated statistics.");
		add(10246 , 10 , "Optimized using an Abstract Plan (ID : %d).");
		add(10247 , 10 , "Optimized using the Abstract Plan in the PLAN clause.");
		add(10249 , 10 , "        Parallel data merge using %d worker processes.");
		add(10250 , 10 , "        Worktable%d created for sort merge join.");
		add(10251 , 10 , "        Merge join (outer table).");
		add(10252 , 10 , "        Merge join (inner table).");
		add(10253 , 10 , "        Serial data merge.");
		add(10254 , 10 , "        Data copying.");
		add(10255 , 10 , "        Text/Image column(s) deallocation.");
		add(10256 , 10 , "        Catalog updates.");
		add(10257 , 10 , "        Executing a newly cached statement (SSQL_ID = %u).");
		add(10258 , 10 , "        Executing a previously cached statement (SSQL_ID = %u).");
		add(10259 , 10 , "The cursor was closed because its current scan position could not be maintained following a severe error during a FETCH operation.");
		add(10260 , 10 , "The cursor is declared as %s cursor.");
		add(10261 , 10 , "%s  Worktable%d created in %s locking mode.");
		add(10262 , 10 , "        The type of query is %s.");
		add(10263 , 10 , "%s Using Worktable%d for internal storage.");
		add(10264 , 10 , "Optimized using the forced options (internally generated Abstract Plan).");
		add(10265 , 10 , "%s If probe succeeds, raise error.");
		add(10266 , 10 , "%s If probe fails, raise error.");
		add(10267 , 10 , "%s If probe succeeds, insert into worktable.");
		add(10268 , 10 , "%s If probe fails, insert into worktable.");
		add(10269 , 10 , "%s Probe if needed: If probe succeeds, insert into worktable.");
		add(10270 , 10 , "%s Unknown action.");
		add(10271 , 10 , "%s External Definition: %.*s");
		add(10272 , 10 , "%s SERVER: %.*s");
		add(10273 , 10 , "%s Using Virtually hashed index.");
		add(10274 , 10 , "QUERY PLAN FOR SQL UDF %s :");
		add(10275 , 10 , "END OF QUERY PLAN FOR SQL UDF %s .");
		add(10276 , 10 , "QUERY PLAN IS RECOMPILED DUE TO %s.");
		add(10277 , 10 , "THE RECOMPILED QUERY PLAN IS:");
		add(10278 , 10 , "Optimized using Deferred Compilation.");
		add(10279 , 10 , "To be Optimized at runtime using Deferred Compilation.");
		add(10280 , 10 , "Optimized at runtime using Deferred Compilation.");
		add(10281 , 10 , "%s EXECUTE TABLE FUNCTION");
		add(10282 , 10 , "%s Table (or index) resides in in-memory database.");
		add(10283 , 10 , "Optimized using %s Mode");
		add(10284 , 10 , "Optimizer timed out %d time(s) while generating this plan, Timeout Limit percentage: %d");
		add(10285 , 10 , "To be prepared at runtime using simplified native access plan.");
		add(10286 , 10 , "Prepared at runtime using simplified native access plan.");
		add(10287 , 10 , "Of which, procedure cache limit was exceeded %d time(s), Limit: %d, Max Useage: %d");
		add(10288 , 10 , "This query is always executed on %s.");
		add(10289 , 16 , "Statement uses Snapshot Isolation.");
		add(10290 , 16 , "Statement has at least one snapshot_isolation disabled table. Statement does not use Snapshot Isolation.");
		add(10291 , 10 , "Fact table hint failed due to: %s");
		add(10292 , 10 , "Optimized using fact table hint");
		add(10293 , 16 , "Table/s %s in the statement are not snapshot_isolation enabled.");
		add(10294 , 10 , "The cursor is declared %s.");
		add(10295 , 10 , "Statement does not use Snapshot Isolation.");
		add(10301 , 14 , "Can't find database id for '%.*s'. Check that this database exists and re-run the command.");
		add(10302 , 14 , "Only the DBO of database '%S_DBID' or a user with System Administrator (SA) role can run this command.");
		add(10303 , 14 , "Object named '%.*s' not found; check sysobjects.");
		add(10304 , 14 , "Only the owner of object '%S_OBJID' or a user with '%.*s' role can run this command.");
		add(10305 , 14 , "Datatype named %.*s not found in database '%.*s'; check systypes.");
		add(10306 , 14 , "You do not have the permission to use datatype named %.*s in database %.*s.");
		add(10307 , 14 , "Curread should dominate the label being used.");
		add(10308 , 14 , "Supplied label is invalid.");
		add(10309 , 14 , "Curwrite is not equal to the label at which write is attempted.");
		add(10310 , 14 , "Session labels dominance relationship has been violated by the label being used.");
		add(10311 , 14 , "You must use one of the SAP-supplied auditing stored procedures to change audit options.");
		add(10312 , 14 , "The ad_hoc_audit builtin can only be called from the following stored procedures: sp_addauditrecord, sp_bindmsg, sp_unbindmsg, sp_bindefault, sp_unbindefault, sp_bindrule, sp_unbindrule, sp_addmessage, sp_dropmessage.");
		add(10313 , 14 , "The caller of the set_password builtin was not found!  Password left unchanged.");
		add(10314 , 14 , "Only a person with System Security Officer (SSO) role can change another person's password.");
		add(10315 , 14 , "Invalid caller's password specified, password left unchanged.");
		add(10316 , 14 , "New password supplied is the same as the previous password.  Please supply a different new password.");
		add(10317 , 14 , "The specified password is too short. Passwords must be at least %d character(s) long.");
		add(10318 , 14 , "Invalid user specified, password left unchanged.");
		add(10319 , 14 , "SET ROLE fails.  The caller is not granted with the specified role.  Please contact a user with System Security Officer (SSO) role for help.");
		add(10320 , 14 , "SET ROLE fails.  The caller cannot assume the new user identity (uid) in the current database.  Please contact a user with System Security Officer (SSO) role for help.");
		add(10321 , 14 , "Ad-hoc updates to system catalogs not enabled. A user with System Security Officer (SSO) role must reconfigure system to allow this.");
		add(10322 , 14 , "In a CREATE SCHEMA statement, the authorization id must match the current user name. The supplied authorization id, '%.*s', does not match the current user name, '%.*s'.");
		add(10323 , 14 , "You do not have the permission to use datatype id %d in database id %d.");
		add(10324 , 14 , "User '%.*s' not found in database '%S_DBID'.; check sysusers.");
		add(10325 , 14 , "Database named %.*s not found; check sysdatabases.");
		add(10326 , 14 , "Suspect object %S_OBJID, database %S_DBID found. Cannot execute query.");
		add(10327 , 14 , "Procedure %S_OBJID, database %S_DBID with labels found UNCERTIFIED. Cannot execute query.");
		add(10328 , 14 , "UNCERTIFIED object %S_OBJID, database %S_DBID accessed by CERTIFIED object %S_OBJID, database %S_DBID. Cannot execute query.");
		add(10329 , 14 , "Sysobjects entry NOT found for procedure buffer entry.");
		add(10330 , 14 , "%s permission denied on object %S_OBJID, database %S_DBID, owner %.*s");
		add(10331 , 14 , "Permission denied, database %S_DBID, owner %.*s. You need the following permission(s) to run this command: %s.");
		add(10332 , 14 , "%s permission denied on column %.*s of object %S_OBJID, database %S_DBID, owner %.*s");
		add(10333 , 14 , "Incorrect DBCC command: Please see the Commands Reference Manual for DBCC commands and options.");
		add(10334 , 14 , "Permission related internal error was encountered.  Unable to continue execution.");
		add(10335 , 14 , "SET label (CURREAD, CURWRITE) failed because new value is an invalid label, or new value doesn't satisfy the dominance relationships among session labels.");
		add(10336 , 14 , "Permission denied. Only the Database Owner (DBO) or a user with the System Administrator (SA), System Security Officer (SSO), or Oper role can execute this command for database '%S_DBID'.");
		add(10337 , 16 , "Object '%S_OBJID' not found.");
		add(10338 , 14 , "Permission denied.  User's curwrite does not match the sensitivity label of object '%S_OBJID'.");
		add(10339 , 16 , "Database '%S_DBID' not found.");
		add(10340 , 14 , "Permission denied.  User's curwrite does not match the sensitivity label of database '%S_DBID'.");
		add(10341 , 14 , "Only users with SA and SSO roles can run this dbcc dbrepair command for the database %S_DBID.");
		add(10342 , 14 , "Only users with SA and SSO roles can run this dbcc dbrepair command for the database %S_DBID.");
		add(10343 , 14 , "Permission denied.  Only a user with curwrite set to @@data_low can perform the command '%.*s'.");
		add(10344 , 14 , "Permission denied.  Only a user with curwrite set to @@data_high can perform the command '%.*s'.");
		add(10345 , 14 , "Permission denied.  The user cannot insert into the object '%S_OBJID'.");
		add(10346 , 14 , "Permission denied.  The user cannot insert into the object '%S_DBID'.");
		add(10347 , 14 , "Permission denied.  The subject cannot see all the contents of the container object '%S_OBJID'.");
		add(10348 , 14 , "Permission denied.  The subject cannot see all the contents of the container object database '%S_DBID'.");
		add(10349 , 14 , "Permission denied.  Only a user with curread set to @@data_high can perform the command '%.*s'.");
		add(10350 , 14 , "Permission related internal error was encountered.  Unable to continue execution.");
		add(10351 , 14 , "Server user id %d is not a valid user in database '%.*s'");
		add(10352 , 14 , "You can only use SELECT or SELECT INTO with the special table.");
		add(10353 , 14 , "You must have any of the following role(s) to execute this command/procedure: '%.*s' . Please contact a user with the appropriate role for help.");
		add(10354 , 14 , "Permission denied. You must be either the system administrator (SA), the database administrator (dbo), or the owner of this object to perform this operation.");
		add(10355 , 16 , "Changing certification state of object %S_OBJID, database %S_DBID to SUSPECT because of change in state of dependent object %.*s (previous object id %d), database %S_DBID.");
		add(10356 , 14 , "Illegal datatype encountered; check systypes.");
		add(10357 , 14 , "Permission denied. User's curwrite does not match the sensitivity label of datatype named '%.*s' in database '%.*s'.");
		add(10358 , 14 , "Curread cannot be set below the current database's hurdle.");
		add(10359 , 18 , "The curread and curwrite labels of the Client do not equal the connection level for the remote Server.");
		add(10360 , 18 , "Site '%.*s' not found in sysservers.");
		add(10361 , 14 , "The attrib_notify() function can only be used from a system stored procedure or with ad hoc updates enabled.");
		add(10362 , 14 , "The logschema() built-in function can only be called from the following stored procedures: sp_rename, sp_setreplicate, sp_setreptable, sp_setrepproc.");
		add(10363 , 14 , "The built-in function '%.*s' can only be called from system stored procedures.");
		add(10364 , 14 , "Permission denied. You must either be the database/object owner or possess any of the following roles in order to perform this operation: '%.*s'.");
		add(10365 , 14 , "Permission denied. You must have '%s' access on the table to lock it in '%s' mode.");
		add(10366 , 14 , "System catalog updates are not allowed in transactions with %s as coordinator.");
		add(10367 , 16 , "Permission denied on the %s ACF built-in.");
		add(10368 , 16 , "Set session authorization permission denied because the target login has a role that you do not have and you have been restricted from using.");
		add(10369 , 14 , "Permission denied. You must be either the database or the object owner or have %.*s to perform this operation.");
		add(10370 , 14 , "Permission denied. Only the DBO of the current database or a user with sso_role can modify the owner of an object/user-defined type.");
		add(10372 , 14 , "Permission denied. Only the key owner or a user with sso_role can modify the encryption key ownership.");
		add(10373 , 14 , "Permission denied. DBO cannot modify the ownership of objects concretely owned by DBO.");
		add(10376 , 14 , "%s permission denied on database '%.*s'. User must have '%s' privilege or be the owner of the template database '%S_DBID'.");
		add(10377 , 14 , "ALTER DATABASE permission denied on database '%.*s'. User must be the owner of the new template database '%S_DBID'.");
		add(10378 , 16 , "Tables referenced by a row-filtering or activation predicate may not in turn require predicated access.");
		add(10379 , 16 , "An object with id %d in database %d referenced by a row-filtering or activation predicate no longer exists.");
		add(10380 , 14 , "Role '%.*s' has not been set on in the current session because its activation predicate returned FALSE.");
		add(10381 , 16 , "Command fails because a row-filtering predicate with object id %S_OBJID, database id %S_DBID is incompatible with the current database schema or server options. The administrator must revoke and redo the predicated grant");
		add(10383 , 16 , "The builtin %s is for Adaptive Server internal use and may not be included in the predicate of a GRANT or GRANT ROLE statement.");
		add(10384 , 14 , "Permission denied. You must have any of the following privilege(s) to execute this command/procedure: '%.*s'.");
		add(10385 , 14 , "Permission denied. You must have all of the following privilege(s) to execute this command/procedure: '%.*s'.");
		add(10386 , 14 , "%s permission denied on %.*s, owner %.*s");
		add(10387 , 16 , "You may not use the GRANTED BY option to GRANT or REVOKE permissions you received through the WITH GRANT OPTION.");
		add(10388 , 16 , "You must be in the master database to grant a role with an activation predicate");
		add(10389 , 14 , "Permission denied. You must be the object owner to replace the definition of '%.*s'.");
		add(10390 , 16 , "User '%.*s' is not authorized to use command '%s'.");
		add(10391 , 14 , "To execute this command/procedure, you must have the same user identity as the target process or must have one of the following role(s) or permission(s): '%.*s'. Please contact a user with the appropriate role for help.");
		add(10393 , 14 , "Owner of object '%S_OBJID' is denied to execute the command.");
		add(10401 , 10 , "additional network memory allocates additional memory for clients which request packet sizes that are larger than the default packet size for the server.");
		add(10402 , 10 , "lock address spinlock ratio specifies the number of address lock buckets in the address locks hash table which are protected by each spinlock (buckets per spinlock).");
		add(10403 , 10 , "allow nested triggers is a toggle that controls the use of nested triggers. When the value is set to 1, data modifications made by triggers can fire other triggers.");
		add(10404 , 10 , "allow remote access determines whether users from remote servers can access this ASE. The default is 1, to allow ASE to communicate with Backup Server.");
		add(10405 , 10 , "allow async i/o is a toggle that enables ASE to run with asynchronous disk I/O.");
		add(10406 , 10 , "allow updates to system tables allows system tables to be updated directly. The default is 0 (off).");
		add(10407 , 10 , "audit queue size determines the number of audit records that the audit queue can hold. The default is 100.");
		add(10408 , 10 , "configuration file specifies the location of the configuration file you want to use.");
		add(10409 , 10 , "cpu accounting flush interval specifies how many machine clock ticks to accumulate before adding cpu usage data to syslogins for use in chargeback accounting statistics.");
		add(10410 , 10 , "cpu grace time specifies the maximum amount of time (in milliseconds) a user process can run without yielding the CPU before ASE infects it.");
		add(10411 , 10 , "deadlock checking period specifies the minimum amount of time (in milliseconds) a process must wait for a lock before ASE initiates a deadlock check.");
		add(10412 , 10 , "deadlock retries specifies the number of times a transaction will retry to acquire a lock after it has become a deadlock victim.");
		add(10413 , 10 , "default character set id is the number of the default character set used by the server.");
		add(10414 , 10 , "default database size sets the default number of megabytes allocated to each new user database. The default run value is 2 (megabytes)");
		add(10415 , 10 , "default fill factor percent sets how full ASE makes each page when creating a new index on existing data (unless user gives other value in create index statement).");
		add(10416 , 10 , "default language id is the number of the language that is used to display system messages unless a user has chosen another language from those available on the server.");
		add(10417 , 10 , "default network packet size sets the default size of network packets for all users on ASE.");
		add(10418 , 10 , "default sortorder id is the number of the current default sortorder on ASE. Do not change this parameter. See the System Administration Guide for more information.");
		add(10419 , 10 , "disk i/o structures specifies the initial number of disk I/O control blocks ASE allocates on startup.");
		add(10420 , 10 , "event buffers per engine specifies the number of events per ASE engine that can be simultaneously monitored. Events are used for observing ASE performance.");
		add(10421 , 10 , "executable code size reports the size of the ASE executable.");
		add(10423 , 10 , "housekeeper free write percent sets the maximum percentage that database writes can increase because of free writes started by the housekeeper process.");
		add(10424 , 10 , "i/o accounting flush interval specifies how many disk I/Os to accumulate before flushing the data to syslogins for use in chargeback accounting.");
		add(10425 , 10 , "i/o polling process count specifies the number of tasks the scheduler will run before checking for disk and/or network I/O completions.");
		add(10426 , 10 , "identity burning set factor sets the percentage of potential IDENTITY column values made available in each block.");
		add(10427 , 10 , "identity grab size allows each ASE process to reserve a block of IDENTITY column values for inserts into tables that have an IDENTITY column.");
		add(10428 , 10 , "page lock promotion HWM sets the maximum number of page locks allowed before ASE escalates to a table lock. The default value is 200.");
		add(10429 , 10 , "page lock promotion LWM sets the minimum number of page locks allowed before ASE escalates to a table lock. The default value is 200.");
		add(10430 , 10 , "page lock promotion PCT sets the percentage of page locks allowed before ASE escalates to a table lock. The default value is 100.");
		add(10431 , 10 , "lock shared memory disallows swapping of ASE pages to disk, and allowing the operating system kernel to avoid the server's internal page locking code.");
		add(10432 , 10 , "max async i/o's per engine specifies the maximum number of asynchronous disk I/O requests that can be outstanding for a single engine at one time.");
		add(10433 , 10 , "max async i/o's per server specifies the maximum number of asynchronous disk I/O requests that can be outstanding for ASE at one time.");
		add(10435 , 10 , "max network packet size sets the maximum network packet size that a client program can request.");
		add(10436 , 10 , "max number of network listeners specifies the maximum number of network listeners that can be open at one time.");
		add(10437 , 10 , "max online engines controls the number of engines in a symmetric multiprocessor environment.");
		add(10438 , 10 , "memory alignment boundary determines on which boundary buffer caches are aligned.");
		add(10440 , 10 , "number of alarms specifies the number of alarms allocated by ASE. Alarms are used with the Transact-SQL waitfor command.");
		add(10441 , 10 , "number of devices controls the number of database devices ASE can use. It does not include devices used for database dumps.");
		add(10442 , 10 , "number of extent i/o buffers allocates the specified number of extents (8 data pages) for use by create index. Do not set this value to more than 100.");
		add(10443 , 10 , "number of index trips specifies the number of times an aged index page recycles itself onto the MRU chain.");
		add(10445 , 10 , "number of locks sets the number of available locks. The default run value is 10000.");
		add(10446 , 10 , "number of mailboxes sets the number of mailbox structures ASE allocates on start-up. Mailboxes are use for process-to-process communication and synchronization.");
		add(10447 , 10 , "number of messages specifies the number of message structures allocated by ASE at start-up time. Messages are used in conjunction with mailboxes for process-to-process communication and synchronization.");
		add(10448 , 10 , "number of oam trips specifies the number of times an aged OAM page recycles itself onto the MRU chain.");
		add(10449 , 10 , "number of open databases sets the maximum number of databases that can be open at one time on ASE. The default run value is 12.");
		add(10450 , 10 , "number of open objects sets the maximum number of database objects that can be open at one time on ASE. The default run value is 500.");
		add(10451 , 10 , "number of preallocated extents specifies the number of extent structures allocated in a single trip to the page manager.");
		add(10452 , 10 , "number of remote connections controls the limit on active connections initiated to and from this ASE. The default is 20.");
		add(10453 , 10 , "number of remote logins controls the number of active user connections from this ASE to remote servers. The default is 20.");
		add(10454 , 10 , "number of remote sites controls the number of simultaneous remote sites that can access this ASE. The default is 10.");
		add(10455 , 10 , "number of sort buffers specifies the number of buffers used to hold pages read from input tables.");
		add(10456 , 10 , "number of user connections sets the maximum number of user connections that can be connected to ASE at one time.");
		add(10457 , 10 , "page lock spinlock ratio specifies the ratio of spinlocks protecting the internal page locks hash table.");
		add(10458 , 10 , "page utilization percent controls when ASE performs an OAM (Object Allocation Map) scan to find unused pages. The default run value is 95.");
		add(10459 , 10 , "partition groups sets how many partition groups to allocate for the server. Partition groups are used by ASE to control access to individual partitions of tables.");
		add(10460 , 10 , "partition spinlock ratio sets the number of partition caches each spinlock protects. These spinlocks keep processes from using partition caches used by other processes.");
		add(10461 , 10 , "permission cache entries determines the number of cache protectors per task.");
		add(10462 , 10 , "print deadlock information enables printing of deadlock information to the error log.");
		add(10463 , 10 , "print recovery information determines what information ASE displays on the console during recovery.");
		add(10464 , 10 , "procedure cache percent specifies the amount of memory allocated to the procedure cache after ASE's memory needs are met. The default run value is 20.");
		add(10465 , 10 , "recovery interval in minutes sets the maximum time per database that ASE uses to complete its recovery procedures in case of a system failure.");
		add(10466 , 10 , "remote server pre-read packets controls the number of packets that a site handler will pre-read in connections with remote servers. The default is 3.");
		add(10467 , 10 , "runnable process search count specifies the number of times an engine will loop looking for a runnable task before relinquishing the CPU.");
		add(10468 , 10 , "sort page count specifies the maximum amount of memory a sort operation can use.");
		add(10469 , 10 , "clock tick length specifies the duration of the server's clock tick, in microseconds.");
		add(10470 , 10 , "stack guard size specifies the size of the stack guard area.");
		add(10471 , 10 , "stack size sets the size of ASE's execution stack.");
		add(10472 , 0  , "This option specifies the number of days that passwords remain in effect after they are changed. The default is 0 (passwords do not expire).");
		add(10473 , 10 , "lock table spinlock ratio specifies the number of table lock buckets in the table lock hash table which are protected by each spinlock (buckets per spinlock).");
		add(10474 , 10 , "tape retention in days sets the number of days you want to retain each tape after it has been used for a database or transaction log dump.");
		add(10475 , 10 , "tcp no delay disables TCP packet batching.");
		add(10476 , 10 , "time slice sets the number of milliseconds that ASE's scheduler allows a user process to run. The default run value is 100 milliseconds.");
		add(10477 , 10 , "total data cache size represents the amount of memory currently available for use as a data cache. It is a calculated value that is not directly user-configurable.");
		add(10478 , 10 , "The run value of 'total logical memory' indicates the size of memory required to satisfy the current configuration.");
		add(10479 , 10 , "upgrade version is changed by the upgrade program provided with new releases.");
		add(10480 , 10 , "user log cache size specifies the size (in bytes) for each user's log cache.");
		add(10481 , 10 , "user log cache spinlock ratio specifies the number of user log caches per user log cache spinlock.");
		add(10482 , 10 , "shared memory starting address determines the virtual address at which ASE starts its shared memory region. Most users do not need to modify this.");
		add(10483 , 10 , "size of auto identity column sets the precision of IDENTITY columns automatically created with the sp_dboption 'auto identity' option.");
		add(10485 , 10 , "os file descriptors is a read-only parameter that indicates how many file descriptors have been allocated to ASE. It is not user-configurable.");
		add(10486 , 10 , "Allow-limits allows the Resource Governor feature to be used by SAs. Default is 0 (off); static.");
		add(10487 , 10 , "number of auxiliary scan descriptors sets the maximum number of auxiliary scan descriptors that can be shared among all connections at one time. The default run value is 200.");
		add(10488 , 10 , "number of open indexes sets the maximum number of indexes that can be open at one time on ASE. The default value is 500.");
		add(10489 , 10 , "open object spinlock ratio specifies the number of open objects protected by one spinlock. The default value is 100.");
		add(10490 , 10 , "open index hash spinlock ratio specifies the number of internal hash tables for open indexes protected by one spinlock. The default value is 100.");
		add(10491 , 10 , "open index spinlock ratio specifies the number of open indexes protected by one spinlock. The default value is 100.");
		add(10492 , 10 , "enable cis specifies whether Component Integration Services is loaded when the server is started. The default is 1.");
		add(10493 , 10 , "cis connect timeout specifies the number of seconds to wait for a connect request to a remote server to complete.");
		add(10494 , 10 , "cis bulk insert batch size specifies the number of rows in a bulk copy batch when performing a SELECT INTO operation.");
		add(10495 , 10 , "max cis remote connections specifies the maximum number of connections to remote servers that can be active at one time.");
		add(10497 , 10 , "cis packet size specifies the maximum size of a network packet.");
		add(10498 , 10 , "cis cursor rows specifies the maximum number of rows that will be returned in response to a single fetch operation.");
		add(10499 , 10 , "CIS idle timeout specifies the number of seconds to wait before terminating an idle connection with a remote server.");
		add(10501 , 16 , "Database '%.*s' not found; check sysdatabases.");
		add(10502 , 16 , "Internal error occurred. Unexpected value supplied. Please call SAP Technical Support.");
		add(10503 , 0  , "The temporary database (dbid = %d) is not available.");
		add(10504 , 0  , "Maximum limit of %d active members of a temporary database group is reached.");
		add(10505 , 0  , "Attempt to remove a temporary database (dbid %d) from a group, but did not find it in that group.");
		add(10506 , 0  , "Cannot assign a temporary database based on the existing soft binding; the temporary database based on the default assignment will be used.");
		add(10507 , 0  , "Failed to read sysattributes or encountered unexpected value.");
		add(10508 , 0  , "Attempt to add a temporary database (dbid = %d) to available list of temporary databases. The database is already in that list.");
		add(10509 , 0  , "Failed to read sysattributes.");
		add(10510 , 0  , "Failed to get name of database (dbid = %d). Cannot add it to any groups it may be bound to.");
		add(10511 , 0  , "Database (dbid = %d) is not a temporary database.");
		add(10512 , 0  , "Database (dbid = %d) not found; check sysdatabases.");
		add(10513 , 0  , "Temporary database based on specified binding could not be assigned. Since binding is hard, this results in a login failure.");
		add(10520 , 16 , "Cannot retrieve the total column count for table '%.*s' in database '%.*s'.");
		add(10601 , 10 , "lock hashtable size specifies the number of buckets in the lock hash table.");
		add(10602 , 10 , "the lock spinlock ratio specifies the number of page and row lock buckets in the lock hash table which are protected by each spinlock (buckets per spinlock).");
		add(10603 , 10 , "row lock promotion HWM sets the maximum number of row locks allowed before ASE escalates to a table lock. The default value is 200.");
		add(10604 , 10 , "row lock promotion LWM sets the minimum number of row locks allowed before ASE escalates to a table lock. The default value is 200.");
		add(10605 , 10 , "row lock promotion PCT sets the percentage of row locks allowed before ASE escalates to a table lock. The default value is 100.");
		add(10606 , 10 , "dump on conditions indicates whether ASE will create a shared memory dump file if any conditions configured using the sp_dumpconfig stored procedure occurs. Possible values are 0 (not enabled) or 1 (enabled).");
		add(10607 , 10 , "enable ASE performance monitoring with Windows NT Perfmon.");
		add(10608 , 10 , "enable unloading of a DLL after each execution of extended stored procedure.");
		add(10609 , 10 , "specify the extended stored procedure execution priority on the XP Server. The values range from 0 to 15. The default value is 8.");
		add(10610 , 10 , "specify the extended stored procedure stack size on the XP Server. The values range and the default value is platform dependent.");
		add(10611 , 10 , "restrict the client execution privileges of the OS command specified with xp_cmdshell. Consult documentation for further details.");
		add(10612 , 10 , "enable start of Sybmail session with Windows NT mail subsystem with ASE startup.");
		add(10613 , 10 , "enable ASE Error logging with Windows NT Event Viewer.");
		add(10614 , 10 , "enable ASE audit (logon success) logging with Windows NT Event Viewer.");
		add(10615 , 10 , "enable ASE audit (logon failure) logging with Windows NT Event Viewer.");
		add(10616 , 10 , "specify the computer name for centralized error logging with Windows NT Event Viewer.");
		add(10617 , 16 , "cis rpc handling specifies whether Component Integration Services or a site handler is used to send RPCs. The default is 1.");
		add(10619 , 10 , "number of large i/o buffers controls the number of extent size i/o disk buffers which are allocated at server startup. These buffers are used by 'disk mirroring', 'load database' and some dbcc commands.");
		add(10620 , 10 , "number of worker processes is the maximum number of worker processes that can be in use Server-wide at any one time.");
		add(10621 , 10 , "memory per worker process is the additional amount of memory that will be allocated to each worker process.");
		add(10622 , 10 , "max parallel degree is the maximum number of worker processes that can be used by a given query at any one time.");
		add(10623 , 10 , "max scan parallel degree is the maximum number of worker processes that can be used for a parallel scan against a non-partitioned object.");
		add(10624 , 10 , "When set to 1, the Server will allow ONLY those user connections which have already been authenticated by the underlying security mechanism. Default is 0.");
		add(10625 , 10 , "When set to 0, the Server will not initialize the Security Control Layer (support for security services is disabled). Default is 0.");
		add(10626 , 10 , "When this parameter is set to 1, ASE will not allow any user connections which are not using message confidentiality. Default value is 0.");
		add(10627 , 10 , "When this parameter is set to 1, ASE will not allow any user connections which are not using message integrity. Default value is 0.");
		add(10628 , 10 , "When set to 1, the Server will not allow any user connections which are not using message replay detection checks. Default value is 0. When set to 0, the Server will allow connections which use message replay as well as those which don't.");
		add(10629 , 10 , "When set to 1, the Server will not allow any user connections which are not using message origin checks. Default value is 0. When set to 0, the Server will allow connections which use message origin checks as well as those connections which don't.");
		add(10630 , 10 , "When set to 1, the Server will not allow any user connections which are not using message out of sequence detection checks. Default value is 0.");
		add(10631 , 10 , "Each character from this string that appears in the principal name is mapped into the DOLLAR sign. This is required to take care of those characters that may be valid in an underlying security mechanism but not valid in the name space.");
		add(10632 , 10 , "This login will be used by ASE to let a user enter ASE as a secure default login if the user has already been authenticated by the underlying security mechanism but does not have an entry in the syslogins table.");
		add(10633 , 10 , "Each character from this string that appears in the principal name is mapped into the POUND sign. This is required to take care of those characters that may be valid in an underlying security mechanism but not valid in the ASE name space.");
		add(10634 , 10 , "Each character from this string that appears in the principal name is mapped into the UNDERSCORE sign. This is required to take care of those characters that may be valid in an underlying security mechanism but not valid in the ASE name space.");
		add(10635 , 10 , "determines whether users can modify their curread when a cursor is open. The default is 1 (allow users to modify their curread when a cursor is open).");
		add(10636 , 10 , "enables/disables the grouping of stored procedures. The default is 1 (procedure grouping allowed).");
		add(10637 , 10 , "enables/disables granting select to public to the text column of the syscomments table. The default is 1 (grant select on syscomments.text to public).");
		add(10638 , 10 , "enables/disables the ability to send messages to internet addresses. The default is 0 (sendmsg not allowed).");
		add(10639 , 10 , "enables/disables auditing for the whole server. The default is 0 (auditing disabled).");
		add(10640 , 10 , "establishes where ASE writes audit records. Values can be 1 to 8, representing sysaudits_01 through sysaudits _08; 0 means to set the current audit table to the next in sequence. The default is 1.");
		add(10641 , 10 , "controls what happens when the audit table becomes full. Values are (1) suspend the audit process and all auditable user processes (default), and (0) truncate the next audit table and start using it as the current table.");
		add(10642 , 10 , "indicates the default port number for sending internet messages.");
		add(10643 , 10 , "enables/disables character conversion before sending to or receiving from the client. The default is 0 (ASE will convert characters before sending to or received from the client).");
		add(10645 , 16 , "Maximum dump conditions indicates the maximum number of shared memory dump conditions that can be configured on this server. The value of this field may be from 10 to 100. The default value is 10.");
		add(10646 , 16 , "This configuration option enables/disables the bidirectional index scans");
		add(10647 , 10 , "enables/disables asynchronous prefetch server-wide. Sets the percentage of each buffer pool in which prefetched but unused pages can be stored. If needed, this value can be overridden for a pool with local async prefetch limit");
		add(10648 , 10 , "disable disk mirroring is a toggle that allows the user to utilize ASE disk mirroring.");
		add(10649 , 10 , "A transaction descriptor is used for each transaction started in a database by a user connection. The number of transaction descriptors per process times the number of user connections is the total number of transaction descriptors available.");
		add(10650 , 10 , "enables unicode-based character set conversions. When set to 1, enables conversions for character sets not already in syscharsets. When set to 2, enables Unicode-based conversions for all connections. The default is 0 (off).");
		add(10651 , 10 , "size of unilib cache sets the size of memory (in bytes) to be set aside for additional Unicode-based conversions and collations.");
		add(10652 , 16 , "Configures cache partition server-wide. The global cache partition number must be power of 2, between 1 to 64 and the partitioned buffer pool size must be at least 256P.");
		add(10653 , 10 , "The value of 'number of ccbs' is the number of Configurable Action Point Control Blocks available to aid debugging.");
		add(10654 , 10 , "The value of 'caps per ccb' is the maximum number of Configurable Action Points that can be configured at any one time within one Configurable Action Point Control Block.");
		add(10655 , 10 , "The value of 'average cap size' is a guess at how many bytes of memory will be required to store the information associated with a typical Configurable Action Point.");
		add(10656 , 16 , "enable java specifies whether Java Services are loaded when the server is started. The default is 0 (not loaded).");
		add(10657 , 16 , "Size of object heap is the per-process memory used for allocating Java objects.");
		add(10658 , 16 , "Size of class heap is the memory used for Java classes and other such structures that are shared between all processes.");
		add(10659 , 10 , "The 'license information' configuration parameter sets the number of user logins for which Adaptive Server is licensed. When this count is exceeded, an informational message is printed to the error log. Contact SAP to purchase additional licenses.");
		add(10660 , 10 , "This configuration option 'enable xact coordination' enables/disables Adaptive Server distributed transaction coordination services.");
		add(10661 , 10 , "The configuration option 'xact coordination interval' changes the distributed transaction recovery interval.");
		add(10662 , 10 , "The configuration option 'number of dtx participants' sets the maximum number of local and remote distributed transaction participants that can be active at any instance of time.");
		add(10663 , 10 , "The configuration option 'strict dtm enforcement' when enabled enforces that only participants that can be managed through Adaptive Server distributed transaction management protocol(s) can participate in a distributed transaction.");
		add(10664 , 10 , "The configuration option 'dtm lock timeout period' sets the maximum time, in seconds, a distributed transaction participant waits on a lock request after which the lock request is timed out.");
		add(10665 , 10 , "Allow the query optimizer to consider sort-merge join and Join Transitive Closure(JTC). The default is 0. By default, the optimizer does not evaluate sort-merge join and join transitive closure, when generating query execution plans.");
		add(10666 , 16 , "Size of global fixed heap is the size of memory used by the Java subsystem for internal data structures and other needs that are shared by all processes.");
		add(10667 , 10 , "enable monitoring specifies whether the Adaptive Server will collect information for the Monitoring and Diagnostic System.");
		add(10668 , 10 , "autostart collector indicates whether the Adaptive Server will start the Q Diagnsotics Engine collector process on server startup.");
		add(10669 , 10 , "collector repository server specifies the name of the Q Diagnostics Engine repository server.");
		add(10670 , 10 , "collector application host specifies the name of the Q Diagnostics Engine Application Server host system.");
		add(10671 , 10 , "collector errorlog file specifies the directory in which the Q Diagnostics Engine Collector process should place its errorlog file.");
		add(10672 , 10 , "collector failover file specifies the directory in which the Q Diagnostics Engine Collector process should place it's failover file");
		add(10673 , 10 , "collection interval specifies the amount of time the Q Diagnostics Engine Collector process waits between each data collection cycle.");
		add(10674 , 10 , "sql text pipe active indicates whether the Adaptive Server will collect historical sql batch text information.");
		add(10675 , 10 , "sql text pipe max messages specifies the maximum number of messages that can be stored for historical sql text.");
		add(10676 , 10 , "plan text pipe active indicates whether the Adaptive Server will collect historical plan text monitoring information.");
		add(10677 , 10 , "plan text pipe max messages specifies the maximum number of messages that can be stored for historical plan text.");
		add(10678 , 16 , "statement pipe active indicates whether the Adaptive Server will collect historical statement level monitoring information.");
		add(10679 , 10 , "statement pipe max messages specifies the maximum number of messages that can be stored for historical statement text.");
		add(10680 , 10 , "errorlog pipe active indicates whether the Adaptive Server will collect historical errorlog monitoring information.");
		add(10681 , 10 , "errorlog pipe max messages specifies the maximum number of messages that can be stored for historical errorlog text.");
		add(10682 , 10 , "deadlock pipe active indicates whether the Adaptive Server will collect historical deadlock monitoring information.");
		add(10683 , 10 , "deadlock pipe max messages specifies the maximum number of messages that can be stored for historical deadlock data.");
		add(10684 , 10 , "wait event timing specifies whether the Adaptive Server will collect monitoring data for all wait events.");
		add(10685 , 10 , "process event timing specifies whether the Adaptive Server will collect monitoring data on wait events for individual processes.");
		add(10686 , 10 , "object lockwait timing specifies whether the Adaptive Server will collect timing data on lock requests.");
		add(10687 , 10 , "SQL batch capture indicates whether the Adaptive Server will collect sql batch text for each process.");
		add(10688 , 16 , "statement statistics active indicates whether ASE will collect ad-hoc statement monitoring information");
		add(10689 , 16 , "'text prefetch size' specifies the number of text pages to prefetch into the text read pipeline.");
		add(10690 , 10 , "The 'default exp_row_size percent' parameter reserves a specified percentage of page size for expanding updates in data-only-locked tables. The default value is 5.");
		add(10691 , 10 , "'enable housekeeper GC' is a toggle that enables the housekeeper task to perform space reclamation on data-only-locked tables. The default value is 1 (enabled).");
		add(10692 , 10 , "'enable rep agent threads' is a toggle that enables RepAgent threads within Adaptive Server. The default value is 0 (disabled).");
		add(10693 , 10 , "'lock scheme' sets the default locking scheme to be used by the create table and select into commands when a lock scheme is not specified in the command. The default value is allpages.");
		add(10694 , 10 , "'lock wait period' limits the number of seconds that tasks wait to acquire a lock on a table, data page or data row. The default value is 2,147,483,647. At the default value, all tasks wait indefinitely for locks.");
		add(10695 , 10 , "'max SQL text monitored' specifies the amount of memory allocated per user connection for saving SQL text to memory shared by Adaptive Server. The default value is 0.");
		add(10696 , 10 , "'read committed with lock' determines whether an Adaptive Server using transaction isolation level 1 (read committed) holds shared locks on rows or pages of data-only-locked tables during select queries. The default value is 0 (off).");
		add(10697 , 0  , "This option specifies the number of consecutive failed login attempts permitted before the targeted login is locked. 'maximum failed logins' for the user is set to zero after every successful login.");
		add(10698 , 0  , "This option specifies the minimum number of characters a password must have to be accepted for any new logins. Logins that were set up using the previously set minimum password length can continue having fewer characters for their passwords.");
		add(10699 , 10 , "Setting configuration parameter 'check password for digit' to 1 checks newly set passwords for the presence of at least one digit. This parameter is off(set to 0) by default.");
		add(10700 , 16 , "%s");
		add(10701 , 16 , "getMoreResults() is not allowed after executeQuery() or executeUpdate().");
		add(10707 , 16 , "Unhandled Java Exception: %s.");
		add(10708 , 16 , "Class %.*s not found. Check and make sure that the class has been installed, and an entry exists in Sysxtypes.");
		add(10709 , 16 , "Illegal reference to field '%.*s'. Field accesses can only be performed on object-valued expressions.");
		add(10710 , 16 , "No public non-static variable '%.*s' found in class '%.*s'.");
		add(10711 , 16 , "Cannot find a public method named '%.*s' in class '%.*s'. Either the method does not exist, or it is being called with the incorrect argument types.");
		add(10712 , 16 , "When using JDBC to execute a stored procedure, the results must be completely processed before any other stored procedure can be executed. You attempted to execute two procedures simultaneously.");
		add(10713 , 16 , "A JDBC query batch without any SQL statements was found. JDBC batches must contain at least one SQL statement.");
		add(10714 , 16 , "Illegal use of parameters in: %s. JDBC does not allow parameters in methods of 'statement' objects.");
		add(10715 , 16 , "Parameter number %d is invalid for the current JDBC statement batch.");
		add(10716 , 16 , "A SQL statement which produces a result set was submitted through a JDBC executeUpdate() method. Use the JDBC execute() or executeQuery() methods.");
		add(10717 , 16 , "A single batch with SQL statements which produce multiple result sets was submitted using the JDBC executeQuery() method. Use seperate batches or use the execute() method.");
		add(10718 , 16 , "A JDBC statement attempted to update a table which is already in use outside of the context of the JAVA method which submitted the statement.");
		add(10719 , 16 , "The %s command is not allowed in JDBC.");
		add(10720 , 16 , "A JDBC statement caused a trigger to fire which generates a result set. Result sets in triggers are not allowed.");
		add(10721 , 16 , "Class %.*s does not exist.");
		add(10722 , 16 , "Package %.*s not found.");
		add(10723 , 16 , "Class %.*s belongs to a jar. It cannot be independently removed or replaced.");
		add(10724 , 16 , "Jar %.*s does not exist.");
		add(10725 , 16 , "Class %.*s is in use. It cannot be removed.");
		add(10726 , 16 , "Cannot open file %.*s. If you've specified a relative pathname, re-try the command using an absolute pathname.");
		add(10727 , 16 , "Invalid text pointer specified.");
		add(10728 , 16 , "The specified file or image column contains a Java class. Java classes cannot be directly installed. Enclose this class in a jar and re-try your command.");
		add(10729 , 16 , "The specified file or image column does not contain a valid jar. Install failed.");
		add(10730 , 16 , "You're attempting to install a jar that contains compressed classes. Re-create this jar without using compression, and try the command again.");
		add(10731 , 16 , "The specified jar contains a class whose name exceeds the server limits in length. Such classes cannot be installed.");
		add(10732 , 16 , "You're attempting to install a class named %.*s. This class belongs to a package reserved for system classes and cannot be installed.");
		add(10733 , 16 , "Class %.*s cannot be replaced because it belongs to a different jar. Install failed.");
		add(10734 , 16 , "Cannot run this command because Java services are not enabled. A user with System Administrator (SA) role must reconfigure the system to enable Java.");
		add(10736 , 16 , "Cannot convert datatype '%s' to datatype '%s'. Either such conversion is not supported or the datatype(s) is invalid.");
		add(10737 , 18 , "An internal conversion error was found while converting datatype '%s' to datatype '%s'.");
		add(10738 , 16 , "An overflow error was found while converting datatype '%s' to datatype '%s'.");
		add(10739 , 16 , "An underflow error was found while converting datatype '%s' type to datatype '%s'.");
		add(10740 , 16 , "Table %.*s does not exist.");
		add(10741 , 16 , "Arithmetic operations on extended type values are currently unsupported.");
		add(10742 , 16 , "You cannot do an update (INSERT, DELETE or UPDATE) from a JAVA method which is invoked in a query already doing an update.");
		add(10743 , 16 , "The %s command is only allowed in JDBC if it does not change the current value.");
		add(10744 , 16 , "You cannot use Java-SQL class datatypes in an ORDER BY clause.");
		add(10745 , 16 , "Conversion error detected while converting SQL data to Java data. Either the conversion is not supported or the datatype(s) is invalid.");
		add(10746 , 16 , "No public field '%.*s' exists in the specified class '%.*s'.");
		add(10747 , 16 , "You tried to assign a value to a field in a NULL-valued object.");
		add(10748 , 16 , "You cannot create index on a column, '%.*s', that has a Java-SQL class datatype.");
		add(10749 , 16 , "Conversion error detected while converting Java data to SQL data. Either the conversion is not supported or the datatype(s) is invalid.");
		add(10750 , 16 , "You cannot use a Java-SQL class datatype in which the size of class is more than the server limits in this aggregate expression.");
		add(10751 , 16 , "You cannot use a Java-SQL class datatype in this subquery or aggregate expression.");
		add(10752 , 16 , "Instance methods can only be executed on object-valued expressions.");
		add(10753 , 16 , "Cannot find class '%.*s' in the database that matches the return datatype of the specified method.");
		add(10754 , 16 , "Java datatype returned by a method cannot be mapped to SQL datatype.");
		add(10755 , 16 , "You cannot pass a SQL NULL value as an argument to a Java method.");
		add(10756 , 16 , "You cannot pass data that has a TEXT, IMAGE or UNITEXT datatype as an argument to a Java method.");
		add(10757 , 16 , "Java datatype returned by a field cannot be mapped to SQL datatype.");
		add(10758 , 16 , "The length of serialized object exceeds the maximum of %d bytes.");
		add(10759 , 16 , "Unable to load the class '%.*s' at execution time. The schema may have changed since the command was compiled.");
		add(10760 , 16 , "Unable to load the method '%.*s' at execution time. The schema may have changed since the command was compiled.");
		add(10761 , 16 , "You specified invalid datatypes in object comparison.");
		add(10762 , 16 , "Cannot initialize the Java Virtual Machine because either the Java class library or PCA plugin library is missing, corrupted, or incompatible with the current server release. Contact your System Administrator for help.");
		add(10763 , 16 , "Execution of remote procedure calls is not supported in JDBC.");
		add(10764 , 16 , "Cannot execute this operation due to insufficient memory in the Java heap(s). Increase the value of the configuration parameters 'size of process object heap' and/or 'size of shared class heap'.");
		add(10765 , 16 , "Cannot insert an object of class '%.*s' into a column because the object is not serializable. An object is serializable if its class implements the 'java.io.Serializable' or 'java.io.Externalizable' interface.");
		add(10766 , 16 , "%s is not the acceptable URL for ASE JDBC driver.");
		add(10767 , 16 , "The wasNull() method failed, because there is no output parameter registered or no parameter has been got from the engine.");
		add(10768 , 16 , "%s is not a valid value for a parameter index. Valid values are 1 to %s.");
		add(10769 , 16 , "Cannot get the value for parameter '%s' because it is not an out parameter.");
		add(10770 , 16 , "The connection has been closed or does not exist.");
		add(10771 , 16 , "%s is not a valid Column index value. Valid values are 1 to %s.");
		add(10772 , 16 , "Cannot get data value or metadata from the result set because the result set has been closed or does not exist.");
		add(10773 , 16 , "Cannot find column name '%s' in this result set.");
		add(10774 , 16 , "SQL statement execution error occurred, use catch statement to get the detailed information.");
		add(10775 , 16 , "You cannot use the statement handle because it has been closed or does not exist.");
		add(10776 , 16 , "Parameter '%s' is registered as output parameter with '%s' type which is not compatible with it's in type '%s'.");
		add(10777 , 16 , "getColumnCount() failed because there is no valid column count for this query.");
		add(10778 , 16 , "getResultSetMetaData() failed because the query does not generate result set or the result set does not exist.");
		add(10779 , 16 , "Cannot set java object at parameter '%s' because either no conversion is available to map the object to any ASE SQL datatype or the java object is invalid.");
		add(10780 , 16 , "Either '%s' is not a valid JDBC datatype or no conversion is available to map the JDBC/Java datatype to an Adaptive Server datatype.");
		add(10781 , 16 , "Cannot convert object to '%s' because either the conversion was attempted between an illegal pair of object types or a format error was encountered in the conversion.");
		add(10782 , 16 , "Method '%s' is not supported in the ASE JDBC driver.");
		add(10783 , 16 , "%s is not a valid value for a parameter index because there is no parameter declared.");
		add(10784 , 16 , "Cannot convert object to any valid numeric data type because either the conversion was attempted between an illegal pair of object types or a format error was encountered in the conversion.");
		add(10785 , 17 , "A Java operation or conversion failed, most likely due to insufficient memory. Please consult the errorlog for more information.");
		add(10786 , 17 , "Insufficient system resources to execute this operation. Too many databases have been opened in order to load classes. Please wait for a few processes to terminate before retrying this command.");
		add(10787 , 16 , "Cannot update or remove Java classes while the current process is still holding references to objects.");
		add(10788 , 16 , "Operation failed because the object being deserialized belongs to class '%s' which is incompatible with its declared class '%s'.");
		add(10789 , 16 , "There is already a class named '%.*s' in the database.");
		add(10790 , 16 , "There is already a jar named '%.*s' in the database.");
		add(10791 , 16 , "Process cannot update or remove class loader because Java Debugger is attached to the process.");
		add(10792 , 16 , "Cannot invoke method '%.*s' on class '%.*s'. Instance methods can only be invoked on objects.");
		add(10793 , 16 , "There is no class in a jar. Make sure that jar contains at least one class. Install failed.");
		add(10794 , 16 , "Cannot pass NULL as the value for parameter number %d to the method '%s' in class '%s'. The parameter is of a Java primitive datatype, and is non-nullable.");
		add(10795 , 16 , "The file '%.*s' contained in the jar does not represent a valid Java class file.");
		add(10796 , 10 , "Warning! Expecting file '%s' to contain Java class '%s'. Instead, class '%s' was found. Installing the class under the correct name '%s'.");
		add(10797 , 16 , "Cannot execute the prepared statement because the '%s' parameter has not been set.");
		add(10798 , 16 , "Cannot get the column value because the result set has not been opened yet. Use the 'next()' function to open the result set before getting the column value.");
		add(10799 , 16 , "Cannot get the column value because there are no more row in the result set.");
		add(10801 , 16 , "Invalid type configured for cache %s. Cache type can be one of default OR mixed OR log along with HK ignore but NOT just HK ignore alone.");
		add(10802 , 16 , "Configuration Error: Configuration Parameter '%s' cannot be changed to 1 when parameter 'evaluated configuration' is set to 1.");
		add(10803 , 16 , "Configuration Error: Cannot set configuration parameter 'evaluated configuration' to 1. Other Security related configuration parameters need to be set properly before this parameter can be changed to 1. Please contact a user with SSO role for help.");
		add(10807 , 16 , "The value of 'max parallel degree' (`%d') cannot be less than the value of 'max scan parallel degree' (`%d').");
		add(10808 , 10 , "Use sp_configure to lower the value of 'max scan parallel degree' or raise the value of 'max parallel degree'.");
		add(10809 , 16 , "The value of 'number of worker processes' (`%d') cannot be less than the value of '%s' (`%d').");
		add(10810 , 16 , "Use sp_configure to lower the value of '%s' or raise the value of 'number of worker processes'.");
		add(10812 , 16 , "Unable to truncate the audit table '%.*s'. Configuration of current audit table failed.");
		add(10813 , 16 , "Audit table cannot be changed because the log device in the sybsecurity database is full.");
		add(10814 , 20 , "Auditing: Fatal error - could not get the name of the audit table with the object id '%d' to truncate it. This is an internal error.");
		add(10815 , 16 , "The lock hashtable size must be a power of 2. You have specified a size of %d, which is not a power of 2. The next highest power of 2, %d, will be used instead.");
		add(10816 , 16 , "The value of the 'dump on conditions' configuration parameter must be either 0 or 1.");
		add(10817 , 16 , "Configuration Error: Unknown cache replacement policy '%s' defined for cache '%s'.");
		add(10818 , 10 , "Warning: the value provided for 'parallel_degree' ('%d') was less than the value of 'scan_parallel_degree' ('%d'). The value of 'scan_parallel_degree' has been adjusted to '%d'.");
		add(10819 , 10 , "The value of 'scan_parallel_degree' ('%d') cannot be larger than the value of 'scan_parallel_degree' set by a calling procedure. The value '%d' is used.");
		add(10820 , 10 , "The configuration option '%s' has been changed by '%s' from '%s' to '%s'.");
		add(10821 , 16 , "The configuration option '%s' requires a character string.");
		add(10822 , 16 , "The string size of the configuration option '%s' must be less than '%d'.");
		add(10823 , 16 , "The specified memory, '%dK', is not big enough to configure the configuration parameter, '%s', to a valid value.");
		add(10824 , 16 , "Illegal value '%s' specified for configuration option '%s'. The legal values are between '%d' and '%d'.");
		add(10825 , 16 , "Configuration parameter '%s' will consume more than %d bytes of memory if configured at %d.");
		add(10826 , 16 , "The value of the 'max memory' parameter '%d' is not high enough to set the other parameter values for the current ASE configuration.");
		add(10827 , 10 , "Warning: the value of the configuration parameter 'max scan parallel degree' has been set to %d. For optimal performance, a value no larger than 4 is recommended.");
		add(10828 , 10 , "Consider increasing the value of configuration parameter 'max memory' or decreasing the value of configuration parameters causing significant memory consumption, such as 'number of user connections'.");
		add(10829 , 16 , "Adaptive Server cannot estimate the memory requirement. See the System Administration Guide for information about Adaptive Server memory requirement.");
		add(10830 , 16 , "Configuration parameter '%s' can be only 0 or 1.");
		add(10831 , 16 , "Configured 'number of cache partitions' ('%d') is illegal in cache '%s'. The value must be a power of '2' and between '%d' and '%d'.");
		add(10832 , 16 , "Each partitioned pool must be at least 256P. With the '%d' partitions we cannot configure this value for buffer pool (%dk) in cache (%s). Please configure a bigger pool or reduce the number of cache partitions.");
		add(10833 , 16 , "You must disable transaction coordinator and CIS RPC handling before you can disable CIS.");
		add(10834 , 16 , "Configuration parameter '%s' can not be enabled without license '%s'.");
		add(10836 , 16 , "Cannot 'enable ha' as HA services require transaction coordination. Please enable transaction coordination first.");
		add(10837 , 16 , "Cannot 'enable ha' as HA services require Omni services . Please enable Omni services first.");
		add(10838 , 16 , "Adaptive Server is currently cluster configured for active-active HA. The value of configuration parameter 'enable HA' cannot be changed until the active-active companion mode is dropped.");
		add(10840 , 16 , "Memory grow failed for pool %s. Error code %d. This is possibly due to memory fragmentation. This pool may grow on demand. Please increase 'max memory' and retry the configuration.");
		add(10841 , 16 , "The value of parameter 'max memory' '%d' cannot be less than the 'total logical memory' size '%d'. Please reconfigure 'max memory' to be greater than or equal to the total logical memory required.");
		add(10842 , 16 , "The value specified for configuration option '%s' '%d' may not be greater than the value '%d' specified for configuration option '%s'.");
		add(10843 , 16 , "The value specified for configuration option 'number of engines at startup' '%d' may not be greater than the number of available CPUs '%d'.");
		add(10844 , 16 , "Cannot enable 'use ssl client cert auth' configuration parameter.");
		add(10845 , 16 , "The maximum number of memory maps '%d' has been reached for '%s' pool. You will have to reboot the server to reconfigure '%s'. You may be able to reconfigure other configuration parameters.");
		add(10846 , 16 , "Overflow error: 'total logical memory' '%d' (2k pages) exceeds the maximum size of memory available on a '%d' bit platform: '%u' bytes. Please reduce the configuration values that are consuming large amounts of memory.");
		add(10847 , 16 , "The Adaptive Server Enterprise Small Business Edition does not allow you to set this configuration parameter to a value higher than %d.");
		add(10848 , 16 , "The Adaptive Server Enterprise Developer Edition does not allow you to set this configuration parameter to a value higher than %d.");
		add(10849 , 16 , "The Adaptive Server Enterprise Developer Edition does not allow you to enable this configuration parameter.");
		add(10850 , 16 , "Adding/Deleting cache partitions to an existing cache is not dynamic. To change the number of cache partitions in the same instance, delete and recreate the cache with the required configuration.");
		add(10851 , 16 , "Shrinking a cache is not dynamic. The cache will be rebuilt with the reduced memory when you reboot the server. To shrink this cache in the same instance, delete the cache and recreate the cache with the required memory.");
		add(10852 , 16 , "ASE is unable to get all the memory requested (%d). %d Kilobytes have been allocated dynamically.");
		add(10853 , 16 , "The change is completed. The option is dynamic and ASE need not be rebooted for the change to take effect.");
		add(10854 , 16 , "Cache ('%.*s') not deleted dynamically. Objects are bound to the cache. Use sp_unbindcache_all to unbind all objects bound to the cache.");
		add(10855 , 16 , "Unable to open database (dbname=%.*s). So online delete cache will fail.");
		add(10856 , 16 , "Unable to lock Sysattributes (dbname=%.*s). So online delete cache will fail.");
		add(10858 , 22 , "Cannot scan Sysattributes (dbname='%.*s').");
		add(10859 , 16 , "%d Kilobytes added successfully to named cache (%.*s). Change takes effect immediately.");
		add(10860 , 16 , "Changing 'cache replacement policy' is not dynamic. The 'cache replacement policy' will be changed when you reboot the server. To change 'cache replacement policy' in the same instance delete the cache and recreate the cache with the required policy.");
		add(10861 , 16 , "Changing 'cache type' successful. The option is dynamic and change takes effect immediately.");
		add(10863 , 16 , "Initialization of the cache (%.*s) failed due to lack of space. Changes will take effect when server is rebooted. To make changes in the same instance increase the value of 'max memory' config parameter and retry command.");
		add(10864 , 16 , "Unable to create cache (%.*s) online. There is insufficient heap memory to allocate %d bytes. To create a cache online, increase configuration parameter 'heap memory per user' or try the command when there is less activity on the system.");
		add(10865 , 16 , "Unable to add memory to the cache (%.*s) as it is too fragmented. Changes will take effect when the server is rebooted. To add memory in the same instance delete the cache and recreate the cache with the required memory.");
		add(10866 , 16 , "The value of 'max concurrently recovered dbs' ('%d') must be less than the value of '%s' ('%d').");
		add(10867 , 16 , "The value of 'max concurrently recovered dbs' ('%d') must be no more than %d.");
		add(10868 , 10 , "Use sp_configure to lower the value of 'max concurrently recovered dbs' or raise the value of '%s'.");
		add(10869 , 16 , "Cannot change the pool configurations in the '%.*s' when the server is in recovery.");
		add(10870 , 16 , "The value of 'number of checkpoint tasks' ('%d') must be less than or equal to the value of '%s' ('%d').");
		add(10871 , 16 , "The value of 'number of checkpoint tasks' ('%d') must be less than or equal to the value of 'number of open databases' ('%d').");
		add(10872 , 16 , "Use sp_configure to lower the value of 'number of checkpoint tasks' or raise the value of '%s'.");
		add(10873 , 16 , "The configuration option 'number of checkpoint tasks' cannot be changed until the previous configuration change has taken effect. Wait until the previous configuration change has taken effect and re-issue the command.");
		add(10875 , 16 , "Cannot add requested %d Kb of memory at runtime. You must request at least %d Kb of additional memory per cache partition at runtime.");
		add(10876 , 16 , "Configuration Error: The Server Default Data Cache should be named as 'default data cache'.");
		add(10877 , 16 , "The value of 'max parallel degree' (`%d') cannot be less than the value of 'max repartition degree' (`%d').");
		add(10878 , 10 , "Use sp_configure to lower the value of 'max repartition degree' or raise the value of 'max parallel degree'.");
		add(10879 , 16 , "The current 'max memory' value '%d', is not sufficient to change the size of cache '%.*s' to '%.*s' (%d KB). 'max memory' should be greater than 'total logical memory' '%d' required for the configuration.");
		add(10880 , 16 , "Large Memory Support is not available on this platform.");
		add(10881 , 16 , "Current size and the new configured size are the same for the extended cache. Verify the size specified.");
		add(10882 , 16 , "Reducing the size of extended cache is not dynamic. It will take effect at the next reboot.");
		add(10883 , 16 , "Extended cache configuration failed. Check the error log for more information.");
		add(10884 , 16 , "The value of '%s' ('%d') must be less than the value of '%s' ('%d').");
		add(10885 , 16 , "Configuration option '%s' is not available on this platform.");
		add(10886 , 16 , "An arithmetic overflow occurred during memory requirement calculation. Please reduce one or more memory consuming configuration parameters.");
		add(10887 , 16 , "CIS RPC handling requires CIS to be enabled.");
		add(10888 , 16 , "The value specified for configuration option '%s' '%d' cannot be greater than the difference between configuration options 'max online engines' and '%s'. The current difference is '%d'.");
		add(10889 , 16 , "The value specified for configuration option '%s' '%d' cannot be less than the sum of the configuration options 'number of engines at startup' and 'max online Q engines'. The current sum is '%d'.");
		add(10890 , 16 , "The value specified for configuration option '%s' '%d' results in an overlap with engines that are part of an engine group. '%s' cannot be set to a value greater than '%d'.");
		add(10891 , 16 , "The sum of the values specified for configuration options '%s' '%d' and '%s' '%d' exceeds the number of cpus '%d' available.");
		add(10892 , 16 , "CP property value in the ASE_CORE license does not allow you to set this configuration parameter to a value higher than %d.");
		add(10893 , 16 , "The value of 'max query parallel degree' (`%d') cannot be less than the value of 'max parallel degree' (`%d').");
		add(10894 , 16 , "Use sp_configure to lower the value of 'max parallel degree' or raise the value of 'max query parallel degree'.");
		add(10895 , 16 , "The value of 'number of worker processes' (`%d') cannot be less than the value of 'max query parallel degree' (`%d').");
		add(10896 , 16 , "Use sp_configure to lower the value of 'max query parallel degree' or raise the value of 'number of worker processes'.");
		add(10897 , 10 , "Warning: You are not allowed to reconfigure cluster-wide configuration option '%s' by update the config file directly or reconfigure it to be instance-specific if it is strictly cluster-wide. The cluster-wide value will be used.");
		add(10898 , 16 , "Statement cache monitoring needs the statement cache size > 0 and 'enable monitoring' on.");
		add(10899 , 16 , "Feature %s can only be enabled with ASE Enterprise Edition.");
		add(10901 , 17 , "This query requires %d auxiliary scan descriptors, but currently there are only %d auxiliary scan descriptors available. Either raise the value of the 'number of aux scan descriptors' configuration parameter or try your query later.");
		add(10902 , 17 , "This query requires %d auxiliary scan descriptors, but the Server is configured with only %d auxiliary scan descriptors. Raise the value of the 'number of aux scan descriptors' configuration parameter before trying this query.");
		add(10903 , 16 , "error executing %S_MSG");
		add(10904 , 10 , "Total number of passwords reset during downgrade = %d");
		add(10905 , 10 , "New password encryption algorithm found for login name %.*s, suid %d. Resetting password to '%.*s'.");
		add(10906 , 10 , "Warning: Login password is corrupted and will be reset during the downgrade phase, suid : %d, name : %.*s");
		add(10907 , 10 , "Warning: New password encryption algorithm found for login name %.*s, suid %d . Password will be reset during the downgrade phase.");
		add(10908 , 16 , "Do not downgrade until server is in single-user mode. Unexpected logins may corrupt passwords.");
		add(10909 , 10 , "Allow password downgrade is set to 0. Login passwords may be reset,if old encryption version of password is not present.");
		add(10910 , 16 , "Error executing 'exec sp_configure 'allow updates to system tables', 1'.");
		add(10911 , 16 , "Error executing 'Delete row from sysattributes'.");
		add(10912 , 16 , "Error executing 'Update on syslogins'.");
		add(10913 , 16 , "Error executing 'Delete from syscolumns'.");
		add(10914 , 16 , "Error executing 'Update password length'.");
		add(10915 , 16 , "Password downgrade has already modified master database, do not repeat downgrade.");
		add(10916 , 16 , "Password downgrade failed while deleting the row from sysattributes where class is %s (%d) and attribute or object is %s (%d).");
		add(10918 , 16 , "Error executing 'delete statistics syslogins(password)'.");
		add(10921 , 10 , "Login account %.*s is not locked.");
		add(10922 , 16 , "Duration %.*s specified is invalid.");
		add(10923 , 16 , "You must specify a value to set.");
		add(10925 , 16 , "The keysize '%.*s' is invalid. Valid sizes must be between 1024 and 4096 and a multiple of 512.");
		add(11001 , 10 , "Row count exceeded limit of %d.");
		add(11002 , 10 , "Estimated IO cost exceeded limit of %d.");
		add(11003 , 10 , "Actual IO cost exceeded limit of %d.");
		add(11004 , 10 , "Query batch running time exceeded limit of %d.");
		add(11005 , 10 , "Transaction's running time exceeded limit of %d.");
		add(11006 , 17 , "Unable to set a kernel alarm; timerange manager is unable to run.");
		add(11007 , 17 , "Unable to set a kernel alarm; time limit alarm cannot be set.");
		add(11008 , 20 , "An attempt to get a free cache member from the Resource Governor's pool has failed. This is a system error -- contact a user with System Administrator (SA) role.");
		add(11009 , 16 , "Syntax error converting to DATETIME from BINARY/VARBINARY string.");
		add(11010 , 10 , "Unknown limit type %d encountered -- limit will be ignored.");
		add(11011 , 10 , "Unknown limit scope 0x%x encountered -- limit will be ignored.");
		add(11012 , 10 , "Unknown limit enforcement time %d encountered -- limit will be ignored.");
		add(11013 , 16 , "Correlated columns are not allowed in the outer join clause of the subquery.");
		add(11014 , 10 , "Warning: Insufficient worker processes available. Query executed using current available worker processes. Inform the system administrator (SA) that the value of worker processes may be too low.");
		add(11015 , 16 , "Insufficient worker processes available. To execute, wait until the system is less busy or set process_limit_action to quiet or warning, or increase the value of worker processes.");
		add(11016 , 16 , "Cannot disable the role '%.*s' since you don't have it enabled.");
		add(11017 , 20 , "DLL for the extended stored procedure '%.*s' is not found. This is an internal error. Please contact SAP Technical Support.");
		add(11018 , 10 , "XP Server must be up for ESP to execute.");
		add(11019 , 16 , "Parameters to extended stored procedure must be passed all by name or all by position.");
		add(11020 , 16 , "Pseudo-column SYB_IDENTITY is referenced from a stored procedure after the identity column has changed. Please drop/recreate the stored procedure.");
		add(11021 , 16 , "Function %s invoked with wrong number or type of argument(s).");
		add(11022 , 16 , "Internal structure for cursor '%.*s' could not be located. This is a severe error. Please check for other errors preceding this one in the errorlog");
		add(11023 , 16 , "An internal structure for the cursor could not be created. This is deemed to be a serious error.");
		add(11026 , 10 , "Warning: The statement on line %d uses the '%.*s' option with the view '%.*s'. Performance hint options are valid only for tables. This hint will be ignored.");
		add(11028 , 16 , "Precomputed result set '%.*s' is immediate and enable, so it is automatically maintained. Refresh is not required.");
		add(11029 , 16 , "An index was found on table '%.*s' created via SELECT INTO. Parallel inserts into indexed tables is unsupported. Drop the table and retry the command.");
		add(11030 , 16 , "Execution of %S_MSG %.*s failed because the server was unable to change the owner context in database %S_DBID when upgrading the compiled object.");
		add(11031 , 16 , "Execution of %S_MSG %.*s failed because of errors parsing the source text in syscomments during upgrade. Please drop and recreate %.*s.%.*s.");
		add(11032 , 16 , "Execution of %S_MSG %.*s failed because the upgrade processing found incorrect source text in syscomments. Please drop and recreate %.*s.%.*s.");
		add(11033 , 16 , "Execution of %S_MSG %.*s failed because the upgrade processing did not find source text in syscomments. Please drop and recreate %.*s.%.*s.");
		add(11034 , 16 , "Execution of %S_MSG %.*s failed because the hidden source text could not be decrypted during upgrade. Please drop and recreate %.*s.%.*s.");
		add(11035 , 16 , "Execution of %S_MSG %.*s failed because upgrade found no entry in syscomments for this object. Please drop and recreate %.*s.%.*s.");
		add(11036 , 16 , "The passed-in table-variable '%.*s' does not have the same schema as the table variable parameter '%.*s' of the stored procedure.");
		add(11037 , 16 , "You specified an incorrect datatype for the variable containing the 'execute immediate' command string.");
		add(11038 , 16 , "Your password will expire in %.*s days.");
		add(11039 , 16 , "Another Execute Immediate statement cannot be executed inside an Execute Immediate statement.");
		add(11040 , 16 , "Adaptive Server cannot perform the requested action because column '%.*s' is not within the scope of the joined table expression. Check your command for missing or incorrect database objects, variable names, and/or input data.");
		add(11041 , 16 , "Adaptive Server cannot perform the requested action. Sybase outer joins and ANSI joins cannot be mixed in the same query. Rewrite the command as specified in the error message.");
		add(11042 , 18 , "Internal Error: Adaptive Server cannot find the ANSI outer join. The query tree may be corrupted. Please contact SAP Technical Support.");
		add(11044 , 16 , "Warning: Ignoring rule/check constraint '%.*s' specified on table '%.*s' because it refers to TEXT, IMAGE, UNITEXT or offrow Java datatype columns.");
		add(11045 , 16 , "%s command not allowed within the current running mode of the companion server");
		add(11046 , 10 , "Warning: The results of the statement on line %d are join-order independent. Results may differ on pre-12.0 releases, where the query is potentially join-order dependent.");
		add(11047 , 17 , "Insufficient number (%d) of 'worker processes' available at execution time to alter %d-way partitioned table '%.*s'. Increase the number of 'worker processes' or wait until the system is less busy.");
		add(11048 , 17 , "ALTER TABLE '%.*s' failed. Cursor '%.*s' is still open. Close this and any other open cursors on this table before this schema change operation.");
		add(11049 , 16 , "The definition of table variable '%.*s' is missing. Make sure it is declared with a table schema in the same batch before using it.");
		add(11050 , 16 , "Adaptive Server cannot process this ALTER TABLE statement due to one or more preceding errors. If there are no preceding errors, please contact SAP Technical Support.");
		add(11051 , 20 , "%s on the object '%.*s' failed. Table is currently being used by one or more other tasks. Retry your query later.");
		add(11052 , 16 , "Neither the 'select into' nor the 'full logging for alter table' database options are enabled for database '%.*s'. ALTER TABLE with data copy cannot be done.");
		add(11053 , 16 , "Cannot alter table '%.*s' because the database option 'allow nulls by default' has been changed by concurrent users.");
		add(11054 , 16 , "The table '%.*s' is an inner member of an outer-join clause. This is not allowed if the table also participates in a regular join clause.");
		add(11055 , 16 , "Query contains an illegal outer-join request.");
		add(11056 , 16 , "Exceeded tempdb space limit of %d pages.");
		add(11057 , 16 , "Execute cursor '%.*s' may not be declared on a SQLJ procedure.");
		add(11058 , 16 , "Statement contains '%d' columns/expessions in the target list. This exceeds the maximum limit of '%d'.");
		add(11060 , 16 , "This statement has exceeded the maximum number of recompilations (%d). This indicates an internal error. Please note the error prior to this one and contact SAP Technical Support.");
		add(11061 , 16 , "The number of columns in the derived column list does not equal the number of columns in the target list of the derived table expression.");
		add(11062 , 16 , "Column '%.*s' is a computed column. Only regular columns can be referenced in a computed column (or function-based index key) definition.");
		add(11063 , 16 , "The column '%.*s' in the outer query is not present in the derived column list or the derived query expression.");
		add(11064 , 14 , "ASE SUPER license is not available/enabled, hence the super class features not enabled.");
		add(11065 , 10 , "'%s' is ON for table '%.*s'.");
		add(11066 , 16 , "'%s' is not supported on proxy tables. Perform this operation directly on the base table.");
		add(11067 , 16 , "Cannot directly insert into or update computed column '%.*s'.");
		add(11068 , 20 , "Transaction was found in the incorrect state of '%s'. The expected state was '%s'.");
		add(11069 , 16 , "Partition '%.*s' does not exist in table '%.*s'.");
		add(11070 , 16 , "The option to specify a partition name is not valid for a table created in a stored procedure.");
		add(11071 , 16 , "The option to specify a partition name is not allowed for views.");
		add(11072 , 18 , "An internal conversion error was found while converting datatype '%s' to datatype '%s'.");
		add(11073 , 16 , "A derived table expression may not have null column names. Use a derived column list in the derived table definition or name the column expressions in the SELECT target list.");
		add(11074 , 16 , "TEXT, IMAGE, UNITEXT, or offrow Java datatype column (%.*s) cannot be referenced in rule/check constraints.");
		add(11075 , 16 , "Virtual computed column '%.*s' cannot be referenced in any constraints.");
		add(11076 , 16 , "The name '%.*s' is too long. Maximum length is %d.");
		add(11077 , 16 , "No column is referenced in the function-based index key.");
		add(11078 , 16 , "Virtual computed column '%.*s' cannot be referenced in a IF UPDATE clause.");
		add(11079 , 16 , "A computed column cannot reference a user-defined function (%.*s) that belongs to a different database.");
		add(11080 , 16 , "The definition tree (object id: %d) of computed column '%.*s' is missing.");
		add(11082 , 10 , "Transaction's idle time exceeded limit of %d seconds.");
		add(11083 , 16 , "Unable to resolve built-in function at line %d, statement %d. Please check if this database has been downgraded recently.");
		add(11084 , 16 , "Same expression subquery is not allowed to participate in multiple NOT IN or ALL predicates. Try to rewrite the query.");
		add(11085 , 16 , "The %S_MSG that starts with '%.*s' is too long. Maximum length allowed for the client is %d. The old client does not support large identifier.");
		add(11086 , 16 , "The target table of a select-into-existing-table command cannot be the same as any of the source tables.");
		add(11087 , 16 , "Command '%s' is unsupported.");
		add(11088 , 16 , "Datatype '%s' is invalid for index key columns and hash factors of virtually hashed tables. Only integer datatypes are supported.");
		add(11090 , 16 , "Only input strings of size < 16K are supported.");
		add(11091 , 16 , "Size of text > 16K after parameterization, returning partial output.");
		add(11092 , 16 , "XMLTABLE ORDINALITY column must be a numeric datatype with a scale of 0.");
		add(11093 , 16 , "XMLTABLE column definition cannot contain only ordinality column.");
		add(11094 , 16 , "XMLTABLE column definition can contain only one ordinality column.");
		add(11095 , 10 , "The SQL text output is truncated to 16384 bytes.");
		add(11096 , 10 , "The statement id is not valid.");
		add(11097 , 16 , "The select-items cannot include any reference to any column of XMLTABLE that is not one of the grouping columns, unless that reference represents the argument, or part of the argument, to one of the aggregate functions.");
		add(11098 , 16 , "A value for NOT_NULL column '%.*s' must be given in the INSERT list.");
		add(11099 , 16 , "Only extended stored procedures can be called within a sql function.");
		add(11101 , 16 , "Cannot grant the role '%.*s' because it contains role '%.*s' which is mutually exclusive with role '%.*s' which is possessed by grantee '%.*s'. Remove the exclusivity and try again.");
		add(11102 , 16 , "Operation failed. Role '%.*s' (contained by role '%.*s') is mutually exclusive at activation or membership level with role '%.*s' (contained by role '%.*s' which is the grantee role or the ancestor role of grantee). Remove the exclusivity and try again.");
		add(11103 , 16 , "Cannot grant the roles '%.*s' and '%.*s' because they are mutually exclusive at activation or membership level. Remove the exclusivity and try again.");
		add(11104 , 16 , "Cannot grant the role '%.*s' to role '%.*s' because it will result in cycle.");
		add(11105 , 16 , "No such user/role '%.*s' exists.");
		add(11106 , 16 , "Failed to grant role '%.*s' to grantee '%.*s' because failed to expand the role to be granted.");
		add(11107 , 10 , "All the roles specified to be granted in the grant role statement have already been granted to grantee '%.*s'.");
		add(11108 , 10 , "The result of the REVOKE ROLE command will take effect once the user logs out and then logs in again.");
		add(11109 , 14 , "You must have SSO authorization to grant/revoke user defined roles.");
		add(11110 , 14 , "You must be in the master database to GRANT/REVOKE ROLE. Contact the System Administrator (SA) if you do not have permission to run USE master.");
		add(11111 , 16 , "No such role '%.*s' exists.");
		add(11112 , 16 , "You must have SSO authorization to create User Defined Roles.");
		add(11113 , 16 , "You must be in the master database to run CREATE ROLE command. Contact the System Administrator (SA) if you do not have permission to run USE master.");
		add(11114 , 16 , "A role with name '%.*s' already exists in this server.");
		add(11115 , 16 , "The role '%.*s' was not dropped because it still has privilege granted to it. Use the 'WITH OVERRIDE' option to drop it.");
		add(11116 , 16 , "Cannot drop role or login '%.*s' because it does not exist in this server.");
		add(11117 , 16 , "You must have SSO authorization to drop Logins or User Defined Roles.");
		add(11118 , 16 , "You must be in the master database to run DROP ROLE command. Contact the System Administrator (SA) if you do not have permission to run USE master.");
		add(11119 , 16 , "Cannot %S_MSG %S_MSG '%.*s' because it is required for the system.");
		add(11120 , 16 , "You must have SSO authorization to use ALTER ROLE to define roles exclusivity.");
		add(11121 , 16 , "You must be in the master database to run ALTER ROLE. Contact the System Administrator (SA) if you do not have permission to run USE master.");
		add(11122 , 16 , "Cannot drop the '%.*s' exclusivity between role '%.*s' and '%.*s' since it does not exist in this server.");
		add(11123 , 16 , "Operation failed because the user '%.*s' has been granted both role '%.*s' and role '%.*s'. Revoke one of the roles from the user and rerun this command.");
		add(11124 , 16 , "Operation failed because role '%.*s' has been granted both role '%.*s' and role '%.*s'. Revoke one of the granted roles from role '%.*s' and rerun this command.");
		add(11125 , 10 , "Warning: User '%.*s' (process ID '%d') has both roles '%.*s' and '%.*s' enabled. This violates the '%.*s' exclusivity just added. Terminate the user's process to remove the violation.");
		add(11126 , 16 , "Cannot add the '%.*s' exclusivity between role '%.*s' and role '%.*s' because it already exists for this server.");
		add(11127 , 16 , "The role named as '%.*s' does not exist for this server. Check the name and resubmit the ALTER ROLE command");
		add(11128 , 16 , "Activation predicate for role '%.*s' is not found in the system tables");
		add(11131 , 16 , "Failed to expand the role with srid '%d' because this exceeds the maximum role limit of '%d'. Please revoke/disable roles you don't require and then rerun your command.");
		add(11132 , 16 , "ASE failed to execute the built-in function %s because it failed to expand the role '%.*s'.");
		add(11133 , 16 , "%s: unknown option: '%.*s'. Use either '%s' or '%s' as an option value.");
		add(11134 , 16 , "You already have the role '%.*s' active.");
		add(11135 , 18 , "Cannot assign login profile '%.*s' %S_MSG because it possesses role '%.*s' which is mutually exclusive with role '%.*s' possessed by login '%.*s'. Remove the exclusivity and try again.");
		add(11136 , 16 , "You have reached the limit on the number of roles (%d) you can enable per session.");
		add(11137 , 18 , "Failed to add the role '%.*s' into the current database catalogs.");
		add(11138 , 16 , "Failed to create role '%.*s', because this exceeds the maximum number roles limit of '%d'. Please delete roles you don't need and rerun your command.");
		add(11141 , 16 , "Password required to set role '%.*s' on.");
		add(11142 , 16 , "You specified the wrong password for enabling role '%.*s'. Try again with the correct password.");
		add(11143 , 16 , "The password specified in CREATE/ALTER ROLE command is too short. The minimum length of passwords is %d characters. Try again with a password that is %d or more characters in length.");
		add(11145 , 16 , "Command failed because no password exists for role '%.*s'.");
		add(11146 , 16 , "Password already exists for role '%.*s'. Drop the existing password and then add the new password.");
		add(11148 , 16 , "Operation failed. Role '%.*s' (contained by role '%.*s') is mutually exclusive at activation or membership level with role '%.*s' (which is the ancestor of role '%.*s' in the hierarchy). Remove the exclusivity and try again.");
		add(11149 , 16 , "Operation failed. Role '%.*s' is contained by/contains role '%.*s'. Revoke the granted role from role '%.*s' or '%.*s' and rerun the command.");
		add(11150 , 16 , "Operation failed. Role '%.*s' is mutually exclusive at membership or activation level with role '%.*s'. Remove the exclusivity and try again.");
		add(11151 , 16 , "Cannot grant the role '%.*s' because it is mutually exclusive with role '%.*s' which is possessed by grantee '%.*s'. Remove the exclusivity and try again.");
		add(11152 , 16 , "Operation failed. Role '%.*s' is mutually exclusive at activation or membership level with role '%.*s' (contained by role '%.*s' which is the grantee role or the ancestor role of grantee). Remove the exclusivity and try again.");
		add(11153 , 16 , "Operation failed. Role '%.*s' (contained by role '%.*s') is mutually exclusive at membership or activation level with role '%.*s'. Remove the exclusivity and try again.");
		add(11154 , 16 , "Operation failed. Role '%.*s' has not been granted to role '%.*s'.");
		add(11155 , 16 , "Operation failed. Role '%.*s' has not been granted to user '%.*s'.");
		add(11156 , 16 , "Operation failed. Role '%.*s' is mutually exclusive at activation or membership level with role '%.*s' (which is the ancestor of role '%.*s' in the hierarchy). Remove the exclusivity and try again.");
		add(11157 , 16 , "Operation failed. Role '%.*s' is mutually exclusive at membership level with role '%.*s' (which along with role '%.*s' has been granted to user '%.*s'). Remove the exclusivity and try again.");
		add(11158 , 16 , "Operation failed. Role '%.*s' (contained by role '%.*s') is mutually exclusive at membership level with role '%.*s' (which along with role '%.*s' has been granted to user '%.*s'). Remove the exclusivity and try again.");
		add(11159 , 16 , "Operation failed. Role '%.*s' (contained by role '%.*s') is mutually exclusive at activation or membership level with role '%.*s' (contained by role '%.*s'). Remove the exclusivity and try again.");
		add(11160 , 16 , "Operation failed. Role '%.*s' (contained by role '%.*s') is mutually exclusive at activation or membership level with role '%.*s'. Remove the exclusivity and try again.");
		add(11161 , 16 , "Operation failed. Role '%.*s' (contained by role '%.*s') is mutually exclusive at activation level with role '%.*s' (contained by role '%.*s', which has already been enabled).");
		add(11162 , 16 , "Operation failed. Role '%.*s' (contained by role '%.*s') is mutually exclusive at activation level with role '%.*s' (which has already been enabled).");
		add(11165 , 16 , "A user, group, login or login profile with the name '%.*s' already exists in this server.");
		add(11166 , 16 , "User '%.*s' is currently logged in. The revocation of roles from users that are currently logged in is not allowed.");
		add(11167 , 16 , "The role 'sybase_ts_role' cannot be granted to other roles.");
		add(11168 , 16 , "The role '%.*s' does not have a password. The value you specified for minimum password length will be used when a password is added to the role.");
		add(11169 , 16 , "All overrides for the '%.*s' option have been removed.");
		add(11170 , 16 , "Invalid value specified for '%.*s' attribute. Try again with a valid value.");
		add(11171 , 16 , "The specified password does not have any numeric characters. New passwords must have at least one numeric character.");
		add(11172 , 14 , "The role '%.*s' is locked. Contact a user with System Security Officer(SSO) role.");
		add(11174 , 16 , "Operation failed because it could not be performed on both companions. Retry later.");
		add(11175 , 16 , "Operation failed because the limit for maximum number of roles that can be synchronized on companions is '%d'.");
		add(11176 , 16 , "Password for role '%.*s' has expired. You must change it before you can enable this role.");
		add(11177 , 16 , "The login '%.*s' is still a user, alias or database owner in '%S_DBID' database.");
		add(11178 , 16 , "Role '%.*s' cannot be dropped because references to the role exist in one or more local temporary databases. In ASE Cluster, no privileges should be granted to the role in any local temporary database. This role can be dropped after a cluster reboot.");
		add(11179 , 16 , "The login '%.*s' was not dropped because it still has execution class bindings. Use sp_unbindexeclass before dropping login.");
		add(11180 , 16 , "The login '%.*s' was not dropped because it is currently active in process ID(s) %.*s.");
		add(11181 , 16 , "Cannot grant permissions to or revoke permissions from a user defined role in a local temporary database '%.*s' in a cluster.");
		add(11182 , 16 , "Cannot set a local temporary database ('%.*s') as the default database for a login ('%.*s').");
		add(11183 , 16 , "Login or login profile with suid '%d' already exists.");
		add(11184 , 16 , "Login profile '%.*s' does not exist.");
		add(11185 , 16 , "suid out of range. Valid range is from %d to %d and %d to %d.");
		add(11186 , 16 , "Login '%.*s' specified does not exist.");
		add(11187 , 16 , "Login name '%.*s' is not allowed.");
		add(11188 , 16 , "Cannot alter login.");
		add(11189 , 16 , "Operation failed. Role '%.*s' has not been granted to login or login profile '%.*s'.");
		add(11190 , 16 , "Login script '%.*s' is invalid.");
		add(11191 , 16 , "The login script '%.*s' must exist in the default database '%.*s'.");
		add(11192 , 16 , "Specified role '%.*s' is password protected. Drop the password to automatically activate the role through a login or login profile.");
		add(11193 , 16 , "The specified login profile is the default login profile and/or associated with one or more login accounts. Remove the default property and/or associations or use the WITH OVERRIDE clause to drop the login profile.");
		add(11194 , 16 , "Failed to lock login '%.*s'.");
		add(11195 , 16 , "Failed to execute master.dbo.sp_cleanpwdchecks %.*s.");
		add(11196 , 16 , "DROP LOGIN failed because login owns objects in one or more databases. See previous messages for more information.");
		add(11197 , 10 , "Login '%.*s' owns object '%.*s' in database '%.*s'.");
		add(11198 , 10 , "The database '%S_DBID' is currently not available and cannot be checked for %S_MSG.");
		add(11199 , 10 , "Warning: The database '%S_DBID' is currently not available and cannot be checked for login references.");
		add(11201 , 16 , "A remote table definition must be defined before the 'existing' option is used (object '%.*s').");
		add(11202 , 16 , "Unable to create table '%.*s' because it has no remote storage location defined. Creation of local user tables is allowed only in the master and tempdb databases.");
		add(11203 , 16 , "The command '%s' is not legal for objects of this type. External definition: %.*s");
		add(11204 , 16 , "There is an error in the syntax of the object definition '%.*s'.");
		add(11205 , 16 , "Data type '%s' is unsupported for server '%.*s'.");
		add(11206 , 16 , "Unable to connect to server '%.*s'.");
		add(11207 , 10 , "Warning, table definition does not contain all columns found in remote object '%.*s'; (defined: %d found: %d).");
		add(11208 , 16 , "No column named '%.*s' found in remote object '%.*s'.");
		add(11209 , 16 , "Column type mismatch in remote object '%.*s' for column '%.*s'; (defined: %d found: %d).");
		add(11210 , 16 , "Column length mismatch in remote object '%.*s' for column '%.*s'; (defined %d found: %d).");
		add(11211 , 16 , "Handling of null values in remote object '%.*s' for column '%.*s' differs from that defined; (defined: '%s' found: '%s').");
		add(11212 , 16 , "Identity attribute mismatch for column '%.*s'; (defined: '%s' found: '%s').");
		add(11213 , 16 , "Column count mismatch in remote object '%.*s'; (defined: %d found %d).");
		add(11214 , 16 , "Remote object '%.*s' does not exist.");
		add(11215 , 16 , "Remote object '%.*s' not uniquely identified; %d objects with the same name and owner were found.");
		add(11216 , 16 , "Internal Ct-Lib/Cs-Lib error %d: '%.*s'.");
		add(11217 , 10 , "Entered passthru mode to server '%.*s'.");
		add(11218 , 10 , "Exited passthru mode from server '%.*s'.");
		add(11219 , 17 , "Cannot open a connection to site '%.*s' because there are no free remote descriptors (RDES). Increase the configuration parameter for user connections and reboot the server.");
		add(11220 , 16 , "Parameter cannot be NULL.");
		add(11221 , 16 , "No external login for suserid %d, server name '%.*s'.");
		add(11222 , 16 , "Parameter %d must be datatype CHAR or VARCHAR.");
		add(11223 , 17 , "Insufficient memory is available to allocate structures needed to access a remote site.");
		add(11224 , 16 , "Cannot open a connection to site '%.*s' because it does not have PASSTHRU or RPC capabilities.");
		add(11225 , 16 , "Server class has not been defined for '%.*s'.");
		add(11226 , 16 , "Server class (%d) for server '%.*s' is not supported.");
		add(11227 , 16 , "Statement '%s' is unsupported by '%.*s'.");
		add(11228 , 16 , "Remote text/image data length less than expected for column '%.*s'.");
		add(11229 , 16 , "Unable to commit transaction on remote server %.*s.");
		add(11230 , 16 , "Unable to prepare transaction on remote server %.*s.");
		add(11231 , 16 , "Unable to rollback transaction on remote server %.*s.");
		add(11232 , 16 , "Unable to access cursor process status structure (PSS); update cannot be completed.");
		add(11233 , 16 , "Column mismatch in remote object '%.*s' for column '%.*s'; (column must be defined with length >= 10 or as DATETIME).");
		add(11234 , 16 , "Column mismatch in remote object '%.*s' for column '%.*s'; (column must be defined with length >= 8 or as DATETIME).");
		add(11235 , 16 , "Column mismatch in remote object '%.*s' for column '%.*s'; (column must be defined with length >= 26 or as DATETIME).");
		add(11236 , 16 , "Remote server error: Msg %d, Level %d, State %d, Server '%.*s', %.*s");
		add(11237 , 16 , "TEXT/IMAGE value too long for INSERT/UPDATE on server '%.*s'. Use WRITETEXT instead.");
		add(11238 , 10 , "Remote server message: Msg %d, Level %d, State %d, Server '%.*s', %.*s");
		add(11242 , 10 , "Component Integration Services recovery started.");
		add(11243 , 10 , "Component Integration Services recovery complete.");
		add(11244 , 10 , "Deallocating text/image data for external object '%.*s'.");
		add(11245 , 10 , "Checking external objects.");
		add(11246 , 16 , "Precision or scale mismatch in remote object '%.*s' for column '%.*s'; (defined: %d,%d found: %d,%d).");
		add(11247 , 16 , "Scale mismatch in remote object '%.*s' for column '%.*s'; (defined: %d found: %d).");
		add(11248 , 16 , "Remote server '%.*s' is currently configured as read only.");
		add(11249 , 16 , "Unable to connect to server '%.*s' from server '%.*s'.");
		add(11250 , 16 , "SQL functions are not supported for proxy tables.");
		add(11251 , 10 , "....... Dynamic Update");
		add(11252 , 10 , "....... Select for Update");
		add(11253 , 10 , "....... Dynamic Delete");
		add(11254 , 10 , "....... Select for Delete");
		add(11255 , 10 , "....... Remote Cursor Operation");
		add(11256 , 10 , "....... %.*s");
		add(11257 , 10 , "........... %.*s");
		add(11258 , 16 , "No column with column id '%d' found in local table.");
		add(11259 , 10 , "Warning, no mapping for remote column named '%.*s' in local object '%.*s'.");
		add(11263 , 10 , "....... Server Name: %.*s");
		add(11264 , 10 , "....... Text of generated SQL:");
		add(11265 , 20 , "Internal error: A session descriptor is missing a remote access object for server '%.*s'.");
		add(11266 , 16 , "The sp_columns result set returned by the remote server is incomplete. Each row must contain at least %d columns, but only %d are present.");
		add(11267 , 16 , "Unable to create table '%.*s' on remote server; this server not configured for heterogeneous data access.");
		add(11268 , 16 , "Unable to insert into a text/image column because the table does not contain a unique index.");
		add(11269 , 16 , "The optimizer could not find a unique index which it could use to retrieve the resulting timestamp value");
		add(11270 , 16 , "Column '%.*s' does not allow null. Any column defined as a parameter column for RPC tables must allow null. A parameter column is a column whose name begins with an underscore.");
		add(11271 , 16 , "Column '%.*s' must precede all parameter columns. A parameter column is a column whose name begins with an underscore.");
		add(11272 , 16 , "Action requested is not valid for remote tables (%.*s).");
		add(11273 , 10 , "Encountered %d conversion errors during processing of external statistics; some rows have been ignored.");
		add(11274 , 0  , "Unable to establish server login to remote server '%.*s'; @@servername is NULL");
		add(11275 , 16 , "A statement referencing an extended datatype contained syntax that prevented it from being sent to the remote server. Rewrite the statement or remove the extended datatype reference.");
		add(11276 , 16 , "An object in column '%.*s' could not be deserialized, possibly because the object was truncated. Check that the value of @@textsize is large enough to accommodate the serialized object.");
		add(11277 , 16 , "Operating system error %d: '%.*s'.");
		add(11278 , 16 , "The file at the specified path is not a directory (%.*s).");
		add(11279 , 16 , "Only the file name can be changed, and it is not included in the SET list.");
		add(11280 , 16 , "The pathname length must be 349 bytes or less.");
		add(11281 , 16 , "Cannot enable full-text search services because there is no license available.");
		add(11282 , 16 , "Cannot create the file (%.*s). A file with the same name already exists.");
		add(11283 , 16 , "External file access is not enabled or not licensed.");
		add(11284 , 10 , "Warning, a failure occurred while attempting to partition proxy table '%.*s'. The proxy table is unpartitioned.");
		add(11285 , 18 , "Attempt to allocate OMNI descriptor failed for remote object '%.*s' of object id %d.  See error log for more information.");
		add(11286 , 16 , "Omni CT-Lib Error Diagnostics.");
		add(11287 , 16 , "Function-based indexes are not supported on proxy_tables.");
		add(11288 , 11 , "Column '%.*s'%.*s does not match for the local and remote servers.");
		add(11289 , 16 , "Datatype %d for column '%.*s'%.*s is not supported by UPDATE STATISTICS in import mode.");
		add(11290 , 11 , "%s statistics for column '%.*s'%.*s is unavailable or incomplete in the remote server.");
		add(11291 , 11 , "%s statistics for colidarray %.*s is unavailable or incomplete in the remote server.");
		add(11292 , 10 , "UPDATE STATISTICS will not run in import mode.");
		add(11293 , 11 , "Index '%.*s' does not exist in the remote server for '%.*s.%.*s.%.*s.%.*s'. UPDATE STATISTICS will continue to run in import mode since the remote statistics are available.");
		add(11294 , 10 , "The remote server ('%.*s') class %d is not supported by UPDATE STATISTICS in import mode.");
		add(11295 , 10 , "Statistics for %s are not updated.");
		add(11296 , 16 , "Partitioned proxy tables are not supported.");
		add(11297 , 16 , "Cannot Add/Drop/Modify encrypted columns on proxy tables.");
		add(11298 , 16 , "The '%s' command contains syntax that requires it to use a cursor but the remote server does not support updateable cursors.");
		add(11299 , 10 , "Warning: The referential integrity reference to table '%.*s' will not be enforced because the references clause cannot be sent to the remote server.");
		add(11302 , 20 , "Internal error: Lock structure overflowed while executing the built-in function logschema() on object '%d' in database '%d'. Please contact SAP Technical Support.");
		add(11303 , 16 , "Failed to obtain locks while executing the built-in function logschema() on object '%d' in database '%d'. Retry the operation.");
		add(11304 , 20 , "Internal error: No free session descriptor is available for opening the user object '%d' in database '%d' while executing the built-in function logschema(). Please contact SAP Technical Support.");
		add(11305 , 16 , "Failed to open the object '%d' in database '%d' while executing the built-in function '%s'. Check if the object exists and retry the operation.");
		add(11306 , 16 , "The object '%d' cannot be found in sysobjects in database '%d'. Check the value of the object ID and retry the operation.");
		add(11307 , 16 , "The object '%d' in database '%d' is not a valid parameter for the built-in function logschema(). The object must be a user table or a stored procedure.");
		add(11308 , 20 , "Internal Error: There is no row in sysusers in database '%d' for user with user ID '%d'. However, this user is the owner of the object '%d' in this database. Please contact SAP Technical Support.");
		add(11309 , 16 , "The built-in function logschema() failed for object '%d' in database '%d'. See the other messages printed along with this message for more information.");
		add(11310 , 20 , "Internal Error: The database '%d' in which the object '%d' resides and the database '%d' in which the schema needs to be logged are different for a schema modification operation. Please contact SAP Technical Support.");
		add(11311 , 20 , "Internal Error: The column count in the XOBJINFO log record for object '%d' in database '%d' is different from the number of XCOLINFO log records that are logged. Please contact SAP Technical Support.");
		add(11312 , 20 , "Permission denied. User cannot execute the built-in function logschema() on object '%d' in database '%d'.");
		add(11313 , 20 , "Failed to write the replication log record for the '%.*s' command for object '%.*s' in database '%S_DBID'. The '%.*s' command is aborted.");
		add(11314 , 17 , "Failed to write the replication log record for the '%.*s' command in database '%S_DBID'. The '%.*s' command will not be replicated.");
		add(11315 , 16 , "Valid values for login name, password, and suid must be specified to the VALIDATE LOGIN statement.");
		add(11400 , 11 , "Could not load library %s. %s");
		add(11401 , 10 , "The number of RPC parameters is %d.");
		add(11402 , 10 , "DLL %s was successfully loaded.");
		add(11403 , 16 , "Encountered an exception(%d) in ESP %s in DLL %s. If this is an user DLL check the code else contact SAP Technical Support.");
		add(11404 , 20 , "ESP %s not found in DLL %s.");
		add(11405 , 19 , "Illegal ESP priority specified. Setting it to previous value %d.");
		add(11406 , 10 , "DLLname = %s.");
		add(11407 , 10 , "ESPname = %s.");
		add(11408 , 19 , "Illegal DLL file name length specified. Name will be truncated to %s.");
		add(11409 , 19 , "Illegal ESP name length specified. Name will be truncated to %s.");
		add(11410 , 20 , "Failed to register the XP Server log file %s.");
		add(11411 , 20 , "Failed to set specified STACK SIZE %d for XP Server. Check the valid range in the documentation.");
		add(11412 , 20 , "Failed to set preemptive scheduling mode. Most probably Open Server does not support it on this platform.");
		add(11413 , 10 , "%s just disconnected.");
		add(11414 , 10 , "XP Server is shutting down.");
		add(11415 , 10 , "XP Server is now running.");
		add(11416 , 20 , "Failed to install the connection handler. Check the XP Server log file.");
		add(11417 , 20 , "Failed to install the disconnect handler. Check the XP Server log file.");
		add(11418 , 20 , "Failed to install the RPC handler. Check the XP Server log file.");
		add(11419 , 20 , "Failed to install the stop handler. Check the XP Server log file.");
		add(11420 , 20 , "Failed to get connection context. Check the XP Server log file.");
		add(11421 , 20 , "Failed to set version of Open Server. Check the XP Server log file.");
		add(11422 , 20 , "Cannot determine XP Server name. XP Server shutting down.");
		add(11423 , 10 , "The XP Server log file name exceeded the maximum limit of %d characters.");
		add(11424 , 20 , "Failed to set error handler for XP Server. Check the XP Server log file.");
		add(11425 , 20 , "Failed to initialize XP Server. Check the XP Server log file.");
		add(11426 , 20 , "Failed to register the Start Handler. Check the XP Server log file.");
		add(11427 , 20 , "Failed to run XP Server. Check the XP Server log file.");
		add(11428 , 10 , "Normal exit thru return from srv_run.");
		add(11429 , 18 , "Failed to free CS_CONTEXT structure. Check the XP Server log file.");
		add(11430 , 10 , "ESP priority set to %d.");
		add(11431 , 10 , "Default stack size for ESP is %d.");
		add(11432 , 10 , "XP Server name is %s.");
		add(11433 , 19 , "Invalid XP Server name length specified. This is an internal error. XP Server is shutting down.");
		add(11434 , 10 , "DLLs will be unloaded automatically.");
		add(11435 , 10 , "Client impersonation context set for ESPs.");
		add(11436 , 10 , "Entering main().");
		add(11437 , 10 , "Debug mode detected.");
		add(11438 , 10 , "NT Service Option detected. Starting service.");
		add(11439 , 10 , "Attempting StartServiceCtrlDispatcher().");
		add(11440 , 20 , "Could not start service. Failed in StartServiceCtrlDispatcher.");
		add(11441 , 16 , "Authentication failed. Connection denied. XP Server does not accept direct connection.");
		add(11442 , 20 , "Invalid authentication. Please contact SAP Technical Support.");
		add(11443 , 10 , "Authentication was successful.");
		add(11444 , 20 , "Failed to register the service control handler. You may start the XP Server through command line interface.");
		add(11445 , 10 , "Entered xp_srv_service_main.");
		add(11446 , 20 , "Failed to create the service thread.");
		add(11447 , 20 , "Failed to create the service event.");
		add(11448 , 20 , "%s: Operating System Error: %d: %s.");
		add(11449 , 20 , "%s: Open Server Error: %d/%d/%d: %s.");
		add(11450 , 18 , "%s: Fatal XP Server Error: %d/%d/%d: %s.");
		add(11451 , 16 , "%s: XP Server Error: %d/%d/%d: %s.");
		add(11452 , 10 , "%s just connected.");
		add(11453 , 20 , "Could not get TDS version in connection handler. This is an internal error. Please contact SAP Technical Support.");
		add(11454 , 20 , "Invalid client or ASE TDS version. TDS version 4.6 or higher required.");
		add(11455 , 20 , "Failed to get thread type for connection handler. This is an internal error. Please contact SAP Technical Support.");
		add(11456 , 20 , "Failed to get login authentication type. This is an internal error. Please cont act SAP Technical Support.");
		add(11457 , 17 , "Failed to get the time. Using random macro instead.");
		add(11458 , 10 , "The DLL %s was successfully unloaded.");
		add(11459 , 20 , "The system DLL %s was not successfully loaded.");
		add(11460 , 18 , "Sybmail configuration failed. Use xp_startmail with parameters to start the ASE mail session.");
		add(11461 , 18 , "ESP configuration failed. Default Values are used.");
		add(11462 , 16 , "Could not load the DLL %s.");
		add(11463 , 16 , "Invalid number of parameters specified. Check the documentation for minimum and maximum number of parameters.");
		add(11464 , 16 , "Invalid parameter value specified. Refer the documentation for the correct value(s).");
		add(11465 , 18 , "Event Log configuration failed.");
		add(11466 , 10 , "Eventlog enable/disable flag is %d.");
		add(11467 , 20 , "Invalid ASE name length (-a). Please check the documentation. XP Server is shutting down.");
		add(11468 , 10 , "ASE name is %s.");
		add(11469 , 20 , "Error condition in ESP. Refer to the XP Server log file for more information.");
		add(11470 , 10 , "Stack size specified was too small. Using default size.");
		add(11471 , 20 , "Failed to set XP Server interfaces file %s. XP Server shutting down.");
		add(11472 , 20 , "The pathname specified for the interfaces file was too long. Check documentation for the maximum value.");
		add(11473 , 10 , "Interfaces file %s is being referred by XP Server.");
		add(11474 , 20 , "XP Server can not determine the client type.");
		add(11475 , 10 , "Direct connection to the XP Server is not allowed.");
		add(11476 , 20 , "Could not install the signal handler for %s. Please contact SAP Technical Support.");
		add(11477 , 16 , "A signal(%s) was raised while executing this ESP. If this is an user DLL check the code else contact SAP Technical Support.");
		add(11478 , 20 , "Failed to set the service status. This is an internal error. Please contact Syb ase Technical Support.");
		add(11479 , 20 , "NT service manager-related internal error.");
		add(11480 , 10 , "DLL for the extended stored procedure not found. Check entry in syscomments for this ESP.");
		add(11481 , 10 , "Unable to start XP Server startup task. The server can continue running without this task, however notify SAP Technical Support for this error.");
		add(11482 , 17 , "Cannot allocate memory. Check the XP Server log file.");
		add(11483 , 10 , "XP Server configuration failed.");
		add(11484 , 10 , "Sybmail configuration for XP Server failed.");
		add(11485 , 20 , "XP Server name is required to start XP Server. XP Server shutting down.");
		add(11486 , 10 , "Cannot unload DLL %s. Either there is an Operating System error while unloading or the DLL was never loaded.");
		add(11487 , 10 , "Attempt to free DLL failed. Check XP Server errorlog file for more information.");
		add(11488 , 14 , "User access denied. Not a member of NT administrators group.");
		add(11489 , 10 , "Event Log configuration for XP Server failed. Check XP Server errorlog file for more information.");
		add(11493 , 14 , "User access denied. Failed to change the user context.");
		add(11494 , 16 , "Invalid Domain Name. PLease enter the correct Domain name and re-run the command.");
		add(11495 , 16 , "Failed to synchronize with ASE. Shutting down the XP Server.");
		add(11496 , 16 , "Cannot %S_MSG site '%S_SRVID'. Please check the XP Server error log file for detailed error description.");
		add(11497 , 20 , "Extended stored procedure %s in dll %s has bad linkage (should be __stdcall)");
		add(11498 , 20 , "xp_cmdshell system esp unable to create synchronisation mutex");
		add(11499 , 16 , "dll currently in use and will be unloaded later");
		add(11501 , 12 , "Invalid data type. An integer value must be supplied for error number.");
		add(11502 , 12 , "Invalid data type. A VARCHAR value must be supplied for message.");
		add(11503 , 12 , "Invalid data type. A VARCHAR value must be supplied for type.");
		add(11504 , 16 , "Error number must be equal to or greater than 50000.");
		add(11505 , 16 , "Type must be 'informational', 'warning' or 'error'.");
		add(11506 , 17 , "Internal error: cannot allocate memory.");
		add(11507 , 16 , "Invalid number of parameters. Error number and message must be provided.");
		add(11508 , 17 , "Event logging is not enabled. Cannot log event in event log.");
		add(11513 , 10 , "Event log computer name is %s.");
		add(11514 , 17 , "Failed to log event in Event Log. The Event Log may be FULL.");
		add(11515 , 18 , "Failed to initialize Event Log.");
		add(11516 , 20 , "Failed to create mutex '%s' used by Sybmail. Refer to other error messages for possible cause of the problem.");
		add(11517 , 20 , "The mail session was already active when %s was invoked. Invocation of this ESP will have no effect.");
		add(11518 , 20 , "Sybmail encountered CMC Error: %s.");
		add(11519 , 20 , "The mail session was not active. Start the mail session using xp_startmail before calling %s.");
		add(11520 , 20 , "Failed to get the number of input parameters for %s. Please contact SAP Technical Support.");
		add(11521 , 20 , "The function %s received an invalid number of parameters (%d). Check user documentation and re-enter command.");
		add(11522 , 20 , "The call to srv_descfmt() failed in %s. Please contact SAP Technical Support.");
		add(11523 , 20 , "The call to srv_xferdata() failed in %s. Please contact SAP Technical Support.");
		add(11524 , 20 , "The function %s expected some recipients, but none were found. Re-enter command with a value for @recipient.");
		add(11525 , 20 , "Memory allocation in %s of size %d failed. Check that sufficient memory is available to XP Server.");
		add(11526 , 20 , "No message retrieved and/or deleted because none found.");
		add(11527 , 20 , "The call to sm_bindparamdata() failed for parameter %s. Please contact SAP Technical Support.");
		add(11528 , 20 , "The call to sm_bindretprmdata() failed for parameter %s. Please contact SAP Technical Support.");
		add(11529 , 20 , "Failed to load CMC Library. Check that the library exists in a known location and re-enter command.");
		add(11530 , 20 , "Failed to get address of function '%s'.Please contact SAP Technical Support.");
		add(11531 , 20 , "Invocation of function %s failed. Please contact SAP Technical Support.");
		add(11532 , 20 , "Failed to create attach file. Error number from Win32 System Service is %d.");
		add(11533 , 20 , "Failed to write to attach file. Error number from Win32 System Service is %d.");
		add(11534 , 20 , "Invalid parameter '%s' received. Check user documentation and re-enter command.");
		add(11535 , 20 , "The data type of parameter %s is invalid. Check user documentation and re-enter command.");
		add(11536 , 20 , "The combination of input parameters %s is invalid. Check user documentation and re-enter command.");
		add(11537 , 20 , "The value of parameter %s is invalid. Check user documentation for correct value.");
		add(11538 , 20 , "The result set obtained by executing the supplied query is invalid. Review the text of query batch and re-enter command.");
		add(11539 , 20 , "Failed to get thread property in %s. Please contact SAP Technical Support.");
		add(11540 , 20 , "Failed to obtain lock in function %s. Please contact SAP Technical Support.");
		add(11541 , 20 , "Failed to unlock mutex in function %s. Please contact SAP Technical Support.");
		add(11542 , 20 , "Invalid mail profile name received. Check 'MailUserName' configuration parameter value for ASE login 'sybmail'.");
		add(11543 , 20 , "The operation type passed to %s is invalid.");
		add(11544 , 20 , "There was an internal error during processing. Please refer to XP Server log file for more information.");
		add(11545 , 20 , "The result set type '%d' obtained by executing the supplied query was invalid.");
		add(11546 , 20 , "The parameter '%s' is not an output parameter.");
		add(11547 , 20 , "The required parameter '%s' is missing. Check user documentation and re-enter command.");
		add(11548 , 20 , "Invalid event log computer name length (-l). XP Server shutting down.");
		add(11549 , 20 , "Failed to access include file %s. Error number from file access call is %d.");
		add(11550 , 20 , "Failed to start mail session. To use default parameter values for xp_startmail, add the 'sybmail' user account and configure 'start mail session' configuration parameter.");
		add(11552 , 16 , "failed to acquire mutex for xpserver dll manager");
		add(11553 , 10 , "Unable to set xp server locale, translation of extended characters may fail");
		add(11554 , 10 , "The function sybesp_dll_version(), which returns the Open Server API version of the DLL, is missing in the loaded DLL '%s'. So, XP Server will not attempt to do version matching but will continue to work with it.");
		add(11555 , 10 , "Open Server API version of the XP Server does not match with that of the loaded DLL '%s'. API version of XP Server = %d, API version of DLL = %d. However, XP Server will continue to work with this loaded DLL.");
		add(11556 , 20 , "internal xpserver error - cannot get socket endpoint");
		add(11557 , 20 , "failed to create mutex for site handler connection");
		add(11558 , 20 , "Failed to setup encryption key. XP Server is shutting down. This is an internal error. Please contact SAP Technical Support.");
		add(11601 , 18 , "Instance does not have any data pointers for counters. Restart ASE. If problem persists, contact SAP Technical Support.");
		add(11602 , 18 , "Failed to open file mapping in DLL to attach to ASE shared memory. ASE may not be running or the machine is low on disk space. Otherwise, contact SAP Technical Support.");
		add(11603 , 18 , "Failed to MapViewOfFile of ASE shared memory file mapping. ASE may not be running or the machine is low on disk space. Otherwise, contact SAP Technical Support.");
		add(11604 , 20 , "Failed during signature verification of SYBPERF_ENV memory block of ASE. Restart ASE. If problem persists, contact SAP Technical Support.");
		add(11605 , 20 , "Cannot allocate any more SYBPERF_COMPLEX_DEFs, array too small. Too many ASE counter objects, counters, and instances. NT Performance Monitor will not monitor this ASE. Please reduce number of counter objects, counters, instances.");
		add(11606 , 20 , "The performance monitor component of ASE is not initialized correctly.");
		add(11607 , 10 , "NT Performance Monitor has started monitoring ASE.");
		add(11608 , 10 , "Monitor Group %s not found.");
		add(11609 , 10 , "Monitor Counter %s not found.");
		add(11610 , 10 , "SYBPERF_OBJECT_TYPE %s not found.");
		add(11611 , 10 , "No ASE is running with perform.exe integration; therefore, there is nothing to monitor.");
		add(11612 , 10 , "%s.");
		add(11613 , 20 , "The Sybperf DLL encountered a fatal exception when processing a %s request from the Windows NT performance monitoring subsystem. The exception code was 0x%X.");
		add(11701 , 15 , "CREATE for extended stored routine cannot contain statements after EXTERNAL statement.");
		add(11704 , 16 , "The specified option '%.*s' is not valid for this command. The option is valid for the LOAD TRANSACTION command.");
		add(11706 , 16 , "Time value '%.*s' in the %s UNTIL_TIME clause is not a legal value.");
		add(11707 , 16 , "Incorrect time syntax in time string '%.*s' used in the %s UNTIL_TIME statement. Correct format is month day, year hour:minute:seconds:milliseconds[am | pm]");
		add(11710 , 16 , "Subqueries are not allowed in a DEFAULT clause.");
		add(11711 , 16 , "The REORG option '%.*s' requires a value greater than 0 to be specified.");
		add(11712 , 16 , "You cannot specify a value with the REORG option '%.*s'.");
		add(11713 , 16 , "Index name is not allowed in UPDATE PARTITION STATISTICS statement. Use partition number instead.");
		add(11714 , 16 , "Partition number is not allowed in UPDATE STATISTICS statement. Use index name instead.");
		add(11715 , 16 , "Command failed: UPDATE ALL STATISTICS does not accept options.");
		add(11717 , 16 , "The quoted identifier '%.*s' is illegal because its first character is '#', which is ambiguous. Please use another character instead.");
		add(11718 , 16 , "%d is not a valid partition number. Partition number must be greater than 0.");
		add(11719 , 16 , "Error converting %d to IDENTITY_START value.");
		add(11720 , 16 , "%.*s' is not a REORG subcommand. The valid REORG subcommands are: REBUILD, FORWARDED_ROWS, RECLAIM_SPACE, COMPACT and DEFRAG.");
		add(11721 , 16 , "Global variables not allowed as defaults.");
		add(11722 , 15 , "The READPAST and HOLDLOCK object level locking options are incompatible.");
		add(11723 , 15 , "READPAST conflicts with AT ISOLATION LEVEL 3.");
		add(11724 , 15 , "Target variable '%.*s' may not appear in both the SET and WHERE clauses of the UPDATE statement, nor in any subquery of the SET clause.");
		add(11725 , 15 , "All result expressions in a CASE expression must not be NULL.");
		add(11726 , 15 , "A single coalesce element is illegal in a COALESCE expression.");
		add(11728 , 15 , "SELECT INTO cannot be used in an INSERT statement to pull values from tables.");
		add(11729 , 15 , "The name '%.*s' is not a valid local variable name.");
		add(11730 , 15 , "The PROXY option cannot be used in conjunction with other options in a SET command.");
		add(11731 , 15 , "Duplicate option has been specified to '%s' command. One or many options have been repeated.");
		add(11732 , 10 , "Warning : Ambiguous correlation names in the set clause");
		add(11733 , 10 , "Warning : Ambiguous table to update; Using the table specified in the update clause.");
		add(11734 , 16 , "The quoted identifier '%.*s' is illegal because it contains an embedded period followed by an embedded double quote. Please substitute another character in place of one of these characters.");
		add(11735 , 15 , "You specified an invalid password option.");
		add(11736 , 16 , "line %d: You cannot specify this command in an 'execute immediate' context.");
		add(11737 , 16 , "You cannot specify outer joins in the HAVING clause of a query.");
		add(11738 , 16 , "Name '%.*s' is reserved for internal use by Adaptive Server. Please use a different name.");
		add(11739 , 15 , "The value specified for identity gap '%d' is not legal; identity gap must be greater than 0.");
		add(11740 , 16 , "You cannot use the GRANTED BY option to GRANT or REVOKE predicated privileges.");
		add(11741 , 15 , "Identity gap can be specified only for tables which have identity columns.");
		add(11742 , 15 , "language java' and 'parameter style java' clauses must be specified when creating sqlj procedure/function.");
		add(11743 , 15 , "CREATE for extended stored routine cannot contain statement '%s'; it can only contain 1 EXTERNAL statement.");
		add(11745 , 16 , "Function name '%.*s' is reserved for a T-SQL builtin function. Please use a different name.");
		add(11746 , 16 , "Unable to create access rule. Please make sure the row level access option 'enable row level access' is enabled.");
		add(11747 , 16 , "Java method '%s' has too many parameters. The maximum number is %d.");
		add(11748 , 16 , "There are too many aggregates in the COMPUTE clause. The maximum number is %d.");
		add(11749 , 15 , "%s must be the only statement in a query batch.");
		add(11751 , 15 , "The column '%.*s' in the outer query is not present in the derived table expression.");
		add(11753 , 15 , "The derived table expression is missing a correlation name. Check derived table syntax in the Reference Manual.");
		add(11754 , 16 , "Subqueries are not allowed in a COMPUTED COLUMN definition.");
		add(11755 , 16 , "Local variables and parameters are not allowed in a COMPUTED COLUMN definition.");
		add(11756 , 15 , "The column '%.*s' in the derived column list is specified more than once.");
		add(11757 , 16 , "You cannot currently create a temporary database; the multiple tempdb feature is disabled.");
		add(11758 , 16 , "The external name clause in SQLJ function or procedure '%s' exceeds the maximum length of 16383 characters.");
		add(11759 , 16 , "Number of partition keys exceeds the %d limit.");
		add(11760 , 16 , "Built-in function '%.*s' is not grantable.");
		add(11761 , 16 , "SET STATEMENT_CACHE ON can only be executed when the ASE configuration option 'statement cache size' is greater than 0.");
		add(11762 , 16 , "You cannot use a derived table in the FROM clause of an UPDATE or DELETE statement.");
		add(11763 , 16 , "Command failed: UPDATE INDEX STATISTICS does not accept a column list.");
		add(11765 , 16 , "Virtual computed column (%.*s) cannot have any constraints.");
		add(11766 , 16 , "Computed column (%.*s) cannot have NULL/NOT NULL constraint.");
		add(11767 , 15 , "UPDATE PARTITION STATISTICS is no longer supported, the equivalent of this command is: UPDATE TABLE STATISTICS <table name> <optional partition name>.");
		add(11768 , 16 , "Index name is not allowed in UPDATE STATISTICS statement when a data partition name is specified.");
		add(11769 , 16 , "UPDATE TABLE STATISTICS does not accept options other than the data partition name.");
		add(11770 , 16 , "UPDATE TABLE STATISTICS does not accept database names.");
		add(11771 , 16 , "Default is not allowed for computed column (%.*s).");
		add(11772 , 16 , "Computed column (%.*s) cannot be an identity column.");
		add(11773 , 16 , "You have specified an invalid value %d as the optimization timeout limit. You can only specify an integer value from 0 to 4000.");
		add(11774 , 16 , "Command failed: Specify keylength for keyvalue option in %s statement.");
		add(11775 , 16 , "Cannot grant %s permission. Verify that the encrypted columns option is enabled.");
		add(11776 , 16 , "A column with the IDENTITY property may not be encrypted.");
		add(11777 , 16 , "Statement with location clause must be the only statement in a query batch.");
		add(11780 , 15 , "At least one of the options specified cannot be set to default.");
		add(11781 , 16 , "Encrypted column definition is not allowed in create table/existing table syntax in statements with AT location clause.");
		add(11782 , 10 , "The maximum number of reported syntax errors for this statement has been reached. No further errors will be reported.");
		add(11783 , 16 , "Number of list partition values per partition exceeds the %d limit.");
		add(11784 , 16 , "Must specify a value for the FETCH offset.");
		add(11785 , 10 , "Warning: Control characters after keyword '%.*s' at line %d are truncated. Maximum number of control characters allowed is : %d.");
		add(11786 , 16 , "Too long string literal.");
		add(11788 , 15 , "Command failed: UPDATE PARTITION STATISTICS does not accept the USING option.");
		add(11789 , 15 , "Command failed: UPDATE PARTITION STATISTICS does not accept the WITH option.");
		add(11790 , 15 , "%s cannot use a procedure name with '*' as the first character in the name.");
		add(11791 , 16 , "SET LITERAL_AUTOPARAM ON can only be executed when the ASE configuration option 'enable literal autoparam' is set to 1.");
		add(11792 , 15 , "You need to specify the instance name if creating a local system temporary database.");
		add(11793 , 16 , "Invalid parameter %d for %s builtin function.");
		add(11794 , 16 , "Can't use the OUTPUT option with CREATE SERVICE.");
		add(11795 , 16 , "The column '%.*s' in the XMLTABLE column definition is specified more than once.");
		add(11796 , 10 , "%S_MSG");
		add(11797 , 10 , "%.*s");
		add(11798 , 16 , "Illegal %s statement within a scalar SQL function.");
		add(11799 , 16 , "Illegal return type for a scalar SQL function.");
		add(11901 , 16 , "Table '%.*s' was not found.");
		add(11902 , 16 , "'%.*s' is not a table.");
		add(11903 , 16 , "You cannot run REORG on a table which uses allpages locking.");
		add(11904 , 16 , "You cannot specify an index with this REORG subcommand. Only the RECLAIM_SPACE subcommand can be run on an index.");
		add(11906 , 16 , "You cannot use the RESUME, TIME, or COMPRESS options with REBUILD.");
		add(11910 , 16 , "Index '%.*s' was not found.");
		add(11911 , 10 , "Using time limit of %d minutes.");
		add(11913 , 10 , "Warning: The RESUME option was specified, but no valid restart point was found. Starting from beginning of object.");
		add(11915 , 10 , "There are approximately %d pages to be processed.");
		add(11916 , 10 , "%d pages have been processed.");
		add(11917 , 16 , "REORG REBUILD of systabstats is not allowed.");
		add(11918 , 16 , "You cannot run REORG REBUILD on '%.*s' because there are one or more isolation level 0 scans active on the table.");
		add(11919 , 16 , "You cannot run REORG REBUILD in this database because the 'select into/bulkcopy' option is off. Please check with the DBO.");
		add(11920 , 10 , "Beginning REORG %s of '%.*s' partition '%.*s'.");
		add(11921 , 10 , "Beginning REORG RECLAIM_SPACE of index '%.*s' on table '%.*s' partition '%.*s'.");
		add(11922 , 10 , "Resuming REORG %s of '%.*s' partition '%.*s'.");
		add(11923 , 10 , "Resuming REORG RECLAIM_SPACE of index '%.*s' on table '%.*s' partition '%.*s'.");
		add(11924 , 10 , "REORG %s of '%.*s' partition '%.*s' completed.");
		add(11925 , 10 , "REORG RECLAIM_SPACE of index '%.*s' on table '%.*s' partition '%.*s' completed.");
		add(11926 , 10 , "REORG %s of '%.*s' terminated due to error or user interrupt.");
		add(11927 , 10 , "REORG RECLAIM_SPACE of index '%.*s' on table '%.*s' terminated due to error or user interrupt.");
		add(11928 , 16 , "Rebuild of index '%.*s' failed because the index is marked suspect.");
		add(11929 , 16 , "Reorg cannot be run on proxy table '%.*s'.");
		add(11930 , 16 , "Index partition '%.*s' was not found for specified index '%.*s'.");
		add(11931 , 16 , "Partition '%.*s' of table '%.*s' was not found.");
		add(11932 , 10 , "Beginning REORG REBUILD of table '%.*s'.");
		add(11933 , 10 , "REORG REBUILD of table '%.*s' completed.");
		add(11934 , 16 , "REORG %s of table '%.*s' failed due to an internal error. Please contact SAP Technical Support.");
		add(11935 , 16 , "You cannot run REORG REBUILD on a single data partition; re-run the command on the entire table.");
		add(11936 , 10 , "Warning: REORG with COMPRESS compresses rows in a compressed table; it does not compress ordinary tables.");
		add(11937 , 10 , "You cannot run REORG %s on '%.*s' as it is a deferred table that has not been allocated any space.");
		add(11938 , 10 , "%s of '%.*s' reached the time limit of %d minutes while processing partition '%.*s'.");
		add(11939 , 16 , "%s on '%.*s' failed. The table should have atleast one index.");
		add(11940 , 10 , "%s of '%.*s' has skipped %d extents in partition '%.*s', using threshold of compactness as %d percent.");
		add(11941 , 10 , "Examined %u allocation unit(s). Processed %u pages out of %u data pages. %d%% completed, resulting in %d%% space compaction.");
		add(11942 , 10 , "Elapsed time %s.");
		add(11943 , 10 , "Resuming from the beginning of the partition '%.*s' of table '%.*s' as it has already been marked fully defragmented.");
		add(12001 , 16 , "Unable to find entry for class: %d, attribute: %d, value: %d.");
		add(12003 , 16 , "Unable to allocate shared memory dump condition. All conditions (%d) already allocated.");
		add(12004 , 16 , "Empty shared memory dump condition list head passed.");
		add(12005 , 16 , "Cannot free shared memory dump condition. Entry 0x%x not found.");
		add(12006 , 16 , "An entry already exists for class: %d, attribute: %d, value: %d.");
		add(12007 , 16 , "Cannot set shared memory dump condition. An invalid attribute value was recevied: %d.");
		add(12008 , 16 , "Directory name too long. The maximum directory length is %d characters.");
		add(12009 , 16 , "File name too long. The maximum length is %d characters.");
		add(12010 , 16 , "Unable to set shared memory dump condition. Invalid record type: %d.");
		add(12011 , 16 , "Configuration of shared memory dump conditions is not available on this platform.");
		add(12013 , 16 , "Function '%s' expected %d parameters but received only %d. Retry the function with at least the expected number of parameters.");
		add(12014 , 16 , "Parameter %d of function %s is too long. Maximum length is %d characters. Retry the function with a shorter parameter.");
		add(12015 , 16 , "Unknown function %s. Check spelling of the function name.");
		add(12016 , 16 , "CAPs configuration table rebuild may be required: %s '%s' is missing from %s '%s'.");
		add(12017 , 16 , "CCB '%s', CAP '%s': Unknown CAP name. Check spelling.");
		add(12018 , 18 , "Not enough memory to %s %s '%s'.");
		add(12019 , 16 , "CCB '%s', profile '%s', CAP '%s': Too many actions. Only the first %d actions will be configured.");
		add(12020 , 16 , "CAP '%s' in CCB '%s' not configured because %s.");
		add(12021 , 18 , "Configuration of CCBs from tables in database '%s' aborted.");
		add(12022 , 18 , "Failed to lock %s '%s'.");
		add(12023 , 16 , "CCB '%s' not configured because %s.");
		add(12024 , 16 , "CCB '%s' cannot be found because %s.");
		add(12025 , 16 , "CAPs configuration table rebuild may be required: %s '%s' is missing.");
		add(12026 , 16 , "CCB '%s' CAP '%s' not activated because %s.");
		add(12027 , 16 , "CCB '%s' CAP '%s' not destroyed because %s.");
		add(12028 , 16 , "CCB '%s' CAP '%s' not deactivated because %s.");
		add(12029 , 16 , "CCB '%s' not destroyed because %s.");
		add(12030 , 16 , "The CAPs facility is not active. Set the configuration parameter number of ccbs to 1 or more.");
		add(12031 , 16 , "The CAPs facility is not active. See the error log for details.");
		add(12032 , 16 , "Capslib detected error: %s.");
		add(12033 , 16 , "Object can not be described because: %s.");
		add(12034 , 17 , "Collection of monitoring data for table '%.*s' failed due to insufficient memory. Retry when there is less load, or fewer users, on the server. %u rows were not returned because %u bytes of memory could not be allocated.");
		add(12035 , 16 , "Failed to return a row for the '%.*s' monitoring table.");
		add(12036 , 17 , "Incomplete configuration on instance ID %d. Collection of monitoring data for table '%.*s' requires that the %s configuration option(s) be enabled. To set the necessary configuration, contact a user who has the System Administrator (SA) role.");
		add(12037 , 10 , "%s is not a valid shared memory dump condition type.");
		add(12038 , 10 , "No shared memory dump condition was found for condition type %s and value %d.");
		add(12039 , 10 , "The %.*s command cannot be used because the 'enable monitoring' configuration option is not enabled.");
		add(12040 , 10 , "%.*s is not a valid parameter for the %.*s command.");
		add(12041 , 10 , "%.*s is not a valid command for the mdaconfig built-in function.");
		add(12042 , 10 , "The %.*s command requires an additional parameter.");
		add(12043 , 10 , "The monitoring table counters are already frozen. The freeze operation was not necessary and was not performed.");
		add(12044 , 10 , "The monitoring table counters are not frozen. The 'end' option is not valid at this time. No further action is needed.");
		add(12048 , 16 , "Cannot set shared memory dump configuration. An invalid object value was received: %d.");
		add(12049 , 16 , "The monitoring table %.*s works only in the DEBUG server.");
		add(12050 , 17 , "Allocation of %d bytes for the hash table for a query on the %.*s table failed. The query will be executed without using a hash table but the query may run slowly.");
		add(12051 , 10 , "Due to concurrent activity, the query on table '%.*s' cannot be completed, and your results are missing some rows. Re-run the query.");
		add(12052 , 17 , "Collection of monitoring data for table '%.*s' requires that the %s configuration option(s) be enabled. To set the necessary configuration, contact a user who has the System Administrator (SA) role.");
		add(12053 , 16 , "The input value of %s is not a valid percentage, This value should be between 0 and 100.");
		add(12054 , 18 , "Failed to open %s message file for MDA tables.");
		add(12055 , 16 , "System call %s failed with error %d.");
		add(12056 , 16 , "Unable to obtain space usage information for device '%s'. '%s' doesn't contain a Microsoft reparse tag. Failed to resolve it.");
		add(12057 , 18 , "Failed to get Unilib handle for MDA localization. English will be used for MDA tables.");
		add(12058 , 10 , "Failed to find some messages from %s message file. English will be used.");
		add(12059 , 10 , "Some character(s) could not be converted into server's character set. Unconverted bytes were changed to question marks ('?').");
		add(12060 , 17 , "Cache Error! Please increase 'size of unilib cache', and try again.");
		add(12061 , 16 , "%s is unsupported language for MDA localization!");
		add(12062 , 10 , "The execution category stack for spid %d has overflowed. Stack level: %d. OperationID: %d");
		add(12063 , 10 , "The process' category stack is underflow. SPID: %d. OperationID: %d");
		add(12064 , 17 , "Monitoring data is incomplete because the monitored resource actively changed its configuration while we were gathering data. Try the command again.");
		add(12100 , 16 , "Cannot execute a LOCK TABLE command on table '%.*s', because this table does not exist.");
		add(12101 , 16 , "The object '%.*s' you've specified is not a user table. Executing the LOCK TABLE command is only permitted on user tables.");
		add(12102 , 16 , "The table '%.*s' you've specified is a temporary table. Executing the LOCK TABLE command is not permitted on temporary tables.");
		add(12103 , 10 , "Table '%.*s' in database '%.*s' was not locked in '%.*s' mode because a covering lock in '%.*s' mode was found.");
		add(12104 , 16 , "A LOCK TABLE command is not allowed outside the scope of a transaction on table '%.*s' in the database '%.*s'.");
		add(12106 , 16 , "Invalid parameter in LOCK TABLE syntax: '%.*s'.");
		add(12201 , 20 , "Lock found in lock cache not on global lock chain: dbid %d, objid %d, locktype %d, sufficiency class %d");
		add(12202 , 10 , "Could not initiate lock wait checking because Adaptive Server has run out of alarms. If your application uses this feature, try rebooting the server.");
		add(12203 , 18 , "Lock cache entry not found for spid %d, lock 0x%x, type %d, suff class %d. Please notify your system administrator.");
		add(12204 , 18 , "Attempted to redo deadlock search as a result of a lock upgrade. Found too many SH_NKL lockrecs. Please contact SAP Technical Support.");
		add(12205 , 17 , "Could not acquire a lock within the specified wait period. %s level wait period=%d seconds, spid=%d, lock type=%s, dbid=%d, objid=%d, pageno=%d, rowno=%d. Aborting the transaction.");
		add(12206 , 20 , "Internal Error in lock manager routine: Attempted lock anti-inheritance when the parents sdes chain does not include the dbid and objid corresponding to the child thread which are dbid=%d and objid=%d.");
		add(12207 , 10 , "Could not acquire a lock within the specified wait period. %s level wait period=%d seconds, spid=%d, lock type=%s, dbid=%d, objid=%d, pageno=%u, rowno=%d.");
		add(12208 , 20 , "Cannot run SELECT FOR UPDATE outside a transaction context for objid %ld, dbid %d, locktype %d, spid %d.");
		add(12209 , 18 , "Internal Error: Process %d attempted to get an exclusive lock on %s while holding an incompatible lock. This request has been ignored to avoid this process blocking itself.");
		add(12210 , 18 , "Internal Error: Process ID %d attempted to release a lock on %s that it was not holding.");
		add(12211 , 20 , "Row/Page lock request made without holding partition level lock. spid=%d, locktype=%d, dbid=%d, objid=%d, ptnid=%d, pageno=%u, rowno=%d.");
		add(12212 , 20 , "Internal Error: The partition ID (%d) of the lock does not match the partition ID (%d) of the new request on this lock. dbid=%d, objid=%d, pageno=%u, rowno=%d locktype=%d");
		add(12213 , 17 , "Resource Governor lock count limit (%d) exceeded");
		add(12300 , 20 , "Internal error: in table '%.*s', database %d, the forwarded row (%d, %d) pointed to by (%d, %d) is invalid. Aborting the transaction.");
		add(12301 , 20 , "Internal error: the index (id = %d) and the data for row (%d, %d) in table '%.*s', database %d are inconsistent; data is marked deleted but index is not. Aborting the transaction.");
		add(12302 , 20 , "Internal error: deleted row (%d, %d) erroneously qualified for table '%.*s', database %d. Terminating the scan.");
		add(12303 , 20 , "Internal error: invalid scan branch type. Aborting the transaction.");
		add(12304 , 10 , "Index id %d cannot be used to access table id %d as it is SUSPECT. Please drop and re-create the index. Table-scan is being used instead.");
		add(12306 , 26 , "No table lock on object '%.*s' in database '%.*s'.");
		add(12307 , 26 , "Row %d of page %u in table '%.*s' (id = %d) in dbid %d is not locked.");
		add(12308 , 21 , "Internal error : Invalid row id (Row %d, Page %u) encountered in the table '%.*s' in database '%.*s'.");
		add(12309 , 21 , "Expanding update on object '%.*s' in database '%.*s' cannot succeed on page %u, because the contiguous_free_bytes of %d is less than the difference of %d between new rowlen and old rowlen. This is an internal error.");
		add(12310 , 21 , "Internal error: split or shrink propagation failed to commit after changing the page %u of index id %d of table '%S_OBJID' (id = %d) in database '%S_DBID'. Xactid is (%u,%d). Drop and re-create the index.");
		add(12311 , 20 , "Internal error: address lock request on page %u of index id %d of table '%S_OBJID' (id = %d) in database '%S_DBID' failed with status %d. No need to drop the index.");
		add(12312 , 20 , "Index with id %d of table '%S_OBJID' (id = %d) in database '%S_DBID' is already at the maximum allowed height. It cannot grow any further. Try dropping and recreating the index.");
		add(12313 , 21 , "Internal error: Insert into page id %u of index id %d of table '%S_OBJID' (id = %d) in database '%S_DBID' tried to replace undeleted RID (%u,%d) at slot %d and ridposn %d. Try dropping and recreating the index.");
		add(12314 , 21 , "Bad child page pointer found on page %u of index with id %d of table '%.*s' in database '%.*s'. Expected child page pointer to be %u but found %u. Check if the index is consistant using DBCC.");
		add(12315 , 21 , "Corrupt page, Internal error: Mismatch between tail timestamp '%04x' and the low two bytes of timestamp in the page header '%04x' while accessing page '%u' of object '%d' in database '%d'. Please contact SAP Technical Support.");
		add(12316 , 20 , "Internal error: Attempt to garbage collect a deallocated data page %u in table '%.*s', database '%.*s'. Aborting the transaction.");
		add(12317 , 20 , "Internal error: Insert of a key of size %d into page %u of index id %d of table '%S_OBJID' (id = %d) in database '%S_DBID' failed because page has freespace of size %d. Try again or drop and recreate the index.");
		add(12318 , 20 , "Fatal internal error ecountered during scan on the index with id %d on table '%.*s' in database '%.*s'. Isolation level is %d. Scan status is %d. Current index scan page is %d. Please contact SAP Technical Support.");
		add(12319 , 20 , "Fatal internal error encountered during deferred dml on table '%.*s' in database '%.*s'. All rows that qualified during the first phase were not visited during second phase of dml.");
		add(12320 , 21 , "Fatal internal error encountered when forwarding row (%d, %d) in table '%.*s', database '%.*s' during update. Aborting the transaction.");
		add(12321 , 20 , "Internal error: No split point found for page %u of index %d of object %d. Old page : %d entries, free space = %d. Split point information : <(%d), (%d), (%d, %d, %d)>.");
		add(12322 , 21 , "Row %d on DOL datapage %d in database '%.*s' has size %d and an invalid holesize %d. Page is corrupted.");
		add(12323 , 20 , "Internal error occured during rebuild of index id %d of table '%S_OBJID' (id = %d) in database '%S_DBID' while processing page %u. Run dbcc checktable to see if the index is consistent.");
		add(12324 , 21 , "In database '%S_DBID', the server failed to open required table '%.*s'. Please contact SAP Technical Support.");
		add(12325 , 10 , "The 'optimistic_index_lock' property should not be enabled for table '%.*s' in database '%.*s'. Please turn this property off on the table using the 'sp_chgattribute' stored procedure.");
		add(12326 , 21 , "Table Corrupt: Free offset in page header is not reasonable; free offset should be >= %d and <= %d; check this page and offset (page#=%u freeoffset on the page header=%d).");
		add(12327 , 16 , "Could not find index partition for index '%d' associated with data partition '%d' of object '%d' in database dbid '%d'.");
		add(12328 , 21 , "The calculated row offset '%d' of an index key on page '%u' for object '%d' in database '%d' is out of bounds (table offset on page = '%d', page status = '%d', local offset table address = 0x%p).");
		add(12329 , 20 , "An attempt was made to fetch logical page '%u' for %S_PTNINFO. However, page belongs to a different partition (indid '%d' partitionid '%d') of the same object. This indicates an ASE internal error and does not indicate data corruption.");
		add(12330 , 20 , "An attempt was made to fetch logical page '%u' with partition ID '%d', index ID '%d' from %S_PTNINFO. No partition with ID '%d' was found in this object. This indicates an ASE internal error and does not indicate data corruption.");
		add(12331 , 16 , "Open table failed, couldn't find an available varno to use.");
		add(12332 , 16 , "Table ID %d contains suspect partitions. This table is only available for read-only purposes until the REORG REBUILD or Repartition (ALTER TABLE PARTITION BY) command has been run on the indicated table to repair the partitions.");
		add(12333 , 20 , "A global index '%S_INDINFO' is in suspect state. Please drop and re-create the index.");
		add(12334 , 21 , "Attempts to read logical page '%u', virtpage '%d' from virtual device '%d' for %S_PTNINFO failed due to read failure in prefetch. Please contact SAP Technical Support.");
		add(12335 , 21 , "An attempt was made to read logical page '%u' for object '%d' in database '%d'. The page was not read successfully because of repeated failures to acquire the page using asynchronous prefetch.");
		add(12336 , 16 , "Definition time object '%S_OBJINFO' found at run time as an attempt to drop the table had failed in a previous query. Please drop the above mentioned table using the DROP TABLE command.");
		add(12337 , 21 , "Page '%u' in database '%.*s' was incorrectly found to be uninitialized when it was read. Recovery of this database cannot continue.");
		add(12338 , 21 , "Internal Error: The page pointer %p in the header of buffer %p and page pointer %p in device map for cache '%.*s' (ID %d) do not match for requested page %d. The page was accessed for %S_PTNINFO.");
		add(12339 , 21 , "The in-memory address of logical page %u cannot be determined.");
		add(12340 , 21 , "Cannot find the cache for page %u in database %S_DBID.");
		add(12341 , 10 , "This message is free.");
		add(12342 , 10 , "You cannot release a lock when there are no locks held. This is an internal error. Please contact technical support.");
		add(12343 , 20 , "Cannot serialize the transaction for the scan on table '%.*s' in database '%.*s', as a phantom row has been inserted in the result set, or some changes have occurred to the rows in the result set since the start of the transaction.");
		add(12344 , 20 , "Internal Error: Process %d attempted to get a database disk map lock while holding %d already. A process can hold a maximum of %d disk map locks.");
		add(12345 , 20 , "Internal Error: Process %d attempted to get an exclusive database disk map lock while holding an incompatible disk map lock. This request has been ignored to avoid this process blocking itself.");
		add(12346 , 20 , "Internal Error: Process ID %d attempted to release a database disk map lock that it was not holding.");
		add(12347 , 18 , "Table id %d in database id %d is in table suspect status after shrink failed. This table is not accessible until DBCC DBREPAIR command has been run on the database to fix the possible table corruption.");
		add(12348 , 26 , "No partition lock on partition '%.*s' in object '%.*s' in database '%.*s'.");
		add(12349 , 10 , "Warning: Some residual data in page %d of database id %d was not erased, due to an internal error. See the error log for more information, and contact Product Support.");
		add(12350 , 10 , "Warning: Some residual data in device %d of database %d was not erased, due to an internal error.");
		add(12351 , 16 , "The table SYSDAMS could not be opened in database '%.*s'. Execute DBCC DAM(%.*s, 'create') and if the problem continues contact SAP product support.");
		add(12352 , 10 , "A transaction in database '%.*s' (spid=%d) has hit a fatal error during rollback. ASE will try to reboot and recover the database. The XREC_BEGINXACT of this failing transaction is (%u, %d).");
		add(12353 , 20 , "Failed to find the required version of row with RID = %S_RID in '%s' for dbid = %d, partition id = %d, object id = %d.");
		add(12354 , 20 , "Failed to find previous node of hash node 0x%p (hashcode = %u, RID = (%u, %d), bucket = %u) for partition %d of index %d of table '%S_OBJID' with ID %d in database '%S_DBID'.");
		add(12355 , 18 , "Encountered %d failure(s) in this partition.");
		add(12356 , 16 , "%s failed as required temporary database '%s' or row storage cache '%s' is not present or is already in use by some other database.");
		add(12357 , 16 , "Command aborted because the configuration option 'snapshot isolation timeout' is set to '%d' seconds, and the command execution is idle since '%d' seconds.");
		add(12400 , 20 , "Adaptive Server internal error: invalid input %d to syscoordinations manager.");
		add(12401 , 16 , "Microsecond datepart is not valid with type '%s'.");
		add(12402 , 21 , "Failed to recover %s log record (%u,%d), for transaction (%u,%d) in sysimrslogs for database '%.*s' (%d), possibly due to insufficient memory in the cache '%.*s' or an internal recovery error at file '%s', line %d.");
		add(12403 , 21 , "Failed to recover transaction (%u,%d) in sysimrslogs for database '%.*s' (%d) due to insufficient memory in the cache '%.*s'.");
		add(12404 , 21 , "Failed to create the invalid block table for database '%.*s' (%d).");
		add(12405 , 21 , "Failed to insert an invalid block entry for transaction with boundaries (%u, %d) and (%u, %d) while recovering database '%.*s' (%d).");
		add(12406 , 21 , "Failed to find the last row marker for transaction (%u,%d) in sysimrslogs for database '%.*s' (%d). The sysimrslogs row is corrupted.");
		add(12504 , 10 , "Timestamp mismatch error was not generated on page because page is marked for deallocation. Page #=%u, object id = %d, page timestamp=%04x %08x. Log old timestamp=%04x %08x.");
		add(12505 , 18 , "Could not open table '%d' in database '%d' by ID");
		add(12511 , 20 , "During recovery, quiescent last log marker was not found for database '%.*s'. The backward log scan was started on marker (%d, %d).");
		add(12512 , 16 , "Database '%.*s' (dbid %d): has incomplete transactions. ONLINE DATABASE FOR STANDBY_ACCESS cannot be completed successfully.");
		add(12513 , 10 , "Failed to delete the user specified recovery order for the dropped database '%.*s'. Inform system administrator. During next bootup of server, this may turn off user specified recovery order.");
		add(12514 , 10 , "The read of user-defined database recovery orders failed. To fix, remove all the user defined recovery orders and reinstall them using sp_dbrecovery_order.");
		add(12516 , 21 , "During undo processing a CLR could not be logged. The internal error number is %d.");
		add(12517 , 16 , "During transaction rollback a CLR could not be logged. The internal error number is %d.This process will retry at intervals of one minute.");
		add(12518 , 20 , "Attempt to get an uninitialized page %u in database id %d during %s.");
		add(12520 , 18 , "Recovery was unable to insert into the syscoordinations table. Please consult the Adaptive Server errorlog for further information as to the cause. Please contact a user with System Administrator (SA) role.");
		add(12521 , 18 , "Recovery was unable to delete from the syscoordinations table. Please consult the Adaptive Server errorlog for further information as to the cause. Please cont act a user with System Administrator (SA) role");
		add(12522 , 18 , "Recovery was unable to update syscoordinations table. Please consult the Adaptive Server errorlog for further information as to the cause. Please contact a user with System Administrator (SA) role");
		add(12523 , 21 , "The last log page number cannot be recovered following an instance failure for database '%.*s' (%d).");
		add(12528 , 18 , "The pre-%s log for database '%.*s' includes a CREATE INDEX incompatible with this server version and operating environment. Only transactions completed before CREATE INDEX will be recovered.");
		add(12530 , 16 , "Database '%.*s' was dumped on a version of Adaptive Server other than the current version, and cannot be brought online in standby access mode. Use the ONLINE DATABASE command without any options.");
		add(12531 , 16 , "Cannot recover from log record %s at %S_RID affecting page %u in '%S_DBID'. Reapply the log records using an earlier (pre-12.0) version of Adaptive Server, or contact SAP Technical Support for assistance.");
		add(12534 , 10 , "During online of database '%.*s' an invalid cross-database reference with constraint id %d was found in the 'sysreferences' system catalog. The referencing and referenced database ids are %d and %d respectively.");
		add(12535 , 18 , "Post-processing for system catalog '%.*s' could not be completed during online of database '%.*s'.");
		add(12536 , 16 , "Sysstatistics upgrade warning for table '%S_OBJID'. New row-length after upgrade, %d, (sequence no %d, format ID %d, column ID %d, %d columns) exceeds maximum limit of %d. Run update statistics on this table after upgrade.");
		add(12537 , 10 , "Database '%.*s' is a copy taken under a QUIESCE/PREPARE DATABASE command. It will be recovered as for LOAD DATABASE and left offline.");
		add(12538 , 10 , "Database '%.*s' is a copy taken under a QUIESCE/PREPARE DATABASE command, but the server is not booted with the '-q' flag. The database state will be ignored, and it will be recovered and brought online normally.");
		add(12539 , 10 , "Database '%.*s' is a system database. Its QUIESCE/PREPARE DATABASE state will be ignored, and the database will be recovered and brought online normally.");
		add(12540 , 10 , "Modified timestamp on page %u of (%d, %d) which falls between log old ts (%d, %d) and log new ts (%d, %d) during recovery of database id %d.");
		add(12541 , 10 , "Modified timestamp on page %u of (%d,%d) which is older than log old ts (%d, %d) during recovery of database id %d.");
		add(12542 , 16 , "Load the next transaction log in the load sequence, or use ONLINE DATABASE with no options to end the load sequence.");
		add(12543 , 20 , "During recovery, quiescent first log marker was not found for database '%.*s'. The forward log scan was started on marker (%d, %d).");
		add(12544 , 0  , "Not recovering temporary database (dbid = %d) since model has not been recovered. Continuing with the next database.");
		add(12545 , 10 , "Database '%.*s' is now online with a lower server version number. Refer to the higher version release notes on the limitations of backward compatibility.");
		add(12546 , 18 , "During undo the timestamp to be assigned to a page is less than the current page timestamp. Page = %u, object id = %d, page timestamp = (%04x %08x), new page timestamp = (%04x %08x).");
		add(12547 , 18 , "Warning: Memory Allocation to store recovery information failed.");
		add(12548 , 10 , "Since database %.*s will bypass recovery, the specified strict online order for this database will not be maintained.");
		add(12549 , 10 , "Since database '%.*s' is in the middle of a load and will not be recovered, the specified strict online order for this database will not be maintained.");
		add(12550 , 10 , "Warning: The read of database recovery orders failed. Databases will be recovered serially in order of database ID.");
		add(12551 , 18 , "Warning: Failed to start a recovery task.");
		add(12552 , 10 , "Recovery counters collected for sample number %d are: %d, %d, %d. The average is %d.");
		add(12553 , 10 , "Upon user's request, the server will recover the remaining %d user databases in serial mode.");
		add(12554 , 10 , "The optimal number of recovery processes is %d.");
		add(12555 , 10 , "The server will recover databases serially.");
		add(12556 , 18 , "During recovery, process %d could not get a resource lock on '%.*s'.");
		add(12557 , 10 , "Recovery has tuned the size of '%.*s' pool in '%.*s' to benefit recovery performance. The original configuration will be restored at the end of recovery.");
		add(12558 , 10 , "Recovery has tuned the '%.*s' pool in '%.*s' by changing its 'local async prefetch limit' from %d to %d. The original configuration will be restored at the end of recovery.");
		add(12559 , 10 , "Recovery cannot restore the size for '%.*s' pool in '%.*s'. The original pool size is %.*s. To fix this, run sp_poolconfig to configure the pool size back to the original value.");
		add(12560 , 10 , "Recovery has restored the original size for '%.*s' pool and '%.*s' pool in '%.*s'.");
		add(12561 , 10 , "Database '%.*s' cannot be brought online immediately, because some database(s) with lower recovery order(s) are not yet online.");
		add(12562 , 10 , "Started estimating recovery log boundaries for database '%.*s'.");
		add(12563 , 10 , "Completed estimating recovery log boundaries for database '%.*s'.");
		add(12564 , 10 , "Started ANALYSIS pass for database '%.*s'.");
		add(12565 , 10 , "Completed ANALYSIS pass for database '%.*s'.");
		add(12566 , 10 , "Started %sREDO pass for database '%.*s'. The total number of log records to process is %d.");
		add(12567 , 10 , "Completed REDO pass for database '%.*s'.");
		add(12568 , 10 , "Recovery of database '%.*s' will undo incomplete nested top actions.");
		add(12569 , 10 , "Started UNDO pass for database '%.*s'. The total number of log records to process is %d.");
		add(12570 , 10 , "Completed UNDO pass for database '%.*s'.");
		add(12571 , 10 , "Started filling free space info for database '%.*s'.");
		add(12572 , 10 , "Completed filling free space info for database '%.*s'.");
		add(12573 , 10 , "Started cleaning up the default data cache for database '%.*s'.");
		add(12574 , 10 , "Completed cleaning up the default data cache for database '%.*s'.");
		add(12575 , 10 , "Started recovery checkpoint for database '%.*s'.");
		add(12576 , 10 , "Completed recovery checkpoint for database '%.*s'.");
		add(12577 , 10 , "WARNING: The value of 'max concurrently recovered db' (%d) exceeds the server resource limit (%d). The server will limit the maximum number of recovery processes to %d.");
		add(12578 , 10 , "The optimal number of recovery processes is %d, but the server will use %d recovery processes as requested.");
		add(12579 , 10 , "Continuing recovery with the next database.");
		add(12580 , 10 , "Recovery has restored the value of 'local async prefetch limit' for '%.*s' pool in '%.*s' from '%d' to '%.*s'.");
		add(12581 , 10 , "Recovery process tried to tune the pool sizes in the '%.*s' to an optimal configuration to aid recovery performance, but failed to do so. It will proceed with the original pool size configuration.");
		add(12582 , 16 , "Database '%.*s': Adaptive Server failed to grant or revoke permissions on table %s.");
		add(12583 , 21 , "Unable to log a record in database '%.*s' (id %d) due to internal error %d. This process will retry at intervals of one minute.");
		add(12584 , 16 , "Unsupported log version %d, from ASE version '%s', found for database '%S_DBID' Upgrade from an ASE version earlier than '%s' is unsupported. Database cannot be opened.");
		add(12585 , 10 , "%S_MSG %.*s (%d %%)");
		add(12586 , 10 , "Database '%.*s', checkpoint=(%u, %d), first=(%u, %d), last=(%u, %d).");
		add(12587 , 20 , "Initialization of sysroles and sysusers in database %.*s failed due to missing system role '%.*s' in master..syssrvroles.");
		add(12588 , 10 , "Initialization of sysroles and sysusers in database %.*s was not able to add system role '%.*s' because no available local role identifier was found in sysroles.");
		add(12589 , 10 , "Initialization of sysusers in database %.*s found that the row for system role '%.*s' is missing. Adding the required row to sysusers.");
		add(12591 , 10 , "Initialization of sysusers in database %.*s changed the system role name from '%.*s' to '%.*s'.");
		add(12592 , 10 , "Initialization of sysroles in database %.*s is deleting an orphaned row in sysprotects for user id (UID) %d. This UID is now used by the system role '%.*s'.");
		add(12593 , 10 , "You cannot be in the '%.*s' database to online it.");
		add(12594 , 18 , "The database '%.*s' cannot be brought online because we are unable to obtain exclusive access. The command has been aborted.");
		add(12595 , 10 , "The database '%.*s' cannot be brought online because recovery marked it 'suspect'.");
		add(12596 , 10 , "Cannot bring database '%.*s' online because cluster is in failover");
		add(12597 , 10 , "Recovery started cleaning up lock cache.");
		add(12598 , 10 , "Recovery cleaned up %d unused locks.");
		add(12599 , 10 , "Database '%.*s' with database id '%d', has only been partially recovered following an instance failure. Locks have been retained that might cause blocking.");
		add(12700 , 18 , "Suspect Granularity: Bad suspect item type '%d' ('%d') due to an internal error. Please contact SAP Technical Support.");
		add(12701 , 10 , "Suspect Granularity: Command failed. No cached suspect list.");
		add(12702 , 18 , "Suspect Granularity: Unable to delete suspect information from master..sysattributes table.");
		add(12703 , 18 , "Suspect Granularity: Unable to start transaction to delete suspect information from master..sysattributes table.");
		add(12704 , 18 , "Suspect Granularity: Failed to access sysdatabases table.");
		add(12705 , 18 , "Suspect Granularity: Failed to replace sysdatabases row.");
		add(12706 , 18 , "Suspect Granularity: Failed to end update on sysdatabases table.");
		add(12707 , 18 , "Suspect Granularity: Adding suspect information rows is not allowed.");
		add(12708 , 18 , "Suspect Granularity: Failed to read or change a bit in status2 field of sysdatabases row.");
		add(12709 , 18 , "Suspect Granularity: Failed to clean up suspect information.");
		add(12710 , 18 , "Suspect Granularity: Command failed because of an unknown suspect attribute ('%d'). This is an internal error. Please contact SAP Technical Support.");
		add(12711 , 18 , "Suspect Granularity: Command failed because cached suspect information is missing. This is an internal error and can be a serious problem. You may need to restart ASE. Contact your System Administrator.");
		add(12712 , 18 , "Suspect Granularity: Command failed because an invalid action ('%d')was detected. This is an internal error. Please contact SAP Technical Support.");
		add(12713 , 18 , "Suspect Granularity: Command failed because a suspect page-to-object map was not available due to allocation page corruption.  Contact your SystemAdministrator.");
		add(12714 , 18 , "Suspect Granularity: For the last suspect page in the object, the delete of the suspect object entry failed but sp_forceonline_page was successful. Use sp_forceonline_object to clean up the object information.");
		add(12715 , 18 , "Suspect Granularity: Command failed and the requested operation did not complete.  Inform your System Administrator.");
		add(12716 , 17 , "Data unavailable: Unable to complete because the required data is currently unavailable. The command failed and the transaction aborted. Try again later or contact your System Administrator.");
		add(12717 , 10 , "Suspect data encountered: Database '%.*s', object '%.*s', index ID '%d', page ID '%u'.");
		add(12718 , 10 , "Suspect data encountered: Database: '%.*s', Page: '%u' (object information not available).");
		add(12719 , 17 , "Suspect Granularity: Drop of object '%.*s' failed because master transaction is required to update master..sysattributes table. Drop the table/index within a master database transaction.");
		add(12720 , 17 , "Suspect data encountered: Drop of object '%.*s' failed because it contains suspect data.");
		add(12721 , 10 , "Suspect Granularity: Page '%u' of database '%.*s' was made accessible to all users from previous state '%.*s'.");
		add(12722 , 10 , "Suspect Granularity: The access state of page '%u' of database '%.*s' was changed from '%.*s' to '%.*s'.");
		add(12723 , 10 , "Suspect Granularity: Object '%d' with index '%d' of database '%.*s' was made accessible to all users from previous state '%.*s'.");
		add(12724 , 10 , "Suspect Granularity: The access state of object '%d' with index '%d' of database '%.*s' was changed from '%.*s' to '%.*s'.");
		add(12725 , 18 , "Suspect Granularity: Transaction failed during commit (putxact).");
		add(12726 , 17 , "Suspect Granularity: Dump database of '%.*s' failed because some of the data in this database is suspect.");
		add(12727 , 17 , "Suspect Granularity: Database '%.*s' has suspect data. Dump transaction with requested options is disabled. Use dump transaction that saves the log OR SA can online all suspect data (sp_forceonline_page) before performing this operation.");
		add(12728 , 18 , "Suspect Granularity: Drop of object '%.*s' failed due to an internal error. Consult the error log and Inform your System Administrator.");
		add(12729 , 10 , "Suspect Granularity: WARNING: The drop of '%.*s' may fail if it has suspect pages because it requires a transaction that started in the master database.");
		add(12730 , 10 , "Suspect Granularity: Automatic truncation of log after checkpoint has been disabled temporarily because some data in database '%.*s' is suspect. Either truncate log without no_log or truncate_only option, or online all suspect pages/objects.");
		add(12731 , 17 , "Recovery (Suspect Granularity): Reached suspect threshold '%d' for database '%.*s'. Increase suspect threshold using sp_setsuspect_threshold.");
		add(12732 , 18 , "Recovery (Suspect Granularity): Unable to mark suspect object '%d'.Inform your System Administrator.");
		add(12733 , 18 , "Recovery (Suspect Granularity): Error in getting suspect information row from master..sysattributes.Inform your System Administrator.");
		add(12734 , 18 , "Recovery (Suspect Granularity): Failed to insert row into master..sysattributes table.");
		add(12735 , 18 , "Recovery (Suspect Granularity): Failed to scan master..sysattributes table for suspect information.");
		add(12736 , 10 , "Recovery (Suspect Granularity): Allocation page %u is corrupted.");
		add(12737 , 18 , "Recovery (Suspect Granularity): Recovery aborted for database '%.*s' because the suspect items cannot be isolated at this level.");
		add(12738 , 18 , "Recovery (Suspect Granularity): Failed to read suspect granularity from master..sysattributes for database '%.*s'.");
		add(12739 , 10 , "Recovery (Suspect Granularity): Warning - suspect granularity defaulted to database level for database '%.*s'.");
		add(12740 , 18 , "Recovery (Suspect Granularity): Failed to read suspect threshold from master..sysattributes for database '%.*s'. Assumimg default ('%d' pages).");
		add(12741 , 10 , "Recovery (Suspect Granularity): No transaction available to write to master..sysattributes table.");
		add(12742 , 17 , "Recovery (Suspect Granularity): Warning: Memory not available to store suspect information. Using default suspect granularity (database).");
		add(12743 , 10 , "Recovery (Suspect Granularity): Page/object suspect information has been deleted.");
		add(12744 , 10 , "Recovery (Suspect Granularity): Bad suspect granularity '%d' for database '%.*s'.This is an internal error. Contact SAP Technical Support.");
		add(12745 , 10 , "Recovery (Suspect Granularity): Warning - Failed to read error list for database:'%.*s'. Continuing with  hard coded error list.");
		add(12746 , 10 , "Recovery (Suspect Granularity): Warning - suspect granularity defaulted to page level. Object level is disabled in this release.");
		add(12747 , 10 , "Recovery (Suspect Granularity): Suspect page encountered: database '%.*s', page '%u', session (%u, %d), log row ID (%u, %d).");
		add(12748 , 10 , "Recovery (Suspect Granularity): Suspect object in database '%.*s', object '%.*s', index '%d'.");
		add(12749 , 10 , "Recovery (Suspect Granularity): Suspect pages are present in database '%.*s'.");
		add(12750 , 10 , "Recovery (Suspect Granularity): Warning - Page to object translation failed.");
		add(12751 , 18 , "Recovery (Suspect Granularity): Failed to insert suspect informationrow into master..sysattributes table.");
		add(12752 , 18 , "Recovery (Suspect Granularity): Failed to write suspect list to master..sysattributes table.");
		add(12753 , 18 , "Recovery (Suspect Granularity): Failed to write suspect attribute to master..sysattributes table.");
		add(12754 , 18 , "Recovery (Suspect Granularity): Failed to read suspect attribute from master..sysattributes table.");
		add(12755 , 18 , "Recovery (Suspect Granularity): Failed to read suspect list from master..sysattributes table.");
		add(12756 , 18 , "Recovery (Suspect Granularity): Recovery aborted while reading master..sysattributes. Inform your System Administrator.");
		add(12757 , 18 , "Recovery (Suspect Granularity): Write of suspect information to master..sysattributes failed. Inform your System Administrator.");
		add(12758 , 10 , "Recovery (Suspect Granularity): Settings for database '%.*s'- Suspect Granularity: '%.*s', Suspect Threshold: %d, Online Option: '%.*s'.");
		add(12759 , 10 , "Recovery (Suspect Granularity): Database '%.*s' - begin list of pre-recovery suspect pages.");
		add(12760 , 10 , "Recovery (Suspect Granularity): Database '%.*s' - end list of pre-recovery suspect pages.");
		add(12761 , 10 , "Recovery (Suspect Granularity): Page '%u' of database '%.*s' is removed from suspect page list because it was unallocated at end of recovery due to page/extent deallocation. This page is clean and no action is required.");
		add(12762 , 10 , "Recovery (Suspect Granularity): Recovery of database '%.*s' found %d suspect pages belonging to %d suspect objects.");
		add(12763 , 10 , "Recovery (Suspect Granularity): Database '%.*s' is clean.");
		add(12767 , 10 , "Suspect data encountered: Database: '%.*s', Object: '%d");
		add(12768 , 10 , "Suspect Granularity: (for Testing only) Simulated error to create suspect pages. Objid: '%d', Indid: '%d', Errtype: '%d', Logtype: '%d', Pagetype: '%d', PageNo: '%d', Simulation Type: '%.*s'.");
		add(12769 , 10 , "Recovery (Suspect Granularity): The database '%.*s' will come online in read only mode due to suspect pages/objects. Use sp_dboption to turn off read only mode.");
		add(12770 , 10 , "Suspect index encountered: database '%.*s', object '%.*s', index '%d'.");
		add(12771 , 16 , "Recovery (Suspect Granularity): Granularity setting '%s' for database '%.*s' is not supported in the ASE Cluster Edition and will be ignored. This message can be suppressed in future by using the command sp_setsuspect_granularity %.*s, 'database'.");
		add(12801 , 12 , "The object `%.*s' is not a partitioned table. UPDATE PARTITION STATISTICS can only be run on partitioned tables.");
		add(12802 , 16 , "Invalid partition number %d. Valid partition number is a positive integer.");
		add(12803 , 16 , "CREATE VIEW failed because column %d in the view definition has a null column name. Column names cannot be null.");
		add(12804 , 18 , "Unable to change the logversion from %d to %d on database '%S_DBID'.");
		add(12805 , 18 , "Unable to bring the master database online due to lack for space. Please re-start the previous of the server, add more space and then reboot the new version of the server. Shutting down.");
		add(12806 , 18 , "cannot replace a tuple in sysstatistics");
		add(12807 , 18 , "cannot delete a tuple in sysstatistics");
		add(12808 , 18 , "Cannot write table '%.*s' statistics");
		add(12809 , 16 , "Duplicate column listed in update statistics. Column name '%.*s' for table '%.*s' listed more than once");
		add(12810 , 16 , "Cannot resolve column name '%.*s' for table '%.*s'. This could be because the column does not belong to the table or it has an unknown datatype or an internal error related to the system catalogs has happened");
		add(12811 , 16 , "Column name '%.*s' for table '%.*s' is one of TEXT, IMAGE, UNITEXT or BIT datatype. This type of column cannot be used in update statistics.");
		add(12813 , 18 , "Failed to start an internal transaction. This will prevent information for index '%.*s', partition '%.*s' on table '%.*s' from being written out to SYSTABSTATS.");
		add(12814 , 18 , "Failed to write information in SYSTABSTATS.");
		add(12815 , 18 , "Failed to obtain lock on SYSTABSTATS.");
		add(12816 , 18 , "Failed to delete a row in SYSTABSTATS for table '%.*s', because the row could not be located.");
		add(12817 , 16 , "This form of UPDATE STATISTICS on table '%.*s' does not support the CONSUMERS option. Please rerun it without this option.");
		add(12818 , 16 , "Cannot create an object of this type in system-created proxy database.");
		add(12819 , 16 , "Cannot create a constraint on a column of TEXT, IMAGE, UNITEXT or off row Java datatype.");
		add(12822 , 16 , "Cannot create temporary table '%.*s'. Prefix name '%.*s' is already in use by another temporary table '%.*s'.");
		add(12823 , 16 , "Command 'addcert' failed to add certificate path %s, system error: %s.");
		add(12824 , 16 , "Command 'dropcert' failed to drop certificate path %s. %s");
		add(12826 , 16 , "Attempt to read certificate path from master database failed.");
		add(12827 , 10 , "Warning: command 'addcert' adds certificate path %s with its common name field different from server name.");
		add(12828 , 16 , "The datatype of a parameter marker used in the dynamic prepare statement could not be resolved.");
		add(12829 , 10 , "Warning: command 'addcert' adds certificate path '%s' that is not yet valid. Error '%s'.");
		add(12830 , 10 , "Warning: command 'addcert' adds certificate path '%s' that has expired. Error %s.");
		add(12831 , 16 , "Failed to create computed column '%.*s' on table '%.*s'.");
		add(12832 , 16 , "The LDAP URL string '%s' is invalid. LDAP subsystem reported error '%s'.");
		add(12833 , 16 , "The string '%s' is a valid LDAP URL accepted by the LDAP subsystem.");
		add(12834 , 16 , "The login name '%s' is invalid. The LDAP subsystem reported error '%s'.");
		add(12835 , 16 , "The login name '%s' exists as a user on the LDAP Server specified for ASE.");
		add(12836 , 16 , "The LDAP URL '%s' could not be set. The LDAP subsystem reported error '%s'.");
		add(12837 , 16 , "The URL '%s' is set for LDAP User Authentication.");
		add(12838 , 10 , "Warning: Attempting to set URL '%s' for LDAP User Authentication, ASE noticed non-fatal condition '%s'. Will continue with attempt.");
		add(12839 , 16 , "Authentication failed. Unable to create local login '%.*s' when LDAP User Authentication is configured at current level %d without valid user name and password on LDAP server.");
		add(12840 , 16 , "%.*s is not an official language name from Syslanguages.");
		add(12841 , 16 , "Partition names in each table or index must be unique. Partition name '%.*s' is specified more than once.");
		add(12842 , 18 , "Adaptive Server cannot process this %s statement due to one or more errors. Please retry this command if it failed due to a deadlock. Please refer to your application log or Adaptive Server errorlog for more information on the cause of this failure.");
		add(12844 , 10 , "The value of 'repartition_degree' (%d) cannot be larger than the value of configuration parameter 'max repartition degree' (%d). The value '%d' is used for 'repartition_degree'.");
		add(12845 , 10 , "The value of 'resource_granularity' (%d) cannot be larger than the value of configuration parameter 'max resource granularity' (%d). The value '%d' is used for 'resource_granularity'.");
		add(12846 , 16 , "The LDAP account distinguished name '%s' cannot be set. The LDAP subsystem reported error '%s'.");
		add(12847 , 16 , "The LDAP account distinguished name '%s' is set for LDAP user authentication.");
		add(12848 , 16 , "Partition '%.*s' is not found for table '%.*s'.");
		add(12849 , 16 , "Partition '%.*s' is not found for index '%.*s'.");
		add(12850 , 16 , "Command 'setcipher' encountered invalid cipher suite name '%s' in cipher suite list, preferences are unchanged.");
		add(12851 , 16 , "Cannot set cipher suite preferences or protocol version in SSL context due to error '%s' (%d). Values are unchanged.");
		add(12852 , 10 , "Warning: Found unexpected row in sysattributes, skipping cipher 0x%x, cipher name %.*s, order preference %d, default value %d, row count %d.");
		add(12853 , 16 , "SSL is not supported on this platform or product version.");
		add(12854 , 16 , "Table '%.*s' cannot have only virtual computed columns.");
		add(12855 , 10 , "The system is under-configured for the calibration of table '%.*s'. Please bump up the number of worker processes to %d using the sp_configure system stored proc");
		add(12856 , 16 , "Incorrect UPDATE STATISTICS calibration percentage '%d' requested. Enter a value between '0' and '100'.");
		add(12857 , 16 , "Sampling is not supported for UPDATE STATISTICS of proxy tables.");
		add(12858 , 20 , "Update to sysobjects row for %S_OBJINFO failed.");
		add(12859 , 20 , "Column sysobjects.%s has length '%d', should be '%d'. The sysobjects row is for %S_OBJINFO.");
		add(12860 , 16 , "Cannot set the %.*s LDAP URL state to %s.");
		add(12861 , 16 , "The LDAP property '%s' cannot be set. The LDAP subsystem reported error '%s'.");
		add(12862 , 16 , "The LDAP property '%s' is set to '%s'.");
		add(12863 , 16 , "Cannot retrieve the LDAP property '%s'. The LDAP subsystem reported error '%s'.");
		add(12864 , 16 , "The property 'max_ldapua_native_threads' cannot exceed the 'max native threads per engine' LESS 'number of dump threads'. Increase 'max native threads per engine' first, then increase 'max_ldapua_native_threads' or 'number of dump threads'.");
		add(12865 , 16 , "LDAP property '%s' must be between '%d' and '%d'.");
		add(12866 , 16 , "Nonfatal condition '%S_MSG' received while attempting to set property '%s' for LDAP user authentication. Attempts to set property will continue.");
		add(12867 , 16 , "Cannot set 'max native threads per engine' since minimum value %d is required to satisfy usages by LDAP user authentication (%d) and shared memory dump (%d).");
		add(12869 , 16 , "There are no local switches set.");
		add(12870 , 16 , "The value %d is out of range.");
		add(12872 , 16 , "Switch %.*s was not set server-wide.");
		add(12873 , 16 , "Switch %.*s was not set as a local switch.");
		add(12874 , 10 , "All supplied switches are successfully switched off.");
		add(12875 , 16 , "Switch %.*s does not exist.");
		add(12876 , 16 , "Switch %.*s is an internal switch and the 'with override' option is not supplied.");
		add(12877 , 16 , "You cannot use SET SWITCH to set switch %.*s.");
		add(12878 , 16 , "You can only use switch %.*s in the runserver file using the -T option.");
		add(12879 , 16 , "You cannot set switch %.*s at the server level. It's a per session switch.");
		add(12880 , 16 , "You can set switch %.*s only at the server level.");
		add(12881 , 17 , "There is insufficient memory to allocate the structures needed to set local switches. Contact your System Administrator.");
		add(12882 , 10 , "All supplied switches are successfully turned on.");
		add(12883 , 10 , "Local switches set : %s.");
		add(12884 , 10 , "Serverwide switches set : %s.");
		add(12885 , 16 , "Switch %.*s is no longer in use.");
		add(12886 , 16 , "LDAP User Authentication is not supported on this platform or product version.");
		add(12887 , 16 , "You must have any of the following roles/privileges : '%.*s' when using switch : %.*s.");
		add(12888 , 10 , "Switch %.*s is turned on.");
		add(12889 , 10 , "Switch %.*s is turned off.");
		add(12890 , 16 , "%s failed. Invalid syntax. Multiple occurence of '%s' option is not allowed.");
		add(12891 , 16 , "Cannot update index replication information for object '%d', column offset '%d'.");
		add(12892 , 16 , "Invalid system view provided. The only valid system views are: 'instance', 'cluster', and 'clear'.");
		add(12893 , 10 , "Processed %u allocation unit(s) out of %u units (allocation page %u). %d%% completed.");
		add(12894 , 16 , "The name '%.*s' is not a valid cluster instance name.");
		add(12895 , 10 , "LDAP server may not accept anonymous binds. Check the access account for the %S_MSG URL set.");
		add(12896 , 10 , "Check access account values for the %S_MSG URL set. Bind without a password is not allowed.");
		add(12897 , 10 , "The value of 'parallel_degree' (`%d') cannot be larger than the value of configuration parameter 'max query parallel degree' (`%d'). The value '%d' is used for 'parallel_degree'.");
		add(12898 , 16 , "Command '%s' is not supported on system catalogs.");
		add(12899 , 16 , "Data-only locking is not supported on virtually hashed table '%.*s'.");
		add(12901 , 16 , "This command is not allowed on an offline database '%S_DBID'.");
		add(12902 , 16 , "Mime page chain starting at page %u has %d parts in it's header %d parts were found.");
		add(12903 , 16 , "Mime page chain starting at page %u has %d bytes in it's header %d bytes were found.");
		add(12904 , 16 , "Cannot find object with ID '%d'. Check the object ID and retry the command.");
		add(12905 , 16 , "Index %d of object %d corrupt; key values in child page %u inconsistent for parent page %u. Drop and recreate the index.");
		add(12906 , 16 , "Index %d of object %d has wrong level %d for page %u, parent %u is at level %d");
		add(12907 , 16 , "The total number of data and control pages in this table is %d.");
		add(12908 , 16 , "Index %d of object %d has orphan leaf page %u. Drop and recreate the index.");
		add(12909 , 16 , "Table with object id=%d (name = %S_OBJID) inconsistent after Large Scale Allocation. %d pages in extent %u were found reserved.");
		add(12910 , 16 , "Page %u in extent %u in table with object id %d (name = %S_OBJID) and index %d is in the process of being allocated. To verify if the page is indeed allocated, run TABLEALLOC with the FIX option when there are no active transactions.");
		add(12911 , 10 , "Page %u, partition ID %d, does not have its 'extended header' bit set. This page belongs to object '%.*s' (ID %d) in database '%.*s' (ID %d).");
		add(12912 , 10 , "Incorrect offset entry(s) in the offset table of row %d. This row is in page %u, partition ID %d, and belongs to object '%.*s' (ID %d) in database '%.*s' (ID %d).");
		add(12913 , 10 , "Incorrect column type in the offset table of row %d. This row is on page %u, partition ID %d, and belongs to object '%.*s' (ID %d) in database '%.*s' (ID %d).");
		add(12914 , 16 , "EXP_ROW_SIZE value of %d is invalid. It must be between %d and %d.");
		add(12915 , 16 , "Invalid Cachelet ID %d. Valid Cachelet ID values are between %d and %d.");
		add(12916 , 16 , "Fixed spacebits (on allocation page) for DOL datapage %u, partition ID %d, with 'insfs' %d and 'expected row length' %d. The expected value was 0x%x; however, the value was 0x%x.");
		add(12917 , 16 , "Non-contiguous free space' value %d in the page header of DOL datapage %u, partition ID %d is incorrect. This value cannot be negative.");
		add(12918 , 16 , "Flags (0x%x) in Text/Image/Unitext Page Status Area on text page %u (partition id %d) does not match the attribute of text page chain starting from page %u. Run DBCC REBUILD_TEXT to fix it.");
		add(12919 , 10 , "Verifying faults for '%.*s'.");
		add(12920 , 16 , "The last completed DBCC CHECKSTORAGE for this database has been processed. You must perform another DBCC CHECKSTORAGE before you can use CHECKVERIFY or CHECKREPAIR. Use sp_dbcc_summaryreport to view the DBCC operations performed.");
		add(12921 , 16 , "A problem was encountered while accessing the faults recorded in the dbccdb database. Please check the dbcc_faults and dbcc_fault_params tables in the dbccdb database.");
		add(12922 , 16 , "A problem was encountered while updating the fault status in the dbcc_faults table. Please check the dbcc_faults and dbcc_fault_params tables in the dbccdb database.");
		add(12923 , 10 , "Failed to get an '%s' lock on table '%.*s'. The faults for this table will not be processed.");
		add(12924 , 10 , "DBCC CHECKVERIFY for database '%.*s' encountered an error. Correct the reported problem reported and execute the CHECKVERIFY command again.");
		add(12925 , 10 , "DBCC CHECKVERIFY for database '%.*s' sequence %d completed at %s. %d suspect conditions considered, %d identified as faults, %d identified as harmless, and %d could not be checked. %d objects could not be checked.");
		add(12926 , 16 , "DBCC CHECKVERIFY could not acquire a lock on the target database.");
		add(12927 , 10 , "Performing QUICK repairs to database '%.*s'.");
		add(12928 , 10 , "DBCC CHECKREPAIR with the QUICK_REPAIRS option does not accept an object name. The parameter '%.*s' will be ignored.");
		add(12929 , 10 , "DBCC CHECKREPAIR for database '%.*s' sequence %d completed at %s. %d faults were repaired, and %d faults were resolved without repair. %d objects could not be processed and %d faults remain unrepaired.");
		add(12930 , 10 , "DBCC CHECKREPAIR for database '%.*s' encountered an error. Correct the problems reported and execute the CHECKREPAIR command again.");
		add(12931 , 10 , "The total number of empty pages (with all deleted rows) in this table is %d.");
		add(12932 , 10 , "The total number of pages which could be garbage collected to free up some space is %d.");
		add(12933 , 16 , "DBCC CHECKSTORAGE not supported in this release of Adaptive Server Enterprise.");
		add(12934 , 16 , "Page %u of object %d, indid %d undergoing change. Some pages of indid %d may not be checked, retry the command later.");
		add(12935 , 16 , "Engine zero can not be offline.");
		add(12936 , 10 , "Failed to (re)build the st-node. Please issue the command 'dbcc rebuild_text (%d, %d, %d)' to (re)build the st-node. (objid=%d, colid=%d, FTP=%d).");
		add(12937 , 16 , "The text page back pointer on text page %u appears to be incorrect. Expected %u, but got %u.");
		add(12938 , 16 , "Engine number must be between %d and (maxonline - 1) %d.");
		add(12939 , 16 , "The minimum number of online engines is %d. No more engine can be offlined.");
		add(12940 , 16 , "Database '%.*s' in Sysreferences for constraint id %d could not be opened.");
		add(12941 , 16 , "Table Corrupt: Table id %d, indid %d in Sysreferences does not have a matching entry in Sysindexes in database %d.");
		add(12942 , 16 , "Table Corrupt: Table id %d, colid %d in Sysconstraints does not have a matching entry in Syscolumns.");
		add(12943 , 16 , "Mismatch found in SYSREFERENCES between database id %d and database name '%.*s'. Actual dbid is %d.");
		add(12944 , 10 , "Insert free space' value in the page header of DOL datapage %u, partition ID %d, has been corrected to %d.");
		add(12945 , 16 , "Mismatch found. Current database ID %d, appears in sysreferences with database ID %d.");
		add(12946 , 10 , "%d allocation pages have been corrected to match database ID %d.");
		add(12947 , 16 , "Syslogs free space is currently %d pages but DBCC counted %d pages. This descrepancy may be spurious if this count was done in multi-user mode. Please run DBCC TABLEALLOC(syslogs, full, fix) to correct it.");
		add(12948 , 10 , "Syslogs free space count has been successfully recalculated. It has been corrected to %d pages.");
		add(12949 , 16 , "This command is only allowed for databases having a separate log segment.");
		add(12950 , 10 , "The following task(s) will affect the offline process:");
		add(12951 , 10 , "spid: %d has outstanding %s connections.");
		add(12952 , 10 , "The total number of wrong st-node back references to first text page chains in this table is %d.");
		add(12953 , 16 , "An invalid external st-node 'first text page' value (%u) is stored in the first text page (page %u, partition ID %d).");
		add(12954 , 16 , "An invalid 'first text page' value (%u) was found in data row text pointer %s for text/image/unitext column %d, in row %d. This row is on page %u, partition ID %d, and belongs to the object with ID %d.");
		add(12955 , 16 , "Incorrect partition ID %d found in extent ID %u for object ID %d.");
		add(12956 , 10 , "The reserved status was found to be improperly set in %d pages. That status has been cleared by DBCC.");
		add(12959 , 10 , "The segmap field was found to be improperly set in %d allocation page(s) and it has been fixed by DBCC.");
		add(12960 , 16 , "Database ID %d not found; check sysdatabases.");
		add(12961 , 16 , "Cannot drop database '%.*s' because it is not a HA-created proxy database.");
		add(12962 , 16 , "Cannot drop database '%.*s' because it is not a HA failed-over database.");
		add(12963 , 16 , "Cannot drop database '%.*s' because it is a HA-created proxy database.");
		add(12964 , 20 , "DBCC cannot insert the row in the dbcc_operation_log table for this check of database '%.*s', aborting check.");
		add(12965 , 0  , "Ignoring invalid exclusion mode '%d'. Valid modes are 0 and 1.");
		add(12966 , 10 , "You cannot use the %s workspace '%.*s' for database '%.*s'; required minimum size is %d KB. The workspace is only %d KB.");
		add(12967 , 16 , "Table '%.*s' does not exist in database '%.*s'.");
		add(12968 , 20 , "Aborting DBCC run. Cannot retrieve the sequence number from the dbcc_operation_log table for this run of CHECKVERIFY on database '%.*s'.");
		add(12969 , 10 , "Database '%.*s', id %d was configured with a different name in dbccdb database. Delete the old configuration and history using 'sp_dbcc_deletedb '%d'' and retry this operation.");
		add(12970 , 10 , "Aborting DBCC run. Cannot insert initial configuration into the dbcc_config table for database '%.*s'.");
		add(12971 , 16 , "Illegal identity value '%.*s' specified for table '%.*s'.");
		add(12972 , 16 , "Identity value '%.*s' overflow for table '%.*s'.");
		add(12973 , 16 , "Cannot use '%s' on table '%.*s', because it is not a user table.");
		add(12974 , 16 , "Engine %d has outstanding ct-lib/java/messaging connections and cannot be taken offline. If RepAgent is bound to this engine, unbind it before taking the engine offline.");
		add(12975 , 16 , "engine %d is not online");
		add(12976 , 16 , "migration from engine %d failed (see errorlog for more details)");
		add(12977 , 16 , "No more engines can be offlined in order to support %d outstanding network connections. Please try later when the server has fewer connections.");
		add(12978 , 16 , "A previous engine offline operation is not complete, please try the command again later");
		add(12979 , 16 , "The server was unable to create a task to perform the engine offline operation. See the errorlog for more information.");
		add(12980 , 16 , "The engine offline operation failed. Check the error log for more information.");
		add(12981 , 16 , "Error while trying to refresh syspartitions row within partition descriptor with dbid %d objid %d indid %d and partition id %d.");
		add(12982 , 16 , "A listener command or an engine online/offline command is already in progress.");
		add(12983 , 16 , "An error occurred during a SELECT operation.");
		add(12984 , 16 , "An error occured while reading the interfaces file.");
		add(12985 , 16 , "No listener will be affected by this command.");
		add(12986 , 16 , "%s is not a valid protocol type on this platform.");
		add(12987 , 16 , "%d is not a valid engine.");
		add(12988 , 16 , "Engine %d is not online.");
		add(12989 , 16 , "The listener wih protocol %s, host %s, port %s, engine %d is not suspended.");
		add(12990 , 16 , "There is no listener with protocol %s, host %s, port %s.");
		add(12991 , 16 , "The listener with protocol %s, host %s, port %s is reserved.");
		add(12992 , 16 , "A listener with protocol %s, host %s, port %s, engine %d already exists.");
		add(12993 , 16 , "There is no listener with protocol %s, host %s, port %s, engine %d.");
		add(12994 , 16 , "This command will leave no more active listeners.");
		add(12995 , 16 , "The listener with protocol %s, host %s, port %s, engine %d is already suspended.");
		add(12996 , 16 , "An error was encountered when starting a listener with protocol %s, host %s, port %s, engine %d.");
		add(12997 , 16 , "An error occurred during a CREATE TABLE operation.");
		add(12998 , 16 , "An error occurred during a DROP TABLE operation.");
		add(12999 , 16 , "Partition id '%d' is not found in dbid '%d'.");
	}
	private void init4()
	{
		add(13001 , 10 , "data page");
		add(13002 , 10 , "index page");
		add(13003 , 10 , "leaf page");
		add(13004 , 10 , "last");
		add(13005 , 10 , "root");
		add(13006 , 10 , "read from");
		add(13007 , 10 , "send to");
		add(13008 , 10 , "receive");
		add(13009 , 10 , "send");
		add(13010 , 10 , "read");
		add(13011 , 10 , "wait");
		add(13012 , 10 , "A USE DATABASE statement");
		add(13013 , 10 , "a procedure or trigger");
		add(13014 , 10 , "A DISTINCT clause");
		add(13015 , 10 , "a view");
		add(13016 , 10 , "An INTO clause");
		add(13017 , 10 , "An ORDER BY clause");
		add(13018 , 10 , "A COMPUTE clause");
		add(13019 , 10 , "a SELECT INTO statement");
		add(13020 , 10 , "option");
		add(13021 , 10 , "offset option");
		add(13022 , 10 , "statistics option");
		add(13023 , 10 , "parameter option");
		add(13024 , 10 , "built-in function name");
		add(13025 , 10 , "field");
		add(13026 , 10 , "parameter");
		add(13027 , 10 , "convert specification");
		add(13028 , 10 , "index");
		add(13029 , 10 , "table");
		add(13030 , 10 , "database");
		add(13031 , 10 , "procedure");
		add(13032 , 10 , "trigger");
		add(13033 , 10 , "view");
		add(13034 , 10 , "default");
		add(13035 , 10 , "rule");
		add(13036 , 10 , "system");
		add(13037 , 10 , "unknown type");
		add(13038 , 10 , "SET command");
		add(13039 , 10 , "column");
		add(13040 , 10 , "type");
		add(13041 , 10 , "character string");
		add(13042 , 10 , "integer");
		add(13043 , 10 , "identifier");
		add(13044 , 10 , "number");
		add(13045 , 10 , "integer value");
		add(13046 , 10 , "floating point value");
		add(13047 , 10 , "object");
		add(13048 , 10 , "column heading");
		add(13049 , 10 , "constraint");
		add(13050 , 10 , "Non-ANSI text");
		add(13051 , 10 , "ANSI text procesed in non-ANSI way");
		add(13052 , 10 , "a non-ANSI data type usage");
		add(13053 , 10 , "Non-standard datatype TIMESTAMP");
		add(13054 , 10 , "Non-standard or user datatype:");
		add(13055 , 10 , "ON <segment>");
		add(13056 , 10 , "Alternate column names in CREATE VIEW");
		add(13057 , 10 , "UNION in INSERT ... SELECT");
		add(13058 , 10 , "FOR BROWSE");
		add(13059 , 10 , "HOLD LOCK in SELECT statement");
		add(13060 , 10 , "transaction name");
		add(13061 , 10 , "Use of TRANSACTION key word instead of WORK");
		add(13062 , 10 , "FROM clause in an UPDATE statement");
		add(13063 , 10 , "More than one table in a from clause for DELETE statement");
		add(13064 , 10 , "Named columns in an ORDER BY included in a UNION");
		add(13065 , 10 , "Comparison operator !=");
		add(13066 , 10 , "Comparison operator !<");
		add(13067 , 10 , "Comparison operator !>");
		add(13068 , 10 , "left equi-join operator");
		add(13069 , 10 , "right equi-join operator");
		add(13070 , 10 , "bitwise operator |");
		add(13071 , 10 , "bitwise operator &");
		add(13072 , 10 , "bitwise operator ^");
		add(13073 , 10 , "bitwise operator ~");
		add(13074 , 10 , "modulo operator %");
		add(13075 , 10 , "temporary table usage");
		add(13076 , 10 , "a statement with assigned variables in the select list");
		add(13077 , 10 , "aborted");
		add(13078 , 10 , "data");
		add(13079 , 10 , "log");
		add(13080 , 10 , "A SYB_RESTREE statement");
		add(13081 , 10 , "A CREATE SCHEMA statement");
		add(13082 , 10 , "dynamic PREPARE statement");
		add(13083 , 10 , "The untyped variable ?");
		add(13084 , 10 , "in a WHERE clause or the SET clause of an UPDATE statement or the VALUES list of an INSERT statement");
		add(13085 , 10 , "Optional procedure number");
		add(13086 , 10 , "Parameter declaration list");
		add(13087 , 10 , "Procedure option");
		add(13088 , 10 , "owner");
		add(13089 , 10 , "object type");
		add(13090 , 10 , "Backup Server");
		add(13091 , 10 , "dump header");
		add(13092 , 10 , "dump trailer");
		add(13093 , 10 , "deadlock");
		add(13094 , 10 , "user interrupt");
		add(13095 , 10 , "suspended");
		add(13096 , 10 , "explicit");
		add(13097 , 10 , "implicit");
		add(13098 , 10 , "A pseudo table");
		add(13099 , 16 , "IDENTITY function");
		add(13100 , 16 , "recalculating sysindexes.minlen");
		add(13101 , 16 , "WITH <option> [=] <value>");
		add(13102 , 10 , "remote server");
		add(13103 , 10 , "primary");
		add(13104 , 10 , "secondary");
		add(13105 , 10 , "updatable");
		add(13106 , 10 , "not updatable");
		add(13108 , 10 , "AT ISOLATION");
		add(13109 , 10 , "because table scans cannot be restarted");
		add(13110 , 10 , "due to an internal error");
		add(13111 , 10 , "initializing new column sysindexes.maxrowsperpage to zero");
		add(13112 , 10 , "checking database references in sysreferences");
		add(13113 , 10 , "modifying index syscomments.syscomments");
		add(13114 , 10 , "recalculating sysindexes.maxlen");
		add(13115 , 10 , "dropping index");
		add(13116 , 10 , "creating table");
		add(13117 , 10 , "creating index");
		add(13118 , 10 , "noting the present database upgrade level");
		add(13119 , 10 , "adding column");
		add(13120 , 10 , "changing column name");
		add(13123 , 10 , "Initializing systimeranges");
		add(13125 , 16 , "forced index");
		add(13126 , 16 , "forced parallel");
		add(13127 , 16 , "forced lru/mru");
		add(13128 , 16 , "forced prefetch");
		add(13134 , 10 , "initializing new column sysusers.sname");
		add(13135 , 10 , "initializing new column sysalternates.sname");
		add(13136 , 10 , "initializing the new column sysobjects.suid");
		add(13137 , 10 , "initializing new column syscomments.hiddentext to NULL");
		add(13138 , 10 , "initializing new column sysprocedures.version");
		add(13139 , 10 , "Setting the value for the column to 1 for all system-defined roles so that they will be enabled on login.");
		add(13144 , 10 , "Checking database timestamps");
		add(13145 , 10 , "Verifying page header information");
		add(13146 , 16 , "Jar");
		add(13147 , 16 , "JDBC");
		add(13148 , 10 , "checking SQL states in sysmessages");
		add(13149 , 16 , "a derived table");
		add(13150 , 10 , "alter table");
		add(13151 , 10 , "insert basic data into bootstrap system tables");
		add(13152 , 10 , "Adaptive Server has expanded all '*' elements in the following statement");
		add(13153 , 10 , "role");
		add(13154 , 10 , "segment");
		add(13155 , 10 , "login");
		add(13156 , 10 , "password");
		add(13157 , 10 , "fullname");
		add(13158 , 10 , "cursor");
		add(13159 , 10 , "tagname");
		add(13160 , 10 , "service name");
		add(13161 , 10 , "server");
		add(13162 , 10 , "user");
		add(13163 , 10 , "client name");
		add(13164 , 10 , "hostname");
		add(13165 , 10 , "application");
		add(13166 , 10 , "language");
		add(13167 , 10 , "abstract plan group");
		add(13168 , 10 , "update system catalog protection data");
		add(13169 , 10 , "validate basic system type data");
		add(13170 , 10 , "unslice table");
		add(13171 , 10 , "label");
		add(13172 , 16 , "datatype");
		add(13173 , 16 , "data length");
		add(13174 , 10 , "clear unused columns");
		add(13175 , 10 , "SQL function");
		add(13178 , 16 , "master key");
		add(13179 , 16 , "dual master key");
		add(13180 , 10 , "column order");
		add(13181 , 10 , "destination type");
		add(13182 , 16 , "login profile name");
		add(13183 , 10 , "a batch");
		add(13184 , 16 , "clustered index");
		add(13185 , 10 , "precomputed result set");
		add(13186 , 10 , "updating DBCC command permissions");
		add(13200 , 10 , "executing SQL statement");
		add(13201 , 10 , "initializing partition IDs for each extent");
		add(13202 , 10 , "initializing partition statistics for each partitioned table");
		add(13203 , 15 , "Variable");
		add(13204 , 15 , "Aggregate function");
		add(13205 , 15 , "check constraint");
		add(13206 , 10 , "changing name of system table");
		add(13207 , 10 , "new name:");
		add(13208 , 10 , "standby-mode log");
		add(13210 , 10 , "Initialize systabstats with valid statistics");
		add(13211 , 10 , "Checking indstatus2 in sysindexes and correcting it if required");
		add(13212 , 10 , "Creating/Updating the last chance threshold for logsegment.");
		add(13213 , 10 , "cache");
		add(13214 , 10 , "insert rows into syspartitions for each system table and index");
		add(13215 , 10 , "function");
		add(13216 , 10 , "Upgrade SARGs in SYSINDEXES to 2-byte column IDs.");
		add(13217 , 16 , "Reconcile (delete obsolete, add new) messages in SYSMESSAGES.");
		add(13218 , 10 , "Load initial set of attribute-definition rows into SYSATTRIBUTES.");
		add(13219 , 16 , "verifying sysstatistics row format");
		add(13220 , 16 , "Initialize disk and create empty allocation units on master device.");
		add(13221 , 16 , "Bootstrap basic system catalogs in database.");
		add(13222 , 10 , "rewrite database");
		add(13223 , 16 , "select into existing table");
		add(13224 , 16 , "null");
		add(13225 , 16 , "range partition values");
		add(13226 , 16 , "a COMPUTED COLUMN defintion");
		add(13227 , 16 , "Update syscharsets with Unicode sort orders.");
		add(13228 , 16 , "Subquery");
		add(13229 , 16 , "list partition values");
		add(13230 , 16 , "partition values");
		add(13231 , 10 , "add");
		add(13232 , 10 , "drop");
		add(13233 , 10 , "update");
		add(13234 , 16 , "FOR XML");
		add(13235 , 16 , "INSERT");
		add(13236 , 16 , "DECLARE CURSOR");
		add(13237 , 16 , "ABSTRACT PLAN");
		add(13238 , 16 , "Grant default permissions on system tables.");
		add(13239 , 10 , "encryption key");
		add(13240 , 16 , "Create proxy_table statement");
		add(13241 , 16 , "subquery EXISTS");
		add(13242 , 16 , "subquery IN");
		add(13243 , 16 , "quantified predicate subquery");
		add(13244 , 16 , "FOR XML SCHEMA");
		add(13245 , 16 , "FOR XML ALL");
		add(13246 , 16 , "messaging builtins");
		add(13247 , 16 , "user-defined Web service");
		add(13248 , 16 , "create existing table syntax");
		add(13249 , 16 , "Computed column declaration");
		add(13250 , 16 , "CREATE TABLE");
		add(13251 , 16 , "CREATE DEFAULT");
		add(13252 , 16 , "Update system roles in system tables.");
		add(13253 , 16 , "partition");
		add(13254 , 16 , "lowercase character(s)");
		add(13255 , 16 , "uppercase character(s)");
		add(13256 , 16 , "alphabetic character(s)");
		add(13257 , 16 , "special character(s)");
		add(13258 , 16 , "digit(s)");
		add(13259 , 16 , "compression");
		add(13260 , 10 , "yes");
		add(13261 , 10 , "no");
		add(13262 , 16 , "LDAP URL string");
		add(13263 , 16 , "login name");
		add(13264 , 16 , "LDAP account distinguished name");
		add(13265 , 16 , "LDAP property");
		add(13266 , 10 , "(internal error, invalid position for value)");
		add(13267 , 16 , "The URL parameter is not an LDAP URL.");
		add(13268 , 16 , "(unable to begin transaction)");
		add(13269 , 16 , "(existing URL found, but could not delete it)");
		add(13270 , 16 , "(internal sysattributes error)");
		add(13271 , 16 , "('enable ldap user auth' is not configured)");
		add(13272 , 16 , "(license ASE_DIRS is not enabled)");
		add(13273 , 10 , "(internal error, invalid position value, defaulting to secondary position)");
		add(13274 , 16 , "(internal error, invalid buffer passed)");
		add(13275 , 16 , "(URL row not found in sysattributes)");
		add(13276 , 16 , "(No URL string to evaluate)");
		add(13277 , 16 , "(No name to evaluate)");
		add(13278 , 16 , "(internal: could not delete existing account info)");
		add(13279 , 16 , "(internal error, insert failed)");
		add(13280 , 16 , "(internal error, invalid pointer passed)");
		add(13281 , 16 , "(Attribute value not found in sysattributes)");
		add(13282 , 16 , "('valid values are 'true' or 'false'')");
		add(13283 , 16 , "(existing value found, but could not delete it)");
		add(13284 , 10 , "configured");
		add(13285 , 10 , "present");
		add(13286 , 10 , "upgrade simulated statistics");
		add(13287 , 10 , "percent cpu busy");
		add(13288 , 10 , "percent i/o busy");
		add(13289 , 10 , "run queue length");
		add(13290 , 10 , "kernel run queue length");
		add(13291 , 10 , "outstanding disk i/os");
		add(13292 , 10 , "disk i/os per second");
		add(13293 , 10 , "network i/os per second");
		add(13294 , 10 , "password decryption failed");
		add(13296 , 10 , "device");
		add(13297 , 16 , "the System Encryption Password");
		add(13298 , 16 , "a login password");
		add(13299 , 16 , "a user-defined password");
		add(13300 , 10 , "percent user busy");
		add(13301 , 10 , "percent system busy");
		add(13302 , 10 , "disk reads per second");
		add(13303 , 10 , "disk writes per second");
		add(13304 , 10 , "network reads per second");
		add(13305 , 10 , "network writes per second");
		add(13306 , 16 , "on");
		add(13307 , 16 , "off");
		add(13308 , 16 , "enable encrypted columns");
		add(13309 , 16 , "enable predicated privileges");
		add(13310 , 16 , "static key");
		add(13311 , 16 , "role activation predicate");
		add(13312 , 16 , "dynamic hash key");
		add(13313 , 16 , "as default");
		add(13314 , 16 , "to login");
		add(13315 , 10 , "DTU");
		add(13316 , 10 , "an ALTER OBJECT MODIFY OWNER statement");
		add(13319 , 16 , "predicated privilege");
		add(13320 , 10 , "reads per second");
		add(13321 , 10 , "writes per second");
		add(13322 , 16 , "privilege");
		add(13323 , 16 , "Minute(s)");
		add(13324 , 16 , "Hour(s)");
		add(13325 , 16 , "Day(s)");
		add(13327 , 10 , "compression info");
		add(13328 , 10 , "object ownership");
		add(13329 , 10 , "threshold");
		add(13330 , 16 , "server logins");
		add(13331 , 16 , "database users");
		add(13332 , 16 , "adding generic user 'usedb_user' to sysusers");
		add(13333 , 10 , "updating builtin permissions");
		add(13334 , 10 , "Adding role sa_serverprivs_role");
		add(13335 , 16 , "replication filter");
		add(13336 , 10 , "cumulative database");
		add(13337 , 10 , "view definition");
		add(13338 , 16 , "GRANT and GRANT ROLE predicates");
		add(13340 , 10 , "not database");
		add(13341 , 10 , "encrypted");
		add(13342 , 10 , "decryption");
		add(13343 , 10 , "decrypted");
		add(13344 , 10 , "encryption");
		add(13345 , 10 , "dual_control");
		add(13347 , 10 , "DUMPED");
		add(13348 , 10 , "LOADED");
		add(13349 , 10 , "PARALLEL");
		add(13350 , 10 , "verifying sysstatistics index data");
		add(13351 , 10 , "encryption or decryption");
		add(13352 , 10 , "encrypted or decrypted");
		add(13353 , 10 , "shrinked");
		add(13354 , 10 , "shrinking");
		add(13355 , 10 , "reorganized");
		add(13356 , 10 , "timeout");
		add(13357 , 10 , "disk fragments pruning");
		add(13358 , 10 , "disk fragments remapping");
		add(13359 , 16 , "start");
		add(13360 , 16 , "LFB");
		add(13361 , 10 , "an arithmetic expression when configuration parameter 'restrict parameter markers' is OFF.");
		add(13362 , 10 , "a case statement when configuration parameter 'restrict parameter markers' is OFF.");
		add(13363 , 10 , "The parameter marker ?");
		add(13364 , 10 , "transaction log");
		add(13365 , 10 , "row store log");
		add(13366 , 16 , "encrypting");
		add(13367 , 16 , "decrypting");
		add(13368 , 16 , "revoke");
		add(13369 , 16 , "lock");
		add(13370 , 16 , "queue");
		add(13371 , 16 , "audit cache");
		add(13372 , 16 , "sequence");
		add(13373 , 16 , "schema");
		add(13375 , 16 , "LIMIT clause");
		add(13377 , 16 , "START WITH");
		add(13378 , 16 , "MAXVALUE");
		add(13379 , 16 , "MINVALUE");
		add(13380 , 16 , "CACHE");
		add(13382 , 16 , "INCREMENT");
		add(13383 , 16 , "scalar type");
		add(13384 , 16 , "table type");
		add(13385 , 16 , "single assign");
		add(13386 , 16 , "Alter database off");
		add(13387 , 10 , "asynchronously");
		add(13388 , 16 , "UNION");
		add(13389 , 16 , "HCB");
		add(13390 , 16 , "external key");
		add(13391 , 16 , "external keystore");
		add(13900 , 10 , "Warning: a default (object id %d) is defined on column '%.*s' being modified. Check the validity of the default value after this ALTER TABLE operation.");
		add(13901 , 10 , "Warning: a rule or constraint is defined on column '%.*s' being modified. Verify the validity of rules and constraints after this ALTER TABLE operation.");
		add(13902 , 10 , "Warning: Column '%.*s' being modified is a key in one or more indexes. Verify the validity of these indexes after this ALTER TABLE operation.");
		add(13903 , 10 , "Warning: primary or foreign keys are defined on column '%.*s' being modified. Verify the validity of the RI constraint after this ALTER TABLE operation.");
		add(13904 , 10 , "Warning: A logical RI constraint, using sp_primarykey/sp_foreignkey exists on column '%.*s' being modified. Verify the validity of the logical RI constraint after this ALTER TABLE operation.");
		add(13905 , 10 , "Warning: no columns to drop, add or modify. ALTER TABLE '%.*s' was aborted.");
		add(13906 , 16 , "ALTER TABLE '%.*s' failed. You cannot add new non-NULL TEXT/IMAGE/UNITEXT or modify to non-NULL TEXT/IMAGE/UNITEXT column '%.*s'. Such columns may only be added as NULL columns.");
		add(13907 , 16 , "ALTER TABLE '%.*s' failed. You cannot modify column '%.*s' to %s %s type.");
		add(13908 , 16 , "ALTER TABLE '%.*s' failed. You cannot add off-row Java/TEXT/IMAGE/UNITEXT column in conjunction with either dropping or modifying such a column.");
		add(13909 , 16 , "ALTER TABLE '%.*s' failed. Both virtual computed column and column of in-row java type are uncompressible.");
		add(13910 , 10 , "Warning: since data is not copied when altering table '%.*s', the specified 'exp_row_size' value will not be honored. Use sp_chgattribute to change the 'exp_row_size' value after this ALTER TABLE operation.");
		add(13911 , 10 , "Warning: when modifying column '%.*s', user specified NULL type overrides the NULL type of user defined datatype '%.*s'.");
		add(13912 , 10 , "Warning: when modifying column '%.*s', the NULL type of the user-defined datatype '%.*s' will be applied to the column.");
		add(13913 , 10 , "Warning: column '%.*s' is referenced by one or more rules or constraints. Verify the validity of the rules/constraints after this ALTER TABLE operation.");
		add(13914 , 16 , "ALTER TABLE '%.*s' failed. You cannot drop column '%.*s' which is referenced in one or more constraints. Drop the constraints before dropping the column.");
		add(13915 , 16 , "ALTER TABLE failed. You cannot add table-level constraints when the operation on table '%.*s' requires data copy. Add the constraints in a separate ALTER TABLE statement.");
		add(13916 , 16 , "ALTER TABLE '%.*s' failed. You cannot add column-level constraints, such as referential integrity or primary key/unique constraints, when the operation requires data copy.");
		add(13917 , 16 , "ALTER TABLE '%.*s' failed. You cannot alter a roundrobin partitioned table with a global placement index when the operation requires data copy. Drop the index and try again.");
		add(13918 , 16 , "ALTER TABLE '%.*s' failed. Default cannot be an expression when adding non-NULL column '%.*s'. Use a default value instead.");
		add(13919 , 16 , "ALTER TABLE '%.*s' failed because the table definition has been changed.");
		add(13920 , 16 , "ALTER TABLE '%.*s' failed. Lock change operation cannot be supported with other operations that do not require data copy.");
		add(13921 , 16 , "ALTER TABLE '%.*s' failed. You cannot drop column '%.*s' on which a primary/foreign key constraint is defined using sp_primarykey or sp_foreignkey. Drop the key definitions before dropping the column.");
		add(13922 , 16 , "ALTER TABLE '%.*s' failed. You cannot modify timestamp column '%.*s'.");
		add(13923 , 16 , "ALTER TABLE '%.*s' failed. You cannot modify the datatype of column '%.*s' to timestamp.");
		add(13924 , 16 , "ALTER TABLE '%.*s' failed. You cannot modify a primary key column to NULL.");
		add(13925 , 10 , "Warning: ALTER TABLE operation%sdid not affect column '%.*s'.");
		add(13926 , 16 , "ALTER TABLE '%.*s' failed. A table with a clustered index cannot be altered if the operation includes a lock scheme change.");
		add(13927 , 16 , "ALTER TABLE '%.*s' failed. You cannot add an identity column to a partitioned table when the operation requires data copy.");
		add(13928 , 16 , "ALTER TABLE '%.*s' failed. You cannot specify a default clause when adding identity column '%.*s'.");
		add(13929 , 16 , "ALTER TABLE '%.*s' failed. You cannot drop identity column '%.*s' when IDENTITY_INSERT or IDENTITY_UPDATE is ON. Set this option OFF before dropping the identity column.");
		add(13930 , 16 , "The procedure '%.*s' contains an ALTER TABLE statement requiring data copy. This should be the only statement in the procedure.");
		add(13931 , 16 , "ALTER TABLE '%.*s' failed. Internal error detected while trying to update SYSCOLUMNS with TEXT/IMAGE/UNITEXT replication status.");
		add(13932 , 16 , "ALTER TABLE '%.*s' failed. You cannot modify column '%.*s' to type '%.*s' which has identity property.");
		add(13933 , 16 , "ALTER TABLE '%.*s' failed. You cannot modify identity column '%.*s' whose datatype is user-defined.");
		add(13934 , 16 , "ALTER TABLE '%.*s' failed. You cannot modify column '%.*s'. You cannot modify a Java column or modify a column to type Java ADT.");
		add(13935 , 16 , "ALTER TABLE '%.*s' failed. You cannot add new non-null Java column '%.*s'. Such columns may only be added as NULL columns.");
		add(13936 , 16 , "ALTER TABLE '%.*s' failed. You cannot alter a partitioned table that has Java columns when the operation requires data copy. To alter the schema, unpartition the table, then repartition it.");
		add(13937 , 10 , "Warning: The schema for table '%.*s' has changed. Drop and re-create each trigger on this table that uses the 'if update(column-name)' clause.");
		add(13938 , 16 , "ALTER TABLE '%.*s' failed. You cannot drop column '%.*s' because it is part of the partition key for the table or index '%.*s'. Drop the index or unpartition the table first.");
		add(13939 , 16 , "ALTER TABLE '%.*s' failed. You cannot modify column '%.*s' because it is part of the partition key.");
		add(13940 , 16 , "One or more column names in the specified table contain reserved words or special characters, for example '%.*s'. Set the QUOTED_IDENTIFIER option to handle the column(s) and re-run the command.");
		add(13941 , 16 , "Cannot partition table '%.*s' because your release level does not support partitioning.");
		add(13942 , 16 , "Failure regenerating partition condition for table '%.*s' index '%.*s'.");
		add(13943 , 16 , "ALTER TABLE '%.*s' failed. This MODIFY operation cannot be performed on computed column '%.*s'.");
		add(13944 , 16 , "ALTER TABLE '%.*s' failed. This MODIFY operation can only be performed on computed columns. Column '%.*s'is not a computed column.");
		add(13945 , 16 , "ALTER TABLE '%.*s' failed. You cannot drop column '%.*s' because it is referenced in one or more computed columns. Drop the computed columns before dropping the column.");
		add(13946 , 16 , "ALTER TABLE '%.*s' failed. You cannot modify column '%.*s' because it is referenced in one or more computed columns. Drop the computed columns before modifying the column.");
		add(13947 , 16 , "ALTER TABLE '%.*s' failed. You cannot '%s' computed column '%.*s'. The new definition cannot reference columns being modified or dropped.");
		add(13948 , 16 , "ALTER TABLE '%.*s' failed. You cannot modify the column that is part of the global clustered index key.");
		add(13949 , 16 , "ALTER TABLE '%.*s' failed. You can only add partitions to range or list partitioned table.");
		add(13950 , 16 , "ALTER TABLE '%.*s' failed. Range partition(s) can only be added to the high end of the existing partition boundaries.");
		add(13951 , 16 , "ALTER TABLE '%.*s' failed. You cannot add partition(s) whose partition type is different from that of the table.");
		add(13952 , 16 , "ALTER TABLE '%.*s' failed. You cannot add new off-row Java/TEXT/IMAGE/UNITEXT computed column '%.*s'.");
		add(13953 , 16 , "ALTER TABLE '%.*s' failed. Virtual computed column '%.*s' must be nullable.");
		add(13954 , 16 , "ALTER TABLE '%.*s' failed. You cannot modify column '%.*s' to be a materialized off-row Java/TEXT/IMAGE/UNITEXT computed column.");
		add(13955 , 16 , "ALTER TABLE '%.*s' failed. You cannot modify computed column (%.*s) to be virtual when it is an index key.");
		add(13956 , 16 , "ALTER TABLE '%.*s' failed. Repartition with rebuilding index is not supported when partition type changes. Drop the indexes before repartition.");
		add(13957 , 16 , "ALTER TABLE '%.*s' failed. Repartition with rebuilding index is not supported when partition key changes. Drop the indexes before repartition.");
		add(13958 , 16 , "ALTER TABLE '%.*s' failed. You cannot specify different segment for different partitions when repartition with global placement index.");
		add(13959 , 10 , "Warning: During repartition, the name and segment associated with the old local index partitions will be lost, and regenerated for the new index partitions from information specified at index level.");
		add(13960 , 16 , "Column '%.*s' can not be decrypted because it is not currently encrypted.");
		add(13961 , 16 , "An internal buffer is not big enough for the number of encrypted or uncompressed columns in the altered table.");
		add(13962 , 16 , "ALTER TABLE '%.*s' failed. In order to encrypt the indexed column '%.*s' you must specify a key defined for use without an initialization vector or data padding.");
		add(13963 , 16 , "ALTER TABLE '%.*s' failed. Unpartition is not supported on tables with indexes. Drop the indexes and retry. Or, use the ALTER TABLE ... PARTITION BY command to relocate the data and create an unpartitioned table.");
		add(13964 , 16 , "ALTER TABLE '%.*s' failed. Unpartition operation is only permitted on roundrobin partitioned tables. Table is partitioned by %s. Use the ALTER TABLE ... PARTITION BY command to create an unpartitioned table. This will involve data relocation.");
		add(13965 , 16 , "ALTER TABLE '%.*s' failed. You cannot unpartition a table when its partitions are bound to different segments. Use the ALTER TABLE ... PARTITION BY command to move the data to one segment and unpartition the table.");
		add(13966 , 16 , "ALTER TABLE '%.*s' failed. You can only drop partitions from range or list partitioned table.");
		add(13967 , 16 , "ALTER TABLE '%.*s' failed. You cannot drop a partition more than once.");
		add(13968 , 16 , "ALTER TABLE '%.*s' failed. You cannot drop all partitions of a table.");
		add(13969 , 21 , "ALTER TABLE '%.*s' drop partition failed. Partition condition with partitionid %d not found for indid %d.");
		add(13970 , 16 , "Object '%.*s' is not a trigger associated with table '%.*s'.");
		add(13971 , 16 , "Could not drop partition with data from table '%.*s', because there are referential constraints defined on the table and there are data rows in some of the referencing tables.");
		add(13972 , 16 , "Cannot run ALTER TABLE on table '%.*s' as ALTER TABLE is not supported on virtually hashed tables.");
		add(13973 , 10 , "Warning: a decrypt_default is defined on column '%.*s' being modified. Check the validity of the decrypt_default value after this ALTER TABLE operation.");
		add(13974 , 16 , "You may not declare a decrypt_default on column '%.*s' because that column is not encrypted.");
		add(13975 , 16 , "You may not declare a null-valued decrypt_default on column '%.*s' because that column is not nullable.");
		add(13976 , 16 , "Failed to drop a decrypt_default on column '%.*s' because no decrypt_default has been declared on that column.");
		add(13977 , 10 , "Warning: unable to alter the proxy table in the HA companion server. You can recreate the proxy database by issuing the following command from the companion server: alter database <dbname> for proxy_update.");
		add(13978 , 11 , "Ownership change failed. User '%.*s' does not own %S_MSG '%.*s'.");
		add(13979 , 11 , "Ownership change failed. User '%.*s' does not own any objects with type '%S_MSG' in the current database, or no change is needed.");
		add(13980 , 16 , "Ownership change on system table '%.*s' failed. You cannot change the ownership of a system table.");
		add(13981 , 16 , "Ownership change failed. The owner of object '%.*s' can only be changed by modifying the owner of the parent table/view.");
		add(13982 , 16 , "Ownership change failed. The new owner '%.*s' already owns an object with name '%.*s'.");
		add(13983 , 11 , "Ownership change failed. User '%.*s' does not own any objects in the current database, or no change is needed.");
		add(13984 , 16 , "Ownership change failed. Adaptive Server cannot access object '%.*s' in the current database.");
		add(13985 , 16 , "Ownership change of %ld out of %ld objects failed. Use sp_helpuser or sp_help to identify them, and retry the command.");
		add(13986 , 16 , "Ownership change of object '%.*s' failed. See previous messages for more information.");
		add(13987 , 16 , "ALTER TABLE '%.*s' merge partition failed. The partitions being merged must be on the same segment.");
		add(13988 , 16 , "ALTER TABLE '%.*s' failed. You cannot modify datatype of column (%.*s) to '%.*s' when it is an index key.");
		add(13991 , 16 , "User '%.*s' does not own user-defined datatype '%.*s' in the current database.");
		add(13992 , 16 , "User '%.*s' does not own any user-defined datatypes in the current database.");
		add(13993 , 16 , "Cannot transfer object ownership to user '%.*s'.");
		add(13994 , 16 , "Cannot use wild-card '*' to alter dbo-owned objects.");
		add(13998 , 16 , "Ownership change failed. With LOGINAME ONLY specified, the new owner must have the same user identity in the database as the current owner.");
		add(13999 , 16 , "User name '%.*s' is not a valid user in the current database.");
		add(14001 , 10 , "per object statistics active determines whether the Adaptive Server will collect monitoring information on a per object basis");
		add(14002 , 16 , "The configuration option 'dtm detach timeout period' specifies the timeout period in minutes, for detached transactions. Transactions that are detached longer than this timeout period will be rolled back.");
		add(14003 , 10 , "The 'abstract plan load' option enables the server wide Abstract Plan LOAD mode from ap_stdin.");
		add(14004 , 10 , "The 'abstract plan dump' option enables the server wide Abstract Plan DUMP mode to ap_stout.");
		add(14005 , 10 , "The 'abstract plan replace' option enables the server wide Abstract Plan REPLACE sub-mode.");
		add(14006 , 10 , "The 'abstract plan cache' option enables the server wide Abstract Plan EXISTS CHECK cache sub-mode.");
		add(14007 , 10 , "'enable HA' lets you enable or disable HA services in Adaptive Server. The default value is 0 (disabled). This is a static option, meaning that you have to restart the server after changing the value.");
		add(14008 , 10 , "Enables Unicode data to be normalized, that is re-written in canonical form. Once disabled, cannot be re-enabled. Default is enabled.");
		add(14009 , 10 , "Changes the default sort order for Unicode (unichar/univarchar) data. Default is 'binary'.");
		add(14010 , 10 , "number of open partitions sets the maximum number of partitions that can be open at one time on Adaptive Server. The default value is 500.");
		add(14011 , 10 , "open partition hash spinlock ratio specifies the number of internal hash table for open partitions protected by one spinlock. The default value is 100.");
		add(14012 , 10 , "open partition spinlock ratio specifies the number of open partitions protected by one spinlock. The default value is 100.");
		add(14013 , 10 , "Enables processing of Unicode surrogates, guaranteeing the integrity of surrogate pairs. When disabled, surrogates are ignored. Default is disabled.");
		add(14014 , 16 , "max memory sets the maximum size of memory, in 2K units, that ASE can allocate.");
		add(14015 , 16 , "procedure cache size specifies the amount of memory allocated to the procedure cache.");
		add(14016 , 16 , "dynamic allocation on demand specifies whether ASE memory can be allocated on demand due to reconfiguration of dynamic configuration parameters.");
		add(14017 , 16 , "allocate max shared memory specifies whether ASE allocates all the memory specified by 'max memory' at any one time.");
		add(14018 , 16 , "number of engines at startup specifies the number of engines ASE brings online during the startup process.");
		add(14019 , 10 , "The amount of heap memory in bytes for each user connection.");
		add(14020 , 10 , "Enables row level access control facility. Default is disabled.");
		add(14021 , 10 , "Enables SSL facility. Default is disabled.");
		add(14022 , 16 , "total physical memory is a read-only parameter that indicates the size of the physical memory allocated by ASE so far. It is not user-configurable.");
		add(14023 , 10 , "The 'number of histogram steps' option specifies the default number of histogram steps for update statistics and create index.");
		add(14024 , 10 , "The 'sampling percent' option specifies the default percentage of a table's rows to be sampled by UPDATE STATISTICS of non-indexed columns and inner columns of composite indexes.");
		add(14025 , 10 , "Allows monitoring by the 'ASE Performance Monitoring Option' product. Default is disabled.");
		add(14026 , 10 , "Enables ASE super features. Default is disabled.");
		add(14028 , 10 , "i/o batch size sets the number of writes issued in a batch before the task goes to sleep. Once the batch is completed the task is woken up and the next batch of writes are issued.");
		add(14029 , 10 , "Statement cache size specifies the amount of memory Adaptive Server allocates to save the query plans of ad hoc SQL statements for reuse.");
		add(14030 , 16 , "The percentage of space in the sybmgmtdb database that may be used for storing job history.");
		add(14031 , 16 , "This value is a percentage of the space allowed for job history in the sybmgmtdb database. When sp_sjobclean is run or the threshold sp_js_history_thresh activated, job history is deleted so that this percentage of the space for job history is unused.");
		add(14032 , 16 , "The percentage of space in the sybmgmtdb database that may be used for job output.");
		add(14033 , 16 , "The maximum amount of job output that may be recorded by any running job. Output is discarded when the limit is reached.");
		add(14034 , 16 , "This value is a percentage of the space allowed for job output in the sybmgmtdb database. When sp_sjobclean runs or the threshold sp_js_history_thresh is activated, job output is deleted so that this percentage of the space for job output is unused.");
		add(14035 , 16 , "The size of the extended histogram is established by multiplying the number of steps with the 'histogram tuning factor' value. This is compressed to a regular histogram without affecting the high frequency cells.");
		add(14036 , 16 , "Changes the default sort order for unicode Xml data. Default is 'binary'.");
		add(14037 , 10 , "Enable/Disable statement cache monitoring. Default is 0.");
		add(14038 , 10 , "The 'enable sql debugger' enables or disables sql debugger services in Adaptive Server. The default value is 1 (enabled). This is a static option, meaning that the server have to be restarted after changing the config value to get the desired effect.");
		add(14039 , 10 , "The 'max nesting level' configuration parameter sets the maximum allowed nesting level for stored procedures and triggers.");
		add(14040 , 10 , "0 - automatic master key access is disabled (default). 1 - automatic master keyaccess is enabled.");
		add(14041 , 10 , "Enable FIPS 140-2 certified module for login password encryption. Default is disabled.");
		add(14042 , 10 , "Choose how string arguments are converted to dates in builtins. When 0, strings are converted to 'datetime'. When 1, strings are converted to 'bigdatetime'.");
		add(14043 , 16 , "GC free lock ratio defines the minumum pro-active free lock ratio to trigger pro-active GC. When the free lock ratio is less than this value, the pro-active GC will run. The default value is 25.");
		add(14044 , 10 , "The 'idle timeout' parameter specifies the number of microseconds idle threads in a thread pool will spin before going to sleep.");
		add(14045 , 10 , "The configuration parameter 'enable deferred parallel' enables/disables the deferred optimization mechanism to compile queries in parallel mode. The default value is 0 (disabled).");
		add(14046 , 16 , "CIPC regular message pool size : The parameter 'CIPC regular message pool size' indicates number of free messages in CIPC regular message pool.");
		add(14047 , 16 , "CIPC large message pool size : The parameter 'CIPC large message pool size' indicates number of free messages configured in 'CIPC large message pool");
		add(14048 , 16 , "DMA object pool size : The parameter 'DMA object pool size' indicates number of DMA messages in CIPC DMA object pool.");
		add(14049 , 10 , "CIS idle timeout specifies");
		add(14050 , 10 , "deadlock retries specifies the number of times a transaction will retry to acquire a lock after it has become a deadlock victim.");
		add(14051 , 10 , "Enable use of HP Posix asynchronous I/O. The default value is 0. This option takes effect only on HPUX platform. It will be ignored on other platforms.");
		add(14052 , 10 , "Enable the memory dump compression. Possible values are 0-9. 0 means dump without compression. 1-9 means dump with different compression level. Here, 1 means best speed and 9 means best compression.");
		add(14053 , 10 , "Execution time monitoring specifies whether the Adaptive Server will collect monitoring data for query categories execution time.");
		add(14054 , 10 , "Control ASE to boot with HugePages on Linux. Possible values are 0-2. 0 (DEFAULT) means use HugePages if possible, else use regular pages. 1 means only use regular pages. 2 means only use HugePages.");
		add(14055 , 10 , "Control ASE to boot with ISM on Solaris. Possible values are 0-2. 0 (DEFAULT) means use ISM if possible, else use regular shared memory. 1 means only use regular shared memory. 2 means only use ISM.");
		add(14056 , 10 , "This parameter allocates additional physical locks which are needed to prevent out of lock conditions. Configure it between 0 and 100 to either not allocate additional locks or to allocate up to the maximum additional physical locks needed.");
		add(14057 , 16 , "Solaris Async IO mode: 0) DEFAULT -- Solaris AIO using aiowait, 1) Solaris AIO using event port, requires OS patch with fix to BugID 15868517.");
		add(14058 , 10 , "Threshold event monitoring specifies whether the Adaptive Server will collect monitoring data for query threshold event.");
		add(14059 , 10 , "Threshold event max messages specifies the maximum number of messages that can be stored for threshold event.");
		add(14060 , 10 , "It specifies the optimization goal when creating the initial plan and initializing the baseline learning object for auto query tuning.");
		add(14061 , 10 , "It specifies the optimizer version when creating the initial plan and initializing the baseline learning object for auto query tuning.");
		add(14062 , 10 , "This parameter is applicable only to databases which have in memory row storage enabled. The value indicates default number of IMRS Garbage Collector tasks which will be spawned during server start or when such database is brought online.");
		add(14063 , 10 , "This parameter is applicable only to databases which have in memory row storage enabled. The value indicates default number of LOB Version Garbage Collector tasks which will be spawned during server start or when such database is brought online.");
		add(14065 , 10 , "The configuration option enables or disables workload analyzer feature. The default value is 0 (disabled).");
		add(14066 , 10 , "Enables ASE1254 optimizer and execution engine while creating the initial plan and initializing the baseline learning object when the 'auto query tuning' option is enabled.");
		add(14067 , 10 , "The time delay in minutes after which job scheduler will try to restart its chores.");
		add(14068 , 10 , "Option to enable/disable snapshot isolation scans for new connections.");
		add(14069 , 16 , "This parameter is applicable only to databases which have in memory row storage enabled. The value indicates default number of IMRS PACK tasks which will be spawned during server start or when such database is brought online.");
		add(14070 , 10 , "The 'abstract plan dynamic replace' option enables the server wide Abstract Plan DYNAMIC REPLACE mode.");
		add(14071 , 16 , "nonpushdown pipe active indicates whether the Adaptive Server will collect historical nonpushdown statement information for SQL statements sent to HANA.");
		add(14072 , 16 , "nonpushdown pipe max messages specifies the maximum number of messages that can be stored in the MDA historical nonpushdown statement table for SQL statements sent to HANA.");
		add(14073 , 10 , "This parameter is applicable only to databases which have in memory row storage enabled. The value defines percentage of memory utilization for IMRS cache which server tries to maintain.");
		add(14074 , 10 , "This parameter is applicable only to databases which have in memory row storage and snapshot isolation enabled. This value defines maximum number of internal re-executions allowed upon getting any write-conflicts. The DEFAULT is -1 meaning no limits.");
		add(14075 , 10 , "If this configuration is enabled, the SQLText in MDA monProcessSQLText will show the compiling statements that reference local variables or temporary tables inside a stored procedure instead of the stored procedure itself.");
		add(14076 , 10 , "This parameter is applicable only to databases which contains hash indexes. The value indicates default number of Hash Index Garbage Collector tasks which will be spawned during server start or when such database is brought online.");
		add(14077 , 10 , "This parameter is applicable only to MVCC enabled databases. The value indicates the time in seconds after which the transaction running at snapshot isolation will timeout.");
		add(14078 , 10 , "This parameter enables Kerberos administrators to pass the caller's password as null in order to reset the login password using the alter login command. The default is 0 (disabled).");
		add(14100 , 21 , "Partition row for %S_PTNINFO not found.");
		add(14101 , 21 , "Insert of syspartition row failed.");
		add(14102 , 21 , "Delete of syspartitions row failed.");
		add(14103 , 21 , "Invalid setup status found in syspartition Manager during a call to: %s.");
		add(14104 , 21 , "No object id specified in syspartitions Manager call to: %s.");
		add(14105 , 21 , "Lookup during syspartitions management failed for %S_PTNINFO.");
		add(14106 , 21 , "Copy of syspartition row failed.");
		add(14107 , 20 , "Invalid partition descriptor field (%d) (%d) for %S_OBJINFO specified.");
		add(14108 , 21 , "Could not find partition descriptor for objid %d, indid %d, ptnid %d in dbid %d.");
		add(14109 , 20 , "Could not install partition descriptor for objid %d, indid %d, ptnid %d in db id %d.");
		add(14110 , 20 , "Invalid input to syspartition manager. Expected valid session descriptor for syspartition system table.");
		add(14111 , 21 , "Ptnid mismatch between partition descriptor 0x%x (ptnid %d) and page 0x%x (ptnid %d) for objid %d in dbid %d.");
		add(14112 , 21 , "Expected index descriptor to be set for objid %d in dbid %d.");
		add(14113 , 21 , "Couldn't find an available partition descriptor for system objects.");
		add(14114 , 26 , "Partition descriptor 0x%x is already installed on the hash table for objid %d, ptnid %d in dbid %d.");
		add(14115 , 20 , "Object with objid %d in dbid %d is not a table.");
		add(14116 , 10 , "Did not find table descriptor linked to process slot structure 0x%x when ASE tried to release it.");
		add(14117 , 20 , "Invalid transaction descriptor passed to the syspartitions manager internal function.");
		add(14118 , 20 , "Invalid index descriptor passed to the syspartition manager internal function.");
		add(14119 , 20 , "Index descriptor (0x%x) for objid %d in dbid %d is already linked to another transaction.");
		add(14120 , 26 , "Expected to find the partition descriptor for objid '%d' indid '%d' ptnid '%d' in dbid '%d', in a '%s' state (found state '%d' instead).");
		add(14121 , 26 , "Partition descriptor found was not expected to be in a %s state.");
		add(14122 , 20 , "Update failed. ASE could not find field '%d' within partition descriptor/buffer.");
		add(14123 , 21 , "Updating wrong ptnrow in dbid %d. Objid for actual row updated is %d, objid for intended row was %d. Partition id for intended row was %d. Partition page is %u, field updated is %d. Partition row address is 0x%x, row number is %d.");
		add(14124 , 20 , "The to be installed PDES existed already. Dbid %d, objid %d, partition id %d, state %d.");
		add(14125 , 20 , "Internal error occurred while running the sysindexes exerciser.");
		add(14126 , 17 , "Couldn't find an available partition descriptor. Raise the value of the configuration parameter 'number of open partitions' for more partition descriptors.");
		add(14127 , 16 , "Cannot drop or modify partition descriptor %S_PTNINFO as it is in use. Please retry your command later. Total reference count '%d'. Task reference count '%d'.");
		add(14128 , 16 , "Cannot install a partition descriptor for objid %d as a dbshutdown for the dbid %d is in progress.");
		add(14129 , 20 , "Update to syspartitions row for %S_PTNINFO failed.");
		add(14130 , 16 , "Cannot run '%s' on table '%.*s' because semantic partitioning is not enabled. A user with System Administrator (SA) role must reconfigure '%s' to 1.");
		add(14131 , 17 , "Could not allocate a local hash table for '%S_INDINFO'. Raise the value of configuration parameter 'procedure cache size'.");
		add(14132 , 21 , "Could not find partition descriptor for objid %d, indid %d, dataptnid %d in dbid %d.");
		add(14133 , 21 , "Could not find partition descriptor for objid %d, indid %d, partition '%.*s' in dbid %d.");
		add(14200 , 16 , "The specified java signature is invalid.");
		add(14201 , 16 , "Return type of the java method for a SQLJ procedure must be void or int.");
		add(14202 , 16 , "The Java 'main' method cannot return result sets.");
		add(14203 , 16 , "Invalid mapping between the SQLJ procedure signature and the signature of the Java command line 'main' method.");
		add(14204 , 16 , "The specified return type does not map to the java method return type.");
		add(14205 , 16 , "The Java 'main' method cannot be used in CREATE FUNCTION.");
		add(14206 , 10 , "Warning: SQLJ procedure is trying to return more result sets than were specified in DYNAMIC RESULT SETS clause (%d). Only %d result sets are returned.");
		add(14207 , 16 , "Incorrect number of parameters for SQLJ function '%.*s'.");
		add(14208 , 16 , "Unable to execute SQLJ function '%s'. The function schema may have changed since the query was compiled.");
		add(14209 , 16 , "Unable to load the method '%.*s' for SQLJ function '%s' at execution time. The method schema may have changed since the function was compiled.");
		add(14210 , 16 , "SQLJ functions do not support TEXT/IMAGE/UNITEXT return types. Use the ADT type java.io.InputStream.");
		add(14211 , 16 , "The method signature of Java method '%s' exceeds the maximum size of %d.");
		add(14212 , 16 , "Cannot find a public method named '%.*s, ResultSets[], ...)' in class '%.*s'. Either the method does not exist, or it is being called with incorrect argument types.");
		add(14213 , 16 , "Java method '%s' has too many parameters. The maximum number is %d.");
		add(14214 , 16 , "SQLJ procedures cannot return a result set from temporary tables to the ASE JDBC client.");
		add(14215 , 16 , "SQLJ procedures can only return result sets created with ASE JDBC driver.");
		add(14216 , 16 , "Function '%.*s' not found. If this is a SQLJ function or SQL function, use sp_help to check whether the object exists (sp_help may produce a large amount of output).");
		add(14217 , 16 , "SQL function not found. If you are attempting to call a java UDF, Java services are not enabled.");
		add(14218 , 16 , "Cannot create or execute a SQLJ UDF, because Java services are not enabled.");
		add(14300 , 16 , "Cannot use duplicate column names in partition key list. Column name '%.*s' listed more than once.");
		add(14301 , 16 , "Column '%.*s' -- Cannot partition on a column of TEXT, IMAGE or UNITEXT data type.");
		add(14302 , 16 , "Column '%.*s' -- Cannot partition on a column of BIT data type.");
		add(14303 , 16 , "Column '%.*s' -- Cannot partition on a column that has a Java-SQL class datatype.");
		add(14304 , 16 , "Partition '%.*s' -- Partition condition not in incremental order.");
		add(14305 , 16 , "Partition '%.*s' -- #%d upperbound value overflow.");
		add(14306 , 16 , "Partition '%.*s' -- #%d upperbound value underflow.");
		add(14307 , 16 , "Partition '%.*s' -- %d upperbounds expected, but %d specified.");
		add(14308 , 20 , "Attempt to insert a row in syspartitionkeys failed.");
		add(14309 , 20 , "Attempt to delete a row in syspartitionkeys failed.");
		add(14310 , 20 , "Attempt to drop a partition condition failed.");
		add(14311 , 16 , "Partition value %s not compatible with the partition key datatype.");
		add(14312 , 16 , "Duplicate values not allowed for list partition.");
		add(14313 , 21 , "Partition condition for object %d, indid %d, ptncondid %d was not found in database %d.");
		add(14314 , 16 , "Column '%.*s' -- Cannot partition on a computed/encrypted column.");
		add(14315 , 20 , "Error while inserting text into %s for partition condition %d in database %d for table %d, indid %d.");
		add(14316 , 19 , "The number field in syscomments for partition condition %d in database %d for table '%.*s' indid %d has exceeded the %d limit.");
		add(14317 , 20 , "Error while reading text from %s for partition condition %d in database %d for table %d, indid %d.");
		add(14318 , 16 , "Failed to lock the partition condition %d in database %d for table %d. Re-run your command when there are fewer active users on the table.");
		add(14400 , 10 , "number of HBC connections setts the maximum number of simultaneous Host Based Communication connections.");
		add(14401 , 10 , "This configuration option enables or disables capture compression statistics feature. The default value is 0 (disabled).");
		add(14402 , 10 , "The configuration option 'send doneinproc tokens' sets the level for doneinproc token transmission. A value of 0 means send doneinproc tokens only for SELECT statements, and 1 means always send doneinproc tokens.");
		add(14403 , 10 , "Enables XML functionality within ASE.");
		add(14404 , 10 , "Enables Web Services functionality within ASE.");
		add(14405 , 10 , "Enables Job Scheduler Task functionality within ASE.");
		add(14406 , 10 , "max repartition degree is the maximum degree to which a table can be partitioned for parallel execution of relational operations like scans, joins, aggregations etc.");
		add(14407 , 10 , "max resource granularity is the maximum percentage of resources in the system that can be allocated to a query.");
		add(14408 , 10 , "optimization goal is a hint to the query optimizer to generate plans targeted towards the specified goal. The default optimization goal is allrows_mix.");
		add(14409 , 10 , "messaging memory allocates memory for use by the Real Time Messaging Service. The memory pool is shared across all sessions.");
		add(14410 , 10 , "Enables Real Time Messaging Services within ASE.");
		add(14411 , 16 , "0 - LDAP authentication is disabled (default). 1 - Fails over syslogins authentication when LDAP fails. 2 - Strict LDAP authentication for logins that are setup to use LDAP.");
		add(14412 , 16 , "0 - PAM authentication is disabled (default). 1 - Fails over syslogins authentication when PAM fails. 2 - Strict PAM authentication for logins that are setup to use PAM.");
		add(14413 , 16 , "extended cache size");
		add(14414 , 10 , "The compression information pool size parameter indicates the amount of memory currently available to store table compression information.");
		add(14415 , 10 , "The configuration option enables or disables compression feature. The default value is 0 (disabled).");
		add(14416 , 10 , "query optimization timeout limit is the maximum percentage of estimated query execution time that may be allocated to the optimization of the query");
		add(14417 , 10 , "max concurrently recovered db sets the limit of the number of databases recovered concurrently. The default value is 0.");
		add(14418 , 10 , "Number of dump threads indicates the number of native threads used to dump the shared memory. It can be any value between 1 and 8.");
		add(14419 , 10 , "The value 'max number of native threads per engine' is the maximum of native threads that will be spawned per engine. When this limit is reached, further attempts to spawn native threads are suspended until a different native thread completes.");
		add(14420 , 10 , "The value 'rtm thread idle wait period' is the idle wait timeout value (in seconds) for a real time messaging thread. When a timeout occurs, the native thread is faded out.");
		add(14421 , 10 , "0 - encrypted columns is disabled (default). 1 - encrypted columns is enabled.");
		add(14422 , 10 , "The value 'number of Q engines at startup' is the number of external engines for MQ messaging that are automatically started at server start-up.");
		add(14423 , 10 , "The value 'max online Q engines' is the maximum number of external Q engines that are allowed in a multiprocessor environment.");
		add(14424 , 10 , "The 'sysstatistics flush interval' parameter sets the minimum interval, in minutes, between sysstatistics flushes by housekeeper. A value of '0' disables sysstatistics flushing by housekeeper.");
		add(14425 , 16 , "enable semantic partitioning' lets you enable or disable range/hash/list partitioning in the Adaptive Server. The default value is 0 (disabled). This is a dynamic option.");
		add(14426 , 10 , "This value defines the size of the memory pool from which buffers are taken in order to read an archive database that has been loaded with a compressed dump. The memory pool is shared by all sessions.");
		add(14427 , 10 , "This option lets you enable or disable logins without sa_role before recovery of user databases is complete during boot time. Logins with sa_role are always allowed to login. The default value is 1 (enabled). This is a dynamic option.");
		add(14428 , 10 , "stored procedure optimization timeout limit is the maximum percentage of estimated execution time for a stored procedure that may be allocated to the optimization of the stored procedure");
		add(14429 , 10 , "The 'start xp server during boot' is to enable automatic start of the xp server during Adaptive Server boot. This is a static option. The default value is 0. When the parameter is set to 1, xp server is booted when Adaptive Server is booted.");
		add(14430 , 10 , "session tempdb log cache size specifies the size (in bytes) for each user's log cache for it's tempdb.");
		add(14431 , 10 , "The 'enable lock remastering' parameter enables or disables lock remastering in a cluster. By default, the parameter is disabled(0).");
		add(14432 , 10 , "The configuration parameter 'min pages for parallel scan' refers to a minimum number of pages required in a table or an index for it to be scanned in parallel.");
		add(14433 , 10 , "The configuration parameter 'prod-consumer overlap factor' refers to the percentage overlap between a producer and a consumer plan fragment in terms of parallelism.");
		add(14434 , 10 , "The configuration parameter 'enable literal autoparam' enables/disables the auto-parameterization of literals in ad-hoc queries. The default value is 1 (enabled).");
		add(14435 , 10 , "The 'workload manager cache size' parameter specifies the maximum amount of memory, in 2K units, that can be used by the workload manager.");
		add(14436 , 16 , "The value 0 allows the client to determine whether to use encryption, 1 requires use of one of the encryption algorithms, and 2 requires use of strong encryption of the password. 0 is the default.");
		add(14437 , 10 , "identity reserve size allows each ASE process to reserve a block of IDENTITY column values for inserts into tables that have an IDENTITY column.");
		add(14438 , 16 , "sort level for the default sortorder. 1 - enables fast comparison by assuming strings with different lengths are unequal. 2 - disables fast comparison when strings with different lengths can be equal. 4 - enables Unicode 5.1.");
		add(14439 , 10 , "0 - restricted decrypt permission is disabled (default). 1 - restricted decrypt permission is enabled.");
		add(14440 , 10 , "ASE will maintain a baseline of good query plans and query execution metrics for all queries that have executed, and remember any bad query plans that have executed, so that ASE can automatically avoid executing bad query plans (default 0).");
		add(14441 , 10 , "Only applicable when the 'auto query tuning' option is enabled and a best plan exists, this will limit the procedure cache used by a query compilation to the 'max resource granualarity' percentage, and use the current best plan when this is exceeded.");
		add(14442 , 10 , "Only applicable when 'auto query tuning' option enabled and a best plan exists, this will limit a query compilation to the 'optimization timeout limit' percentage of average execution time, and use the current best plan when this is exceeded.");
		add(14443 , 10 , "Only applicable when 'auto query tuning' option is enabled, this value determines the number of times a query plan is executed before it can be considered a good query plan or a bad query plan (default 3).");
		add(14444 , 10 , "Configuration parameter 'enable merge join' can be used to enable/disable merge_join at server level. Default value of 'enable merge join' depends on current optimization goal setting.");
		add(14445 , 10 , "If the logical IO of this query is less than value of this configuration parameter, then the query metrics associated with this query will not be written to the catalogs.");
		add(14446 , 10 , "If the physical IO of this query is less than value of this configuration parameter, then the query metrics associated with this query will not be written to the catalogs.");
		add(14447 , 10 , "If the elapsed time of this query is less than value of this configuration parameter, then the query metrics associated with this query will not be written to the catalogs.");
		add(14448 , 10 , "If the execution time of this query is less than value of this configuration parameter, then the query metrics associated with this query will not be written to the catalogs.");
		add(14449 , 10 , "The 'maximum buffers per lava operator' sets an upper bound on the number of buffers that can be claimed/allocated per sort-hash operator in a query statement. This value can have a secondary effect on system resources.");
		add(14451 , 10 , "This option lets you enable or disable high availability backup server. Adaptive Server will start Backup Server automatically when enabled at dump / load command request. The default value is 1 (enabled). This is a dynamic option.");
		add(14452 , 10 , "The 'enable i/o fencing' parameter enables/disables I/O fencing functionality on all database devices. The default value is 0 (disable).");
		add(14453 , 10 , "The 'cluster heartbeat interval' parameter specifies the number of seconds between cluster heartbeats.");
		add(14454 , 10 , "The 'quorum heartbeat interval' parameter specifies the number of seconds between heartbeat writes to the cluster quorum device.");
		add(14455 , 10 , "The 'quorum heartbeat retries' parameter specifies the number of times Adaptive Server retries a failed quorum heartbeat before shutting down.");
		add(14456 , 10 , "The 'automatic cluster takeover' parameter enables or disables the Adaptive Server ability to automatically boot as a cluster coordinator following an abrupt cluster shutdown.");
		add(14457 , 10 , "The 'cluster heartbeat retries' parameter specifies the number of times Adaptive Server retries a failed cluster heartbeat before entering a voting phase.");
		add(14458 , 10 , "The 'cluster vote timeout' parameter specifies the maximum number of seconds Adaptive Server waits during the cluster voting phase.");
		add(14459 , 10 , "Configuration parameter 'mnc_full_index_filter' can be used to enable/disable mnc_full_index_filter at server level. Default value of 'mnc_full_index_filter' depends on current optimization goal setting.");
		add(14460 , 10 , "Use the configuration parameter 'capture missing statistics' to enable or disable capturing of missing statistics information at the server level. The default value is 0 (disabled).");
		add(14461 , 10 , "This parameter enables or disables runtime compilation of procedural statements. Changing the current value may cause currently cached procedure plans to be recompiled.");
		add(14462 , 10 , "Enable or disable auto generation of statistics for temp tables at the first optimizable query after the table is populated with rows. The default value is 0 (disabled).");
		add(14463 , 10 , "This parameter indicates the Adaptive Server Enterprise optimizer version that will be used to perform query optimization.");
		add(14464 , 10 , "This parameter allows the search engine to expand its internal tick rate non-linearly. This is especially useful if the search space is likely to encounter many illegal plans (ie Outer Joins). Configure it to 0 leave the increment linear.");
		add(14466 , 16 , "cluster redundancy level' is the maximum number of nodes that can simultaneously fail for recovery to proceed concurrently with other activity. The cluster shuts down if the failed number of nodes exceeds the maximum.");
		add(14467 , 10 , "The value of 'max query parallel degree' is the maximum number of worker processes allowed per query when forced to use abstract plans while the system is configured to run in serial mode.");
		add(14468 , 10 , "The value of 'number of backup threads' is the maximum number of user connections that Backup Server can consume to perform a dump or a load of an in-memory database. The value must be equal to the number of stripes plus one.");
		add(14469 , 10 , "config file version is a unique number to track the latest copy of the configuration file. It is used when cluster runs under 'private' mode.");
		add(14470 , 10 , "The 'deferred name resolution' parameter determines whether dependent objects in a stored procedure are resolved when the procedure is created, or when it is executed.");
		add(14471 , 10 , "max transfer history' determines how many table transfer history records ASE retains for each table, for successful transfers and for failed transfers.");
		add(14472 , 10 , "number of threads controls the number of threads in a thread pool when that thread pool is created.");
		add(14473 , 10 , "enables/disables console logging. The default is 0 (console logging disabled).");
		add(14474 , 10 , "disk threads controls how many threads in the thread pool will be created to perform disk I/O polling. These threads are in addition to the threads defined in the number of threads configuration option for the thread pool.");
		add(14475 , 10 , "network threads determines the number of threads in the thread pool that should be used to perform network I/O polling. These threads are created in addition to the threads created by setting the number of threads configuration variable.");
		add(14476 , 10 , "kernel mode controls the mode of kernel to use, this controls the use of seperate processes for each engine or native threads within a single process.");
		add(14477 , 10 , "Enable predicated privileges. Default is disabled.");
		add(14479 , 10 , "enable file access enables access through proxy tables to the External File System.");
		add(14480 , 10 , "cis bulk insert array size specifies the block size Open Client uses to transfer data. The default is 50 rows, and the property is dynamic, allowing it to be changed without server reboot.");
		add(14481 , 10 , "enable full-text search enables the Enhanced Full-Text Search services.");
		add(14482 , 10 , "Enable granular permissions. Default is disabled.");
		add(14483 , 10 , "The 'job scheduler tasks' parameter sets the maximum number of jobs that can run simultaneously through Job Scheduler.");
		add(14484 , 10 , "The 'job scheduler interval' parameter sets the interval at which the Job Scheduler checks scheduled jobs that are due to be executed.");
		add(14485 , 10 , "The 'number of checkpoint tasks' parameter configures parallel checkpoints. The max value is limited by the value of 'number of engines at startup' and 'number of open databases', with a max of 8. The default value is 1, which implies serial checkpoints.");
		add(14486 , 16 , "The pci memory size parameter indicates the amount of memory currently available for use as a data cache for the PCI subsystem.");
		add(14487 , 16 , "The max pci slots parameter specifies the maximum number of slots available to the PCI subsystem for additional PCA plug-in use.");
		add(14488 , 16 , "The pci enable parameter enables the PCI subsystem which can be used to run PCA plug-ins. By default, pci enable is disabled.");
		add(14489 , 16 , "The number of java sockets parameter indicates the number of network sockets available to the Kona Java VM.");
		add(14490 , 10 , "This parameter enables or disables Distributed Transaction Management (DTM) feature. When DTM is enabled, you can use Adaptive Server as a resource manager in X/Open XA, MSDTC, and ASTC systems.");
		add(14491 , 10 , "Capture query metrics to system catalogs.");
		add(14492 , 10 , "Cost of a single logical I/O (used in new optimizer cost model).");
		add(14493 , 10 , "Cost of a single physical I/O (used in new optimizer cost model).");
		add(14494 , 10 , "Cost of a single CPU unit (used in new optimizer cost model).");
		add(14495 , 10 , "Use ASE1254 optimizer and execution engine in preference to current optimizer and execution engine.");
		add(14496 , 10 , "The 'number of disk tasks' parameter specifies the number of tasks that poll and complete disk I/Os.");
		add(14497 , 10 , "Specifies whether a given I/O type is polled using a separate thread ('threaded') or as part of an engine thread during scheduling ('inline').");
		add(14498 , 10 , "The 'number of network tasks' parameter specifies the number of tasks that poll and complete network I/Os. This parameter is only applicable when 'network polling mode' is 'threaded'.");
		add(14499 , 10 , "The 'number of ctlib tasks' parameter specifies the number of tasks that poll and complete ctlib I/Os.");
		add(14500 , 16 , "Manifest file '%.*s' cannot be opened. Check the file path and permissions.");
		add(14501 , 16 , "Manifest file creation failed. The file '%.*s' already exists.");
		add(14502 , 16 , "Database '%.*s' is a user created temporary database. It cannot be unmounted.");
		add(14503 , 20 , "I/O error occurred while reading '%.*s' as a manifest file. The file is not a manifest file or it is corrupt.");
		add(14504 , 20 , "I/O error occurred while writing the manifest file to '%.*s'.");
		add(14505 , 16 , "ASE cannot mount these databases. The version in the manifest file is newer than the version in the Server. Server: log version =%d upgdvers =%d, Manifest File: log vers =%d upgd vers =%d.");
		add(14506 , 16 , "Mount database failed due to page size incompatibility. The current page size is %d, and the manifest file shows that the databases you are trying to mount are of page size %d.");
		add(14507 , 16 , "The manifest file shows that the databases you are mounting have a different sort order ID (%d) or character set ID (%d) than the ones running on this server (SortOrd = %d, CharSet = %d). If the sort orders differ, at least one of them is non-binary.");
		add(14508 , 16 , "Manifest file validation failed. The file is not a manifest file.");
		add(14509 , 16 , "This manifest type is not supported.");
		add(14510 , 16 , "Unable to use the manifest file as it was created by a later version of Adaptive Server.");
		add(14511 , 17 , "%s: Failed to allocate %d bytes of memory.");
		add(14513 , 20 , "Cannot parse manifest file data. Manifest file '%.*s' is corrupt.");
		add(14514 , 10 , "MOUNT DATABASE is skipping recovery of database '%.*s', and is proceeding to recover the next database.");
		add(14515 , 16 , "Database '%.*s'  is being unmounted by another session. This UNMOUNT DATABASE command is aborting.");
		add(14516 , 10 , "MOUNT DATABASE: Completed recovery of mounted database '%.*s'.");
		add(14517 , 10 , "MOUNT DATABASE: Recovery of mounted database '%.*s' failed.");
		add(14519 , 16 , "MOUNT DATABASE: Failed to validate the devices. The device allocations are not consistent with the descriptions in the manifest file.");
		add(14520 , 22 , "Could not find row in sysdatabases for database '%.*s'");
		add(14521 , 16 , "Permission denied. Only a user with SA role can execute the '%.*s' command.");
		add(14522 , 16 , "Only %d databases are allowed in the %s command.");
		add(14523 , 16 , "Database '%.*s' does not exist.");
		add(14524 , 16 , "%s error: This command option is not allowed when disk mirroring is enabled.");
		add(14525 , 16 , "MOUNT DATABASE: Some devices are specified by name and others by order. If any device is specified by name, then all devices must be specified by name.");
		add(14526 , 16 , "MOUNT DATABASE: The number of device specifications in the command (%d) does not match the number of devices (%d) in the manifest file.");
		add(14527 , 16 , "MOUNT DATABASE: Cannot locate device name '%.*s' in the manifest file. Use the listonly option to see device names in the manifest file.");
		add(14528 , 16 , "MOUNT DATABASE: The device specifications are missing for device '%.*s', path '%.*s'.");
		add(14529 , 16 , "MOUNT DATABASE: Cannot map the devices in the manifest file '%.*s'. Command is being aborted.");
		add(14530 , 10 , "'%.*s' = '%.*s'");
		add(14531 , 21 , "%s command could not locate the sysdevices row for vdevno = '%d'.");
		add(14532 , 17 , "UNMOUNT DATABASE command failed. An alarm function cannot be installed.");
		add(14533 , 17 , "%s could not acquire '%.*s' lock needed for this command.");
		add(14534 , 20 , "Unable to put process %d to sleep. Aborting UNMOUNT DATABASE command.");
		add(14535 , 16 , "Aborting the UNMOUNT DATABASE command as transactions in a prepared state did not finish within the prescribed time limit.");
		add(14536 , 10 , "UNMOUNT DATABASE: Waiting for multi-database transactions in a prepared state to complete. Retry count: %d.");
		add(14537 , 16 , "Database '%.*s' is a system database which cannot be specified in this command.");
		add(14538 , 16 , "%s: Device '%.*s' is also used by database '%.*s', which is not specified in this command.");
		add(14539 , 16 , "The %s command is being aborted due to device sharing violations.");
		add(14540 , 16 , "Database '%.*s' is quiesced or is being quiesced, and cannot be unmounted. UNMOUNT DATABASE command is aborting. Run this command after QUIESCE/PREPARE DATABASE RELEASE has been executed.");
		add(14541 , 18 , "%s command could not create the manifest file.");
		add(14542 , 16 , "%s command is not allowed when HA is enabled.");
		add(14543 , 10 , "Warning: Devices that are mirrored in the source server will not be mirrored in the target.");
		add(14544 , 20 , "The database pages %d to %d for database '%.*s' are on virtual blocks %d to %d on device '%.*s'. This is out of range for that device.");
		add(14545 , 16 , "Cannot locate the logical page %u for database '%.*s', dbid=%d, on the device '%.*s'. The page on the device is logical page %u for dbid %d.");
		add(14546 , 16 , "The database '%.*s' uses a device which is not in the manifest file. The manifest file is corrupt.");
		add(14547 , 16 , "The device '%.*s' does not correspond to the device '%.*s' in the manifest file.");
		add(14548 , 16 , "Database '%.*s', which is being unmounted, has dependencies (referential constraints) from database '%.*s'.");
		add(14549 , 16 , "%s command has found that database '%.*s' has dependencies (referential constraints) to database '%*.s'.");
		add(14550 , 17 , "%s command cannot acquire a lock on the sysreferences catalog in dbid '%d' to check cross-database references. Try the command later.");
		add(14551 , 16 , "Cross-database referential constraints do not allow the execution of this '%s' command to proceed. See previous error messages.");
		add(14552 , 16 , "The manifest file name is longer than the allowed maximum of 127 characters.");
		add(14553 , 16 , "Database %.*s is a proxy database. It cannot be unmounted.");
		add(14554 , 16 , "Cannot execute %s because you are not currently in the master database.");
		add(14556 , 16 , "User has aborted the %s command.");
		add(14557 , 16 , "Cannot execute %s command when the MODEL database is in use.");
		add(14558 , 16 , "MOUNT DATABASE: A new database id was required for database '%.*s' in order to mount it. Execute DBCC CHECKALLOC(%.*s, fixdbid) to correct it.");
		add(14559 , 20 , "%s Error: An internal function queue for manifest file operations is corrupted.");
		add(14560 , 20 , "Attempt to write the manifest file failed; error code is %d.");
		add(14561 , 20 , "Attempt to read the manifest file failed; error code is %d.");
		add(14562 , 16 , "Database '%.*s' has been specified more than once in this command.");
		add(14563 , 10 , "ASE is ignoring the referential constraint errors, since the override option is specified.");
		add(14564 , 16 , "Warning: ASE encountered an unknown token with ID '%d' while parsing item '%d' in the manifest file. This token will be skipped.");
		add(14565 , 16 , "ASE encountered an illegal datalength of %d for token %d, while parsing item %d in the manifest file. The manifest file is corrupt.");
		add(14567 , 16 , "This command cannot be run on the archive database '%.*s'.");
		add(14568 , 16 , "MOUNT DATABASE: The number of databases in the command (%d) does not match the number of databases (%d) in the manifest file.");
		add(14569 , 16 , "MOUNT DATABASE: Cannot locate database name '%.*s' in the manifest file. Use the listonly option to see database names in the manifest file.");
		add(14570 , 16 , "MOUNT DATABASE: The database specifications are missing for database '%.*s'.");
		add(14571 , 16 , "MOUNT DATABASE: Cannot map the databases in the manifest file '%.*s'. Command is being aborted.");
		add(14572 , 16 , "MOUNT DATABASE: Some databases are specified by name and others by order. If any database is specified by name, then all databases must be specified by name.");
		add(14573 , 10 , "[%S_MSG]");
		add(14574 , 16 , "The manifest file could not be created because the allocation pages of database '%S_DBID' have the same database id '%d' as that of database '%S_DBID'. Please run DBCC CHECKALLOC with the 'fix' option on database '%S_DBID' to correct this problem.");
		add(14575 , 16 , "%s is not supported for in-memory database '%.*s'.");
		add(14576 , 18 , "Aborting %s. Instance %d did not successfully perform the requested task. See the instance's error log for more detail. Try the %s again.");
		add(14577 , 20 , "%s: Internal error while communicating with other instances.");
		add(14578 , 16 , "Another database operation is already in progress in database '%.*s'. Retry %s later.");
		add(14579 , 16 , "Aborting %s; instance failover recovery in progress. Reissue the command after failover recovery completes.");
		add(14580 , 16 , "You cannot mount the database(s) because at least one database contains functionality (feature ID %d) that is available only on the server on which it originated.");
		add(14581 , 16 , "You cannot unmount database '%.*s' because it was created with asynchronous initialization and it has not been fully initialized. Retry the command later.");
		add(14582 , 16 , "Could not unmount encrypted database '%.*s' because it is being %S_MSG.");
		add(14583 , 16 , "Failed to generate manifest content for database '%.*s'.");
		add(14584 , 16 , "There is no matching database encryption key '%.*s' available for the database '%.*s'.");
		add(14585 , 10 , "MOUNT DATABASE: A new database id was required for database '%.*s' in order to mount it. ASE will automatically fix this in all the allocation pages. The process can take some time.");
		add(14586 , 10 , "The physical file for logical device '%.*s' is the mirrored device '%.*s'.");
		add(14600 , 16 , "Failed to read page '%u' from sysanchors.");
		add(14601 , 16 , "Invalid length '%d' found for anchor type '%d'. Sysanchors page '%u', offset '%d'.");
		add(14602 , 16 , "Invalid anchor type '%d' found on sysanchors page '%u' offset '%d'.");
		add(14603 , 16 , "The end-of-file marker for sysanchors is missing. Last page '%u'.");
		add(14604 , 16 , "There is no free space available in sysanchors.");
		add(14605 , 21 , "The object id to which logical page 24 belongs to is set incorrectly as '%d'. The expected object id is '%d'.");
		add(14606 , 16 , "Inconsistent sysobjects row location anchor: objid '%d'.");
		add(14607 , 16 , "Inconsistent sysindexes row location anchor: object '%d' indid '%d'.");
		add(14608 , 16 , "Inconsistent syspartitions row location anchor: object '%d' indid '%d' partition '%d'.");
		add(14609 , 16 , "The rids for the sysobjects row location anchor for the object '%d' do not match. Rid in sysobjects is '%S_RID' and rid in the anchor is '%S_RID'.");
		add(14610 , 16 , "The rids for the sysindexes row location anchor for object '%d' and index '%d' do not match. Rid in sysindexes is '%S_RID' and rid in the anchor is '%S_RID'.");
		add(14611 , 16 , "The rids for the syspartitions row location anchor for object '%d', index '%d' and partition '%d' do not match. Rid in syspartitions is '%S_RID' and rid in the anchor is '%S_RID'.");
		add(14612 , 16 , "Inconsistent usage anchor: Dbid '%d' Lstart '%d'.");
		add(14613 , 23 , "The '%s' field in usage anchor has '%d' which does not match with '%d' from sysusages. Dbid '%d'. Lstart '%d'.");
		add(14614 , 16 , "Inconsistent sysdatabases row location anchor: dbid '%d'.");
		add(14615 , 16 , "Inconsistent sysdevices row location anchor: vdevno '%d' devtype '%d'.");
		add(14616 , 16 , "The rids for the sysdatabases row location anchor for dbid '%d' do not match. Rid in sysdatabases is '%S_RID' and rid in the anchor is '%S_RID'.");
		add(14617 , 16 , "The rids for the sysdevices row location anchor for vdevno '%d', devtype '%d' do not match. Rid in sysdevices is '%S_RID' and rid in the anchor is '%S_RID'.");
		add(14618 , 21 , "There is not enough space on anchor page %u to insert a %d byte anchor. Space for this anchor should have been reserved, but was not.");
		add(14619 , 21 , "The anchor for row ID '%S_RID' is missing from sysanchors page %u.");
		add(14620 , 21 , "An attempt to read page %u in database '%.*s' failed.");
		add(14621 , 21 , "The anchor for database ID %d, start page %u is missing from sysanchors page %u.");
		add(14622 , 20 , "The dbinfo anchor in the database '%S_DBINFO' is already locked by the task. Nested access to dbinfo anchor is not allowed. Lock was acquired in file '%s' at line %d. This is an internal error. Please contact SAP Technical Support.");
		add(14623 , 20 , "You are trying to remove an anchor of a row for objectid %d indid %d that still exists in %s. You must delete the row before you may remove its anchor.");
		add(14624 , 21 , "The anchor for rsid %d is missing from sysanchors page %u.");
		add(14701 , 16 , "%s: XML parser error <<%s>> at line %d, offset %d.");
		add(14702 , 16 , "%s: XML parser fatal error <<%s>> at line %d, offset %d.");
		add(14703 , 10 , "%s: XML parser warning <<%s>> at line %d, offset %d.");
		add(14704 , 20 , "%s: SAX parse exception <<%s>>.");
		add(14705 , 20 , "%s: XML exception <<%s>>.");
		add(14706 , 16 , "%s: One or more validation errors or warnings.");
		add(14707 , 16 , "The document might be corrupted. Storage format %s unrecognized.");
		add(14708 , 16 , "Read past the end of stream of length %d failed.");
		add(14709 , 16 , "This document may be corrupted. Actual size is %d, but should be %d.");
		add(14710 , 16 , "Error reading parsed XML document at byte position: %d. Document may be corrupted, truncated, or generated on a platform with different byte-ordering.");
		add(14711 , 18 , "Cannot access XML database; verify that it is set up correctly.");
		add(14712 , 18 , "Cannot access XML catalog table; verify that it is set up correctly.");
		add(14713 , 18 , "Cannot look up URI schema location '%s'; verify that it is set up correctly.");
		add(14801 , 16 , "XPATH query syntax error.");
		add(14802 , 16 , "XPATH: Function '%s' not supported.");
		add(14803 , 16 , "XPATH: Parenthesized expression not supported.");
		add(14804 , 16 , "XPATH: No path expressions are allowed after attribute expressions.");
		add(14805 , 16 , "XPATH: Complex expressions are not allowed on right side of comparison.");
		add(14806 , 16 , "XPATH: Queries starting with relative paths are not allowed.");
		add(14807 , 16 , "XPATH: NEGATION operator is not supported.");
		add(14808 , 16 , "XPATH: DESCENDANT operator requires a Right Hand Side");
		add(14809 , 16 , "XPATH: Top Level 'AND' or 'OR' operators are not allowed.");
		add(14810 , 16 , "Received error %d : %s");
		add(14811 , 16 , "%s datatype is not supported with FOR XML.");
		add(14812 , 16 , "%s disallowed with FOR XML.");
		add(14813 , 16 , "Wildcards are not supported with namespaces.");
		add(14814 , 16 , "Invalid token encountered for xpath query.");
		add(14815 , 16 , "XPATH: No path expressions are allowed after text() function.");
		add(14816 , 16 , "Invalid range specified for subscript.");
		add(14817 , 16 , "FOR XML: Failed to generate string representation of %s datatype.");
		add(14818 , 16 , "The comparison expression returns a boolean value. Expressions that return a boolean value are not allowed in parentheses.");
		add(14819 , 16 , "Expressions with set operators return a boolean value. Expressions that return a boolean value are not allowed in parentheses.");
		add(14820 , 16 , "Complex path expressions are not supported after an expression that contains a parentheses followed by subscript.");
		add(14821 , 16 , "Absolute paths are not supported inside parentheses. Only paths relative to outer contexts are supported.");
		add(14822 , 16 , "Attribute scans are not supported after an expression that contains a parentheses followed by subscript.");
		add(14823 , 16 , "text() nodetest is not supported after an expression that contains a parentheses followed by subscript.");
		add(14824 , 16 , "Too many arguments to XPath function '%s'.");
		add(14825 , 16 , "XPath function call must be at leaf level.");
		add(14826 , 16 , "A boolean expression is not a valid argument for XPath function '%s'.");
		add(14827 , 16 , "The arguments of a top-level XPath function call must be absolute path expressions.");
		add(14828 , 16 , "The arguments of a relative XPath function must be relative path expressions.");
		add(14829 , 16 , "The operands of '%s' must be node-sets.");
		add(14830 , 16 , "Too few arguments to XPath function '%s'.");
		add(14831 , 16 , "A wildcard cannot be specified immediately before a function call.");
		add(14832 , 16 , "String or numeric literal is too long.");
		add(14833 , 16 , "Absolute paths inside a filter operator are not supported.");
		add(14834 , 16 , "Error creating SQLX document: %s.");
		add(14835 , 16 , "Node tests are not functions. It is illegal to pass arguments to node tests.");
		add(14836 , 16 , "XPATH:Illegal token %s encountered.");
		add(14837 , 16 , "Return type of %s is not supported with FOR XML.");
		add(14838 , 16 , "Single or double quote mismatch");
		add(14839 , 16 , "Xml sortorder mismatch. Document is parsed with sortorder %s and the current sortorder is %s.");
		add(14841 , 16 , "XMLTABLE: Failed to convert column pattern result to %s for column %d.");
		add(14842 , 16 , "XMLTABLE column pattern must be a relative path.");
		add(14843 , 16 , "XMLTABLE row pattern must be an absolute path.:");
		add(14844 , 16 , "XMLTABLE %s pattern cannot terminate in '/' or '//'.");
		add(14845 , 16 , "XMLTABLE %s pattern is invalid.");
		add(14846 , 16 , "An overflow has occurred in the value for column '%d'. Try using another datatype for ordinality column.");
		add(14847 , 16 , "XMLTABLE column %d, does not allow null values.");
		add(14848 , 16 , "A column pattern must return exactly one result for each node in row pattern.");
		add(14849 , 16 , "XPath queries in row and column patterns of xmltable can have only simple paths consisting of '/' and element names (simple forward paths).");
		add(14850 , 16 , "Default value of NULL cannot be combined with a NOT NULL constraint in the declaration of xmltable column %d.");
		add(14851 , 16 , "The Xpath syntax %s is not supported.");
		add(14901 , 20 , "Unexpected exception caught at %s:%d.");
		add(14902 , 20 , "Xerces panic error, msg '%s'.");
		add(14903 , 16 , "The length specified in the RETURNS clause is not big enough to hold the result.");
		add(14904 , 16 , "Cannot parse an already parsed XML document.");
		add(14905 , 16 , "Invalid xml option value : %s");
		add(14906 , 16 , "Cannot service request; XML option not enabled or not licensed.");
		add(14907 , 16 , "If you specify schemavalidate='yes', then you must either specify dtdvalidate='strict', or omit dtdvalidate.");
		add(14908 , 16 , "Invalid xml option name : %s.");
		add(14909 , 16 , "Invalid options string. The format of an option string is 'optionName=optionValue, optionName=optionValue, ...'.");
		add(14910 , 16 , "The value '%.*s' specified for option '%.*s' cannot be greater than %d bytes.");
		add(14911 , 16 , "Current sort order is different that the sort order of the parsed document.");
		add(14912 , 16 , "Option 'ncr' is not supported for documents with embedded DTD.");
		add(15000 , 10 , "*** NOTICE: Space reserved on the log segment is %s pages (%s MB), %s%%.");
		add(15001 , 16 , "Partition name '%.*s' is not found in dbid '%d'.");
		add(15002 , 16 , "The SYSGAMS table in database '%.*s' has %d extents allocated, but the database size indicates %d extents are needed. Please contact Technical Support for assistance.");
		add(15003 , 16 , "The first page in sysindexes for table SYSGAMS, %u, should be the first page of an extent and the previous page number should be 0. (Previous page of page %u was found to be %u. First page of extent holding page %u is %u).");
		add(15004 , 16 , "The next page, %u, pointed to by SYSGAMS page %u (last page of an extent) should be the first page of a new extent.");
		add(15005 , 16 , "The next page pointed to by SYSGAMS page %u should be %u instead of page number %u.");
		add(15006 , 10 , "Verifying faults for table '%.*s'. The total number of tables to verify is %d. This is table number %d.");
		add(15007 , 16 , "Table Corrupt: Object '%.*s' is not a user table but it has trigger (id %d) bound to it.");
		add(15008 , 16 , "Table Corrupt: Object '%.*s' is not a trigger, but it is bound to table '%.*s' as a trigger. The object has type ID %d, type code '%s'.");
		add(15009 , 16 , "Table Corrupt: Trigger (id %d) for table '%.*s' was not found in sysobjects.");
		add(15010 , 16 , "Table Corrupt: Target user table (id %d) for trigger '%.*s' was not found in sysobjects.");
		add(15011 , 16 , "Table Corrupt: Object '%.*s' is not a user table but is a target for the trigger '%.*s'.");
		add(15012 , 16 , "Table Corrupt: Trigger '%.*s' has a target table '%d' which does not match one of the triggers on the target table. Target table '%.*s' has insert trigger '%d', update trigger '%d' and delete trigger '%d'.");
		add(15013 , 16 , "Internal Error: Function '%s' was passed an illegal value (%d).");
		add(15014 , 16 , "Invalid 'identity_burn_max' value '%.*s'. Retry the command using a valid value.");
		add(15015 , 16 , "Cannot get an '%s' lock on table '%.*s'. Retry the command.");
		add(15016 , 10 , "A large I/O buffer cannot be allocated; pages will be read one at a time.");
		add(15017 , 16 , "Cannot reconfigure the maximum number of network listeners.");
		add(15018 , 16 , "Table Corrupt: The %.*s entry for object ID '%d', index ID '%d', does not have a matching entry in %.*s.");
		add(15019 , 16 , "Table Corrupt: The %.*s for object ID '%d', index ID '%d', does not match between %.*s and %.*s.");
		add(15020 , 16 , "%s: parameter %d is incorrect. Invalid command %s.");
		add(15021 , 16 , "%s: parameter %d not specified. The only command that can leave the remaining arguments unspecified is status.");
		add(15022 , 16 , "%s: parameter %d has invalid type.");
		add(15023 , 16 , "%s: parameter %d cannot be longer than %d characters.");
		add(15024 , 16 , "%s: parameter %d must contain at least two, and at most three, components.");
		add(15025 , 16 , "%s: parameter %d specifies an invalid network protocol %s.");
		add(15026 , 16 , "%s: param %d specifies a host component that is longer than %d characters.");
		add(15027 , 16 , "%s: parameter %d specifies a port component that is longer than %d characters.");
		add(15028 , 16 , "%s: engine parameter is ignored on this platform .");
		add(15029 , 16 , "%s: parameter %d specifies an invalid engine number %s.");
		add(15030 , 16 , "%s: parameter %d specifies an engine list that is longer than %d characters.");
		add(15031 , 16 , "%s: parameter %d contains an invalid separator %c.");
		add(15032 , 16 , "%s: parameter %d specifies an incomplete list.");
		add(15033 , 16 , "%s: parameter %d specifies an engine %d, which is out of range.");
		add(15034 , 16 , "%s: parameter %d specifies an invalid engine range %d-%d.");
		add(15035 , 16 , "%s: parameter %d makes the argument list too long.");
		add(15036 , 16 , "%s: this command requires %d more argument(s).");
		add(15037 , 16 , "%s: 0 and remaining are the only valid values for engine when running under trace flag 7822.");
		add(15038 , 16 , "The specified port %s is invalid.");
		add(15039 , 10 , "The table (id = %d) was skipped as it can not be opened. It may have already been dropped.");
		add(15040 , 18 , "Internal error: Query from system catalog '%.*s' returned no rows.");
		add(15041 , 16 , "Table Corrupt: Row %d in page %u is in the wrong partition (ID %d). The row should reside in the partition corresponding to ID %d.");
		add(15042 , 10 , "Checking partition '%.*s' (partition ID %d) of table '%.*s'. The logical page size of this table is %d bytes.");
		add(15043 , 16 , "Invalid partition argument passed to DBCC CHECKTABLE. Either the partition '%.*s' (partition ID %d) does not belong to table '%.*s' (table ID %d) or it is not a data partition.");
		add(15044 , 10 , "Partition '%.*s' (partition ID %d) has %s data rows.");
		add(15045 , 10 , "Checking table '%.*s' (object ID %d): Logical page size is %d bytes.");
		add(15046 , 16 , "Data partition(partitionid = %d) does not exist.");
		add(15047 , 16 , "Invalid partition id(%d), index id(%d) combination. No such partition exists.");
		add(15048 , 16 , "DBCC INDEXALLOC cannot be run against indid 255. Use DBCC TEXTALLOC instead.");
		add(15049 , 16 , "Internal index error: Table id %d, indid %d, colid %d %s in Syscolumns %d does not match value %d in Sysindexes.");
		add(15050 , 16 , "Internal index error: Table id %d, indid %d, colid %d calculated offset %d does not match value %d in Sysindexes.");
		add(15051 , 16 , "Internal index error: Table id %d, indid %d colid %d does not have a matching entry in Syscolumns.");
		add(15052 , 16 , "Index error: Table id %d, indid %d calculated %s %d does not match value %d in Sysindexes.");
		add(15053 , 16 , "Found %d errors in index %d for table %d, run DBCC CHECKCATALOG(<db>, fix) or recreate the index to correct it.");
		add(15054 , 16 , "Invalid partition argument passed to DBCC. The partition with ID '%d' does not belong to index id %d of table '%.*s' (table ID %d).");
		add(15055 , 16 , "Invalid partition argument passed to DBCC. The partition '%.*s' does not belong to index id %d of table '%.*s' (table ID %d).");
		add(15056 , 16 , "The root page %u of index ID %d for empty table '%.*s can have at most one entry pointing to the first page %u. However, it has either an incorrect entry, or more than one entries.");
		add(15057 , 10 , "Fixing above %d errors found in index %d for table %d.");
		add(15058 , 10 , "Found an error in index %d for table %d that cannot be fixed. Please recreate the index to correct it. If it is a system table index, please contact SAP Technical Support for assistance.");
		add(15059 , 16 , "Partition ID mismatch found while checking table '%.*s' (object ID %d). The partition ID (%d) in the header of page number %u does not match the partition ID (%d) in the table's session descriptor.");
		add(15060 , 16 , "The state of the sort bit on OAM page %u for object ID %d does not agree with the state recorded in the object's syspartitions row. A problem may have occurred while creating or recreating index ID %d for this object.");
		add(15061 , 16 , "Object %d: Expected page %u to be for index %d, partition %d; however, it is a page for index %d, partition %d.");
		add(15062 , 16 , "A %S_MSG level CHECKVERIFY command is already running on this %S_MSG.");
		add(15063 , 20 , "Could not find row in syspartitions for object ID '%d', partition ID '%d', in database ID '%d'.");
		add(15064 , 16 , "Cannot process partition ID '%d', index ID '%d' because this combination maps to a global index. Use of the partition ID argument with DBCC commands INDEXALLOC or TABLEALLOC limits processing to local indexes.");
		add(15065 , 10 , "Index has %s leaf rids.");
		add(15066 , 10 , "No leaf row found for data page %u row %d in leaf page %u of indexid %d, table %d.");
		add(15067 , 10 , "The total number of index leaf pages in this index is %d.");
		add(15068 , 16 , "The 'bottom_up' option for dbcc checkindex is not available on allpages locked tables.");
		add(15069 , 20 , "Cannot continue: %S_MSG has failed for database '%.*s'. The last reported error is %d.");
		add(15070 , 16 , "Table Corrupt: Table '%.*s' (table ID %d), partition '%.*s' (partition ID %d)'s First Page %u and OAM Page %u are not valid.");
		add(15071 , 16 , "Table Corrupt: The %.*s entry for object ID '%d', index ID '%d', partition ID '%d', does not have a matching entry in %.*s.");
		add(15072 , 16 , "Table Corrupt: The %.*s entry for object ID '%d' has an incorrect index ID '%d'.");
		add(15073 , 16 , "Engine %d is timed out.");
		add(15074 , 10 , "The total number of deleted rows in the table is %s.");
		add(15075 , 10 , "The total number of pages with more than %d percent garbage is %d.");
		add(15076 , 10 , "The total number of pages with more than %d percent insert free space is %d.");
		add(15077 , 10 , "Warning: Definition time object ID %d (object name = %.*s) has been detected. This may have been left behind due to an improper rollback. Drop the object and re-run the command.");
		add(15078 , 16 , "The root page %u of index ID %d for empty sliced table %.*s has too many entries, or one or more child entries pointing to incorrect or deallocated pages.");
		add(15079 , 16 , "Trace flag %d is not supported, and may have a negative impact on the server. Verify that this is the correct trace flag and use the 'with override' option to switch it on.");
		add(15080 , 16 , "The root page %u of index id %d for table '%.*s' has inconsistent rootkeys information. Drop and recreate the index. Use DBCC REINDEX to rebuild indexes on system catalogs with this form of inconsistency.");
		add(15081 , 16 , "You cannot use DBCC TRACEON to set trace flag %d.");
		add(15082 , 10 , "There are %d OAM entries with zero used/unused page counts. This is not an error. Run DBCC %s FIX on objid %d indid %d to remove these entries as doing so will improve OAM scan performance.");
		add(15083 , 10 , "%d OAM entries with zero used/unused page counts have been deleted for objid %d indid %d.");
		add(15084 , 18 , "The OAM has no room for new inserts. Run DBCC %s FIX on objid %d indid %d.");
		add(15085 , 10 , "The OAM for objid %d indid %d has been extended with page %u.");
		add(15086 , 16 , "Attempt to extend the OAM for objid %d indid %d failed.");
		add(15087 , 16 , "Attempt to delete an OAM entry with zero used/unused page counts for allocation page %u from OAM page %u for objid %d indid %d failed.");
		add(15088 , 16 , "Parameter '%s' (number %d) to DBCC command '%s' has invalid value/type.");
		add(15089 , 16 , "The DBCC command '%s' requires a minimum of %d and a maximum of %d parameters.");
		add(15090 , 10 , "An index for replication is missing or is in suspect state (column '%.*s' of table '%.*s'). Run DBCC REINDEX to fix this inconsistency.");
		add(15091 , 10 , "Found an orphan or suspect index '%.*s' on table '%.*s'. Run DBCC REINDEX to fix this inconsistency.");
		add(15092 , 10 , "Rebuilding replication index for column '%.*s' on table '%.*s'.");
		add(15093 , 10 , "Dropping orphan replication index '%.*s' on table '%.*s'.");
		add(15094 , 10 , "Inconsistencies found on indexes created for replication. Attempting to fix them.");
		add(15095 , 10 , "An invalid 'data row id' value (%u, %d) was found in first text page of a text/image/unitext column. This information is on page %u, partition ID %d, and belongs to the object with ID %d. Text/image/unitext replication on this column may not work.");
		add(15096 , 10 , "CIPCTEST: Test succeeded");
		add(15097 , 10 , "CIPCTEST: Test failed");
		add(15098 , 10 , "CIPCTEST: Input invalid");
		add(15099 , 10 , "The total number of deleted rows in partition '%.*s' (partition ID %d) is %s.");
		add(15100 , 16 , "Syntax error in endpoint at '%.*s'.");
		add(15101 , 17 , "There is insufficient memory to allocate %d bytes. Please increase configuration parameter 'messaging memory', or try again when there is less activity on the server.");
		add(15102 , 16 , "Endpoint requires 'topic' or 'queue' qualifier.");
		add(15103 , 16 , "Endpoint type '%.*s' is not allowed for built-in function '%.*s'.");
		add(15104 , 16 , "Cannot service request: messaging option not enabled or not licensed.");
		add(15105 , 20 , "Messaging services API call failed. Operation '%.*s'.");
		add(15106 , 16 , "Error received from the messaging provider.  	%.*s From provider '%.*s', endpoint '%.*s'.");
		add(15107 , 16 , "Unrecognized server class '%.*s'.");
		add(15108 , 16 , "Syntax error in endpoint, expected ':'.");
		add(15109 , 16 , "Syntax error in endpoint, '?' is missing.");
		add(15110 , 16 , "Syntax error in OPTION. Last option '%.*s'.");
		add(15111 , 16 , "Cannot determine the type of '%.*s'.");
		add(15112 , 16 , "Unsupported message type '%.*s' cannot be read.");
		add(15113 , 16 , "Cannot convert the message to the type specified. Message type '%.*s', return type '%.*s'.");
		add(15114 , 16 , "Value '%.*s' is not valid for option '%.*s'.");
		add(15115 , 16 , "Syntax error in options or properties, '%.*s'.");
		add(15116 , 16 , "The hex number '%.*s' is too long to be converted into an INTEGER value.");
		add(15117 , 16 , "Unrecognized endpoint option '%.*s'.");
		add(15119 , 16 , "The specified XML document is empty or could not be parsed.");
		add(15120 , 16 , "Subscription '%.*s' has already been started on this session.");
		add(15121 , 16 , "Subscription '%.*s' has not been registered yet.");
		add(15122 , 16 , "The subscription '%.*s' has not been started yet.");
		add(15123 , 16 , "SYB_RTMS has not yet been defined in sysservers. Use sp_addserver to add SYB_RTMS.");
		add(15124 , 16 , "Property names beginning with 'ASE_' cannot be set.");
		add(15125 , 16 , "Cannot find provider '%.*s' in system catalogs.");
		add(15126 , 10 , "Specified username/password are ignored because a registered login was found.");
		add(15127 , 10 , "Connection to '%.*s' with client-id '%.*s' will not be released until the subscription '%.*s' is unsubscribed.");
		add(15128 , 16 , "The requeue endpoint must be to the same provider as specified in the '%.*s' builtin function.");
		add(15129 , 16 , "Could not requeue the message to '%.*s'.");
		add(15130 , 16 , "Unhandled message has been requeued to '%.*s'.");
		add(15131 , 16 , "The message received is encoded in a charset that is not translatable to the current server charset. Message encoding '%.*s'.");
		add(15132 , 16 , "The message data specified is in a charset that cannot be translated to a Java charset. 'OPTION encoding=utf8' should be specified.");
		add(15133 , 16 , "The Unicode message specified requires the 'type' or 'encoding' OPTION in order to be sent.");
		add(15134 , 16 , "The connection to '%.*s' is dead, because a previous messaging operation sharing this connection recieved an error from the messaging provider.");
		add(15135 , 16 , "The number '%.*s' must be smaller than 9223372036854775807.");
		add(15136 , 16 , "You cannot specify '%.*s' for provider class '%.*s'.");
		add(15137 , 16 , "The length of '%.*s' cannot be greater than %d.");
		add(15138 , 16 , "The number '%.*s' must be in the range %d to %d.");
		add(15139 , 16 , "Syntax error in the endpoint specified.");
		add(15140 , 16 , "You cannot use a registered '%s' on provider class '%s'.");
		add(15141 , 16 , "The 'topics' property cannot be null if 'rfhCommand' is '%s'.");
		add(15142 , 16 , "The 'topics' property can only contain one topic when 'rfhCommand' is '%.*s'.");
		add(15143 , 16 , "Provider class '%s' is not supported on this platform.");
		add(15144 , 16 , "Unrecognized option '%.*s'.");
		add(15145 , 16 , "The MQ message of format type '%s' not allowed. Verify 'requeue' and 'format' properties.");
		add(15146 , 16 , "Verify that 'number of Q engines at startup' and 'max online Q engines' are configured correctly.");
		add(15147 , 16 , "Cannot load %s dynamic load libraries. Verify the path to the libraries.");
		add(15148 , 16 , "RFH header properties '%s' and '%s' cannot be both be 'yes' when RFH command is '%s'.");
		add(15149 , 16 , "Cannot allocate a packet for the KRTMS layer.");
		add(15150 , 16 , "Cannot retrieve SYBASE_JRE_RTDS environment variable.");
		add(15151 , 16 , "Cannot retrieve SYBASE_ASE environment variable.");
		add(15152 , 16 , "Cannot retrieve SYBASE environment variable.");
		add(15153 , 10 , "Terminating RTDS_HANDLER system task.");
		add(15154 , 16 , "Transient error on the socket. Error: <%d>");
		add(15155 , 10 , "The JRTMS JMS server has stopped. Attempting to restart.");
		add(15156 , 16 , "The JRTMS JVM server (process id: <%d>) is no longer running.");
		add(15157 , 16 , "Error spawning JRTMS JVM server.");
		add(15158 , 16 , "Cannot connect to JRTMS JVM server. Attempting to shutdown JRTMS JVM server.");
		add(15159 , 16 , "The INTERRUPT_THREAD packet bound for the JRTMS JVM server failed with <%d>.");
		add(15160 , 16 , "The SHUTDOWN_JVM packet bound for the JRTMS JVM server failed with <%d>.");
		add(15161 , 10 , "The JRTMS JVM server stopped successfully.");
		add(15162 , 16 , "Set 'enable real time messaging' option to execute this command.");
		add(15163 , 10 , "The JRTMS JVM server is up and running.");
		add(15164 , 10 , "The JRTMS JVM server is down.");
		add(15165 , 16 , "Invalid MQ inquire command %s");
		add(15166 , 16 , "Invalid attribute %s for the MQ inquire cmd %s");
		add(15167 , 16 , "Invalid MQ inquire state %d");
		add(15168 , 16 , "The type of the MQ attribute %s is undefined.Please contact SAP Technical Support for assistance.");
		add(15169 , 16 , "There was an error converting string data from '%s' encoding to '%s' encoding.");
		add(15170 , 16 , "Provider class '%s' is not supported");
		add(15171 , 16 , "The mq security protocol '%.*s' is not supported.");
		add(15172 , 16 , "The environment variable SYBASE_JRE is being temporarily used because the environment variable SYBASE_JRE_RTDS is not set.");
		add(15200 , 10 , "No web methods mapped to proxy tables for the WSDL URI [%s].");
		add(15201 , 10 , "WSDL URI in most cases has the suffix ?WSDL. Please verify WSDL URI.");
		add(15202 , 16 , "Web Method [%s] not mapped to proxy table because of unsupported datatype.");
		add(15203 , 16 , "Received request to execute an unknown procedure [%s].");
		add(15204 , 16 , "Caught IOException. This usually indicates an error in communications between ASE and the Consumer. Details: [%s].");
		add(15205 , 16 , "Caught SQLException. This usually indicates an error retrieving meta data from ASE. Details: [%s]");
		add(15206 , 16 , "Caught an Unknown Exception: Details: [%s]");
		add(15207 , 16 , "Caught Remote Web Method Exception (AxisFault). This indicates an error in the remote web method. Details: [%s].");
		add(15208 , 16 , "Caught Mapping Exception. This indicates an error in mapping the web method arguments to ASE types. Details: [%s]");
		add(15209 , 16 , "Caught Service Exception. This usually indicates an incorrect WSDL file. Details: [%s]");
		add(15210 , 16 , "Received XML input to the webmethod that was is not well formed.");
		add(15211 , 16 , "Error in invoking web method (MalformedURL) Details: [%s]");
		add(15212 , 16 , "Caught RemoteException. This usually indicates an error in the network transmission. Details: [%s]");
		add(15213 , 16 , "Error in invoking web method (Unknown Exception): Details [%s]");
		add(15214 , 16 , "Aborting invocation of web method [%s] from proxy table [%s] because the web method expects [%s] arguments and [%s] were received.");
		add(15215 , 15 , "Parameter length/count/type mismatch. Check the length, number and types of the parameters passed to ws_admin.");
		add(15216 , 15 , "Unknown operation, starting with '%.*s', specified to ws_admin. Check parameter spelling and placement.");
		add(15217 , 20 , "Failure during update/insert/delete from sysattributes.");
		add(15218 , 20 , "Cannot retrieve current database name.");
		add(15219 , 20 , "Cannot retrieve object ID for '%.*s'.");
		add(15220 , 16 , "A user-defined Web service by that name already exists.");
		add(15221 , 16 , "Cannot drop alias when it is being referenced by a service.");
		add(15222 , 16 , "Setting the [%s] to [%s] failed. For more information about [%s], see the ASE Web Services engine log file.");
		add(15271 , 10 , "The requested %s property is already set or cleared for the database or object '%.*s'.");
		add(15272 , 16 , "Latch free index property cannot be specified on partition level.");
		add(15273 , 16 , "The requested property '%s' is not allowed when property '%s' is either already set or also specified.");
		add(15274 , 16 , "%s failed since database '%.*s' is in use as version storage by database '%.*s'.");
		add(15400 , 16 , "Adaptive Server is unable to remove or change the system encryption password because the current password is either incorrectly specified or missing.");
		add(15401 , 16 , "You must configure '%S_MSG' in Adaptive Server to execute the %s command or option.");
		add(15402 , 18 , "The encrypted columns feature is not available on this platform.");
		add(15403 , 17 , "There is no memory available for an internal encryption operation in Adaptive Server. The current command cannot be processed.");
		add(15404 , 16 , "There is no existing system encryption password to reset. Omit the old password parameter.");
		add(15405 , 18 , "Adaptive Server failed to %s the encryption password. This is an internal error.");
		add(15406 , 18 , "Adaptive Server failed to save the system encryption password because of an internal error.");
		add(15407 , 18 , "The hex representation of the system encryption password or user encryption password has been corrupted or truncated. Contact a user with System Security Officer (SSO) role.");
		add(15408 , 16 , "Invalid keylength specified for algorithm '%.*s'. The valid values for keylength are: '%d', '%d', or '%d'.");
		add(15409 , 16 , "Adaptive Server failed to save the master key startup file path because of an internal error.");
		add(15410 , 18 , "Adapter Server failed to synchronize the content of the master key startup file with server memory.");
		add(15411 , 18 , "Error occurred when creating symmetric key '%.*s' (error code %d).");
		add(15412 , 18 , "An internal error occurred when Adaptive Server was setting up the context for symmetric encryption or decryption (error code %d). Please contact SAP Technical Support.");
		add(15413 , 18 , "An internal error occurred during an encryption operation (error code %d). Please contact SAP Technical Support.");
		add(15414 , 18 , "An internal error occurred at end of symmetric encryption or decryption operation (error code %d). Please contact SAP Technical Support.");
		add(15415 , 16 , "The encr_admin builtin requires parameter '%s', which is missing. Check user documentation for the correct syntax.");
		add(15416 , 16 , "A system default key already exists for this database. Use ALTER ENCRYPTION KEY to create a new system default key.");
		add(15417 , 18 , "An internal error occurred during a decryption operation (error code %d). Please contact SAP Technical Support.");
		add(15418 , 20 , "The encryption key create function issued too many lock requests.");
		add(15419 , 11 , "Cannot alter encryption key '%.*s', because this key does not exist in database '%S_DBID'.");
		add(15420 , 16 , "Cannot alter encryption key '%.*s', because it is not the default key for database '%S_DBID'.");
		add(15421 , 11 , "The '%.*s' command cannot be executed because the system encryption password does not exist in database '%S_DBID'.");
		add(15422 , 16 , "The '%s' command cannot be executed because there is no default encryption key in database %.*s. Use a named key or contact a user with System Security Officer (SSO) role for help.");
		add(15423 , 16 , "The %s command cannot be executed because encryption key '%.*s' does not exist.");
		add(15424 , 16 , "Adaptive Server cannot access the encryption key with object id '%d' in database '%.*s'.");
		add(15425 , 16 , "Columns of datatype %s may not be encrypted.");
		add(15426 , 16 , "The encrypted column '%.*s' may not be used with a primary key, unique or referential constraint because the associated encryption key specifies the use of an initialization vector or random padding.");
		add(15427 , 16 , "The database '%S_DBID' is currently offline and cannot be checked for encryption key references. The encryption key '%.*s' may be dropped.");
		add(15428 , 11 , "The %s command cannot be executed because encryption key %d does not exist.");
		add(15429 , 18 , "An internal error occurred when Adaptive Server was generating random data during an encryption operation. Please contact SAP Technical Support.");
		add(15430 , 16 , "Adaptive Server failed to open database '%.*s' to access encryption key %d.");
		add(15431 , 10 , "Database '%.*s' contains encryption key '%.*s' that is used in database '%.*s'.");
		add(15432 , 16 , "A validation check failed when Adaptive Server decrypted an encryption key. This error may indicate an incorrect password.");
		add(15433 , 16 , "The system encryption password may not be deleted in the current database because there exists at least one encryption key that is dependent on it.");
		add(15434 , 18 , "Adaptive Server failed to create an encryption key for internal use. Please contact SAP Technical Support.");
		add(15435 , 16 , "A validation check failed when Adaptive Server decrypted a password. Please contact SAP Technical Support.");
		add(15436 , 16 , "The length of the %s option on the %s command is incorrect. The expected length is %d.");
		add(15437 , 16 , "The '%s' option is missing on the '%s' command.");
		add(15438 , 16 , "Cannot drop the system table sysencryptkeys in database '%.*s' because it contains encryption key '%.*s' that is used in database '%.*s'.");
		add(15439 , 16 , "The 'remove_catalog' option cannot be processed because Adaptive Server is not in single-user mode.");
		add(15440 , 16 , "After removing sysencryptkeys from database '%.*s', Adaptive Server failed to remove relevant rows from sysattributes. You must manually delete rows from sysattributes where CLASS=1 and ATTRIBUTE=%d, or contact SAP Technical Support for assistance.");
		add(15441 , 18 , "The encryption key '%.*s' in syscolumns does not match the key in sysobjects.");
		add(15442 , 16 , "Cannot create/alter an encryption key for protection by a master key when 'downgrade_kek_size' is true.");
		add(15443 , 10 , "Removing the system encryption password from database '%.*s'.");
		add(15444 , 16 , "Specified column '%.*s' does not exist in the SELECT INTO target list.");
		add(15445 , 16 , "The %S_MSG of the ciphertext data (%s) is incorrect for the column '%.*s'.");
		add(15446 , 10 , "The database '%S_DBID' is currently not available and cannot be checked for cross-database encryption key references for the keys existing in database '%S_DBID'.");
		add(15447 , 16 , "Column '%.*s' may not specify both encryption and a referential constraint.");
		add(15448 , 16 , "You may not encrypt/decrypt column '%.*s' because there exists a trigger on table '%.*s'. Drop the trigger before encrypting/decrypting the column and re-create the trigger afterwards.");
		add(15449 , 16 , "Column '%.*s' is not encrypted. Both the primary and foreign key must be encrypted.");
		add(15450 , 16 , "Both primary and foreign keys must be encrypted with the same encryption key.");
		add(15451 , 16 , "You cannot encrypt/decrypt column '%.*s' because it belongs to a clustered/placement index on table '%.*s'. Drop the index before the ALTER command, and recreate it afterwards.");
		add(15452 , 16 , "You cannot change the type of the encrypted column '%.*s' because it belongs to a clustered/placement index on table '%.*s'. Drop the index before the ALTER command, and recreate it afterwards.");
		add(15453 , 18 , "An internal error occurred when Adaptive Server was generating an interal encryption key (error code %d). Please contact SAP Technical Support.");
		add(15454 , 18 , "Adaptive Server failed to set 'downgrade_kek_size' because of an internal error.");
		add(15455 , 16 , "A computed column/function based index may not be encrypted nor reference an encrypted column (column '%.*s').");
		add(15456 , 16 , "You cannot encrypt column '%.*s' in table '%.*s' because there is a partition key on the column.");
		add(15457 , 16 , "You may not encrypt columns in table '%.*s' because the query uses the union operator.");
		add(15458 , 10 , "Warning: you are altering encryption key '%.*s' to set the default property, which that key already has.");
		add(15459 , 16 , "Failed to alter key '%.*s'. Key '%.*s' must be encrypted by a user password, and the current command must supply the password.");
		add(15460 , 16 , "You may not designate a key copy of '%.*s' for encryption by the system encryption password or the master key unless you also specify FOR LOGIN_ASSOCIATION.");
		add(15461 , 16 , "Attempt to drop non-existent encryption key copy for user '%.*s'.");
		add(15462 , 16 , "You may use ALTER ENCRYPTION KEY to modify only your own copy of key '%.*s'.");
		add(15463 , 11 , "%*.s' command cannot execute because the user encryption password has not been set for column '%.*s' in table '%*.s'.");
		add(15464 , 16 , "You may not modify encryption key '%.*s' for encryption by the system encryption password, external key or the master key.");
		add(15465 , 16 , "You may not designate an encryption key copy of key '%.*s' for user '%.*s' because that user is the key owner.");
		add(15466 , 10 , "Encryption key password overrides the encrypted column password.");
		add(15467 , 16 , "The password supplied for '%.*s' cannot be validated for login '%.*s'.");
		add(15468 , 16 , "Cannot set a master key as the default encryption key.");
		add(15469 , 11 , "You cannot execute '%.*s' command because the user encryption password has not been set.");
		add(15470 , 16 , "Command failed: Cannot specify version/uid/status for cleartext password in %s statement.");
		add(15471 , 16 , "Extra or invalid option on the '%s' command.");
		add(15472 , 16 , "You may not modify the original encryption key '%.*s' for encryption by the session's login password. Only key copies can be protected by login passwords.");
		add(15473 , 16 , "The %s command specifies key '%.*s' as encrypted by %S_MSG, but it is actually encrypted by %S_MSG.");
		add(15474 , 16 , "Failed to decrypt the login password when processing key '%.*s'.");
		add(15475 , 10 , "Adaptive Server does not have 'enable encrypted columns' configured.");
		add(15476 , 16 , "Failed to find login password information for user '%.*s' for key '%.*s'.");
		add(15477 , 16 , "Cannot encrypt key '%.*s' using a login password because you are not the original user of the current session.");
		add(15478 , 16 , "Adaptive Server was not able to encrypt a copy of key '%.*s' with the session's login password.");
		add(15479 , 16 , "A copy of key '%.*s' already exists for user '%.*s'.");
		add(15480 , 16 , "A recovery copy of key '%.*s' already exists.");
		add(15481 , 16 , "There is no recovery key copy for key '%.*s'.");
		add(15482 , 16 , "Adaptive Server is unable to create or validate a copy of key '%.*s' for login association. User '%.*s' must first log in to upgrade the login password format in syslogins.");
		add(15483 , 10 , "Adaptive Server failed to update the key copies for user '%.*s' in database '%.*s' during the login password reset. Ask the key custodian to check and update the key copies, if needed.");
		add(15484 , 10 , "During the login password reset, Adaptive Server was not able to check the existence of dependencies between encryption key copies and the login password of user '%.*s' in database '%.*s'. This event should be reported to the key custodian.");
		add(15485 , 10 , "An internal error occurred when updating the key copies for user '%.*s' during the login password reset. This event should be reported to the key custodian.");
		add(15486 , 16 , "The %s command specifies column '%.*s' as encrypted by key with %S_MSG, but it is actually encrypted by %S_MSG.");
		add(15487 , 16 , "The %s command specifies column '%.*s' as encrypted by key with %S_MSG, but it is actually not encrypted. Encrypt the column before using this command.");
		add(15488 , 16 , "Encryption with keys from a local temporary database '%.*s' in a cluster is not allowed. Please change the command to encrypt with keys from a global database.");
		add(15489 , 16 , "Cannot create a key copy for 'guest' for login association.");
		add(15490 , 16 , "Guest's key copy cannot be altered for encryption by a login password.");
		add(15491 , 16 , "A %S_MSG already exists for this database. You may use ALTER ENCRYPTION KEY to regenerate a new one.");
		add(15493 , 16 , "SET CIPHERTEXT ON/OFF command is not allowed in the definition of an instead-of trigger.");
		add(15494 , 16 , "The %S_MSG does not exist in database '%S_DBID'. Use CREATE ENCRYPTION KEY to create one, if needed.");
		add(15496 , 10 , "Failed to update sysencryptkeys in database '%S_DBID' during operation to re-encrypt keys with the master key.");
		add(15497 , 16 , "The password for the %S_MSG of database '%S_DBID' has not been set.");
		add(15498 , 16 , "Master and dual master keys in the same database must be owned separately.");
		add(15499 , 16 , "The key copy assignee on the alter encryption key command may not be a group or a role.");
		add(15502 , 10 , "Inserted row into sysservers table for cluster instance '%.*s'.");
		add(15503 , 18 , "Failed to insert row into sysservers table for cluster instance '%.*s'.");
		add(15506 , 18 , "Cannot synchronize sysservers table with cluster instance information. Try to synchronize using procedures sp_addserver, sp_dropserver and sp_serveroption.");
		add(15507 , 10 , "Deleting row (srvid=%d srvname='%.*s') from sysservers table as '%.*s' is no longer a cluster instance.");
		add(15508 , 16 , "Cannot insert row for cluster instance '%.*s'; there is a conflicting row (srvid=%d srvname='%.*s') in sysservers table.");
		add(15509 , 16 , "Current value of srvid column in sysservers table has reached maximum limit (%d). Cannot insert any more rows into sysservers table to synchronize with cluster instance information.");
		add(15510 , 16 , "Cannot insert row into sysservers table for cluster instance '%.*s'; length of instance name (%d) exceeds maximum limit (%d).");
		add(15511 , 16 , "instance id '%d' is out of range: '%d' to '%d'.");
		add(15512 , 16 , "instance name '%.*s' is too long for the '%s' request.");
		add(15513 , 10 , "add_server request: instance: '%s' instance id: '%d' cipc info: '%s'.");
		add(15514 , 16 , "cipc info '%.*s' for server name '%.*s' is too long for the add_server request.");
		add(15515 , 16 , "add_server: Instance with name '%s' or instance with id '%d' already exists.");
		add(15516 , 18 , "add_server: could not allocate cluster admin message from CIPC pool. cipcmsg_alloc() failed.");
		add(15517 , 16 , "add_server: cipc protocol '%s' for the instance does not match current cluster protocol '%s'.");
		add(15518 , 18 , "Failed to send cluster admin message.");
		add(15519 , 16 , "drop_server: Instance with name '%.*s' does not exist in the cluster.");
		add(15520 , 18 , "Error while handling CIPC messages.");
		add(15521 , 16 , "drop_server: instance %.*s is active and not shut down yet.");
		add(15522 , 16 , "Cannot drop the instance. The local temporary database resources for instance %d have not been released.");
		add(15523 , 18 , "drop_server: could not allocate cluster admin message from CIPC pool. cipcmsg_alloc() failed.");
		add(15524 , 10 , "instance '%d' sets new %s to '%d'.");
		add(15525 , 16 , "Incorrect value %s. The minimum is %d.");
		add(15526 , 18 , "Could not allocate cluster admin message from CIPC pool.");
		add(15527 , 16 , "Incorrect subcommand. Valid ones are: '%s'.");
		add(15530 , 15 , "Instance '%.*s' does not exist.");
		add(15531 , 18 , "Failed to initialize object coherency header at address 0x%p.");
		add(15532 , 18 , "Failed to initialize object coherency block at address 0x%p.");
		add(15533 , 16 , "add_server: Invalid server name - NULL Specified.");
		add(15534 , 16 , "add_server: Invalid CIPC Information - NULL Specified.");
		add(15535 , 16 , "add_server: missing net address for the %s interconnect.");
		add(15536 , 16 , "add_server: missing start port information for the %s interconnect");
		add(15537 , 16 , "add_server: missing end port information for the %s interconnect.");
		add(15538 , 16 , "add_server: Invalid or unsupported nettype '%s' specified for the '%s' interconnect.");
		add(15539 , 16 , "Invalid cluster_admin command '%.*s' is specified.");
		add(15540 , 16 , "NULL command is specified in cluster_admin. Please use a valid command.");
		add(15541 , 16 , "drop_server: ID Mismatch - The given id (%d) does not match the id (%d) obtained from the given server name");
		add(15542 , 16 , "add_server: CIPC interconnect host name mismatch - primary is specified with hostname '%s' and secondary with hostname '%s'.");
		add(15543 , 16 , "drop_server: CIPC node drop failed - Unable to drop the instance with id (%d).");
		add(15544 , 15 , "Instance %d does not exist.");
		add(15545 , 18 , "Fail to drop sysconfigures entries for instance id %d.");
		add(15546 , 10 , "Message originated on cluster instance %d with message number %d, severity %d, and state %d: %.*s");
		add(15547 , 10 , "node/cluster_cur should never bigger than node/cluster_max.");
		add(15548 , 21 , "Adaptive Server has been denied access to the master device by the I/O fencing subsystem. The server will shut down.");
		add(15549 , 16 , "Cannot drop the instance. First drop all the private devices owned by the instance %d.");
		add(15550 , 16 , "The sum, ( ((%s) + (%s) + (%s) + (%s)) / (%s) ) + (%s %s) + (%s) %s, must be no greater than '%d'.");
		add(15551 , 10 , "Assigned recovery of dbid=%d to csvr=%d, reqid=%d, map=0x%x.");
		add(15552 , 10 , "ERROR!! Failed to recover dbid=%d on csvr=%d, reqid=%d. Leaving the db in unrecovered/being-recovered state. pcmreply=%p, pcmmsg=%p.");
		add(15553 , 10 , "Successfully recovered dbid=%d on csvr=%d, reqid=%d.");
		add(15558 , 18 , "Attempt to acquire object coherency lock for '%s' (ID = %d) failed. Return status is %d.");
		add(15600 , 20 , "Lookup of systabstats for %S_PTNINFO failed.");
		add(15601 , 16 , "Failed to cache systabstats contents for %S_OBJINFO.");
		add(15602 , 20 , "Update to systabstats row for %S_PTNINFO failed.");
		add(15603 , 10 , "Upgrade has finished in database '%.*s'. ASE is now updating table level statistics for its system tables. Please be patient.");
		add(15604 , 16 , "The statistics coherency mode is %.*s with threshold value of %d");
		add(15605 , 16 , "Table id %d index id %d partition id %d: statistics lag value=%d. STAT FIELD VALUES: ts_indexheight = %d, ts_leafct = %d, ts_unused_pgct = %d, ts_oam_pgct = %d, ts_nrows = %f, ts_nforwrows = %f, ts_ndelrows = %f, ts_dextent_extraio = %f");
		add(15606 , 16 , "Table id %d index id %d partition id %d: STAT FIELD VALUES: ts_iextent_extraio = %f, ts_page_extraio = %f, ts_oam_apg_ct = %d, ts_ext0_pg_ct = %d, ts_datarowsize = %f, ts_leafrowsize = %f, ts_plljoindegree = %d");
		add(15607 , 16 , "Table id %d index id %d partition id %d: STAT FIELD VALUES: ts_rslastoam = %d, ts_rslastpage = %d, ts_frlastoam = %d, ts_frlastpage = %d, ts_conopt_thld = %d, ts_plldegree =%d, ts_empty_pg_cnt = %d");
		add(15608 , 10 , "If this option is enabled, before the backup server establishes a remote connection to another backup server, the connection socket is bound to an address where the backup server is listening on.");
		add(15609 , 10 , "The 'enable delta dump tran' option will avoid that DUMP TRANSACTION copies pages that have been copied in a previous transaction dump. If disabled, every transaction dump will contain all the log pages from the oldest active tratsaction.");
		add(15610 , 10 , "When the configuration option 'enable buffered io for load' is enabled, ASE will ask the Backup Server to open the database devices using buffered I/O at load time, independently of the devices being configured to use DSYNC or DIRECTIO.");
		add(15611 , 10 , "If this option is enabled the database options of the source database will be applied to the target database when either a full, cumulative or transaction dumps are loaded.");
		add(15613 , 10 , "The HCB index memory pool size parameter indicates the total amount of memory to store index hash caching information.");
		add(15614 , 10 , "This configuration option determines whether ASE encryption key management should use an external key store.");
		add(15615 , 10 , "This configuration option determines the default timeout value for the streaming replication message channel used to communicate with Replication Server.");
		add(15700 , 16 , "Failed to read the virtual page '%d' from the device '%d'.");
		add(15701 , 16 , "Error in dump format. End of page list expected.");
		add(15702 , 16 , "Failed to insert entry into the database disk map.");
		add(15703 , 16 , "Failed to delete row(s) from sysaltusages in the scratch database.");
		add(15704 , 16 , "The size of at least one stripe exceeds the maximum size of 32 GB. Consider striping the dump using more stripes in order to reduce the size of each stripe.");
		add(15705 , 16 , "The dump device '%.*s' is already in use by the database '%d'.");
		add(15706 , 16 , "The dump device '%.*s' is already in use as a %s.");
		add(15707 , 16 , "Failed to insert the attribute into master.dbo.sysattributes.");
		add(15708 , 16 , "The archive database is in an incorrect state to be loaded.");
		add(15709 , 16 , "There is no scratch database for the archive database '%d'.");
		add(15710 , 16 , "The scratch database '%.*s' is not useable for an archive database.");
		add(15711 , 16 , "A remote backup server, 'compress::' and other dump attributes cannot be specified in the LOAD DATABASE or LOAD TRANSACTION command.");
		add(15712 , 16 , "Failed to initialize device '%.*s'.");
		add(15713 , 16 , "Failed to insert row into sysaltusages in the scratch database.");
		add(15714 , 16 , "The length (%d) of the device name '%.*s' is too long. It must be at most 255 characters.");
		add(15715 , 16 , "Unable to open or create the sysaltusages table in the scratch database '%.*s'.");
		add(15716 , 16 , "Failed to delete the entries for the archive database with ID '%d' from sysaltusages in the scratch database '%.*s'.");
		add(15717 , 16 , "The archive database '%.*s' is already being updated by the process with spid '%d'. Please try again later.");
		add(15718 , 18 , "Invalid parameter specified.");
		add(15719 , 16 , "Failed to update the sysaltusages table in the scratch database with the modified disk map entries.");
		add(15720 , 10 , "Invalid options specified in the LOAD DATABASE or LOAD TRANSACTION command have been ignored.");
		add(15721 , 16 , "Duplicate device '%.*s' specified.");
		add(15722 , 10 , "Warning: The archive database '%.*s' appears to be in the process of being updated by a process other than this one. No action need be taken.");
		add(15723 , 20 , "Unable to update sysaltusages in the scratch database after making changes to the archive database '%.*s'.");
		add(15724 , 10 , "The database '%.*s' cannot be used as a scratch database. Please execute the sp_dboption stored procedure using the 'scratch database' option.");
		add(15725 , 16 , "The database cannot be dropped because it is being used as the scratch database for the archive database '%S_DBID'. Drop the archive database first.");
		add(15726 , 16 , "The number of stripes in the LOAD DATABASE or LOAD TRANSACTION command (%d) does not match the the number of stripes originally dumped (%d).");
		add(15727 , 16 , "At least one stripe specified in the LOAD DATABASE or LOAD TRANSACTION command is not part of set of stripes that were originally dumped.");
		add(15728 , 16 , "Unable to get exclusive access to the archive database '%.*s'.");
		add(15729 , 18 , "Testing hook to test cleanup after a fatal exception.");
		add(15730 , 16 , "Unable to create the original disk map for the archive database.");
		add(15731 , 10 , "Warning: Unable to reclaim space in the modified pages section of the archive database '%.*s' prior to loading it. The load will continue without reclaiming the space.");
		add(15732 , 18 , "Unable to clean up stale information from system catalogs for the archive database '%.*s' prior to loading it.");
		add(15733 , 16 , "An option specified in the ALTER DATABASE command is not valid for an archive database.");
		add(15734 , 16 , "The size of the memory pool used for compressed blocks (%d) is too small as a minimum of '%d' pages is needed. Use sp_configure 'compression memory size' to increase this.");
		add(15735 , 16 , "The dump cannot be loaded into an archive database because the format of the compressed dump is not supported.");
		add(15736 , 21 , "Unable to remap the page '%u' to the modified pages section in the archive database '%.*s'.");
		add(15737 , 21 , "An internal error occured during the remapping of a page in the archive database '%.*s'.");
		add(15738 , 16 , "There is no more space in the modified pages section for the archive database '%.*s'. Use the ALTER DATABASE command to increase the amount of space available to the database.");
		add(15739 , 16 , "Space in the modified pages section for the archive database '%.*s' has not been extended. Operation will be aborted.");
		add(15740 , 21 , "Attempt to read page %u (mass virtual page: 0x%08x, id: %d) for the archive database '%.*s' using a buffer from a large memory pool.");
		add(15741 , 20 , "Attempt to change the archive database '%.*s' without obtaining the requisite approval.");
		add(15742 , 20 , "Unable to obtain approval to change the archive database '%.*s'.");
		add(15743 , 20 , "Unable to save the changes made to the modified pages section in the archive database '%.*s'.");
		add(15744 , 16 , "Unable to get exclusive access to the archive database '%.*s' because it is being used. Please try again later.");
		add(15745 , 10 , "Any changes that may have been made to the archive database '%S_DBID' have been lost because of a failure to save the changes to the modified pages section.");
		add(15746 , 16 , "Unable to run this command on the archive database '%S_DBID' because it is not supported.");
		add(15747 , 16 , "Unable to run this DBCC command on the archive database '%S_DBID' because it has not been recovered.");
		add(15748 , 18 , "Unable to checkpoint the archive database '%.*s'.");
		add(15749 , 16 , "Unable to run this command on the archive database '%.*s' because it is not supported.");
		add(15750 , 16 , "The 'master' database cannot be loaded into an archive database.");
		add(15751 , 16 , "The status '%d' indicates that '%.*s' is not an 'archive database' device. Either specify a physical device name or create a logical device using sp_addumpdevice with the 'archive database' option.");
		add(15754 , 20 , "Unable to read and decompress the block that contains page %u in the archive database '%S_DBID'.");
		add(15755 , 16 , "Unable to determine the size of the device '%s'.");
		add(15756 , 10 , "Invalid compression format found in device '%.*s'. The compression will be ignored.");
		add(15757 , 16 , "The compression format found in device '%.*s' differs from the format of a previous stripe. This stripe set cannot be loaded.");
		add(15758 , 20 , "Unable to remove the disposable changes segment from the modified pages section in the archive database '%S_DBID'.");
		add(15759 , 20 , "Internal error occurred when attempting to load the archive database '%S_DBID'.");
		add(15760 , 20 , "Invalid dump header when loading the database with ID '%d'.");
		add(15761 , 20 , "Unable to determine the device sequence number when loading the archive database '%S_DBID'.");
		add(15762 , 20 , "The archive database '%S_DBID' was loaded using a version of Adaptive Server that precedes that required for LOAD TRAN. Reload the database dump.");
		add(15763 , 20 , "LOAD TRANSACTION cannot load the archive database '%S_DBID' because it was loaded WITH NORECOVERY. Reload the database without WITH NORECOVERY.");
		add(15764 , 16 , "Adaptive Server was shut down abnormally while LOAD TRANSACTION was active in the archive database '%S_DBID'. Execute the LOAD TRANSACTION command again.");
		add(15765 , 16 , "The device '%.*s' found in sysattributes seems stale. The device number expected is '%d' but instead '%d' was found.");
		add(15766 , 16 , "The archive database feature is not supported in this version of Adaptive Server. You cannot use database '%.*s'.");
		add(15767 , 16 , "The archive database '%.*s' is currently being updated on the cluster instance '%d'. Execute %s on that node.");
		add(15768 , 16 , "The archive database '%.*s' is currently being updated on the cluster instance '%d'. %s cannot be executed until the update completes. Please retry later.");
		add(15900 , 10 , "The total number of pages in partition '%.*s' (partition ID %d) with more than %d percent garbage is %d.");
		add(15901 , 10 , "The total number of pages in partition '%.*s' (partition ID %d) with more than %d percent insert free space is %d.");
		add(15902 , 10 , "The total number of TEXT/IMAGE/UNITEXT pages in partition '%.*s' (partition ID %d) is %d.");
		add(15903 , 10 , "The total number of empty pages (with all deleted rows) in partition '%.*s' (partition ID %d) is %d.");
		add(15904 , 10 , "The total number of pages in partition '%.*s' (partition ID %d) which could be garbage collected to free up some space is %d.");
		add(15905 , 16 , "You can run DBCC '%.*s' only on virtually hashed tables.");
		add(15906 , 16 , "Virtually hashed table '%.*s' corrupt. The expected number of data pages between two consecutive OAM extents is %d; however, %d pages have been allocated.");
		add(15907 , 16 , "Virtually hashed table '%.*s' corrupt. Data page %u is allocated in extent %u that is reserved for OAM pages.");
		add(15908 , 16 , "Virtually hashed table '%.*s' corrupt. OAM page %u is allocated in extent %u; however, OAM page for hash region must be allocated in first extent of allocation unit.");
		add(15909 , 16 , "Virtually hashed table '%.*s' corrupt. Expected number of data pages in hash region is %d; however, %d pages have been allocated.");
		add(15910 , 16 , "The engine online operation failed. Check the error log for more information.");
		add(15911 , 16 , "Partition condition corrupt for table id: %d, index id: %d, partition condition id: %d, the partition ids in sysprocedures do not match those in syscomments.");
		add(15912 , 16 , "Table Corrupt: User (id %d) for key copy does not match between %.*s and %.*s.");
		add(15913 , 16 , "Table Corrupt: Base key (id %d) for key copy assigned to user %d was not found in sysencryptkeys.");
		add(15914 , 16 , "Failed to bind dbcc named cache '%.*s' to the scan workspace '%.*s'.");
		add(15915 , 16 , "CIPCTEST: test cannot be initiated.");
		add(15916 , 16 , "Text pointer value %s references a data page with an invalid timestamp. This value is for TEXT/IMAGE column %d, in row %d located on page %d, partition ID %d for object with ID %d and references first text page %d.");
		add(15917 , 16 , "Text pointer value %s references a data page with an invalid text status. This value is for TEXT/IMAGE column %d, in row %d located on page %u, partition ID %d for object with ID %d and references first text page %u.");
		add(15918 , 16 , "Text pointer value %s conflicts with the column name specified. This value is for TEXT/IMAGE column %d, in row %d located on page %u, partition ID %d for object with ID %d and references first text page %u.");
		add(15919 , 10 , "fence_admin: Invalid input");
		add(15920 , 10 , "fence_admin: Succeeded");
		add(15921 , 10 , "fence_admin: Failed");
		add(15923 , 17 , "The cache '%.*s' specified in the dbcc_config table cannot be used because it is an instance only cache.");
		add(15924 , 0  , "The CHECKSTORAGE operation cannot use the workspace '%.*s' in database '%.*s' simultaneously for scan and text workspace. Use sp_dbcc_updateconfig to correct the problem.");
		add(15925 , 16 , "Terminating the listener with protocol %s, host %s, port %s because the listener execution context is located on engine %d, which is not responding.");
		add(15926 , 10 , "Cannot complete recovery of row counts and other metadata information for database '%.*s'. Use DBCC CHECKALLOC(%.*s, fix) command to ensure that this information is correct.");
		add(15927 , 10 , "The OAM page hint for some extents were out of date, and have now been updated.");
		add(15928 , 16 , "DBCC %.*s is not supported in database '%S_DBID' which is of type '%.*s'.");
		add(15929 , 16 , "Value %d for option '%s' is not applicable for pages from an in-memory database.");
		add(15931 , 16 , "%s: engine parameter is ignored in threaded-mode kernel");
		add(15932 , 16 , "The listener wih protocol %s, host %s, port %s is not suspended.");
		add(15933 , 16 , "A listener with protocol %s, host %s, port %s already exists.");
		add(15934 , 16 , "There is no listener with protocol %s, host %s, port %s.");
		add(15935 , 16 , "The listener with protocol %s, host %s, port %s is already suspended.");
		add(15936 , 16 , "An error was encountered when starting a listener with protocol %s, host %s, port %s.");
		add(15937 , 16 , "The password in database %S_DBID for %.*s that is stored in sysattributes class=%d, attribute=%d, cannot be decrypted with current encryption key. Re-enter or remove the password to correct the inconsistency.");
		add(15938 , 10 , "Table Corrupt: Login profile (id %d) for '%.*s' attribute stored in master.dbo.sysattributes does not exist in syslogins.");
		add(15939 , 10 , "Table Corrupt: Login profile (id %d) associated with login (suid %d) does not exist in syslogins.");
		add(15940 , 16 , "This command is not supported in threaded mode. To achieve the same result in threaded mode, use the 'alter thread pool' command to change '%s'.");
		add(15941 , 10 , "Invalid column length %d found for compressed column, column ID %d, row ID %d, page number %u, partition ID %d. Fixed-length column cannot have a NULL value.");
		add(15942 , 16 , "Table has %s row-level only compressed rows, and %s page-level compressed rows.");
		add(15943 , 16 , "The total number of page-level compressed pages in this table is %s.");
		add(15944 , 16 , "Partition '%.*s' (partition ID %d) has %s row-level only compressed rows, and %s page-level compressed rows.");
		add(15945 , 16 , "The total number of page-level compressed pages in partition '%.*s' (partition ID %d) is %s.");
		add(15946 , 16 , "Invalid column length %d found for column, column ID %d, row ID %d, page number %u, partition ID %d. The length is greater than the expected maximum column length %d.");
		add(15947 , 16 , "Invalid column length %d found for compressed column, column ID %d, row ID %d, page number %u, partition ID %d. The last compressed column cannot be a NULL column.");
		add(15948 , 16 , "Table Corrupt: Row %d in page %u cannot reside in a valid partition.");
		add(15949 , 16 , "Statistics mismatch while checking text page %d (partition ID %d). The %.*s in block header is %d, but it is %d in page.");
		add(15950 , 16 , "The encryption flags of page %d (partition ID %d) do not match that found in system catalog.");
		add(15951 , 16 , "The length %d of data on text page %d (partition ID %d) is invalid for encrypted data.");
		add(15952 , 16 , "Row %d in page %u is page dictionary compressed, but the page has no page dictionary.");
		add(15953 , 16 , "Row %d in page %u is page index compressed, but the page has no page index.");
		add(15954 , 16 , "Page dictionary entry num %d of column %d Row %d in page %u should be less or equal to num of page dictionary entries which is %d.");
		add(15955 , 16 , "Row %d in page %u is page dictionary compressed, but no column is page dictionary compressed.");
		add(15956 , 16 , "Row %d in page %u has page dictionary compressed columns, but it is not marked as page dictionary compressed.");
		add(15957 , 10 , "There are %s pages with page index and %s pages with page dictionary that are not referenced or referenced only once in partition '%.*s' (partition ID %d).");
		add(15958 , 16 , "This command is not supported on Dynamic Hash Tables ('%.*s').");
		add(15959 , 16 , "This command is not supported on dynamic hash table indid = 253 entries because no disk storage is involved. (Table '%.*s')");
		add(15960 , 10 , "The compression information of LOB started with page %u does not match that found in system catalog.");
		add(15961 , 10 , "Statistics of '%.*s' mismatch while checking the LOB value started with page %u.");
		add(15962 , 16 , "Compressed text column '%.*s' cannot be fixed; decompress the column before changing the character set.");
		add(15963 , 16 , "Warning: Row ID in Text/Image Page Status Area on the first text page %u has not been updated, and the text page chain has not been fully rebuilt. For a full rebuild, re-run the command without specifying the first text page number.");
		add(15964 , 16 , "Number of characters that can be encoded into four bits on page %u is %d, which should not be more than 9.");
		add(15965 , 10 , "Table '%.*s' in database '%.*s' is a deferred table that does not have any allocated space to check.");
		add(15966 , 16 , "Permissions for built-in functions and DBCC cannot be downgraded.");
		add(15967 , 16 , "The '%.*s' command failed when updating permissions to system roles in database '%.*s'. The roles in the database may not have the correct permissions.");
		add(15968 , 16 , "%s: parameter %d is not specified.");
		add(15969 , 16 , "You must be in database '%.*s' to run this %s command.");
		add(15970 , 16 , "The forwarded row (%u, %d) pointed to by row (%u, %d) in partition ID %d is invalid.");
		add(15971 , 16 , "You must disable the option '%s' in the database '%.*s' before executing this command.");
		add(15972 , 16 , "This command can be executed only when the database option 'allow incremental dumps' is set and a full database dump is available.");
		add(15974 , 16 , "Attempt to remove an anchor for object '%s' in database '%.*s' failed.");
		add(15975 , 18 , "Attempt to drop the object '%s' in database '%.*s' failed.");
		add(15976 , 18 , "Attempt to redo the last part of shrink database in database '%.*s' failed with error code %d.");
		add(15977 , 18 , "Partition '%.*s' (partition id %d) should have text back link pointers, but the status of this partition indicates it does not.");
		add(15978 , 16 , "Status bits on sysindexes.status3 for Index %.*s (ID %d) are inconsistent while it's marked as index compressed.");
		add(15979 , 16 , "The value(%d) of fixed length field of compressed leaf page %u of index ID %d is incorrect.");
		add(15980 , 16 , "The prefix entry (ID %d) used for row %d in leaf page %u of index ID %d doesn't exist in current prefix row.");
		add(15981 , 16 , "The breakpoint %d of row %d in leaf page %u of index ID %d should not be more than key columns' number %d or 0.");
		add(15982 , 10 , "Index compression dictionaries for index '%.*s' (ID %d) are not up to date and not efficient, please run REORG REBUILD INDEX to regenerate them.");
		add(15983 , 16 , "The length(%d) of prefix entry (ID %d) used for row %d in leaf page %u of index ID %d is incorrect.");
		add(15984 , 16 , "Column %d on index compressed row %d in leaf page %u of index ID %d is corrupt. The length should be %d but got %d.");
		add(15985 , 16 , "Length of column %d on index compressed row %d in leaf page %u of index ID %d is incorrect.");
		add(15986 , 16 , "Length of index compressed row %d in leaf page %u of index ID %d is %d while the calculated length is %d.");
		add(15987 , 16 , "Offset table in leaf page %u of index %d is corrupt. No offset entry found that is next to row %d.");
		add(15988 , 10 , "Index partition '%.*s' (ID %d) of index '%.*s' (ID %d) has %s index leaf rows, and %s of them are compressed.");
		add(15989 , 10 , "Index partition '%.*s' (ID %d) of index '%.*s' (ID %d) has %u index leaf pages, and %u of them contain(s) compressed row(s).");
		add(15990 , 10 , "Index '%.*s' (ID %d) has %s index leaf rows, and %s of them are compressed.");
		add(15991 , 10 , "Index '%.*s' (ID %d) has %u index leaf pages, and %u of them contain(s) compressed row(s).");
		add(15992 , 10 , "Column '%.*s' (ID %d) on Index '%.*s' (ID %d) is chosen most frequently as breakpoint for index compression.");
		add(15993 , 16 , "Index compressed row %d in leaf page %u of index ID %d contains unused status bit(%s: 0x%x).");
		add(15994 , 16 , "Index leaf row %d in leaf page %u of index ID %d contains unexpected status bits(status 0x%x), run sp_fixindex.");
		add(15995 , 16 , "Mismatch between the 'undeleted row count' value (%d) in the page header of index leaf page %u, partition ID %d, index ID %d, and the actual amount of undeleted rows (%d) in the page.");
		add(15996 , 16 , "NCFS on leaf page %u appears to be incorrect. Expected %u, but got %u.");
		add(15997 , 16 , "The number of RIDs not deleted on leaf page %u appears to be incorrect. Expected %u, but got %u.");
		add(15998 , 10 , "NCFS in the page header of leaf page %u, partition ID %d, has been corrected to %d.");
		add(15999 , 10 , "The not deleted number of RIDs in the page header of leaf page %u, partition ID %d, has been corrected to %d.");
		add(16000 , 16 , "TEXT and IMAGE are invalid datatypes for columns of Virtually hashed table '%.*s'.");
		add(16001 , 16 , "Segment ID %d already has a virtually hashed table. Create a different segment.");
		add(16002 , 16 , "Status of segment ID %d doesn't have status bit for virtually hashed table set.");
		add(16003 , 16 , "Segment ID %d is not an exclusive segment. You can create a virtually hashed table only on an exclusive segment.");
		add(16004 , 16 , "Segment ID %d already has an object. You can create a virtually hashed table only on a segment that does not have any other object.");
		add(16005 , 16 , "Virtually hashed tables are not supported on this platform.");
		add(16006 , 16 , "You cannot set the max_rows_per_page attribute for Virtually hashed table '%.*s'.");
		add(16007 , 16 , "%.*s' is not supported on virtually hashed table.");
		add(16008 , 16 , "Job Scheduler is starting. Wait a few minutes, then retry the Job Scheduler command.");
		add(16009 , 16 , "The %.*s LDAP URL state is already set to '%s'.");
		add(16011 , 16 , "The utility command on the table '%.*s' cannot be executed because it is currently in use. Please retry your command.");
		add(16012 , 16 , "Cannot create a column reference to data in a local temporary database '%.*s' in a cluster.");
		add(16014 , 16 , "Sybase HA is not a valid option in ASE CE release.");
		add(16015 , 16 , "You cannot specify an 'out of range' histogram adjustment option at the same time as 'partition name', or other options. Only a list of columns (col1), (col2), etc is allowed.");
		add(16016 , 16 , "The 'out of range' histogram adjustment update failed. The column does not have any existing statistics.");
		add(16017 , 16 , "Cannot open database %d.");
		add(16018 , 16 , "The operation cannot be completed because LDAP user authentication has not been initialized.");
		add(16019 , 16 , "Secure LDAP is not configured.");
		add(16020 , 16 , "%s' is an invalid operation on the table created with 'for load' option.");
		add(16021 , 16 , "Failed to unpartition the table '%.*s' because the first partition is empty. Tables with 'for load' option must have non-empty first partition.");
		add(16022 , 17 , "The ASE PCI-Bridge is not able to process the requested dispatching. This is a fatal error, please contact your System Administrator (SA) for help.");
		add(16023 , 10 , "The trigger on '%.*s' will not be executed because it's an unlogged table. Execute ALTER TABLE %.*s SET LOG to enable it.");
		add(16024 , 10 , "This '%s' command failed to record its status in table '%.*s'.");
		add(16025 , 20 , "%s %.*s: command failed with status %d.");
		add(16026 , 16 , "%s: the requested column order (%.*s) cannot be used with the requested destination type (%.*s).");
		add(16027 , 16 , "%s: datatype %d (%s, column '%.*s') cannot be written using output file type '%.*s'.");
		add(16028 , 16 , "%s: value '%.*s' is not valid for option '%.*s'.");
		add(16029 , 16 , "%s: '%.*s' is not a valid %S_MSG for %S_MSG '%.*s'.");
		add(16030 , 10 , "Failed to open table '%.*s'. This command cannot record its status.");
		add(16031 , 10 , "Transfer %d of object '%.*s' is %d percent done (%d/%d), has sent %s Mb in %s rows.");
		add(16032 , 16 , "Invalid value '%.*s' specified for '%.*s' option. Allowed values are listed in the Adaptive Server Reference Manual.");
		add(16033 , 20 , "Cannot change the '%.*s' option due to an internal error. Retry the command.");
		add(16034 , 16 , "The '%.*s' option cannot be used along with other clauses of this command.");
		add(16035 , 10 , "This transaction must synchronize with a data transfer for table '%.*s'. The transfer is currently at page %u, but must pass page %u before this transaction may proceed.");
		add(16036 , 16 , "%s failed. In-memory database '%.*s' must be created with durability level %s.");
		add(16037 , 10 , "Warning: Database '%.*s' has a durability level of NO_RECOVERY; changes to it will be lost when you restart Adaptive Server.");
		add(16038 , 10 , "Warning: Database '%.*s' has a durability level of AT_SHUTDOWN; changes to it could be lost when you restart Adaptive Server after an abnormal shutdown.");
		add(16039 , 18 , "The transaction log in database '%.*s' shows activity requiring recovery. The database cannot be recovered, as it has a durability level '%s' and will therefore be marked suspect.");
		add(16040 , 16 , "%s failed. The durability value specified for database '%.*s' is invalid. For a database with %s, the only durability levels allowed are one of %s.");
		add(16041 , 10 , "The database '%.*s' with durability 'AT_SHUTDOWN' could not be shut down properly and will not be recovered when Adaptive Server is re-started.");
		add(16042 , 16 , "%s is not allowed for database '%.*s' which is at durability level %s.");
		add(16043 , 16 , "The option '%.*s' cannot be used for %s databases or for objects in %s databases.");
		add(16044 , 16 , "The option '%.*s' cannot be used for system tables.");
		add(16045 , 16 , "The option '%.*s' cannot be used for tables with referential integrity constraints.");
		add(16046 , 10 , "Database '%S_DBID' with durability '%s' has active transactions, and will be marked as suspect following the restart of Adaptive Server.");
		add(16047 , 16 , "%s failed. Database '%.*s' is of type %s, and the only durability allowed for such databases is %s.");
		add(16048 , 16 , "%s failed. Database '%.*s' at durability %s has one or more database options which prevent changing the durability to '%.*s' . Retry the command after turning off these options: '%s'.");
		add(16049 , 10 , "Warning: The database '%.*s' is assigned the %s property, which will be ignored, because the database has a durability of %s.");
		add(16050 , 16 , "%s: option '%.*s' is not valid for this transfer.");
		add(16051 , 10 , "Warning: At least one table in the database '%.*s' is assigned the %s property, which will be ignored, because the database has a durability of %s.");
		add(16052 , 16 , "Cannot change the %s option of the database '%.*s' because the database is in use. Retry the command when there are no users in the database, or use sp_dboption '%.*s', '%s', 'true' to put the database in '%s' mode.");
		add(16053 , 16 , "The command '%s' with property '%s' is currently not supported in SAP Adaptive Server%s%s.");
		add(16055 , 16 , "%s for database '%.*s' failed. A database must have a durability of FULL in a high-availability environment.");
		add(16056 , 20 , "TRANSFER TABLE not supported for tables with off-row columns, including text, unitext, image, and most Java columns.");
		add(16057 , 16 , "There is no thread pool named '%.*s' defined in the system.");
		add(16058 , 16 , "You cannot rename the thread pool to '%.*s', that name already exists.");
		add(16059 , 16 , "You cannot create thread pool '%.*s', as a thread pool with that name already exists.");
		add(16060 , 16 , "You cannot modify the description of a system thread pool.");
		add(16061 , 16 , "You cannot rename system thread pools.");
		add(16062 , 16 , "You cannot rename the thread pool to '%.*s', as that is a reserved name for system thread pools.");
		add(16063 , 16 , "You cannot run '%s' affecting %S_MSG '%.*s' because the %s license is either not available or has expired.");
		add(16064 , 16 , "%s: file '%.*s': file open failed with error %d: %.*s");
		add(16065 , 16 , "%s: file '%.*s': file write failed with error %d: %.*s");
		add(16066 , 16 , "%s: file '%.*s': file read failed with error %d: %.*s");
		add(16067 , 20 , "%s: transfer for '%.*s' is not permitted when receiving file is a pipe.");
		add(16068 , 20 , "%s: this command is not currently permitted on ASE CE release.");
		add(16069 , 16 , "%s: you may not transfer this data in to tables in database '%.*s'. When the transfer command is enabled under the %s license, the source and destination database cannot both be disk resident databases with full durability.");
		add(16070 , 10 , "Transfer in of object '%.*s' has received %s Mb in %s rows.");
		add(16071 , 16 , "Command '%s' not executed because the database '%S_DBID' is in %s mode.");
		add(16072 , 16 , "Threadpool %s is in use by an execution class definition. Delete the execution class before trying to drop the threadpool.");
		add(16073 , 16 , "LOB datatypes are not valid as an output parameter.");
		add(16074 , 16 , "The description of the thread pool cannot be more than %d characters.");
		add(16075 , 20 , "'%s' is not supported when the kernel mode is set to '%s'.");
		add(16076 , 16 , "A login mapping for the name '%.*s' already exists in this Server. Drop an existing mapping before creating a new mapping.");
		add(16077 , 16 , "You cannot alter '%s' for thread pool '%s'.");
		add(16078 , 16 , "The total number of threads across the engine thread pools exceeds the value of 'max online engines'. Either retry the command with a lower thread count or increase the value of 'max online engines'.");
		add(16079 , 16 , "Invalid thread count specified, the thread count must be greater than zero.");
		add(16080 , 16 , "Invalid %s, only integer constants may be supplied.");
		add(16081 , 16 , "Cannot find %d pages to create DHT on current database.");
		add(16082 , 16 , "Feature '%S_MSG' is not supported for dynamic hash table.");
		add(16083 , 16 , "You cannot drop a dynamic hash key definition ('%.*s') from a dynamic hash table.");
		add(16086 , 16 , "The computed number of pages for this request, %.*s, is too large. The maximum page that Adaptive Server can address is %ld.");
		add(16087 , 10 , "Warning: Failed to apply keypair regeneration setting on all cluster instances. Please retry your command.");
		add(16088 , 22 , "The fragment information string for dynamic hash table '%.*s', ID %d is invalid or missing from sysattributes in database '%.*s'.");
		add(16089 , 16 , "Invalid idle timeout specified. Idle timeout must be greater than or equal to -1.");
		add(16090 , 16 , "The '%s' thread pool attribute may only be set for engine thread pools.");
		add(16091 , 16 , "Key word '%.*s' must appear in the hash by clause when creating/altering Dynamic Hash Table.");
		add(16092 , 16 , "Column '%.*s' -- cannot use HASH BY on columns of TEXT, IMAGE, UNITEXT or BIT data type.");
		add(16093 , 16 , "Column '%.*s' -- cannot use HASH BY on identity column.");
		add(16094 , 16 , "Column '%.*s' -- cannot use HASH BY on column of Java-SQL class datatype.");
		add(16095 , 16 , "Column '%.*s' -- cannot use HASH BY on computed/encrypted column.");
		add(16096 , 16 , "Cannot set the GAM ('global allocation map') bits for dynamic hash table.");
		add(16097 , 16 , "CREATE TABLE for dynamic hash table: '%.*s' failed: insufficient memory to allocate backout structure. Raise the value of the configuration parameter 'procedure cache size'.");
		add(16098 , 20 , "Cannot get the last log marker for database '%.*s'. %s %s on '%.*s' has been rolled back. Retry the command later.");
		add(16099 , 16 , "%s %s on '%.*s' failed as it cannot find a unique index on the table.");
		add(16100 , 10 , "Could not attempt LDAP authentication due to an internal error: '%S_MSG'.");
		add(16101 , 14 , "The Adaptive Server, which has been started as a Windows service, is paused. Login rejected.");
		add(16102 , 14 , "Cannot execute inbound RPC request. There was an error generated while creating the site handler task.");
		add(16103 , 14 , "NT trusted login check failed.");
		add(16104 , 14 , "Invalid SQL interface type.");
		add(16105 , 14 , "The syslogins table does not exist.");
		add(16106 , 14 , "Either the login name does not exist in syslogins or there is no login mapping specified for the user.");
		add(16107 , 14 , "No secure default login is configured. Login for user authenticated with external security mechanism rejected.");
		add(16108 , 14 , "Server is being upgraded. Only a system administrator can log in.");
		add(16109 , 14 , "Cannot complete outbound RPC request. Either remote access is not configured, or there was an error generated while creating the site handler task.");
		add(16110 , 14 , "Cannot allocate memory for host-based communication connection.");
		add(16111 , 14 , "Adaptive Server is running in single-user mode. The user does not have the system administrator role.");
		add(16112 , 14 , "Shutdown is in progress. Only the system administrator can log in.");
		add(16113 , 14 , "Cannot open user default database and the user does not have access permission for master database.");
		add(16114 , 14 , "Cannot read sysattributes, or unexpected value encountered while assigning a temporary database to this login session.");
		add(16115 , 14 , "Cannot convert remote login password to server character set.");
		add(16116 , 14 , "No remote or universal password has been specified for this remote login.");
		add(16117 , 14 , "Character set conversion failed.");
		add(16118 , 14 , "Cannot convert the login password to the server character set.");
		add(16119 , 14 , "Cannot set session authorization for automatic login.");
		add(16120 , 14 , "The automatic login access to database failed.");
		add(16121 , 14 , "Cannot send encryption key to client during login password handshake.");
		add(16122 , 14 , "Cannot receive encrypted password from client during login password handshake.");
		add(16123 , 14 , "The remote server name does not exist in sysservers.");
		add(16124 , 14 , "The sysremotelogins table does not exist.");
		add(16125 , 14 , "User that is attempting a remote login does not exist in the sysremotelogins table.");
		add(16126 , 14 , "Site-to-site connection failed; the sites have different security configurations.");
		add(16127 , 14 , "Cannot establish site hander security session with remote server.");
		add(16128 , 14 , "The automatic connection to the remote server failed.");
		add(16129 , 14 , "Either this is not an HA server, or the failover process has not completed. Failover connection rejected.");
		add(16130 , 14 , "HA login session failed.");
		add(16131 , 14 , "Cannot send HA session information to the HA client.");
		add(16132 , 14 , "HA client cannot respond to session information.");
		add(16133 , 14 , "Invalid option specified for this probe or RPC login authentication for connection to Open Server application.");
		add(16134 , 14 , "TDS version is earlier than 5.0 for this probe or RPC connection to Open Server application.");
		add(16135 , 14 , "Cannot send message stream for this probe or RPC login authentication for connection to Open Server application.");
		add(16136 , 14 , "Cannot receive message stream for this probe or RPC login authentication for connection to Open Server application.");
		add(16137 , 14 , "The probe or RPC login authentication for connection to Open Server application failed.");
		add(16138 , 14 , "Login authentication appears to have succeeded, but some initialization has not occurred.");
		add(16139 , 14 , "Database recovery is in progress. Only a system administrator can log in.");
		add(16140 , 10 , "Credential delegation failed.");
		add(16141 , 18 , "RSA decryption failed. Client should attempt to reconnect.");
		add(16142 , 16 , "Password length specified should be in the range from %d to %d.");
		add(16143 , 16 , "The password length supplied with the password_random builtin does not satisfy the global 'minimum password length'.");
		add(16144 , 16 , "The password_random builtin failed because the minimum password complexity checks disallow the use of any character or digit. Report this error to the System Security Officer.");
		add(16145 , 10 , "Update of companion syslogins was successful.");
		add(16146 , 10 , "The encrypted password for server '%s' was dropped by ASE Server because it exceeded the 255 bytes limit set to store the encrypted passwords.");
		add(16147 , 10 , "The encrypted password received for server '%s' by ASE Server exceeded the 480 bytes limit and hence was dropped.");
		add(16148 , 16 , "All logins have been assigned. No more logins can be added at this time.");
		add(16149 , 17 , "Backup Server cannot connect to Adaptive Server. Retry when there are fewer active archive operations in progress or increase the configuration parameter 'number of backup connections'.");
		add(16150 , 16 , "login: %.*s %.*s, spid: %d, kpid: %d (0x%0x), application name: %.*s, progname : %.*s, connectivity version: %d.%d.%d.%d\n");
		add(16152 , 16 , "To modify or drop the defdb attribute, drop the existing login_script attribute. You can reinstall the login_script attribute after the operation completes.");
		add(16153 , 14 , "Table Corrupt: The login profile that is applicable to this login account does not exist in syslogins. Run DBCC CHECKCATALOG on the master database to locate the inconsistency, then associate a valid login profile with this login account.");
		add(16154 , 16 , "The default language name in login record '%.*s' is not a recognized language name on this Adaptive Server. The default language '%.*s', specified through a login profile, will be used.");
		add(16155 , 16 , "Neither the language name in login record '%.*s', nor language name in login profile '%.*s' is a recognized language name on this Adaptive Server. Server-wide default '%.*s' will be used.");
		add(16156 , 16 , "The default language name from login profile '%.*s' is not a recognized language name on this Adaptive Server. Server-wide default '%.*s' will be used.");
		add(16157 , 10 , "Warning. Authentication mechanism '%.*s' is not enabled.");
		add(16158 , 16 , "An existing login mapping for user '%.*s' allows only '%.*s' authentication mechanism to be used.");
		add(16159 , 10 , "Role '%.*s' was not added or dropped for auto activation.");
		add(16160 , 16 , "NULL %S_MSG has been specified.");
		add(16161 , 16 , "'%.*s' is not a valid login profile name.");
		add(16162 , 10 , "Password length of %d is greater than allowed length %d.");
		add(16163 , 10 , "Warning: Remote instance %d has both roles '%.*s' and '%.*s' enabled. This violates the '%.*s' exclusivity just added. Terminate the user's process to remove the violation. Refer to the errorlog of the instance for more information.");
		add(16164 , 10 , "The decrypted nonce message does not match expected nonce value.");
		add(16165 , 14 , "Cannot receive encrypted symmetric key from client.");
		add(16166 , 16 , "A key already exists on HSM external keystore for this SAP ASE instance.");
		add(16167 , 16 , "UUID '%.*s' is invalid.");
		add(16168 , 16 , "Could not found unique key on HSM device with UUID '%.*s'.");
		add(16169 , 16 , "Creation of key '%.*s' on HSM device with UUID '%.*s' failed.");
		add(16170 , 16 , "Call to Cryptoki API '%s' failed with error code %d (0x%0x) %s.");
		add(16171 , 16 , "Multiple key with same uuid exits on HSM device.");
		add(16172 , 16 , "The HSM key does not exist in database 'master'. Use CREATE ENCRYPTION KEY to create one, if needed.");
		add(16173 , 16 , "Dropping of key '%.*s' from HSM device with UUID '%.*s' failed.");
		add(16174 , 16 , "You cannot alter encryption key '%.*s' present on external keystore.");
		add(16175 , 16 , "Key copy of master key exists. Drop the key copy before encrypting with '%s'.");
		add(16176 , 16 , "You cannot set encryption password for %S_MSG encrypted with external key in database '%S_DBID'.");
		add(16177 , 16 , "A %S_MSG already exists for this database. You must specify WITH OVERRIDE.");
		add(16178 , 16 , "%.*s.");
		add(16203 , 10 , "Credential delegation not requested. No connection to server '%.*s'.");
		add(16204 , 10 , "Delegated credentials not available for this session. No connection to server '%.*s'.");
		add(16205 , 10 , "No security mechanism authentication attempted for connection to server '%.*s'. Using default authentication.");
		add(16206 , 16 , "Cannot create proxy table in an in-memory database, or map a proxy table to an object in an in-memory database.");
		add(16208 , 16 , "LOB cannot be sent as a parameter because it is not supported for this server class or remote server.");
		add(16209 , 16 , "Operations on in-row LOB columns in proxy tables are not supported.");
		add(16210 , 16 , "Operations on compressed columns in proxy tables are not supported.");
		add(16211 , 16 , "Merge statements on proxy tables are not supported.");
		add(16212 , 16 , "This command %s is not allowed for proxy database '%.*s'.");
		add(16213 , 16 , "ALTER TABLE statement has more than one action from ADD/MODIFY/DROP. This syntax is not supported in remote server.");
		add(16214 , 16 , "The optimizer could not find any suitable unique index defined on table '%.*s'.");
		add(16215 , 16 , "Index compression related operation %s on proxy table '%.*s' are not supported.");
		add(16216 , 16 , "TEXT/IMAGE value cannot be sent in a positioned update query. Use WRITETEXT instead.");
		add(16217 , 16 , "%.*s is not supported at remote server.");
		add(16219 , 16 , "Invalid length %d received for column '%.*s' from remote data source.");
		add(16300 , 16 , "TEXT/IMAGE, UNITEXT and TIMESTAMP type cannot be a return type of a scalar SQL function.");
		add(16301 , 16 , "SQL function %s has too many parameters. The maximum number is %d.");
		add(16302 , 16 , "The return statement should be the last statement within a SQL function.");
		add(16303 , 10 , "Java is not supported in this ASE release.");
		add(16304 , 15 , "Specify the instance name only if you are creating a local temporary database.");
		add(16305 , 15 , "Incorrect syntax near '%.*s'. In ASE Cluster Edition, use 'shutdown cluster' or 'shutdown instance_name'.");
		add(16306 , 16 , "You cannot use an identity function in a SELECT INTO statement with the UNION operation.");
		add(16308 , 16 , "You must specify a password when creating [dual] master keys.");
		add(16309 , 10 , "Warning: CREATE ENCRYPTION KEY ignores an invalid key attribute specified, such as default, keylength, init_vector, pad, dual_control, or static key.");
		add(16310 , 16 , "Cannot create a partitioned Dynamic hash table/Virtually hashed table.");
		add(16311 , 16 , "Only allpages locking scheme allowed for Virtually hashed tables.");
		add(16312 , 16 , "for load' option is valid only for rounrobin partitioned tables having more than one partition.");
		add(16314 , 16 , "Incorrect syntax near '%.*s'. USE AS TEMPLATE is allowed only in CREATE INMEMORY DATABASE.");
		add(16315 , 16 , "You cannot create user thread pools that use the internal prefix 'syb_'.");
		add(16316 , 16 , "You cannot drop internal system thread pools.");
		add(16317 , 16 , "You cannot include the thread pool name in the WITH clause of a CREATE THREAD POOL statement.");
		add(16318 , 14 , "Cannot '%.*s' predicated permission. Verify that the predicated privileges option is enabled.");
		add(16319 , 16 , "Can't specify a dht-device in a CREATE DATABASE statement without also specifying at least one non-log-device and one log-device.");
		add(16320 , 16 , "Duplicate attribute '%.*s' has been specified.");
		add(16321 , 16 , "Integer value '%.*s' is disallowed.");
		add(16322 , 16 , "String value '%.*s' is disallowed.");
		add(16324 , 16 , "Hashkeyvalues cannot be bigger than %d bits.");
		add(16325 , 16 , "Cannot GRANT/REVOKE permission '%s'. Verify that the granular permissions option is enabled.");
		add(16326 , 16 , "You have specified an invalid value %d as the LOB compression level.");
		add(16327 , 16 , "An encrypted LOB column cannot be compressed, and cannot reference an compressed LOB column (column '%.*s').");
		add(16328 , 16 , "A computed LOB column cannot be compressed, and cannot reference an compressed LOB column (column '%.*s').");
		add(16332 , 16 , "Reserve rate '%d' is invalid; rate must be between 1 and 100.");
		add(16333 , 16 , "Cannot use '%.*s' in ''%.*s' option.");
		add(16334 , 16 , "You cannot define more than one column property for column '%.*s' using SELECT INTO.");
		add(16335 , 16 , "Expected row size '%d' must be greater than 0.");
		add(16336 , 16 , "A SELECT FOR UPDATE query cannot be used with DISTINCT, GROUP BY, HAVING, COMPUTE, UNION, aggregates, computed columns, subqueries or SELECT INTO.");
		add(16337 , 15 , "Option '%s' is not valid when used with '%s'.");
		add(16338 , 16 , "This %s command contains a '%s' clause together with clauses that require data copy. This combination is not allowed.");
		add(16339 , 16 , "The '%s' statement is illegal in the '%s' clause of the MERGE statement.");
		add(16341 , 20 , "Source partition (partition id %d) range does not match with destination partition range. Please retry the split partition with correct range.");
		add(16342 , 19 , "Move partition to segment '%s' invalid. Partition already belongs to the segment. Please retry the move partition with correct segment.");
		add(16343 , 19 , "The move partition command does not support moving multiple partitions in a single command. Please move each partition separately.");
		add(16344 , 16 , "The option '%.*s' is invalid in the current context.");
		add(16345 , 16 , "The options WITH LISTONLY=(HEADER, TRAILER) or their equivalents WITH HEADERONLY, TRAILERONLY and the option WITH LISTONLY[=VOLUME] cannot be used with any other LISTONLY/VERIFY/VERIFYONLY options.");
		add(16346 , 16 , "You cannot use the FROM clause with the LISTONLY=LOAD_SQL option.");
		add(16347 , 16 , "Syntax error. Alter Table command option 'with no datacopy' is not valid if 'drop column' is not specified.");
		add(16348 , 16 , "You cannot %s permissions on a hashed temporary object (object with a name starting with '#').");
		add(16349 , 16 , "Procedure number is not allowed with '%.*s' clause");
		add(16350 , 16 , "Invalid option for '%.*s' clause.");
		add(16351 , 16 , "In-memory, master, model and dbccdb databases cannot be encrypted or decrypted.");
		add(16352 , 16 , "Operations related to Single Instance Databases are available only on ASE Cluster Edition.");
		add(16353 , 16 , "Default column values are not supported for table variables.");
		add(16354 , 16 , "Timestamp values are not supported for table variables.");
		add(16355 , 16 , "Identity columns are not supported for table variables.");
		add(16356 , 16 , "Column and table constraints are not supported for table variables except null/not null column constraint.");
		add(16357 , 16 , "Storage type specification is not supported for table variables.");
		add(16360 , 16 , "set query_exec_direction { auto | colstorage | rowstorage } failed because '%.*s' is not a valid parameter.");
		add(16361 , 16 , "Cannot select from or insert/update variable '%.*s' because it is not a table variable.");
		add(16362 , 16 , "Computed columns are not supported for table variables.");
		add(16363 , 16 , "Cannot specify fill factor, page related or segment info for table variable declaration.");
		add(16364 , 16 , "Cannot alter table for table variable.");
		add(16365 , 16 , "Join skew threshold must be > 0.0 and <= 1.0");
		add(16366 , 16 , "Table Variable '%.*s' is illegal in this context.");
		add(16367 , 16 , "EXECUTE AS OWNER procedures cannot be created by an alias or with the %s command when the procedure has SQL statements that reference objects across databases. Create the procedure from a non-impersonated session.");
		add(16368 , 16 , "%s command is not allowed inside an EXECUTE AS OWNER procedure.");
		add(16369 , 16 , "%d is not a valid value for SET command '%s'.");
		add(16371 , 16 , "invalid %S_MSG: %S_MSG cannot be more than %S_MSG or less than %S_MSG");
		add(16372 , 16 , "numeric overflow: '%.*s'.");
		add(16373 , 16 , "invalid %S_MSG: absolute value of %S_MSG must be less than %S_MSG minus %S_MSG");
		add(16374 , 16 , "invalid %S_MSG: %S_MSG should not be greater than '%d' and %S_MSG minus %S_MSG");
		add(16375 , 16 , "invalid %S_MSG: %S_MSG must be more than %ld");
		add(16376 , 16 , "invalid %S_MSG: %S_MSG must be less than %ld");
		add(16378 , 16 , "Invalid number: not a valid number string '%.*s'.");
		add(16379 , 16 , "invalid %S_MSG: %S_MSG must be a non-zero integer");
		add(16380 , 16 , "Invalid number: '%.*s' isn't a valid numeric value.");
		add(16381 , 16 , "Error: SQLScript syntax '%s' is not supported.");
		add(16382 , 16 , "Procedure name can not be started with prefix 'sp_'.");
		add(16384 , 14 , "Index option is not allowed: '%.*s'.");
		add(16385 , 16 , "%.*s");
		add(16386 , 16 , "SQL syntax error: %s.");
		add(16387 , 16 , "Error code is not in the range. User defined error codes are allowed only in the range of 20000 to MAX INT value");
		add(16388 , 16 , "Cannot modify column to identity column: '%.*s'.");
		add(16390 , 16 , "TOP operator conflict with the LIMIT clause");
		add(16391 , 16 , "The order by must be used with limit or top together in subquery.");
		add(16392 , 16 , "Invalid trimchar length specified in the second parameter. The valid length is 1.");
		add(16395 , 16 , "Table UDF error: for table UDF in sqlscript, a subquery or a table variable must be specified in return statement.");
		add(16396 , 16 , "Table UDF error: no table variable declared.");
		add(16397 , 16 , "feature not supported: default value with identity column: %.*s.");
		add(16398 , 16 , "%S_MSG ambiguously defined: %.*s.");
		add(16399 , 16 , "Invalid limit or offset value, only constant value, variable or question mark of integer data type is allowed.");
		add(16400 , 18 , "Workload manager could not set the completion time for action with handle %d.");
		add(16401 , 18 , "Workload manager could not determine the start time for action with handle %d.");
		add(16402 , 17 , "Unable to allocate a logical cluster descriptor for logical cluster '%.*s'. Drop an existing logical cluster or raise the configuration parameter 'workload manager cache size'.");
		add(16403 , 17 , "Unable to allocate a descriptor for route '%.*s'. Drop an existing route or raise the configuration parameter 'workload manager cache size'.");
		add(16404 , 17 , "Unable to allocate a descriptor for load profile '%.*s'. Drop an existing load profile or raise the configuration parameter 'workload manager cache size'.");
		add(16405 , 17 , "Unable to allocate a descriptor for action with handle %d. Release a completed action or raise the configuration parameter 'workload manager cache size'.");
		add(16406 , 18 , "Encountered logical cluster '%.*s' with illegal state %d. Reboot ASE to clear this problem.");
		add(16407 , 18 , "Workload manager encountered an unexpected state of %d for logical cluster '%.*s' on instance %d. Reboot ASE to clear this problem.");
		add(16408 , 10 , "Logical cluster '%.*s' could not be brought online on instance %d because it is in the TIMEDWAIT state on that instance.");
		add(16409 , 14 , "Workload management rules do not allow your connection to continue. Please contact your System Administrator for assistance.");
		add(16410 , 16 , "Unknown attribute id %d passed to the workload manager.");
		add(16411 , 18 , "Attempt to acquire the workload manager global configuration lock failed.");
		add(16412 , 16 , "A logical cluster with name `%.*s` already exists.");
		add(16413 , 16 , "A logical cluster with id %d already exists.");
		add(16414 , 16 , "Could not find descriptor for logical cluster with id %d.");
		add(16415 , 16 , "You cannot rename the system logical cluster.");
		add(16416 , 16 , "You cannot drop the system logical cluster.");
		add(16417 , 16 , "You cannot drop the open logical cluster.");
		add(16418 , 16 , "You cannot drop logical cluster '%.*s' because it has defined routes. Drop all associated routes before dropping the logical cluster.");
		add(16419 , 16 , "You may not set attribute %d of the system logical cluster.");
		add(16420 , 16 , "The value %d is not legal for logical cluster attribute %d.");
		add(16421 , 16 , "%d is not a valid logical cluster attribute id.");
		add(16422 , 16 , "Cannot find descriptor for load profile with id %d.");
		add(16423 , 16 , "Could not find descriptor for logical cluster with name '%.*s'.");
		add(16424 , 16 , "You cannot run the '%.*s' command against the system logical cluster.");
		add(16425 , 16 , "The wlmgr_admin built-in cannot be executed because the workload manager subsystem is not online.");
		add(16426 , 15 , "'%.*s' is not a valid workload manager command.");
		add(16427 , 15 , "'%.*s' is not a valid workload manager sub-command.");
		add(16428 , 15 , "You cannot specify the same instance in both instance lists.");
		add(16429 , 15 , "'%.*s' is not a valid workload manager wait option.");
		add(16430 , 15 , "You cannot specify a time value with wait option '%s'.");
		add(16431 , 15 , "You must specify a time value with wait option '%s'.");
		add(16432 , 16 , "Could not find descriptor for action with handle %d.");
		add(16433 , 15 , "You may not specify a 'from' or 'to' instance list for the '%s %s' command.");
		add(16434 , 15 , "You must specify a 'from' instance list for the '%s instance' command.");
		add(16435 , 15 , "'%.*s' is not a legal subcommand for the '%.*s' command.");
		add(16436 , 15 , "You may not specify a base instance in the from list for the 'failback instance' command.");
		add(16437 , 17 , "Insufficient memory to allocate workload manager backout structure. Raise the value of configuration parameter 'procedure cache size'.");
		add(16438 , 18 , "Attempt to acquire object coherency lock for logical cluster '%.*s' failed. Retrun status was %d.");
		add(16439 , 16 , "Cannot drop logical cluster '%.*s' because it is currently in the '%s' state. Try taking the logical cluster offline before dropping it.");
		add(16440 , 16 , "You cannot change instance settings for the system logical cluster.");
		add(16441 , 15 , "Illegal failover group %d specified. Legal values are between %d and %d.");
		add(16442 , 16 , "Cannot add instance '%s' to logical cluster '%.*s' because it is already an instance in that logical cluster.");
		add(16443 , 16 , "Cannot drop instance %d ('%s') from logical cluster '%.*s' because it is currently in the '%s' state. Try taking the logical cluster offline on this instance before dropping it.");
		add(16444 , 16 , "Cannot drop instance %d ('%s') from logical cluster '%.*s' because it is not an instance in that logical cluster.");
		add(16445 , 15 , "'%c' is not a valid logical cluster instance type.");
		add(16446 , 15 , "Invalid route type %d.");
		add(16447 , 16 , "A route of type %d with key '%.*s' already exists.");
		add(16448 , 16 , "Could not find descriptor for route with type %d and key '%.*s'.");
		add(16449 , 16 , "A load profile with name '%.*s' already exists.");
		add(16450 , 16 , "A load profile with id %d already exists.");
		add(16451 , 16 , "%d is not a valid load profile attribute id.");
		add(16452 , 16 , "You cannot drop load profile '%.*s' because it is being used by one or more logical clusters.");
		add(16453 , 16 , "Workload manager could not bring any instances online for logical cluster '%.*s' during the failback command. The command will be aborted.");
		add(16454 , 16 , "Workload manager could not bring any instances online for logical cluster '%.*s' during the failover command. The command will be aborted.");
		add(16455 , 18 , "Attempt to acquire object coherency lock for action %d failed. Return status was %d.");
		add(16456 , 18 , "A failure was encountered while multicasting the execute event for action %d. The action will use an infinite wait on instances that did not receive the message.");
		add(16457 , 17 , "Workload manager could not allocate an alarm for action %d. Try raising the 'number of alarms' configuration parameter.");
		add(16458 , 18 , "Attempt to set an alarm for action %d failed. The action will run on this instance until all affected user connections disconnect or migrate.");
		add(16459 , 16 , "Cannot create a user load profile with an id less than %d.");
		add(16460 , 18 , "Workload manager fatal error: could not initialize the system logical cluster.");
		add(16461 , 18 , "Attempt to acquire object coherency lock for workload manager control failed. Return status was %d.");
		add(16462 , 17 , "Failed to spawn the workload manager thread.");
		add(16463 , 18 , "Workload manager could not setup a scan of sysattributes. The on disk configuration could not be read.");
		add(16464 , 18 , "Workload manager encountered an error while retrieving existing actions at boot time.");
		add(16465 , 18 , "Unable to install action with handle %d.");
		add(16466 , 17 , "The workload manager could not establish a load update alarm. Load statistics for this instance will not be tracked. Try raising the 'number of alarms' configuration parameter.");
		add(16467 , 18 , "Unable to do proper shutdown handling for logical cluster '%.*s'. The logical cluster will be recovered when this instance exits.");
		add(16468 , 15 , "The user supplied workload metric value must be greater than or equal to zero.");
		add(16469 , 16 , "You cannot set the user workload metric for instance '%s' because that instance is not in the UP state.");
		add(16470 , 18 , "Workload manager encountered an error posting the user workload metric update event. The user workload metric value has not been changed.");
		add(16471 , 18 , "Workload manager encountered a DMM error while retrieving usage data for logical cluster '%.*s'.");
		add(16472 , 18 , "Route of type %d with key '%.*s' could not be activated because a matching route descriptor cuold not be found.");
		add(16473 , 16 , "You cannot submit a new action for logical cluster '%.*s' on instance '%s' because it already has an action pending on that instance.");
		add(16474 , 18 , "Workload manager is unable to submit action with handle %d for execution due to a previous error. However, changes to logical cluster '%.*s' have already been committed and will not be undone. The action will behave with an infinite wait.");
		add(16475 , 16 , "Action with handle %d is associated with logical cluster %.*s, not logical cluster '%.*s'.");
		add(16476 , 18 , "Workload manager encountered a PCM error (%d) while sending a remote command. The current command will be aborted.");
		add(16477 , 18 , "Workload manager remote operation %d succeeded on %d instance(s) but failed on %d instance(s). This operation cannot be undone, and the workload manager may now be in an inconsistent state.");
		add(16478 , 18 , "Workload manager encountered an error during remote operation %d and the operation will be aborted. Consult the Adaptive Server log on each instance for additional details.");
		add(16479 , 15 , "A wait option is required for the '%s %s' command.");
		add(16480 , 18 , "Attempt to send a cluster event for command '%s %s' failed. The command will be aborted.");
		add(16481 , 16 , "The action you are trying to release is active. You must wait for it to complete or cancel it prior to releasing it.");
		add(16482 , 16 , "The action you are trying to release is already being released.");
		add(16483 , 18 , "The workload manager command '%s %s' failed because it could not submit an action. Refer to previous errors or the Adaptive Server error log for additional details.");
		add(16484 , 15 , "You may not specify a 'from' instance list for the '%s %s' command.");
		add(16485 , 16 , "The failover instance command requires that all 'from' instances be in the online state.");
		add(16486 , 16 , "Instance %d ('%s') is not a defined instance for logical cluster '%.*s'.");
		add(16487 , 10 , "Could not automatically start logical cluster '%.*s' at startup. Consult the Adaptive Server error log for additional details.");
		add(16488 , 18 , "Workload manager encountered an error while completing the timed wait transition for logical cluster '%.*s' and this logical cluster will not properly go offline. Consult the Adaptive Server error log for additional details.");
		add(16489 , 16 , "A workload manager operation has aborted due to an attention flag.");
		add(16490 , 0  , "Cannot create a user load profile that begins with sybase_profile.");
		add(16491 , 16 , "Spid %d is not migratable.");
		add(16492 , 0  , "Instance '%d' is not online on logical cluster '%.*s'.");
		add(16493 , 16 , "Workload manager cannot perform a failover for logical cluster '%.*s' without a specified failover instance while the failover mode is set to group and additional instances remain online.");
		add(16494 , 16 , "The failover cluster command requires that the cluster be in the online state.");
		add(16500 , 10 , "Temporary database based on the specified soft binding could not be assigned. Assigning temporary database '%S_DBID' from the 'default' group.");
		add(16501 , 10 , "Temporary database group (groupid = %d) is not available for use due to insufficient resources.");
		add(16502 , 10 , "Failed to add temporary database (dbid = %d) to the temporary database group.");
		add(16503 , 11 , "Temporary database group %.*s does not exist.");
		add(16504 , 10 , "Currently, there are no active temporary database members for the temporary database group (groupid %d).");
		add(16505 , 16 , "Database (dbid = %d) is not a local user temporary database.");
		add(16506 , 0  , "Multiple tempdb PCM service call failed!");
		add(16507 , 20 , "Attempt to acquire the lock for cluster-wide synchronization of changes in temporary database binding or group configuration failed.");
		add(16508 , 16 , "Local temporary database '%.*s' is skipped for this operation. The database is accessible from the owner instance %d only.");
		add(16509 , 16 , "The database '%S_DBID' (dbid=%d) is not owned by the current cluster instance. To add the database to the list of available local user temporary databases, execute the command on its owner instance.");
		add(16600 , 10 , "The sort is performed using Parallel sort.");
		add(16601 , 10 , "Warning: Serial sort is being used rather than parallel sort in order to enforce the dump tran sequence.");
		add(16700 , 20 , "Mismatch between the configuration file and the configuration used by the coordinator instance. Reboot the current instance using the newly dumped configuration file from the coordinator instance.");
		add(16701 , 20 , "Attempt to dump configuration file failed at the coordinator instance. Use sp_configure to dump the configuration file from the coordinator instance.");
		add(16702 , 16 , "Total number of caches is different at instances %s and %s; restart both instances. If problem persists, restart the cluster.");
		add(16703 , 16 , "Named cache %s has different cache ID values at instances %s and %s; restart both instances. If problem persists, restart the cluster.");
		add(16704 , 16 , "Named cache %s has been deleted at instance %s but not from instance %s; restart both instances. If problem persists, restart the cluster.");
		add(16705 , 20 , "Configuration file not updated. Use sp_configure to create a new one.");
		add(16706 , 10 , "You are using an old version of the configuration file. The latest version of the configuration file will be extracted from the quorum device into file %s. Please reboot using the new configuration file.");
		add(16707 , 10 , "The config file version hits the upper limit. It will be reset to 1.");
		add(16708 , 16 , "Failed to acquire the quorum file system lock.");
		add(16709 , 16 , "Failed to store the configuration file on quorum device.");
		add(16710 , 10 , "Failed to unlock the quorum device.");
		add(16711 , 16 , "Failed to get the inode structure of the configuration file on quorum device.");
		add(16712 , 16 , "Failed to set the config file version number on quorum device.");
		add(16713 , 16 , "Failed to extract the configuration file from the quorum device.");
		add(16714 , 10 , "The configuration file does not exist on quorum device.");
		add(16715 , 16 , "The replacement strategy for cache device %s should be 'none' or 'DEFAULT'.");
		add(16716 , 10 , "Larger buffer pools are not supported for in-memory storage cache. ASE will use the default buffer pool to start.");
		add(16718 , 16 , "The value of 'cluster redundancy level' must be less than the maximum number of instances in the cluster ( %d).");
		add(16719 , 16 , "Cache '%.*s' not deleted, because one or more devices still exist on the cache. Use sp_dropdevice to drop the device, then try deleting the cache again.");
		add(16720 , 18 , "Internal Error: Address lock for cache '%.*s' not acquired.");
		add(16721 , 16 , "The value of 'number of backup threads' (%d) must be less than the value of 'number of user connections' (%d).");
		add(16722 , 16 , "In-memory storage cache ('%.*s') not deleted dynamically. Drop all the in-memory databases using this cache, then try deleting the cache again.");
		add(16723 , 16 , "ASE detects that a cluster-wide static configuration option '%s' is updated but instances using this value have not be restarted yet. Please shutdown and restart these instances, then join the cluster later.");
		add(16724 , 16 , "Creating a cache of type '%s' is currently not supported in SAP Adaptive Server%s%s.");
		add(16725 , 16 , "Internal Error: Failed to allocate memory for free list elements for the in-memory storage cache '%.*s'.");
		add(16726 , 16 , "You cannot enable HA because the database '%.*s' does not have a durability of FULL.");
		add(16727 , 10 , "Invalid number of threads defined for thread pool '%s' at line %d.");
		add(16728 , 10 , "The parameter '%s' has no effect in '%s' kernel mode. You can set the value, but it does not take effect until you change the kernel mode and restart Adaptive Server.");
		add(16729 , 10 , "You cannot decrease the '%s' parameter at runtime. The new setting will take effect when you restart Adaptive Server.");
		add(16730 , 10 , "Invalid idle timeout defined for thread pool '%s' at line %d.");
		add(16731 , 10 , "Invalid number of 'network threads' defined for thread pool '%s' on line %d.");
		add(16732 , 10 , "Attempt to set description text for the system thread pool '%s failed on line %d. Only user thread pools can have descriptions in the configuration file.");
		add(16733 , 10 , "The %s text for the thread pool '%s' on line %d is too long.");
		add(16734 , 10 , "Unexpected attribute for thread pool '%s' on line %d.");
		add(16735 , 20 , "Improper cache status or replacement policy for in-memory storage cache '%s'. Adaptive Server will shut down.");
		add(16736 , 16 , "You cannot make the size of the default pool of cache '%s' smaller.");
		add(16737 , 16 , "Changes to the 'enable granular permissions' configuration parameter failed. There must be at least one unlocked login with %S_MSG '%s' and at least one unlocked login with %S_MSG '%s'.");
		add(16738 , 10 , "If you are using 32-bit ASE, please refer to the documents for the addressable memory limits before setting this option.");
		add(16739 , 16 , "Warning: Configuration option '%s' has been updated, however, some instances are still using the old value. Use sp_configure to synchronize the configured value, then, to improve performance, restart those instances at your convenience.");
		add(16740 , 16 , "Warning: 'Free Locks' pool on instance '%s' could not be grown with respect to the 'maximum total cache' configured in the cluster. Performance may be affected. Consider increasing 'max memory' or deleting cache. Run dbcc showcache for more information.");
		add(16742 , 16 , "Buffer pool configuration failed on instance '%s'.");
		add(16743 , 16 , "Can not estimate the memory requirement for option '%s', since it does not consume any memory.");
		add(16744 , 16 , "Illegal value for dump configuration '%s'. Legal values are '%s'.");
		add(16745 , 16 , "Invalid dump configuration: Block size '%d' is invalid. Block size must be a power of 2 that is greater than or equal to the pagesize '%d'.");
		add(16746 , 17 , "The configured value '%d' for parameter 'kernel resource memory' is too low. It should be atleast '%d' for the present configuration.");
		add(16747 , 16 , "The '%s' configuration option is only available on the %s platform. This option is not valid on the current platform.");
		add(16748 , 10 , "The 'number of disk tasks' configuration parameter is '%d' but the number of disk tasks has been reset to 1 because the '%s' parameter is enabled. In order to use multiple disk tasks you must disable the '%s' parameter.");
		add(16749 , 16 , "The number of file descriptors per ASE process required to support the configuration resulting from the value %d of the configuration parameter \'%s\' exceeds the limit %d by %d.");
		add(16750 , 16 , "The maximum number of file descriptors per ASE process is calculated by the %s edition in %s mode using: %s.");
		add(16751 , 16 , "changes to console logging are ignored in the currently running server because HA is active");
		add(16752 , 14 , "Permission denied. Only users with permission '%.*s' can change configuration option '%s'.");
		add(16753 , 20 , "The '%s' configuration option requires '%s' to be enabled.");
		add(16754 , 16 , "ASE running in kernel process mode only ignores %s.");
		add(16755 , 16 , "Configuration %s = 2 is not supported.");
		add(16756 , 16 , "Adaptive Server is currently HADR configured and running as %s. The value of configuration parameter '%s' cannot be changed until this server is dropped from HADR group using 'sp_hadr_admin dropserver' command.");
		add(16757 , 16 , "Configuration %s is ignored. It is only valid on Solaris.");
		add(16758 , 16 , "The configuration option '%s' is currently not supported in SAP Adaptive Server%s%s.");
		add(16759 , 16 , "The configuration parameter 'max network peek depth' specifies the maximum number of bytes of pending nework input on a client connection that ASE is requested to inspect in search of a cancel request somewhere in the pending input stream.");
		add(16760 , 16 , "The 'user log cache size' configuration parameter is set to '%d' bytes. It must be '%d' bytes or greater when the 'user log cache queue size' configuration parameter is set to '%d'.");
		add(16761 , 10 , "Configuration parameter %s is deprecated and will be ignored.");
		add(16762 , 16 , "Invalid type configured for cache %s. Cache type can NOT be 'lockless data cache' along with 'mixed' OR 'log only' OR 'in-memory storage' types.");
		add(16763 , 16 , "%s failed since the cache '%.*s' is in use as %s cache by database '%.*s'.");
		add(16764 , 16 , "Changing 'cache type' from 'lockless data cache' unsuccessful as objects are bound to the cache. Use sp_unbindcache_all to unbind all objects bound to the cache and then retry.");
		add(16765 , 16 , "Changing 'cache type' to 'lockless' when the 'Run Replacement' policy is 'strict' is not dynamic. To change 'cache type' to 'lockless' in the same instance, delete the cache and recreate it with the required arguments.");
		add(16766 , 16 , "You must disable HADR before you can disable cis rpc handling.");
		add(16767 , 16 , "You must disable HADR before you can switch the kernel mode to 'process'.");
		add(16768 , 16 , "Adaptive Server is currently HADR configured and running as %s. The value of configuration parameter '%s' cannot be changed to DR Standby.");
		add(16800 , 16 , "The search string supplied by the RPC or dynamic SQL operation is too long. It should not be longer than %d bytes.");
		add(16802 , 14 , "You must have the following permission to execute this command/procedure: '%.*s'. Please contact a user with the appropriate permission for help.");
		add(16803 , 16 , "The builtin '%.*s' can only be called from a stored procedure.");
		add(16804 , 16 , "Incompatible LOB - LOCATOR data types found.");
		add(16805 , 16 , "A LOB LOCATOR was used that is no longer valid: Either the transaction that created it has ended or it has been deallocated.");
		add(16806 , 16 , "Invalid %s data type passed to %s builtin.");
		add(16807 , 16 , "An invalid LOCATOR value was passed to the locator_literal builtin function.");
		add(16808 , 16 , "The SET SEND_LOCATOR ON/OFF command cannot be executed because the client process does not have the capability to process LOB LOCATORs.");
		add(16809 , 16 , "The LOB value referenced by a LOB LOCATOR in the query is too large to process (larger than 16 KB).");
		add(16810 , 17 , "The total number of active plus deallocated LOB LOCATORs (%d) has reached the maximum allowed for a single transaction.");
		add(16811 , 16 , "SELECT FOR UPDATE has one or more columns in its FOR UPDATE OF list that are not updatable.");
		add(16812 , 10 , "Warning: SELECT FOR UPDATE references tables from different databases with ID '%d' and '%d'. Therefore, the selected rows cannot be exclusively locked.");
		add(16813 , 10 , "Warning: SELECT FOR UPDATE is being executed outside a transaction context. Therefore, the selected rows cannot be exclusively locked.");
		add(16814 , 10 , "Warning: Acquiring exclusive locks by SELECT FOR UPDATE is applicable only to tables using the datarows locking scheme. Therefore, the selected rows for table '%.*s' cannot be exclusively locked.");
		add(16815 , 16 , "USE DATABASE must be the last statement in a query batch.");
		add(16816 , 16 , "Only single DML command without references to local or global variables can be executed with homogeneous batch parameters.");
		add(16817 , 16 , "A query plan cannot be generated for DML command executed with homogeneous batch parameters. The batch was aborted.");
		add(16818 , 10 , "Warning: SELECT FOR UPDATE is being executed on a proxy table. Therefore, the selected rows cannot be exclusively locked.");
		add(16819 , 16 , "The range for '%s' is %d to %d %S_MSG.");
		add(16820 , 10 , "Warning: SELECT FOR UPDATE is being executed when the default isolation level is 0. Therefore, the selected rows cannot be exlusively locked.");
		add(16821 , 16 , "Command %s has been aborted because it cannot make unlogged changes to table '%.*s' in database '%.*s' while %s REORG/CREATE INDEX is active on the table.");
		add(16822 , 16 , "Operations using LOB locator are not supported.");
		add(16823 , 16 , "Only a single statement is allowed for a positioned update query.");
		add(16824 , 10 , "Warning: Acquiring exclusive locks by SELECT FOR UPDATE is not applicable to tables using the allpages locking scheme. Therefore, the selected rows for table '%.*s' cannot be exclusively locked.");
		add(16825 , 16 , "System defined role '%.*s' cannot be added or dropped for auto activation.");
		add(16826 , 16 , "TEXT_LOCATOR, IMAGE_LOCATOR and UNITEXT_LOCATOR data types are invalid as column data types.");
		add(16827 , 16 , "The MERGE command has been aborted because triggers are not supported with MERGE.");
		add(16828 , 10 , "Threshold exists for login '%.*s' in database '%S_DBID'.");
		add(16830 , 16 , "The partitions being merged are not contiguous for given range partition.");
		add(16831 , 16 , "Merge partition requires at least two existing partitions for the operation to succeed.");
		add(16832 , 16 , "Number of rows is very large. Please use count_big() instead of count().");
		add(16833 , 10 , "Thread (spid=%d) initiating parallel primary error processing.");
		add(16835 , 18 , "Null SDES encountered");
		add(16836 , 16 , "The %s command cannot be executed because either the encryption key '%.*s' does not exist or it is %S_MSG encryption key.");
		add(16837 , 16 , "Database '%.*s' is not encrypted.");
		add(16838 , 16 , "Database '%.*s' is encrypted with different key.");
		add(16839 , 16 , "Database '%.*s' cannot be %S_MSG when %S_MSG is in progress.");
		add(16840 , 16 , "Database '%.*s' is %S_MSG.");
		add(16841 , 16 , "%.*s is already protected by %S_MSG.");
		add(16842 , 16 , "Merge updates the same target row more than once.");
		add(16843 , 16 , "There is no running %S_MSG process on database '%.*s' to suspend.");
		add(16844 , 16 , "There is no fragment in database '%S_DBID' that has starting logical page %d .");
		add(16845 , 16 , "There is no encryption or decryption progress information available for database %S_DBID.");
		add(16846 , 16 , "There is no %S_MSG progress on database %.*s to resume.");
		add(16847 , 10 , "Initiated %S_MSG tasks on database %S_DBID in background.");
		add(16848 , 16 , "Failed to initiate %S_MSG tasks on database %S_DBID in background.");
		add(16849 , 10 , "Suspending %S_MSG tasks on database %S_DBID......");
		add(16850 , 16 , "Value of %d is not valid for option %S_MSG.");
		add(16851 , 16 , "Logical Cluster: '%.*s' is for single instance access. It can't be online on more than one instance. Onlinemap: 0x%x.");
		add(16852 , 16 , "All databases bound to logical cluster: '%.*s' should be unbound before it is dropped. Run 'sp_cluster logical, show' to view bound databases.");
		add(16853 , 16 , "Logical Cluster: '%.*s' has been created for single instance access. It is not allowed to have more than one base instance.");
		add(16854 , 16 , "Database related operations are not allowed on the system logical cluster.");
		add(16855 , 16 , "Logical cluster: '%.*s' is not for single instance access. Database related operations not permitted.");
		add(16856 , 16 , "Database: '%.*s' can't be bound to: '%.*s' it is already bound to logical cluster: '%.*s'. Unbound it first before binding.");
		add(16857 , 16 , "Database: '%.*s' can't be bound to single instance logical cluster: '%.*s'. At most %d databases allowed to be bound.");
		add(16858 , 20 , "Workload manager encountered an error while changing state to '%s' for logical cluster: '%.*s' for instance: '%s' during the '%s' command. The command will be aborted. Consult the Adaptive Server log on each instance for additional details.");
		add(16859 , 20 , "Workload manager encountered an error while performing database related operation for logical cluster: '%.*s'. Consult the Adaptive Server log on each instance for additional details.");
		add(16860 , 16 , "Unknown logical cluster type: %d found in sysattributes row for logical cluster: '%.*s'.");
		add(16861 , 17 , "Unable to allocate a database descriptor for database: '%.*s'. Drop an existing database or raise the configuration parameter 'workload manager cache size'.");
		add(16862 , 16 , "Parameter %d of function %s is too long, negative or 0. Maximum length is %d characters. Retry the function with a shorter parameter.");
		add(16863 , 16 , "Repeated update in direct mode has been attempted on the row with row ID '%d' in logical page '%d' for table '%.*s' in database '%.*s'. This is an internal error.");
		add(16864 , 16 , "Invalid trimchar length specified in the second parameter. The valid length is 1.");
		add(16865 , 16 , "Cannot start scan at transaction isolation level 'transaction snapshot' on table '%.*s' because some data rows that should not be visible to this scan may have been inserted to the table by concurrent bulk insert or utility tasks.");
		add(16866 , 16 , "Parameter length is odd . The valid length is even number.");
		add(16867 , 16 , "Invalid character '%s' of function %s. Please input valid character.");
		add(16869 , 16 , "Attempt to get sequence value failed.");
		add(16870 , 16 , "sequence is exhausted.");
		add(16871 , 16 , "CURRVAL of given sequence is not yet defined.");
		add(16872 , 16 , "The administration of the RSA keysize is not allowed in this ASE version.");
		add(16873 , 16 , "Reached maximum internal reexecution threshhold (%d). Configure 'number of reexecutions' with increased number or DEFAULT (-1).");
		add(16874 , 16 , "Could not execute the procedure. user-defined error: [%d] user-defined error exception: %.*s");
		add(16875 , 16 , "The LIMIT/OFFSET is not allowed inside correlated subquery");
		add(16876 , 16 , "The offset specified in a OFFSET clause may not be negative.");
		add(16877 , 16 , "Unable to create a new user-defined type '%.*s'. Please try again when there are fewer user-defined table types in SYSTYPES.");
		add(16878 , 16 , "The limit specified in a LIMIT clause may not be negative.");
		add(16879 , 16 , "INSERT and UPDATE are disallowed on the generated field: cannot insert into or update generated identity column field %.*s.");
		add(16880 , 16 , "Cannot modify generated identity column: '%.*s'.");
		add(16881 , 16 , "Cannot create temporary table having identity column: '%.*s'.");
		add(16882 , 16 , "Cannot alter temporary table to add identity column: '%.*s'.");
		add(16883 , 16 , "invalid sequence: more than one column in the SELECT list of the RESET BY query");
		add(16884 , 16 , "invalid sequence: type of given column in the RESET BY query must be numeric");
		add(16885 , 16 , "invalid sequence: RESET BY query has no result");
		add(16886 , 16 , "invalid sequence: RESET BY query returns null value");
		add(16887 , 16 , "invalid sequence: RESET BY query returns more than one row");
		add(16888 , 16 , "invalid sequence: RESET BY query is invalid");
		add(16889 , 16 , "CURRVAL of given sequence is not yet defined");
		add(16890 , 16 , "the %s value is failed to converted into 64bits integer");
		add(16891 , 16 , "Invalid column type for identity column '%.*s', it must be a numeric type.");
		add(16892 , 16 , "expression cannot be used as an assignment target:%d");
		add(16893 , 16 , "Failed to get sequence value.");
		add(16894 , 16 , "feature not supported: %s is/are not supported in read-only procedure");
		add(16895 , 16 , "invalid name of function or procedure: %s");
		add(16897 , 16 , "invalid name of function or procedure: there is no output parameter name %s in user defined function.");
		add(16898 , 16 , "invalid name of function or procedure: This user defined function has multiple outputs, but this usage requires a single output. Specify a single output.");
		add(16899 , 16 , "Database option '%s' needs to be enabled in the database '%.*s' for the statement to succeed.");
		add(17000 , 0  , "timeouts");
		add(17001 , 0  , "no timeouts");
		add(17002 , 0  , "net password encryption");
		add(17003 , 0  , "Usage: sp_showoptstats [database[.owner[.table]]], [column], [option]");
		add(17004 , 0  , "The current @@textsize of %1! is too small for the XML output which is at %2!. Please increase @@textsize and re-run this procedure.");
		add(17005 , 0  , "The databases master, model, tempdb, sybsecurity, sybsystemprocs and mounted_sybsystemprocs cannot carry out this operation.");
		add(17006 , 0  , "Database is modified and in single-user mode.");
		add(17007 , 0  , "ERROR: The Job Scheduler database could not be found on this server. The Job Scheduler must be installed in order to use this stored procedure.");
		add(17008 , 0  , "ERROR: The Job Scheduler is not installed on this server. The Job Scheduler must be installed in order to use this stored procedure.");
		add(17009 , 0  , "ERROR: The Job Scheduler is not running. Contact a system administrator to resolve this problem.");
		add(17010 , 0  , "no");
		add(17011 , 0  , "yes");
		add(17012 , 0  , "ERROR: You cannot combine option '%1!' with any other option.");
		add(17013 , 0  , "ERROR: Invalid option parameter: '%1!'.");
		add(17014 , 0  , "ERROR: Both '%1!' and '%2!' were specified. You can only use one of these options at a time");
		add(17015 , 0  , "predicate");
		add(17016 , 0  , "There are no encryption keys (key copies) in '%1!'.");
		add(17017 , 0  , "Warning: The database(s) %1! is (are) currently not available and cannot be checked for login references. The request to ignore this error may leave users for this login in the database(s).");
		add(17018 , 0  , "The database(s) %1! is (are) currently not available and cannot be checked for login references. The command has been aborted.");
		add(17019 , 0  , "No such dump config '%1!' exists. Run sp_config_dump without parameters to list dump configurations.");
		add(17020 , 0  , "The specified login profile '%1!' must be associated with the current user or you must possess System Security Officer (SSO) authorization.");
		add(17021 , 0  , "execute as owner");
		add(17022 , 0  , "execute as caller");
		add(17023 , 0  , "Drop service key");
		add(17024 , 0  , "You are not authorized to execute this stored procedure. Only the Database Owner (DBO) or a user with %1! can execute this stored procedure.");
		add(17025 , 0  , "%1!: Permission denied. This operation requires that the user is the DBO of database '%2!' and have the '%3!' '%4!");
		add(17026 , 0  , "You must possess either the System Security Officer (SSO) or Key Custodian (KC) role to execute this command/procedure.");
		add(17027 , 0  , "You are not authorized to execute this stored procedure. Only a user with '%1!' is allowed to execute this stored procedure.");
		add(17028 , 0  , "Granular Permissions must be %1! to execute '%2!'.");
		add(17029 , 0  , "Dependencies for stored procedure '%1!' cannot be determined as ASE does not store dependencies for procedures created with the 'execute as caller' option.");
		add(17031 , 0  , "Login profile '%1!' does not exist.");
		add(17032 , 0  , "Account locked by ASE automatically since account was inactive");
		add(17033 , 0  , "Restoring '%1!' in progress.");
		add(17034 , 0  , "Usage: sp_restore_system_role 'role_name' [,'all_dbs']");
		add(17035 , 0  , "delete");
		add(17036 , 0  , "You must be the Database Owner (dbo) to execute this procedure.");
		add(17037 , 0  , "default sortorder id");
		add(17038 , 0  , "The permission '%1!' is required in order to modify attributes of another process.");
		add(17039 , 0  , "The permission '%1!' is required in order to change the priority.");
		add(17040 , 0  , "Operation failed. There must be at least one unlocked login with privilege MANAGE SECRUITY PERMISSIONS and at least one unlocked login with privilege MANAGE SERVER PERMISSIONS after this operation.");
		add(17047 , 0  , "The commands 'expire login passwords' and 'expire role passwords' require an argument.");
		add(17049 , 0  , "ERROR: You have specified more than one optimizer goal. Only one optimizer goal can be specified at a time.");
		add(17050 , 0  , "select into/bulkcopy/pllsort");
		add(17051 , 0  , "trunc log on chkpt");
		add(17052 , 0  , "no chkpt on recovery");
		add(17053 , 0  , "don't recover");
		add(17054 , 0  , "not recovered");
		add(17055 , 0  , "ddl in tran");
		add(17056 , 0  , "read only");
		add(17057 , 0  , "dbo use only");
		add(17058 , 0  , "single user");
		add(17059 , 0  , "ALL SETTABLE OPTIONS");
		add(17060 , 0  , "dbname has changed");
		add(17061 , 0  , "failed upgrade");
		add(17062 , 0  , "abort tran on log full");
		add(17063 , 0  , "no free space acctg");
		add(17067 , 0  , "Unable to encrypt password for '%1!'. See prior error message for reason.");
		add(17069 , 0  , "allow nulls by default");
		add(17070 , 0  , "trusted");
		add(17071 , 0  , "ERROR: The @@servername variable is null. The server name must be set.");
		add(17072 , 0  , "ERROR: Creation of work table 'tempdb..%1!' failed");
		add(17073 , 0  , "ERROR: Failed to create job '%1!' with option '%2!' with error code: %3!");
		add(17074 , 0  , "ERROR: An error occurred while executing the job. Job name: '%1!', job id: %2!. Error: %3!");
		add(17075 , 0  , "Channel Devices");
		add(17076 , 0  , "ERROR: No output found for job (jobid: '%1!'). The job may have failed or the Job Scheduler may not be running. Contact a system administrator to verify that the Job Scheduler is running and review the Job Scheduler Agent log for errors.");
		add(17077 , 0  , "ERROR: The optimizer diagnostics were incomplete. This may be because the value of the 'maximum job output' configuration parameter (%1!) is smaller than the size of the diagnostic output. Consider increasing the value of 'maximum job output'.");
		add(17078 , 0  , "ERROR: The call to sp_sjobhistory to drop job history '%1!' failed with error code %2!");
		add(17079 , 0  , "ERROR: Unable to find the job name for job ID: %1!");
		add(17080 , 0  , "showplan");
		add(17081 , 0  , "noexec");
		add(17082 , 0  , "arithignore");
		add(17083 , 0  , "arithabort");
		add(17084 , 0  , "background");
		add(17085 , 0  , "control");
		add(17086 , 0  , "offsets");
		add(17087 , 0  , "statistics io and time");
		add(17088 , 0  , "parseonly");
		add(17089 , 0  , "procid");
		add(17090 , 0  , "rowcount");
		add(17091 , 0  , "nocount");
		add(17092 , 0  , "ERROR: Work table 'tempdb..%1!' could not be found.");
		add(17093 , 0  , "ERROR: No query found for job_id: %1!");
		add(17094 , 0  , "ERROR: You must have either 'js_user_role' or 'js_admin_role' to run this stored procedure.");
		add(17095 , 0  , "ERROR: The Job Scheduler is not enabled on this server. The Job Scheduler must be enabled to execute this stored procedure.");
		add(17096 , 0  , "ERROR: call to sp_sjobdrop to drop job '%1!' failed with error code %2!.");
		add(17097 , 0  , "ERROR: Database '%1!' does not exist on this server.");
		add(17098 , 0  , "ERROR: The job (jobid '%1!') failed with exit code '%2!'. Verify that the current user has a valid externlogin defined for this server and review the Job Scheduler agent log for any errors.");
		add(17099 , 0  , "ERROR: The user name can only be specified if the database name is also specified.");
		add(17100 , 0  , "trigger");
		add(17101 , 0  , "system table");
		add(17102 , 0  , "view");
		add(17103 , 0  , "user table");
		add(17104 , 0  , "stored procedure");
		add(17105 , 0  , "default");
		add(17106 , 0  , "rule");
		add(17107 , 0  , "stored procedure (ext)");
		add(17108 , 0  , "precomputed result set");
		add(17110 , 0  , "data only");
		add(17111 , 0  , "log only");
		add(17112 , 0  , "data and log");
		add(17117 , 0  , "The '%1!' command is supported only in process kernel mode");
		add(17118 , 0  , "The length of the user defined goal name must be smaller than 12.");
		add(17119 , 0  , "precomputed result set defined");
		add(17120 , 0  , "default disk");
		add(17121 , 0  , "physical disk");
		add(17122 , 0  , "archive database disk");
		add(17123 , 0  , "read-only");
		add(17124 , 0  , "dump device");
		add(17125 , 0  , "serial writes");
		add(17126 , 0  , "device mirrored");
		add(17127 , 0  , "reads mirrored");
		add(17128 , 0  , "half-mirror only");
		add(17129 , 0  , "mirror enabled");
		add(17130 , 0  , "os_session_label");
		add(17131 , 0  , "maximum write");
		add(17132 , 0  , "current write");
		add(17133 , 0  , "minimum write");
		add(17134 , 0  , "maximum read");
		add(17135 , 0  , "current read");
		add(17136 , 0  , "maxhold");
		add(17137 , 0  , "minhold");
		add(17138 , 0  , "clearance");
		add(17139 , 0  , "SQL function");
		add(17140 , 0  , "referential constraint");
		add(17142 , 0  , "You need to be able to set curwrite label to data_high. This script will continue in spite of failure to set curwrite. Please rerun after setting your labels correctly.");
		add(17144 , 0  , "identity in nonunique index");
		add(17145 , 0  , "auto identity");
		add(17148 , 0  , "readonly");
		add(17149 , 0  , "User defined optimizer goal with such name does not exist. Please check the goal name.");
		add(17150 , 0  , "Incorrect action. Possible actions are : 'show','save','delete'.");
		add(17151 , 0  , "System defined optimizer goal cannot be modified.");
		add(17152 , 0  , "The dump history file version is invalid.");
		add(17153 , 0  , "allow incremental dumps");
		add(17154 , 0  , "Incremental dumps are not enabled in database %1!.");
		add(17155 , 0  , "There isn't any incremental dump information available for database %1! because the database has not been fully dumped yet.");
		add(17156 , 0  , "Warning: The replication status for database '%1!' is being set to 'L0'. Replication of 'writetext' command will not be supported for replication status 'L0'.");
		add(17157 , 0  , "%1! command is not allowed in current server state (%2!).");
		add(17158 , 0  , "Cannot run this command as %1! is not configured. A user with System Administrator (SA) role must reconfigure the system to enable %2!.");
		add(17159 , 0  , "ASE encountered an error during '%1!'. Check the ASE error log of server '%2!' for details.");
		add(17160 , 0  , "Shared memory dump file compression level: %1!");
		add(17161 , 0  , "There are no databases encrypted with key '%1!'.");
		add(17162 , 0  , "Partition name has been changed.");
		add(17163 , 0  , "There is already a partition named '%1!' for index '%2!'.");
		add(17164 , 0  , "user-created");
		add(17165 , 0  , "enhanced performance temp db");
		add(17166 , 0  , "warning: '%1!' is the same as the local server name");
		add(17168 , 0  , "low durability");
		add(17170 , 0  , "encrypted");
		add(17171 , 0  , "The Replication Agent configuration property '%1!' is changed for database '%2!'. This property is not currently active, the change will take effect the next time the Replication Agent is started with the '%3!' property %4!.");
		add(17172 , 0  , "HADR group '%1!' is already configured on this server. Drop an existing group before configuring new group.");
		add(17173 , 0  , "The '%1!' option is not valid in the Adaptive Server Cluster Edition.");
		add(17174 , 0  , "Partition level locking");
		add(17175 , 0  , "encryption in progress");
		add(17176 , 0  , "decryption in progress");
		add(17177 , 0  , "encrypted partly");
		add(17178 , 0  , "decrypted partly");
		add(17180 , 0  , "erase residual data");
		add(17181 , 0  , "Only users with %1! can execute this command.");
		add(17182 , 0  , "You should be in the sybsecurity database to execute this command.");
		add(17183 , 0  , "Create view ch_events failed.");
		add(17184 , 0  , "View ch_events does not exist. Use 'sp_confighistory create_view' to create this view.");
		add(17185 , 0  , "Invalid parameter '%1!'. Use 'sp_confighistory help' to show usage.");
		add(17186 , 0  , "Usage: sp_helptrigger {table_name | view_name}");
		add(17187 , 0  , "Object '%1!' is not a table or a view");
		add(17188 , 0  , "There are no %1! triggers declared on %2! %3!");
		add(17189 , 0  , "%1! can not be used for %2!.");
		add(17190 , 0  , "You cannot set the '%1!' option for a proxy database.");
		add(17191 , 0  , "Logical cluster: %1! has no database associated with it.");
		add(17192 , 0  , "Invalid operation: '%1!' invoked on database: '%2!' which is not configured for single instance access. Call sp_helpdb to check database type.");
		add(17193 , 0  , "Invalid operation: '%1!' invoked on logical cluster: '%2!' which is not configured for single instance access. Call sp_cluster logical, show to check logical cluster type.");
		add(17194 , 0  , "Internal error for: '%1!' database '%2!' for logical cluster: '%3!'.");
		add(17195 , 0  , "Operation: '%1!' successful on database: '%2!' for logical cluster: '%3!'.");
		add(17197 , 0  , "Work table '%1!' was found in tempdb. This may be because another user has executed sp_sysmon with begin_sample. Please run sp_sysmon again after the other sp_sysmon session has finished executing or delete the work table if it is not in use.");
		add(17198 , 0  , "The 'async log service' option can only be set to true for configurations that have a 'user log cache queue size' set to '0'.");
		add(17199 , 0  , "Invalid parameter '%1!'.");
		add(17200 , 0  , "Message number must be greater than or equal to 17000.");
		add(17201 , 0  , "'%1!' is not an official language name from syslanguages.");
		add(17202 , 0  , "Message number %1! does not exist in the %2! language.");
		add(17203 , 0  , "row level compressed");
		add(17204 , 0  , "page level compressed");
		add(17205 , 0  , "contains compressed data");
		add(17206 , 0  , "page compression");
		add(17207 , 0  , "row compression");
		add(17208 , 0  , "Usage: sp_logging_rate {'full'|'sum', '[day,]hh:mm:ss'}[, @interval='hh:mm:ss'][, @clear_option='y'|'n']");
		add(17209 , 0  , "Illegal format: '%1!'.");
		add(17210 , 0  , "Message number must be at least 20000.");
		add(17211 , 0  , "Cannot add message until sysusermessages system table is created properly by Upgrade.");
		add(17212 , 0  , "A message with number %1! in the specified language already exists.");
		add(17213 , 0  , "Drop the old message first if you still wish to add this one.");
		add(17214 , 0  , "The message has been inserted.");
		add(17215 , 0  , "The message has not been inserted.");
		add(17216 , 0  , "Only the System Administrator (SA) or the Database Owner (dbo) may add messages which set the WITH_LOG option to `'true'`.");
		add(17217 , 0  , "The only valid @with_log values are TRUE or FALSE.");
		add(17218 , 0  , "Message number %1! with language ID %2! was created by user ID %3!. You cannot replace that message; you must first delete the existing message using sp_dropmessage, then add the changed message.");
		add(17219 , 0  , "Can't start sampling because interval time '%1!' is longer than duration time '%2!'.");
		add(17220 , 0  , "Message number %1! does not exist.");
		add(17221 , 0  , "Message deleted.");
		add(17222 , 0  , "User '%1!' does not have permission to drop message number %2!.");
		add(17223 , 0  , "User '%1!' does not have permission to drop message number %2! in the %3! language.");
		add(17224 , 0  , "Drop failed.  Your curwrite label must match the security label of the message.  Check sysusermessages.");
		add(17225 , 0  , "The '%1!' option is not supported when '%2!' is %3!.");
		add(17226 , 0  , "The dump history file is empty or the version is missing.");
		add(17227 , 0  , "index compression");
		add(17228 , 0  , "The 'resolve as' user name maps a user name to itself. The command is ignored.");
		add(17229 , 0  , "Resolve as' mapping exists for user '%1!'. Use sp_modifyuser to drop current mapping.");
		add(17230 , 0  , "You must be the System Administrator (SA) or the Database Owner (dbo) to execute this procedure.");
		add(17231 , 0  , "No login with the specified name exists.");
		add(17232 , 0  , "No user with the specified name exists in the current database.");
		add(17233 , 0  , "'%1!' is already a user in the current database.");
		add(17234 , 0  , "The specified user name is already aliased.");
		add(17235 , 0  , "Alias user added.");
		add(17236 , 0  , "Setting curwrite label to data_low for inserts into sysalternates table failed.");
		add(17237 , 0  , "defer_index_recovery auto");
		add(17238 , 0  , "defer_index_recovery manual");
		add(17239 , 0  , "defer_index_recovery none");
		add(17240 , 0  , "'%1!' is not a valid name.");
		add(17241 , 0  , "A user with the specified group name already exists.");
		add(17242 , 0  , "A group with the specified name already exists.");
		add(17243 , 0  , "New group added.");
		add(17245 , 0  , "defer_index_recovery parallel");
		add(17246 , 0  , "Indexes created on system tables cannot have their recovery deferred.");
		add(17247 , 0  , "There are no indexes in '%1!' '%2!' whose creation has been deferred by LOAD TRAN recovery.");
		add(17248 , 0  , "The recovery of index '%1!' is not deferred during the LOAD TRAN recovery.");
		add(17249 , 0  , "The database name must be specified if the option is either 'create' or 'drop'.");
		add(17250 , 0  , "'%1!' already exists in syslanguages.");
		add(17251 , 0  , "'%1!' is not a valid date order.");
		add(17252 , 0  , "'%1!' is not a valid first day.");
		add(17253 , 0  , "'%1!' alias already exists in syslanguages.");
		add(17254 , 0  , "Language not inserted.");
		add(17255 , 0  , "New language inserted.");
		add(17256 , 0  , "There is no HADR server named '%1!'.");
		add(17257 , 0  , "There is already a DR monitor server for HADR server '%1!'.");
		add(17258 , 0  , "%1! is not a DR monitor server, hence it cannot be dropped using sp_hadr_admin 'dropmonserver' command.");
		add(17259 , 0  , "Warning: The execution of the stored procedure sp_reptostandby will take time to process all the tables and all the text/image columns in database '%1!'.");
		add(17260 , 0  , "Can't run %1! from within a transaction.");
		add(17261 , 0  , "Only the System Administrator (SA) may execute this procedure.");
		add(17262 , 0  , "A user with the specified login name already exists.");
		add(17263 , 0  , "Database name not valid -- login not added.");
		add(17264 , 0  , "New login created.");
		add(17265 , 0  , "A role with the specified name '%1!' already exists in this Server.");
		add(17266 , 0  , "All logins have been assigned. No more logins can be added at this time.");
		add(17267 , 0  , "Invalid value specified for %1! option. Login not created.");
		add(17268 , 0  , "Usage: sp_modifyuser user_name, 'resolve as' [, owning_user_name ] null or no value for 'owning_user_name' removes existing 'resolve as' mapping");
		add(17269 , 0  , "latch free index");
		add(17270 , 0  , "There is not a server named '%1!'.");
		add(17271 , 0  , "'%1!' is the local server - remote login not applicable.");
		add(17272 , 0  , "There is already a default-name mapping of a remote login from remote server '%1!'.");
		add(17273 , 0  , "New remote login creat