/*******************************************************************************
 * Copyright (C) 2010-2019 Goran Schwarz
 * 
 * This file is part of DbxTune
 * DbxTune is a family of sub-products *Tune, hence the Dbx
 * Here are some of the tools: AseTune, IqTune, RsTune, RaxTune, HanaTune, 
 *          SqlServerTune, PostgresTune, MySqlTune, MariaDbTune, Db2Tune, ...
 * 
 * DbxTune is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * DbxTune is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DbxTune.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * NOTE: SEK is ALLOWED to use this utility file for SEK ASE Auditor Project
 *       This is cleared by Goran Schwarz, the author of DbxTune
 ******************************************************************************/
package sek.ase.auditor.utils;

import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.sybase.jdbcx.EedInfo;
import com.sybase.util.ds.interfaces.Service;
import com.sybase.util.ds.interfaces.SyInterfacesDriver;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;

public class AseUtils
{
	private static Logger _logger = LogManager.getLogger(MethodHandles.lookup().lookupClass());

	/**
	 * Get Some text description for ALL SQLException or SQLWarning in the Exception chain
	 * @param sqle
	 * @return
	 */
	public static String sqlExceptionOrWarningAllToString(SQLException sqle)
	{
		StringBuffer sb = new StringBuffer();
		
		String prefix = "";
		int cnt = 0;
		while (sqle != null)
		{
			cnt++;
			if (sqle instanceof EedInfo) 
			{
				EedInfo sybsqle = (EedInfo) sqle;
				
				int errorCode = sqle   .getErrorCode();
				int severity  = sybsqle.getSeverity();

				sb.append(prefix); // Add comma to if not FIRST entry
				sb.append( "(Srv='"      ).append( sybsqle.getServerName()    ).append("'");;
				if (errorCode != 0 && severity != 10) // Pure INFO messages, collapse error and severity
				{
					sb.append( ", Error="    ).append( errorCode );
					sb.append( ", Severity=" ).append( severity  );
				}
				if (StringUtil.hasValue(sybsqle.getProcedureName()))
				{
					sb.append( ", Proc='").append( sybsqle.getProcedureName() ).append("'");;
					sb.append( ", Line=" ).append( sybsqle.getLineNumber() );
				}
				sb.append( ", Text='"    ).append( sqle.getMessage().trim()   ).append("'");
				sb.append( ")" );
			}
			else
			{
				sb.append( "(Error=" ).append( sqle.getErrorCode() );
				sb.append( ", Text='").append( sqle.getMessage()   ).append("'");
				sb.append( ")" );
			}
			sqle = sqle.getNextException();
			prefix = ", ";
		}
		// Remove surrounding '(' and ')' if we only have 1 exception/warning 
		if (cnt == 1)
		{
			sb.delete(0, 1);
			sb.delete(sb.length()-1, sb.length());
		}
		return sb.toString();
	}

	/**
	 * Get Some text description for a SQLException or SQLWarning
	 * @param sqle
	 * @return
	 */
	public static String sqlExceptionOrWarningSingleToString(SQLException sqle)
	{
		StringBuffer sb = new StringBuffer();
		if (sqle instanceof EedInfo) 
		{
			EedInfo sybsqle = (EedInfo) sqle;
			
			int errorCode = sqle   .getErrorCode();
			int severity  = sybsqle.getSeverity();

			sb.append( "Srv='"        ).append( sybsqle.getServerName()   ).append("'");
			if (errorCode != 0 && severity != 10) // Pure INFO messages, collapse error and severity
			{
				sb.append( ", Error="    ).append( errorCode );
				sb.append( ", Severity=" ).append( severity  );
			}
			if (StringUtil.hasValue(sybsqle.getProcedureName()))
			{
				sb.append( ", Proc='").append( sybsqle.getProcedureName() ).append("'");
				sb.append( ", Line=" ).append( sybsqle.getLineNumber() );
			}
			sb.append( ", Text='"    ).append( sqle.getMessage().trim()   ).append("'");
		}
		else
		{
			sb.append( "Error=" ).append( sqle.getErrorCode() );
			sb.append( ", Text='" ).append( sqle.getMessage() ).append("'");
		}
		return sb.toString();
	}
	
	
	public static String getHostPortFromInterfacesFile(String server) 
//	throws IOException, InterfacesException
	{
//		System.setProperty("interfaces.file", interfacesFile);
//		_interfacesDriver = new SyInterfacesDriver(interfacesFile);
//		_interfacesDriver.open(interfacesFile);

		SyInterfacesDriver interfacesDriver = new SyInterfacesDriver();
		try
		{
			interfacesDriver.open();
		}
		catch (Exception ex)
		{
			_logger.warn("getHostPortFromInterfacesFile(): Can not Initialize the interfaces driver. Caught: " + ex);
		}

		// Get entry
		SyInterfacesEntry ie = interfacesDriver.getEntry(server);

		if (ie == null)
		{
			_logger.warn("getHostPortFromInterfacesFile(): Can not find an entry for server '" + server + "', from the interfaces driver '" + interfacesDriver.getBundle() + "'. null will be returned.");
			return null;
		}

		String hostPortStr = "";

		// LOOP query/master rows in current SERVERNAME entry
		List<Service> queryRows = ie.getServices();
		for (Iterator<Service> it = queryRows.iterator(); it.hasNext(); )
		{
			// se Service Entry
			Service se = it.next();

			if ( Service.QUERY.equalsIgnoreCase(se.getType()) )
			{
				String seHost = se.getHost();
				String sePort = se.getPort();

				hostPortStr += seHost + ":" + sePort;
				
//				if (it.hasNext())
//					hostPortStr += ",";
				
				return hostPortStr;
			}
		} // end: LOOP queryRows

//		return hostPortStr;
		return null;
	}




	public static int getAseConfigRunValue(Connection conn, String config)
	throws SQLException
	{
		int    val = -1;

		Statement stmt = conn.createStatement();
		ResultSet rs = stmt.executeQuery("sp_configure '"+config+"'");
		while (rs.next())
		{
			val = rs.getInt(5);
		}
		rs.close();
		stmt.close();
		
		return val;
	}

	public static String getAseConfigRunValueStr(Connection conn, String config)
	throws SQLException
	{
		String val = null;

		Statement stmt = conn.createStatement();
		ResultSet rs = stmt.executeQuery("sp_configure '"+config+"'");
		while (rs.next())
		{
			val = rs.getString(5);
		}
		rs.close();
		stmt.close();
		
		if ( val != null )
			val = val.trim();

		return val;
	}
}
