/*******************************************************************************
 * SEK ASE Auditor -- Created by: goran.schwarz@executeit.se
 ******************************************************************************/
package sek.ase.auditor.wqs;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import sek.ase.auditor.collectors.records.AuditRecord;


public class WriterQueueContainer
{
	private static Logger _logger = LogManager.getLogger();

	/*---------------------------------------------------
	** Constants
	**---------------------------------------------------
	*/

	/*---------------------------------------------------
	** class members
	**---------------------------------------------------
	*/
	/** This one is maintained from the PersistWriter, which is responsible for starting/ending storage sessions. 
	 * If _sessionStartTime is set by a user, it will be over written by the PersistCoiunterHandler or the PersistWriter */
	protected Timestamp           _mainSampleTime   = null;
	protected String              _serverName       = null;
	protected String              _onHostname       = null;
//	private   List<CountersModel> _counterObjects   = null;
	private   List<AuditRecord>   _auditRecords     = null;


	/**
	 * Small class to hold Header information
	 */
	public static class HeaderInfo
	{
		private Timestamp _mainSampleTime;
		private String    _serverName;        // Normally the DBMS instance name
		private String    _onHostname;        // on which host does this server run

		public HeaderInfo()
		{
		}
		
		public Timestamp getMainSampleTime()             { return _mainSampleTime; }
		public void      setMainSampleTime(Timestamp ts) { _mainSampleTime = ts; }

		public String    getServerName()       { return _serverName; }
		public String    getOnHostname()       { return _onHostname; }

		public HeaderInfo(Timestamp mainSampleTime, String serverName, String onHostname)
		{
			_mainSampleTime   = mainSampleTime;
			_serverName       = serverName;
			_onHostname       = onHostname;
		}
	}
	
	/*---------------------------------------------------
	** Constructors
	**---------------------------------------------------
	*/
	private WriterQueueContainer(Timestamp mainSampleTime, String serverName, String onHostname)
	{
		_mainSampleTime    = mainSampleTime;
		_serverName        = serverName;
		_onHostname        = onHostname;
	}
	
	public WriterQueueContainer(HeaderInfo headerInfo)
	{
		this(headerInfo.getMainSampleTime(), headerInfo.getServerName(), headerInfo.getOnHostname());
	}


	/*---------------------------------------------------
	** Methods
	**---------------------------------------------------
	*/
	public void setMainSampleTime   (Timestamp mainSampleTime) { _mainSampleTime    = mainSampleTime; }
	public void setServerName       (String serverName)        { _serverName        = serverName; }
	public void setOnHostname       (String onHostname)        { _onHostname        = onHostname; }
	
	/** Get the "main" Timestamp, this is the time when a "loop" to collect all various ConterModdel's, which we get data for */ 
	public Timestamp getMainSampleTime()    { return _mainSampleTime; }
	public String    getServerName()        { return _serverName; }
	public String    getOnHostname()        { return _onHostname; }

	public void add(AuditRecord auditRecord)
	{
		if (auditRecord == null)
			return;

		auditRecord.setContainer(this);

		if (_auditRecords == null)
			_auditRecords = new ArrayList<AuditRecord>(200);

//		if (_logger.isDebugEnabled())
//			_logger.debug("WriterQueueContainer.add: name=" + StringUtil.left(cm.getName(),20) + ", timeHead=" + cm.getSampleTimeHead() + ", sampleTime=" + cm.getSampleTime() + ", interval=" + cm.getSampleInterval());
		_auditRecords.add(auditRecord);
	}

	/**
	 * Get counter objects
	 * @return Will never return null
	 */
	public List<AuditRecord> getAuditRecords()
	{
		if (_auditRecords == null)
			return Collections.emptyList();
		return _auditRecords;		
	}
	
	/**
	 * check if the contains contains anything...
	 * @return
	 */
	public boolean isEmpty()
	{
		return getAuditRecords().isEmpty();
	}
	
	/**
	 * Returns the number of Entries in this Audit Records list...
	 * @return
	 */
	public int size()
	{
		return getAuditRecords().size();
	}
	
	public boolean equals(WriterQueueContainer pc)
	{
		if (pc == null)	         return false;
		if (_mainSampleTime == null) return false;
		
		return _mainSampleTime.equals(pc.getMainSampleTime());
	}
	
	
	//////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////
	//// ---- TEST CODE ---- TEST CODE ---- TEST CODE ---- TEST CODE ----
	//////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////
//	public static void main(String[] args) 
//	{
//	}

}
