/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin;

import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCItem2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCPageController;
import com.sybase.central.SCProfile;
import com.sybase.central.SCProvider3;
import com.sybase.central.SCProviderLoader;
import com.sybase.central.SCViewerSupport;
import com.sybase.central.SCViewerSupport4;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.util.Dbg;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;

public abstract class BaseProvider
implements SCProvider3 {
    private SCViewerSupport4 _viewerSupport;
    private JFrame _frame;
    private static SCProfile _profile;
    private static SCProviderLoader _loader;
    private static Vector _dialogList;

    public BaseProvider() {
        _dialogList = new Vector();
    }

    public abstract String getDisplayName();

    public abstract String getDisplayVersion();

    public abstract String getId();

    public abstract SCMenu getHelpMenu();

    public abstract void onHelpCommand(JFrame var1, int var2);

    public boolean initialize(JFrame jFrame, SCViewerSupport sCViewerSupport) {
        this._viewerSupport = (SCViewerSupport4)sCViewerSupport;
        this._frame = jFrame;
        return true;
    }

    public boolean startup(JFrame jFrame, SCProfile sCProfile, SCProviderLoader sCProviderLoader) {
        _profile = sCProfile;
        _loader = sCProviderLoader;
        return true;
    }

    public boolean isOkToShutdown(JFrame jFrame) {
        return this.isOkToCloseDialogs();
    }

    public void shutdown() {
        this.closeAllDialogs();
    }

    public boolean editConnection(JFrame jFrame, SCProfile sCProfile) {
        return false;
    }

    public boolean restoreConnection(JFrame jFrame, SCProfile sCProfile) {
        return false;
    }

    public boolean supportsConnectionProfiles() {
        return false;
    }

    public SCMenu getContextExtensionMenu(String[] stringArray) {
        return null;
    }

    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, Object object) {
    }

    public SCPageController[] getPropertyExtensionPages(SCItem2 sCItem2, SCDialogSupport sCDialogSupport) {
        return null;
    }

    public SCViewerSupport4 getViewerSupport() {
        return this._viewerSupport;
    }

    public JFrame getViewerFrame() {
        return this._frame;
    }

    public SCProviderLoader getLoader() {
        return _loader;
    }

    public SCProfile getProfile() {
        return _profile;
    }

    public void registerDialog(BaseController baseController) {
        Dbg.wassert(baseController != null, "Null base controller parameter.");
        Dbg.trace(1, "Register Dialog '" + baseController.getTitle() + "'");
        _dialogList.add(baseController);
    }

    public void unRegisterDialog(BaseController baseController) {
        Dbg.wassert(baseController != null, "Null base controller parameter.");
        Dbg.wassert(_dialogList.contains(baseController), "Dialog was not registered with the provider.");
        Dbg.trace(1, "Unregister Dialog '" + baseController.getTitle() + "'");
        _dialogList.remove(baseController);
    }

    public BaseController getDialog(Class clazz) {
        Dbg.wassert(clazz != null, "Null dialog class parameter.");
        for (int i = 0; i < _dialogList.size(); ++i) {
            BaseController baseController = (BaseController)_dialogList.get(i);
            if (baseController.getClass() != clazz || baseController.getItemName() != null) continue;
            return baseController;
        }
        return null;
    }

    public BaseController getDialog(Class clazz, String string) {
        Dbg.wassert(clazz != null, "Null dialog class parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty key name parameter.");
        for (int i = 0; i < _dialogList.size(); ++i) {
            BaseController baseController = (BaseController)_dialogList.get(i);
            if (baseController.getClass() != clazz || baseController.getItemName() == null || !baseController.getItemName().equals(string)) continue;
            return baseController;
        }
        return null;
    }

    protected boolean isOkToCloseDialogs() {
        boolean bl = true;
        for (int i = 0; i < _dialogList.size() && bl; ++i) {
            BaseController baseController = (BaseController)_dialogList.get(i);
            bl = baseController.isOkToClose();
        }
        return bl;
    }

    protected void closeAllDialogs() {
        Dbg.trace(1, "Close all registered Dialogs");
        Object[] objectArray = _dialogList.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            BaseController baseController = (BaseController)objectArray[i];
            baseController.closeDialog();
        }
    }
}

