/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin;

import com.sybase.rsmplugin.ExtensibleListResource;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.util.Dbg;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class BundleManager {
    private static BundleManager _mgr = null;
    private HashMap _bundleTable = new HashMap();
    private static final String RES_NOT_FND = "Resource Bundle Error";
    public static final String RES_DIR = "com.sybase.rsmplugin.resources";

    protected BundleManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this._bundleTable.clear();
        }
        finally {
            super.finalize();
        }
    }

    public ExtensibleListResource get(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty bundle name.");
        Dbg.wassert(this._bundleTable != null, "Null resource bundle hash table.");
        return (ExtensibleListResource)this._bundleTable.get(string);
    }

    public void put(String string, ExtensibleListResource extensibleListResource) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty bundle name.");
        Dbg.wassert(extensibleListResource != null, "Null resource bundle parameter.");
        Dbg.wassert(this._bundleTable != null, "Null resource bundle hash table.");
        this._bundleTable.put(string, extensibleListResource);
    }

    public static ExtensibleListResource getResource(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty bundle name.");
        Dbg.wassert(string.indexOf(".".charAt(0)) == -1, "Bundle must not include the package information.");
        if (_mgr == null) {
            _mgr = new BundleManager();
        }
        ExtensibleListResource extensibleListResource = _mgr.get(string);
        try {
            if (extensibleListResource == null) {
                String string2 = "com.sybase.rsmplugin.resources." + string;
                extensibleListResource = (ExtensibleListResource)ResourceBundle.getBundle(string2);
                _mgr.put(string, extensibleListResource);
            }
        }
        catch (MissingResourceException missingResourceException) {
            PluginSupport.LogErrorMessage(RES_NOT_FND, missingResourceException.getMessage());
            extensibleListResource = null;
        }
        return extensibleListResource;
    }

    public static String getString(String string, String string2) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty bundle name.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty resource key.");
        String string3 = null;
        ExtensibleListResource extensibleListResource = BundleManager.getResource(string);
        if (extensibleListResource != null) {
            try {
                string3 = extensibleListResource.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                PluginSupport.LogErrorMessage(RES_NOT_FND, missingResourceException.getMessage());
            }
        }
        return string3;
    }

    public static String getString(String string, String string2, String string3) {
        Object[] objectArray = new String[]{string3};
        return BundleManager.getString(string, string2, objectArray);
    }

    public static String getString(String string, String string2, Object[] objectArray) {
        String string3 = BundleManager.getString(string, string2);
        if (string3 != null) {
            string3 = MessageFormat.format(string3, objectArray);
        }
        return string3;
    }

    public static char getMnemonic(String string, String string2) {
        char c = '\u0000';
        String string3 = BundleManager.getString(string, string2);
        if (string3 != null) {
            Dbg.wassert(string3.length() == 1, "Value string is not a single character");
            c = string3.charAt(0);
        }
        return c;
    }
}

