/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCLogEntry;
import com.sybase.central.SCProfile;
import com.sybase.central.SCProvider;
import com.sybase.central.SCProviderLoader;
import com.sybase.central.SCViewerSupport4;
import com.sybase.rsmplugin.RSMProvider;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.toplevel.TopContainer;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.Container;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class PluginSupport {
    public static final String PROFILE_LIST_DELIMITER = ",";
    private static final String BOOLEAN_TRUE_STR = "true";
    private static final String BOOLEAN_FALSE_STR = "false";
    private static RSMProvider _plugin;

    public PluginSupport(RSMProvider rSMProvider) {
        _plugin = rSMProvider;
    }

    public static RSMProvider getPlugin() {
        return _plugin;
    }

    public static SCProviderLoader getLoader() {
        return PluginSupport.getPlugin().getLoader();
    }

    public static SCViewerSupport4 getViewerSupport() {
        return PluginSupport.getPlugin().getViewerSupport();
    }

    public static JFrame getViewerFrame() {
        return PluginSupport.getPlugin().getViewerFrame();
    }

    public static SCDialogSupport2 getDialogSupport(JFrame jFrame) {
        return (SCDialogSupport2)PluginSupport.getViewerSupport().getDialogSupport(jFrame);
    }

    public static SCDialogSupport2 getDialogSupport(JDialog jDialog) {
        return (SCDialogSupport2)PluginSupport.getViewerSupport().getDialogSupport(jDialog);
    }

    public static SCProfile getProfile() {
        return PluginSupport.getPlugin().getProfile();
    }

    public static String readProfileString(String string) {
        return PluginSupport.getProfile().readString(string);
    }

    public static String readProfileStringEncrypted(String string) {
        return PluginSupport.getProfile().readEncryptedString(string);
    }

    public static int readProfileInt(String string) {
        int n = 0;
        try {
            n = Integer.valueOf(PluginSupport.readProfileString(string));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public static List readProfileStringList(String string) {
        String string2 = PluginSupport.getProfile().readString(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, PROFILE_LIST_DELIMITER);
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(MessageText.removeDoubleQuotes(stringTokenizer.nextToken()));
        }
        return arrayList;
    }

    public static List readProfileStringListEncrypted(String string) {
        String string2 = PluginSupport.getProfile().readEncryptedString(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, PROFILE_LIST_DELIMITER);
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(MessageText.removeDoubleQuotes(stringTokenizer.nextToken()));
        }
        return arrayList;
    }

    public static int[] readProfileIntArray(String string) {
        String string2 = PluginSupport.getProfile().readString(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, PROFILE_LIST_DELIMITER);
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                nArray[n] = Integer.valueOf(stringTokenizer.nextToken().trim());
            }
            catch (NumberFormatException numberFormatException) {
                nArray[n] = 100;
            }
            ++n;
        }
        return nArray;
    }

    public static Rectangle readProfileRectangle(String string) {
        Rectangle rectangle = null;
        int[] nArray = PluginSupport.readProfileIntArray(string);
        if (nArray != null && nArray.length == 4) {
            rectangle = new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        return rectangle;
    }

    public static boolean readProfileBoolean(String string, boolean bl) {
        String string2 = PluginSupport.getProfile().readString(string);
        if (string2 == null || string2.length() == 0) {
            return bl;
        }
        if (string2.equalsIgnoreCase(BOOLEAN_TRUE_STR)) {
            return true;
        }
        Dbg.wassert(string2.equalsIgnoreCase(BOOLEAN_FALSE_STR), "Invalid boolean flag for profile key: " + string);
        return false;
    }

    public static void writeProfileString(String string, String string2) {
        PluginSupport.getProfile().writeString(string, string2);
    }

    public static void writeProfileStringEncrypted(String string, String string2) {
        PluginSupport.getProfile().writeEncryptedString(string, string2);
    }

    public static void writeProfileInt(String string, int n) {
        String string2 = String.valueOf(n);
        PluginSupport.getProfile().writeString(string, string2);
    }

    public static void writeProfileStringList(String string, List list) {
        String string2 = new String();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string3 = (String)listIterator.next();
            if (string3 == null) {
                string3 = "";
            }
            string2 = string2 + MessageText.addDoubleQuotes(string3);
            if (!listIterator.hasNext()) continue;
            string2 = string2 + PROFILE_LIST_DELIMITER;
        }
        PluginSupport.getProfile().writeString(string, string2);
    }

    public static void writeProfileStringListEncrypted(String string, List list) {
        String string2 = new String();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string3 = (String)listIterator.next();
            if (string3 == null) {
                string3 = "";
            }
            string2 = string2 + MessageText.addDoubleQuotes(string3);
            if (!listIterator.hasNext()) continue;
            string2 = string2 + PROFILE_LIST_DELIMITER;
        }
        PluginSupport.getProfile().writeEncryptedString(string, string2);
    }

    public static void writeProfileIntArray(String string, int[] nArray) {
        String string2 = new String();
        for (int i = 0; i < nArray.length; ++i) {
            string2 = string2 + String.valueOf(nArray[i]);
            if (i + 1 >= nArray.length) continue;
            string2 = string2 + PROFILE_LIST_DELIMITER;
        }
        PluginSupport.getProfile().writeString(string, string2);
    }

    public static void writeProfileRectangle(String string, Rectangle rectangle) {
        String string2 = new String();
        string2 = string2 + String.valueOf(rectangle.x);
        string2 = string2 + PROFILE_LIST_DELIMITER;
        string2 = string2 + String.valueOf(rectangle.y);
        string2 = string2 + PROFILE_LIST_DELIMITER;
        string2 = string2 + String.valueOf(rectangle.width);
        string2 = string2 + PROFILE_LIST_DELIMITER;
        string2 = string2 + String.valueOf(rectangle.height);
        PluginSupport.getProfile().writeString(string, string2);
    }

    public static void writeProfileBoolean(String string, boolean bl) {
        if (bl) {
            PluginSupport.writeProfileString(string, BOOLEAN_TRUE_STR);
        } else {
            PluginSupport.writeProfileString(string, BOOLEAN_FALSE_STR);
        }
    }

    public static void deleteProfileString(String string) {
        PluginSupport.getProfile().deleteString(string);
    }

    public static void LogInfoMessage(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginSupport.getViewerSupport().addLogEntry(new SCLogEntry(2, Calendar.getInstance().getTime(), PluginSupport.getPlugin().getDisplayName(), string, string2, "plain"));
                Dbg.traceSystemMessage(2048, 2, string, string2);
            }
        });
    }

    public static void LogWarningMessage(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginSupport.getViewerSupport().addLogEntry(new SCLogEntry(1, Calendar.getInstance().getTime(), PluginSupport.getPlugin().getDisplayName(), string, string2, "plain"));
                Dbg.traceSystemMessage(2048, 1, string, string2);
            }
        });
    }

    public static void LogErrorMessage(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginSupport.getViewerSupport().addLogEntry(new SCLogEntry(0, Calendar.getInstance().getTime(), PluginSupport.getPlugin().getDisplayName(), string, string2, "plain"));
                Dbg.traceSystemMessage(2048, 0, string, string2);
            }
        });
    }

    public static void showInfo(String string, String string2) {
        PluginSupport.showInfo(PluginSupport.getViewerFrame(), string, string2);
    }

    public static void showInfo(Container container, String string, String string2) {
        PluginSupport.getViewerSupport().messageBoxString(container, string, 1);
        if (string2 != null && string2.length() > 0) {
            PluginSupport.LogInfoMessage(string, string2);
        } else {
            PluginSupport.LogInfoMessage(string, string);
        }
    }

    public static void showWarning(String string, String string2) {
        PluginSupport.showWarning(PluginSupport.getViewerFrame(), string, string2);
    }

    public static void showWarning(Container container, String string, String string2) {
        PluginSupport.getViewerSupport().messageBoxString(container, string, 2);
        if (string2 != null && string2.length() > 0) {
            PluginSupport.LogWarningMessage(string, string2);
        } else {
            PluginSupport.LogWarningMessage(string, string);
        }
    }

    public static void showError(String string, String string2) {
        PluginSupport.showError(PluginSupport.getViewerFrame(), string, string2);
    }

    public static void showError(Container container, String string, String string2) {
        PluginSupport.getViewerSupport().messageBoxString(container, string, 0);
        if (string2 != null && string2.length() > 0) {
            PluginSupport.LogErrorMessage(string, string2);
        } else {
            PluginSupport.LogErrorMessage(string, string);
        }
    }

    public static void showValidationError(String string) {
        PluginSupport.showValidationError(PluginSupport.getViewerFrame(), string);
    }

    public static void showValidationError(Container container, String string) {
        PluginSupport.getViewerSupport().messageBoxString(container, string, 0);
    }

    public static void showDetailedError(Throwable throwable) {
        PluginSupport.getViewerSupport().showDetailsErrorDialog((Container)PluginSupport.getViewerFrame(), throwable.toString(), throwable.getMessage());
        PluginSupport.LogErrorMessage(throwable.toString(), throwable.getMessage());
    }

    public static boolean askQuestion(String string, boolean bl) {
        return PluginSupport.askQuestion(string, PluginSupport.getViewerFrame(), bl);
    }

    public static boolean askQuestion(String string, Container container, boolean bl) {
        int n = PluginSupport.getViewerSupport().messageBoxString(container, string, 0, 3, bl ? 0 : 1);
        return n == 0;
    }

    public static boolean askQuestion(String string) {
        return PluginSupport.askQuestion(string, PluginSupport.getViewerFrame());
    }

    public static boolean askQuestion(String string, Container container) {
        int n = PluginSupport.getViewerSupport().messageBoxString(container, string, 0, 3);
        return n == 0;
    }

    public static void addEvent(Image image, String string, String string2, String string3, String string4) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty event object parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty event source parameter.");
        PluginSupport.getPlugin().getEventList().add(image, string, string2, string3, string4);
    }

    public static void addEvent(StatusSO statusSO) {
        Dbg.wassert(statusSO != null, "Null status semantic object parameter.");
        PluginSupport.getPlugin().getEventList().add(statusSO);
    }

    public static Domain getDomain(String string) {
        return PluginSupport.getPlugin().getDomain(string);
    }

    public static void registerDomain(Domain domain) {
        Dbg.wassert(domain != null, "Null EnvConnection parameter.");
        PluginSupport.getPlugin().registerDomain(domain);
        PluginSupport.getViewerSupport().registerConnection((SCProvider)PluginSupport.getPlugin(), domain.getName(), domain.getDescription(), (Object)domain);
    }

    public static void unregisterDomain(Domain domain) {
        PluginSupport.getPlugin().unregisterDomain(domain.getName());
        PluginSupport.getViewerSupport().unregisterConnection((Object)domain);
    }

    public static List getAllServers() {
        return PluginSupport.getPlugin().getAllServers();
    }

    public static void registerDialog(BaseController baseController) {
        PluginSupport.getPlugin().registerDialog(baseController);
    }

    public static void unRegisterDialog(BaseController baseController) {
        PluginSupport.getPlugin().unRegisterDialog(baseController);
    }

    public static BaseController getDialog(Class clazz) {
        return PluginSupport.getPlugin().getDialog(clazz);
    }

    public static BaseController getDialog(Class clazz, String string) {
        return PluginSupport.getPlugin().getDialog(clazz, string);
    }

    public static SemanticFactory getSemanticFactory(String string) {
        return PluginSupport.getPlugin().getSemanticFactory(string);
    }

    public static boolean logSQL() {
        return PluginSupport.getPlugin().logSQL();
    }

    public static void setLogSQL(boolean bl) {
        PluginSupport.getPlugin().setLogSQL(bl);
    }

    public static void refreshAll() {
        PluginSupport.getPlugin().refreshAll();
    }

    public static void refreshDomain(BaseItem baseItem) {
        PluginSupport.getPlugin().refreshDomain(baseItem);
    }

    public static void registerBkgndThread(BkgndThread bkgndThread) {
        PluginSupport.getPlugin().registerBkgndThread(bkgndThread);
    }

    public static void unregisterBkgndThread(BkgndThread bkgndThread) {
        PluginSupport.getPlugin().unregisterBkgndThread(bkgndThread);
    }

    public static TopContainer getTopContainer() {
        return PluginSupport.getPlugin().getTopContainer();
    }
}

