/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.DefaultSCMenuItem2;
import com.sybase.central.SCContainer;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.central.SCProfile;
import com.sybase.central.SCProvider;
import com.sybase.central.SCProviderLoader;
import com.sybase.central.SCViewerSupport;
import com.sybase.rsmplugin.BaseProvider;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMConstants;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.Version;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.bkgnd.BkgndThreadListDlg;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.ConnectDlg;
import com.sybase.rsmplugin.components.EnvSemanticFactory;
import com.sybase.rsmplugin.components.RMSSemanticFactory;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.toplevel.TopContainer;
import com.sybase.rsmplugin.eventlist.EventList;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.util.Dbg;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class RSMProvider
extends BaseProvider {
    private static final int CMD_ONLINE_HELP = 1;
    private static final String SC_PROFILE_LOG_SQL = "logSQLCommands";
    private static final String CONN_PROFILE_UID = "username";
    private static final String CONN_PROFILE_PWD = "password";
    private static final String CONN_PROFILE_ENV = "environment";
    private PluginSupport _support = null;
    private TopContainer _providerContainer = null;
    private HashMap _domainList = new HashMap();
    private ArrayList _bkgndThreads = new ArrayList();
    private boolean _logSQL = true;
    private HelpSet _HS = null;
    public HelpBroker _HB = null;
    private EventList _eventList;

    @Override
    public boolean initialize(JFrame jFrame, SCViewerSupport sCViewerSupport) {
        super.initialize(jFrame, sCViewerSupport);
        this._support = new PluginSupport(this);
        return true;
    }

    public void connect(JFrame jFrame) {
        ConnectDlg connectDlg = new ConnectDlg(PluginSupport.getDialogSupport(PluginSupport.getViewerFrame()), true);
        if (connectDlg.showDialog()) {
            Domain domain = connectDlg.getDomain();
            domain.save();
            this.getTopContainer().refresh();
        }
    }

    public void disconnect(JFrame jFrame, Object object) {
        Domain domain = (Domain)object;
        Dbg.trace(1, "Disconnect domain '" + domain.getName() + "'.");
        domain.disconnect();
        this.getTopContainer().collapse();
        this.getTopContainer().refresh();
    }

    @Override
    public boolean supportsConnectionProfiles() {
        return true;
    }

    @Override
    public boolean editConnection(JFrame jFrame, SCProfile sCProfile) {
        boolean bl = false;
        String string = sCProfile.readString(CONN_PROFILE_ENV);
        String string2 = sCProfile.readString(CONN_PROFILE_UID);
        String string3 = sCProfile.readEncryptedString(CONN_PROFILE_PWD);
        if (string != null && string.length() > 0) {
            ConnAttributes connAttributes = ConnAttributes.load(string, string);
            if (connAttributes != null) {
                connAttributes.setUser(string2);
                connAttributes.setPassword(string3);
                ConnectDlg connectDlg = new ConnectDlg(PluginSupport.getDialogSupport(PluginSupport.getViewerFrame()), false, connAttributes);
                bl = connectDlg.showDialog();
                if (bl) {
                    Domain domain = connectDlg.getDomain();
                    domain.save();
                    sCProfile.writeString(CONN_PROFILE_ENV, connectDlg.getDomainName());
                    sCProfile.writeString(CONN_PROFILE_UID, connectDlg.getUsername());
                    sCProfile.writeEncryptedString(CONN_PROFILE_PWD, connectDlg.getPassword());
                }
            } else {
                ConnectDlg connectDlg = new ConnectDlg(PluginSupport.getDialogSupport(PluginSupport.getViewerFrame()), false, string, string2, string3);
                bl = connectDlg.showDialog();
                if (bl) {
                    sCProfile.writeString(CONN_PROFILE_ENV, connectDlg.getDomainName());
                    sCProfile.writeString(CONN_PROFILE_UID, connectDlg.getUsername());
                    sCProfile.writeEncryptedString(CONN_PROFILE_PWD, connectDlg.getPassword());
                }
            }
        } else {
            ConnectDlg connectDlg = new ConnectDlg(PluginSupport.getDialogSupport(PluginSupport.getViewerFrame()), false);
            bl = connectDlg.showDialog();
            if (bl) {
                Domain domain = connectDlg.getDomain();
                if (domain != null) {
                    domain.save();
                }
                sCProfile.writeString(CONN_PROFILE_ENV, connectDlg.getDomainName());
                sCProfile.writeString(CONN_PROFILE_UID, connectDlg.getUsername());
                sCProfile.writeEncryptedString(CONN_PROFILE_PWD, connectDlg.getPassword());
                this.getTopContainer().refresh();
            }
        }
        return bl;
    }

    @Override
    public boolean restoreConnection(JFrame jFrame, SCProfile sCProfile) {
        boolean bl = false;
        String string = sCProfile.readString(CONN_PROFILE_ENV);
        String string2 = sCProfile.readString(CONN_PROFILE_UID);
        String string3 = sCProfile.readEncryptedString(CONN_PROFILE_PWD);
        Domain domain = PluginSupport.getDomain(string);
        if (domain != null) {
            PluginSupport.showValidationError(BundleManager.getString("DomainRes", "ERR_DOMAIN_ALREADY_CONNECTED", string));
        } else {
            try {
                ConnAttributes connAttributes = ConnAttributes.load(string, string);
                if (connAttributes != null) {
                    RMSDomain rMSDomain = new RMSDomain(string);
                    rMSDomain.connect(string2, string3, true);
                } else {
                    EnvDomain envDomain = new EnvDomain(string);
                    envDomain.connect(string2, string3);
                }
                this.getTopContainer().refresh();
                bl = true;
            }
            catch (SQLException sQLException) {
                PluginSupport.showValidationError(sQLException.getMessage());
            }
        }
        return bl;
    }

    @Override
    public String getDisplayName() {
        return BundleManager.getString("RSMProviderRes", "PROVIDER_NAME");
    }

    @Override
    public String getDisplayVersion() {
        return Version.getVersionBuildId();
    }

    public String getCopyrightMessage() {
        return Version.getVersionString();
    }

    @Override
    public String getId() {
        return RSMConstants.PROVIDER_ID;
    }

    public String getProviderName() {
        return "Replication Manager";
    }

    @Override
    public SCMenu getHelpMenu() {
        DefaultSCMenu defaultSCMenu = new DefaultSCMenu();
        DefaultSCMenuItem2 defaultSCMenuItem2 = new DefaultSCMenuItem2(2, BundleManager.getString("RSMProviderRes", "HELP_MENU"), BundleManager.getString("RSMProviderRes", "HELP_MENU_DESC"), 1);
        defaultSCMenu.addItem((SCMenuItem)defaultSCMenuItem2);
        return defaultSCMenu;
    }

    @Override
    public void onHelpCommand(JFrame jFrame, int n) {
        if (this._HB != null) {
            this._HB.setDisplayed(true);
        }
    }

    @Override
    public boolean startup(JFrame jFrame, SCProfile sCProfile, SCProviderLoader sCProviderLoader) {
        super.startup(jFrame, sCProfile, sCProviderLoader);
        this._logSQL = PluginSupport.readProfileBoolean(SC_PROFILE_LOG_SQL, false);
        this._providerContainer = new TopContainer();
        this.getViewerSupport().registerTopLevelContainer((SCContainer)this._providerContainer, (SCProvider)this);
        this._HS = this.getHelpSet(sCProviderLoader);
        this._HB = this._HS != null ? this._HS.createHelpBroker() : null;
        this._eventList = new EventList();
        this._eventList.initialize();
        this.getViewerSupport().setTopLevelJMenus(this.getSearchMenu(), (SCProvider)this);
        return true;
    }

    @Override
    public boolean isOkToShutdown(JFrame jFrame) {
        boolean bl = this.isOKToCancelThreads();
        if (bl) {
            bl = super.isOkToShutdown(jFrame);
        }
        return bl;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.cancelAllThreads();
        this._eventList.releaseResources();
        this.getViewerSupport().unregisterTopLevelContainer((SCContainer)this._providerContainer, (SCProvider)this);
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection collection = this._domainList.values();
        if (collection != null) {
            for (Object object : collection) {
                arrayList.add(object.getName());
            }
        }
        Iterator iterator = arrayList.listIterator();
        while (iterator.hasNext()) {
            Object object;
            object = (String)iterator.next();
            Domain domain = this.getDomain((String)object);
            if (domain == null) continue;
            domain.disconnect();
        }
    }

    protected HelpSet getHelpSet(SCProviderLoader sCProviderLoader) {
        Object object;
        String string;
        HelpSet helpSet = null;
        String string2 = null;
        String string3 = null;
        Locale locale = Locale.getDefault();
        if (locale != null) {
            string = locale.getLanguage();
            if (string != null) {
                if (string.equalsIgnoreCase("ja")) {
                    string2 = "rmja.jar";
                    string3 = "rmja.hs";
                } else if (string.equalsIgnoreCase("zh")) {
                    string2 = "rmzh.jar";
                    string3 = "rmzh.hs";
                } else if (string.equalsIgnoreCase("fr")) {
                    string2 = "rmfr.jar";
                    string3 = "rmfr.hs";
                } else {
                    string2 = "rmen.jar";
                    string3 = "rmen.hs";
                }
            } else {
                string2 = "rmen.jar";
                string3 = "rmen.hs";
            }
        } else {
            string2 = "rmen.jar";
            string3 = "rmen.hs";
        }
        string = null;
        String string4 = sCProviderLoader.getProviderClasspath();
        StringTokenizer stringTokenizer = new StringTokenizer(string4, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (!object.endsWith(string2)) continue;
            string = object;
            break;
        }
        if (string != null) {
            Dbg.trace(64, "Loading the help set from the jar file: " + string);
            try {
                object = this.getURLs("file:" + string);
                URLClassLoader uRLClassLoader = new URLClassLoader((URL[])object);
                URL uRL = HelpSet.findHelpSet((ClassLoader)uRLClassLoader, (String)string3);
                helpSet = new HelpSet((ClassLoader)uRLClassLoader, uRL);
            }
            catch (HelpSetException helpSetException) {
                Object[] objectArray = new String[]{string2, string3};
                PluginSupport.LogErrorMessage(BundleManager.getString("RSMProviderRes", "ERR_HELP_FILE", objectArray), helpSetException.getLocalizedMessage());
                helpSet = null;
            }
        } else {
            Dbg.trace(64, "Loading the help set from the RM's classpath: " + sCProviderLoader.getProviderClasspath());
            try {
                object = sCProviderLoader.getClassLoader();
                URL uRL = HelpSet.findHelpSet((ClassLoader)object, (String)string3);
                helpSet = new HelpSet((ClassLoader)object, uRL);
            }
            catch (HelpSetException helpSetException) {
                Object[] objectArray = new String[]{string2, string3};
                PluginSupport.LogErrorMessage(BundleManager.getString("RSMProviderRes", "ERR_HELP_FILE", objectArray), helpSetException.getLocalizedMessage());
                helpSet = null;
            }
        }
        return helpSet;
    }

    private URL[] getURLs(String string) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        try {
            objectArray = new URL(string);
            vector.addElement(objectArray);
        }
        catch (Exception exception) {
            Dbg.trace(64, "Unable to create URL with specification: " + string);
        }
        objectArray = new URL[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getVersionString() {
        return Version.getVersionString();
    }

    public boolean logSQL() {
        return this._logSQL;
    }

    public void setLogSQL(boolean bl) {
        this._logSQL = bl;
        PluginSupport.writeProfileBoolean(SC_PROFILE_LOG_SQL, this._logSQL);
    }

    public EventList getEventList() {
        Dbg.wassert(this._eventList != null, "Event list was not initialized.");
        return this._eventList;
    }

    public TopContainer getTopContainer() {
        Dbg.wassert(this._providerContainer != null, "TopContainer has not been instanciated.");
        return this._providerContainer;
    }

    public void refreshAll() {
        this.getTopContainer().refresh();
    }

    public void refreshDomain(BaseItem baseItem) {
        BaseItem baseItem2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (baseItem2 = baseItem; baseItem2 != null; baseItem2 = baseItem2.getParent()) {
            arrayList.add(baseItem2.getKey());
        }
        if (arrayList.size() <= 1) {
            this.getTopContainer().refresh();
        } else {
            int n = arrayList.size() - 2;
            baseItem2 = this.getTopContainer().findItem((String)arrayList.get(n));
            if (baseItem2 == null) {
                this.getTopContainer().refresh();
            } else {
                baseItem2.refresh();
                Domain domain = this.getDomain(baseItem2.getName());
                if (domain != null) {
                    domain.refreshStatus();
                }
                baseItem2 = this.getTopContainer();
                BaseContainer baseContainer = null;
                while (n >= 0) {
                    baseContainer = (BaseContainer)baseItem2;
                    if ((baseItem2 = baseContainer.findItem((String)arrayList.get(n))) == null || !(baseItem2 instanceof SCContainer)) {
                        n = 0;
                    } else if (n == 0) {
                        baseContainer = (BaseContainer)baseItem2;
                    }
                    --n;
                }
                if (!baseContainer.isOpen()) {
                    baseContainer = baseContainer.getParent();
                }
                if (baseContainer != null) {
                    baseContainer.select();
                }
            }
        }
    }

    public Domain getDomain(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty DomainConnection name parameter.");
        Object v = this._domainList.get(string);
        return (Domain)v;
    }

    public void registerDomain(Domain domain) {
        Dbg.wassert(domain != null, "Null Domain parameter.");
        Dbg.trace(1, "Add Domain '" + domain.getName() + "'");
        if (this._domainList.get(domain.getName()) == null) {
            this._domainList.put(domain.getName(), domain);
        } else {
            Dbg.wassert(false, "Attempted to add a Domain that is already in the list.");
        }
    }

    public void unregisterDomain(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty Domain name parameter.");
        Dbg.trace(1, "Remove domain '" + string + "'");
        this._domainList.remove(string);
    }

    public List getAllServers() {
        ArrayList arrayList = new ArrayList();
        Collection collection = this._domainList.values();
        if (collection != null) {
            for (Domain domain : collection) {
                arrayList.addAll(domain.getServerKeys());
            }
        }
        return arrayList;
    }

    public SemanticFactory getSemanticFactory(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty connection name parameter.");
        Domain domain = this.getDomain(string);
        if (domain == null) {
            Dbg.wassert(false, "Attempted to create a SemanticFactory with a connection name ('" + string + "') that does not exist.");
            return null;
        }
        if (domain.isEnvironment()) {
            return new EnvSemanticFactory((EnvDomain)domain);
        }
        if (domain.isRMS()) {
            return new RMSSemanticFactory((RMSDomain)domain);
        }
        Dbg.wassert(false, "Invalid object instance for connection '" + string + "'.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBkgndThread(BkgndThread bkgndThread) {
        Dbg.wassert(bkgndThread != null, "Null background thread parameter.");
        ArrayList arrayList = this._bkgndThreads;
        synchronized (arrayList) {
            Dbg.wassert(!this._bkgndThreads.contains(bkgndThread), "Background thread has already been registered with the provider.");
            this._bkgndThreads.add(bkgndThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBkgndThread(BkgndThread bkgndThread) {
        Dbg.wassert(bkgndThread != null, "Null background thread parameter.");
        ArrayList arrayList = this._bkgndThreads;
        synchronized (arrayList) {
            this._bkgndThreads.remove(bkgndThread);
        }
    }

    public List getBkgndThreads() {
        return this._bkgndThreads;
    }

    protected boolean isOKToCancelThreads() {
        boolean bl = true;
        if (this._bkgndThreads.size() > 0) {
            bl = PluginSupport.askQuestion(BundleManager.getString("RSMProviderRes", "SHUTDOWN_PROCESS_MSG"));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelAllThreads() {
        Dbg.trace(1, "Close all background threads.");
        this.getViewerSupport().startWait();
        ArrayList arrayList = this._bkgndThreads;
        synchronized (arrayList) {
            ListIterator listIterator = this._bkgndThreads.listIterator();
            while (listIterator.hasNext()) {
                BkgndThread bkgndThread = (BkgndThread)listIterator.next();
                bkgndThread.interrupt();
            }
        }
        try {
            for (int i = 0; i < 10 && this._bkgndThreads.size() > 0; ++i) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getViewerSupport().endWait();
    }

    protected JMenu[] getSearchMenu() {
        JMenu[] jMenuArray = new JMenu[1];
        JMenu jMenu = new JMenu(BundleManager.getString("RSMProviderRes", "MENU_TEXT_SEARCH"));
        jMenu.setMnemonic(BundleManager.getMnemonic("RSMProviderRes", "MENU_MNEM_SEARCH"));
        JMenuItem jMenuItem = new JMenuItem(new BkgndThreadAction());
        jMenu.add(jMenuItem);
        jMenuArray[0] = jMenu;
        return jMenuArray;
    }

    public class BkgndThreadAction
    extends AbstractAction {
        public BkgndThreadAction() {
            this.putValue("Name", BundleManager.getString("RSMProviderRes", "MENU_TEXT_PROCESSES"));
            this.putValue("SmallIcon", new ImageIcon(RSMImages.getBkgndThread()));
            this.putValue("MnemonicKey", new Integer(BundleManager.getMnemonic("RSMProviderRes", "MENU_MNEM_PROCESSES")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseController baseController = PluginSupport.getDialog(BkgndThreadListDlg.class);
            if (baseController != null) {
                baseController.requestFocus();
            } else {
                BkgndThreadListDlg bkgndThreadListDlg = new BkgndThreadListDlg(PluginSupport.getDialogSupport(PluginSupport.getViewerFrame()), RSMProvider.this.getBkgndThreads());
                bkgndThreadListDlg.showDialog();
            }
        }
    }

    public class FilterAction
    extends AbstractAction {
        public FilterAction() {
            this.putValue("Name", BundleManager.getString("RSMProviderRes", "MENU_TEXT_FILTER"));
            this.putValue("SmallIcon", new ImageIcon(RSMImages.getBlank()));
            this.putValue("MnemonicKey", new Integer(BundleManager.getMnemonic("RSMProviderRes", "MENU_MNEM_FILTER")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Dbg.trace(1, "Filter menu item selected");
        }
    }

    public class FindNextAction
    extends AbstractAction {
        public FindNextAction() {
            this.putValue("Name", BundleManager.getString("RSMProviderRes", "MENU_TEXT_FIND_NEXT"));
            this.putValue("SmallIcon", new ImageIcon(RSMImages.getFindNext()));
            this.putValue("MnemonicKey", new Integer(BundleManager.getMnemonic("RSMProviderRes", "MENU_MNEM_FIND_NEXT")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F3"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Dbg.trace(1, "Find Next menu item selected");
        }
    }

    public class FindAction
    extends AbstractAction {
        public FindAction() {
            this.putValue("Name", BundleManager.getString("RSMProviderRes", "MENU_TEXT_FIND"));
            this.putValue("SmallIcon", new ImageIcon(RSMImages.getFind()));
            this.putValue("MnemonicKey", new Integer(BundleManager.getMnemonic("RSMProviderRes", "MENU_MNEM_FIND")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl F"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Dbg.trace(1, "Find menu item selected");
        }
    }
}

