/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.bkgnd;

import com.sybase.central.viewer.SCImageLoader;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.bkgnd.BkgndThreadSummaryDlg;
import com.sybase.rsmplugin.util.Dbg;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public abstract class BkgndSummaryThread
extends BkgndThread {
    public static final int INFO_MESSAGE = 0;
    public static final int WARNING_MESSAGE = 1;
    public static final int ERROR_MESSAGE = 2;
    private String _desc = null;
    private ImageIcon _infoIcon;
    private ImageIcon _warnIcon;
    private ImageIcon _errorIcon;
    private BkgndThreadSummaryDlg _summaryDlg = null;

    public BkgndSummaryThread(String string, String string2, String string3, boolean bl) {
        super(string, string3, bl);
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty description parameter.");
        this._desc = string2;
        Image image = SCImageLoader.getImage((String)"inform32", (int)1006);
        if (image != null) {
            this._infoIcon = new ImageIcon(image.getScaledInstance(16, 16, 4));
        }
        if ((image = SCImageLoader.getImage((String)"warn32", (int)1006)) != null) {
            this._warnIcon = new ImageIcon(image.getScaledInstance(16, 16, 4));
        }
        if ((image = SCImageLoader.getImage((String)"error32", (int)1006)) != null) {
            this._errorIcon = new ImageIcon(image.getScaledInstance(16, 16, 4));
        }
    }

    public String getDescription() {
        return this._desc;
    }

    public synchronized void setStatus(int n, String string) {
        switch (n) {
            case 0: {
                this.setStatus(this._infoIcon, string);
                break;
            }
            case 1: {
                this.setStatus(this._warnIcon, string);
                break;
            }
            case 2: {
                this.setStatus(this._errorIcon, string);
                break;
            }
            default: {
                this.setStatus(string);
            }
        }
    }

    @Override
    public synchronized void setStatus(final String string) {
        Dbg.wassert(string != null, "Null status message parameter.");
        super.setStatus(string);
        if (this._summaryDlg != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BkgndSummaryThread.this._summaryDlg.addEntry(string);
                }
            });
        }
    }

    public synchronized void setStatus(final Icon icon, final String string) {
        Dbg.wassert(string != null, "Null status message parameter.");
        super.setStatus(string);
        if (this._summaryDlg != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BkgndSummaryThread.this._summaryDlg.addEntry(icon, string);
                }
            });
        }
    }

    @Override
    protected void displayMessageDialog() {
        this._summaryDlg = new BkgndThreadSummaryDlg(PluginSupport.getDialogSupport(PluginSupport.getViewerFrame()), this);
        this._summaryDlg.showDialog();
    }

    @Override
    public synchronized void messageDialogClosed() {
        this._summaryDlg = null;
    }

    @Override
    protected synchronized void close() {
        PluginSupport.unregisterBkgndThread(this);
        if (this.isInterrupted()) {
            Dbg.trace(4096, "Background summary thread '" + this.getName() + "' was canceled.");
            String string = BundleManager.getString("BkgndThreadRes", "STATE_CANCELED");
            Image image = RSMImages.getBkgndThreadCanceled();
            this.writeEvent(string, image);
            this.setStatus(1, string);
        } else if (this.errorOccurred()) {
            Dbg.trace(4096, "Background summary thread '" + this.getName() + "' completed, but an error occurred.");
            String string = BundleManager.getString("BkgndThreadRes", "STATE_ERROR");
            Image image = RSMImages.getBkgndThreadError();
            this.writeEvent(string, image);
        } else {
            Dbg.trace(4096, "Background summary thread '" + this.getName() + "' completed.");
            if (this.displayCompletionEvent()) {
                this.writeEvent(BundleManager.getString("BkgndThreadRes", "STATE_COMPLETED"), RSMImages.getBkgndThread());
            }
        }
    }
}

