/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.bkgnd;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.bkgnd.BkgndThreadMsgDlg;
import com.sybase.rsmplugin.util.Dbg;
import java.awt.Image;
import java.util.Date;
import javax.swing.SwingUtilities;

public abstract class BkgndThread
extends Thread {
    private String _domain = null;
    private String _status = null;
    private boolean _error = false;
    private Date _startDate = null;
    private BkgndThreadMsgDlg _msgDlg = null;
    private boolean _completionEvent = true;

    public BkgndThread(String string, String string2, boolean bl) {
        this(string, string2);
        this._completionEvent = bl;
    }

    public BkgndThread(String string, String string2) {
        super(string);
        this.setDaemon(true);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty thread name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty domain name parameter.");
        this._domain = string2;
    }

    @Override
    public abstract void run();

    public synchronized String getStatus() {
        return this._status == null ? "" : this._status;
    }

    public synchronized void setStatus(String string) {
        Dbg.wassert(string != null, "Null status message parameter.");
        this._status = string;
    }

    public boolean displayCompletionEvent() {
        return this._completionEvent;
    }

    public synchronized void setError(boolean bl) {
        this._error = bl;
    }

    public synchronized boolean errorOccurred() {
        return this._error;
    }

    public synchronized String getDomainName() {
        return this._domain;
    }

    public synchronized Date getStartDate() {
        return this._startDate;
    }

    public synchronized void setStartDate() {
        this._startDate = new Date();
    }

    @Override
    public void start() {
        PluginSupport.registerBkgndThread(this);
        this.displayMessageDialog();
        this.setStartDate();
        Dbg.trace(4096, "Starting background thread '" + this.getName() + "' at: " + this.getStartDate().toString());
        super.start();
    }

    protected void displayMessageDialog() {
        this._msgDlg = new BkgndThreadMsgDlg(PluginSupport.getDialogSupport(PluginSupport.getViewerFrame()), this);
        this._msgDlg.showDialog();
    }

    public synchronized void messageDialogClosed() {
        this._msgDlg = null;
    }

    protected synchronized void close() {
        PluginSupport.unregisterBkgndThread(this);
        if (this._msgDlg != null) {
            Dbg.trace(4096, "Closing the message dialog for thread '" + this.getName() + "'.");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BkgndThread.this._msgDlg.closeDialog();
                }
            });
        }
        if (this.isInterrupted()) {
            Dbg.trace(4096, "Background thread '" + this.getName() + "' was canceled.");
            this.writeEvent(BundleManager.getString("BkgndThreadRes", "STATE_CANCELED"), RSMImages.getBkgndThreadCanceled());
        } else if (this.errorOccurred()) {
            Dbg.trace(4096, "Background thread '" + this.getName() + "' completed, but an error occurred.");
            this.writeEvent(BundleManager.getString("BkgndThreadRes", "STATE_ERROR"), RSMImages.getBkgndThreadError());
        } else {
            Dbg.trace(4096, "Background thread '" + this.getName() + "' completed.");
            if (this.displayCompletionEvent()) {
                this.writeEvent(BundleManager.getString("BkgndThreadRes", "STATE_COMPLETED"), RSMImages.getBkgndThread());
            }
        }
    }

    protected synchronized void writeEvent(final String string, final Image image) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginSupport.addEvent(image, BkgndThread.this.getName(), string, BkgndThread.this.getDomainName(), BkgndThread.this.getStatus());
            }
        });
    }
}

