/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.bkgnd;

import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.bkgnd.BkgndThreadListPanel;
import com.sybase.rsmplugin.components.BaseDialog;
import com.sybase.rsmplugin.components.BasePage;
import com.sybase.rsmplugin.util.DateCellRenderer;
import com.sybase.rsmplugin.util.Dbg;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class BkgndThreadListDlg
extends BaseDialog {
    private static final String COLUMN_WIDTH_PROFILE_KEY = "BkgndProcessColumnWidth";
    protected SCPageController[] _page = null;
    protected List _threads;

    public BkgndThreadListDlg(SCDialogSupport2 sCDialogSupport2, List list) {
        super(sCDialogSupport2);
        Dbg.wassert(sCDialogSupport2 != null, "Null dialog support parameter.");
        Dbg.wassert(list != null, "Null background thread List parameter.");
        this._threads = list;
    }

    public List getThreads() {
        return this._threads;
    }

    @Override
    public void showDialog() {
        this.getDialogSupport().setDialogController((SCDialogController)this);
        this.getDialogSupport().setTitle(this.getTitle());
        this.getDialogSupport().setResizable(true);
        this.getDialogSupport().setStandardButtons(false);
        this.getDialogSupport().setModal(false);
        this.getDialogSupport().setHelpButton(false);
        PluginSupport.registerDialog(this);
        this.getDialogSupport().render();
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("BkgndThreadRes", "PROCESS_LIST_TITLE");
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._page == null) {
            this._page = new SCPageController[]{new BkgndThreadListPage()};
        }
        return this._page;
    }

    class BkgndThreadListPage
    extends BasePage
    implements ActionListener,
    ListSelectionListener {
        private BkgndThreadListPanel _goPage = new BkgndThreadListPanel();
        private int _frameIdx = 0;

        public BkgndThreadListPage() {
            this._goPage.btn_close.addActionListener((ActionListener)this);
            this._goPage.btn_refresh.addActionListener((ActionListener)this);
            this._goPage.btn_cancel.addActionListener((ActionListener)this);
            this._goPage.tbl_threads.addListSelectionListener((ListSelectionListener)this);
            this._goPage.tbl_threads.getColumnModel().getColumn(1).setCellRenderer(new DateCellRenderer());
        }

        @Override
        public void onInitDialog() {
            this._goPage.getRootPane().setDefaultButton((JButton)this._goPage.btn_close);
            int[] nArray = PluginSupport.readProfileIntArray(BkgndThreadListDlg.COLUMN_WIDTH_PROFILE_KEY);
            if (nArray != null && nArray.length == 3) {
                this._goPage.tbl_threads.setColumnWidths(nArray);
            }
            this.loadThreads();
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            int n = 0;
            int[] nArray = new int[this._goPage.tbl_threads.getColumnCount()];
            Enumeration<TableColumn> enumeration = this._goPage.tbl_threads.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                nArray[n++] = tableColumn.getPreferredWidth();
            }
            PluginSupport.writeProfileIntArray(BkgndThreadListDlg.COLUMN_WIDTH_PROFILE_KEY, nArray);
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void loadThreads() {
            this._goPage.tbl_threads.clear();
            List list = BkgndThreadListDlg.this.getThreads();
            synchronized (list) {
                ListIterator listIterator = BkgndThreadListDlg.this.getThreads().listIterator();
                while (listIterator.hasNext()) {
                    BkgndThread bkgndThread = (BkgndThread)listIterator.next();
                    Object[] objectArray = new Object[]{bkgndThread.getName(), bkgndThread.getStartDate(), bkgndThread.getStatus()};
                    this._goPage.tbl_threads.addRow(objectArray);
                }
            }
            if (this._goPage.tbl_threads.getSelectedRowCount() > 0) {
                this._goPage.tbl_threads.selectRow(0);
                this._goPage.btn_cancel.setEnabled(true);
            } else {
                this._goPage.btn_cancel.setEnabled(false);
            }
            this._goPage.tbl_threads.requestFocus();
        }

        protected void stopProcesses() {
            int n;
            BkgndThreadListDlg.this.getDialogSupport().startWait();
            boolean bl = false;
            int[] nArray = this._goPage.tbl_threads.getSelectedRows();
            for (n = 0; n < nArray.length; ++n) {
                Object[] objectArray = this._goPage.tbl_threads.getRowAsArray(nArray[n]);
                Dbg.trace((String)objectArray[0]);
                BkgndThread bkgndThread = this.findThread((String)this._goPage.tbl_threads.getValueAt(nArray[n], 0), (Date)this._goPage.tbl_threads.getValueAt(nArray[n], 1));
                if (bkgndThread == null || !bkgndThread.isAlive()) continue;
                bkgndThread.interrupt();
                bl = true;
            }
            if (bl) {
                try {
                    for (n = 0; n < 10; ++n) {
                        Thread.sleep(200L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.loadThreads();
            BkgndThreadListDlg.this.getDialogSupport().endWait();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected BkgndThread findThread(String string, Date date) {
            List list = BkgndThreadListDlg.this.getThreads();
            synchronized (list) {
                ListIterator listIterator = BkgndThreadListDlg.this.getThreads().listIterator();
                while (listIterator.hasNext()) {
                    BkgndThread bkgndThread = (BkgndThread)listIterator.next();
                    if (!bkgndThread.getName().equals(string) || !bkgndThread.getStartDate().equals(date)) continue;
                    return bkgndThread;
                }
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_cancel) {
                this.stopProcesses();
            } else if (actionEvent.getSource() == this._goPage.btn_refresh) {
                this.loadThreads();
            } else if (actionEvent.getSource() == this._goPage.btn_close) {
                BkgndThreadListDlg.this.closeDialog();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this._goPage.btn_cancel.setEnabled(this._goPage.tbl_threads.getSelectedRowCount() > 0);
            }
        }
    }
}

