/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.bkgnd;

import com.sybase.asa.ASAIconTextUserData;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.central.viewer.SCImageLoader;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.bkgnd.BkgndSummaryThread;
import com.sybase.rsmplugin.bkgnd.BkgndThreadSummaryPanel;
import com.sybase.rsmplugin.components.BasePage;
import com.sybase.rsmplugin.util.Dbg;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;

public class BkgndThreadSummaryDlg
implements SCDialogController {
    protected SCDialogSupport2 _support;
    protected SCPageController[] _page = null;
    protected BkgndSummaryThread _thrd;
    protected Timer _timer = null;
    protected static ImageIcon[] _frames = new ImageIcon[]{new ImageIcon(RSMImages.getBkgndThreadLarge1()), new ImageIcon(RSMImages.getBkgndThreadLarge2()), new ImageIcon(RSMImages.getBkgndThreadLarge3()), new ImageIcon(RSMImages.getBkgndThreadLarge4()), new ImageIcon(RSMImages.getBkgndThreadLarge5()), new ImageIcon(RSMImages.getBkgndThreadLarge6()), new ImageIcon(RSMImages.getBkgndThreadLarge7()), new ImageIcon(RSMImages.getBkgndThreadLarge8())};
    ImageIcon _infoIcon;
    ImageIcon _warnIcon;
    ImageIcon _errorIcon;

    public BkgndThreadSummaryDlg(SCDialogSupport2 sCDialogSupport2, BkgndSummaryThread bkgndSummaryThread) {
        Dbg.wassert(sCDialogSupport2 != null, "Null dialog support parameter.");
        Dbg.wassert(bkgndSummaryThread != null, "Null background thread parameter.");
        this._support = sCDialogSupport2;
        this._thrd = bkgndSummaryThread;
        Image image = SCImageLoader.getImage((String)"inform32", (int)1006);
        if (image != null) {
            this._infoIcon = new ImageIcon(image.getScaledInstance(16, 16, 4));
        }
        if ((image = SCImageLoader.getImage((String)"warn32", (int)1006)) != null) {
            this._warnIcon = new ImageIcon(image.getScaledInstance(16, 16, 4));
        }
        if ((image = SCImageLoader.getImage((String)"error32", (int)1006)) != null) {
            this._errorIcon = new ImageIcon(image.getScaledInstance(16, 16, 4));
        }
    }

    public SCDialogSupport2 getDialogSupport() {
        return this._support;
    }

    public void showDialog() {
        this.getDialogSupport().setDialogController((SCDialogController)this);
        this.getDialogSupport().setTitle(this.getTitle());
        this.getDialogSupport().setResizable(true);
        this.getDialogSupport().setStandardButtons(false);
        this.getDialogSupport().setModal(false);
        this.getDialogSupport().setHelpButton(false);
        this.getDialogSupport().render();
    }

    public String getTitle() {
        return this._thrd.getName() + " - [" + this._thrd.getDomainName() + "]";
    }

    public int getDialogType() {
        return 0;
    }

    public final int getInitialPageNumber() {
        return 0;
    }

    public void onApply() {
    }

    public boolean onCancel() {
        this.closeDialog();
        return false;
    }

    public boolean onOk() {
        this.closeDialog();
        return false;
    }

    public void closeDialog() {
        this.stopTimer();
        this.getDialogSupport().closeDialog(false);
        this.releaseResources();
        this._thrd.messageDialogClosed();
    }

    protected void stopTimer() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    public boolean onWizardFinish() {
        return true;
    }

    public void releaseResources() {
        SCPageController[] sCPageControllerArray = this.getPageControllers();
        for (int i = 0; i < sCPageControllerArray.length; ++i) {
            sCPageControllerArray[i].releaseResources();
        }
        this._support = null;
    }

    public SCPageController[] getPageControllers() {
        if (this._page == null) {
            this._page = new SCPageController[]{new BkgndThreadSummaryPage()};
        }
        return this._page;
    }

    private BkgndThreadSummaryPage getSummaryPage() {
        SCPageController[] sCPageControllerArray = this.getPageControllers();
        Dbg.wassert(sCPageControllerArray.length == 1, "Invalid page list, only one page should be loaded.");
        return (BkgndThreadSummaryPage)sCPageControllerArray[0];
    }

    public void addEntry(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty text parameter.");
        if (string.startsWith("E. ")) {
            string = string.substring("E. ".length());
            this.getSummaryPage().addEntry(this._errorIcon, string);
        } else if (string.startsWith("W. ")) {
            string = string.substring("W. ".length());
            this.getSummaryPage().addEntry(this._warnIcon, string);
        } else if (string.startsWith("I. ")) {
            string = string.substring("I. ".length());
            this.getSummaryPage().addEntry(this._infoIcon, string);
        } else {
            this.getSummaryPage().addEntry(this._infoIcon, string);
        }
    }

    public void addEntry(Icon icon, String string) {
        Dbg.wassert(icon != null, "Null icon parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty text parameter.");
        this.getSummaryPage().addEntry(icon, string);
    }

    class BkgndThreadSummaryPage
    extends BasePage
    implements ActionListener {
        private BkgndThreadSummaryPanel _goPage = new BkgndThreadSummaryPanel();
        private int _frameIdx = 0;

        public BkgndThreadSummaryPage() {
            this._goPage.btn_close.addActionListener((ActionListener)this);
            this._goPage.btn_cancel.addActionListener((ActionListener)this);
        }

        @Override
        public void onInitDialog() {
            this._goPage.getRootPane().setDefaultButton((JButton)this._goPage.btn_close);
            this._goPage.lbl_desc.setText(BkgndThreadSummaryDlg.this._thrd.getDescription());
            this._frameIdx = 0;
            BkgndThreadSummaryDlg.this._timer = new Timer(500, this);
            BkgndThreadSummaryDlg.this._timer.start();
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        public void addEntry(Icon icon, String string) {
            Dbg.wassert(icon != null, "Null icon parameter.");
            Dbg.wassert(string != null && string.length() > 0, "Null or empty text parameter.");
            ASAIconTextUserData aSAIconTextUserData = new ASAIconTextUserData(icon, string);
            this._goPage.lst_items.addItem((Object)aSAIconTextUserData);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_cancel) {
                BkgndThreadSummaryDlg.this.closeDialog();
                BkgndThreadSummaryDlg.this._thrd.interrupt();
            } else if (actionEvent.getSource() == this._goPage.btn_close) {
                BkgndThreadSummaryDlg.this.closeDialog();
            } else if (actionEvent.getSource() == BkgndThreadSummaryDlg.this._timer) {
                if (!BkgndThreadSummaryDlg.this._thrd.isAlive()) {
                    BkgndThreadSummaryDlg.this.stopTimer();
                    this._goPage.btn_cancel.setEnabled(false);
                }
                ++this._frameIdx;
                if (this._frameIdx == _frames.length) {
                    this._frameIdx = 0;
                }
                this._goPage.lbl_image.setIcon((Icon)_frames[this._frameIdx]);
            }
        }
    }
}

