/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components;

import com.sybase.central.SCContainerEvent;
import com.sybase.central.SCContainerListener;
import com.sybase.central.SCHeader;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCToolBarButton;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.util.Dbg;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;

public abstract class BaseContainer
extends BaseItem {
    public static final String COLUMN_WIDTH_KEY = "ColumnWidths";
    public static final String VISIBLE_COLUMN_KEY = "VisibleColumns";
    protected boolean _isOpened = false;
    protected Vector _itemList = null;
    protected Vector _containerListeners = null;
    protected int[] _columnWidths = null;
    protected int[] _visibleColumns = null;

    public BaseContainer() {
    }

    public BaseContainer(BaseContainer baseContainer) {
        super(baseContainer);
    }

    public Vector getItemList() {
        if (this._itemList == null) {
            this._itemList = new Vector();
        }
        return this._itemList;
    }

    public void addItem(SCItem sCItem) {
        Dbg.wassert(sCItem != null, "Null item parameter.");
        if (this._itemList == null) {
            this._itemList = new Vector();
        }
        this._itemList.add(sCItem);
    }

    public void removeItem(SCItem sCItem) {
        Dbg.wassert(sCItem != null, "Null item parameter.");
        if (this._itemList != null) {
            this._itemList.removeElement(sCItem);
            this.notifyChangeListeners(2, sCItem);
        }
    }

    public BaseItem findItem(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or emtpy item key name parameter.");
        Enumeration enumeration = this._itemList.elements();
        while (enumeration.hasMoreElements()) {
            BaseItem baseItem = (BaseItem)enumeration.nextElement();
            if (!baseItem.getKey().equals(string)) continue;
            return baseItem;
        }
        return null;
    }

    public void notifyChangeListeners(int n, SCItem sCItem) {
        if (this._containerListeners != null) {
            for (int i = 0; i < this._containerListeners.size(); ++i) {
                ((SCContainerListener)this._containerListeners.elementAt(i)).containerChanged(new SCContainerEvent((Object)this, n, sCItem));
            }
        }
    }

    @Override
    public void refresh() {
        if (this.getParent() != null) {
            this.getParent().notifyChangeListeners(3, (SCItem)this);
        } else {
            this.notifyChangeListeners(3, (SCItem)this);
        }
    }

    @Override
    public void redisplay() {
        if (this.getParent() != null) {
            this.getParent().notifyChangeListeners(6, (SCItem)this);
        } else {
            this.notifyChangeListeners(6, (SCItem)this);
        }
    }

    @Override
    public void delete() {
        if (this.getParent() != null) {
            this.getParent().notifyChangeListeners(2, (SCItem)this);
            this.getParent().removeItem((SCItem)this);
        } else {
            this.notifyChangeListeners(2, (SCItem)this);
        }
    }

    public void select() {
        this.notifyChangeListeners(7, (SCItem)this);
    }

    public void collapse() {
        this.notifyChangeListeners(5, (SCItem)this);
    }

    protected abstract String[] getHeadings();

    public void columnWidthsChanged(int[] nArray) {
        PluginSupport.writeProfileIntArray(this.getColumnWidthKey(), nArray);
        this._columnWidths = nArray;
    }

    public SCHeader[] getHeadingInfo() {
        String[] stringArray = this.getHeadings();
        Dbg.wassert(stringArray != null, "Null heading string array passed by subclass.");
        if (this._columnWidths == null) {
            this._columnWidths = this.readColumnWidths();
        }
        SCHeader[] sCHeaderArray = new SCHeader[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = i < this._columnWidths.length ? this._columnWidths[i] : (i == stringArray.length - 1 ? 200 : 100);
            sCHeaderArray[i] = new SCHeader(stringArray[i], i, n);
        }
        return sCHeaderArray;
    }

    protected int[] readColumnWidths() {
        int[] nArray = PluginSupport.readProfileIntArray(this.getColumnWidthKey());
        if (nArray == null) {
            nArray = new int[]{};
        }
        return nArray;
    }

    protected String getColumnWidthKey() {
        return this.getId() + "." + COLUMN_WIDTH_KEY;
    }

    public int[] getVisibleColumns() {
        String[] stringArray;
        if (this._visibleColumns == null) {
            this._visibleColumns = this.readVisibleColumns();
        }
        if (this._visibleColumns.length > (stringArray = this.getHeadings()).length) {
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = this._visibleColumns[i];
            }
            this.setVisibleColumns(nArray);
        }
        return this._visibleColumns;
    }

    public void setVisibleColumns(int[] nArray) {
        PluginSupport.writeProfileIntArray(this.getVisibleColumnKey(), nArray);
        this._visibleColumns = nArray;
    }

    protected int[] readVisibleColumns() {
        int[] nArray = PluginSupport.readProfileIntArray(this.getVisibleColumnKey());
        if (nArray == null) {
            nArray = this.getDefaultVisibleColumns();
        }
        return nArray;
    }

    protected String getVisibleColumnKey() {
        return this.getId() + "." + VISIBLE_COLUMN_KEY;
    }

    protected int[] getDefaultVisibleColumns() {
        String[] stringArray = this.getHeadings();
        Dbg.wassert(stringArray != null, "Null heading string array passed by subclass.");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    public void addContainerListener(SCContainerListener sCContainerListener) {
        if (this._containerListeners == null) {
            this._containerListeners = new Vector();
        }
        this._containerListeners.addElement(sCContainerListener);
    }

    public boolean isOpen() {
        return this._isOpened;
    }

    public void close() {
        if (this._itemList != null) {
            Enumeration enumeration = this._itemList.elements();
            while (enumeration.hasMoreElements()) {
                SCItem sCItem = (SCItem)enumeration.nextElement();
                sCItem.releaseResources();
            }
            this._itemList.removeAllElements();
            this._isOpened = false;
        }
    }

    public Object[] getDetailsPanels() {
        return null;
    }

    public SCMenu getCreationMenu() {
        return null;
    }

    public Enumeration getItems() {
        if (this._itemList == null) {
            this._itemList = new Vector();
        }
        return this._itemList.elements();
    }

    public boolean onNotify(JFrame jFrame, int n, int n2) {
        return true;
    }

    public void open(int n) {
        this._isOpened = true;
    }

    public void removeContainerListener(SCContainerListener sCContainerListener) {
        if (this._containerListeners != null) {
            this._containerListeners.removeElement(sCContainerListener);
        }
    }

    public Object[] getDetailsPanels(JFrame jFrame) {
        return null;
    }

    public SCToolBarButton[] getCreationToolBarButtons() {
        return null;
    }

    public SCMenu[] getContextMenuBarMenus() {
        return null;
    }

    public SCToolBarButton[] getContextToolBarButtons() {
        return null;
    }

    public int getSortedColumn() {
        return 0;
    }
}

