/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components;

import com.sybase.central.SCContainerEvent;
import com.sybase.central.SCContainerListener;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCHeader;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCToolBarButton;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.util.Dbg;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;

public abstract class BaseDetailContainer
implements SCDetailsContainer {
    protected Vector _itemList = null;
    protected Vector _containerListeners = null;
    protected int[] _columnWidths = null;
    protected int[] _visibleColumns = null;
    protected String _name = null;

    public BaseDetailContainer(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        this._name = string;
    }

    public String getId() {
        return "com.sybase.rsmplugin.components." + this.getPkgAndClass();
    }

    public abstract String getPkgAndClass();

    public Vector getItemList() {
        if (this._itemList == null) {
            this._itemList = new Vector();
        }
        return this._itemList;
    }

    public void addItem(SCItem sCItem) {
        Dbg.wassert(sCItem != null, "Null item parameter.");
        if (this._itemList == null) {
            this._itemList = new Vector();
        }
        this._itemList.add(sCItem);
    }

    public void removeItem(SCItem sCItem) {
        Dbg.wassert(sCItem != null, "Null item parameter.");
        if (this._itemList != null) {
            this._itemList.removeElement(sCItem);
            this.notifyChangeListeners(2, sCItem);
        }
    }

    public BaseItem findItem(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or emtpy item name parameter.");
        Enumeration enumeration = this._itemList.elements();
        while (enumeration.hasMoreElements()) {
            BaseItem baseItem = (BaseItem)enumeration.nextElement();
            if (!baseItem.getName().equals(string)) continue;
            return baseItem;
        }
        return null;
    }

    public void notifyChangeListeners(int n, SCItem sCItem) {
        if (this._containerListeners != null) {
            for (int i = 0; i < this._containerListeners.size(); ++i) {
                ((SCContainerListener)this._containerListeners.elementAt(i)).containerChanged(new SCContainerEvent((Object)this, n, sCItem));
            }
        }
    }

    public void refresh() {
        this.notifyChangeListeners(3, (SCItem)this);
    }

    public void redisplay() {
        this.notifyChangeListeners(6, (SCItem)this);
    }

    public void select() {
        this.notifyChangeListeners(7, (SCItem)this);
    }

    public void collapse() {
        this.notifyChangeListeners(5, (SCItem)this);
    }

    protected abstract String[] getHeadings();

    protected int[] readColumnWidths() {
        int[] nArray = PluginSupport.readProfileIntArray(this.getColumnWidthKey());
        if (nArray == null) {
            nArray = new int[]{};
        }
        return nArray;
    }

    protected String getColumnWidthKey() {
        return this.getId() + "." + "ColumnWidths";
    }

    protected int[] readVisibleColumns() {
        int[] nArray = PluginSupport.readProfileIntArray(this.getVisibleColumnKey());
        if (nArray == null) {
            nArray = this.getDefaultVisibleColumns();
        }
        return nArray;
    }

    protected String getVisibleColumnKey() {
        return this.getId() + "." + "VisibleColumns";
    }

    protected int[] getDefaultVisibleColumns() {
        String[] stringArray = this.getHeadings();
        Dbg.wassert(stringArray != null, "Null heading string array passed by subclass.");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    public void addContainerListener(SCContainerListener sCContainerListener) {
        if (this._containerListeners == null) {
            this._containerListeners = new Vector();
        }
        this._containerListeners.addElement(sCContainerListener);
    }

    public void close() {
        if (this._itemList != null) {
            Enumeration enumeration = this._itemList.elements();
            while (enumeration.hasMoreElements()) {
                SCItem sCItem = (SCItem)enumeration.nextElement();
                sCItem.releaseResources();
            }
            this._itemList.removeAllElements();
        }
    }

    public void columnWidthsChanged(int[] nArray) {
        PluginSupport.writeProfileIntArray(this.getColumnWidthKey(), nArray);
        this._columnWidths = nArray;
    }

    public SCMenu getContextMenu() {
        return null;
    }

    public SCMenu[] getContextMenuBarMenus() {
        return null;
    }

    public SCToolBarButton[] getContextToolBarButtons() {
        return null;
    }

    public SCMenu getCreationMenu() {
        return null;
    }

    public SCToolBarButton[] getCreationToolBarButtons() {
        return null;
    }

    public String getDisplayName() {
        return this._name;
    }

    public int[] getEnabledContextCmdIds() {
        return null;
    }

    public SCHeader[] getHeadingInfo() {
        String[] stringArray = this.getHeadings();
        Dbg.wassert(stringArray != null, "Null heading string array passed by subclass.");
        if (this._columnWidths == null) {
            this._columnWidths = this.readColumnWidths();
        }
        SCHeader[] sCHeaderArray = new SCHeader[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = i < this._columnWidths.length ? this._columnWidths[i] : (i == stringArray.length - 1 ? 200 : 100);
            sCHeaderArray[i] = new SCHeader(stringArray[i], i, n);
        }
        return sCHeaderArray;
    }

    public Enumeration getItems() {
        if (this._itemList == null) {
            this._itemList = new Vector();
        }
        return this._itemList.elements();
    }

    public int getSortedColumn() {
        return 0;
    }

    public int[] getVisibleColumns() {
        String[] stringArray;
        if (this._visibleColumns == null) {
            this._visibleColumns = this.readVisibleColumns();
        }
        if (this._visibleColumns.length > (stringArray = this.getHeadings()).length) {
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = this._visibleColumns[i];
            }
            this.setVisibleColumns(nArray);
        }
        return this._visibleColumns;
    }

    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
    }

    public boolean onNotify(JFrame jFrame, int n, int n2) {
        return true;
    }

    public void open(int n) {
    }

    public void removeContainerListener(SCContainerListener sCContainerListener) {
        if (this._containerListeners != null) {
            this._containerListeners.removeElement(sCContainerListener);
        }
    }

    public void setVisibleColumns(int[] nArray) {
        PluginSupport.writeProfileIntArray(this.getVisibleColumnKey(), nArray);
        this._visibleColumns = nArray;
    }
}

