/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components;

import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCItem2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.util.Dbg;
import java.awt.Container;

public abstract class BaseDialog
extends BaseController {
    private boolean _isModeless = true;

    public BaseDialog(SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(sCDialogSupport2 != null, "Null SCDialogSupport parameter.");
    }

    public boolean showModalDialog() {
        this._isModeless = false;
        this.getDialogSupport().setDialogController((SCDialogController)this);
        this.getDialogSupport().setTitle(this.getTitle());
        this.getDialogSupport().setResizable(true);
        this.getDialogSupport().setStandardButtons(true);
        this.getDialogSupport().setModal(true);
        this.getDialogSupport().setHelpButton(false);
        return this.getDialogSupport().render();
    }

    @Override
    public boolean isModified() {
        boolean bl = false;
        SCPageController[] sCPageControllerArray = this.getPageControllers();
        Dbg.wassert(sCPageControllerArray != null);
        for (int i = 0; i < sCPageControllerArray.length && !bl; ++i) {
            bl = sCPageControllerArray[i].isModified();
        }
        return bl;
    }

    @Override
    public boolean isOkToClose() {
        boolean bl = true;
        if (this.isModified()) {
            this.requestFocus();
            String string = BundleManager.getString("ComponentRes", "MSG_DIALOG_MODIFIED", this.getTitle());
            int n = PluginSupport.getViewerSupport().messageBoxString((Container)this.getJDialog(), string, 1, 2);
            if (n == 0) {
                this.onApply();
            } else if (n == 2) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public abstract String getTitle();

    @Override
    public abstract SCPageController[] getPageControllers();

    @Override
    public int getDialogType() {
        return 0;
    }

    @Override
    public boolean onCancel() {
        if (this._isModeless) {
            return super.onCancel();
        }
        this.releaseResources();
        return true;
    }

    @Override
    public boolean onOk() {
        if (this._isModeless) {
            return super.onOk();
        }
        this.releaseResources();
        return true;
    }

    @Override
    public SCItem2 getSCItem2() {
        return null;
    }
}

