/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components;

import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.util.Dbg;
import javax.swing.JDialog;

public abstract class BaseModalDialog
implements SCDialogController {
    private SCDialogSupport2 _dlgSupport = null;

    public BaseModalDialog(SCDialogSupport2 sCDialogSupport2) {
        Dbg.wassert(sCDialogSupport2 != null, "Null SCDialogSupport parameter.");
        this._dlgSupport = sCDialogSupport2;
    }

    public boolean showDialog() {
        this.getDialogSupport().setDialogController((SCDialogController)this);
        this.getDialogSupport().setTitle(this.getTitle());
        this.getDialogSupport().setResizable(true);
        this.getDialogSupport().setStandardButtons(true);
        this.getDialogSupport().setModal(true);
        this.getDialogSupport().setHelpButton(false);
        return this.getDialogSupport().render();
    }

    public SCDialogSupport2 getDialogSupport() {
        return this._dlgSupport;
    }

    public final JDialog getJDialog() {
        return this.getDialogSupport().getJDialog();
    }

    public void requestFocus() {
        JDialog jDialog = this.getJDialog();
        if (jDialog != null) {
            jDialog.requestFocus();
        }
    }

    public abstract String getTitle();

    public boolean isModified() {
        boolean bl = false;
        SCPageController[] sCPageControllerArray = this.getPageControllers();
        Dbg.wassert(sCPageControllerArray != null);
        for (int i = 0; i < sCPageControllerArray.length && !bl; ++i) {
            bl = sCPageControllerArray[i].isModified();
        }
        return bl;
    }

    public abstract SCPageController[] getPageControllers();

    public int getDialogType() {
        return 0;
    }

    public final int getInitialPageNumber() {
        return 0;
    }

    public void onApply() {
    }

    public boolean onCancel() {
        this.releaseResources();
        return true;
    }

    public boolean onOk() {
        this.releaseResources();
        return true;
    }

    public boolean onWizardFinish() {
        this.releaseResources();
        return true;
    }

    public void releaseResources() {
        SCPageController[] sCPageControllerArray = this.getPageControllers();
        for (int i = 0; i < sCPageControllerArray.length; ++i) {
            sCPageControllerArray[i].releaseResources();
        }
        this._dlgSupport = null;
    }
}

