/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCItem2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.util.Dbg;
import java.awt.Container;

public abstract class BaseProperties
extends BaseController {
    public BaseProperties(SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(sCDialogSupport2 != null, "Null SCDialogSupport parameter.");
    }

    @Override
    public String getItemName() {
        if (this.getItem() != null) {
            return this.getItem().getName();
        }
        return null;
    }

    @Override
    public boolean isModified() {
        boolean bl = false;
        SCPageController[] sCPageControllerArray = this.getPageControllers();
        Dbg.wassert(sCPageControllerArray != null);
        for (int i = 0; i < sCPageControllerArray.length && !bl; ++i) {
            bl = sCPageControllerArray[i].isModified();
        }
        return bl;
    }

    public void setButtons() {
        this.getDialogSupport().setEnabledStandardButtons(this.getEnabledStandardButtons());
    }

    public int getEnabledStandardButtons() {
        int n = this.isModified() ? 15 : 11;
        return n;
    }

    protected void clearModifiedFlag() {
        SCPageController[] sCPageControllerArray = this.getPageControllers();
        for (int i = 0; i < sCPageControllerArray.length; ++i) {
            ((BasePropertyPage)sCPageControllerArray[i]).setModified(false);
        }
    }

    @Override
    public boolean isOkToClose() {
        boolean bl = true;
        if (this.isModified()) {
            this.requestFocus();
            String string = BundleManager.getString("ComponentRes", "MSG_DIALOG_MODIFIED", this.getTitle());
            int n = PluginSupport.getViewerSupport().messageBoxString((Container)this.getJDialog(), string, 1, 2);
            if (n == 0) {
                this.onApply();
            } else if (n == 2) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public abstract String getTitle();

    public abstract BaseItem getItem();

    @Override
    public abstract SCPageController[] getPageControllers();

    @Override
    public int getDialogType() {
        return 2;
    }

    @Override
    public void onApply() {
        this.clearModifiedFlag();
        this.setButtons();
    }

    @Override
    public SCItem2 getSCItem2() {
        return null;
    }
}

