/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components;

import com.sybase.central.SCDialogSupport2;
import com.sybase.rsmplugin.components.BasePage;
import com.sybase.rsmplugin.components.BaseWizard;
import com.sybase.rsmplugin.util.Dbg;
import javax.swing.JPanel;

public abstract class BaseWizardPage
extends BasePage {
    private String _title = null;
    private BaseWizard _controller = null;
    private int _buttonMask = 10;

    public BaseWizardPage(BaseWizard baseWizard, String string) {
        Dbg.wassert(baseWizard != null, "Null BaseProperties parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty title parameter.");
        this._controller = baseWizard;
        this._title = string;
    }

    public BaseWizard getController() {
        Dbg.wassert(this._controller != null, "Null dialog controller attribute.");
        return this._controller;
    }

    public SCDialogSupport2 getDialogSupport() {
        return this.getController().getDialogSupport();
    }

    public void enableBackButton(boolean bl) {
        this.setButton(16, bl);
    }

    public void enableNextButton(boolean bl) {
        this.setButton(32, bl);
    }

    public void enableFinishButton(boolean bl) {
        this.setButton(0x1000040, bl);
    }

    private void setButton(int n, boolean bl) {
        Dbg.wassert(n == 16 || n == 32 || n == 0x1000040, "Invalid button mask parameter value.");
        if (bl) {
            if ((this._buttonMask & n) == 0) {
                this._buttonMask |= n;
                this.getDialogSupport().setEnabledStandardButtons(this._buttonMask);
            }
        } else if ((this._buttonMask & n) == n) {
            this._buttonMask ^= n;
            this.getDialogSupport().setEnabledStandardButtons(this._buttonMask);
        }
    }

    public boolean isNextButtonEnabled() {
        return (this._buttonMask & 0x20) == 32;
    }

    @Override
    public abstract JPanel getJPanel();

    @Override
    public String getPageTitle() {
        Dbg.wassert(this._title != null && this._title.length() > 0, "Null or empty page title.");
        String string = this.getController().getTitle();
        if (string != null && string.length() > 0) {
            return string + " - " + this._title;
        }
        return this._title;
    }

    @Override
    public int getEnabledStandardButtons() {
        return this._buttonMask;
    }

    @Override
    public void releaseResources() {
        this._controller = null;
        this._title = null;
    }
}

