/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components;

import com.sybase.asa.ASASpinBoxChangeEvent;
import com.sybase.asa.ASASpinBoxChangeListener;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.CommPanel;
import com.sybase.rsmplugin.components.ServerStatusSO;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CommPage
extends BasePropertyPage
implements ActionListener,
DocumentListener,
ASASpinBoxChangeListener {
    private CommPanel _goPage = new CommPanel();
    ServerStatusSO _server;

    public CommPage(BaseProperties baseProperties, ServerStatusSO serverStatusSO) {
        super(baseProperties, BundleManager.getString("ConnectionRes", "COMM_PAGE_TAG"));
        Dbg.wassert(serverStatusSO != null, "Null server parameter.");
        this._server = serverStatusSO;
    }

    protected ServerStatusSO getServer() {
        return this._server;
    }

    @Override
    public void onInitDialog() {
        this._goPage.fld_username.setText(this.getServer().getUsername());
        this._goPage.fld_password.setText("        ");
        this._goPage.cbx_charset.setSelection(this.getServer().getCharset());
        this._goPage.cbx_language.setSelection(this.getServer().getLanguage());
        this._goPage.fld_username.getDocument().addDocumentListener(this);
        this._goPage.fld_password.getDocument().addDocumentListener(this);
        this._goPage.cbx_charset.addActionListener(this);
        this._goPage.cbx_language.addActionListener(this);
        if (this.getServer().isControlledByRSMS()) {
            this._goPage.lbl_host.setVisible(false);
            this._goPage.fld_host.setVisible(false);
            this._goPage.lbl_port.setVisible(false);
            this._goPage.fld_port.setVisible(false);
            this._goPage.chk_monitor.setSelected(this.getServer().isMonitoringEnabled());
            this._goPage.spn_interval.setValue(this.getServer().getMonitoringInterval());
            this._goPage.lbl_date.setText(BundleManager.getString("DomainRes", "LAST_MONITOR_DATE", this.getServer().getLastMonitoredDate()));
            this._goPage.chk_monitor.addActionListener((ActionListener)this);
            this._goPage.spn_interval.addSpinBoxChangeListener((ASASpinBoxChangeListener)this);
        } else {
            this._goPage.chk_monitor.setVisible(false);
            this._goPage.lbl_interval.setVisible(false);
            this._goPage.spn_interval.setVisible(false);
            this._goPage.lbl_units.setVisible(false);
            this._goPage.lbl_date.setVisible(false);
            if (this.getServer().isAddressSavedLocally()) {
                this._goPage.fld_host.setText(this.getServer().getHost());
                this._goPage.fld_port.setText(this.getServer().getPort());
            }
            this._goPage.fld_host.getDocument().addDocumentListener(this);
            this._goPage.fld_port.getDocument().addDocumentListener(this);
        }
    }

    @Override
    public boolean onOk() {
        if (this.isModified()) {
            String string = this._goPage.fld_username.getText();
            String string2 = this._goPage.fld_password.getPasswordString();
            if (string2.equals("        ")) {
                string2 = this.getServer().getPassword();
            }
            String string3 = this._goPage.cbx_charset.getSelection();
            if ((string3 = string3.trim()).equals("default")) {
                string3 = "";
            }
            String string4 = this._goPage.cbx_language.getSelection();
            if ((string4 = string4.trim()).equals("default")) {
                string4 = "";
            }
            String string5 = this._goPage.fld_host.getText();
            string5 = string5.trim();
            String string6 = this._goPage.fld_port.getText();
            string6 = string6.trim();
            boolean bl = this._goPage.chk_monitor.isSelected();
            int n = this._goPage.spn_interval.getValue();
            try {
                this.getServer().validateConnection(string, string2, string3, string4, string5, string6);
                this.getServer().alter(string, string2, string3, string4, string5, string6, bl, n);
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                return false;
            }
        }
        return true;
    }

    @Override
    public JPanel getJPanel() {
        return this._goPage;
    }

    @Override
    public void releaseResources() {
        this._goPage.releaseResources();
        this._goPage = null;
        super.releaseResources();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setModified(true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setModified(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setModified(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setModified(true);
    }

    public void valueChanged(ASASpinBoxChangeEvent aSASpinBoxChangeEvent) {
        this.setModified(true);
    }
}

