/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.BaseModalDialog;
import com.sybase.rsmplugin.components.BasePage;
import com.sybase.rsmplugin.components.ConfigEditPanel;
import com.sybase.rsmplugin.components.ConfigParameter;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.NumericsOnlyDocument;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ConfigEditDlg
extends BaseModalDialog {
    protected SCPageController[] _page = null;
    private String _param = "";
    private ConfigParameter _obj;

    public ConfigEditDlg(SCDialogSupport2 sCDialogSupport2, ConfigParameter configParameter) {
        super(sCDialogSupport2);
        Dbg.wassert(sCDialogSupport2 != null, "Null dialog support parameter.");
        this._obj = configParameter;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("DomainRes", "EDIT_TITLE", this._obj.getName());
    }

    public void setParam(String string) {
        this._param = string;
    }

    public String getParam() {
        return this._param;
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._page == null) {
            this._page = new SCPageController[]{new ConfigEditPage()};
        }
        return this._page;
    }

    protected double getMinimum(String string, boolean bl) {
        int n;
        double d = 0.0;
        String string2 = null;
        if (string != null && (n = string.indexOf(",")) >= 0 && (string2 = string.substring(0, n)) != null && (string2 = string2.trim()).length() > 0) {
            try {
                d = bl ? (double)Long.parseLong(string2) : Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Dbg.trace(16, "Minimum Value '" + string2 + "' converted value: " + String.valueOf(d));
        return d;
    }

    protected double getMaximum(String string, boolean bl) throws NumberFormatException {
        int n;
        double d = 2.147483647E9;
        String string2 = null;
        if (string != null && (n = string.indexOf(",")) >= 0 && (string2 = string.substring(string.indexOf(",") + 1)) != null && (string2 = string2.trim()).length() > 0) {
            try {
                d = bl ? (double)Long.parseLong(string2) : Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Dbg.trace(16, "Maximum Value '" + string2 + "' converted value: " + String.valueOf(d));
        return d;
    }

    class ConfigEditPage
    extends BasePage
    implements DocumentListener,
    ActionListener {
        private ConfigEditPanel _goPage = new ConfigEditPanel();

        public ConfigEditPage() {
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
            String string = BundleManager.getString("ComponentRes", "EDIT_DESC");
            this._goPage.lbl_description.setText(string);
            String string2 = ConfigEditDlg.this._obj.getLegalValues();
            string2 = string2 == null ? "" : string2.trim();
            int n = string2.indexOf(58);
            String string3 = "";
            if (n >= 0) {
                string3 = string2.substring(0, n);
                String string4 = string3 = string3 == null ? "" : string3.trim();
                if (string3.equalsIgnoreCase("list") || string3.equalsIgnoreCase("range")) {
                    string2 = (string2 = string2.substring(n + 1)) == null ? "" : string2.trim();
                }
            }
            switch (ConfigEditDlg.this._obj.getDatatype()) {
                case 0: 
                case 1: {
                    this.setupNumeric(string3, string2);
                    break;
                }
                case 2: {
                    this.setupString(string3, string2);
                    break;
                }
                case 3: {
                    this.setupBoolean(string3, string2);
                    break;
                }
                case 4: {
                    this.setupPasswordField();
                    break;
                }
                default: {
                    this.setupTextField();
                }
            }
        }

        protected void setupString(String string, String string2) {
            if (string.equalsIgnoreCase("list") && string2 != null && string2.length() > 0) {
                this.setupDropdownField(string2);
            } else {
                this.setupTextField();
            }
        }

        protected void setupBoolean(String string, String string2) {
            if ((string.equalsIgnoreCase("list") || string.equalsIgnoreCase("range")) && string2 != null && string2.length() > 0) {
                this.setupDropdownField(string2);
            } else {
                this.setupTextField();
            }
        }

        protected void setupNumeric(String string, String string2) {
            if (string2 != null && string2.length() > 0) {
                if (string.equalsIgnoreCase("list")) {
                    this.setupDropdownField(string2);
                } else if (string.equalsIgnoreCase("range")) {
                    this.setupNumericField(string2);
                } else {
                    this.setupNumericField(string2);
                }
            } else {
                this.setupNumericField("");
            }
        }

        protected void setupNumericField(String string) {
            this._goPage.fld_edit_param.requestFocus();
            this._goPage.lbl_edit_param.setLabelFor((Component)this._goPage.fld_edit_param);
            this._goPage.fld_edit_param.setEnabled(true);
            this._goPage.fld_edit_param.setVisible(true);
            this._goPage.pwd_edit_param.setEnabled(false);
            this._goPage.pwd_edit_param.setVisible(false);
            this._goPage.cbx_edit_param.setEnabled(false);
            this._goPage.cbx_edit_param.setVisible(false);
            boolean bl = ConfigEditDlg.this._obj.getDatatype() == 0;
            double d = ConfigEditDlg.this.getMinimum(string, bl);
            double d2 = ConfigEditDlg.this.getMaximum(string, bl);
            this._goPage.fld_edit_param.setDocument((Document)new NumericsOnlyDocument(bl, d, d2));
            this._goPage.fld_edit_param.setText(ConfigEditDlg.this._obj.getPendingValue());
            this._goPage.fld_edit_param.selectAll();
            this._goPage.fld_edit_param.getDocument().addDocumentListener(this);
        }

        protected void setupTextField() {
            this._goPage.fld_edit_param.requestFocus();
            this._goPage.lbl_edit_param.setLabelFor((Component)this._goPage.fld_edit_param);
            this._goPage.fld_edit_param.setEnabled(true);
            this._goPage.fld_edit_param.setVisible(true);
            this._goPage.pwd_edit_param.setEnabled(false);
            this._goPage.pwd_edit_param.setVisible(false);
            this._goPage.cbx_edit_param.setEnabled(false);
            this._goPage.cbx_edit_param.setVisible(false);
            this._goPage.fld_edit_param.setText(ConfigEditDlg.this._obj.getPendingValue());
            this._goPage.fld_edit_param.selectAll();
            this._goPage.fld_edit_param.getDocument().addDocumentListener(this);
        }

        protected void setupPasswordField() {
            this._goPage.pwd_edit_param.requestFocus();
            this._goPage.lbl_edit_param.setLabelFor((Component)this._goPage.pwd_edit_param);
            this._goPage.fld_edit_param.setEnabled(false);
            this._goPage.fld_edit_param.setVisible(false);
            this._goPage.pwd_edit_param.setEnabled(true);
            this._goPage.pwd_edit_param.setVisible(true);
            this._goPage.cbx_edit_param.setEnabled(false);
            this._goPage.cbx_edit_param.setVisible(false);
            this._goPage.pwd_edit_param.setText("        ");
            this._goPage.pwd_edit_param.selectAll();
            this._goPage.pwd_edit_param.getDocument().addDocumentListener(this);
        }

        protected void setupDropdownField(String string) {
            Dbg.wassert(string != null && string.length() > 0, "Null or empty dropdown list value parameter.");
            this._goPage.cbx_edit_param.removeAllItems();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",/;");
            while (stringTokenizer.hasMoreTokens()) {
                this._goPage.cbx_edit_param.addItem((Object)stringTokenizer.nextToken().trim());
            }
            this._goPage.cbx_edit_param.requestFocus();
            this._goPage.lbl_edit_param.setLabelFor((Component)this._goPage.cbx_edit_param);
            this._goPage.fld_edit_param.setEnabled(false);
            this._goPage.fld_edit_param.setVisible(false);
            this._goPage.pwd_edit_param.setEnabled(false);
            this._goPage.pwd_edit_param.setVisible(false);
            this._goPage.cbx_edit_param.setEnabled(true);
            this._goPage.cbx_edit_param.setVisible(true);
            this._goPage.lbl_edit_param.setLabelFor((Component)this._goPage.cbx_edit_param);
            String string2 = ConfigEditDlg.this._obj.getPendingValue();
            this._goPage.cbx_edit_param.setSelectedItem(string2);
            this._goPage.cbx_edit_param.addActionListener((ActionListener)this);
        }

        @Override
        public boolean onSetActive() {
            this.enableButtons();
            return super.onSetActive();
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public boolean onOk() {
            if (this._goPage.fld_edit_param.isEnabled()) {
                ConfigEditDlg.this.setParam(this._goPage.fld_edit_param.getText());
            } else if (this._goPage.cbx_edit_param.isEnabled()) {
                ConfigEditDlg.this.setParam(this._goPage.cbx_edit_param.getSelectedString());
            } else {
                String string = this._goPage.pwd_edit_param.getPasswordString();
                if (!string.equals("        ")) {
                    ConfigEditDlg.this.setParam(string);
                }
            }
            return super.onOk();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.cbx_edit_param) {
                this.setModified(true);
                this.enableButtons();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
            this.enableButtons();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
            this.enableButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
            this.enableButtons();
        }

        protected void enableButtons() {
            String string;
            if (this._goPage.fld_edit_param.isEnabled()) {
                string = this._goPage.fld_edit_param.getText();
                if (string != null && string.length() > 0) {
                    ConfigEditDlg.this.getDialogSupport().setEnabledStandardButtons(3);
                } else {
                    ConfigEditDlg.this.getDialogSupport().setEnabledStandardButtons(2);
                }
                if (ConfigEditDlg.this._obj.getDatatype() == 2) {
                    ConfigEditDlg.this.getDialogSupport().setEnabledStandardButtons(3);
                }
            }
            if (this._goPage.cbx_edit_param.isEnabled()) {
                string = this._goPage.cbx_edit_param.getSelectedString();
                if (string != null && string.length() > 0) {
                    ConfigEditDlg.this.getDialogSupport().setEnabledStandardButtons(3);
                } else {
                    ConfigEditDlg.this.getDialogSupport().setEnabledStandardButtons(2);
                }
            }
        }
    }
}

