/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.ConfigEditDlg;
import com.sybase.rsmplugin.components.ConfigPanel;
import com.sybase.rsmplugin.components.ConfigParameter;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.RSMObjectRow;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConfigPage
extends BasePropertyPage
implements ListSelectionListener,
DocumentListener,
ActionListener {
    public static final int CURRENT_VALUE_COL = 1;
    private ConfigPanel _goPage;
    private List _data;
    private MouseAdapter _listMouseListener = null;
    private boolean _pendingColumn = true;

    public ConfigPage(BaseProperties baseProperties, List list) {
        super(baseProperties, BundleManager.getString("ComponentRes", "CONFIG_PAGE_TAG"));
        Dbg.wassert(list != null, "Null parameter list.");
        this._data = list;
        this._pendingColumn = true;
        if (this._data.size() > 0) {
            RSMObjectRow rSMObjectRow = (RSMObjectRow)this._data.get(0);
            if (rSMObjectRow.getColumnCount() == 2) {
                this._pendingColumn = false;
            } else {
                Dbg.wassert(rSMObjectRow.getColumnCount() == 3, "Invalid number of columns: " + rSMObjectRow.getColumnCount());
            }
        }
        this._goPage = new ConfigPanel(this._pendingColumn);
        if (this._data.size() > 0) {
            this._goPage.tbl_parameters.addRows(this._data);
        }
        this.addMouseListener();
    }

    @Override
    public void onInitDialog() {
        JTextField jTextField = new JTextField();
        jTextField.getDocument().addDocumentListener(this);
        this._goPage.tbl_parameters.getSelectionModel().addListSelectionListener(this);
        this._goPage.tbl_parameters.requestFocus();
        this._goPage.tbl_parameters.setSorting(true);
        this._goPage.tbl_parameters.setSortedColumnNumber(0);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this._goPage.tbl_parameters.registerKeyboardAction(this, keyStroke, 0);
        this._goPage.tbl_parameters.getInputMap().put(KeyStroke.getKeyStroke(27, 0, false), "ESC_KEY");
        this._goPage.tbl_parameters.getActionMap().put("ESC_KEY", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigPage.this.getController().closeDialog();
            }
        });
        this._goPage.btn_edit.setEnabled(false);
        this._goPage.btn_edit.addActionListener((ActionListener)this);
        this._goPage.lbl_restart.setVisible(this._pendingColumn);
        this._goPage.fld_restart.setVisible(this._pendingColumn);
    }

    @Override
    public JPanel getJPanel() {
        return this._goPage;
    }

    @Override
    public void releaseResources() {
        if (this._goPage.tbl_parameters != null) {
            this._goPage.tbl_parameters.removeMouseListener(this._listMouseListener);
        }
        this._goPage.releaseResources();
        this._goPage = null;
        super.releaseResources();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ConfigParameter configParameter;
        int n;
        ListSelectionModel listSelectionModel;
        if (!listSelectionEvent.getValueIsAdjusting() && !(listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty() && (n = this._goPage.tbl_parameters.getSelectedRow()) >= 0 && (configParameter = (ConfigParameter)((Object)this._goPage.tbl_parameters.getRSMObjectRow(n))) != null) {
            this._goPage.btn_edit.setEnabled(true);
            this._goPage.fld_default.setText(configParameter.getDefaultValue());
            this._goPage.fld_range.setText(configParameter.getLegalValues());
            this._goPage.fld_restart.setText(configParameter.getStatus());
            this._goPage.txt_desc.setText(configParameter.getExplanation());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setModified(true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setModified(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setModified(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if ((actionEvent.getSource() == this._goPage.btn_edit || actionEvent.getSource() == this._goPage.tbl_parameters) && (n = this._goPage.tbl_parameters.getSelectedRow()) >= 0) {
            this.runEditDialog(n);
        }
    }

    @Override
    public boolean onOk() {
        return true;
    }

    private void addMouseListener() {
        this._listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Point point;
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = ((ConfigPage)ConfigPage.this)._goPage.tbl_parameters.rowAtPoint(point = mouseEvent.getPoint())) >= 0) {
                    ConfigPage.this.runEditDialog(n);
                }
            }
        };
        this._goPage.tbl_parameters.addMouseListener(this._listMouseListener);
    }

    private void runEditDialog(int n) {
        if (n >= 0) {
            ConfigParameter configParameter = (ConfigParameter)((Object)this._goPage.tbl_parameters.getRSMObjectRow(n));
            ConfigEditDlg configEditDlg = new ConfigEditDlg(PluginSupport.getDialogSupport(this.getController().getJDialog()), configParameter);
            if (configEditDlg.showDialog()) {
                String string = configEditDlg.getParam();
                configParameter.setPendingValue(string);
                this._goPage.tbl_parameters.requestFocus();
                if (!this.isModified()) {
                    this.setModified(configParameter.isModified());
                }
            }
        }
    }
}

