/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components;

import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseModalDialog;
import com.sybase.rsmplugin.components.BasePage;
import com.sybase.rsmplugin.components.ConnectPanel;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.ServerInterfaces;
import com.sybase.rsmplugin.util.Dbg;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ConnectDlg
extends BaseModalDialog {
    protected SCPageController[] _page = null;
    protected Domain _domain = null;
    protected boolean _isExistingDomain = false;
    protected boolean _validate;
    protected ConnAttributes _att = null;
    protected String _domainName = null;
    protected String _username = null;
    protected String _password = null;

    public ConnectDlg(SCDialogSupport2 sCDialogSupport2, boolean bl) {
        super(sCDialogSupport2);
        Dbg.wassert(sCDialogSupport2 != null, "Null dialog support parameter.");
        this._isExistingDomain = false;
        this._validate = bl;
    }

    public ConnectDlg(SCDialogSupport2 sCDialogSupport2, boolean bl, ConnAttributes connAttributes) {
        super(sCDialogSupport2);
        Dbg.wassert(sCDialogSupport2 != null, "Null dialog support parameter.");
        Dbg.wassert(connAttributes != null, "Null connection attributes parameter.");
        this._isExistingDomain = true;
        this._validate = bl;
        this._att = connAttributes;
    }

    public ConnectDlg(SCDialogSupport2 sCDialogSupport2, boolean bl, String string, String string2, String string3) {
        super(sCDialogSupport2);
        Dbg.wassert(sCDialogSupport2 != null, "Null dialog support parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty username parameter.");
        this._isExistingDomain = true;
        this._validate = bl;
        this._domainName = string;
        this._username = string2;
        this._password = string3;
    }

    @Override
    public boolean showDialog() {
        this.getDialogSupport().setDialogController((SCDialogController)this);
        this.getDialogSupport().setTitle(this.getTitle());
        this.getDialogSupport().setResizable(true);
        this.getDialogSupport().setStandardButtons(false);
        this.getDialogSupport().setModal(true);
        this.getDialogSupport().setHelpButton(false);
        return this.getDialogSupport().render();
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("DomainRes", "CONNECT_TITLE");
    }

    public Domain getDomain() {
        return this._domain;
    }

    public String getDomainName() {
        return this._domainName;
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    protected ConnAttributes getRMSConnAttributes() {
        return this._att;
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._page == null) {
            this._page = new SCPageController[]{new ConnectPage()};
        }
        return this._page;
    }

    class ConnectPage
    extends BasePage
    implements ActionListener,
    DocumentListener {
        private ConnectPanel _goPage = new ConnectPanel();
        private boolean _optionsOn = true;
        private ServerInterfaces _srvInterface = null;

        @Override
        public void onInitDialog() {
            try {
                this._srvInterface = new ServerInterfaces();
            }
            catch (Exception exception) {
                PluginSupport.LogErrorMessage(exception.getMessage(), exception.getMessage());
            }
            this.getJPanel().getRootPane().setDefaultButton((JButton)this._goPage.btn_ok);
            this._goPage.btn_ok.addActionListener((ActionListener)this);
            this._goPage.btn_cancel.addActionListener((ActionListener)this);
            this._goPage.btn_options.addActionListener((ActionListener)this);
            this._goPage.rbn_env.addActionListener((ActionListener)this);
            this._goPage.rbn_rma.addActionListener((ActionListener)this);
            this._goPage.fld_username.getDocument().addDocumentListener(this);
            this._goPage.fld_name.getDocument().addDocumentListener(this);
            this._goPage.fld_host.getDocument().addDocumentListener(this);
            this._goPage.fld_port.getDocument().addDocumentListener(this);
            if (ConnectDlg.this._isExistingDomain) {
                ConnAttributes connAttributes = ConnectDlg.this.getRMSConnAttributes();
                boolean bl = connAttributes != null;
                this._goPage.rbn_rma.setSelected(bl);
                this._goPage.rbn_env.setSelected(!bl);
                this._goPage.rbn_rma.setEnabled(false);
                this._goPage.rbn_env.setEnabled(false);
                this._goPage.cbx_env.setEnabled(false);
                this._goPage.fld_name.setEnabled(false);
                this._goPage.fld_password.setText("        ");
                if (bl) {
                    String string;
                    this._goPage.cbx_env.addItem((Object)connAttributes.getServer());
                    this._goPage.fld_name.setText(connAttributes.getServer());
                    this._goPage.fld_username.setText(connAttributes.getUser());
                    this._goPage.fld_password.setText("        ");
                    if (connAttributes.getHost() != null) {
                        this._goPage.fld_host.setText(connAttributes.getHost().trim());
                    }
                    if (connAttributes.getPort() != null) {
                        this._goPage.fld_port.setText(connAttributes.getPort().trim());
                    }
                    if (connAttributes.getCharset() != null && (string = connAttributes.getCharset().trim()).length() > 0) {
                        this._goPage.cbx_charset.setSelection(string);
                    }
                    if (connAttributes.getLanguage() != null && (string = connAttributes.getLanguage().trim()).length() > 0) {
                        this._goPage.cbx_charset.setSelection(string);
                    }
                    this.displayOptionsPanel(false);
                } else {
                    this._goPage.btn_options.setEnabled(false);
                    this._goPage.cbx_env.addItem((Object)ConnectDlg.this.getDomainName());
                    this._goPage.fld_username.setText(ConnectDlg.this.getUsername());
                }
            } else {
                this.setupRMS();
            }
            this._goPage.fld_username.requestFocus();
        }

        @Override
        public boolean onSetActive() {
            this.enableButtons();
            return super.onSetActive();
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public boolean onOk() {
            boolean bl = true;
            ConnectDlg.this._domainName = this._goPage.cbx_env.getSelectedString();
            ConnectDlg.this._username = this._goPage.fld_username.getText();
            ConnectDlg.this._password = this._goPage.fld_password.getPasswordString();
            if (this._goPage.rbn_rma.isSelected()) {
                Object object;
                Domain domain;
                if (this._optionsOn) {
                    ConnectDlg.this._domainName = this._goPage.fld_name.getText();
                }
                if ((domain = PluginSupport.getDomain(ConnectDlg.this._domainName)) != null) {
                    PluginSupport.showValidationError(BundleManager.getString("DomainRes", "ERR_DOMAIN_ALREADY_CONNECTED", ConnectDlg.this._domainName));
                    bl = false;
                } else {
                    object = EnvDomain.getDomains();
                    ListIterator listIterator = object.listIterator();
                    while (listIterator.hasNext()) {
                        String string = (String)listIterator.next();
                        if (!string.equals(ConnectDlg.this._domainName)) continue;
                        PluginSupport.showValidationError(BundleManager.getString("DomainRes", "ERR_ENV_ALREADY_DEFINED", ConnectDlg.this._domainName));
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    object = new ConnAttributes();
                    ((ConnAttributes)object).setServer(ConnectDlg.this._domainName);
                    ((ConnAttributes)object).setType("RMS");
                    ((ConnAttributes)object).setUser(ConnectDlg.this._username);
                    if (ConnectDlg.this._isExistingDomain) {
                        if (!ConnectDlg.this._password.equals("        ")) {
                            ((ConnAttributes)object).setPassword(ConnectDlg.this._password);
                        }
                    } else {
                        if (ConnectDlg.this._password.equals("        ")) {
                            ConnectDlg.this._password = "";
                        }
                        ((ConnAttributes)object).setPassword(ConnectDlg.this._password);
                    }
                    ((ConnAttributes)object).setSaveAddress(this._optionsOn);
                    if (this._optionsOn) {
                        ((ConnAttributes)object).setHost(this._goPage.fld_host.getText());
                        ((ConnAttributes)object).setPort(this._goPage.fld_port.getText());
                        ((ConnAttributes)object).setCharset(this._goPage.cbx_charset.getSelection());
                        ((ConnAttributes)object).setLanguage(this._goPage.cbx_language.getSelection());
                    } else if (this._srvInterface != null) {
                        ((ConnAttributes)object).setHost(this._srvInterface.getHostName(ConnectDlg.this._domainName));
                        ((ConnAttributes)object).setPort(this._srvInterface.getPortNumber(ConnectDlg.this._domainName));
                    }
                    try {
                        ConnectDlg.this._domain = new RMSDomain(((ConnAttributes)object).getServer());
                        ((RMSDomain)ConnectDlg.this._domain).connect((ConnAttributes)object, ConnectDlg.this._validate);
                        Dbg.trace(8, "ReconnectDlg.onOk - user: " + this._goPage.fld_username.getText());
                        bl = super.onOk();
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.showValidationError(sQLException.getMessage());
                        bl = false;
                    }
                }
            } else if (ConnectDlg.this._validate) {
                try {
                    ConnectDlg.this._domain = new EnvDomain(ConnectDlg.this._domainName);
                    ((EnvDomain)ConnectDlg.this._domain).connect(ConnectDlg.this._username, ConnectDlg.this._password);
                    Dbg.trace(8, "ConnectDlg.onOk - user: " + this._goPage.fld_username.getText());
                    bl = super.onOk();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showValidationError(sQLException.getMessage());
                    bl = false;
                }
            }
            if (!bl) {
                ConnectDlg.this._domain = null;
            }
            return bl;
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_options) {
                if (this._goPage.rbn_rma.isSelected()) {
                    this.displayOptionsPanel(!this._optionsOn);
                }
            } else if (actionEvent.getSource() == this._goPage.btn_ok) {
                if (this.onOk()) {
                    ConnectDlg.this.getDialogSupport().closeDialog(true);
                    this.releaseResources();
                }
            } else if (actionEvent.getSource() == this._goPage.btn_cancel) {
                ConnectDlg.this.getDialogSupport().closeDialog(false);
                this.releaseResources();
            } else if (actionEvent.getSource() == this._goPage.rbn_env) {
                if (this._goPage.rbn_env.isSelected()) {
                    this.setupEnvironment();
                }
            } else if (actionEvent.getSource() == this._goPage.rbn_rma && this._goPage.rbn_rma.isSelected()) {
                this.setupRMS();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
            this.enableButtons();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
            this.enableButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
            this.enableButtons();
        }

        protected void enableButtons() {
            String string = this._goPage.fld_username.getText();
            String string2 = this._goPage.fld_name.getText();
            boolean bl = false;
            if (string != null && string.length() > 0) {
                bl = true;
                if (string2 != null && string2.length() > 0) {
                    String string3 = this._goPage.fld_host.getText();
                    String string4 = this._goPage.fld_port.getText();
                    bl = string3 != null && string3.length() > 0 && string4 != null && string4.length() > 0;
                }
            }
            this._goPage.btn_ok.setEnabled(bl);
        }

        protected void displayOptionsPanel(boolean bl) {
            if (this._optionsOn != bl) {
                this._optionsOn = bl;
                this._goPage.grd_option.setVisible(this._optionsOn);
                if (this._optionsOn) {
                    this._goPage.btn_options.setText(BundleManager.getString("ComponentRes", "OPTIONS_ON_BUTTON"));
                } else {
                    this._goPage.btn_options.setText(BundleManager.getString("ComponentRes", "OPTIONS_OFF_BUTTON"));
                }
                this._goPage.btn_options.setMnemonic(BundleManager.getMnemonic("ComponentRes", "OPTIONS_BUTTON_MNEM"));
                if (ConnectDlg.this.getDialogSupport().getJDialog() != null) {
                    int n = ConnectDlg.this.getDialogSupport().getJDialog().getSize().width;
                    int n2 = ConnectDlg.this.getDialogSupport().getJDialog().getPreferredSize().height;
                    ConnectDlg.this.getDialogSupport().getJDialog().setSize(n, n2);
                    ConnectDlg.this.getDialogSupport().getJDialog().setVisible(true);
                }
            }
        }

        protected void setupEnvironment() {
            this.displayOptionsPanel(false);
            this._goPage.btn_options.setEnabled(false);
            this._goPage.lbl_env.setText(BundleManager.getString("ComponentRes", "ENVIRONMENT"));
            this._goPage.lbl_env.setDisplayedMnemonic(BundleManager.getMnemonic("ComponentRes", "ENVIRONMENT_MNEM"));
            this._goPage.cbx_env.clear();
            List list = EnvDomain.getDomains();
            if (list != null) {
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    String string = (String)listIterator.next();
                    Domain domain = PluginSupport.getDomain(string);
                    if (domain != null) continue;
                    this._goPage.cbx_env.addItem((Object)string);
                }
            }
        }

        protected void setupRMS() {
            this.displayOptionsPanel(false);
            this._goPage.btn_options.setEnabled(true);
            this._goPage.lbl_env.setText(BundleManager.getString("ComponentRes", "SERVER_LIST"));
            this._goPage.lbl_env.setDisplayedMnemonic(BundleManager.getMnemonic("ComponentRes", "SERVER_LIST_MNEM"));
            if (this._optionsOn) {
                this._goPage.btn_options.setText(BundleManager.getString("ComponentRes", "OPTIONS_ON_BUTTON"));
            } else {
                this._goPage.btn_options.setText(BundleManager.getString("ComponentRes", "OPTIONS_OFF_BUTTON"));
            }
            this._goPage.btn_options.setMnemonic(BundleManager.getMnemonic("ComponentRes", "OPTIONS_BUTTON_MNEM"));
            this._goPage.cbx_env.clear();
            if (this._srvInterface != null) {
                ListIterator listIterator = this._srvInterface.getAllServerNames().listIterator();
                while (listIterator.hasNext()) {
                    String string = listIterator.next().toString();
                    this._goPage.cbx_env.addItem((Object)string);
                }
            }
        }
    }
}

