/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components;

import com.sybase.rsmplugin.components.DataServer;
import com.sybase.rsmplugin.components.EnvServerStatusSO;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ase.ASE;
import com.sybase.rsmplugin.components.ase.DomainASE;
import com.sybase.rsmplugin.components.connection.DomainConnParameter;
import com.sybase.rsmplugin.components.connection.DomainExceptionLog;
import com.sybase.rsmplugin.components.connection.DomainPhyConnection;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.database.Database;
import com.sybase.rsmplugin.components.database.DomainDatabase;
import com.sybase.rsmplugin.components.dbrepdef.DBRepDef;
import com.sybase.rsmplugin.components.dbrepdef.DomainDBRepDef;
import com.sybase.rsmplugin.components.dbsubscription.DBSub;
import com.sybase.rsmplugin.components.dbsubscription.DomainDBSub;
import com.sybase.rsmplugin.components.directconnect.DirectConnect;
import com.sybase.rsmplugin.components.directconnect.DomainDirectConnect;
import com.sybase.rsmplugin.components.errorclass.DomainErrorClass;
import com.sybase.rsmplugin.components.errorclass.ErrorClass;
import com.sybase.rsmplugin.components.events.RMSEventSO;
import com.sybase.rsmplugin.components.functionrepdef.DomainFunctionRepDef;
import com.sybase.rsmplugin.components.functionrepdef.FunctionRepDef;
import com.sybase.rsmplugin.components.functionstringclass.DomainFunctionStringClass;
import com.sybase.rsmplugin.components.functionstringclass.FunctionStringClass;
import com.sybase.rsmplugin.components.hds.DomainHDS;
import com.sybase.rsmplugin.components.hds.DomainMSS;
import com.sybase.rsmplugin.components.hds.DomainOracle;
import com.sybase.rsmplugin.components.hds.DomainUDB;
import com.sybase.rsmplugin.components.hds.HDS;
import com.sybase.rsmplugin.components.lanrepagent.DomainLANRepAgent;
import com.sybase.rsmplugin.components.lanrepagent.DomainLANRepAgentParameter;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgent;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgentParameter;
import com.sybase.rsmplugin.components.logical.DomainLogConnection;
import com.sybase.rsmplugin.components.logical.DomainLogConnectionParameter;
import com.sybase.rsmplugin.components.logical.DomainLogServer;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.components.logical.LogServer;
import com.sybase.rsmplugin.components.mirrorrepagent.DomainMirrorRepAgent;
import com.sybase.rsmplugin.components.mirrorrepagent.DomainMirrorRepAgentParameter;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgent;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgentParameter;
import com.sybase.rsmplugin.components.partition.DomainPartition;
import com.sybase.rsmplugin.components.partition.Partition;
import com.sybase.rsmplugin.components.queue.DomainQueue;
import com.sybase.rsmplugin.components.queue.QueueData;
import com.sybase.rsmplugin.components.queue.RSQueue;
import com.sybase.rsmplugin.components.repagent.DomainRepAgent;
import com.sybase.rsmplugin.components.repagent.DomainRepAgentParameter;
import com.sybase.rsmplugin.components.repagent.RepAgent;
import com.sybase.rsmplugin.components.repserver.DomainRepServer;
import com.sybase.rsmplugin.components.repserver.DomainRepServerParameter;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.components.route.DomainRoute;
import com.sybase.rsmplugin.components.route.DomainRouteParameter;
import com.sybase.rsmplugin.components.route.Route;
import com.sybase.rsmplugin.components.rsthread.DomainRSThread;
import com.sybase.rsmplugin.components.rsthread.RSThread;
import com.sybase.rsmplugin.components.rsuser.DomainRSUser;
import com.sybase.rsmplugin.components.rsuser.RSUser;
import com.sybase.rsmplugin.components.storedprocedure.DomainStoredProcedure;
import com.sybase.rsmplugin.components.storedprocedure.StoredProcedure;
import com.sybase.rsmplugin.components.subscription.DomainSub;
import com.sybase.rsmplugin.components.subscription.Subscription;
import com.sybase.rsmplugin.components.table.DomainTable;
import com.sybase.rsmplugin.components.table.Table;
import com.sybase.rsmplugin.components.tablerepdef.DomainTableRepDef;
import com.sybase.rsmplugin.components.tablerepdef.TableRepDef;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class EnvSemanticFactory
implements SemanticFactory {
    EnvDomain _domain = null;

    public EnvSemanticFactory(EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null EnvDomain parameter.");
        this._domain = envDomain;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null EnvDomain attribute.");
        return this._domain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null EnvConnection attribute.");
        return this._domain.getName();
    }

    @Override
    public RepServer getRepServer(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty Replication Server name parameter.");
        return DomainRepServer.getRepServer(string, this.getDomain());
    }

    @Override
    public List getRepServers() {
        return DomainRepServer.getRepServers(this.getDomain());
    }

    @Override
    public List getRepServerParameters(String string) throws SQLException {
        return DomainRepServerParameter.getRepServerParameters(string, this.getDomain());
    }

    @Override
    public List getLANRepAgentParameters(String string) throws SQLException {
        return DomainLANRepAgentParameter.getLANRepAgentParameters(string, this.getDomain());
    }

    @Override
    public LANRepAgentParameter getLANRepAgentParameter(String string, String string2) throws SQLException {
        return DomainLANRepAgentParameter.getLANRepAgentParameter(string, string2, this.getDomain());
    }

    @Override
    public List getMirrorRepAgentParameters(String string) throws SQLException {
        return DomainMirrorRepAgentParameter.getMirrorRepAgentParameters(string, this.getDomain());
    }

    @Override
    public MirrorRepAgentParameter getMirrorRepAgentParameter(String string, String string2) throws SQLException {
        return DomainMirrorRepAgentParameter.getMirrorRepAgentParameter(string, string2, this.getDomain());
    }

    @Override
    public ASE getASE(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty ASE name parameter.");
        return DomainASE.getASE(string, this.getDomain());
    }

    @Override
    public List getASEs() {
        return DomainASE.getASEs(this.getDomain());
    }

    @Override
    public HDS getHDS(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty HDS name parameter.");
        DataServer dataServer = this.getDataServer(string);
        if (dataServer instanceof DomainHDS) {
            return (HDS)((Object)dataServer);
        }
        return null;
    }

    @Override
    public List getHDSs() {
        return DomainHDS.getHDSs(this.getDomain());
    }

    @Override
    public DataServer getDataServer(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty HDS name parameter.");
        EnvServerStatusSO envServerStatusSO = null;
        ConnAttributes connAttributes = this.getDomain().getServer(string);
        if (connAttributes != null) {
            String string2 = connAttributes.getType();
            if (string2.equals("ASE")) {
                envServerStatusSO = new DomainASE(string, this.getDomain());
            } else if (!string2.equals("ASA") && !string2.equals("IQ")) {
                if (string2.equals("Oracle")) {
                    envServerStatusSO = new DomainOracle(string, this.getDomain());
                } else if (string2.equals("MSSS")) {
                    envServerStatusSO = new DomainMSS(string, this.getDomain());
                } else if (string2.equals("UDB")) {
                    envServerStatusSO = new DomainUDB(string, this.getDomain());
                } else if (string2.equals("Informix")) {
                    // empty if block
                }
            }
        }
        return envServerStatusSO;
    }

    @Override
    public List getDataServers() {
        List list = DomainASE.getASEs(this.getDomain());
        list.addAll(DomainHDS.getHDSs(this.getDomain()));
        return list;
    }

    @Override
    public LANRepAgent getLANRepAgent(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty Rep Agent name parameter.");
        return DomainLANRepAgent.getLANRepAgent(string, this.getDomain());
    }

    @Override
    public LANRepAgent getLANRepAgent(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty source server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty source database name parameter.");
        return DomainLANRepAgent.getLANRepAgent(string, string2, this.getDomain());
    }

    @Override
    public List getLANRepAgents() {
        return DomainLANRepAgent.getLANRepAgents(this.getDomain());
    }

    @Override
    public MirrorRepAgent getMirrorRepAgent(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty Rep Agent name parameter.");
        return DomainMirrorRepAgent.getMirrorRepAgent(string, this.getDomain());
    }

    @Override
    public MirrorRepAgent getMirrorRepAgent(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty source server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty source database name parameter.");
        return DomainMirrorRepAgent.getMirrorRepAgent(string, string2, this.getDomain());
    }

    @Override
    public List getMirrorRepAgents() {
        return DomainMirrorRepAgent.getMirrorRepAgents(this.getDomain());
    }

    @Override
    public DirectConnect getDirectConnect(String string) {
        return DomainDirectConnect.getDirectConnect(string, this.getDomain());
    }

    @Override
    public List getDirectConnects() {
        return DomainDirectConnect.getDirectConnects(this.getDomain());
    }

    @Override
    public List getRemoteRMSs() {
        return new ArrayList();
    }

    @Override
    public PhyConnection getPhyConnection(String string, String string2, String string3) {
        return new DomainPhyConnection(string, string2, string3, this.getDomain());
    }

    @Override
    public List getPhyConnections(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        return DomainPhyConnection.getConnections(string, this.getDomain());
    }

    @Override
    public List getKnownPhyConnections(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        return DomainPhyConnection.getKnownConnections(string, this.getDomain());
    }

    @Override
    public List getPhyConnectionsAll() throws SQLException {
        return new ArrayList();
    }

    @Override
    public List getPhyConnectionsForDataServer(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server name parameter.");
        return DomainPhyConnection.getConnectionsForDataServer(string, this.getDomain());
    }

    @Override
    public List getPhyConnectionsForLANRepAgent(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server name parameter.");
        return DomainPhyConnection.getConnectionsForLANRepAgent(string, this.getDomain());
    }

    @Override
    public List getPhyConnectionsForMirrorRepAgent(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server name parameter.");
        return DomainPhyConnection.getConnectionsForMirrorRepAgent(string, this.getDomain());
    }

    @Override
    public List getPhyConnectionsForDirectConnect(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server name parameter.");
        return DomainPhyConnection.getConnectionsForDirectConnect(string, this.getDomain());
    }

    @Override
    public List getConnParameters(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty data server name parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty database name parameter.");
        return DomainConnParameter.getConnParameters(string, string2, string3, this.getDomain());
    }

    @Override
    public List getExceptionLog(String string, String string2, String string3, String string4, int n, String string5) throws SQLException {
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty rep server name parameter.");
        return DomainExceptionLog.getExceptionLog(string, string2, string3, string4, n, string5, this.getDomain());
    }

    @Override
    public LogServer getLogServer(String string) {
        return new DomainLogServer(string, this.getDomain());
    }

    @Override
    public List getLogServers() throws SQLException {
        return DomainLogServer.getLogServers(this.getDomain());
    }

    @Override
    public LogConnection getLogConnection(String string, String string2, String string3) {
        return new DomainLogConnection(string, string2, string3, this.getDomain());
    }

    @Override
    public List getLogConnections(String string) throws SQLException {
        return DomainLogConnection.getLogConnections(string, this.getDomain());
    }

    @Override
    public List getLogConnections() throws SQLException {
        return DomainLogConnection.getLogConnections(this.getDomain());
    }

    @Override
    public List getLogConnectionsforLDS(String string) throws SQLException {
        return DomainLogConnection.getLogConnectionsforLDS(string, this.getDomain());
    }

    @Override
    public List getLogConnectionParameters(String string, String string2, String string3) throws SQLException {
        return DomainLogConnectionParameter.getLogConnectionParameters(string, string2, string3, this.getDomain());
    }

    @Override
    public Database getDatabase(String string, String string2) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database name parameter.");
        return new DomainDatabase(string, string2, this.getDomain());
    }

    @Override
    public List getDatabases(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server name parameter.");
        return DomainDatabase.getDatabases(string, this.getDomain());
    }

    @Override
    public List getRepAgents(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty ASE server name parameter.");
        return new ArrayList();
    }

    @Override
    public RepAgent getRepAgent(String string, String string2) {
        return new DomainRepAgent(string, string2, this.getDomain());
    }

    @Override
    public List getRepAgentParameters(String string, String string2) throws SQLException {
        return DomainRepAgentParameter.getRepAgentParameters(string, string2, this.getDomain());
    }

    @Override
    public Table getTable(String string, String string2, String string3, String string4) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database name parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty owner name parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty table name parameter.");
        return new DomainTable(string, string2, string3, string4, this.getDomain());
    }

    @Override
    public List getTables(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database name parameter.");
        return DomainTable.getTables(string, string2, this.getDomain());
    }

    @Override
    public RSUser getRSUser(String string, String string2) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty user parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty replication server name parameter.");
        return new DomainRSUser(string, string2, this.getDomain());
    }

    @Override
    public List getRSUsers(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        return DomainRSUser.getRSUsers(string, this.getDomain());
    }

    @Override
    public List getDBRepDefs(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        return DomainDBRepDef.getDBRepDefs(string, string2, string3, this.getDomain());
    }

    @Override
    public DBRepDef getDBRepDef(String string, String string2, String string3, String string4) {
        return new DomainDBRepDef(string, string2, string3, string4, this.getDomain());
    }

    @Override
    public List getTableRepDefs(String string) throws SQLException {
        return DomainTableRepDef.getTableRepDefs(string, this.getDomain());
    }

    @Override
    public List getTableRepDefs(String string, String string2, String string3) throws SQLException {
        return DomainTableRepDef.getTableRepDefs(string, string2, string3, this.getDomain());
    }

    @Override
    public List getTableRepDefs(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty replication server parameter.");
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty replication database parameter.");
        Dbg.wassert(string6 != null && string6.length() > 0, "Null or empty table name parameter.");
        Dbg.wassert(string7 != null && string7.length() > 0, "Null or empty table owner parameter.");
        return DomainTableRepDef.getTableRepDefs(string, string2, string3, string4, string5, string6, string7, this.getDomain());
    }

    @Override
    public TableRepDef getTableRepDef(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty rep def name parameter.");
        return DomainTableRepDef.getTableRepDef(string, string2, this.getDomain());
    }

    @Override
    public TableRepDef getTableRepDef(String string, String string2, String string3, String string4, String string5, String string6) {
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty replication server name parameter.");
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty replication server parameter.");
        Dbg.wassert(string6 != null && string6.length() > 0, "Null or empty replication database parameter.");
        return new DomainTableRepDef(string, string2, string3, string4, string5, string6, this.getDomain());
    }

    @Override
    public List getFunctionRepDefs(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty replication server parameter.");
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty replication database parameter.");
        Dbg.wassert(string6 != null && string6.length() > 0, "Null or empty table name parameter.");
        Dbg.wassert(string7 != null && string7.length() > 0, "Null or empty table owner parameter.");
        return DomainFunctionRepDef.getFunctionRepDefs(string, string2, string3, string4, string5, string6, string7, this.getDomain());
    }

    @Override
    public FunctionRepDef getFunctionRepDef(String string, String string2, String string3, String string4, String string5, String string6) {
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty replication server name parameter.");
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty replication server parameter.");
        Dbg.wassert(string6 != null && string6.length() > 0, "Null or empty replication database parameter.");
        return new DomainFunctionRepDef(string, string2, string3, string4, string5, string6, this.getDomain());
    }

    @Override
    public FunctionRepDef getFunctionRepDef(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty rep def name parameter.");
        return DomainFunctionRepDef.getFunctionRepDef(string, string2, this.getDomain());
    }

    @Override
    public List getDBSubs(String string, String string2, String string3) throws SQLException {
        return DomainDBSub.getDBSubs(string, this.getDomain(), string2, string3);
    }

    @Override
    public DBSub getDBSub(String string, String string2, String string3, String string4, String string5) {
        return new DomainDBSub(string, string2, string3, string4, string5, this.getDomain());
    }

    @Override
    public List getDatabase(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server name parameter.");
        return DomainDatabase.getDatabases(string, this.getDomain());
    }

    @Override
    public List getTable(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database name parameter.");
        return DomainTable.getTables(string, string2, this.getDomain());
    }

    @Override
    public Route getRoute(String string, String string2, String string3) {
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty origin rep server parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty destination rep server parameter.");
        return new DomainRoute(string2, string3, this.getDomain());
    }

    @Override
    public List getRoutes(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        return DomainRoute.getRoutes(string, this.getDomain());
    }

    @Override
    public List getOriginRoutes(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        return DomainRoute.getOriginRoutes(string, this.getDomain());
    }

    @Override
    public List getRouteParameters(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty origin rep server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty destination rep server name parameter.");
        return DomainRouteParameter.getRouteParameters(string, string2, this.getDomain());
    }

    @Override
    public RSQueue getQueue(String string, String string2) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty queue name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty rep server parameter.");
        return new DomainQueue(string, string2, this.getDomain());
    }

    @Override
    public RSQueue getQueue(String string, int n, int n2, String string2) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty queue name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty rep server parameter.");
        return new DomainQueue(string, n, n2, string2, this.getDomain());
    }

    @Override
    public List getQueues(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        return DomainQueue.getQueues(string, this.getDomain());
    }

    @Override
    public List getQueueData(String string, int n, int n2, int n3, int n4, int n5, int n6) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        return QueueData.getQueueData(string, n, n2, n3, n4, n5, n6, this.getDomain());
    }

    @Override
    public Partition getPartition(String string, String string2) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty user parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty replication server name parameter.");
        return new DomainPartition(string, string2, this.getDomain());
    }

    @Override
    public List getPartitions(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        return DomainPartition.getPartitions(string, this.getDomain());
    }

    @Override
    public List getEvents() throws SQLException {
        return new ArrayList();
    }

    @Override
    public List getServerEvents(String string) throws SQLException {
        return new ArrayList();
    }

    @Override
    public List getRMSComponents(String string, String string2) throws SQLException {
        return new ArrayList();
    }

    @Override
    public RMSEventSO getRMSEventSO(String string, String string2, String string3, String string4, String string5, String string6, int n, String string7, int n2, boolean bl, String string8) throws SQLException {
        return new RMSEventSO(string, string2, string3, string4, string5, string6, n, string7, n2, bl, string8, null);
    }

    @Override
    public RSThread getRSThread(String string, String string2) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty spid parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty replication server name parameter.");
        return new DomainRSThread(string, string2, this.getDomain());
    }

    @Override
    public List getRSThreads(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        return DomainRSThread.getRSThreads(string, this.getDomain());
    }

    @Override
    public List getDISTThreads(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        return DomainRSThread.getDISTThreads(string, this.getDomain());
    }

    @Override
    public List getDSIThreads(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        return DomainRSThread.getDSIThreads(string, this.getDomain());
    }

    @Override
    public List getRSIThreads(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        return DomainRSThread.getRSIThreads(string, this.getDomain());
    }

    @Override
    public List getSQMThreads(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        return DomainRSThread.getSQMThreads(string, this.getDomain());
    }

    @Override
    public List getSQTThreads(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        return DomainRSThread.getSQTThreads(string, this.getDomain());
    }

    @Override
    public FunctionStringClass getFunctionStringClass(String string, String string2) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty user parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty replication server name parameter.");
        return new DomainFunctionStringClass(string, string2, this.getDomain());
    }

    @Override
    public List getFunctionStringClasses(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        return DomainFunctionStringClass.getFunctionStringClasses(string, this.getDomain());
    }

    @Override
    public ErrorClass getErrorClass(String string, String string2) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty user parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty replication server name parameter.");
        return new DomainErrorClass(string, string2, this.getDomain());
    }

    @Override
    public List getErrorClasses(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        return DomainErrorClass.getErrorClasses(string, this.getDomain());
    }

    @Override
    public List getStoredProcedures(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database name parameter.");
        return DomainStoredProcedure.getStoredProcedures(string, string2, this.getDomain());
    }

    @Override
    public StoredProcedure getStoredProcedure(String string, String string2, String string3, String string4) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database name parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty owner name parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty table name parameter.");
        return new DomainStoredProcedure(string, string2, string3, string4, this.getDomain());
    }

    @Override
    public List getSubsAtReplicate(String string, String string2, String string3, String string4, String string5) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty owner parameter.");
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty object parameter.");
        return DomainSub.getSubsAtReplicate(string, string2, string3, string4, string5, this.getDomain());
    }

    @Override
    public Subscription getSubscription(String string, String string2, String string3, String string4, String string5) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty rs parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty rep def parameter.");
        return new DomainSub(string, string2, string3, string4, string5, this.getDomain());
    }
}

