/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.RMSStatusSO;
import com.sybase.rsmplugin.components.ServerStatusSO;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;

public abstract class RMSServerStatusSO
extends RMSStatusSO
implements ServerStatusSO {
    public static final int MONITOR_DEFAULT_INTERVAL = 60;
    public static final int MONITOR_MINIMUM_INTERVAL = 10;
    public static final int MONITOR_MAXIMUM_INTERVAL = 50000;
    protected static final String USERNAME_PARAM = "username";
    protected static final String CHARSET_PARAM = "charset";
    protected static final String LANGUAGE_PARAM = "language";
    protected static final String PASSWORD_PARAM = "password";
    protected static final String MONITORING_PARAM = "monitoring";
    protected static final String INTERVAL_PARAM = "interval";
    protected String _username = null;
    protected String _charset = null;
    protected String _language = null;
    protected boolean _monitoring = true;
    protected int _interval = 60;
    protected static final String GET_RMS_CONFIG_PARAMS = "GET_RMS_CONFIG_PARAMS";
    protected static final String SET_RMS_CONFIG_PARAMS = "SET_RMS_CONFIG_PARAMS";
    protected static final String SHUTDOWN = "SHUTDOWN";
    protected static final String GET_DESCRIPTIONS = "GET_DESCRIPTIONS";
    private static final Object[][] contents = new Object[][]{{"GET_RMS_CONFIG_PARAMS", new Integer(1500), "configure server {0} RMS"}, {"SET_RMS_CONFIG_PARAMS", new Integer(1500), "configure server {0} RMS {1}={2}"}, {"SHUTDOWN", new Integer(1500), "shutdown {0}"}, {"GET_DESCRIPTIONS", new Integer(1500), "get status descriptions for {0}"}};
    protected static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSServerStatusSO(String string, RMSDomain rMSDomain) {
        super(string, rMSDomain);
    }

    public RMSServerStatusSO(String string) {
        super(string);
    }

    @Override
    public String getUsername() {
        return this._username == null ? "" : this._username;
    }

    @Override
    public String getPassword() {
        return "        ";
    }

    @Override
    public String getCharset() {
        return this._charset == null ? "" : this._charset;
    }

    @Override
    public String getLanguage() {
        return this._language == null ? "" : this._language;
    }

    @Override
    public String getHost() {
        return null;
    }

    @Override
    public String getPort() {
        return null;
    }

    @Override
    public boolean isAddressSavedLocally() {
        return false;
    }

    @Override
    public boolean isMonitoringEnabled() {
        return this._monitoring;
    }

    @Override
    public int getMonitoringInterval() {
        return this._interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadProperties() throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection != null) {
            int n = this.getDomain().getRMSVersionNumber();
            String string = _cmdBundle.getCommand(GET_RMS_CONFIG_PARAMS, n, this.getName());
            Dbg.wassert(string != null, "Unable to get RMS parameter command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    if (string2.equalsIgnoreCase(USERNAME_PARAM)) {
                        this._username = rSMResultSet.getColumnString(3);
                        continue;
                    }
                    if (string2.equalsIgnoreCase(CHARSET_PARAM)) {
                        this._charset = rSMResultSet.getColumnString(3);
                        this._charset = this._charset.equalsIgnoreCase("default") ? "" : this._charset;
                        continue;
                    }
                    if (string2.equalsIgnoreCase(LANGUAGE_PARAM)) {
                        this._language = rSMResultSet.getColumnString(3);
                        this._language = this._language.equalsIgnoreCase("default") ? "" : this._language;
                        continue;
                    }
                    if (string2.equalsIgnoreCase(MONITORING_PARAM)) {
                        this._monitoring = rSMResultSet.getColumnBool(3);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase(INTERVAL_PARAM)) continue;
                    this._interval = rSMResultSet.getColumnInt(3);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        this.loadDescriptions();
    }

    @Override
    public void alter(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n) throws SQLException {
        String string7;
        if (string != null && !this.getUsername().equals(string)) {
            this.setRMSConfigParameter(USERNAME_PARAM, string);
        }
        if (string2 != null && !this.getPassword().equals(string2)) {
            this.setRMSConfigParameter(PASSWORD_PARAM, string2);
        }
        if (string3 != null && !this.getCharset().equals(string3)) {
            string7 = string3.trim().length() == 0 ? "default" : string3;
            this.setRMSConfigParameter(CHARSET_PARAM, string7);
        }
        if (string4 != null && !this.getLanguage().equals(string4)) {
            string7 = string4.trim().length() == 0 ? "default" : string4;
            this.setRMSConfigParameter(LANGUAGE_PARAM, string7);
        }
        if (this.isMonitoringEnabled() != bl) {
            this.setRMSConfigParameter(MONITORING_PARAM, bl ? "true" : "false");
        }
        if (this.getMonitoringInterval() != n) {
            this.setRMSConfigParameter(INTERVAL_PARAM, String.valueOf(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRMSConfigParameter(String string, String string2) throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection != null) {
            int n = this.getDomain().getRMSVersionNumber();
            Object[] objectArray = new String[]{this.getName(), string, string2};
            String string3 = _cmdBundle.getCommand(SET_RMS_CONFIG_PARAMS, n, objectArray);
            Dbg.wassert(string3 != null, "Unable to set RMS parameter command, RMS version: " + n);
            try {
                rMSConnection.execute(string3);
            }
            finally {
                rMSConnection.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void shutdown() throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection == null) throw new SQLException(BundleManager.getString("ComponentRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        int n = this.getDomain().getRMSVersionNumber();
        String string = _cmdBundle.getCommand(SHUTDOWN, n, this.getName());
        Dbg.wassert(string != null, "Unable to get shutdown command for an RMS server. RMS version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
        try {
            rSMResultSet.open(string);
            if (!rSMResultSet.getNextRow() || rSMResultSet.getColumnCount() != 2) return;
            PluginSupport.LogInfoMessage(rSMResultSet.getColumnString(1), rSMResultSet.getColumnString(2));
            return;
        }
        finally {
            rSMResultSet.close();
            rMSConnection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDescriptions() throws SQLException {
        RMSConnection rMSConnection;
        if (this.getDomain() != null && (rMSConnection = this.getDomain().getRMSConnection()) != null) {
            int n = this.getDomain().getRMSVersionNumber();
            String string = _cmdBundle.getCommand(GET_DESCRIPTIONS, n, this.getName());
            Dbg.wassert(string != null, "Unable to get descriptions command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                this.clearReasons();
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    this.addReason(string2);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
    }

    @Override
    public void validateConnection(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
    }
}

