/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components;

import com.sybase.rsmplugin.components.BaseStatusSO;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;

public abstract class RMSStatusSO
extends BaseStatusSO {
    public static final String RMS_REP_SERVER_TYPE = "Replication Server";
    public static final String RMS_ASE_TYPE = "ASE";
    public static final String RMS_ASA_TYPE = "ASA";
    public static final String RMS_IQ_TYPE = "IQ";
    public static final String RMS_REP_AGENT_TYPE = "Replication Agent";
    public static final String RMS_MRA_TYPE = "Mirror Replication Agent";
    public static final String RMS_DIRECTCONNECT_TYPE = "DirectConnect";
    public static final String RMS_OPEN_SERVER_TYPE = "Open Server";
    public static final String RMS_SERVER_TYPE = "RMS";
    public static final String RMS_CONNECTION_TYPE = "Connection";
    public static final String RMS_RA_CONNECTION_TYPE = "RA Connection";
    public static final String RMS_DSI_CONNECTION_TYPE = "DSI Connection";
    public static final String RMS_LOG_SERVER_TYPE = "Logical Server";
    public static final String RMS_LOG_CONNECTION_TYPE = "Logical Connection";
    public static final String RMS_ROUTE_TYPE = "Route";
    public static final String RMS_QUEUE_TYPE = "Queue";
    public static final String RMS_PARTITION_TYPE = "Partition";
    public static final String RMS_REPAGENT_TYPE = "Repagent";
    private RMSDomain _domain = null;
    private String _name = null;
    private String _controllingServer = null;
    protected static final String GET_DESCRIPTIONS = "GET_DESCRIPTIONS";
    private static final Object[][] contents = new Object[][]{{"GET_DESCRIPTIONS", new Integer(1500), "get status descriptions for {0} {1} for {2}"}};
    protected static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSStatusSO(String string, String string2, RMSDomain rMSDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty server parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty name parameter.");
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        this._controllingServer = string;
        this._name = string2;
        this._domain = rMSDomain;
    }

    public RMSStatusSO(String string, RMSDomain rMSDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        this._name = string;
        this._domain = rMSDomain;
    }

    public RMSStatusSO(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        this._name = string;
    }

    @Override
    public String getName() {
        Dbg.wassert(this._name != null && this._name.length() > 0, "Null or empty name attribute.");
        return this._name;
    }

    public void setName(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        this._name = string;
    }

    public RMSDomain getDomain() {
        return this._domain;
    }

    @Override
    public String getDomainName() {
        String string = "";
        if (this._domain != null) {
            string = this._domain.getName();
        }
        return string;
    }

    public void setDomain(RMSDomain rMSDomain) {
        this._domain = rMSDomain;
    }

    public String getControllingServer() {
        return this._controllingServer;
    }

    public abstract String getRMSType();

    public boolean isControlledByRSMS() {
        return true;
    }

    public void loadProperties() throws SQLException {
        this.loadDescriptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDescriptions() throws SQLException {
        RMSConnection rMSConnection;
        if (this.getDomain() != null && (rMSConnection = this.getDomain().getRMSConnection()) != null) {
            Object[] objectArray = new String[]{this.getRMSType(), this.getName(), this.getControllingServer()};
            int n = this.getDomain().getRMSVersionNumber();
            String string = _cmdBundle.getCommand(GET_DESCRIPTIONS, n, objectArray);
            Dbg.wassert(string != null, "Unable to get descriptions command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                this.clearReasons();
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    this.addReason(string2);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
    }
}

