/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.ase;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.DataServer;
import com.sybase.rsmplugin.components.EnvServerStatusSO;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ase.ASE;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.database.DomainDatabase;
import com.sybase.rsmplugin.components.storedprocedure.DomainStoredProcedure;
import com.sybase.rsmplugin.components.storedprocedure.Parameter;
import com.sybase.rsmplugin.components.storedprocedure.StoredProcedure;
import com.sybase.rsmplugin.components.table.Column;
import com.sybase.rsmplugin.components.table.DomainTable;
import com.sybase.rsmplugin.components.table.Table;
import com.sybase.rsmplugin.sql.ASEConnection;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class DomainASE
extends EnvServerStatusSO
implements ASE,
DataServer,
Comparable {
    private static final String GET_LOG_FILE = "GET_LOG_FILE";
    private static final String ENABLE_RA_THREADS = "ENABLE_RA_THREADS";
    private static final String ARE_RA_THREADS_ENABLED = "ARE_RA_THREADS_ENABLED";
    private static final String LOGIN_EXISTS = "LOGIN_EXISTS";
    private static final String ADD_LOGIN = "ADD_LOGIN";
    private static final String UNLOCK_LOGIN = "UNLOCK_LOGIN";
    private static final String GET_DBS = "GET_DBS";
    private static final String ALIAS_USER = "ALIAS_USER";
    private static final String GRANT_PERMISSION = "GRANT_PERMISSION";
    private static final String GRANT_ROLE = "GRANT_ROLE";
    private static final String SP_DBOPTION = "SP_DBOPTION";
    private static final String CHECKPOINT = "CHECKPOINT";
    private static final String SET_REPLICATE = "SET_REPLICATE";
    private static final String GET_TABLES = "GET_TABLES";
    private static final String GET_TABLE = "GET_TABLE";
    private static final String GET_COLUMNS = "GET_COLUMNS";
    private static final String GET_KEY_COLUMNS = "GET_KEY_COLUMNS";
    private static final String GET_STORED_PROCEDURES = "GET_STORED_PROCEDURES";
    private static final String GET_STORED_PROCEDURE = "GET_STORED_PROCEDURE";
    private static final String GET_PARAMETERS = "GET_PARAMETERS";
    private static final String MARK_TABLE_FOR_REPLICATION = "MARK_TABLE_FOR_REPLICATION";
    private static final String UNMARK_TABLE_FOR_REPLICATION = "UNMARK_TABLE_FOR_REPLICATION";
    private static final String OWNER_QUALIFY_TABLE = "OWNER_QUALIFY_TABLE";
    private static final String MARK_PROC_FOR_REPLICATION = "MARK_PROC_FOR_REPLICATION";
    private static final String UNMARK_PROC_FOR_REPLICATION = "UNMARK_PROC_FOR_REPLICATION";
    private static final String MARK_COLUMN_FOR_REPLICATION = "MARK_COLUMN_FOR_REPLICATION";
    private static final Object[][] contents = new Object[][]{{"GET_LOG_FILE", new Integer(120000), "admin log_name"}, {"ENABLE_RA_THREADS", new Integer(120000), "sp_configure 'enable rep agent threads', 1"}, {"ARE_RA_THREADS_ENABLED", new Integer(120000), "select is_rep_agent_enabled()"}, {"LOGIN_EXISTS", new Integer(120000), "select name from master.dbo.syslogins where name = ''{0}''"}, {"ADD_LOGIN", new Integer(120000), "sp_addlogin ''{0}'', ''{1}''"}, {"UNLOCK_LOGIN", new Integer(120000), "sp_locklogin ''{0}'', \"unlock\""}, {"GET_DBS", new Integer(150001), "select name, status, dbid from master.dbo.sysdatabases\n\twhere name != 'model' and name != 'tempdb'\n\tand name != 'sybsystemdb' and name != 'sybsystemprocs'"}, {"GET_DBS", new Integer(120000), "select name, status, dbid from master.dbo.sysdatabases\n\twhere name != 'model' and name != 'tempdb'\n\tand name != 'sybsystemdb' and name != 'sybsystemprocs'\tand name != 'master'"}, {"ALIAS_USER", new Integer(120000), "sp_addalias {0}, dbo"}, {"GRANT_PERMISSION", new Integer(120000), "grant {0} on {1} to {2}"}, {"GRANT_ROLE", new Integer(120000), "sp_role ''grant'', {0}, {1}"}, {"SP_DBOPTION", new Integer(120000), "sp_dboption {0}, \"ddl in tran\", \"true\""}, {"SET_REPLICATE", new Integer(120000), "sp_setreplicate {0}, ''true''"}, {"CHECKPOINT", new Integer(120000), "checkpoint"}, {"GET_TABLES", new Integer(120000), "select usr.name, obj.name, obj.sysstat, obj.sysstat2 \nfrom {0}..sysobjects obj, {0}..sysusers usr \nwhere obj.type = ''U'' and obj.uid=usr.uid \norder by obj.name, usr.name"}, {"GET_TABLE", new Integer(120000), "select usr.name, obj.name, obj.sysstat, obj.sysstat2 \nfrom {0}..sysobjects obj, {0}..sysusers usr \nwhere obj.type = ''U'' and obj.uid=usr.uid and \nusr.name = ''{1}'' and obj.name = ''{2}'' "}, {"GET_COLUMNS", new Integer(120000), "select user_name = usr.name, tbl_name = obj.name, col_name = col.name, \ntyp2.type, col.length, col.colid, col.status, col.xstatus, col.xtype, obj.sysstat2, typ2.name \ninto #columns \nfrom sysusers usr, sysobjects obj, syscolumns col, systypes typ2 \nwhere obj.type = ''U'' and col.id = obj.id and col.usertype = typ2.usertype and \nobj.uid = usr.uid and \n(''{0}'' = ''*'' or usr.name = ''{0}'') and \n(''{1}'' = ''*'' or obj.name = ''{1}'') \nselect tmp.user_name, tmp.tbl_name, tmp.col_name, tmp.type, '''', \ntmp.length, tmp.colid, tmp.status, tmp.xstatus, xtyp.xtname, tmp.sysstat2, tmp.name \nfrom #columns tmp, sysxtypes xtyp \nwhere tmp.xtype *= xtyp.xtid \norder by tmp.colid \ndrop table #columns "}, {"GET_KEY_COLUMNS", new Integer(120000), "sp_special_columns @table_name=''{1}'', @table_owner=''{0}'', @col_type=R"}, {"GET_STORED_PROCEDURES", new Integer(120000), "select usr.name, obj.name, obj.sysstat from {0}..sysobjects obj, {0}..sysusers usr where obj.type = ''P'' and usr.uid=obj.uid order by obj.name, usr.name"}, {"GET_STORED_PROCEDURE", new Integer(120000), "select usr.name, obj.name, obj.sysstat \nfrom {0}..sysobjects obj, {0}..sysusers usr \nwhere obj.type = ''P'' and obj.uid=usr.uid and \nusr.name = ''{1}'' and obj.name = ''{2}'' "}, {"GET_PARAMETERS", new Integer(120000), "select usr.name, obj.name, cols.name, types2.type, '''', cols.length, colid, types2.name from sysusers usr, sysobjects obj, syscolumns cols, systypes types1, systypes types2 where obj.type = ''P'' and cols.id = obj.id and cols.usertype = types1.usertype and types1.type = types2.type and obj.uid = usr.uid and (''{0}'' = ''*'' or usr.name = ''{0}'') and (''{1}'' = ''*'' or obj.name = ''{1}'') group by obj.name, cols.name having types2.usertype = min(types2.usertype) and obj.type = ''P'' and cols.id = obj.id and cols.usertype = types1.usertype and types1.type = types2.type and obj.uid = usr.uid order by colid"}, {"MARK_TABLE_FOR_REPLICATION", new Integer(120000), "sp_setreptable ''{0}'', ''true'', ''{1}''"}, {"UNMARK_TABLE_FOR_REPLICATION", new Integer(120000), "sp_setreptable ''{0}'', ''false''"}, {"OWNER_QUALIFY_TABLE", new Integer(120000), "sp_setrepdefmode ''{0}'', ''{1}''"}, {"MARK_PROC_FOR_REPLICATION", new Integer(120000), "sp_setrepproc ''{0}'', ''function''"}, {"UNMARK_PROC_FOR_REPLICATION", new Integer(120000), "sp_setrepproc ''{0}'', ''false''"}, {"MARK_COLUMN_FOR_REPLICATION", new Integer(120000), "sp_setrepcol ''{0}'', ''{1}'', ''{2}''"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainASE(String string, EnvDomain envDomain) {
        super(string, envDomain);
        StatusSO statusSO = this.getDomain().getStatus(this.getType(), this.getName());
        if (statusSO != null) {
            this.setState(statusSO.getRSState());
            this.setReasons(statusSO.getReasons());
        } else {
            this.setState(3);
        }
    }

    public int compareTo(Object object) {
        if (object instanceof DomainASE) {
            return this.getName().compareTo(((DomainASE)object).getName());
        }
        Dbg.wassert(false, "CompareTo is comparing a non-DomainASE object.");
        return -1;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    public static ASE getASE(String string, EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        ASE aSE = null;
        List list = DomainASE.getASEs(envDomain);
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext() && aSE == null) {
                ASE aSE2 = (ASE)listIterator.next();
                if (!aSE2.getName().equals(string)) continue;
                aSE = aSE2;
            }
        }
        return aSE;
    }

    public static List getASEs(EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        ArrayList<DomainASE> arrayList = new ArrayList<DomainASE>();
        ListIterator listIterator = envDomain.getASEServerNames().listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            DomainASE domainASE = new DomainASE(string, envDomain);
            arrayList.add(domainASE);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public void load() throws SQLException {
        this.monitor();
    }

    public void monitor() {
        this.clearReasons();
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            try {
                rSMConnection.open();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            switch (rSMConnection.getState()) {
                case 1: {
                    this.setState(5);
                    break;
                }
                case 3: {
                    this.setState(1);
                    break;
                }
                default: {
                    this.setState(0);
                }
            }
            String string = rSMConnection.getReason();
            if (string != null && string.length() > 0) {
                this.addReason(string);
            }
        } else {
            this.setState(3);
            return;
        }
        rSMConnection.unlock();
        if (this.isUp()) {
            try {
                this.checkRollupStatus();
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                this.setState(0);
                this.addReason(sQLException.getLocalizedMessage());
            }
        }
    }

    @Override
    public String getVersionString() {
        String string = "";
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            string = rSMConnection.getVersionString();
            rSMConnection.unlock();
        }
        return string;
    }

    @Override
    public String getStateString() {
        String string;
        switch (this.getRSState()) {
            case 5: {
                string = BundleManager.getString("ASERes", "ACTIVE_STATE");
                break;
            }
            case 0: {
                string = BundleManager.getString("ASERes", "DOWN_STATE");
                break;
            }
            case 4: {
                string = BundleManager.getString("ASERes", "SUSPECT_STATE");
                break;
            }
            case 1: {
                string = BundleManager.getString("ASERes", "TIMED_OUT_STATE");
                break;
            }
            case 3: {
                string = BundleManager.getString("ASERes", "UNKNOWN_STATE");
                break;
            }
            default: {
                Dbg.wassert(false, "Unexpected ASE State");
                string = "";
            }
        }
        return string;
    }

    @Override
    public void alter(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n) throws SQLException {
        this.alter(string, string2, string3, string4, string5, string6, "ASE");
    }

    @Override
    public void drop() {
        this.getDomain().deleteServer(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateConnection(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty username parameter.");
        ConnAttributes connAttributes = new ConnAttributes();
        connAttributes.setServer(this.getName());
        connAttributes.setType("ASE");
        connAttributes.setUser(string);
        connAttributes.setPassword(string2);
        connAttributes.setCharset(string3);
        connAttributes.setLanguage(string4);
        if (string5 != null && string5.length() > 0 && string6 != null && string6.length() > 0) {
            connAttributes.setHost(string5);
            connAttributes.setPort(string6);
            connAttributes.setSaveAddress(true);
        } else {
            connAttributes.setHost("");
            connAttributes.setPort("");
            connAttributes.setSaveAddress(false);
        }
        ASEConnection aSEConnection = new ASEConnection(connAttributes);
        try {
            aSEConnection.open();
        }
        finally {
            if (aSEConnection != null) {
                aSEConnection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableReplication() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(ENABLE_RA_THREADS, n);
            Dbg.wassert(string != null, "Unable to get suspend command, repserver version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string);
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean areRAThreadsEnabled() throws SQLException {
        boolean bl = false;
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        int n = rSMConnection.getVersionNumber();
        String string = _cmdBundle.getCommand(ARE_RA_THREADS_ENABLED, n);
        Dbg.wassert(string != null, "Unable to get suspend command, repserver version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
        try {
            rSMResultSet.open(string);
            if (!rSMResultSet.getNextRow()) return bl;
            int n2 = rSMResultSet.getColumnInt(1);
            bl = n2 == 1;
            return bl;
        }
        finally {
            rSMResultSet.close();
            rSMConnection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loginExists(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty user name parameter.");
        boolean bl = false;
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        int n = rSMConnection.getVersionNumber();
        String string2 = _cmdBundle.getCommand(LOGIN_EXISTS, n, string);
        Dbg.wassert(string2 != null, "Unable to get login exists command, ASE version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
        try {
            rSMResultSet.open(string2);
            if (!rSMResultSet.getNextRow()) return bl;
            String string3 = rSMResultSet.getColumnString(1);
            bl = string.equals(string3);
            return bl;
        }
        finally {
            rSMResultSet.close();
            rSMConnection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLogin(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty user name parameter.");
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{string, string2};
            String string3 = _cmdBundle.getCommand(ADD_LOGIN, n, objectArray);
            Dbg.wassert(string3 != null, "Unable to get add login command, ASE version: " + n);
            try {
                rSMConnection.execute(string3);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockLogin(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty user name parameter.");
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            String string2 = _cmdBundle.getCommand(UNLOCK_LOGIN, n, string);
            Dbg.wassert(string2 != null, "Unable to get add login command, ASE version: " + n);
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public boolean supportsMasterDB() {
        int n;
        boolean bl = false;
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null && (n = rSMConnection.getVersionNumber()) >= 150001) {
            bl = true;
        }
        return bl;
    }

    private void checkRollupStatus() throws SQLException {
        this.clearReasons();
        try {
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
            List list = semanticFactory.getPhyConnectionsForDataServer(this.getName());
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                PhyConnection phyConnection = (PhyConnection)listIterator.next();
                if (phyConnection.isPartOfLogicalConnection() || phyConnection.isUp()) continue;
                this.setState(4);
                this.addReason(phyConnection.getReasons());
            }
        }
        catch (SQLException sQLException) {
            this.setState(4);
            this.addReason(sQLException.getLocalizedMessage());
        }
    }

    @Override
    public boolean supportsDBs() {
        return true;
    }

    @Override
    public boolean supportsDBLevelReplication() {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public String getUDDClass() {
        return "rs_sqlserver_dt_class";
    }

    @Override
    public String getFunctionStringClass() {
        return "rs_sqlserver_function_class";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getDatabases() throws SQLException {
        ArrayList<DomainDatabase> arrayList = new ArrayList<DomainDatabase>();
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(GET_DBS, n);
            Dbg.wassert(string != null, "Unable to get database query command, ASE version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    if (string2 == null || string2.length() <= 0) continue;
                    DomainDatabase domainDatabase = new DomainDatabase(this.getName(), string2, this.getDomain());
                    domainDatabase.setStatus(rSMResultSet.getColumnInt(2));
                    domainDatabase.setDBID(rSMResultSet.getColumnInt(3));
                    arrayList.add(domainDatabase);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getTables(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        ArrayList<DomainTable> arrayList = new ArrayList<DomainTable>();
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_TABLES, n, string);
            Dbg.wassert(string2 != null, "Unable to get table query command, ASE version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    if (string3 != null && string3.length() > 0 && string4 != null && string4.length() > 0) {
                        DomainTable domainTable = new DomainTable(this.getName(), string, string3, string4, this.getDomain());
                        domainTable.setStatus(rSMResultSet.getColumnInt(3));
                        domainTable.setStat2(rSMResultSet.getColumnInt(4));
                        arrayList.add(domainTable);
                        continue;
                    }
                    Dbg.wassert(false, "Unexpected null or empty column in table result set.");
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomainTable getTable(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty table owner parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        DomainTable domainTable = null;
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{string, string2, string3};
            String string4 = _cmdBundle.getCommand(GET_TABLE, n, objectArray);
            Dbg.wassert(string4 != null, "Unable to get table query command, ASE version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string4);
                while (rSMResultSet.getNextRow()) {
                    String string5 = rSMResultSet.getColumnString(1);
                    String string6 = rSMResultSet.getColumnString(2);
                    if (string5 != null && string5.length() > 0 && string5.equals(string2) && string6 != null && string6.length() > 0 && string6.equals(string3)) {
                        domainTable = new DomainTable(this.getName(), string, string2, string3, this.getDomain());
                        domainTable.setStatus(rSMResultSet.getColumnInt(3));
                        domainTable.setStat2(rSMResultSet.getColumnInt(4));
                        continue;
                    }
                    Dbg.wassert(false, "Unexpected null or empty column in table result set.");
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        return domainTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getColumns(String string, String string2, String string3) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty table owner parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        ArrayList<Column> arrayList = new ArrayList<Column>();
        ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName());
        if (aSEConnection != null) {
            aSEConnection.use(string);
            int n = aSEConnection.getVersionNumber();
            object3 = new String[]{string2, string3};
            String string4 = _cmdBundle.getCommand(GET_COLUMNS, n, (Object[])object3);
            Dbg.wassert(string4 != null, "Unable to get column query command, ASE version: " + n);
            object2 = new RSMResultSet(aSEConnection);
            try {
                ((RSMResultSet)object2).open(string4);
                while (((RSMResultSet)object2).getNextRow()) {
                    object = ((RSMResultSet)object2).getColumnString(3);
                    int n2 = ((RSMResultSet)object2).getColumnInt(4);
                    int n3 = ((RSMResultSet)object2).getColumnInt(6);
                    int n4 = ((RSMResultSet)object2).getColumnInt(7);
                    int n5 = ((RSMResultSet)object2).getColumnInt(8);
                    String string5 = ((RSMResultSet)object2).getColumnString(12);
                    Column column = new Column((String)object, string5, n2, n4, n3, n5, this.getDomain());
                    arrayList.add(column);
                }
            }
            finally {
                ((RSMResultSet)object2).close();
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ASERes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        ListIterator listIterator = this.getKeyColumns(string, string2, string3).listIterator();
        while (listIterator.hasNext()) {
            object3 = (String)listIterator.next();
            if (object3 == null || ((String)object3).length() <= 0) continue;
            boolean bl = false;
            object2 = arrayList.listIterator();
            while (object2.hasNext() && !bl) {
                object = (Column)object2.next();
                if (!((Column)object).getName().equals(object3)) continue;
                ((Column)object).setKey(true);
                bl = true;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getKeyColumns(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty table owner parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        ArrayList<String> arrayList = new ArrayList<String>();
        ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName());
        if (aSEConnection != null) {
            aSEConnection.use(string);
            int n = aSEConnection.getVersionNumber();
            Object[] objectArray = new String[]{string2, string3};
            String string4 = _cmdBundle.getCommand(GET_KEY_COLUMNS, n, objectArray);
            Dbg.wassert(string4 != null, "Unable to get key column query command, ASE version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(aSEConnection);
            try {
                rSMResultSet.open(string4);
                while (rSMResultSet.getNextRow()) {
                    String string5 = rSMResultSet.getColumnString(2);
                    if (string5 != null && string5.length() > 0) {
                        arrayList.add(string5);
                        continue;
                    }
                    Dbg.wassert(false, "Unexpected null or empty column in table result set.");
                }
            }
            finally {
                rSMResultSet.close();
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ASERes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getStoredProcedures(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        ArrayList<DomainStoredProcedure> arrayList = new ArrayList<DomainStoredProcedure>();
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_STORED_PROCEDURES, n, string);
            Dbg.wassert(string2 != null, "Unable to get stored procedure query command, ASE version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    if (string3 != null && string3.length() > 0 && string4 != null && string4.length() > 0) {
                        DomainStoredProcedure domainStoredProcedure = new DomainStoredProcedure(this.getName(), string, string3, string4, this.getDomain());
                        domainStoredProcedure.setStatus(rSMResultSet.getColumnInt(3));
                        arrayList.add(domainStoredProcedure);
                        continue;
                    }
                    Dbg.wassert(false, "Unexpected null or empty column in StoredProcedure result set.");
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ASERes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomainStoredProcedure getStoredProcedure(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty table owner parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty stored procedure name parameter.");
        DomainStoredProcedure domainStoredProcedure = null;
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{string, string2, string3};
            String string4 = _cmdBundle.getCommand(GET_STORED_PROCEDURE, n, objectArray);
            Dbg.wassert(string4 != null, "Unable to get stored procedure query command, ASE version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string4);
                while (rSMResultSet.getNextRow()) {
                    String string5 = rSMResultSet.getColumnString(1);
                    String string6 = rSMResultSet.getColumnString(2);
                    if (string5 != null && string5.length() > 0 && string5.equals(string2) && string6 != null && string6.length() > 0 && string6.equals(string3)) {
                        domainStoredProcedure = new DomainStoredProcedure(this.getName(), string, string2, string3, this.getDomain());
                        domainStoredProcedure.setStatus(rSMResultSet.getColumnInt(3));
                        continue;
                    }
                    Dbg.wassert(false, "Unexpected null or empty column in table result set.");
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        return domainStoredProcedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getParameters(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty table owner parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName());
        if (aSEConnection != null) {
            aSEConnection.use(string);
            int n = aSEConnection.getVersionNumber();
            Object[] objectArray = new String[]{string2, string3};
            String string4 = _cmdBundle.getCommand(GET_PARAMETERS, n, objectArray);
            Dbg.wassert(string4 != null, "Unable to get parameter query command, ASE version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(aSEConnection);
            try {
                rSMResultSet.open(string4);
                while (rSMResultSet.getNextRow()) {
                    String string5 = rSMResultSet.getColumnString(3);
                    int n2 = rSMResultSet.getColumnInt(4);
                    int n3 = rSMResultSet.getColumnInt(6);
                    int n4 = rSMResultSet.getColumnInt(7);
                    String string6 = rSMResultSet.getColumnString(8);
                    Parameter parameter = new Parameter(string5, string6, n2, n4, n3, 0, this.getDomain());
                    arrayList.add(parameter);
                }
            }
            finally {
                rSMResultSet.close();
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ASERes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aliasUser(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty user name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database parameter.");
        ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName());
        if (aSEConnection != null) {
            int n = aSEConnection.getVersionNumber();
            String string3 = _cmdBundle.getCommand(ALIAS_USER, n, string);
            Dbg.wassert(string3 != null, "Unable to get alias command, ASE version: " + n);
            try {
                aSEConnection.use(string2);
                aSEConnection.execute(string3);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantPermission(String string, String string2, String string3, String string4) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty user name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty database object parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or permission parameter.");
        ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName());
        if (aSEConnection != null) {
            Object[] objectArray = new String[]{string4, string3, string};
            int n = aSEConnection.getVersionNumber();
            String string5 = _cmdBundle.getCommand(GRANT_PERMISSION, n, objectArray);
            Dbg.wassert(string5 != null, "Unable to get grant command, ASE version: " + n);
            try {
                aSEConnection.use(string2);
                aSEConnection.execute(string5);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantRole(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty user name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty role parameter.");
        ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName());
        if (aSEConnection != null) {
            int n = aSEConnection.getVersionNumber();
            Object[] objectArray = new String[]{string3, string};
            String string4 = _cmdBundle.getCommand(GRANT_ROLE, n, objectArray);
            Dbg.wassert(string4 != null, "Unable to get grant role command, ASE version: " + n);
            try {
                aSEConnection.use(string2);
                aSEConnection.execute(string4);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDBOption(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName());
        if (aSEConnection != null) {
            int n = aSEConnection.getVersionNumber();
            String string2 = _cmdBundle.getCommand(SP_DBOPTION, n, string);
            Dbg.wassert(string2 != null, "Unable to get SP_DBOPTION command, ASE version: " + n);
            String string3 = _cmdBundle.getCommand(CHECKPOINT, n);
            Dbg.wassert(string2 != null, "Unable to get CHECKPOINT command, ASE version: " + n);
            try {
                aSEConnection.use("master");
                aSEConnection.execute(string2);
                aSEConnection.use(string);
                aSEConnection.execute(string3);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplicate(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty object name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database parameter.");
        ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName());
        if (aSEConnection != null) {
            int n = aSEConnection.getVersionNumber();
            String string3 = _cmdBundle.getCommand(SET_REPLICATE, n, string);
            Dbg.wassert(string3 != null, "Unable to get set replicate command, ASE version: " + n);
            try {
                aSEConnection.use(string2);
                aSEConnection.execute(string3);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markTable(String string, String string2, String string3, boolean bl) throws SQLException {
        ASEConnection aSEConnection;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + "." + string3;
        }
        if ((aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName())) != null) {
            int n = aSEConnection.getVersionNumber();
            Object[] objectArray = new String[]{string3, bl ? "owner_on" : "owner_off"};
            String string4 = _cmdBundle.getCommand(MARK_TABLE_FOR_REPLICATION, n, objectArray);
            Dbg.wassert(string4 != null, "Unable to get mark table command, ASE version: " + n);
            try {
                aSEConnection.use(string);
                aSEConnection.execute(string4);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ASERes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmarkTable(String string, String string2, String string3) throws SQLException {
        ASEConnection aSEConnection;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + "." + string3;
        }
        if ((aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName())) != null) {
            int n = aSEConnection.getVersionNumber();
            String string4 = _cmdBundle.getCommand(UNMARK_TABLE_FOR_REPLICATION, n, string3);
            Dbg.wassert(string4 != null, "Unable to get unmark table command, ASE version: " + n);
            try {
                aSEConnection.use(string);
                aSEConnection.execute(string4);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ASERes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public boolean isTableMarked(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        boolean bl = false;
        try {
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
            Table table = semanticFactory.getTable(this.getName(), string, string2, string3);
            table.loadTable();
            bl = table.getReplicateStatus();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ownerQualifyTable(String string, String string2, String string3, boolean bl) throws SQLException {
        ASEConnection aSEConnection;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + "." + string3;
        }
        if ((aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName())) != null) {
            int n = aSEConnection.getVersionNumber();
            Object[] objectArray = new String[]{string3, bl ? "owner_on" : "owner_off"};
            String string4 = _cmdBundle.getCommand(OWNER_QUALIFY_TABLE, n, objectArray);
            Dbg.wassert(string4 != null, "Unable to get owner qualify command, ASE version: " + n);
            try {
                aSEConnection.use(string);
                aSEConnection.execute(string4);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ASERes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public boolean isTableOwnerQualified(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        boolean bl = false;
        try {
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
            Table table = semanticFactory.getTable(this.getName(), string, string2, string3);
            table.loadTable();
            bl = table.getOwnerQualifiedStatus();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markStoredProcedure(String string, String string2, String string3) throws SQLException {
        ASEConnection aSEConnection;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty procedure name parameter.");
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + "." + string3;
        }
        if ((aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName())) != null) {
            int n = aSEConnection.getVersionNumber();
            String string4 = _cmdBundle.getCommand(MARK_PROC_FOR_REPLICATION, n, string3);
            Dbg.wassert(string4 != null, "Unable to retrieve the mark proc command, ASE version: " + n);
            try {
                aSEConnection.use(string);
                aSEConnection.execute(string4);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ASERes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmarkStoredProcedure(String string, String string2, String string3) throws SQLException {
        ASEConnection aSEConnection;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty procedure name parameter.");
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + "." + string3;
        }
        if ((aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName())) != null) {
            int n = aSEConnection.getVersionNumber();
            String string4 = _cmdBundle.getCommand(UNMARK_PROC_FOR_REPLICATION, n, string3);
            Dbg.wassert(string4 != null, "Unable to retrieve the unmark proc command, ASE version: " + n);
            try {
                aSEConnection.use(string);
                aSEConnection.execute(string4);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ASERes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public boolean isStoredProcedureMarked(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty procedure name parameter.");
        boolean bl = false;
        try {
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
            StoredProcedure storedProcedure = semanticFactory.getStoredProcedure(this.getName(), string, string2, string3);
            storedProcedure.loadStoredProcedure();
            bl = storedProcedure.getReplicateStatus();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markLOBColumn(String string, String string2, String string3, String string4, boolean bl) throws SQLException {
        ASEConnection aSEConnection;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + "." + string3;
        }
        if ((aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName())) != null) {
            int n = aSEConnection.getVersionNumber();
            Object[] objectArray = new String[]{string3, string4, bl ? "always_replicate" : "replicate_if_changed"};
            String string5 = _cmdBundle.getCommand(MARK_COLUMN_FOR_REPLICATION, n, objectArray);
            Dbg.wassert(string5 != null, "Unable to retrieve the unmark proc command, ASE version: " + n);
            try {
                aSEConnection.use(string);
                aSEConnection.execute(string5);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ASERes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmarkLOBColumn(String string, String string2, String string3, String string4) throws SQLException {
        ASEConnection aSEConnection;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + "." + string3;
        }
        if ((aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getName())) != null) {
            int n = aSEConnection.getVersionNumber();
            Object[] objectArray = new String[]{string3, string4, "do_not_replicate"};
            String string5 = _cmdBundle.getCommand(MARK_COLUMN_FOR_REPLICATION, n, objectArray);
            Dbg.wassert(string5 != null, "Unable to retrieve the unmark proc command, ASE version: " + n);
            try {
                aSEConnection.use(string);
                aSEConnection.execute(string5);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ASERes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }
}

